// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

#[allow(unused_imports)]
use crate::calc_grammar::CalcGrammar;
use id_tree::Tree;
use log::trace;
use miette::{miette, IntoDiagnostic, Result};
use parol_runtime::lexer::Token;
use parol_runtime::parser::{ParseTreeStackEntry, ParseTreeType, UserActionsTrait};
use std::path::{Path, PathBuf};

/// Semantic actions trait generated for the user grammar
/// All functions have default implementations.
pub trait CalcGrammarTrait<'t> {
    fn init(&mut self, _file_name: &Path) {}

    /// Semantic action for user production 0:
    ///
    /// calc: {instruction <0>";"};
    ///
    fn calc(&mut self, _arg: &Calc<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 1:
    ///
    /// equality_op: <0>"==|!=";
    ///
    fn equality_op(&mut self, _arg: &EqualityOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 2:
    ///
    /// assign_op: <0>"(\+|-|\*|/|%|<<|>>|&|\^|\|)?=";
    ///
    fn assign_op(&mut self, _arg: &AssignOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 3:
    ///
    /// logical_or_op: <0>"\|\|";
    ///
    fn logical_or_op(&mut self, _arg: &LogicalOrOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 4:
    ///
    /// logical_and_op: <0>"&&";
    ///
    fn logical_and_op(&mut self, _arg: &LogicalAndOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 5:
    ///
    /// bitwise_or_op: <0>"\|";
    ///
    fn bitwise_or_op(&mut self, _arg: &BitwiseOrOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 6:
    ///
    /// bitwise_and_op: <0>"&";
    ///
    fn bitwise_and_op(&mut self, _arg: &BitwiseAndOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 7:
    ///
    /// bitwise_shift_op: <0>"<<|>>";
    ///
    fn bitwise_shift_op(&mut self, _arg: &BitwiseShiftOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 8:
    ///
    /// relational_op: <0>"<=|<|>=|>";
    ///
    fn relational_op(&mut self, _arg: &RelationalOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 9:
    ///
    /// plus: <0>"\+";
    ///
    fn plus(&mut self, _arg: &Plus<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 10:
    ///
    /// minus: <0>"-";
    ///
    fn minus(&mut self, _arg: &Minus<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 11:
    ///
    /// pow_op: <0>"\*\*";
    ///
    fn pow_op(&mut self, _arg: &PowOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 12:
    ///
    /// mult_op: <0>"\*|/|%";
    ///
    fn mult_op(&mut self, _arg: &MultOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 13:
    ///
    /// instruction: assignment;
    ///
    fn instruction(&mut self, _arg: &Instruction<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 15:
    ///
    /// assign_item: id assign_op;
    ///
    fn assign_item(&mut self, _arg: &AssignItem<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 16:
    ///
    /// assignment: assign_item {assign_item} logical_or;
    ///
    fn assignment(&mut self, _arg: &Assignment<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 17:
    ///
    /// logical_or: logical_and {logical_or_op logical_and};
    ///
    fn logical_or(&mut self, _arg: &LogicalOr<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 18:
    ///
    /// logical_and: bitwise_or {logical_and_op bitwise_or};
    ///
    fn logical_and(&mut self, _arg: &LogicalAnd<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 19:
    ///
    /// bitwise_or: bitwise_and {bitwise_or_op bitwise_and};
    ///
    fn bitwise_or(&mut self, _arg: &BitwiseOr<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 20:
    ///
    /// bitwise_and: equality {bitwise_and_op equality};
    ///
    fn bitwise_and(&mut self, _arg: &BitwiseAnd<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 21:
    ///
    /// equality: relational {equality_op relational};
    ///
    fn equality(&mut self, _arg: &Equality<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 22:
    ///
    /// relational: bitwise_shift {relational_op bitwise_shift};
    ///
    fn relational(&mut self, _arg: &Relational<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 23:
    ///
    /// bitwise_shift: summ {bitwise_shift_op summ};
    ///
    fn bitwise_shift(&mut self, _arg: &BitwiseShift<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 24:
    ///
    /// add_op: plus | minus;
    ///
    fn add_op(&mut self, _arg: &AddOp<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 25:
    ///
    /// summ: mult {add_op mult};
    ///
    fn summ(&mut self, _arg: &Summ<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 26:
    ///
    /// mult: power {mult_op power};
    ///
    fn mult(&mut self, _arg: &Mult<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 27:
    ///
    /// power: factor {pow_op factor};
    ///
    fn power(&mut self, _arg: &Power<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 28:
    ///
    /// negate: minus;
    ///
    fn negate(&mut self, _arg: &Negate<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 29:
    ///
    /// factor: number | idref | negate factor | <0>"\(" logical_or <0>"\)";
    ///
    fn factor(&mut self, _arg: &Factor<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 30:
    ///
    /// number: <0>"0|[1-9][0-9]*";
    ///
    fn number(&mut self, _arg: &Number<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 31:
    ///
    /// idref: id;
    ///
    fn idref(&mut self, _arg: &Idref<'t>) -> Result<()> {
        Ok(())
    }

    /// Semantic action for user production 32:
    ///
    /// id: <0>"[a-zA-Z_][a-zA-Z0-9_]*";
    ///
    fn id(&mut self, _arg: &Id<'t>) -> Result<()> {
        Ok(())
    }
}

// -------------------------------------------------------------------------------------------------
//
// Output Types of productions deduced from the structure of the transformed grammar
//

///
/// Type derived for production 15
///
/// instruction: assignment;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Instruction0<'t> {
    pub assignment: Box<Assignment<'t>>,
}

///
/// Type derived for production 16
///
/// instruction: logical_or;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Instruction1<'t> {
    pub logical_or: Box<LogicalOr<'t>>,
}

///
/// Type derived for production 42
///
/// add_op: plus;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct AddOp0<'t> {
    pub plus: Box<Plus<'t>>,
}

///
/// Type derived for production 43
///
/// add_op: minus;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct AddOp1<'t> {
    pub minus: Box<Minus<'t>>,
}

///
/// Type derived for production 54
///
/// factor: number;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Factor0<'t> {
    pub number: Box<Number<'t>>,
}

///
/// Type derived for production 55
///
/// factor: idref;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Factor1<'t> {
    pub idref: Box<Idref<'t>>,
}

///
/// Type derived for production 56
///
/// factor: negate factor;
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Factor2<'t> {
    pub negate: Box<Negate<'t>>,
    pub factor: Box<Factor<'t>>,
}

///
/// Type derived for production 57
///
/// factor: "\(" logical_or "\)";
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Factor3<'t> {
    pub l_paren: Token<'t>, /* \( */
    pub logical_or: Box<LogicalOr<'t>>,
    pub r_paren: Token<'t>, /* \) */
}

// -------------------------------------------------------------------------------------------------
//
// Types of non-terminals deduced from the structure of the transformed grammar
//

///
/// Type derived for non-terminal add_op
///
#[allow(dead_code)]
#[derive(Debug, Clone)]
pub enum AddOp<'t> {
    AddOp0(AddOp0<'t>),
    AddOp1(AddOp1<'t>),
}

///
/// Type derived for non-terminal assign_item
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct AssignItem<'t> {
    pub id: Box<Id<'t>>,
    pub assign_op: Box<AssignOp<'t>>,
}

///
/// Type derived for non-terminal assign_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct AssignOp<'t> {
    pub assign_op: Token<'t>, /* (\+|-|\*|/|%|<<|>>|&|\^|\|)?= */
}

///
/// Type derived for non-terminal assignment
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Assignment<'t> {
    pub assign_item: Box<AssignItem<'t>>,
    pub assignment_list: Vec<AssignmentList<'t>>,
    pub logical_or: Box<LogicalOr<'t>>,
}

///
/// Type derived for non-terminal assignmentList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct AssignmentList<'t> {
    pub assign_item: Box<AssignItem<'t>>,
}

///
/// Type derived for non-terminal bitwise_and
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseAnd<'t> {
    pub equality: Box<Equality<'t>>,
    pub bitwise_and_list: Vec<BitwiseAndList<'t>>,
}

///
/// Type derived for non-terminal bitwise_andList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseAndList<'t> {
    pub bitwise_and_op: Box<BitwiseAndOp<'t>>,
    pub equality: Box<Equality<'t>>,
}

///
/// Type derived for non-terminal bitwise_and_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseAndOp<'t> {
    pub bitwise_and_op: Token<'t>, /* & */
}

///
/// Type derived for non-terminal bitwise_or
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseOr<'t> {
    pub bitwise_and: Box<BitwiseAnd<'t>>,
    pub bitwise_or_list: Vec<BitwiseOrList<'t>>,
}

///
/// Type derived for non-terminal bitwise_orList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseOrList<'t> {
    pub bitwise_or_op: Box<BitwiseOrOp<'t>>,
    pub bitwise_and: Box<BitwiseAnd<'t>>,
}

///
/// Type derived for non-terminal bitwise_or_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseOrOp<'t> {
    pub bitwise_or_op: Token<'t>, /* \| */
}

///
/// Type derived for non-terminal bitwise_shift
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseShift<'t> {
    pub summ: Box<Summ<'t>>,
    pub bitwise_shift_list: Vec<BitwiseShiftList<'t>>,
}

///
/// Type derived for non-terminal bitwise_shiftList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseShiftList<'t> {
    pub bitwise_shift_op: Box<BitwiseShiftOp<'t>>,
    pub summ: Box<Summ<'t>>,
}

///
/// Type derived for non-terminal bitwise_shift_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct BitwiseShiftOp<'t> {
    pub bitwise_shift_op: Token<'t>, /* <<|>> */
}

///
/// Type derived for non-terminal calc
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Calc<'t> {
    pub calc_list: Vec<CalcList<'t>>,
}

///
/// Type derived for non-terminal calcList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct CalcList<'t> {
    pub instruction: Box<Instruction<'t>>,
    pub semicolon: Token<'t>, /* ; */
}

///
/// Type derived for non-terminal equality
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Equality<'t> {
    pub relational: Box<Relational<'t>>,
    pub equality_list: Vec<EqualityList<'t>>,
}

///
/// Type derived for non-terminal equalityList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct EqualityList<'t> {
    pub equality_op: Box<EqualityOp<'t>>,
    pub relational: Box<Relational<'t>>,
}

///
/// Type derived for non-terminal equality_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct EqualityOp<'t> {
    pub equality_op: Token<'t>, /* ==|!= */
}

///
/// Type derived for non-terminal factor
///
#[allow(dead_code)]
#[derive(Debug, Clone)]
pub enum Factor<'t> {
    Factor0(Factor0<'t>),
    Factor1(Factor1<'t>),
    Factor2(Factor2<'t>),
    Factor3(Factor3<'t>),
}

///
/// Type derived for non-terminal id
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Id<'t> {
    pub id: Token<'t>, /* [a-zA-Z_][a-zA-Z0-9_]* */
}

///
/// Type derived for non-terminal idref
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Idref<'t> {
    pub id: Box<Id<'t>>,
}

///
/// Type derived for non-terminal instruction
///
#[allow(dead_code)]
#[derive(Debug, Clone)]
pub enum Instruction<'t> {
    Instruction0(Instruction0<'t>),
    Instruction1(Instruction1<'t>),
}

///
/// Type derived for non-terminal logical_and
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct LogicalAnd<'t> {
    pub bitwise_or: Box<BitwiseOr<'t>>,
    pub logical_and_list: Vec<LogicalAndList<'t>>,
}

///
/// Type derived for non-terminal logical_andList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct LogicalAndList<'t> {
    pub logical_and_op: Box<LogicalAndOp<'t>>,
    pub bitwise_or: Box<BitwiseOr<'t>>,
}

///
/// Type derived for non-terminal logical_and_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct LogicalAndOp<'t> {
    pub logical_and_op: Token<'t>, /* && */
}

///
/// Type derived for non-terminal logical_or
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct LogicalOr<'t> {
    pub logical_and: Box<LogicalAnd<'t>>,
    pub logical_or_list: Vec<LogicalOrList<'t>>,
}

///
/// Type derived for non-terminal logical_orList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct LogicalOrList<'t> {
    pub logical_or_op: Box<LogicalOrOp<'t>>,
    pub logical_and: Box<LogicalAnd<'t>>,
}

///
/// Type derived for non-terminal logical_or_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct LogicalOrOp<'t> {
    pub logical_or_op: Token<'t>, /* \|\| */
}

///
/// Type derived for non-terminal minus
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Minus<'t> {
    pub minus: Token<'t>, /* - */
}

///
/// Type derived for non-terminal mult
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Mult<'t> {
    pub power: Box<Power<'t>>,
    pub mult_list: Vec<MultList<'t>>,
}

///
/// Type derived for non-terminal multList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct MultList<'t> {
    pub mult_op: Box<MultOp<'t>>,
    pub power: Box<Power<'t>>,
}

///
/// Type derived for non-terminal mult_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct MultOp<'t> {
    pub mult_op: Token<'t>, /* \*|/|% */
}

///
/// Type derived for non-terminal negate
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Negate<'t> {
    pub minus: Box<Minus<'t>>,
}

///
/// Type derived for non-terminal number
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Number<'t> {
    pub number: Token<'t>, /* 0|[1-9][0-9]* */
}

///
/// Type derived for non-terminal plus
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Plus<'t> {
    pub plus: Token<'t>, /* \+ */
}

///
/// Type derived for non-terminal pow_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct PowOp<'t> {
    pub pow_op: Token<'t>, /* \*\* */
}

///
/// Type derived for non-terminal power
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Power<'t> {
    pub factor: Box<Factor<'t>>,
    pub power_list: Vec<PowerList<'t>>,
}

///
/// Type derived for non-terminal powerList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct PowerList<'t> {
    pub pow_op: Box<PowOp<'t>>,
    pub factor: Box<Factor<'t>>,
}

///
/// Type derived for non-terminal relational
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Relational<'t> {
    pub bitwise_shift: Box<BitwiseShift<'t>>,
    pub relational_list: Vec<RelationalList<'t>>,
}

///
/// Type derived for non-terminal relationalList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct RelationalList<'t> {
    pub relational_op: Box<RelationalOp<'t>>,
    pub bitwise_shift: Box<BitwiseShift<'t>>,
}

///
/// Type derived for non-terminal relational_op
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct RelationalOp<'t> {
    pub relational_op: Token<'t>, /* <=|<|>=|> */
}

///
/// Type derived for non-terminal summ
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct Summ<'t> {
    pub mult: Box<Mult<'t>>,
    pub summ_list: Vec<SummList<'t>>,
}

///
/// Type derived for non-terminal summList
///
#[allow(dead_code)]
#[derive(Builder, Debug, Clone)]
pub struct SummList<'t> {
    pub add_op: Box<AddOp<'t>>,
    pub mult: Box<Mult<'t>>,
}

// -------------------------------------------------------------------------------------------------

///
/// Deduced ASTType of expanded grammar
///
#[allow(dead_code)]
#[derive(Debug, Clone)]
pub enum ASTType<'t> {
    AddOp(AddOp<'t>),
    AssignItem(AssignItem<'t>),
    AssignOp(AssignOp<'t>),
    Assignment(Assignment<'t>),
    AssignmentList(Vec<AssignmentList<'t>>),
    BitwiseAnd(BitwiseAnd<'t>),
    BitwiseAndList(Vec<BitwiseAndList<'t>>),
    BitwiseAndOp(BitwiseAndOp<'t>),
    BitwiseOr(BitwiseOr<'t>),
    BitwiseOrList(Vec<BitwiseOrList<'t>>),
    BitwiseOrOp(BitwiseOrOp<'t>),
    BitwiseShift(BitwiseShift<'t>),
    BitwiseShiftList(Vec<BitwiseShiftList<'t>>),
    BitwiseShiftOp(BitwiseShiftOp<'t>),
    Calc(Calc<'t>),
    CalcList(Vec<CalcList<'t>>),
    Equality(Equality<'t>),
    EqualityList(Vec<EqualityList<'t>>),
    EqualityOp(EqualityOp<'t>),
    Factor(Factor<'t>),
    Id(Id<'t>),
    Idref(Idref<'t>),
    Instruction(Instruction<'t>),
    LogicalAnd(LogicalAnd<'t>),
    LogicalAndList(Vec<LogicalAndList<'t>>),
    LogicalAndOp(LogicalAndOp<'t>),
    LogicalOr(LogicalOr<'t>),
    LogicalOrList(Vec<LogicalOrList<'t>>),
    LogicalOrOp(LogicalOrOp<'t>),
    Minus(Minus<'t>),
    Mult(Mult<'t>),
    MultList(Vec<MultList<'t>>),
    MultOp(MultOp<'t>),
    Negate(Negate<'t>),
    Number(Number<'t>),
    Plus(Plus<'t>),
    PowOp(PowOp<'t>),
    Power(Power<'t>),
    PowerList(Vec<PowerList<'t>>),
    Relational(Relational<'t>),
    RelationalList(Vec<RelationalList<'t>>),
    RelationalOp(RelationalOp<'t>),
    Summ(Summ<'t>),
    SummList(Vec<SummList<'t>>),
}

/// Auto-implemented adapter grammar
///
/// The lifetime parameter `'t` refers to the lifetime of the scanned text.
/// The lifetime parameter `'u` refers to the lifetime of user grammar object.
///
#[allow(dead_code)]
pub struct CalcGrammarAuto<'t, 'u>
where
    't: 'u,
{
    // Mutable reference of the actual user grammar to be able to call the semantic actions on it
    user_grammar: &'u mut dyn CalcGrammarTrait<'t>,
    // Stack to construct the AST on it
    item_stack: Vec<ASTType<'t>>,
    // Path of the input file. Used for diagnostics.
    file_name: PathBuf,
}

///
/// The `CalcGrammarAuto` impl is automatically generated for the
/// given grammar.
///
impl<'t, 'u> CalcGrammarAuto<'t, 'u> {
    pub fn new(user_grammar: &'u mut dyn CalcGrammarTrait<'t>) -> Self {
        Self {
            user_grammar,
            item_stack: Vec::new(),
            file_name: PathBuf::default(),
        }
    }

    #[allow(dead_code)]
    fn push(&mut self, item: ASTType<'t>, context: &str) {
        trace!("push    {}: {:?}", context, item);
        self.item_stack.push(item)
    }

    #[allow(dead_code)]
    fn pop(&mut self, context: &str) -> Option<ASTType<'t>> {
        if !self.item_stack.is_empty() {
            let item = self.item_stack.pop();
            if let Some(ref item) = item {
                trace!("pop     {}: {:?}", context, item);
            }
            item
        } else {
            None
        }
    }

    #[allow(dead_code)]
    // Use this function for debugging purposes:
    // trace!("{}", self.trace_item_stack(context));
    fn trace_item_stack(&self, context: &str) -> std::string::String {
        format!(
            "Item stack at {}:\n{}",
            context,
            self.item_stack
                .iter()
                .rev()
                .map(|s| format!("  {:?}", s))
                .collect::<Vec<std::string::String>>()
                .join("\n")
        )
    }

    /// Semantic action for production 0:
    ///
    /// calc: calcList /* Vec */;
    ///
    #[named]
    fn calc(
        &mut self,
        _calc_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let calc_list = if let Some(ASTType::CalcList(mut calc_list)) = self.pop(context) {
            calc_list.reverse();
            calc_list
        } else {
            return Err(miette!("{}: Expecting ASTType::CalcList", context));
        };
        let calc_built = CalcBuilder::default()
            .calc_list(calc_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.calc(&calc_built)?;
        self.push(ASTType::Calc(calc_built), context);
        Ok(())
    }

    /// Semantic action for production 1:
    ///
    /// calcList: instruction ";" calcList; // Vec<T>::Push
    ///
    #[named]
    fn calc_list_0(
        &mut self,
        _instruction: &ParseTreeStackEntry<'t>,
        semicolon: &ParseTreeStackEntry<'t>,
        _calc_list: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let semicolon = *semicolon.token(parse_tree)?;
        let mut calc_list = if let Some(ASTType::CalcList(calc_list)) = self.pop(context) {
            calc_list
        } else {
            return Err(miette!("{}: Expecting ASTType::CalcList", context));
        };
        let instruction = if let Some(ASTType::Instruction(instruction)) = self.pop(context) {
            instruction
        } else {
            return Err(miette!("{}: Expecting ASTType::Instruction", context));
        };
        let calc_list_0_built = CalcListBuilder::default()
            .semicolon(semicolon)
            .instruction(Box::new(instruction))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        calc_list.push(calc_list_0_built);
        self.push(ASTType::CalcList(calc_list), context);
        Ok(())
    }

    /// Semantic action for production 2:
    ///
    /// calcList: ; // Vec<T>::New
    ///
    #[named]
    fn calc_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let calc_list_1_built = Vec::new();
        self.push(ASTType::CalcList(calc_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 3:
    ///
    /// equality_op: "==|!=";
    ///
    #[named]
    fn equality_op(
        &mut self,
        equality_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let equality_op = *equality_op.token(parse_tree)?;
        let equality_op_built = EqualityOpBuilder::default()
            .equality_op(equality_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.equality_op(&equality_op_built)?;
        self.push(ASTType::EqualityOp(equality_op_built), context);
        Ok(())
    }

    /// Semantic action for production 4:
    ///
    /// assign_op: "(\+|-|\*|/|%|<<|>>|&|\^|\|)?=";
    ///
    #[named]
    fn assign_op(
        &mut self,
        assign_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let assign_op = *assign_op.token(parse_tree)?;
        let assign_op_built = AssignOpBuilder::default()
            .assign_op(assign_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.assign_op(&assign_op_built)?;
        self.push(ASTType::AssignOp(assign_op_built), context);
        Ok(())
    }

    /// Semantic action for production 5:
    ///
    /// logical_or_op: "\|\|";
    ///
    #[named]
    fn logical_or_op(
        &mut self,
        logical_or_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_or_op = *logical_or_op.token(parse_tree)?;
        let logical_or_op_built = LogicalOrOpBuilder::default()
            .logical_or_op(logical_or_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.logical_or_op(&logical_or_op_built)?;
        self.push(ASTType::LogicalOrOp(logical_or_op_built), context);
        Ok(())
    }

    /// Semantic action for production 6:
    ///
    /// logical_and_op: "&&";
    ///
    #[named]
    fn logical_and_op(
        &mut self,
        logical_and_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_and_op = *logical_and_op.token(parse_tree)?;
        let logical_and_op_built = LogicalAndOpBuilder::default()
            .logical_and_op(logical_and_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.logical_and_op(&logical_and_op_built)?;
        self.push(ASTType::LogicalAndOp(logical_and_op_built), context);
        Ok(())
    }

    /// Semantic action for production 7:
    ///
    /// bitwise_or_op: "\|";
    ///
    #[named]
    fn bitwise_or_op(
        &mut self,
        bitwise_or_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_or_op = *bitwise_or_op.token(parse_tree)?;
        let bitwise_or_op_built = BitwiseOrOpBuilder::default()
            .bitwise_or_op(bitwise_or_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.bitwise_or_op(&bitwise_or_op_built)?;
        self.push(ASTType::BitwiseOrOp(bitwise_or_op_built), context);
        Ok(())
    }

    /// Semantic action for production 8:
    ///
    /// bitwise_and_op: "&";
    ///
    #[named]
    fn bitwise_and_op(
        &mut self,
        bitwise_and_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_and_op = *bitwise_and_op.token(parse_tree)?;
        let bitwise_and_op_built = BitwiseAndOpBuilder::default()
            .bitwise_and_op(bitwise_and_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.bitwise_and_op(&bitwise_and_op_built)?;
        self.push(ASTType::BitwiseAndOp(bitwise_and_op_built), context);
        Ok(())
    }

    /// Semantic action for production 9:
    ///
    /// bitwise_shift_op: "<<|>>";
    ///
    #[named]
    fn bitwise_shift_op(
        &mut self,
        bitwise_shift_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_shift_op = *bitwise_shift_op.token(parse_tree)?;
        let bitwise_shift_op_built = BitwiseShiftOpBuilder::default()
            .bitwise_shift_op(bitwise_shift_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar
            .bitwise_shift_op(&bitwise_shift_op_built)?;
        self.push(ASTType::BitwiseShiftOp(bitwise_shift_op_built), context);
        Ok(())
    }

    /// Semantic action for production 10:
    ///
    /// relational_op: "<=|<|>=|>";
    ///
    #[named]
    fn relational_op(
        &mut self,
        relational_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let relational_op = *relational_op.token(parse_tree)?;
        let relational_op_built = RelationalOpBuilder::default()
            .relational_op(relational_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.relational_op(&relational_op_built)?;
        self.push(ASTType::RelationalOp(relational_op_built), context);
        Ok(())
    }

    /// Semantic action for production 11:
    ///
    /// plus: "\+";
    ///
    #[named]
    fn plus(
        &mut self,
        plus: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let plus = *plus.token(parse_tree)?;
        let plus_built = PlusBuilder::default()
            .plus(plus)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.plus(&plus_built)?;
        self.push(ASTType::Plus(plus_built), context);
        Ok(())
    }

    /// Semantic action for production 12:
    ///
    /// minus: "-";
    ///
    #[named]
    fn minus(
        &mut self,
        minus: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let minus = *minus.token(parse_tree)?;
        let minus_built = MinusBuilder::default()
            .minus(minus)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.minus(&minus_built)?;
        self.push(ASTType::Minus(minus_built), context);
        Ok(())
    }

    /// Semantic action for production 13:
    ///
    /// pow_op: "\*\*";
    ///
    #[named]
    fn pow_op(
        &mut self,
        pow_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let pow_op = *pow_op.token(parse_tree)?;
        let pow_op_built = PowOpBuilder::default()
            .pow_op(pow_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.pow_op(&pow_op_built)?;
        self.push(ASTType::PowOp(pow_op_built), context);
        Ok(())
    }

    /// Semantic action for production 14:
    ///
    /// mult_op: "\*|/|%";
    ///
    #[named]
    fn mult_op(
        &mut self,
        mult_op: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mult_op = *mult_op.token(parse_tree)?;
        let mult_op_built = MultOpBuilder::default()
            .mult_op(mult_op)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.mult_op(&mult_op_built)?;
        self.push(ASTType::MultOp(mult_op_built), context);
        Ok(())
    }

    /// Semantic action for production 15:
    ///
    /// instruction: assignment;
    ///
    #[named]
    fn instruction_0(
        &mut self,
        _assignment: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let assignment = if let Some(ASTType::Assignment(assignment)) = self.pop(context) {
            assignment
        } else {
            return Err(miette!("{}: Expecting ASTType::Assignment", context));
        };
        let instruction_0_built = Instruction0Builder::default()
            .assignment(Box::new(assignment))
            .build()
            .into_diagnostic()?;
        let instruction_0_built = Instruction::Instruction0(instruction_0_built);
        // Calling user action here
        self.user_grammar.instruction(&instruction_0_built)?;
        self.push(ASTType::Instruction(instruction_0_built), context);
        Ok(())
    }

    /// Semantic action for production 16:
    ///
    /// instruction: logical_or;
    ///
    #[named]
    fn instruction_1(
        &mut self,
        _logical_or: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_or = if let Some(ASTType::LogicalOr(logical_or)) = self.pop(context) {
            logical_or
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalOr", context));
        };
        let instruction_1_built = Instruction1Builder::default()
            .logical_or(Box::new(logical_or))
            .build()
            .into_diagnostic()?;
        let instruction_1_built = Instruction::Instruction1(instruction_1_built);
        // Calling user action here
        self.user_grammar.instruction(&instruction_1_built)?;
        self.push(ASTType::Instruction(instruction_1_built), context);
        Ok(())
    }

    /// Semantic action for production 17:
    ///
    /// assign_item: id assign_op;
    ///
    #[named]
    fn assign_item(
        &mut self,
        _id: &ParseTreeStackEntry<'t>,
        _assign_op: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let assign_op = if let Some(ASTType::AssignOp(assign_op)) = self.pop(context) {
            assign_op
        } else {
            return Err(miette!("{}: Expecting ASTType::AssignOp", context));
        };
        let id = if let Some(ASTType::Id(id)) = self.pop(context) {
            id
        } else {
            return Err(miette!("{}: Expecting ASTType::Id", context));
        };
        let assign_item_built = AssignItemBuilder::default()
            .id(Box::new(id))
            .assign_op(Box::new(assign_op))
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.assign_item(&assign_item_built)?;
        self.push(ASTType::AssignItem(assign_item_built), context);
        Ok(())
    }

    /// Semantic action for production 18:
    ///
    /// assignment: assign_item assignmentList /* Vec */ logical_or;
    ///
    #[named]
    fn assignment(
        &mut self,
        _assign_item: &ParseTreeStackEntry<'t>,
        _assignment_list: &ParseTreeStackEntry<'t>,
        _logical_or: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_or = if let Some(ASTType::LogicalOr(logical_or)) = self.pop(context) {
            logical_or
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalOr", context));
        };
        let assignment_list =
            if let Some(ASTType::AssignmentList(mut assignment_list)) = self.pop(context) {
                assignment_list.reverse();
                assignment_list
            } else {
                return Err(miette!("{}: Expecting ASTType::AssignmentList", context));
            };
        let assign_item = if let Some(ASTType::AssignItem(assign_item)) = self.pop(context) {
            assign_item
        } else {
            return Err(miette!("{}: Expecting ASTType::AssignItem", context));
        };
        let assignment_built = AssignmentBuilder::default()
            .assign_item(Box::new(assign_item))
            .assignment_list(assignment_list)
            .logical_or(Box::new(logical_or))
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.assignment(&assignment_built)?;
        self.push(ASTType::Assignment(assignment_built), context);
        Ok(())
    }

    /// Semantic action for production 19:
    ///
    /// assignmentList: assign_item assignmentList; // Vec<T>::Push
    ///
    #[named]
    fn assignment_list_0(
        &mut self,
        _assign_item: &ParseTreeStackEntry<'t>,
        _assignment_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut assignment_list =
            if let Some(ASTType::AssignmentList(assignment_list)) = self.pop(context) {
                assignment_list
            } else {
                return Err(miette!("{}: Expecting ASTType::AssignmentList", context));
            };
        let assign_item = if let Some(ASTType::AssignItem(assign_item)) = self.pop(context) {
            assign_item
        } else {
            return Err(miette!("{}: Expecting ASTType::AssignItem", context));
        };
        let assignment_list_0_built = AssignmentListBuilder::default()
            .assign_item(Box::new(assign_item))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        assignment_list.push(assignment_list_0_built);
        self.push(ASTType::AssignmentList(assignment_list), context);
        Ok(())
    }

    /// Semantic action for production 20:
    ///
    /// assignmentList: ; // Vec<T>::New
    ///
    #[named]
    fn assignment_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let assignment_list_1_built = Vec::new();
        self.push(ASTType::AssignmentList(assignment_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 21:
    ///
    /// logical_or: logical_and logical_orList /* Vec */;
    ///
    #[named]
    fn logical_or(
        &mut self,
        _logical_and: &ParseTreeStackEntry<'t>,
        _logical_or_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_or_list =
            if let Some(ASTType::LogicalOrList(mut logical_or_list)) = self.pop(context) {
                logical_or_list.reverse();
                logical_or_list
            } else {
                return Err(miette!("{}: Expecting ASTType::LogicalOrList", context));
            };
        let logical_and = if let Some(ASTType::LogicalAnd(logical_and)) = self.pop(context) {
            logical_and
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalAnd", context));
        };
        let logical_or_built = LogicalOrBuilder::default()
            .logical_and(Box::new(logical_and))
            .logical_or_list(logical_or_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.logical_or(&logical_or_built)?;
        self.push(ASTType::LogicalOr(logical_or_built), context);
        Ok(())
    }

    /// Semantic action for production 22:
    ///
    /// logical_orList: logical_or_op logical_and logical_orList; // Vec<T>::Push
    ///
    #[named]
    fn logical_or_list_0(
        &mut self,
        _logical_or_op: &ParseTreeStackEntry<'t>,
        _logical_and: &ParseTreeStackEntry<'t>,
        _logical_or_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut logical_or_list =
            if let Some(ASTType::LogicalOrList(logical_or_list)) = self.pop(context) {
                logical_or_list
            } else {
                return Err(miette!("{}: Expecting ASTType::LogicalOrList", context));
            };
        let logical_and = if let Some(ASTType::LogicalAnd(logical_and)) = self.pop(context) {
            logical_and
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalAnd", context));
        };
        let logical_or_op = if let Some(ASTType::LogicalOrOp(logical_or_op)) = self.pop(context) {
            logical_or_op
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalOrOp", context));
        };
        let logical_or_list_0_built = LogicalOrListBuilder::default()
            .logical_and(Box::new(logical_and))
            .logical_or_op(Box::new(logical_or_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        logical_or_list.push(logical_or_list_0_built);
        self.push(ASTType::LogicalOrList(logical_or_list), context);
        Ok(())
    }

    /// Semantic action for production 23:
    ///
    /// logical_orList: ; // Vec<T>::New
    ///
    #[named]
    fn logical_or_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_or_list_1_built = Vec::new();
        self.push(ASTType::LogicalOrList(logical_or_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 24:
    ///
    /// logical_and: bitwise_or logical_andList /* Vec */;
    ///
    #[named]
    fn logical_and(
        &mut self,
        _bitwise_or: &ParseTreeStackEntry<'t>,
        _logical_and_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_and_list =
            if let Some(ASTType::LogicalAndList(mut logical_and_list)) = self.pop(context) {
                logical_and_list.reverse();
                logical_and_list
            } else {
                return Err(miette!("{}: Expecting ASTType::LogicalAndList", context));
            };
        let bitwise_or = if let Some(ASTType::BitwiseOr(bitwise_or)) = self.pop(context) {
            bitwise_or
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseOr", context));
        };
        let logical_and_built = LogicalAndBuilder::default()
            .bitwise_or(Box::new(bitwise_or))
            .logical_and_list(logical_and_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.logical_and(&logical_and_built)?;
        self.push(ASTType::LogicalAnd(logical_and_built), context);
        Ok(())
    }

    /// Semantic action for production 25:
    ///
    /// logical_andList: logical_and_op bitwise_or logical_andList; // Vec<T>::Push
    ///
    #[named]
    fn logical_and_list_0(
        &mut self,
        _logical_and_op: &ParseTreeStackEntry<'t>,
        _bitwise_or: &ParseTreeStackEntry<'t>,
        _logical_and_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut logical_and_list =
            if let Some(ASTType::LogicalAndList(logical_and_list)) = self.pop(context) {
                logical_and_list
            } else {
                return Err(miette!("{}: Expecting ASTType::LogicalAndList", context));
            };
        let bitwise_or = if let Some(ASTType::BitwiseOr(bitwise_or)) = self.pop(context) {
            bitwise_or
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseOr", context));
        };
        let logical_and_op = if let Some(ASTType::LogicalAndOp(logical_and_op)) = self.pop(context)
        {
            logical_and_op
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalAndOp", context));
        };
        let logical_and_list_0_built = LogicalAndListBuilder::default()
            .bitwise_or(Box::new(bitwise_or))
            .logical_and_op(Box::new(logical_and_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        logical_and_list.push(logical_and_list_0_built);
        self.push(ASTType::LogicalAndList(logical_and_list), context);
        Ok(())
    }

    /// Semantic action for production 26:
    ///
    /// logical_andList: ; // Vec<T>::New
    ///
    #[named]
    fn logical_and_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let logical_and_list_1_built = Vec::new();
        self.push(ASTType::LogicalAndList(logical_and_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 27:
    ///
    /// bitwise_or: bitwise_and bitwise_orList /* Vec */;
    ///
    #[named]
    fn bitwise_or(
        &mut self,
        _bitwise_and: &ParseTreeStackEntry<'t>,
        _bitwise_or_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_or_list =
            if let Some(ASTType::BitwiseOrList(mut bitwise_or_list)) = self.pop(context) {
                bitwise_or_list.reverse();
                bitwise_or_list
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseOrList", context));
            };
        let bitwise_and = if let Some(ASTType::BitwiseAnd(bitwise_and)) = self.pop(context) {
            bitwise_and
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseAnd", context));
        };
        let bitwise_or_built = BitwiseOrBuilder::default()
            .bitwise_and(Box::new(bitwise_and))
            .bitwise_or_list(bitwise_or_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.bitwise_or(&bitwise_or_built)?;
        self.push(ASTType::BitwiseOr(bitwise_or_built), context);
        Ok(())
    }

    /// Semantic action for production 28:
    ///
    /// bitwise_orList: bitwise_or_op bitwise_and bitwise_orList; // Vec<T>::Push
    ///
    #[named]
    fn bitwise_or_list_0(
        &mut self,
        _bitwise_or_op: &ParseTreeStackEntry<'t>,
        _bitwise_and: &ParseTreeStackEntry<'t>,
        _bitwise_or_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut bitwise_or_list =
            if let Some(ASTType::BitwiseOrList(bitwise_or_list)) = self.pop(context) {
                bitwise_or_list
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseOrList", context));
            };
        let bitwise_and = if let Some(ASTType::BitwiseAnd(bitwise_and)) = self.pop(context) {
            bitwise_and
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseAnd", context));
        };
        let bitwise_or_op = if let Some(ASTType::BitwiseOrOp(bitwise_or_op)) = self.pop(context) {
            bitwise_or_op
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseOrOp", context));
        };
        let bitwise_or_list_0_built = BitwiseOrListBuilder::default()
            .bitwise_and(Box::new(bitwise_and))
            .bitwise_or_op(Box::new(bitwise_or_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        bitwise_or_list.push(bitwise_or_list_0_built);
        self.push(ASTType::BitwiseOrList(bitwise_or_list), context);
        Ok(())
    }

    /// Semantic action for production 29:
    ///
    /// bitwise_orList: ; // Vec<T>::New
    ///
    #[named]
    fn bitwise_or_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_or_list_1_built = Vec::new();
        self.push(ASTType::BitwiseOrList(bitwise_or_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 30:
    ///
    /// bitwise_and: equality bitwise_andList /* Vec */;
    ///
    #[named]
    fn bitwise_and(
        &mut self,
        _equality: &ParseTreeStackEntry<'t>,
        _bitwise_and_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_and_list =
            if let Some(ASTType::BitwiseAndList(mut bitwise_and_list)) = self.pop(context) {
                bitwise_and_list.reverse();
                bitwise_and_list
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseAndList", context));
            };
        let equality = if let Some(ASTType::Equality(equality)) = self.pop(context) {
            equality
        } else {
            return Err(miette!("{}: Expecting ASTType::Equality", context));
        };
        let bitwise_and_built = BitwiseAndBuilder::default()
            .equality(Box::new(equality))
            .bitwise_and_list(bitwise_and_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.bitwise_and(&bitwise_and_built)?;
        self.push(ASTType::BitwiseAnd(bitwise_and_built), context);
        Ok(())
    }

    /// Semantic action for production 31:
    ///
    /// bitwise_andList: bitwise_and_op equality bitwise_andList; // Vec<T>::Push
    ///
    #[named]
    fn bitwise_and_list_0(
        &mut self,
        _bitwise_and_op: &ParseTreeStackEntry<'t>,
        _equality: &ParseTreeStackEntry<'t>,
        _bitwise_and_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut bitwise_and_list =
            if let Some(ASTType::BitwiseAndList(bitwise_and_list)) = self.pop(context) {
                bitwise_and_list
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseAndList", context));
            };
        let equality = if let Some(ASTType::Equality(equality)) = self.pop(context) {
            equality
        } else {
            return Err(miette!("{}: Expecting ASTType::Equality", context));
        };
        let bitwise_and_op = if let Some(ASTType::BitwiseAndOp(bitwise_and_op)) = self.pop(context)
        {
            bitwise_and_op
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseAndOp", context));
        };
        let bitwise_and_list_0_built = BitwiseAndListBuilder::default()
            .equality(Box::new(equality))
            .bitwise_and_op(Box::new(bitwise_and_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        bitwise_and_list.push(bitwise_and_list_0_built);
        self.push(ASTType::BitwiseAndList(bitwise_and_list), context);
        Ok(())
    }

    /// Semantic action for production 32:
    ///
    /// bitwise_andList: ; // Vec<T>::New
    ///
    #[named]
    fn bitwise_and_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_and_list_1_built = Vec::new();
        self.push(ASTType::BitwiseAndList(bitwise_and_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 33:
    ///
    /// equality: relational equalityList /* Vec */;
    ///
    #[named]
    fn equality(
        &mut self,
        _relational: &ParseTreeStackEntry<'t>,
        _equality_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let equality_list =
            if let Some(ASTType::EqualityList(mut equality_list)) = self.pop(context) {
                equality_list.reverse();
                equality_list
            } else {
                return Err(miette!("{}: Expecting ASTType::EqualityList", context));
            };
        let relational = if let Some(ASTType::Relational(relational)) = self.pop(context) {
            relational
        } else {
            return Err(miette!("{}: Expecting ASTType::Relational", context));
        };
        let equality_built = EqualityBuilder::default()
            .relational(Box::new(relational))
            .equality_list(equality_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.equality(&equality_built)?;
        self.push(ASTType::Equality(equality_built), context);
        Ok(())
    }

    /// Semantic action for production 34:
    ///
    /// equalityList: equality_op relational equalityList; // Vec<T>::Push
    ///
    #[named]
    fn equality_list_0(
        &mut self,
        _equality_op: &ParseTreeStackEntry<'t>,
        _relational: &ParseTreeStackEntry<'t>,
        _equality_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut equality_list =
            if let Some(ASTType::EqualityList(equality_list)) = self.pop(context) {
                equality_list
            } else {
                return Err(miette!("{}: Expecting ASTType::EqualityList", context));
            };
        let relational = if let Some(ASTType::Relational(relational)) = self.pop(context) {
            relational
        } else {
            return Err(miette!("{}: Expecting ASTType::Relational", context));
        };
        let equality_op = if let Some(ASTType::EqualityOp(equality_op)) = self.pop(context) {
            equality_op
        } else {
            return Err(miette!("{}: Expecting ASTType::EqualityOp", context));
        };
        let equality_list_0_built = EqualityListBuilder::default()
            .relational(Box::new(relational))
            .equality_op(Box::new(equality_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        equality_list.push(equality_list_0_built);
        self.push(ASTType::EqualityList(equality_list), context);
        Ok(())
    }

    /// Semantic action for production 35:
    ///
    /// equalityList: ; // Vec<T>::New
    ///
    #[named]
    fn equality_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let equality_list_1_built = Vec::new();
        self.push(ASTType::EqualityList(equality_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 36:
    ///
    /// relational: bitwise_shift relationalList /* Vec */;
    ///
    #[named]
    fn relational(
        &mut self,
        _bitwise_shift: &ParseTreeStackEntry<'t>,
        _relational_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let relational_list =
            if let Some(ASTType::RelationalList(mut relational_list)) = self.pop(context) {
                relational_list.reverse();
                relational_list
            } else {
                return Err(miette!("{}: Expecting ASTType::RelationalList", context));
            };
        let bitwise_shift = if let Some(ASTType::BitwiseShift(bitwise_shift)) = self.pop(context) {
            bitwise_shift
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseShift", context));
        };
        let relational_built = RelationalBuilder::default()
            .bitwise_shift(Box::new(bitwise_shift))
            .relational_list(relational_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.relational(&relational_built)?;
        self.push(ASTType::Relational(relational_built), context);
        Ok(())
    }

    /// Semantic action for production 37:
    ///
    /// relationalList: relational_op bitwise_shift relationalList; // Vec<T>::Push
    ///
    #[named]
    fn relational_list_0(
        &mut self,
        _relational_op: &ParseTreeStackEntry<'t>,
        _bitwise_shift: &ParseTreeStackEntry<'t>,
        _relational_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut relational_list =
            if let Some(ASTType::RelationalList(relational_list)) = self.pop(context) {
                relational_list
            } else {
                return Err(miette!("{}: Expecting ASTType::RelationalList", context));
            };
        let bitwise_shift = if let Some(ASTType::BitwiseShift(bitwise_shift)) = self.pop(context) {
            bitwise_shift
        } else {
            return Err(miette!("{}: Expecting ASTType::BitwiseShift", context));
        };
        let relational_op = if let Some(ASTType::RelationalOp(relational_op)) = self.pop(context) {
            relational_op
        } else {
            return Err(miette!("{}: Expecting ASTType::RelationalOp", context));
        };
        let relational_list_0_built = RelationalListBuilder::default()
            .bitwise_shift(Box::new(bitwise_shift))
            .relational_op(Box::new(relational_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        relational_list.push(relational_list_0_built);
        self.push(ASTType::RelationalList(relational_list), context);
        Ok(())
    }

    /// Semantic action for production 38:
    ///
    /// relationalList: ; // Vec<T>::New
    ///
    #[named]
    fn relational_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let relational_list_1_built = Vec::new();
        self.push(ASTType::RelationalList(relational_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 39:
    ///
    /// bitwise_shift: summ bitwise_shiftList /* Vec */;
    ///
    #[named]
    fn bitwise_shift(
        &mut self,
        _summ: &ParseTreeStackEntry<'t>,
        _bitwise_shift_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_shift_list =
            if let Some(ASTType::BitwiseShiftList(mut bitwise_shift_list)) = self.pop(context) {
                bitwise_shift_list.reverse();
                bitwise_shift_list
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseShiftList", context));
            };
        let summ = if let Some(ASTType::Summ(summ)) = self.pop(context) {
            summ
        } else {
            return Err(miette!("{}: Expecting ASTType::Summ", context));
        };
        let bitwise_shift_built = BitwiseShiftBuilder::default()
            .summ(Box::new(summ))
            .bitwise_shift_list(bitwise_shift_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.bitwise_shift(&bitwise_shift_built)?;
        self.push(ASTType::BitwiseShift(bitwise_shift_built), context);
        Ok(())
    }

    /// Semantic action for production 40:
    ///
    /// bitwise_shiftList: bitwise_shift_op summ bitwise_shiftList; // Vec<T>::Push
    ///
    #[named]
    fn bitwise_shift_list_0(
        &mut self,
        _bitwise_shift_op: &ParseTreeStackEntry<'t>,
        _summ: &ParseTreeStackEntry<'t>,
        _bitwise_shift_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut bitwise_shift_list =
            if let Some(ASTType::BitwiseShiftList(bitwise_shift_list)) = self.pop(context) {
                bitwise_shift_list
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseShiftList", context));
            };
        let summ = if let Some(ASTType::Summ(summ)) = self.pop(context) {
            summ
        } else {
            return Err(miette!("{}: Expecting ASTType::Summ", context));
        };
        let bitwise_shift_op =
            if let Some(ASTType::BitwiseShiftOp(bitwise_shift_op)) = self.pop(context) {
                bitwise_shift_op
            } else {
                return Err(miette!("{}: Expecting ASTType::BitwiseShiftOp", context));
            };
        let bitwise_shift_list_0_built = BitwiseShiftListBuilder::default()
            .summ(Box::new(summ))
            .bitwise_shift_op(Box::new(bitwise_shift_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        bitwise_shift_list.push(bitwise_shift_list_0_built);
        self.push(ASTType::BitwiseShiftList(bitwise_shift_list), context);
        Ok(())
    }

    /// Semantic action for production 41:
    ///
    /// bitwise_shiftList: ; // Vec<T>::New
    ///
    #[named]
    fn bitwise_shift_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let bitwise_shift_list_1_built = Vec::new();
        self.push(
            ASTType::BitwiseShiftList(bitwise_shift_list_1_built),
            context,
        );
        Ok(())
    }

    /// Semantic action for production 42:
    ///
    /// add_op: plus;
    ///
    #[named]
    fn add_op_0(
        &mut self,
        _plus: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let plus = if let Some(ASTType::Plus(plus)) = self.pop(context) {
            plus
        } else {
            return Err(miette!("{}: Expecting ASTType::Plus", context));
        };
        let add_op_0_built = AddOp0Builder::default()
            .plus(Box::new(plus))
            .build()
            .into_diagnostic()?;
        let add_op_0_built = AddOp::AddOp0(add_op_0_built);
        // Calling user action here
        self.user_grammar.add_op(&add_op_0_built)?;
        self.push(ASTType::AddOp(add_op_0_built), context);
        Ok(())
    }

    /// Semantic action for production 43:
    ///
    /// add_op: minus;
    ///
    #[named]
    fn add_op_1(
        &mut self,
        _minus: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let minus = if let Some(ASTType::Minus(minus)) = self.pop(context) {
            minus
        } else {
            return Err(miette!("{}: Expecting ASTType::Minus", context));
        };
        let add_op_1_built = AddOp1Builder::default()
            .minus(Box::new(minus))
            .build()
            .into_diagnostic()?;
        let add_op_1_built = AddOp::AddOp1(add_op_1_built);
        // Calling user action here
        self.user_grammar.add_op(&add_op_1_built)?;
        self.push(ASTType::AddOp(add_op_1_built), context);
        Ok(())
    }

    /// Semantic action for production 44:
    ///
    /// summ: mult summList /* Vec */;
    ///
    #[named]
    fn summ(
        &mut self,
        _mult: &ParseTreeStackEntry<'t>,
        _summ_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let summ_list = if let Some(ASTType::SummList(mut summ_list)) = self.pop(context) {
            summ_list.reverse();
            summ_list
        } else {
            return Err(miette!("{}: Expecting ASTType::SummList", context));
        };
        let mult = if let Some(ASTType::Mult(mult)) = self.pop(context) {
            mult
        } else {
            return Err(miette!("{}: Expecting ASTType::Mult", context));
        };
        let summ_built = SummBuilder::default()
            .mult(Box::new(mult))
            .summ_list(summ_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.summ(&summ_built)?;
        self.push(ASTType::Summ(summ_built), context);
        Ok(())
    }

    /// Semantic action for production 45:
    ///
    /// summList: add_op mult summList; // Vec<T>::Push
    ///
    #[named]
    fn summ_list_0(
        &mut self,
        _add_op: &ParseTreeStackEntry<'t>,
        _mult: &ParseTreeStackEntry<'t>,
        _summ_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut summ_list = if let Some(ASTType::SummList(summ_list)) = self.pop(context) {
            summ_list
        } else {
            return Err(miette!("{}: Expecting ASTType::SummList", context));
        };
        let mult = if let Some(ASTType::Mult(mult)) = self.pop(context) {
            mult
        } else {
            return Err(miette!("{}: Expecting ASTType::Mult", context));
        };
        let add_op = if let Some(ASTType::AddOp(add_op)) = self.pop(context) {
            add_op
        } else {
            return Err(miette!("{}: Expecting ASTType::AddOp", context));
        };
        let summ_list_0_built = SummListBuilder::default()
            .mult(Box::new(mult))
            .add_op(Box::new(add_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        summ_list.push(summ_list_0_built);
        self.push(ASTType::SummList(summ_list), context);
        Ok(())
    }

    /// Semantic action for production 46:
    ///
    /// summList: ; // Vec<T>::New
    ///
    #[named]
    fn summ_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let summ_list_1_built = Vec::new();
        self.push(ASTType::SummList(summ_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 47:
    ///
    /// mult: power multList /* Vec */;
    ///
    #[named]
    fn mult(
        &mut self,
        _power: &ParseTreeStackEntry<'t>,
        _mult_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mult_list = if let Some(ASTType::MultList(mut mult_list)) = self.pop(context) {
            mult_list.reverse();
            mult_list
        } else {
            return Err(miette!("{}: Expecting ASTType::MultList", context));
        };
        let power = if let Some(ASTType::Power(power)) = self.pop(context) {
            power
        } else {
            return Err(miette!("{}: Expecting ASTType::Power", context));
        };
        let mult_built = MultBuilder::default()
            .power(Box::new(power))
            .mult_list(mult_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.mult(&mult_built)?;
        self.push(ASTType::Mult(mult_built), context);
        Ok(())
    }

    /// Semantic action for production 48:
    ///
    /// multList: mult_op power multList; // Vec<T>::Push
    ///
    #[named]
    fn mult_list_0(
        &mut self,
        _mult_op: &ParseTreeStackEntry<'t>,
        _power: &ParseTreeStackEntry<'t>,
        _mult_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut mult_list = if let Some(ASTType::MultList(mult_list)) = self.pop(context) {
            mult_list
        } else {
            return Err(miette!("{}: Expecting ASTType::MultList", context));
        };
        let power = if let Some(ASTType::Power(power)) = self.pop(context) {
            power
        } else {
            return Err(miette!("{}: Expecting ASTType::Power", context));
        };
        let mult_op = if let Some(ASTType::MultOp(mult_op)) = self.pop(context) {
            mult_op
        } else {
            return Err(miette!("{}: Expecting ASTType::MultOp", context));
        };
        let mult_list_0_built = MultListBuilder::default()
            .power(Box::new(power))
            .mult_op(Box::new(mult_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        mult_list.push(mult_list_0_built);
        self.push(ASTType::MultList(mult_list), context);
        Ok(())
    }

    /// Semantic action for production 49:
    ///
    /// multList: ; // Vec<T>::New
    ///
    #[named]
    fn mult_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mult_list_1_built = Vec::new();
        self.push(ASTType::MultList(mult_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 50:
    ///
    /// power: factor powerList /* Vec */;
    ///
    #[named]
    fn power(
        &mut self,
        _factor: &ParseTreeStackEntry<'t>,
        _power_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let power_list = if let Some(ASTType::PowerList(mut power_list)) = self.pop(context) {
            power_list.reverse();
            power_list
        } else {
            return Err(miette!("{}: Expecting ASTType::PowerList", context));
        };
        let factor = if let Some(ASTType::Factor(factor)) = self.pop(context) {
            factor
        } else {
            return Err(miette!("{}: Expecting ASTType::Factor", context));
        };
        let power_built = PowerBuilder::default()
            .factor(Box::new(factor))
            .power_list(power_list)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.power(&power_built)?;
        self.push(ASTType::Power(power_built), context);
        Ok(())
    }

    /// Semantic action for production 51:
    ///
    /// powerList: pow_op factor powerList; // Vec<T>::Push
    ///
    #[named]
    fn power_list_0(
        &mut self,
        _pow_op: &ParseTreeStackEntry<'t>,
        _factor: &ParseTreeStackEntry<'t>,
        _power_list: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let mut power_list = if let Some(ASTType::PowerList(power_list)) = self.pop(context) {
            power_list
        } else {
            return Err(miette!("{}: Expecting ASTType::PowerList", context));
        };
        let factor = if let Some(ASTType::Factor(factor)) = self.pop(context) {
            factor
        } else {
            return Err(miette!("{}: Expecting ASTType::Factor", context));
        };
        let pow_op = if let Some(ASTType::PowOp(pow_op)) = self.pop(context) {
            pow_op
        } else {
            return Err(miette!("{}: Expecting ASTType::PowOp", context));
        };
        let power_list_0_built = PowerListBuilder::default()
            .factor(Box::new(factor))
            .pow_op(Box::new(pow_op))
            .build()
            .into_diagnostic()?;
        // Add an element to the vector
        power_list.push(power_list_0_built);
        self.push(ASTType::PowerList(power_list), context);
        Ok(())
    }

    /// Semantic action for production 52:
    ///
    /// powerList: ; // Vec<T>::New
    ///
    #[named]
    fn power_list_1(&mut self, _parse_tree: &Tree<ParseTreeType<'t>>) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let power_list_1_built = Vec::new();
        self.push(ASTType::PowerList(power_list_1_built), context);
        Ok(())
    }

    /// Semantic action for production 53:
    ///
    /// negate: minus;
    ///
    #[named]
    fn negate(
        &mut self,
        _minus: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let minus = if let Some(ASTType::Minus(minus)) = self.pop(context) {
            minus
        } else {
            return Err(miette!("{}: Expecting ASTType::Minus", context));
        };
        let negate_built = NegateBuilder::default()
            .minus(Box::new(minus))
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.negate(&negate_built)?;
        self.push(ASTType::Negate(negate_built), context);
        Ok(())
    }

    /// Semantic action for production 54:
    ///
    /// factor: number;
    ///
    #[named]
    fn factor_0(
        &mut self,
        _number: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let number = if let Some(ASTType::Number(number)) = self.pop(context) {
            number
        } else {
            return Err(miette!("{}: Expecting ASTType::Number", context));
        };
        let factor_0_built = Factor0Builder::default()
            .number(Box::new(number))
            .build()
            .into_diagnostic()?;
        let factor_0_built = Factor::Factor0(factor_0_built);
        // Calling user action here
        self.user_grammar.factor(&factor_0_built)?;
        self.push(ASTType::Factor(factor_0_built), context);
        Ok(())
    }

    /// Semantic action for production 55:
    ///
    /// factor: idref;
    ///
    #[named]
    fn factor_1(
        &mut self,
        _idref: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let idref = if let Some(ASTType::Idref(idref)) = self.pop(context) {
            idref
        } else {
            return Err(miette!("{}: Expecting ASTType::Idref", context));
        };
        let factor_1_built = Factor1Builder::default()
            .idref(Box::new(idref))
            .build()
            .into_diagnostic()?;
        let factor_1_built = Factor::Factor1(factor_1_built);
        // Calling user action here
        self.user_grammar.factor(&factor_1_built)?;
        self.push(ASTType::Factor(factor_1_built), context);
        Ok(())
    }

    /// Semantic action for production 56:
    ///
    /// factor: negate factor;
    ///
    #[named]
    fn factor_2(
        &mut self,
        _negate: &ParseTreeStackEntry<'t>,
        _factor: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let factor = if let Some(ASTType::Factor(factor)) = self.pop(context) {
            factor
        } else {
            return Err(miette!("{}: Expecting ASTType::Factor", context));
        };
        let negate = if let Some(ASTType::Negate(negate)) = self.pop(context) {
            negate
        } else {
            return Err(miette!("{}: Expecting ASTType::Negate", context));
        };
        let factor_2_built = Factor2Builder::default()
            .negate(Box::new(negate))
            .factor(Box::new(factor))
            .build()
            .into_diagnostic()?;
        let factor_2_built = Factor::Factor2(factor_2_built);
        // Calling user action here
        self.user_grammar.factor(&factor_2_built)?;
        self.push(ASTType::Factor(factor_2_built), context);
        Ok(())
    }

    /// Semantic action for production 57:
    ///
    /// factor: "\(" logical_or "\)";
    ///
    #[named]
    fn factor_3(
        &mut self,
        l_paren: &ParseTreeStackEntry<'t>,
        _logical_or: &ParseTreeStackEntry<'t>,
        r_paren: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let l_paren = *l_paren.token(parse_tree)?;
        let r_paren = *r_paren.token(parse_tree)?;
        let logical_or = if let Some(ASTType::LogicalOr(logical_or)) = self.pop(context) {
            logical_or
        } else {
            return Err(miette!("{}: Expecting ASTType::LogicalOr", context));
        };
        let factor_3_built = Factor3Builder::default()
            .l_paren(l_paren)
            .logical_or(Box::new(logical_or))
            .r_paren(r_paren)
            .build()
            .into_diagnostic()?;
        let factor_3_built = Factor::Factor3(factor_3_built);
        // Calling user action here
        self.user_grammar.factor(&factor_3_built)?;
        self.push(ASTType::Factor(factor_3_built), context);
        Ok(())
    }

    /// Semantic action for production 58:
    ///
    /// number: "0|[1-9][0-9]*";
    ///
    #[named]
    fn number(
        &mut self,
        number: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let number = *number.token(parse_tree)?;
        let number_built = NumberBuilder::default()
            .number(number)
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.number(&number_built)?;
        self.push(ASTType::Number(number_built), context);
        Ok(())
    }

    /// Semantic action for production 59:
    ///
    /// idref: id;
    ///
    #[named]
    fn idref(
        &mut self,
        _id: &ParseTreeStackEntry<'t>,
        _parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let id = if let Some(ASTType::Id(id)) = self.pop(context) {
            id
        } else {
            return Err(miette!("{}: Expecting ASTType::Id", context));
        };
        let idref_built = IdrefBuilder::default()
            .id(Box::new(id))
            .build()
            .into_diagnostic()?;
        // Calling user action here
        self.user_grammar.idref(&idref_built)?;
        self.push(ASTType::Idref(idref_built), context);
        Ok(())
    }

    /// Semantic action for production 60:
    ///
    /// id: "[a-zA-Z_][a-zA-Z0-9_]*";
    ///
    #[named]
    fn id(
        &mut self,
        id: &ParseTreeStackEntry<'t>,
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        let context = function_name!();
        trace!("{}", self.trace_item_stack(context));
        let id = *id.token(parse_tree)?;
        let id_built = IdBuilder::default().id(id).build().into_diagnostic()?;
        // Calling user action here
        self.user_grammar.id(&id_built)?;
        self.push(ASTType::Id(id_built), context);
        Ok(())
    }
}

impl<'t> UserActionsTrait<'t> for CalcGrammarAuto<'t, '_> {
    ///
    /// Initialize the user with additional information.
    /// This function is called by the parser before parsing starts.
    /// It is used to transport necessary data from parser to user.
    ///
    fn init(&mut self, file_name: &Path) {
        self.file_name = file_name.to_owned();
        self.user_grammar.init(file_name);
    }

    ///
    /// This function is implemented automatically for the user's item CalcGrammar.
    ///
    fn call_semantic_action_for_production_number(
        &mut self,
        prod_num: usize,
        children: &[ParseTreeStackEntry<'t>],
        parse_tree: &Tree<ParseTreeType<'t>>,
    ) -> Result<()> {
        match prod_num {
            0 => self.calc(&children[0], parse_tree),
            1 => self.calc_list_0(&children[0], &children[1], &children[2], parse_tree),
            2 => self.calc_list_1(parse_tree),
            3 => self.equality_op(&children[0], parse_tree),
            4 => self.assign_op(&children[0], parse_tree),
            5 => self.logical_or_op(&children[0], parse_tree),
            6 => self.logical_and_op(&children[0], parse_tree),
            7 => self.bitwise_or_op(&children[0], parse_tree),
            8 => self.bitwise_and_op(&children[0], parse_tree),
            9 => self.bitwise_shift_op(&children[0], parse_tree),
            10 => self.relational_op(&children[0], parse_tree),
            11 => self.plus(&children[0], parse_tree),
            12 => self.minus(&children[0], parse_tree),
            13 => self.pow_op(&children[0], parse_tree),
            14 => self.mult_op(&children[0], parse_tree),
            15 => self.instruction_0(&children[0], parse_tree),
            16 => self.instruction_1(&children[0], parse_tree),
            17 => self.assign_item(&children[0], &children[1], parse_tree),
            18 => self.assignment(&children[0], &children[1], &children[2], parse_tree),
            19 => self.assignment_list_0(&children[0], &children[1], parse_tree),
            20 => self.assignment_list_1(parse_tree),
            21 => self.logical_or(&children[0], &children[1], parse_tree),
            22 => self.logical_or_list_0(&children[0], &children[1], &children[2], parse_tree),
            23 => self.logical_or_list_1(parse_tree),
            24 => self.logical_and(&children[0], &children[1], parse_tree),
            25 => self.logical_and_list_0(&children[0], &children[1], &children[2], parse_tree),
            26 => self.logical_and_list_1(parse_tree),
            27 => self.bitwise_or(&children[0], &children[1], parse_tree),
            28 => self.bitwise_or_list_0(&children[0], &children[1], &children[2], parse_tree),
            29 => self.bitwise_or_list_1(parse_tree),
            30 => self.bitwise_and(&children[0], &children[1], parse_tree),
            31 => self.bitwise_and_list_0(&children[0], &children[1], &children[2], parse_tree),
            32 => self.bitwise_and_list_1(parse_tree),
            33 => self.equality(&children[0], &children[1], parse_tree),
            34 => self.equality_list_0(&children[0], &children[1], &children[2], parse_tree),
            35 => self.equality_list_1(parse_tree),
            36 => self.relational(&children[0], &children[1], parse_tree),
            37 => self.relational_list_0(&children[0], &children[1], &children[2], parse_tree),
            38 => self.relational_list_1(parse_tree),
            39 => self.bitwise_shift(&children[0], &children[1], parse_tree),
            40 => self.bitwise_shift_list_0(&children[0], &children[1], &children[2], parse_tree),
            41 => self.bitwise_shift_list_1(parse_tree),
            42 => self.add_op_0(&children[0], parse_tree),
            43 => self.add_op_1(&children[0], parse_tree),
            44 => self.summ(&children[0], &children[1], parse_tree),
            45 => self.summ_list_0(&children[0], &children[1], &children[2], parse_tree),
            46 => self.summ_list_1(parse_tree),
            47 => self.mult(&children[0], &children[1], parse_tree),
            48 => self.mult_list_0(&children[0], &children[1], &children[2], parse_tree),
            49 => self.mult_list_1(parse_tree),
            50 => self.power(&children[0], &children[1], parse_tree),
            51 => self.power_list_0(&children[0], &children[1], &children[2], parse_tree),
            52 => self.power_list_1(parse_tree),
            53 => self.negate(&children[0], parse_tree),
            54 => self.factor_0(&children[0], parse_tree),
            55 => self.factor_1(&children[0], parse_tree),
            56 => self.factor_2(&children[0], &children[1], parse_tree),
            57 => self.factor_3(&children[0], &children[1], &children[2], parse_tree),
            58 => self.number(&children[0], parse_tree),
            59 => self.idref(&children[0], parse_tree),
            60 => self.id(&children[0], parse_tree),
            _ => Err(miette!("Unhandled production number: {}", prod_num)),
        }
    }
}
