// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use miette::Result;
use parol_runtime::lexer::{TokenStream, Tokenizer};
#[allow(unused_imports)]
use parol_runtime::parser::{
    DFATransition, LLKParser, LookaheadDFA, ParseTreeType, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;
use std::path::Path;

use parol_runtime::lexer::tokenizer::{
    ERROR_TOKEN, NEW_LINE_TOKEN, UNMATCHABLE_TOKEN, WHITESPACE_TOKEN,
};

pub const TERMINALS: &[&str; 42] = &[
    /*  0 */ UNMATCHABLE_TOKEN,
    /*  1 */ UNMATCHABLE_TOKEN,
    /*  2 */ UNMATCHABLE_TOKEN,
    /*  3 */ UNMATCHABLE_TOKEN,
    /*  4 */ UNMATCHABLE_TOKEN,
    /*  5 */ r###"\."###,
    /*  6 */ r###"\["###,
    /*  7 */ r###"]"###,
    /*  8 */ r###"\("###,
    /*  9 */ r###"\)"###,
    /* 10 */ r###"~"###,
    /* 11 */ r###":="###,
    /* 12 */ r###">=|<=|\#|<|>"###,
    /* 13 */ r###"="###,
    /* 14 */ r###","###,
    /* 15 */ r###"ELSE"###,
    /* 16 */ r###"END"###,
    /* 17 */ r###"IF"###,
    /* 18 */ r###"THEN"###,
    /* 19 */ r###"ELSIF"###,
    /* 20 */ r###"WHILE"###,
    /* 21 */ r###"DO"###,
    /* 22 */ r###"REPEAT"###,
    /* 23 */ r###"UNTIL"###,
    /* 24 */ r###";"###,
    /* 25 */ r###"ARRAY"###,
    /* 26 */ r###"OF"###,
    /* 27 */ r###":"###,
    /* 28 */ r###"RECORD"###,
    /* 29 */ r###"VAR"###,
    /* 30 */ r###"PROCEDURE"###,
    /* 31 */ r###"BEGIN"###,
    /* 32 */ r###"RETURN"###,
    /* 33 */ r###"TYPE"###,
    /* 34 */ r###"CONST"###,
    /* 35 */ r###"MODULE"###,
    /* 36 */ r###"\*|/|DIV|MOD|&"###,
    /* 37 */ r###"\+|-|OR"###,
    /* 38 */ r###"\+|-"###,
    /* 39 */ r###"[a-zA-Z][a-zA-Z0-9]*"###,
    /* 40 */ r###"[0-9]+"###,
    /* 41 */ ERROR_TOKEN,
];

pub const TERMINAL_NAMES: &[&str; 42] = &[
    /*  0 */ "EndOfInput",
    /*  1 */ "Newline",
    /*  2 */ "Whitespace",
    /*  3 */ "LineComment",
    /*  4 */ "BlockComment",
    /*  5 */ "Dot",
    /*  6 */ "LBracket",
    /*  7 */ "RBracket",
    /*  8 */ "LParen",
    /*  9 */ "RParen",
    /* 10 */ "Tilde",
    /* 11 */ "ColonEqu",
    /* 12 */ "RelationalOps",
    /* 13 */ "Equ",
    /* 14 */ "Comma",
    /* 15 */ "ELSE",
    /* 16 */ "END",
    /* 17 */ "IF",
    /* 18 */ "THEN",
    /* 19 */ "ELSIF",
    /* 20 */ "WHILE",
    /* 21 */ "DO",
    /* 22 */ "REPEAT",
    /* 23 */ "UNTIL",
    /* 24 */ "Semicolon",
    /* 25 */ "ARRAY",
    /* 26 */ "OF",
    /* 27 */ "Colon",
    /* 28 */ "RECORD",
    /* 29 */ "VAR",
    /* 30 */ "PROCEDURE",
    /* 31 */ "BEGIN",
    /* 32 */ "RETURN",
    /* 33 */ "TYPE",
    /* 34 */ "CONST",
    /* 35 */ "MODULE",
    /* 36 */ "MulOperator",
    /* 37 */ "AddOperator",
    /* 38 */ "UnaryOp",
    /* 39 */ "Ident",
    /* 40 */ "Integer",
    /* 41 */ "Error",
];

/* SCANNER_0: "INITIAL" */
const SCANNER_0: (&[&str; 5], &[usize; 36]) = (
    &[
        /*  0 */ UNMATCHABLE_TOKEN,
        /*  1 */ NEW_LINE_TOKEN,
        /*  2 */ WHITESPACE_TOKEN,
        /*  3 */ UNMATCHABLE_TOKEN,
        /*  4 */ r###"((?ms)\(\*.*?\*\))"###,
    ],
    &[
        5,  /* Dot */
        6,  /* LBracket */
        7,  /* RBracket */
        8,  /* LParen */
        9,  /* RParen */
        10, /* Tilde */
        11, /* ColonEqu */
        12, /* RelationalOps */
        13, /* Equ */
        14, /* Comma */
        15, /* ELSE */
        16, /* END */
        17, /* IF */
        18, /* THEN */
        19, /* ELSIF */
        20, /* WHILE */
        21, /* DO */
        22, /* REPEAT */
        23, /* UNTIL */
        24, /* Semicolon */
        25, /* ARRAY */
        26, /* OF */
        27, /* Colon */
        28, /* RECORD */
        29, /* VAR */
        30, /* PROCEDURE */
        31, /* BEGIN */
        32, /* RETURN */
        33, /* TYPE */
        34, /* CONST */
        35, /* MODULE */
        36, /* MulOperator */
        37, /* AddOperator */
        38, /* UnaryOp */
        39, /* Ident */
        40, /* Integer */
    ],
);

const MAX_K: usize = 2;

pub const NON_TERMINALS: &[&str; 59] = &[
    /*  0 */ "ActualParameters",
    /*  1 */ "ActualParametersSuffix",
    /*  2 */ "AddExpression",
    /*  3 */ "AddOperator",
    /*  4 */ "ArrayType",
    /*  5 */ "AssignOp",
    /*  6 */ "ConstDecls",
    /*  7 */ "FPSection",
    /*  8 */ "FPSectionRest",
    /*  9 */ "FieldList",
    /* 10 */ "FieldListRest",
    /* 11 */ "FormalParameters",
    /* 12 */ "FormalParametersSuffix",
    /* 13 */ "IdentList",
    /* 14 */ "IdentListRest",
    /* 15 */ "IfPrefix",
    /* 16 */ "IfStatement",
    /* 17 */ "IfStatementSuffix",
    /* 18 */ "MulExpression",
    /* 19 */ "MulOperator",
    /* 20 */ "ProcedureBody",
    /* 21 */ "ProcedureBodySuffix",
    /* 22 */ "ProcedureBodySuffix1",
    /* 23 */ "ProcedureCall",
    /* 24 */ "ProcedureCallSuffix",
    /* 25 */ "ProcedureDeclaration",
    /* 26 */ "ProcedureDeclarationList",
    /* 27 */ "ProcedureHeading",
    /* 28 */ "ProcedureHeadingSuffix",
    /* 29 */ "RecordType",
    /* 30 */ "RelationOp",
    /* 31 */ "RelationalOps",
    /* 32 */ "RepeatStatement",
    /* 33 */ "SimpleExpression",
    /* 34 */ "StatementSequence",
    /* 35 */ "StatementSequenceRest",
    /* 36 */ "TypeDecls",
    /* 37 */ "UnaryOp",
    /* 38 */ "VarDecls",
    /* 39 */ "WhileStatement",
    /* 40 */ "assignment",
    /* 41 */ "declarations",
    /* 42 */ "declarationsSuffix",
    /* 43 */ "declarationsSuffix1",
    /* 44 */ "declarationsSuffix2",
    /* 45 */ "elseiflist",
    /* 46 */ "expression",
    /* 47 */ "expressionSuffix",
    /* 48 */ "expressionlistrest",
    /* 49 */ "factor",
    /* 50 */ "ident",
    /* 51 */ "integer",
    /* 52 */ "module",
    /* 53 */ "moduleSuffix",
    /* 54 */ "selector",
    /* 55 */ "selectorlist",
    /* 56 */ "statement",
    /* 57 */ "term",
    /* 58 */ "type",
];

pub const LOOKAHEAD_AUTOMATA: &[LookaheadDFA; 59] = &[
    /* 0 - "ActualParameters" */
    LookaheadDFA {
        states: &[Some(24)],
        transitions: &[],
        k: 0,
    },
    /* 1 - "ActualParametersSuffix" */
    LookaheadDFA {
        states: &[None, Some(25), Some(26)],
        transitions: &[
            DFATransition(0, 8, 2),
            DFATransition(0, 9, 1),
            DFATransition(0, 10, 2),
            DFATransition(0, 38, 2),
            DFATransition(0, 39, 2),
            DFATransition(0, 40, 2),
        ],
        k: 1,
    },
    /* 2 - "AddExpression" */
    LookaheadDFA {
        states: &[None, Some(13), Some(14)],
        transitions: &[
            DFATransition(0, 7, 2),
            DFATransition(0, 9, 2),
            DFATransition(0, 11, 2),
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 2),
            DFATransition(0, 14, 2),
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 21, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 26, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 37, 1),
        ],
        k: 1,
    },
    /* 3 - "AddOperator" */
    LookaheadDFA {
        states: &[Some(101)],
        transitions: &[],
        k: 0,
    },
    /* 4 - "ArrayType" */
    LookaheadDFA {
        states: &[Some(52)],
        transitions: &[],
        k: 0,
    },
    /* 5 - "AssignOp" */
    LookaheadDFA {
        states: &[None, Some(15), Some(19)],
        transitions: &[DFATransition(0, 11, 1), DFATransition(0, 13, 2)],
        k: 1,
    },
    /* 6 - "ConstDecls" */
    LookaheadDFA {
        states: &[None, Some(91), Some(92)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 29, 2),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 33, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 7 - "FPSection" */
    LookaheadDFA {
        states: &[None, Some(61), Some(62)],
        transitions: &[DFATransition(0, 29, 1), DFATransition(0, 39, 2)],
        k: 1,
    },
    /* 8 - "FPSectionRest" */
    LookaheadDFA {
        states: &[None, Some(66), Some(67)],
        transitions: &[DFATransition(0, 9, 2), DFATransition(0, 24, 1)],
        k: 1,
    },
    /* 9 - "FieldList" */
    LookaheadDFA {
        states: &[None, Some(53), Some(54)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 10 - "FieldListRest" */
    LookaheadDFA {
        states: &[None, Some(56), Some(57)],
        transitions: &[DFATransition(0, 16, 2), DFATransition(0, 24, 1)],
        k: 1,
    },
    /* 11 - "FormalParameters" */
    LookaheadDFA {
        states: &[Some(63)],
        transitions: &[],
        k: 0,
    },
    /* 12 - "FormalParametersSuffix" */
    LookaheadDFA {
        states: &[None, Some(64), Some(65)],
        transitions: &[
            DFATransition(0, 9, 1),
            DFATransition(0, 29, 2),
            DFATransition(0, 39, 2),
        ],
        k: 1,
    },
    /* 13 - "IdentList" */
    LookaheadDFA {
        states: &[Some(49)],
        transitions: &[],
        k: 0,
    },
    /* 14 - "IdentListRest" */
    LookaheadDFA {
        states: &[None, Some(50), Some(51)],
        transitions: &[DFATransition(0, 14, 1), DFATransition(0, 27, 2)],
        k: 1,
    },
    /* 15 - "IfPrefix" */
    LookaheadDFA {
        states: &[Some(35)],
        transitions: &[],
        k: 0,
    },
    /* 16 - "IfStatement" */
    LookaheadDFA {
        states: &[Some(32)],
        transitions: &[],
        k: 0,
    },
    /* 17 - "IfStatementSuffix" */
    LookaheadDFA {
        states: &[None, Some(33), Some(34)],
        transitions: &[DFATransition(0, 15, 1), DFATransition(0, 16, 2)],
        k: 1,
    },
    /* 18 - "MulExpression" */
    LookaheadDFA {
        states: &[None, Some(10), Some(11)],
        transitions: &[
            DFATransition(0, 7, 2),
            DFATransition(0, 9, 2),
            DFATransition(0, 11, 2),
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 2),
            DFATransition(0, 14, 2),
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 21, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 26, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 36, 1),
            DFATransition(0, 37, 2),
        ],
        k: 1,
    },
    /* 19 - "MulOperator" */
    LookaheadDFA {
        states: &[Some(100)],
        transitions: &[],
        k: 0,
    },
    /* 20 - "ProcedureBody" */
    LookaheadDFA {
        states: &[Some(71)],
        transitions: &[],
        k: 0,
    },
    /* 21 - "ProcedureBodySuffix" */
    LookaheadDFA {
        states: &[None, Some(75), Some(76)],
        transitions: &[DFATransition(0, 16, 2), DFATransition(0, 32, 1)],
        k: 1,
    },
    /* 22 - "ProcedureBodySuffix1" */
    LookaheadDFA {
        states: &[None, Some(72), Some(73), Some(74)],
        transitions: &[
            DFATransition(0, 16, 3),
            DFATransition(0, 31, 1),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 23 - "ProcedureCall" */
    LookaheadDFA {
        states: &[Some(29)],
        transitions: &[],
        k: 0,
    },
    /* 24 - "ProcedureCallSuffix" */
    LookaheadDFA {
        states: &[None, Some(30), Some(31)],
        transitions: &[
            DFATransition(0, 8, 1),
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 25 - "ProcedureDeclaration" */
    LookaheadDFA {
        states: &[Some(77)],
        transitions: &[],
        k: 0,
    },
    /* 26 - "ProcedureDeclarationList" */
    LookaheadDFA {
        states: &[None, Some(89), Some(90)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 30, 1),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 27 - "ProcedureHeading" */
    LookaheadDFA {
        states: &[Some(68)],
        transitions: &[],
        k: 0,
    },
    /* 28 - "ProcedureHeadingSuffix" */
    LookaheadDFA {
        states: &[None, Some(69), Some(70)],
        transitions: &[DFATransition(0, 8, 1), DFATransition(0, 24, 2)],
        k: 1,
    },
    /* 29 - "RecordType" */
    LookaheadDFA {
        states: &[Some(55)],
        transitions: &[],
        k: 0,
    },
    /* 30 - "RelationOp" */
    LookaheadDFA {
        states: &[None, Some(16), Some(17)],
        transitions: &[
            DFATransition(0, 11, 1),
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 1),
        ],
        k: 1,
    },
    /* 31 - "RelationalOps" */
    LookaheadDFA {
        states: &[Some(18)],
        transitions: &[],
        k: 0,
    },
    /* 32 - "RepeatStatement" */
    LookaheadDFA {
        states: &[Some(39)],
        transitions: &[],
        k: 0,
    },
    /* 33 - "SimpleExpression" */
    LookaheadDFA {
        states: &[Some(12)],
        transitions: &[],
        k: 0,
    },
    /* 34 - "StatementSequence" */
    LookaheadDFA {
        states: &[Some(46)],
        transitions: &[],
        k: 0,
    },
    /* 35 - "StatementSequenceRest" */
    LookaheadDFA {
        states: &[None, Some(47), Some(48)],
        transitions: &[
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 1),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 36 - "TypeDecls" */
    LookaheadDFA {
        states: &[None, Some(93), Some(94)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 29, 2),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 37 - "UnaryOp" */
    LookaheadDFA {
        states: &[Some(102)],
        transitions: &[],
        k: 0,
    },
    /* 38 - "VarDecls" */
    LookaheadDFA {
        states: &[None, Some(95), Some(96)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 39 - "WhileStatement" */
    LookaheadDFA {
        states: &[Some(38)],
        transitions: &[],
        k: 0,
    },
    /* 40 - "assignment" */
    LookaheadDFA {
        states: &[Some(23)],
        transitions: &[],
        k: 0,
    },
    /* 41 - "declarations" */
    LookaheadDFA {
        states: &[None, Some(78), Some(79), Some(82), Some(83)],
        transitions: &[
            DFATransition(0, 16, 4),
            DFATransition(0, 29, 3),
            DFATransition(0, 30, 4),
            DFATransition(0, 31, 4),
            DFATransition(0, 32, 4),
            DFATransition(0, 33, 1),
            DFATransition(0, 34, 2),
        ],
        k: 1,
    },
    /* 42 - "declarationsSuffix" */
    LookaheadDFA {
        states: &[None, Some(87), Some(88)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 29, 1),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 43 - "declarationsSuffix1" */
    LookaheadDFA {
        states: &[None, Some(84), Some(85), Some(86)],
        transitions: &[
            DFATransition(0, 16, 3),
            DFATransition(0, 29, 2),
            DFATransition(0, 30, 3),
            DFATransition(0, 31, 3),
            DFATransition(0, 32, 3),
            DFATransition(0, 33, 1),
        ],
        k: 1,
    },
    /* 44 - "declarationsSuffix2" */
    LookaheadDFA {
        states: &[None, Some(80), Some(81)],
        transitions: &[
            DFATransition(0, 16, 2),
            DFATransition(0, 29, 1),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 45 - "elseiflist" */
    LookaheadDFA {
        states: &[None, Some(36), Some(37)],
        transitions: &[
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 19, 1),
        ],
        k: 1,
    },
    /* 46 - "expression" */
    LookaheadDFA {
        states: &[Some(20)],
        transitions: &[],
        k: 0,
    },
    /* 47 - "expressionSuffix" */
    LookaheadDFA {
        states: &[None, Some(21), Some(22)],
        transitions: &[
            DFATransition(0, 7, 2),
            DFATransition(0, 9, 2),
            DFATransition(0, 11, 1),
            DFATransition(0, 12, 1),
            DFATransition(0, 13, 1),
            DFATransition(0, 14, 2),
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 21, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 26, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 48 - "expressionlistrest" */
    LookaheadDFA {
        states: &[None, Some(27), Some(28)],
        transitions: &[DFATransition(0, 9, 2), DFATransition(0, 14, 1)],
        k: 1,
    },
    /* 49 - "factor" */
    LookaheadDFA {
        states: &[None, Some(4), Some(5), Some(6), Some(7), Some(8)],
        transitions: &[
            DFATransition(0, 8, 3),
            DFATransition(0, 10, 4),
            DFATransition(0, 38, 5),
            DFATransition(0, 39, 1),
            DFATransition(0, 40, 2),
        ],
        k: 1,
    },
    /* 50 - "ident" */
    LookaheadDFA {
        states: &[Some(103)],
        transitions: &[],
        k: 0,
    },
    /* 51 - "integer" */
    LookaheadDFA {
        states: &[Some(104)],
        transitions: &[],
        k: 0,
    },
    /* 52 - "module" */
    LookaheadDFA {
        states: &[Some(97)],
        transitions: &[],
        k: 0,
    },
    /* 53 - "moduleSuffix" */
    LookaheadDFA {
        states: &[None, Some(98), Some(99)],
        transitions: &[DFATransition(0, 16, 2), DFATransition(0, 31, 1)],
        k: 1,
    },
    /* 54 - "selector" */
    LookaheadDFA {
        states: &[Some(0)],
        transitions: &[],
        k: 0,
    },
    /* 55 - "selectorlist" */
    LookaheadDFA {
        states: &[None, Some(1), Some(2), Some(3)],
        transitions: &[
            DFATransition(0, 5, 1),
            DFATransition(0, 6, 2),
            DFATransition(0, 7, 3),
            DFATransition(0, 9, 3),
            DFATransition(0, 11, 3),
            DFATransition(0, 12, 3),
            DFATransition(0, 13, 3),
            DFATransition(0, 14, 3),
            DFATransition(0, 15, 3),
            DFATransition(0, 16, 3),
            DFATransition(0, 18, 3),
            DFATransition(0, 19, 3),
            DFATransition(0, 21, 3),
            DFATransition(0, 23, 3),
            DFATransition(0, 24, 3),
            DFATransition(0, 26, 3),
            DFATransition(0, 32, 3),
            DFATransition(0, 36, 3),
            DFATransition(0, 37, 3),
        ],
        k: 1,
    },
    /* 56 - "statement" */
    LookaheadDFA {
        states: &[
            None,
            None,
            Some(40),
            Some(41),
            None,
            Some(42),
            None,
            Some(43),
            None,
            Some(44),
            None,
            None,
            None,
            None,
            None,
            None,
            Some(45),
        ],
        transitions: &[
            DFATransition(0, 15, 10),
            DFATransition(0, 16, 11),
            DFATransition(0, 17, 4),
            DFATransition(0, 19, 12),
            DFATransition(0, 20, 6),
            DFATransition(0, 22, 8),
            DFATransition(0, 23, 13),
            DFATransition(0, 24, 14),
            DFATransition(0, 32, 15),
            DFATransition(0, 39, 1),
            DFATransition(1, 5, 2),
            DFATransition(1, 6, 2),
            DFATransition(1, 8, 3),
            DFATransition(1, 11, 2),
            DFATransition(1, 13, 2),
            DFATransition(1, 15, 3),
            DFATransition(1, 16, 3),
            DFATransition(1, 19, 3),
            DFATransition(1, 23, 3),
            DFATransition(1, 24, 3),
            DFATransition(1, 32, 3),
            DFATransition(4, 8, 5),
            DFATransition(4, 10, 5),
            DFATransition(4, 38, 5),
            DFATransition(4, 39, 5),
            DFATransition(4, 40, 5),
            DFATransition(6, 8, 7),
            DFATransition(6, 10, 7),
            DFATransition(6, 38, 7),
            DFATransition(6, 39, 7),
            DFATransition(6, 40, 7),
            DFATransition(8, 17, 9),
            DFATransition(8, 20, 9),
            DFATransition(8, 22, 9),
            DFATransition(8, 23, 9),
            DFATransition(8, 24, 9),
            DFATransition(8, 39, 9),
            DFATransition(10, 16, 16),
            DFATransition(10, 17, 16),
            DFATransition(10, 20, 16),
            DFATransition(10, 22, 16),
            DFATransition(10, 24, 16),
            DFATransition(10, 39, 16),
            DFATransition(11, 15, 16),
            DFATransition(11, 16, 16),
            DFATransition(11, 19, 16),
            DFATransition(11, 23, 16),
            DFATransition(11, 24, 16),
            DFATransition(11, 32, 16),
            DFATransition(11, 39, 16),
            DFATransition(12, 8, 16),
            DFATransition(12, 10, 16),
            DFATransition(12, 38, 16),
            DFATransition(12, 39, 16),
            DFATransition(12, 40, 16),
            DFATransition(13, 8, 16),
            DFATransition(13, 10, 16),
            DFATransition(13, 38, 16),
            DFATransition(13, 39, 16),
            DFATransition(13, 40, 16),
            DFATransition(14, 15, 16),
            DFATransition(14, 16, 16),
            DFATransition(14, 17, 16),
            DFATransition(14, 19, 16),
            DFATransition(14, 20, 16),
            DFATransition(14, 22, 16),
            DFATransition(14, 23, 16),
            DFATransition(14, 24, 16),
            DFATransition(14, 32, 16),
            DFATransition(14, 39, 16),
            DFATransition(15, 8, 16),
            DFATransition(15, 10, 16),
            DFATransition(15, 38, 16),
            DFATransition(15, 39, 16),
            DFATransition(15, 40, 16),
        ],
        k: 2,
    },
    /* 57 - "term" */
    LookaheadDFA {
        states: &[Some(9)],
        transitions: &[],
        k: 0,
    },
    /* 58 - "type" */
    LookaheadDFA {
        states: &[None, Some(58), Some(59), Some(60)],
        transitions: &[
            DFATransition(0, 25, 2),
            DFATransition(0, 28, 3),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
];

pub const PRODUCTIONS: &[Production; 105] = &[
    // 0 - selector: selectorlist;
    Production {
        lhs: 54,
        production: &[ParseType::N(55)],
    },
    // 1 - selectorlist: "\." ident selectorlist;
    Production {
        lhs: 55,
        production: &[ParseType::N(55), ParseType::N(50), ParseType::T(5)],
    },
    // 2 - selectorlist: "\[" expression "]" selectorlist;
    Production {
        lhs: 55,
        production: &[
            ParseType::N(55),
            ParseType::T(7),
            ParseType::N(46),
            ParseType::T(6),
        ],
    },
    // 3 - selectorlist: ;
    Production {
        lhs: 55,
        production: &[],
    },
    // 4 - factor: ident selector;
    Production {
        lhs: 49,
        production: &[ParseType::N(54), ParseType::N(50)],
    },
    // 5 - factor: integer;
    Production {
        lhs: 49,
        production: &[ParseType::N(51)],
    },
    // 6 - factor: "\(" expression "\)";
    Production {
        lhs: 49,
        production: &[ParseType::T(9), ParseType::N(46), ParseType::T(8)],
    },
    // 7 - factor: "~" factor;
    Production {
        lhs: 49,
        production: &[ParseType::N(49), ParseType::T(10)],
    },
    // 8 - factor: UnaryOp factor;
    Production {
        lhs: 49,
        production: &[ParseType::N(49), ParseType::N(37)],
    },
    // 9 - term: factor MulExpression;
    Production {
        lhs: 57,
        production: &[ParseType::N(18), ParseType::N(49)],
    },
    // 10 - MulExpression: MulOperator factor MulExpression;
    Production {
        lhs: 18,
        production: &[ParseType::N(18), ParseType::N(49), ParseType::N(19)],
    },
    // 11 - MulExpression: ;
    Production {
        lhs: 18,
        production: &[],
    },
    // 12 - SimpleExpression: term AddExpression;
    Production {
        lhs: 33,
        production: &[ParseType::N(2), ParseType::N(57)],
    },
    // 13 - AddExpression: AddOperator term AddExpression;
    Production {
        lhs: 2,
        production: &[ParseType::N(2), ParseType::N(57), ParseType::N(3)],
    },
    // 14 - AddExpression: ;
    Production {
        lhs: 2,
        production: &[],
    },
    // 15 - AssignOp: ":=";
    Production {
        lhs: 5,
        production: &[ParseType::T(11)],
    },
    // 16 - RelationOp: AssignOp;
    Production {
        lhs: 30,
        production: &[ParseType::N(5)],
    },
    // 17 - RelationOp: RelationalOps;
    Production {
        lhs: 30,
        production: &[ParseType::N(31)],
    },
    // 18 - RelationalOps: ">=|<=|\#|<|>";
    Production {
        lhs: 31,
        production: &[ParseType::T(12)],
    },
    // 19 - AssignOp: "=";
    Production {
        lhs: 5,
        production: &[ParseType::T(13)],
    },
    // 20 - expression: SimpleExpression expressionSuffix;
    Production {
        lhs: 46,
        production: &[ParseType::N(47), ParseType::N(33)],
    },
    // 21 - expressionSuffix: RelationOp SimpleExpression;
    Production {
        lhs: 47,
        production: &[ParseType::N(33), ParseType::N(30)],
    },
    // 22 - expressionSuffix: ;
    Production {
        lhs: 47,
        production: &[],
    },
    // 23 - assignment: ident selector AssignOp expression;
    Production {
        lhs: 40,
        production: &[
            ParseType::N(46),
            ParseType::N(5),
            ParseType::N(54),
            ParseType::N(50),
        ],
    },
    // 24 - ActualParameters: "\(" ActualParametersSuffix;
    Production {
        lhs: 0,
        production: &[ParseType::N(1), ParseType::T(8)],
    },
    // 25 - ActualParametersSuffix: "\)";
    Production {
        lhs: 1,
        production: &[ParseType::T(9)],
    },
    // 26 - ActualParametersSuffix: expression expressionlistrest "\)";
    Production {
        lhs: 1,
        production: &[ParseType::T(9), ParseType::N(48), ParseType::N(46)],
    },
    // 27 - expressionlistrest: "," expression expressionlistrest;
    Production {
        lhs: 48,
        production: &[ParseType::N(48), ParseType::N(46), ParseType::T(14)],
    },
    // 28 - expressionlistrest: ;
    Production {
        lhs: 48,
        production: &[],
    },
    // 29 - ProcedureCall: ident ProcedureCallSuffix;
    Production {
        lhs: 23,
        production: &[ParseType::N(24), ParseType::N(50)],
    },
    // 30 - ProcedureCallSuffix: ActualParameters;
    Production {
        lhs: 24,
        production: &[ParseType::N(0)],
    },
    // 31 - ProcedureCallSuffix: ;
    Production {
        lhs: 24,
        production: &[],
    },
    // 32 - IfStatement: IfPrefix IfStatementSuffix;
    Production {
        lhs: 16,
        production: &[ParseType::N(17), ParseType::N(15)],
    },
    // 33 - IfStatementSuffix: "ELSE" StatementSequence "END";
    Production {
        lhs: 17,
        production: &[ParseType::T(16), ParseType::N(34), ParseType::T(15)],
    },
    // 34 - IfStatementSuffix: "END";
    Production {
        lhs: 17,
        production: &[ParseType::T(16)],
    },
    // 35 - IfPrefix: "IF" expression "THEN" StatementSequence elseiflist;
    Production {
        lhs: 15,
        production: &[
            ParseType::N(45),
            ParseType::N(34),
            ParseType::T(18),
            ParseType::N(46),
            ParseType::T(17),
        ],
    },
    // 36 - elseiflist: "ELSIF" expression "THEN" StatementSequence elseiflist;
    Production {
        lhs: 45,
        production: &[
            ParseType::N(45),
            ParseType::N(34),
            ParseType::T(18),
            ParseType::N(46),
            ParseType::T(19),
        ],
    },
    // 37 - elseiflist: ;
    Production {
        lhs: 45,
        production: &[],
    },
    // 38 - WhileStatement: "WHILE" expression "DO" StatementSequence "END";
    Production {
        lhs: 39,
        production: &[
            ParseType::T(16),
            ParseType::N(34),
            ParseType::T(21),
            ParseType::N(46),
            ParseType::T(20),
        ],
    },
    // 39 - RepeatStatement: "REPEAT" StatementSequence "UNTIL" expression;
    Production {
        lhs: 32,
        production: &[
            ParseType::N(46),
            ParseType::T(23),
            ParseType::N(34),
            ParseType::T(22),
        ],
    },
    // 40 - statement: assignment;
    Production {
        lhs: 56,
        production: &[ParseType::N(40)],
    },
    // 41 - statement: ProcedureCall;
    Production {
        lhs: 56,
        production: &[ParseType::N(23)],
    },
    // 42 - statement: IfStatement;
    Production {
        lhs: 56,
        production: &[ParseType::N(16)],
    },
    // 43 - statement: WhileStatement;
    Production {
        lhs: 56,
        production: &[ParseType::N(39)],
    },
    // 44 - statement: RepeatStatement;
    Production {
        lhs: 56,
        production: &[ParseType::N(32)],
    },
    // 45 - statement: ;
    Production {
        lhs: 56,
        production: &[],
    },
    // 46 - StatementSequence: statement StatementSequenceRest;
    Production {
        lhs: 34,
        production: &[ParseType::N(35), ParseType::N(56)],
    },
    // 47 - StatementSequenceRest: ";" statement StatementSequenceRest;
    Production {
        lhs: 35,
        production: &[ParseType::N(35), ParseType::N(56), ParseType::T(24)],
    },
    // 48 - StatementSequenceRest: ;
    Production {
        lhs: 35,
        production: &[],
    },
    // 49 - IdentList: ident IdentListRest;
    Production {
        lhs: 13,
        production: &[ParseType::N(14), ParseType::N(50)],
    },
    // 50 - IdentListRest: "," ident IdentListRest;
    Production {
        lhs: 14,
        production: &[ParseType::N(14), ParseType::N(50), ParseType::T(14)],
    },
    // 51 - IdentListRest: ;
    Production {
        lhs: 14,
        production: &[],
    },
    // 52 - ArrayType: "ARRAY" expression "OF" type;
    Production {
        lhs: 4,
        production: &[
            ParseType::N(58),
            ParseType::T(26),
            ParseType::N(46),
            ParseType::T(25),
        ],
    },
    // 53 - FieldList: IdentList ":" type;
    Production {
        lhs: 9,
        production: &[ParseType::N(58), ParseType::T(27), ParseType::N(13)],
    },
    // 54 - FieldList: ;
    Production {
        lhs: 9,
        production: &[],
    },
    // 55 - RecordType: "RECORD" FieldList FieldListRest "END";
    Production {
        lhs: 29,
        production: &[
            ParseType::T(16),
            ParseType::N(10),
            ParseType::N(9),
            ParseType::T(28),
        ],
    },
    // 56 - FieldListRest: ";" FieldList FieldListRest;
    Production {
        lhs: 10,
        production: &[ParseType::N(10), ParseType::N(9), ParseType::T(24)],
    },
    // 57 - FieldListRest: ;
    Production {
        lhs: 10,
        production: &[],
    },
    // 58 - type: ident;
    Production {
        lhs: 58,
        production: &[ParseType::N(50)],
    },
    // 59 - type: ArrayType;
    Production {
        lhs: 58,
        production: &[ParseType::N(4)],
    },
    // 60 - type: RecordType;
    Production {
        lhs: 58,
        production: &[ParseType::N(29)],
    },
    // 61 - FPSection: "VAR" IdentList ":" type;
    Production {
        lhs: 7,
        production: &[
            ParseType::N(58),
            ParseType::T(27),
            ParseType::N(13),
            ParseType::T(29),
        ],
    },
    // 62 - FPSection: IdentList ":" type;
    Production {
        lhs: 7,
        production: &[ParseType::N(58), ParseType::T(27), ParseType::N(13)],
    },
    // 63 - FormalParameters: "\(" FormalParametersSuffix;
    Production {
        lhs: 11,
        production: &[ParseType::N(12), ParseType::T(8)],
    },
    // 64 - FormalParametersSuffix: "\)";
    Production {
        lhs: 12,
        production: &[ParseType::T(9)],
    },
    // 65 - FormalParametersSuffix: FPSection FPSectionRest "\)";
    Production {
        lhs: 12,
        production: &[ParseType::T(9), ParseType::N(8), ParseType::N(7)],
    },
    // 66 - FPSectionRest: ";" FPSection FPSectionRest;
    Production {
        lhs: 8,
        production: &[ParseType::N(8), ParseType::N(7), ParseType::T(24)],
    },
    // 67 - FPSectionRest: ;
    Production {
        lhs: 8,
        production: &[],
    },
    // 68 - ProcedureHeading: "PROCEDURE" ident ProcedureHeadingSuffix;
    Production {
        lhs: 27,
        production: &[ParseType::N(28), ParseType::N(50), ParseType::T(30)],
    },
    // 69 - ProcedureHeadingSuffix: FormalParameters;
    Production {
        lhs: 28,
        production: &[ParseType::N(11)],
    },
    // 70 - ProcedureHeadingSuffix: ;
    Production {
        lhs: 28,
        production: &[],
    },
    // 71 - ProcedureBody: declarations ProcedureBodySuffix1;
    Production {
        lhs: 20,
        production: &[ParseType::N(22), ParseType::N(41)],
    },
    // 72 - ProcedureBodySuffix1: "BEGIN" StatementSequence ProcedureBodySuffix;
    Production {
        lhs: 22,
        production: &[ParseType::N(21), ParseType::N(34), ParseType::T(31)],
    },
    // 73 - ProcedureBodySuffix1: "RETURN" expression "END" ident;
    Production {
        lhs: 22,
        production: &[
            ParseType::N(50),
            ParseType::T(16),
            ParseType::N(46),
            ParseType::T(32),
        ],
    },
    // 74 - ProcedureBodySuffix1: "END" ident;
    Production {
        lhs: 22,
        production: &[ParseType::N(50), ParseType::T(16)],
    },
    // 75 - ProcedureBodySuffix: "RETURN" expression "END" ident;
    Production {
        lhs: 21,
        production: &[
            ParseType::N(50),
            ParseType::T(16),
            ParseType::N(46),
            ParseType::T(32),
        ],
    },
    // 76 - ProcedureBodySuffix: "END" ident;
    Production {
        lhs: 21,
        production: &[ParseType::N(50), ParseType::T(16)],
    },
    // 77 - ProcedureDeclaration: ProcedureHeading ";" ProcedureBody;
    Production {
        lhs: 25,
        production: &[ParseType::N(20), ParseType::T(24), ParseType::N(27)],
    },
    // 78 - declarations: "TYPE" TypeDecls declarationsSuffix2;
    Production {
        lhs: 41,
        production: &[ParseType::N(44), ParseType::N(36), ParseType::T(33)],
    },
    // 79 - declarations: "CONST" ConstDecls declarationsSuffix1;
    Production {
        lhs: 41,
        production: &[ParseType::N(43), ParseType::N(6), ParseType::T(34)],
    },
    // 80 - declarationsSuffix2: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 44,
        production: &[ParseType::N(26), ParseType::N(38), ParseType::T(29)],
    },
    // 81 - declarationsSuffix2: ProcedureDeclarationList;
    Production {
        lhs: 44,
        production: &[ParseType::N(26)],
    },
    // 82 - declarations: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 41,
        production: &[ParseType::N(26), ParseType::N(38), ParseType::T(29)],
    },
    // 83 - declarations: ProcedureDeclarationList;
    Production {
        lhs: 41,
        production: &[ParseType::N(26)],
    },
    // 84 - declarationsSuffix1: "TYPE" TypeDecls declarationsSuffix;
    Production {
        lhs: 43,
        production: &[ParseType::N(42), ParseType::N(36), ParseType::T(33)],
    },
    // 85 - declarationsSuffix1: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 43,
        production: &[ParseType::N(26), ParseType::N(38), ParseType::T(29)],
    },
    // 86 - declarationsSuffix1: ProcedureDeclarationList;
    Production {
        lhs: 43,
        production: &[ParseType::N(26)],
    },
    // 87 - declarationsSuffix: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 42,
        production: &[ParseType::N(26), ParseType::N(38), ParseType::T(29)],
    },
    // 88 - declarationsSuffix: ProcedureDeclarationList;
    Production {
        lhs: 42,
        production: &[ParseType::N(26)],
    },
    // 89 - ProcedureDeclarationList: ProcedureDeclaration ";" ProcedureDeclarationList;
    Production {
        lhs: 26,
        production: &[ParseType::N(26), ParseType::T(24), ParseType::N(25)],
    },
    // 90 - ProcedureDeclarationList: ;
    Production {
        lhs: 26,
        production: &[],
    },
    // 91 - ConstDecls: ident AssignOp expression ";" ConstDecls;
    Production {
        lhs: 6,
        production: &[
            ParseType::N(6),
            ParseType::T(24),
            ParseType::N(46),
            ParseType::N(5),
            ParseType::N(50),
        ],
    },
    // 92 - ConstDecls: ;
    Production {
        lhs: 6,
        production: &[],
    },
    // 93 - TypeDecls: ident AssignOp type ";" TypeDecls;
    Production {
        lhs: 36,
        production: &[
            ParseType::N(36),
            ParseType::T(24),
            ParseType::N(58),
            ParseType::N(5),
            ParseType::N(50),
        ],
    },
    // 94 - TypeDecls: ;
    Production {
        lhs: 36,
        production: &[],
    },
    // 95 - VarDecls: IdentList ":" type ";" VarDecls;
    Production {
        lhs: 38,
        production: &[
            ParseType::N(38),
            ParseType::T(24),
            ParseType::N(58),
            ParseType::T(27),
            ParseType::N(13),
        ],
    },
    // 96 - VarDecls: ;
    Production {
        lhs: 38,
        production: &[],
    },
    // 97 - module: "MODULE" ident ";" declarations moduleSuffix;
    Production {
        lhs: 52,
        production: &[
            ParseType::N(53),
            ParseType::N(41),
            ParseType::T(24),
            ParseType::N(50),
            ParseType::T(35),
        ],
    },
    // 98 - moduleSuffix: "BEGIN" StatementSequence "END" ident "\.";
    Production {
        lhs: 53,
        production: &[
            ParseType::T(5),
            ParseType::N(50),
            ParseType::T(16),
            ParseType::N(34),
            ParseType::T(31),
        ],
    },
    // 99 - moduleSuffix: "END" ident "\.";
    Production {
        lhs: 53,
        production: &[ParseType::T(5), ParseType::N(50), ParseType::T(16)],
    },
    // 100 - MulOperator: "\*|/|DIV|MOD|&";
    Production {
        lhs: 19,
        production: &[ParseType::T(36)],
    },
    // 101 - AddOperator: "\+|-|OR";
    Production {
        lhs: 3,
        production: &[ParseType::T(37)],
    },
    // 102 - UnaryOp: "\+|-";
    Production {
        lhs: 37,
        production: &[ParseType::T(38)],
    },
    // 103 - ident: "[a-zA-Z][a-zA-Z0-9]*";
    Production {
        lhs: 50,
        production: &[ParseType::T(39)],
    },
    // 104 - integer: "[0-9]+";
    Production {
        lhs: 51,
        production: &[ParseType::T(40)],
    },
];

lazy_static! {
    static ref TOKENIZERS: Vec<(&'static str, Tokenizer)> = vec![(
        "INITIAL",
        Tokenizer::build(TERMINALS, SCANNER_0.0, SCANNER_0.1).unwrap()
    ),];
}

pub fn parse<'t, T>(
    input: &'t str,
    file_name: T,
    user_actions: &mut dyn UserActionsTrait<'t>,
) -> Result<Tree<ParseTreeType<'t>>>
where
    T: AsRef<Path>,
{
    let mut llk_parser = LLKParser::new(
        52,
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream =
        RefCell::new(TokenStream::new(input, file_name, &TOKENIZERS, MAX_K).unwrap());
    let result = llk_parser.parse(token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
