// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
{{#auto_generate?}}use parol_runtime::lexer::Token;{{/auto_generate}}
use parol_runtime::parser::{ParseTreeStackEntry, ParseTreeType, UserActionsTrait};
{{#auto_generate?}}use log::trace;
{{/auto_generate}}use miette::{miette, {{#auto_generate?}}IntoDiagnostic, {{/auto_generate}}Result};
{{#auto_generate?}}#[allow(unused_imports)]{{/auto_generate}}
use crate::{{module_name}}::{{user_type_name}};
{{#auto_generate?}}use std::path::{Path, PathBuf};{{/auto_generate}}{{^auto_generate?}}use std::path::Path;{{/auto_generate}}

{{#auto_generate?}}
/// Semantic actions trait generated for the user grammar
/// All functions have default implementations.
pub trait {{user_type_name}}Trait<'t> {
    fn init(&mut self, _file_name: &Path) {}

    {{{user_trait_functions}}}
}

// -------------------------------------------------------------------------------------------------
//
// Output Types of productions deduced from the structure of the transformed grammar
//

{{{production_output_types}}}

// -------------------------------------------------------------------------------------------------
//
// Types of non-terminals deduced from the structure of the transformed grammar
//

{{{non_terminal_types}}}


// -------------------------------------------------------------------------------------------------

{{{ast_type_decl}}}

/// Auto-implemented adapter grammar
///
/// The lifetime parameter `'t` refers to the lifetime of the scanned text.
/// The lifetime parameter `'u` refers to the lifetime of user grammar object.
///
#[allow(dead_code)]
pub struct {{{user_type_name}}}Auto<'t, 'u> where 't: 'u {
    // Mutable reference of the actual user grammar to be able to call the semantic actions on it
    user_grammar: &'u mut dyn {{user_type_name}}Trait<'t>,
    // Stack to construct the AST on it
    item_stack: Vec<ASTType<'t>>,
    // Path of the input file. Used for diagnostics.
    file_name: PathBuf,
}
{{/auto_generate}}

{{#auto_generate?}}
///
/// The `{{{user_type_name}}}Auto` impl is automatically generated for the
/// given grammar.
///
impl<'t, 'u> {{{user_type_name}}}Auto<'t, 'u> {
    pub fn new(user_grammar: &'u mut dyn {{user_type_name}}Trait<'t>) -> Self {
        Self {
            user_grammar,
            item_stack: Vec::new(),
            file_name: PathBuf::default(),
        }
    }

    #[allow(dead_code)]
    fn push(&mut self, item: ASTType<'t>, context: &str) {
        trace!("push    {}: {:?}", context, item);
        self.item_stack.push(item)
    }

    #[allow(dead_code)]
    fn pop(&mut self, context: &str) -> Option<ASTType<'t>> {
        if !self.item_stack.is_empty() {
            let item = self.item_stack.pop();
            if let Some(ref item) = item {
                trace!("pop     {}: {:?}", context, item);
            }
            item
        } else {
            None
        }
    }

    #[allow(dead_code)]
    // Use this function for debugging purposes:
    // trace!("{}", self.trace_item_stack(context));
    fn trace_item_stack(&self, context: &str) -> std::string::String {
        format!(
            "Item stack at {}:\n{}",
            context,
            self.item_stack
                .iter()
                .rev()
                .map(|s| format!("  {:?}", s))
                .collect::<Vec<std::string::String>>()
                .join("\n")
        )
    }

{{/auto_generate}}
{{^auto_generate?}}
///
/// The `{{{user_type_name}}}Trait` trait is automatically generated for the
/// given grammar.
/// All functions have default implementations.
///
pub trait {{{user_type_name}}}Trait {
    ///
    /// Implement this method if you need the provided information
    ///
    fn init(&mut self, _file_name: &Path) {
    }
{{/auto_generate}}

    {{{trait_functions}}}
}

{{#auto_generate?}}impl<'t> UserActionsTrait<'t> for {{{user_type_name}}}Auto<'t, '_> { {{/auto_generate}}
{{^auto_generate?}}impl UserActionsTrait<'_> for {{{user_type_name}}} { {{/auto_generate}}
    ///
    /// Initialize the user with additional information.
    /// This function is called by the parser before parsing starts.
    /// Is is used to transport necessary data from parser to user.
    ///
    fn init(&mut self, {{^auto_generate?}}_{{/auto_generate}}file_name: &Path) {
{{#auto_generate?}}
        self.file_name = file_name.to_owned();
        self.user_grammar.init(file_name);
{{/auto_generate}}
    }

    ///
    /// This function is implemented automatically for the user's item {{{user_type_name}}}.
    ///
    fn call_semantic_action_for_production_number(
        &mut self,
        prod_num: usize,
        children: &[ParseTreeStackEntry{{#auto_generate?}}<'t>{{/auto_generate}}],
        parse_tree: &Tree<ParseTreeType{{#auto_generate?}}<'t>{{/auto_generate}}>) -> Result<()> {
        match prod_num {
{{{trait_caller}}}            _ => Err(miette!("Unhandled production number: {}", prod_num)),
        }
    }
}
