// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use miette::Result;
use parol_runtime::lexer::{TokenStream, Tokenizer};
use parol_runtime::parser::{
    DFATransition, LLKParser, LookaheadDFA, ParseTreeType, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;
use std::path::Path;

use parol_runtime::lexer::tokenizer::{
    ERROR_TOKEN, NEW_LINE_TOKEN, UNMATCHABLE_TOKEN, WHITESPACE_TOKEN,
};

pub const TERMINALS: &[&str; 8] = &[
    /* 0 */ UNMATCHABLE_TOKEN,
    /* 1 */ UNMATCHABLE_TOKEN,
    /* 2 */ UNMATCHABLE_TOKEN,
    /* 3 */ UNMATCHABLE_TOKEN,
    /* 4 */ UNMATCHABLE_TOKEN,
    /* 5 */ r###","###,
    /* 6 */ r###"0|[1-9][0-9]*"###,
    /* 7 */ ERROR_TOKEN,
];

pub const TERMINAL_NAMES: &[&str; 8] = &[
    /* 0 */ "EndOfInput",
    /* 1 */ "Newline",
    /* 2 */ "Whitespace",
    /* 3 */ "LineComment",
    /* 4 */ "BlockComment",
    /* 5 */ "Comma",
    /* 6 */ "Num",
    /* 7 */ "Error",
];

/* SCANNER_0: "INITIAL" */
const SCANNER_0: (&[&str; 5], &[usize; 2]) = (
    &[
        /* 0 */ UNMATCHABLE_TOKEN,
        /* 1 */ NEW_LINE_TOKEN,
        /* 2 */ WHITESPACE_TOKEN,
        /* 3 */ UNMATCHABLE_TOKEN,
        /* 4 */ UNMATCHABLE_TOKEN,
    ],
    &[5 /* Comma */, 6 /* Num */],
);

const MAX_K: usize = 2;

pub const NON_TERMINALS: &[&str; 4] = &[
    /* 0 */ "List",
    /* 1 */ "ListRest",
    /* 2 */ "ListSuffix",
    /* 3 */ "Num",
];

pub const LOOKAHEAD_AUTOMATA: &[LookaheadDFA; 4] = &[
    /* 0 - "List" */
    LookaheadDFA {
        states: &[None, Some(0), Some(3)],
        transitions: &[DFATransition(0, 0, 2), DFATransition(0, 6, 1)],
        k: 1,
    },
    /* 1 - "ListRest" */
    LookaheadDFA {
        states: &[None, None, Some(4), Some(5)],
        transitions: &[
            DFATransition(0, 0, 3),
            DFATransition(0, 5, 1),
            DFATransition(1, 0, 3),
            DFATransition(1, 6, 2),
        ],
        k: 2,
    },
    /* 2 - "ListSuffix" */
    LookaheadDFA {
        states: &[None, Some(1), Some(2)],
        transitions: &[DFATransition(0, 0, 2), DFATransition(0, 5, 1)],
        k: 1,
    },
    /* 3 - "Num" */
    LookaheadDFA {
        states: &[Some(6)],
        transitions: &[],
        k: 0,
    },
];

pub const PRODUCTIONS: &[Production; 7] = &[
    // 0 - List: Num ListRest ListSuffix;
    Production {
        lhs: 0,
        production: &[ParseType::N(2), ParseType::N(1), ParseType::N(3)],
    },
    // 1 - ListSuffix: ",";
    Production {
        lhs: 2,
        production: &[ParseType::T(5)],
    },
    // 2 - ListSuffix: ;
    Production {
        lhs: 2,
        production: &[],
    },
    // 3 - List: ;
    Production {
        lhs: 0,
        production: &[],
    },
    // 4 - ListRest: "," Num ListRest;
    Production {
        lhs: 1,
        production: &[ParseType::N(1), ParseType::N(3), ParseType::T(5)],
    },
    // 5 - ListRest: ;
    Production {
        lhs: 1,
        production: &[],
    },
    // 6 - Num: "0|[1-9][0-9]*";
    Production {
        lhs: 3,
        production: &[ParseType::T(6)],
    },
];

lazy_static! {
    static ref TOKENIZERS: Vec<(&'static str, Tokenizer)> = vec![(
        "INITIAL",
        Tokenizer::build(TERMINALS, SCANNER_0.0, SCANNER_0.1).unwrap()
    ),];
}

pub fn parse<'t, T>(
    input: &'t str,
    file_name: T,
    user_actions: &mut dyn UserActionsTrait,
) -> Result<Tree<ParseTreeType<'t>>>
where
    T: AsRef<Path>,
{
    let mut llk_parser = LLKParser::new(
        0,
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream =
        RefCell::new(TokenStream::new(input, file_name, &TOKENIZERS, MAX_K).unwrap());
    let result = llk_parser.parse(token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
