# Contributing to `parol`

👋 Welcome and thanks for taking the time to contribute! 👋

Feedback is always appreciated. Please, use the [Discussions](https://github.com/jsinger67/parol/discussions)
of the project when you have questions or suggestions.

When you find any open issue that is not assigned to someone yet and you feel yourself able the
solve it, please open a Pull Request on it.

Any other Pull Requests are welcome too but please submit an issue on it with your intended changes
before submitting a PR.

You can also submit Issues if you have found bugs or want to propose new features or enhancements, even
if you aren't able to fix it. Someone else will probably do it.

If you do submit a Pull Request please do the following:

- Include documentation for your changes where appropriate (public methods must be documented,
while documentation is appreciated but not required for private methods)
- Include tests for your changes wherever appropriate.  In particular, try to "prove" (if
possible) that your changes do what they are supposed to.  Also, show that the proper error
messages are being returned when necessary.
- Make sure you run `cargo fmt` (found [here](https://github.com/rust-lang-nursery/rustfmt))
on your changes.
- Also run `cargo clippy` (found [here](https://github.com/Manishearth/rust-clippy/))
on your changes and fix all warnings if possible.
- It would be nice if you do a spell check. It is not required but encouraged.
- Don't forget to add yourself to the to the list of Contributors in the README! This is also
not required, but it is very much encouraged!
