// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use parol_runtime::lexer::{TokenStream, Tokenizer};
use anyhow::Result;
use parol_runtime::parser::{
    ParseTreeType, DFATransition, LLKParser, LookaheadDFA, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;

{{{lexer_source}}}

const MAX_K: usize = {{max_k}};

pub const NON_TERMINALS: &[&str; {{non_terminal_count}}] = &[
{{{non_terminals}}}];

{{{dfa_source}}}
{{{productions}}}
lazy_static! {
    static ref TOKENIZERS: Vec<(&'static str, Tokenizer)> = vec![
        ("INITIAL", Tokenizer::build(TERMINALS, SCANNER_0.0, SCANNER_0.1).unwrap()),
{{{scanner_builds}}}
    ];
}

pub fn parse<'t>(
    input: &'t str,
    file_name: String,
    user_actions: &mut dyn UserActionsTrait,
) -> Result<Tree<ParseTreeType<'t>>> {
    let mut llk_parser = LLKParser::new(
        {{start_symbol_index}},
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream = RefCell::new(
        TokenStream::new(input, file_name, &TOKENIZERS, MAX_K).unwrap(),
    );
    let result = llk_parser.parse(token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
