// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use parol_runtime::lexer::{TokenStream, Tokenizer};
use anyhow::Result;
use parol_runtime::parser::{
    ParseTreeType, DFATransition, LLKParser, LookaheadDFA, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;

use parol_runtime::lexer::tokenizer::{
    ERROR_TOKEN, NEW_LINE_TOKEN, UNMATCHABLE_TOKEN, WHITESPACE_TOKEN,
};

pub const TERMINALS: &[&str; 23] = &[
    /*  0 */ UNMATCHABLE_TOKEN,
    /*  1 */ NEW_LINE_TOKEN,
    /*  2 */ WHITESPACE_TOKEN,
    /*  3 */ r###"//.*"###,
    /*  4 */ r###"(?ms)/\*.*?\*/"###,
    /*  5 */ r###"%title"###,
    /*  6 */ r###"%comment"###,
    /*  7 */ r###"%start"###,
    /*  8 */ r###"%line_comment"###,
    /*  9 */ r###"%block_comment"###,
    /* 10 */ r###"%%"###,
    /* 11 */ r###":"###,
    /* 12 */ r###";"###,
    /* 13 */ r###"\|"###,
    /* 14 */ r###"\("###,
    /* 15 */ r###"\)"###,
    /* 16 */ r###"\["###,
    /* 17 */ r###"\]"###,
    /* 18 */ r###"\{"###,
    /* 19 */ r###"\}"###,
    /* 20 */ r###"[a-zA-Z_]\w*"###,
    /* 21 */ r###"\u{0022}([^\\]|\\.)*?\u{0022}"###,
    /* 22 */ ERROR_TOKEN,
];

pub const TERMINAL_NAMES: &[&str; 23] = &[
    /*  0 */ "EndOfInput",
    /*  1 */ "Newline",
    /*  2 */ "Whitespace",
    /*  3 */ "LineComment",
    /*  4 */ "BlockComment",
    /*  5 */ "PercentTitle",
    /*  6 */ "PercentComment",
    /*  7 */ "PercentStart",
    /*  8 */ "PercentLineUnderscoreComment",
    /*  9 */ "PercentBlockUnderscoreComment",
    /* 10 */ "PercentPercent",
    /* 11 */ "Colon",
    /* 12 */ "Semicolon",
    /* 13 */ "EscOr",
    /* 14 */ "EscLParen",
    /* 15 */ "EscRParen",
    /* 16 */ "EscLBracket",
    /* 17 */ "EscRBracket",
    /* 18 */ "EscLBrace",
    /* 19 */ "EscRBrace",
    /* 20 */ "Identifier",
    /* 21 */ "String",
    /* 22 */ "Error",
];

const MAX_K: usize = 1;

pub const NON_TERMINALS: &[&str; 17] = &[
    /*  0 */ "Alternation",
    /*  1 */ "Alternations",
    /*  2 */ "AlternationsRest",
    /*  3 */ "Declaration",
    /*  4 */ "Factor",
    /*  5 */ "Grammar",
    /*  6 */ "GrammarDefinition",
    /*  7 */ "Group",
    /*  8 */ "Identifier",
    /*  9 */ "Optional",
    /* 10 */ "Production",
    /* 11 */ "Productions",
    /* 12 */ "Prolog",
    /* 13 */ "PrologRest",
    /* 14 */ "Repeat",
    /* 15 */ "String",
    /* 16 */ "Symbol",
];

pub const LOOKAHEAD_AUTOMATA: &[LookaheadDFA; 17] = &[
    /* 0 - "Alternation" */
    LookaheadDFA {
        states: &[None, Some(16), Some(17)],
        transitions: &[
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 2),
            DFATransition(0, 14, 1),
            DFATransition(0, 15, 2),
            DFATransition(0, 16, 1),
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 1),
            DFATransition(0, 19, 2),
            DFATransition(0, 20, 1),
            DFATransition(0, 21, 1),
        ],
        k: 1,
    },
    /* 1 - "Alternations" */
    LookaheadDFA {
        states: &[Some(13)],
        transitions: &[],
        k: 0,
    },
    /* 2 - "AlternationsRest" */
    LookaheadDFA {
        states: &[None, Some(14), Some(15)],
        transitions: &[
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 1),
            DFATransition(0, 15, 2),
            DFATransition(0, 17, 2),
            DFATransition(0, 19, 2),
        ],
        k: 1,
    },
    /* 3 - "Declaration" */
    LookaheadDFA {
        states: &[None, Some(2), Some(3), Some(4), Some(5), Some(6)],
        transitions: &[
            DFATransition(0, 5, 1),
            DFATransition(0, 6, 2),
            DFATransition(0, 7, 3),
            DFATransition(0, 8, 4),
            DFATransition(0, 9, 5),
        ],
        k: 1,
    },
    /* 4 - "Factor" */
    LookaheadDFA {
        states: &[None, Some(18), Some(19), Some(20), Some(21)],
        transitions: &[
            DFATransition(0, 14, 1),
            DFATransition(0, 16, 3),
            DFATransition(0, 18, 2),
            DFATransition(0, 20, 4),
            DFATransition(0, 21, 4),
        ],
        k: 1,
    },
    /* 5 - "Grammar" */
    LookaheadDFA {
        states: &[Some(0)],
        transitions: &[],
        k: 0,
    },
    /* 6 - "GrammarDefinition" */
    LookaheadDFA {
        states: &[Some(9)],
        transitions: &[],
        k: 0,
    },
    /* 7 - "Group" */
    LookaheadDFA {
        states: &[Some(24)],
        transitions: &[],
        k: 0,
    },
    /* 8 - "Identifier" */
    LookaheadDFA {
        states: &[Some(27)],
        transitions: &[],
        k: 0,
    },
    /* 9 - "Optional" */
    LookaheadDFA {
        states: &[Some(25)],
        transitions: &[],
        k: 0,
    },
    /* 10 - "Production" */
    LookaheadDFA {
        states: &[Some(12)],
        transitions: &[],
        k: 0,
    },
    /* 11 - "Productions" */
    LookaheadDFA {
        states: &[None, Some(10), Some(11)],
        transitions: &[DFATransition(0, 0, 2), DFATransition(0, 20, 1)],
        k: 1,
    },
    /* 12 - "Prolog" */
    LookaheadDFA {
        states: &[Some(1)],
        transitions: &[],
        k: 0,
    },
    /* 13 - "PrologRest" */
    LookaheadDFA {
        states: &[None, Some(7), Some(8)],
        transitions: &[
            DFATransition(0, 5, 1),
            DFATransition(0, 6, 1),
            DFATransition(0, 7, 1),
            DFATransition(0, 8, 1),
            DFATransition(0, 9, 1),
            DFATransition(0, 10, 2),
        ],
        k: 1,
    },
    /* 14 - "Repeat" */
    LookaheadDFA {
        states: &[Some(26)],
        transitions: &[],
        k: 0,
    },
    /* 15 - "String" */
    LookaheadDFA {
        states: &[Some(28)],
        transitions: &[],
        k: 0,
    },
    /* 16 - "Symbol" */
    LookaheadDFA {
        states: &[None, Some(22), Some(23)],
        transitions: &[DFATransition(0, 20, 1), DFATransition(0, 21, 2)],
        k: 1,
    },
];

pub const PRODUCTIONS: &[Production; 29] = &[
    // 0 - Grammar: Prolog GrammarDefinition;
    Production {
        lhs: 5,
        production: &[ParseType::N(6), ParseType::N(12)],
    },
    // 1 - Prolog: Declaration PrologRest;
    Production {
        lhs: 12,
        production: &[ParseType::N(13), ParseType::N(3)],
    },
    // 2 - Declaration: "%title" String;
    Production {
        lhs: 3,
        production: &[ParseType::N(15), ParseType::T(5)],
    },
    // 3 - Declaration: "%comment" String;
    Production {
        lhs: 3,
        production: &[ParseType::N(15), ParseType::T(6)],
    },
    // 4 - Declaration: "%start" Identifier;
    Production {
        lhs: 3,
        production: &[ParseType::N(8), ParseType::T(7)],
    },
    // 5 - Declaration: "%line_comment" String;
    Production {
        lhs: 3,
        production: &[ParseType::N(15), ParseType::T(8)],
    },
    // 6 - Declaration: "%block_comment" String String;
    Production {
        lhs: 3,
        production: &[ParseType::N(15), ParseType::N(15), ParseType::T(9)],
    },
    // 7 - PrologRest: Prolog;
    Production {
        lhs: 13,
        production: &[ParseType::N(12)],
    },
    // 8 - PrologRest: ;
    Production {
        lhs: 13,
        production: &[],
    },
    // 9 - GrammarDefinition: "%%" Production Productions;
    Production {
        lhs: 6,
        production: &[ParseType::N(11), ParseType::N(10), ParseType::T(10)],
    },
    // 10 - Productions: Production Productions;
    Production {
        lhs: 11,
        production: &[ParseType::N(11), ParseType::N(10)],
    },
    // 11 - Productions: ;
    Production {
        lhs: 11,
        production: &[],
    },
    // 12 - Production: Identifier ":" Alternations ";";
    Production {
        lhs: 10,
        production: &[
            ParseType::T(12),
            ParseType::N(1),
            ParseType::T(11),
            ParseType::N(8),
        ],
    },
    // 13 - Alternations: Alternation AlternationsRest;
    Production {
        lhs: 1,
        production: &[ParseType::N(2), ParseType::N(0)],
    },
    // 14 - AlternationsRest: "\|" Alternation AlternationsRest;
    Production {
        lhs: 2,
        production: &[ParseType::N(2), ParseType::N(0), ParseType::T(13)],
    },
    // 15 - AlternationsRest: ;
    Production {
        lhs: 2,
        production: &[],
    },
    // 16 - Alternation: Factor Alternation;
    Production {
        lhs: 0,
        production: &[ParseType::N(0), ParseType::N(4)],
    },
    // 17 - Alternation: ;
    Production {
        lhs: 0,
        production: &[],
    },
    // 18 - Factor: Group;
    Production {
        lhs: 4,
        production: &[ParseType::N(7)],
    },
    // 19 - Factor: Repeat;
    Production {
        lhs: 4,
        production: &[ParseType::N(14)],
    },
    // 20 - Factor: Optional;
    Production {
        lhs: 4,
        production: &[ParseType::N(9)],
    },
    // 21 - Factor: Symbol;
    Production {
        lhs: 4,
        production: &[ParseType::N(16)],
    },
    // 22 - Symbol: Identifier;
    Production {
        lhs: 16,
        production: &[ParseType::N(8)],
    },
    // 23 - Symbol: String;
    Production {
        lhs: 16,
        production: &[ParseType::N(15)],
    },
    // 24 - Group: "\(" Alternations "\)";
    Production {
        lhs: 7,
        production: &[ParseType::T(15), ParseType::N(1), ParseType::T(14)],
    },
    // 25 - Optional: "\[" Alternations "\]";
    Production {
        lhs: 9,
        production: &[ParseType::T(17), ParseType::N(1), ParseType::T(16)],
    },
    // 26 - Repeat: "\{" Alternations "\}";
    Production {
        lhs: 14,
        production: &[ParseType::T(19), ParseType::N(1), ParseType::T(18)],
    },
    // 27 - Identifier: "[a-zA-Z_]\w*";
    Production {
        lhs: 8,
        production: &[ParseType::T(20)],
    },
    // 28 - String: "\u{0022}([^\\]|\\.)*?\u{0022}";
    Production {
        lhs: 15,
        production: &[ParseType::T(21)],
    },
];

lazy_static! {
    static ref TOKENIZER: Tokenizer = Tokenizer::build(TERMINALS).unwrap();
}

pub fn parse(
    input: &str,
    file_name: String,
    user_actions: &mut dyn UserActionsTrait,
) -> Result<Tree<ParseTreeType>> {
    let mut llk_parser = LLKParser::new(
        5,
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream = RefCell::new(TokenStream::new(input, file_name, &TOKENIZER, MAX_K).unwrap());
    let result = llk_parser.parse(&token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
