// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use parol_runtime::errors::*;
use parol_runtime::lexer::{TokenStream, Tokenizer};
use parol_runtime::parser::{
    DFATransition, LLKParser, LookaheadDFA, ParseTreeType, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;

use parol_runtime::lexer::tokenizer::{
    ERROR_TOKEN, NEW_LINE_TOKEN, UNMATCHABLE_TOKEN, WHITESPACE_TOKEN,
};

pub const TERMINALS: &[&str; 18] = &[
    /*  0 */ UNMATCHABLE_TOKEN,
    /*  1 */ UNMATCHABLE_TOKEN,
    /*  2 */ UNMATCHABLE_TOKEN,
    /*  3 */ UNMATCHABLE_TOKEN,
    /*  4 */ UNMATCHABLE_TOKEN,
    /*  5 */ r###";"###,
    /*  6 */ r###"(?i)AND"###,
    /*  7 */ r###"(?i)OR"###,
    /*  8 */ r###"(?i)XOR"###,
    /*  9 */ r###"(?i)NOR"###,
    /* 10 */ r###"(?i)NAND"###,
    /* 11 */ r###"(?i)XNOR"###,
    /* 12 */ r###"(?i)TRUE"###,
    /* 13 */ r###"(?i)FALSE"###,
    /* 14 */ r###"(?i)NOT"###,
    /* 15 */ r###"\("###,
    /* 16 */ r###"\)"###,
    /* 17 */ ERROR_TOKEN,
];

pub const TERMINAL_NAMES: &[&str; 18] = &[
    /*  0 */ "EndOfInput",
    /*  1 */ "Newline",
    /*  2 */ "Whitespace",
    /*  3 */ "LineComment",
    /*  4 */ "BlockComment",
    /*  5 */ "Semicolon",
    /*  6 */ "AndOp",
    /*  7 */ "OrOp",
    /*  8 */ "XorOp",
    /*  9 */ "NorOp",
    /* 10 */ "NandOp",
    /* 11 */ "XnorOp",
    /* 12 */ "True",
    /* 13 */ "False",
    /* 14 */ "Not",
    /* 15 */ "LParen",
    /* 16 */ "RParen",
    /* 17 */ "Error",
];

/* SCANNER_0: "INITIAL" */
const SCANNER_0: (&[&str; 5], &[usize; 12]) = (
    &[
        /*  0 */ UNMATCHABLE_TOKEN,
        /*  1 */ NEW_LINE_TOKEN,
        /*  2 */ WHITESPACE_TOKEN,
        /*  3 */ r###"(//.*(\r\n|\r|\n|$))"###,
        /*  4 */ r###"((?ms)\(\*.*?\*\))"###,
    ],
    &[
        5,  /* Semicolon */
        6,  /* AndOp */
        7,  /* OrOp */
        8,  /* XorOp */
        9,  /* NorOp */
        10, /* NandOp */
        11, /* XnorOp */
        12, /* True */
        13, /* False */
        14, /* Not */
        15, /* LParen */
        16, /* RParen */
    ],
);

const MAX_K: usize = 2;

pub const NON_TERMINALS: &[&str; 21] = &[
    /*  0 */ "AndOp",
    /*  1 */ "BinaryOperator",
    /*  2 */ "Boolean",
    /*  3 */ "Expression",
    /*  4 */ "Expressions",
    /*  5 */ "ExpressionsList",
    /*  6 */ "ExpressionsSuffix",
    /*  7 */ "Factor",
    /*  8 */ "False",
    /*  9 */ "NandOp",
    /* 10 */ "NorOp",
    /* 11 */ "Not",
    /* 12 */ "OrOp",
    /* 13 */ "Parenthesized",
    /* 14 */ "TailExpression",
    /* 15 */ "TailExpressionList",
    /* 16 */ "Term",
    /* 17 */ "True",
    /* 18 */ "UnaryOperator",
    /* 19 */ "XnorOp",
    /* 20 */ "XorOp",
];

pub const LOOKAHEAD_AUTOMATA: &[LookaheadDFA; 21] = &[
    /* 0 - "AndOp" */
    LookaheadDFA {
        states: &[Some(20)],
        transitions: &[],
        k: 0,
    },
    /* 1 - "BinaryOperator" */
    LookaheadDFA {
        states: &[
            None,
            Some(14),
            Some(15),
            Some(16),
            Some(17),
            Some(18),
            Some(19),
        ],
        transitions: &[
            DFATransition(0, 6, 1),
            DFATransition(0, 7, 2),
            DFATransition(0, 8, 3),
            DFATransition(0, 9, 4),
            DFATransition(0, 10, 5),
            DFATransition(0, 11, 6),
        ],
        k: 1,
    },
    /* 2 - "Boolean" */
    LookaheadDFA {
        states: &[None, Some(11), Some(12)],
        transitions: &[DFATransition(0, 12, 1), DFATransition(0, 13, 2)],
        k: 1,
    },
    /* 3 - "Expression" */
    LookaheadDFA {
        states: &[Some(5)],
        transitions: &[],
        k: 0,
    },
    /* 4 - "Expressions" */
    LookaheadDFA {
        states: &[Some(0)],
        transitions: &[],
        k: 0,
    },
    /* 5 - "ExpressionsList" */
    LookaheadDFA {
        states: &[None, None, Some(3), Some(4)],
        transitions: &[
            DFATransition(0, 0, 3),
            DFATransition(0, 5, 1),
            DFATransition(1, 0, 3),
            DFATransition(1, 12, 2),
            DFATransition(1, 13, 2),
            DFATransition(1, 14, 2),
            DFATransition(1, 15, 2),
        ],
        k: 2,
    },
    /* 6 - "ExpressionsSuffix" */
    LookaheadDFA {
        states: &[None, Some(1), Some(2)],
        transitions: &[DFATransition(0, 0, 2), DFATransition(0, 5, 1)],
        k: 1,
    },
    /* 7 - "Factor" */
    LookaheadDFA {
        states: &[None, Some(30), Some(31)],
        transitions: &[
            DFATransition(0, 12, 1),
            DFATransition(0, 13, 1),
            DFATransition(0, 15, 2),
        ],
        k: 1,
    },
    /* 8 - "False" */
    LookaheadDFA {
        states: &[Some(27)],
        transitions: &[],
        k: 0,
    },
    /* 9 - "NandOp" */
    LookaheadDFA {
        states: &[Some(24)],
        transitions: &[],
        k: 0,
    },
    /* 10 - "NorOp" */
    LookaheadDFA {
        states: &[Some(23)],
        transitions: &[],
        k: 0,
    },
    /* 11 - "Not" */
    LookaheadDFA {
        states: &[Some(28)],
        transitions: &[],
        k: 0,
    },
    /* 12 - "OrOp" */
    LookaheadDFA {
        states: &[Some(21)],
        transitions: &[],
        k: 0,
    },
    /* 13 - "Parenthesized" */
    LookaheadDFA {
        states: &[Some(29)],
        transitions: &[],
        k: 0,
    },
    /* 14 - "TailExpression" */
    LookaheadDFA {
        states: &[Some(6)],
        transitions: &[],
        k: 0,
    },
    /* 15 - "TailExpressionList" */
    LookaheadDFA {
        states: &[None, Some(7), Some(8)],
        transitions: &[
            DFATransition(0, 0, 2),
            DFATransition(0, 5, 2),
            DFATransition(0, 6, 1),
            DFATransition(0, 7, 1),
            DFATransition(0, 8, 1),
            DFATransition(0, 9, 1),
            DFATransition(0, 10, 1),
            DFATransition(0, 11, 1),
            DFATransition(0, 16, 2),
        ],
        k: 1,
    },
    /* 16 - "Term" */
    LookaheadDFA {
        states: &[None, Some(9), Some(10)],
        transitions: &[
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 2),
            DFATransition(0, 14, 1),
            DFATransition(0, 15, 2),
        ],
        k: 1,
    },
    /* 17 - "True" */
    LookaheadDFA {
        states: &[Some(26)],
        transitions: &[],
        k: 0,
    },
    /* 18 - "UnaryOperator" */
    LookaheadDFA {
        states: &[Some(13)],
        transitions: &[],
        k: 0,
    },
    /* 19 - "XnorOp" */
    LookaheadDFA {
        states: &[Some(25)],
        transitions: &[],
        k: 0,
    },
    /* 20 - "XorOp" */
    LookaheadDFA {
        states: &[Some(22)],
        transitions: &[],
        k: 0,
    },
];

pub const PRODUCTIONS: &[Production; 32] = &[
    // 0 - Expressions: Expression ExpressionsList ExpressionsSuffix;
    Production {
        lhs: 4,
        production: &[ParseType::N(6), ParseType::N(5), ParseType::N(3)],
    },
    // 1 - ExpressionsSuffix: ";";
    Production {
        lhs: 6,
        production: &[ParseType::T(5)],
    },
    // 2 - ExpressionsSuffix: ;
    Production {
        lhs: 6,
        production: &[],
    },
    // 3 - ExpressionsList: ";" Expression ExpressionsList;
    Production {
        lhs: 5,
        production: &[ParseType::N(5), ParseType::N(3), ParseType::T(5)],
    },
    // 4 - ExpressionsList: ;
    Production {
        lhs: 5,
        production: &[],
    },
    // 5 - Expression: Term TailExpression;
    Production {
        lhs: 3,
        production: &[ParseType::N(14), ParseType::N(16)],
    },
    // 6 - TailExpression: TailExpressionList;
    Production {
        lhs: 14,
        production: &[ParseType::N(15)],
    },
    // 7 - TailExpressionList: BinaryOperator Term TailExpressionList;
    Production {
        lhs: 15,
        production: &[ParseType::N(15), ParseType::N(16), ParseType::N(1)],
    },
    // 8 - TailExpressionList: ;
    Production {
        lhs: 15,
        production: &[],
    },
    // 9 - Term: UnaryOperator Factor;
    Production {
        lhs: 16,
        production: &[ParseType::N(7), ParseType::N(18)],
    },
    // 10 - Term: Factor;
    Production {
        lhs: 16,
        production: &[ParseType::N(7)],
    },
    // 11 - Boolean: True;
    Production {
        lhs: 2,
        production: &[ParseType::N(17)],
    },
    // 12 - Boolean: False;
    Production {
        lhs: 2,
        production: &[ParseType::N(8)],
    },
    // 13 - UnaryOperator: Not;
    Production {
        lhs: 18,
        production: &[ParseType::N(11)],
    },
    // 14 - BinaryOperator: AndOp;
    Production {
        lhs: 1,
        production: &[ParseType::N(0)],
    },
    // 15 - BinaryOperator: OrOp;
    Production {
        lhs: 1,
        production: &[ParseType::N(12)],
    },
    // 16 - BinaryOperator: XorOp;
    Production {
        lhs: 1,
        production: &[ParseType::N(20)],
    },
    // 17 - BinaryOperator: NorOp;
    Production {
        lhs: 1,
        production: &[ParseType::N(10)],
    },
    // 18 - BinaryOperator: NandOp;
    Production {
        lhs: 1,
        production: &[ParseType::N(9)],
    },
    // 19 - BinaryOperator: XnorOp;
    Production {
        lhs: 1,
        production: &[ParseType::N(19)],
    },
    // 20 - AndOp: "(?i)AND";
    Production {
        lhs: 0,
        production: &[ParseType::T(6)],
    },
    // 21 - OrOp: "(?i)OR";
    Production {
        lhs: 12,
        production: &[ParseType::T(7)],
    },
    // 22 - XorOp: "(?i)XOR";
    Production {
        lhs: 20,
        production: &[ParseType::T(8)],
    },
    // 23 - NorOp: "(?i)NOR";
    Production {
        lhs: 10,
        production: &[ParseType::T(9)],
    },
    // 24 - NandOp: "(?i)NAND";
    Production {
        lhs: 9,
        production: &[ParseType::T(10)],
    },
    // 25 - XnorOp: "(?i)XNOR";
    Production {
        lhs: 19,
        production: &[ParseType::T(11)],
    },
    // 26 - True: "(?i)TRUE";
    Production {
        lhs: 17,
        production: &[ParseType::T(12)],
    },
    // 27 - False: "(?i)FALSE";
    Production {
        lhs: 8,
        production: &[ParseType::T(13)],
    },
    // 28 - Not: "(?i)NOT";
    Production {
        lhs: 11,
        production: &[ParseType::T(14)],
    },
    // 29 - Parenthesized: "\(" Expression "\)";
    Production {
        lhs: 13,
        production: &[ParseType::T(16), ParseType::N(3), ParseType::T(15)],
    },
    // 30 - Factor: Boolean;
    Production {
        lhs: 7,
        production: &[ParseType::N(2)],
    },
    // 31 - Factor: Parenthesized;
    Production {
        lhs: 7,
        production: &[ParseType::N(13)],
    },
];

lazy_static! {
    static ref TOKENIZERS: Vec<(&'static str, Tokenizer)> = vec![(
        "INITIAL",
        Tokenizer::build(TERMINALS, SCANNER_0.0, SCANNER_0.1).unwrap()
    ),];
}

pub fn parse(
    input: &str,
    file_name: String,
    user_actions: &mut dyn UserActionsTrait,
) -> Result<Tree<ParseTreeType>> {
    let mut llk_parser = LLKParser::new(
        4,
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream =
        RefCell::new(TokenStream::new(input, file_name, &TOKENIZERS, MAX_K).unwrap());
    let result = llk_parser.parse(token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
