// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use parol_runtime::errors::*;
use parol_runtime::lexer::{TokenStream, Tokenizer};
use parol_runtime::parser::{
    DFATransition, LLKParser, LookaheadDFA, ParseTreeType, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;

use parol_runtime::lexer::tokenizer::{
    ERROR_TOKEN, NEW_LINE_TOKEN, UNMATCHABLE_TOKEN, WHITESPACE_TOKEN,
};

pub const TERMINALS: &[&str; 8] = &[
    /* 0 */ UNMATCHABLE_TOKEN,
    /* 1 */ UNMATCHABLE_TOKEN,
    /* 2 */ UNMATCHABLE_TOKEN,
    /* 3 */ UNMATCHABLE_TOKEN,
    /* 4 */ UNMATCHABLE_TOKEN,
    /* 5 */ r###","###,
    /* 6 */ r###"\d+"###,
    /* 7 */ ERROR_TOKEN,
];

pub const TERMINAL_NAMES: &[&str; 8] = &[
    /* 0 */ "EndOfInput",
    /* 1 */ "Newline",
    /* 2 */ "Whitespace",
    /* 3 */ "LineComment",
    /* 4 */ "BlockComment",
    /* 5 */ "Comma",
    /* 6 */ "Num",
    /* 7 */ "Error",
];

/* SCANNER_0: "INITIAL" */
const SCANNER_0: (&[&str; 5], &[usize; 2]) = (
    &[
        /* 0 */ UNMATCHABLE_TOKEN,
        /* 1 */ NEW_LINE_TOKEN,
        /* 2 */ WHITESPACE_TOKEN,
        /* 3 */ UNMATCHABLE_TOKEN,
        /* 4 */ UNMATCHABLE_TOKEN,
    ],
    &[5 /* Comma */, 6 /* Num */],
);

const MAX_K: usize = 2;

pub const NON_TERMINALS: &[&str; 4] = &[
    /* 0 */ "list",
    /* 1 */ "list_item",
    /* 2 */ "list_rest",
    /* 3 */ "num",
];

pub const LOOKAHEAD_AUTOMATA: &[LookaheadDFA; 4] = &[
    /* 0 - "list" */
    LookaheadDFA {
        states: &[None, Some(0), Some(1)],
        transitions: &[DFATransition(0, 0, 1), DFATransition(0, 6, 2)],
        k: 1,
    },
    /* 1 - "list_item" */
    LookaheadDFA {
        states: &[Some(3)],
        transitions: &[],
        k: 0,
    },
    /* 2 - "list_rest" */
    LookaheadDFA {
        states: &[None, None, Some(2), Some(4), Some(5)],
        transitions: &[
            DFATransition(0, 0, 3),
            DFATransition(0, 5, 1),
            DFATransition(1, 0, 4),
            DFATransition(1, 6, 2),
        ],
        k: 2,
    },
    /* 3 - "num" */
    LookaheadDFA {
        states: &[Some(6)],
        transitions: &[],
        k: 0,
    },
];

pub const PRODUCTIONS: &[Production; 7] = &[
    // 0 - list: ;
    Production {
        lhs: 0,
        production: &[],
    },
    // 1 - list: num list_rest;
    Production {
        lhs: 0,
        production: &[ParseType::N(2), ParseType::N(3)],
    },
    // 2 - list_rest: list_item list_rest;
    Production {
        lhs: 2,
        production: &[ParseType::N(2), ParseType::N(1)],
    },
    // 3 - list_item: "," num;
    Production {
        lhs: 1,
        production: &[ParseType::N(3), ParseType::T(5)],
    },
    // 4 - list_rest: ;
    Production {
        lhs: 2,
        production: &[],
    },
    // 5 - list_rest: ",";
    Production {
        lhs: 2,
        production: &[ParseType::T(5)],
    },
    // 6 - num: "\d+";
    Production {
        lhs: 3,
        production: &[ParseType::T(6)],
    },
];

lazy_static! {
    static ref TOKENIZERS: Vec<(&'static str, Tokenizer)> = vec![(
        "INITIAL",
        Tokenizer::build(TERMINALS, SCANNER_0.0, SCANNER_0.1).unwrap()
    ),];
}

pub fn parse(
    input: &str,
    file_name: String,
    user_actions: &mut dyn UserActionsTrait,
) -> Result<Tree<ParseTreeType>> {
    let mut llk_parser = LLKParser::new(
        0,
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream =
        RefCell::new(TokenStream::new(input, file_name, &TOKENIZERS, MAX_K).unwrap());
    let result = llk_parser.parse(token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
