// ---------------------------------------------------------
// This file was generated by parol.
// It is not intended for manual editing and changes will be
// lost after next build.
// ---------------------------------------------------------

use id_tree::Tree;
use parol_runtime::lexer::{TokenStream, Tokenizer};
use parol_runtime::parser::errors::*;
use parol_runtime::parser::{
    DFATransition, LLKParser, LookaheadDFA, ParseTreeType, ParseType, Production, UserActionsTrait,
};
use std::cell::RefCell;

use parol_runtime::lexer::tokenizer::{
    ERROR_TOKEN, NEW_LINE_TOKEN, UNMATCHABLE_TOKEN, WHITESPACE_TOKEN,
};

pub const TERMINALS: &[&str; 42] = &[
    /*  0 */ UNMATCHABLE_TOKEN,
    /*  1 */ NEW_LINE_TOKEN,
    /*  2 */ WHITESPACE_TOKEN,
    /*  3 */ UNMATCHABLE_TOKEN,
    /*  4 */ r###"(?ms)\(\*.*?\*\)"###,
    /*  5 */ r###"\."###,
    /*  6 */ r###"\["###,
    /*  7 */ r###"]"###,
    /*  8 */ r###"\("###,
    /*  9 */ r###"\)"###,
    /* 10 */ r###"~"###,
    /* 11 */ r###":="###,
    /* 12 */ r###">=|<=|\#|<|>"###,
    /* 13 */ r###"="###,
    /* 14 */ r###","###,
    /* 15 */ r###"IF"###,
    /* 16 */ r###"THEN"###,
    /* 17 */ r###"ELSE"###,
    /* 18 */ r###"END"###,
    /* 19 */ r###"ELSIF"###,
    /* 20 */ r###"WHILE"###,
    /* 21 */ r###"DO"###,
    /* 22 */ r###"REPEAT"###,
    /* 23 */ r###"UNTIL"###,
    /* 24 */ r###";"###,
    /* 25 */ r###"ARRAY"###,
    /* 26 */ r###"OF"###,
    /* 27 */ r###":"###,
    /* 28 */ r###"RECORD"###,
    /* 29 */ r###"VAR"###,
    /* 30 */ r###"PROCEDURE"###,
    /* 31 */ r###"BEGIN"###,
    /* 32 */ r###"RETURN"###,
    /* 33 */ r###"TYPE"###,
    /* 34 */ r###"CONST"###,
    /* 35 */ r###"MODULE"###,
    /* 36 */ r###"\*|/|DIV|MOD|&"###,
    /* 37 */ r###"\+|-|OR"###,
    /* 38 */ r###"\+|-"###,
    /* 39 */ r###"[a-zA-Z][a-zA-Z0-9]*"###,
    /* 40 */ r###"[0-9]+"###,
    /* 41 */ ERROR_TOKEN,
];

pub const TERMINAL_NAMES: &[&str; 42] = &[
    /*  0 */ "EndOfInput",
    /*  1 */ "Newline",
    /*  2 */ "Whitespace",
    /*  3 */ "LineComment",
    /*  4 */ "BlockComment",
    /*  5 */ "Dot",
    /*  6 */ "LBracket",
    /*  7 */ "RBracket",
    /*  8 */ "LParen",
    /*  9 */ "RParen",
    /* 10 */ "Tilde",
    /* 11 */ "ColonEqu",
    /* 12 */ "RelationalOps",
    /* 13 */ "Equ",
    /* 14 */ "Comma",
    /* 15 */ "IF",
    /* 16 */ "THEN",
    /* 17 */ "ELSE",
    /* 18 */ "END",
    /* 19 */ "ELSIF",
    /* 20 */ "WHILE",
    /* 21 */ "DO",
    /* 22 */ "REPEAT",
    /* 23 */ "UNTIL",
    /* 24 */ "Semicolon",
    /* 25 */ "ARRAY",
    /* 26 */ "OF",
    /* 27 */ "Colon",
    /* 28 */ "RECORD",
    /* 29 */ "VAR",
    /* 30 */ "PROCEDURE",
    /* 31 */ "BEGIN",
    /* 32 */ "RETURN",
    /* 33 */ "TYPE",
    /* 34 */ "CONST",
    /* 35 */ "MODULE",
    /* 36 */ "MulOperator",
    /* 37 */ "AddOperator",
    /* 38 */ "UnaryOp",
    /* 39 */ "Ident",
    /* 40 */ "Integer",
    /* 41 */ "Error",
];

const MAX_K: usize = 2;

pub const NON_TERMINALS: &[&str; 58] = &[
    /*  0 */ "ActualParameters",
    /*  1 */ "ActualParametersSuffix",
    /*  2 */ "AddExpression",
    /*  3 */ "AddOperator",
    /*  4 */ "ArrayType",
    /*  5 */ "AssignOp",
    /*  6 */ "ConstDecls",
    /*  7 */ "FPSection",
    /*  8 */ "FPSectionRest",
    /*  9 */ "FieldList",
    /* 10 */ "FieldListRest",
    /* 11 */ "FormalParameters",
    /* 12 */ "FormalParametersSuffix",
    /* 13 */ "IdentList",
    /* 14 */ "IdentListRest",
    /* 15 */ "IfStatement",
    /* 16 */ "IfStatementSuffix",
    /* 17 */ "MulExpression",
    /* 18 */ "MulOperator",
    /* 19 */ "ProcedureBody",
    /* 20 */ "ProcedureBodySuffix",
    /* 21 */ "ProcedureBodySuffix1",
    /* 22 */ "ProcedureCall",
    /* 23 */ "ProcedureCallSuffix",
    /* 24 */ "ProcedureDeclaration",
    /* 25 */ "ProcedureDeclarationList",
    /* 26 */ "ProcedureHeading",
    /* 27 */ "ProcedureHeadingSuffix",
    /* 28 */ "RecordType",
    /* 29 */ "RelationOp",
    /* 30 */ "RelationalOps",
    /* 31 */ "RepeatStatement",
    /* 32 */ "SimpleExpression",
    /* 33 */ "StatementSequence",
    /* 34 */ "StatementSequenceRest",
    /* 35 */ "TypeDecls",
    /* 36 */ "UnaryOp",
    /* 37 */ "VarDecls",
    /* 38 */ "WhileStatement",
    /* 39 */ "assignment",
    /* 40 */ "declarations",
    /* 41 */ "declarationsSuffix",
    /* 42 */ "declarationsSuffix1",
    /* 43 */ "declarationsSuffix2",
    /* 44 */ "elseiflist",
    /* 45 */ "expression",
    /* 46 */ "expressionSuffix",
    /* 47 */ "expressionlistrest",
    /* 48 */ "factor",
    /* 49 */ "ident",
    /* 50 */ "integer",
    /* 51 */ "module",
    /* 52 */ "moduleSuffix",
    /* 53 */ "selector",
    /* 54 */ "selectorlist",
    /* 55 */ "statement",
    /* 56 */ "term",
    /* 57 */ "type",
];

pub const LOOKAHEAD_AUTOMATA: &[LookaheadDFA; 58] = &[
    /* 0 - "ActualParameters" */
    LookaheadDFA {
        states: &[Some(24)],
        transitions: &[],
        k: 0,
    },
    /* 1 - "ActualParametersSuffix" */
    LookaheadDFA {
        states: &[None, Some(25), Some(26)],
        transitions: &[
            DFATransition(0, 8, 2),
            DFATransition(0, 9, 1),
            DFATransition(0, 10, 2),
            DFATransition(0, 38, 2),
            DFATransition(0, 39, 2),
            DFATransition(0, 40, 2),
        ],
        k: 1,
    },
    /* 2 - "AddExpression" */
    LookaheadDFA {
        states: &[None, Some(13), Some(14)],
        transitions: &[
            DFATransition(0, 7, 2),
            DFATransition(0, 9, 2),
            DFATransition(0, 11, 2),
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 2),
            DFATransition(0, 14, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 21, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 26, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 37, 1),
        ],
        k: 1,
    },
    /* 3 - "AddOperator" */
    LookaheadDFA {
        states: &[Some(100)],
        transitions: &[],
        k: 0,
    },
    /* 4 - "ArrayType" */
    LookaheadDFA {
        states: &[Some(51)],
        transitions: &[],
        k: 0,
    },
    /* 5 - "AssignOp" */
    LookaheadDFA {
        states: &[None, Some(15), Some(19)],
        transitions: &[DFATransition(0, 11, 1), DFATransition(0, 13, 2)],
        k: 1,
    },
    /* 6 - "ConstDecls" */
    LookaheadDFA {
        states: &[None, Some(90), Some(91)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 29, 2),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 33, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 7 - "FPSection" */
    LookaheadDFA {
        states: &[None, Some(60), Some(61)],
        transitions: &[DFATransition(0, 29, 1), DFATransition(0, 39, 2)],
        k: 1,
    },
    /* 8 - "FPSectionRest" */
    LookaheadDFA {
        states: &[None, Some(65), Some(66)],
        transitions: &[DFATransition(0, 9, 2), DFATransition(0, 24, 1)],
        k: 1,
    },
    /* 9 - "FieldList" */
    LookaheadDFA {
        states: &[None, Some(52), Some(53)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 10 - "FieldListRest" */
    LookaheadDFA {
        states: &[None, Some(55), Some(56)],
        transitions: &[DFATransition(0, 18, 2), DFATransition(0, 24, 1)],
        k: 1,
    },
    /* 11 - "FormalParameters" */
    LookaheadDFA {
        states: &[Some(62)],
        transitions: &[],
        k: 0,
    },
    /* 12 - "FormalParametersSuffix" */
    LookaheadDFA {
        states: &[None, Some(63), Some(64)],
        transitions: &[
            DFATransition(0, 9, 1),
            DFATransition(0, 29, 2),
            DFATransition(0, 39, 2),
        ],
        k: 1,
    },
    /* 13 - "IdentList" */
    LookaheadDFA {
        states: &[Some(48)],
        transitions: &[],
        k: 0,
    },
    /* 14 - "IdentListRest" */
    LookaheadDFA {
        states: &[None, Some(49), Some(50)],
        transitions: &[DFATransition(0, 14, 1), DFATransition(0, 27, 2)],
        k: 1,
    },
    /* 15 - "IfStatement" */
    LookaheadDFA {
        states: &[Some(32)],
        transitions: &[],
        k: 0,
    },
    /* 16 - "IfStatementSuffix" */
    LookaheadDFA {
        states: &[None, Some(33), Some(34)],
        transitions: &[DFATransition(0, 17, 1), DFATransition(0, 18, 2)],
        k: 1,
    },
    /* 17 - "MulExpression" */
    LookaheadDFA {
        states: &[None, Some(10), Some(11)],
        transitions: &[
            DFATransition(0, 7, 2),
            DFATransition(0, 9, 2),
            DFATransition(0, 11, 2),
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 2),
            DFATransition(0, 14, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 21, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 26, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 36, 1),
            DFATransition(0, 37, 2),
        ],
        k: 1,
    },
    /* 18 - "MulOperator" */
    LookaheadDFA {
        states: &[Some(99)],
        transitions: &[],
        k: 0,
    },
    /* 19 - "ProcedureBody" */
    LookaheadDFA {
        states: &[Some(70)],
        transitions: &[],
        k: 0,
    },
    /* 20 - "ProcedureBodySuffix" */
    LookaheadDFA {
        states: &[None, Some(74), Some(75)],
        transitions: &[DFATransition(0, 18, 2), DFATransition(0, 32, 1)],
        k: 1,
    },
    /* 21 - "ProcedureBodySuffix1" */
    LookaheadDFA {
        states: &[None, Some(71), Some(72), Some(73)],
        transitions: &[
            DFATransition(0, 18, 3),
            DFATransition(0, 31, 1),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 22 - "ProcedureCall" */
    LookaheadDFA {
        states: &[Some(29)],
        transitions: &[],
        k: 0,
    },
    /* 23 - "ProcedureCallSuffix" */
    LookaheadDFA {
        states: &[None, Some(30), Some(31)],
        transitions: &[
            DFATransition(0, 8, 1),
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 24 - "ProcedureDeclaration" */
    LookaheadDFA {
        states: &[Some(76)],
        transitions: &[],
        k: 0,
    },
    /* 25 - "ProcedureDeclarationList" */
    LookaheadDFA {
        states: &[None, Some(88), Some(89)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 30, 1),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 26 - "ProcedureHeading" */
    LookaheadDFA {
        states: &[Some(67)],
        transitions: &[],
        k: 0,
    },
    /* 27 - "ProcedureHeadingSuffix" */
    LookaheadDFA {
        states: &[None, Some(68), Some(69)],
        transitions: &[DFATransition(0, 8, 1), DFATransition(0, 24, 2)],
        k: 1,
    },
    /* 28 - "RecordType" */
    LookaheadDFA {
        states: &[Some(54)],
        transitions: &[],
        k: 0,
    },
    /* 29 - "RelationOp" */
    LookaheadDFA {
        states: &[None, Some(16), Some(17)],
        transitions: &[
            DFATransition(0, 11, 1),
            DFATransition(0, 12, 2),
            DFATransition(0, 13, 1),
        ],
        k: 1,
    },
    /* 30 - "RelationalOps" */
    LookaheadDFA {
        states: &[Some(18)],
        transitions: &[],
        k: 0,
    },
    /* 31 - "RepeatStatement" */
    LookaheadDFA {
        states: &[Some(38)],
        transitions: &[],
        k: 0,
    },
    /* 32 - "SimpleExpression" */
    LookaheadDFA {
        states: &[Some(12)],
        transitions: &[],
        k: 0,
    },
    /* 33 - "StatementSequence" */
    LookaheadDFA {
        states: &[Some(45)],
        transitions: &[],
        k: 0,
    },
    /* 34 - "StatementSequenceRest" */
    LookaheadDFA {
        states: &[None, Some(46), Some(47)],
        transitions: &[
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 1),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 35 - "TypeDecls" */
    LookaheadDFA {
        states: &[None, Some(92), Some(93)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 29, 2),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 36 - "UnaryOp" */
    LookaheadDFA {
        states: &[Some(101)],
        transitions: &[],
        k: 0,
    },
    /* 37 - "VarDecls" */
    LookaheadDFA {
        states: &[None, Some(94), Some(95)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
    /* 38 - "WhileStatement" */
    LookaheadDFA {
        states: &[Some(37)],
        transitions: &[],
        k: 0,
    },
    /* 39 - "assignment" */
    LookaheadDFA {
        states: &[Some(23)],
        transitions: &[],
        k: 0,
    },
    /* 40 - "declarations" */
    LookaheadDFA {
        states: &[None, Some(77), Some(78), Some(81), Some(82)],
        transitions: &[
            DFATransition(0, 18, 4),
            DFATransition(0, 29, 3),
            DFATransition(0, 30, 4),
            DFATransition(0, 31, 4),
            DFATransition(0, 32, 4),
            DFATransition(0, 33, 1),
            DFATransition(0, 34, 2),
        ],
        k: 1,
    },
    /* 41 - "declarationsSuffix" */
    LookaheadDFA {
        states: &[None, Some(86), Some(87)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 29, 1),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 42 - "declarationsSuffix1" */
    LookaheadDFA {
        states: &[None, Some(83), Some(84), Some(85)],
        transitions: &[
            DFATransition(0, 18, 3),
            DFATransition(0, 29, 2),
            DFATransition(0, 30, 3),
            DFATransition(0, 31, 3),
            DFATransition(0, 32, 3),
            DFATransition(0, 33, 1),
        ],
        k: 1,
    },
    /* 43 - "declarationsSuffix2" */
    LookaheadDFA {
        states: &[None, Some(79), Some(80)],
        transitions: &[
            DFATransition(0, 18, 2),
            DFATransition(0, 29, 1),
            DFATransition(0, 30, 2),
            DFATransition(0, 31, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 44 - "elseiflist" */
    LookaheadDFA {
        states: &[None, Some(35), Some(36)],
        transitions: &[
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 1),
        ],
        k: 1,
    },
    /* 45 - "expression" */
    LookaheadDFA {
        states: &[Some(20)],
        transitions: &[],
        k: 0,
    },
    /* 46 - "expressionSuffix" */
    LookaheadDFA {
        states: &[None, Some(21), Some(22)],
        transitions: &[
            DFATransition(0, 7, 2),
            DFATransition(0, 9, 2),
            DFATransition(0, 11, 1),
            DFATransition(0, 12, 1),
            DFATransition(0, 13, 1),
            DFATransition(0, 14, 2),
            DFATransition(0, 16, 2),
            DFATransition(0, 17, 2),
            DFATransition(0, 18, 2),
            DFATransition(0, 19, 2),
            DFATransition(0, 21, 2),
            DFATransition(0, 23, 2),
            DFATransition(0, 24, 2),
            DFATransition(0, 26, 2),
            DFATransition(0, 32, 2),
        ],
        k: 1,
    },
    /* 47 - "expressionlistrest" */
    LookaheadDFA {
        states: &[None, Some(27), Some(28)],
        transitions: &[DFATransition(0, 9, 2), DFATransition(0, 14, 1)],
        k: 1,
    },
    /* 48 - "factor" */
    LookaheadDFA {
        states: &[None, Some(4), Some(5), Some(6), Some(7), Some(8)],
        transitions: &[
            DFATransition(0, 8, 3),
            DFATransition(0, 10, 4),
            DFATransition(0, 38, 5),
            DFATransition(0, 39, 1),
            DFATransition(0, 40, 2),
        ],
        k: 1,
    },
    /* 49 - "ident" */
    LookaheadDFA {
        states: &[Some(102)],
        transitions: &[],
        k: 0,
    },
    /* 50 - "integer" */
    LookaheadDFA {
        states: &[Some(103)],
        transitions: &[],
        k: 0,
    },
    /* 51 - "module" */
    LookaheadDFA {
        states: &[Some(96)],
        transitions: &[],
        k: 0,
    },
    /* 52 - "moduleSuffix" */
    LookaheadDFA {
        states: &[None, Some(97), Some(98)],
        transitions: &[DFATransition(0, 18, 2), DFATransition(0, 31, 1)],
        k: 1,
    },
    /* 53 - "selector" */
    LookaheadDFA {
        states: &[Some(0)],
        transitions: &[],
        k: 0,
    },
    /* 54 - "selectorlist" */
    LookaheadDFA {
        states: &[None, Some(1), Some(2), Some(3)],
        transitions: &[
            DFATransition(0, 5, 1),
            DFATransition(0, 6, 2),
            DFATransition(0, 7, 3),
            DFATransition(0, 9, 3),
            DFATransition(0, 11, 3),
            DFATransition(0, 12, 3),
            DFATransition(0, 13, 3),
            DFATransition(0, 14, 3),
            DFATransition(0, 16, 3),
            DFATransition(0, 17, 3),
            DFATransition(0, 18, 3),
            DFATransition(0, 19, 3),
            DFATransition(0, 21, 3),
            DFATransition(0, 23, 3),
            DFATransition(0, 24, 3),
            DFATransition(0, 26, 3),
            DFATransition(0, 32, 3),
            DFATransition(0, 36, 3),
            DFATransition(0, 37, 3),
        ],
        k: 1,
    },
    /* 55 - "statement" */
    LookaheadDFA {
        states: &[
            None,
            Some(40),
            Some(39),
            None,
            Some(41),
            None,
            Some(42),
            None,
            Some(43),
            None,
            None,
            None,
            None,
            None,
            None,
            Some(44),
        ],
        transitions: &[
            DFATransition(0, 15, 3),
            DFATransition(0, 17, 9),
            DFATransition(0, 18, 10),
            DFATransition(0, 19, 11),
            DFATransition(0, 20, 5),
            DFATransition(0, 22, 7),
            DFATransition(0, 23, 12),
            DFATransition(0, 24, 13),
            DFATransition(0, 32, 14),
            DFATransition(0, 39, 1),
            DFATransition(1, 5, 2),
            DFATransition(1, 6, 2),
            DFATransition(1, 8, 1),
            DFATransition(1, 11, 2),
            DFATransition(1, 13, 2),
            DFATransition(3, 8, 4),
            DFATransition(3, 10, 4),
            DFATransition(3, 38, 4),
            DFATransition(3, 39, 4),
            DFATransition(3, 40, 4),
            DFATransition(5, 8, 6),
            DFATransition(5, 10, 6),
            DFATransition(5, 38, 6),
            DFATransition(5, 39, 6),
            DFATransition(5, 40, 6),
            DFATransition(7, 15, 8),
            DFATransition(7, 20, 8),
            DFATransition(7, 22, 8),
            DFATransition(7, 23, 8),
            DFATransition(7, 24, 8),
            DFATransition(7, 39, 8),
            DFATransition(9, 15, 15),
            DFATransition(9, 18, 15),
            DFATransition(9, 20, 15),
            DFATransition(9, 22, 15),
            DFATransition(9, 24, 15),
            DFATransition(9, 39, 15),
            DFATransition(10, 17, 15),
            DFATransition(10, 18, 15),
            DFATransition(10, 19, 15),
            DFATransition(10, 23, 15),
            DFATransition(10, 24, 15),
            DFATransition(10, 32, 15),
            DFATransition(10, 39, 15),
            DFATransition(11, 8, 15),
            DFATransition(11, 10, 15),
            DFATransition(11, 38, 15),
            DFATransition(11, 39, 15),
            DFATransition(11, 40, 15),
            DFATransition(12, 8, 15),
            DFATransition(12, 10, 15),
            DFATransition(12, 38, 15),
            DFATransition(12, 39, 15),
            DFATransition(12, 40, 15),
            DFATransition(13, 15, 15),
            DFATransition(13, 17, 15),
            DFATransition(13, 18, 15),
            DFATransition(13, 19, 15),
            DFATransition(13, 20, 15),
            DFATransition(13, 22, 15),
            DFATransition(13, 23, 15),
            DFATransition(13, 24, 15),
            DFATransition(13, 32, 15),
            DFATransition(13, 39, 15),
            DFATransition(14, 8, 15),
            DFATransition(14, 10, 15),
            DFATransition(14, 38, 15),
            DFATransition(14, 39, 15),
            DFATransition(14, 40, 15),
        ],
        k: 2,
    },
    /* 56 - "term" */
    LookaheadDFA {
        states: &[Some(9)],
        transitions: &[],
        k: 0,
    },
    /* 57 - "type" */
    LookaheadDFA {
        states: &[None, Some(57), Some(58), Some(59)],
        transitions: &[
            DFATransition(0, 25, 2),
            DFATransition(0, 28, 3),
            DFATransition(0, 39, 1),
        ],
        k: 1,
    },
];

pub const PRODUCTIONS: &[Production; 104] = &[
    // 0 - selector: selectorlist;
    Production {
        lhs: 53,
        production: &[ParseType::N(54)],
    },
    // 1 - selectorlist: "\." ident selectorlist;
    Production {
        lhs: 54,
        production: &[ParseType::N(54), ParseType::N(49), ParseType::T(5)],
    },
    // 2 - selectorlist: "\[" expression "]" selectorlist;
    Production {
        lhs: 54,
        production: &[
            ParseType::N(54),
            ParseType::T(7),
            ParseType::N(45),
            ParseType::T(6),
        ],
    },
    // 3 - selectorlist: ;
    Production {
        lhs: 54,
        production: &[],
    },
    // 4 - factor: ident selector;
    Production {
        lhs: 48,
        production: &[ParseType::N(53), ParseType::N(49)],
    },
    // 5 - factor: integer;
    Production {
        lhs: 48,
        production: &[ParseType::N(50)],
    },
    // 6 - factor: "\(" expression "\)";
    Production {
        lhs: 48,
        production: &[ParseType::T(9), ParseType::N(45), ParseType::T(8)],
    },
    // 7 - factor: "~" factor;
    Production {
        lhs: 48,
        production: &[ParseType::N(48), ParseType::T(10)],
    },
    // 8 - factor: UnaryOp factor;
    Production {
        lhs: 48,
        production: &[ParseType::N(48), ParseType::N(36)],
    },
    // 9 - term: factor MulExpression;
    Production {
        lhs: 56,
        production: &[ParseType::N(17), ParseType::N(48)],
    },
    // 10 - MulExpression: MulOperator factor MulExpression;
    Production {
        lhs: 17,
        production: &[ParseType::N(17), ParseType::N(48), ParseType::N(18)],
    },
    // 11 - MulExpression: ;
    Production {
        lhs: 17,
        production: &[],
    },
    // 12 - SimpleExpression: term AddExpression;
    Production {
        lhs: 32,
        production: &[ParseType::N(2), ParseType::N(56)],
    },
    // 13 - AddExpression: AddOperator term AddExpression;
    Production {
        lhs: 2,
        production: &[ParseType::N(2), ParseType::N(56), ParseType::N(3)],
    },
    // 14 - AddExpression: ;
    Production {
        lhs: 2,
        production: &[],
    },
    // 15 - AssignOp: ":=";
    Production {
        lhs: 5,
        production: &[ParseType::T(11)],
    },
    // 16 - RelationOp: AssignOp;
    Production {
        lhs: 29,
        production: &[ParseType::N(5)],
    },
    // 17 - RelationOp: RelationalOps;
    Production {
        lhs: 29,
        production: &[ParseType::N(30)],
    },
    // 18 - RelationalOps: ">=|<=|\#|<|>";
    Production {
        lhs: 30,
        production: &[ParseType::T(12)],
    },
    // 19 - AssignOp: "=";
    Production {
        lhs: 5,
        production: &[ParseType::T(13)],
    },
    // 20 - expression: SimpleExpression expressionSuffix;
    Production {
        lhs: 45,
        production: &[ParseType::N(46), ParseType::N(32)],
    },
    // 21 - expressionSuffix: RelationOp SimpleExpression;
    Production {
        lhs: 46,
        production: &[ParseType::N(32), ParseType::N(29)],
    },
    // 22 - expressionSuffix: ;
    Production {
        lhs: 46,
        production: &[],
    },
    // 23 - assignment: ident selector AssignOp expression;
    Production {
        lhs: 39,
        production: &[
            ParseType::N(45),
            ParseType::N(5),
            ParseType::N(53),
            ParseType::N(49),
        ],
    },
    // 24 - ActualParameters: "\(" ActualParametersSuffix;
    Production {
        lhs: 0,
        production: &[ParseType::N(1), ParseType::T(8)],
    },
    // 25 - ActualParametersSuffix: "\)";
    Production {
        lhs: 1,
        production: &[ParseType::T(9)],
    },
    // 26 - ActualParametersSuffix: expression expressionlistrest "\)";
    Production {
        lhs: 1,
        production: &[ParseType::T(9), ParseType::N(47), ParseType::N(45)],
    },
    // 27 - expressionlistrest: "," expression expressionlistrest;
    Production {
        lhs: 47,
        production: &[ParseType::N(47), ParseType::N(45), ParseType::T(14)],
    },
    // 28 - expressionlistrest: ;
    Production {
        lhs: 47,
        production: &[],
    },
    // 29 - ProcedureCall: ident ProcedureCallSuffix;
    Production {
        lhs: 22,
        production: &[ParseType::N(23), ParseType::N(49)],
    },
    // 30 - ProcedureCallSuffix: ActualParameters;
    Production {
        lhs: 23,
        production: &[ParseType::N(0)],
    },
    // 31 - ProcedureCallSuffix: ;
    Production {
        lhs: 23,
        production: &[],
    },
    // 32 - IfStatement: "IF" expression "THEN" StatementSequence elseiflist IfStatementSuffix;
    Production {
        lhs: 15,
        production: &[
            ParseType::N(16),
            ParseType::N(44),
            ParseType::N(33),
            ParseType::T(16),
            ParseType::N(45),
            ParseType::T(15),
        ],
    },
    // 33 - IfStatementSuffix: "ELSE" StatementSequence "END";
    Production {
        lhs: 16,
        production: &[ParseType::T(18), ParseType::N(33), ParseType::T(17)],
    },
    // 34 - IfStatementSuffix: "END";
    Production {
        lhs: 16,
        production: &[ParseType::T(18)],
    },
    // 35 - elseiflist: "ELSIF" expression "THEN" StatementSequence elseiflist;
    Production {
        lhs: 44,
        production: &[
            ParseType::N(44),
            ParseType::N(33),
            ParseType::T(16),
            ParseType::N(45),
            ParseType::T(19),
        ],
    },
    // 36 - elseiflist: ;
    Production {
        lhs: 44,
        production: &[],
    },
    // 37 - WhileStatement: "WHILE" expression "DO" StatementSequence "END";
    Production {
        lhs: 38,
        production: &[
            ParseType::T(18),
            ParseType::N(33),
            ParseType::T(21),
            ParseType::N(45),
            ParseType::T(20),
        ],
    },
    // 38 - RepeatStatement: "REPEAT" StatementSequence "UNTIL" expression;
    Production {
        lhs: 31,
        production: &[
            ParseType::N(45),
            ParseType::T(23),
            ParseType::N(33),
            ParseType::T(22),
        ],
    },
    // 39 - statement: assignment;
    Production {
        lhs: 55,
        production: &[ParseType::N(39)],
    },
    // 40 - statement: ProcedureCall;
    Production {
        lhs: 55,
        production: &[ParseType::N(22)],
    },
    // 41 - statement: IfStatement;
    Production {
        lhs: 55,
        production: &[ParseType::N(15)],
    },
    // 42 - statement: WhileStatement;
    Production {
        lhs: 55,
        production: &[ParseType::N(38)],
    },
    // 43 - statement: RepeatStatement;
    Production {
        lhs: 55,
        production: &[ParseType::N(31)],
    },
    // 44 - statement: ;
    Production {
        lhs: 55,
        production: &[],
    },
    // 45 - StatementSequence: statement StatementSequenceRest;
    Production {
        lhs: 33,
        production: &[ParseType::N(34), ParseType::N(55)],
    },
    // 46 - StatementSequenceRest: ";" statement StatementSequenceRest;
    Production {
        lhs: 34,
        production: &[ParseType::N(34), ParseType::N(55), ParseType::T(24)],
    },
    // 47 - StatementSequenceRest: ;
    Production {
        lhs: 34,
        production: &[],
    },
    // 48 - IdentList: ident IdentListRest;
    Production {
        lhs: 13,
        production: &[ParseType::N(14), ParseType::N(49)],
    },
    // 49 - IdentListRest: "," ident IdentListRest;
    Production {
        lhs: 14,
        production: &[ParseType::N(14), ParseType::N(49), ParseType::T(14)],
    },
    // 50 - IdentListRest: ;
    Production {
        lhs: 14,
        production: &[],
    },
    // 51 - ArrayType: "ARRAY" expression "OF" type;
    Production {
        lhs: 4,
        production: &[
            ParseType::N(57),
            ParseType::T(26),
            ParseType::N(45),
            ParseType::T(25),
        ],
    },
    // 52 - FieldList: IdentList ":" type;
    Production {
        lhs: 9,
        production: &[ParseType::N(57), ParseType::T(27), ParseType::N(13)],
    },
    // 53 - FieldList: ;
    Production {
        lhs: 9,
        production: &[],
    },
    // 54 - RecordType: "RECORD" FieldList FieldListRest "END";
    Production {
        lhs: 28,
        production: &[
            ParseType::T(18),
            ParseType::N(10),
            ParseType::N(9),
            ParseType::T(28),
        ],
    },
    // 55 - FieldListRest: ";" FieldList FieldListRest;
    Production {
        lhs: 10,
        production: &[ParseType::N(10), ParseType::N(9), ParseType::T(24)],
    },
    // 56 - FieldListRest: ;
    Production {
        lhs: 10,
        production: &[],
    },
    // 57 - type: ident;
    Production {
        lhs: 57,
        production: &[ParseType::N(49)],
    },
    // 58 - type: ArrayType;
    Production {
        lhs: 57,
        production: &[ParseType::N(4)],
    },
    // 59 - type: RecordType;
    Production {
        lhs: 57,
        production: &[ParseType::N(28)],
    },
    // 60 - FPSection: "VAR" IdentList ":" type;
    Production {
        lhs: 7,
        production: &[
            ParseType::N(57),
            ParseType::T(27),
            ParseType::N(13),
            ParseType::T(29),
        ],
    },
    // 61 - FPSection: IdentList ":" type;
    Production {
        lhs: 7,
        production: &[ParseType::N(57), ParseType::T(27), ParseType::N(13)],
    },
    // 62 - FormalParameters: "\(" FormalParametersSuffix;
    Production {
        lhs: 11,
        production: &[ParseType::N(12), ParseType::T(8)],
    },
    // 63 - FormalParametersSuffix: "\)";
    Production {
        lhs: 12,
        production: &[ParseType::T(9)],
    },
    // 64 - FormalParametersSuffix: FPSection FPSectionRest "\)";
    Production {
        lhs: 12,
        production: &[ParseType::T(9), ParseType::N(8), ParseType::N(7)],
    },
    // 65 - FPSectionRest: ";" FPSection FPSectionRest;
    Production {
        lhs: 8,
        production: &[ParseType::N(8), ParseType::N(7), ParseType::T(24)],
    },
    // 66 - FPSectionRest: ;
    Production {
        lhs: 8,
        production: &[],
    },
    // 67 - ProcedureHeading: "PROCEDURE" ident ProcedureHeadingSuffix;
    Production {
        lhs: 26,
        production: &[ParseType::N(27), ParseType::N(49), ParseType::T(30)],
    },
    // 68 - ProcedureHeadingSuffix: FormalParameters;
    Production {
        lhs: 27,
        production: &[ParseType::N(11)],
    },
    // 69 - ProcedureHeadingSuffix: ;
    Production {
        lhs: 27,
        production: &[],
    },
    // 70 - ProcedureBody: declarations ProcedureBodySuffix1;
    Production {
        lhs: 19,
        production: &[ParseType::N(21), ParseType::N(40)],
    },
    // 71 - ProcedureBodySuffix1: "BEGIN" StatementSequence ProcedureBodySuffix;
    Production {
        lhs: 21,
        production: &[ParseType::N(20), ParseType::N(33), ParseType::T(31)],
    },
    // 72 - ProcedureBodySuffix1: "RETURN" expression "END" ident;
    Production {
        lhs: 21,
        production: &[
            ParseType::N(49),
            ParseType::T(18),
            ParseType::N(45),
            ParseType::T(32),
        ],
    },
    // 73 - ProcedureBodySuffix1: "END" ident;
    Production {
        lhs: 21,
        production: &[ParseType::N(49), ParseType::T(18)],
    },
    // 74 - ProcedureBodySuffix: "RETURN" expression "END" ident;
    Production {
        lhs: 20,
        production: &[
            ParseType::N(49),
            ParseType::T(18),
            ParseType::N(45),
            ParseType::T(32),
        ],
    },
    // 75 - ProcedureBodySuffix: "END" ident;
    Production {
        lhs: 20,
        production: &[ParseType::N(49), ParseType::T(18)],
    },
    // 76 - ProcedureDeclaration: ProcedureHeading ";" ProcedureBody;
    Production {
        lhs: 24,
        production: &[ParseType::N(19), ParseType::T(24), ParseType::N(26)],
    },
    // 77 - declarations: "TYPE" TypeDecls declarationsSuffix2;
    Production {
        lhs: 40,
        production: &[ParseType::N(43), ParseType::N(35), ParseType::T(33)],
    },
    // 78 - declarations: "CONST" ConstDecls declarationsSuffix1;
    Production {
        lhs: 40,
        production: &[ParseType::N(42), ParseType::N(6), ParseType::T(34)],
    },
    // 79 - declarationsSuffix2: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 43,
        production: &[ParseType::N(25), ParseType::N(37), ParseType::T(29)],
    },
    // 80 - declarationsSuffix2: ProcedureDeclarationList;
    Production {
        lhs: 43,
        production: &[ParseType::N(25)],
    },
    // 81 - declarations: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 40,
        production: &[ParseType::N(25), ParseType::N(37), ParseType::T(29)],
    },
    // 82 - declarations: ProcedureDeclarationList;
    Production {
        lhs: 40,
        production: &[ParseType::N(25)],
    },
    // 83 - declarationsSuffix1: "TYPE" TypeDecls declarationsSuffix;
    Production {
        lhs: 42,
        production: &[ParseType::N(41), ParseType::N(35), ParseType::T(33)],
    },
    // 84 - declarationsSuffix1: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 42,
        production: &[ParseType::N(25), ParseType::N(37), ParseType::T(29)],
    },
    // 85 - declarationsSuffix1: ProcedureDeclarationList;
    Production {
        lhs: 42,
        production: &[ParseType::N(25)],
    },
    // 86 - declarationsSuffix: "VAR" VarDecls ProcedureDeclarationList;
    Production {
        lhs: 41,
        production: &[ParseType::N(25), ParseType::N(37), ParseType::T(29)],
    },
    // 87 - declarationsSuffix: ProcedureDeclarationList;
    Production {
        lhs: 41,
        production: &[ParseType::N(25)],
    },
    // 88 - ProcedureDeclarationList: ProcedureDeclaration ";" ProcedureDeclarationList;
    Production {
        lhs: 25,
        production: &[ParseType::N(25), ParseType::T(24), ParseType::N(24)],
    },
    // 89 - ProcedureDeclarationList: ;
    Production {
        lhs: 25,
        production: &[],
    },
    // 90 - ConstDecls: ident AssignOp expression ";" ConstDecls;
    Production {
        lhs: 6,
        production: &[
            ParseType::N(6),
            ParseType::T(24),
            ParseType::N(45),
            ParseType::N(5),
            ParseType::N(49),
        ],
    },
    // 91 - ConstDecls: ;
    Production {
        lhs: 6,
        production: &[],
    },
    // 92 - TypeDecls: ident AssignOp type ";" TypeDecls;
    Production {
        lhs: 35,
        production: &[
            ParseType::N(35),
            ParseType::T(24),
            ParseType::N(57),
            ParseType::N(5),
            ParseType::N(49),
        ],
    },
    // 93 - TypeDecls: ;
    Production {
        lhs: 35,
        production: &[],
    },
    // 94 - VarDecls: IdentList ":" type ";" VarDecls;
    Production {
        lhs: 37,
        production: &[
            ParseType::N(37),
            ParseType::T(24),
            ParseType::N(57),
            ParseType::T(27),
            ParseType::N(13),
        ],
    },
    // 95 - VarDecls: ;
    Production {
        lhs: 37,
        production: &[],
    },
    // 96 - module: "MODULE" ident ";" declarations moduleSuffix;
    Production {
        lhs: 51,
        production: &[
            ParseType::N(52),
            ParseType::N(40),
            ParseType::T(24),
            ParseType::N(49),
            ParseType::T(35),
        ],
    },
    // 97 - moduleSuffix: "BEGIN" StatementSequence "END" ident "\.";
    Production {
        lhs: 52,
        production: &[
            ParseType::T(5),
            ParseType::N(49),
            ParseType::T(18),
            ParseType::N(33),
            ParseType::T(31),
        ],
    },
    // 98 - moduleSuffix: "END" ident "\.";
    Production {
        lhs: 52,
        production: &[ParseType::T(5), ParseType::N(49), ParseType::T(18)],
    },
    // 99 - MulOperator: "\*|/|DIV|MOD|&";
    Production {
        lhs: 18,
        production: &[ParseType::T(36)],
    },
    // 100 - AddOperator: "\+|-|OR";
    Production {
        lhs: 3,
        production: &[ParseType::T(37)],
    },
    // 101 - UnaryOp: "\+|-";
    Production {
        lhs: 36,
        production: &[ParseType::T(38)],
    },
    // 102 - ident: "[a-zA-Z][a-zA-Z0-9]*";
    Production {
        lhs: 49,
        production: &[ParseType::T(39)],
    },
    // 103 - integer: "[0-9]+";
    Production {
        lhs: 50,
        production: &[ParseType::T(40)],
    },
];

lazy_static! {
    static ref TOKENIZER: Tokenizer = Tokenizer::build(TERMINALS).unwrap();
}

pub fn parse(
    input: &str,
    file_name: String,
    user_actions: &mut dyn UserActionsTrait,
) -> Result<Tree<ParseTreeType>> {
    let mut llk_parser = LLKParser::new(
        51,
        LOOKAHEAD_AUTOMATA,
        PRODUCTIONS,
        TERMINAL_NAMES,
        NON_TERMINALS,
    );
    let token_stream = RefCell::new(TokenStream::new(input, file_name, &TOKENIZER, MAX_K).unwrap());
    let result = llk_parser.parse(&token_stream, user_actions);
    match result {
        Ok(()) => Ok(llk_parser.parse_tree),
        Err(e) => Err(e),
    }
}
