use crate::errors::ParclMathErrorCode;
use anchor_lang::prelude::*;

pub trait TrySub: Sized {
    fn try_sub(self, rhs: Self) -> Result<Self>;
}

pub trait TryAdd: Sized {
    fn try_add(self, rhs: Self) -> Result<Self>;
}

pub trait TryDiv<T>: Sized {
    fn try_div(self, rhs: T) -> Result<Self>;
}

pub trait TryMul<T>: Sized {
    fn try_mul(self, rhs: T) -> Result<Self>;
}

pub trait TryRem<T>: Sized {
    fn try_rem(self, rhs: T) -> Result<Self>;
}

impl TryAdd for u128 {
    fn try_add(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_add(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TrySub for u128 {
    fn try_sub(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_sub(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryMul<u128> for u128 {
    fn try_mul(self, rhs: u128) -> Result<Self> {
        let val = self
            .checked_mul(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryDiv<u128> for u128 {
    fn try_div(self, rhs: u128) -> Result<Self> {
        let val = self
            .checked_div(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryRem<u128> for u128 {
    fn try_rem(self, rhs: u128) -> Result<Self> {
        let val = self
            .checked_rem(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryAdd for u64 {
    fn try_add(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_add(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TrySub for u64 {
    fn try_sub(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_sub(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryMul<u64> for u64 {
    fn try_mul(self, rhs: u64) -> Result<Self> {
        let val = self
            .checked_mul(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryDiv<u64> for u64 {
    fn try_div(self, rhs: u64) -> Result<Self> {
        let val = self
            .checked_div(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryRem<u64> for u64 {
    fn try_rem(self, rhs: u64) -> Result<Self> {
        let val = self
            .checked_rem(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryAdd for u32 {
    fn try_add(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_add(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TrySub for u32 {
    fn try_sub(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_sub(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryMul<u32> for u32 {
    fn try_mul(self, rhs: u32) -> Result<Self> {
        let val = self
            .checked_mul(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryDiv<u32> for u32 {
    fn try_div(self, rhs: u32) -> Result<Self> {
        let val = self
            .checked_div(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryRem<u32> for u32 {
    fn try_rem(self, rhs: u32) -> Result<Self> {
        let val = self
            .checked_rem(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryAdd for i128 {
    fn try_add(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_add(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TrySub for i128 {
    fn try_sub(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_sub(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryMul<i128> for i128 {
    fn try_mul(self, rhs: i128) -> Result<Self> {
        let val = self
            .checked_mul(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryDiv<i128> for i128 {
    fn try_div(self, rhs: i128) -> Result<Self> {
        let val = self
            .checked_div(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryRem<i128> for i128 {
    fn try_rem(self, rhs: i128) -> Result<Self> {
        let val = self
            .checked_rem(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryAdd for i64 {
    fn try_add(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_add(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TrySub for i64 {
    fn try_sub(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_sub(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryMul<i64> for i64 {
    fn try_mul(self, rhs: i64) -> Result<Self> {
        let val = self
            .checked_mul(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryDiv<i64> for i64 {
    fn try_div(self, rhs: i64) -> Result<Self> {
        let val = self
            .checked_div(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryRem<i64> for i64 {
    fn try_rem(self, rhs: i64) -> Result<Self> {
        let val = self
            .checked_rem(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryAdd for i32 {
    fn try_add(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_add(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TrySub for i32 {
    fn try_sub(self, rhs: Self) -> Result<Self> {
        let val = self
            .checked_sub(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryMul<i32> for i32 {
    fn try_mul(self, rhs: i32) -> Result<Self> {
        let val = self
            .checked_mul(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryDiv<i32> for i32 {
    fn try_div(self, rhs: i32) -> Result<Self> {
        let val = self
            .checked_div(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}

impl TryRem<i32> for i32 {
    fn try_rem(self, rhs: i32) -> Result<Self> {
        let val = self
            .checked_rem(rhs)
            .ok_or(ParclMathErrorCode::IntegerOverflow)?;
        Ok(val)
    }
}
