//! Type conversion functions.
use crate::errors::ParclMathErrorCode;
use anchor_lang::prelude::*;
use std::convert::TryInto;

/// Returns value cast to i32.
pub fn to_i32(value: impl TryInto<i32>) -> Result<i32> {
    value
        .try_into()
        .map_err(|_| error!(ParclMathErrorCode::ConversionError))
}

/// Returns value cast to i64.
pub fn to_i64(value: impl TryInto<i64>) -> Result<i64> {
    value
        .try_into()
        .map_err(|_| error!(ParclMathErrorCode::ConversionError))
}

/// Returns value cast to i128.
pub fn to_i128(value: impl TryInto<i128>) -> Result<i128> {
    value
        .try_into()
        .map_err(|_| error!(ParclMathErrorCode::ConversionError))
}

/// Returns value cast to u32.
pub fn to_u32(value: impl TryInto<u32>) -> Result<u32> {
    value
        .try_into()
        .map_err(|_| error!(ParclMathErrorCode::ConversionError))
}

/// Returns value cast to u64.
pub fn to_u64(value: impl TryInto<u64>) -> Result<u64> {
    value
        .try_into()
        .map_err(|_| error!(ParclMathErrorCode::ConversionError))
}

/// Returns value cast to u128.
pub fn to_u128(value: impl TryInto<u128>) -> Result<u128> {
    value
        .try_into()
        .map_err(|_| error!(ParclMathErrorCode::ConversionError))
}
