// This file is autogenerated by build-prefixes.js. DO NOT EDIT!

use crate::vendor_prefix::VendorPrefix;
use crate::targets::Browsers;

#[allow(dead_code)]
pub enum Feature {
  AlignContent,
  AlignItems,
  AlignSelf,
  Animation,
  AnimationDelay,
  AnimationDirection,
  AnimationDuration,
  AnimationFillMode,
  AnimationIterationCount,
  AnimationName,
  AnimationPlayState,
  AnimationTimingFunction,
  Appearance,
  AtKeyframes,
  AtResolution,
  AtViewport,
  BackdropFilter,
  BackfaceVisibility,
  BackgroundClip,
  BackgroundOrigin,
  BackgroundSize,
  BorderBlockEnd,
  BorderBlockStart,
  BorderBottomLeftRadius,
  BorderBottomRightRadius,
  BorderImage,
  BorderInlineEnd,
  BorderInlineStart,
  BorderRadius,
  BorderTopLeftRadius,
  BorderTopRightRadius,
  BoxDecorationBreak,
  BoxShadow,
  BoxSizing,
  BreakAfter,
  BreakBefore,
  BreakInside,
  Calc,
  ClipPath,
  ColorAdjust,
  ColumnCount,
  ColumnFill,
  ColumnGap,
  ColumnRule,
  ColumnRuleColor,
  ColumnRuleStyle,
  ColumnRuleWidth,
  ColumnSpan,
  ColumnWidth,
  Columns,
  CrossFade,
  DisplayFlex,
  DisplayGrid,
  Element,
  Fill,
  FillAvailable,
  Filter,
  FilterFunction,
  FitContent,
  Flex,
  FlexBasis,
  FlexDirection,
  FlexFlow,
  FlexGrow,
  FlexShrink,
  FlexWrap,
  FlowFrom,
  FlowInto,
  FontFeatureSettings,
  FontKerning,
  FontLanguageOverride,
  FontVariantLigatures,
  Grab,
  Grabbing,
  GridArea,
  GridColumn,
  GridColumnAlign,
  GridColumnEnd,
  GridColumnStart,
  GridRow,
  GridRowAlign,
  GridRowEnd,
  GridRowStart,
  GridTemplate,
  GridTemplateAreas,
  GridTemplateColumns,
  GridTemplateRows,
  Hyphens,
  ImageRendering,
  ImageSet,
  InlineFlex,
  InlineGrid,
  Isolate,
  IsolateOverride,
  JustifyContent,
  LinearGradient,
  MarginBlockEnd,
  MarginBlockStart,
  MarginInlineEnd,
  MarginInlineStart,
  Mask,
  MaskBorder,
  MaskBorderOutset,
  MaskBorderRepeat,
  MaskBorderSlice,
  MaskBorderSource,
  MaskBorderWidth,
  MaskClip,
  MaskComposite,
  MaskImage,
  MaskOrigin,
  MaskPosition,
  MaskRepeat,
  MaskSize,
  MaxContent,
  MinContent,
  ObjectFit,
  ObjectPosition,
  Order,
  OverscrollBehavior,
  PaddingBlockEnd,
  PaddingBlockStart,
  PaddingInlineEnd,
  PaddingInlineStart,
  Perspective,
  PerspectiveOrigin,
  Pixelated,
  PlaceSelf,
  Plaintext,
  PseudoClassAnyLink,
  PseudoClassAutofill,
  PseudoClassFullscreen,
  PseudoClassPlaceholderShown,
  PseudoClassReadOnly,
  PseudoClassReadWrite,
  PseudoElementBackdrop,
  PseudoElementFileSelectorButton,
  PseudoElementPlaceholder,
  PseudoElementSelection,
  RadialGradient,
  RegionFragment,
  RepeatingLinearGradient,
  RepeatingRadialGradient,
  ScrollSnapCoordinate,
  ScrollSnapDestination,
  ScrollSnapPointsX,
  ScrollSnapPointsY,
  ScrollSnapType,
  ShapeImageThreshold,
  ShapeMargin,
  ShapeOutside,
  Sticky,
  Stretch,
  TabSize,
  TextAlignLast,
  TextDecoration,
  TextDecorationColor,
  TextDecorationLine,
  TextDecorationSkip,
  TextDecorationSkipInk,
  TextDecorationStyle,
  TextEmphasis,
  TextEmphasisColor,
  TextEmphasisPosition,
  TextEmphasisStyle,
  TextOrientation,
  TextOverflow,
  TextSizeAdjust,
  TextSpacing,
  TouchAction,
  Transform,
  TransformOrigin,
  TransformStyle,
  Transition,
  TransitionDelay,
  TransitionDuration,
  TransitionProperty,
  TransitionTimingFunction,
  UserSelect,
  WritingMode,
  ZoomIn,
  ZoomOut
}

impl Feature {
  pub fn prefixes_for(&self, browsers: Browsers) -> VendorPrefix {
    let mut prefixes = VendorPrefix::None;
    match self {
      Feature::BorderRadius |
      Feature::BorderTopLeftRadius |
      Feature::BorderTopRightRadius |
      Feature::BorderBottomRightRadius |
      Feature::BorderBottomLeftRadius => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 131328 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 198144 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 197120 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BoxShadow => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 196608 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 589824 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 197888 && version <= 198144 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 327680 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Animation |
      Feature::AnimationName |
      Feature::AnimationDuration |
      Feature::AnimationDelay |
      Feature::AnimationDirection |
      Feature::AnimationFillMode |
      Feature::AnimationIterationCount |
      Feature::AnimationPlayState |
      Feature::AnimationTimingFunction |
      Feature::AtKeyframes => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 2752512 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 327680 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 786432 && version <= 786432 {
            prefixes |= VendorPrefix::O;
          }
          if version >= 983040 && version <= 1900544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Transition |
      Feature::TransitionProperty |
      Feature::TransitionDuration |
      Feature::TransitionDelay |
      Feature::TransitionTimingFunction => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 1638400 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 655360 && version <= 786432 {
            prefixes |= VendorPrefix::O;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Transform |
      Feature::TransformOrigin => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 2293760 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 197888 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 589824 && version <= 589824 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 656640 && version <= 786432 {
            prefixes |= VendorPrefix::O;
          }
          if version >= 983040 && version <= 1441792 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Perspective |
      Feature::PerspectiveOrigin |
      Feature::TransformStyle => {
        if let Some(version) = browsers.android {
          if version >= 196608 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 786432 && version <= 2293760 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 655360 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 1441792 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BackfaceVisibility => {
        if let Some(version) = browsers.android {
          if version >= 196608 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 786432 && version <= 2293760 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 655360 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 1441792 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::LinearGradient |
      Feature::RepeatingLinearGradient |
      Feature::RadialGradient |
      Feature::RepeatingRadialGradient => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 1638400 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 198144 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 721152 && version <= 786432 {
            prefixes |= VendorPrefix::O;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BoxSizing => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 196608 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 589824 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 1835008 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 327680 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Filter => {
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1179648 && version <= 3407872 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 393216 && version <= 589824 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2555904 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393216 && version <= 589824 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 393728 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::FilterFunction => {
        if let Some(version) = browsers.ios_saf {
          if version >= 589824 && version <= 590592 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 589824 && version <= 589824 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BackdropFilter => {
        if let Some(version) = browsers.edge {
          if version >= 1114112 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 589824 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 589824 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Element => {
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 6225920 {
            prefixes |= VendorPrefix::Moz;
          }
        }
      },
      Feature::Columns |
      Feature::ColumnWidth |
      Feature::ColumnGap |
      Feature::ColumnRule |
      Feature::ColumnRuleColor |
      Feature::ColumnRuleWidth |
      Feature::ColumnCount |
      Feature::ColumnRuleStyle |
      Feature::ColumnSpan |
      Feature::ColumnFill => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 3211264 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 3342336 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2359296 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BreakBefore |
      Feature::BreakAfter |
      Feature::BreakInside => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 3211264 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2359296 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::UserSelect => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 3473408 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 4456448 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2621440 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 327680 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::DisplayFlex |
      Feature::InlineFlex |
      Feature::Flex |
      Feature::FlexGrow |
      Feature::FlexShrink |
      Feature::FlexBasis |
      Feature::FlexDirection |
      Feature::FlexWrap |
      Feature::FlexFlow |
      Feature::JustifyContent |
      Feature::Order |
      Feature::AlignItems |
      Feature::AlignSelf |
      Feature::AlignContent => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 1835008 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 1376256 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 655360 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 1048576 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Calc => {
        if let Some(version) = browsers.chrome {
          if version >= 1245184 && version <= 1638400 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 393216 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393216 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BackgroundOrigin |
      Feature::BackgroundSize => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 131840 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 198144 && version <= 198144 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 655360 && version <= 655360 {
            prefixes |= VendorPrefix::O;
          }
        }
      },
      Feature::BackgroundClip => {
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 262144 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 917504 {
            prefixes |= VendorPrefix::Ms;
          }
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 393216 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::FontFeatureSettings |
      Feature::FontVariantLigatures |
      Feature::FontLanguageOverride => {
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1048576 && version <= 3080192 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 262144 && version <= 2162688 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2228224 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::FontKerning => {
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263168 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1900544 && version <= 2097152 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 524288 && version <= 721664 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 1048576 && version <= 1245184 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 458752 && version <= 589824 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BorderImage => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 917504 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 197888 && version <= 917504 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 327680 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 720896 && version <= 786688 {
            prefixes |= VendorPrefix::O;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 327936 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoElementSelection => {
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 3997696 {
            prefixes |= VendorPrefix::Moz;
          }
        }
      },
      Feature::PseudoElementPlaceholder => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 3670016 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 1179648 && version <= 3276800 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 262656 && version <= 655360 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2818048 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 327680 && version <= 655360 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 393728 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoClassPlaceholderShown => {
        if let Some(version) = browsers.firefox {
          if version >= 262144 && version <= 3276800 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
      },
      Feature::Hyphens => {
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 393216 && version <= 2752512 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 262656 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 327936 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoClassFullscreen => {
        if let Some(version) = browsers.chrome {
          if version >= 983040 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 655360 && version <= 4128768 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 720896 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 4128768 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 327936 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 590336 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoElementBackdrop => {
        if let Some(version) = browsers.chrome {
          if version >= 1310720 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 4128768 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393216 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 590336 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoElementFileSelectorButton => {
        if let Some(version) = browsers.chrome {
          if version >= 65536 && version <= 5767168 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 786432 {
            prefixes |= VendorPrefix::Ms;
          }
          if version >= 5767168 && version <= 5767168 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196608 && version <= 917504 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 65536 && version <= 917504 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 4849664 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 65536 && version <= 917504 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoClassAutofill => {
        if let Some(version) = browsers.chrome {
          if version >= 131072 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 131072 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 131072 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 655616 && version <= 4259840 {
            prefixes |= VendorPrefix::O;
          }
          if version >= 983040 && version <= 5308416 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 131072 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 131328 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TabSize => {
        if let Some(version) = browsers.firefox {
          if version >= 262144 && version <= 6029312 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 656896 && version <= 786688 {
            prefixes |= VendorPrefix::O;
          }
        }
      },
      Feature::MaxContent |
      Feature::MinContent => {
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1441792 && version <= 2949120 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 196608 && version <= 4259840 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 458752 && version <= 852992 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2097152 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 655616 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Fill |
      Feature::FillAvailable => {
        if let Some(version) = browsers.chrome {
          if version >= 1441792 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 196608 && version <= 4259840 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 458752 && version <= 852992 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 655616 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Stretch |
      Feature::FitContent => {
        if let Some(version) = browsers.firefox {
          if version >= 196608 && version <= 6225920 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1441792 && version <= 2949120 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 458752 && version <= 852992 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2097152 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 655616 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::ZoomIn |
      Feature::ZoomOut => {
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 2359296 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 1507328 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 1507328 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Grab |
      Feature::Grabbing => {
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 4390912 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 1703936 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 3538944 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 655616 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Sticky => {
        if let Some(version) = browsers.ios_saf {
          if version >= 393216 && version <= 786944 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 786688 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TouchAction => {
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 655360 {
            prefixes |= VendorPrefix::Ms;
          }
        }
      },
      Feature::TextDecorationStyle |
      Feature::TextDecorationColor |
      Feature::TextDecorationLine |
      Feature::TextDecoration => {
        if let Some(version) = browsers.chrome {
          if version >= 1703936 && version <= 3670016 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 393216 && version <= 2293760 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 524288 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 2293760 && version <= 2818048 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 459008 && version <= 786432 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TextDecorationSkip |
      Feature::TextDecorationSkipInk => {
        if let Some(version) = browsers.ios_saf {
          if version >= 524288 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 459008 && version <= 786432 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TextSizeAdjust => {
        if let Some(version) = browsers.firefox {
          if version >= 6029312 && version <= 6029312 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 327680 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::MaskClip |
      Feature::MaskComposite |
      Feature::MaskImage |
      Feature::MaskOrigin |
      Feature::MaskRepeat |
      Feature::MaskBorderRepeat |
      Feature::MaskBorderSource |
      Feature::Mask |
      Feature::MaskPosition |
      Feature::MaskSize |
      Feature::MaskBorder |
      Feature::MaskBorderOutset |
      Feature::MaskBorderWidth |
      Feature::MaskBorderSlice => {
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::ClipPath => {
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1572864 && version <= 3538944 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 458752 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2686976 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 458752 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BoxDecorationBreak => {
        if let Some(version) = browsers.chrome {
          if version >= 1441792 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 458752 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::ObjectFit |
      Feature::ObjectPosition => {
        if let Some(version) = browsers.opera {
          if version >= 656896 && version <= 786688 {
            prefixes |= VendorPrefix::O;
          }
        }
      },
      Feature::ShapeMargin |
      Feature::ShapeOutside |
      Feature::ShapeImageThreshold => {
        if let Some(version) = browsers.ios_saf {
          if version >= 524288 && version <= 655360 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 459008 && version <= 655360 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TextOverflow => {
        if let Some(version) = browsers.opera {
          if version >= 589824 && version <= 786432 {
            prefixes |= VendorPrefix::O;
          }
        }
      },
      Feature::AtViewport => {
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 720896 && version <= 786688 {
            prefixes |= VendorPrefix::O;
          }
        }
      },
      Feature::AtResolution => {
        if let Some(version) = browsers.android {
          if version >= 131840 && version <= 262656 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 1835008 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 197888 && version <= 983040 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 591104 && version <= 786432 {
            prefixes |= VendorPrefix::O;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TextAlignLast => {
        if let Some(version) = browsers.firefox {
          if version >= 786432 && version <= 3145728 {
            prefixes |= VendorPrefix::Moz;
          }
        }
      },
      Feature::Pixelated => {
        if let Some(version) = browsers.firefox {
          if version >= 198144 && version <= 6029312 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 327680 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 722432 && version <= 786688 {
            prefixes |= VendorPrefix::O;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393216 && version <= 393216 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::ImageRendering => {
        if let Some(version) = browsers.ie {
          if version >= 458752 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
      },
      Feature::BorderInlineStart |
      Feature::BorderInlineEnd |
      Feature::MarginInlineStart |
      Feature::MarginInlineEnd |
      Feature::PaddingInlineStart |
      Feature::PaddingInlineEnd => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 4456448 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 196608 && version <= 2621440 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 786432 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 3604480 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 786432 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 590336 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::BorderBlockStart |
      Feature::BorderBlockEnd |
      Feature::MarginBlockStart |
      Feature::MarginBlockEnd |
      Feature::PaddingBlockStart |
      Feature::PaddingBlockEnd => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 4456448 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 786432 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 3604480 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 786432 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 590336 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Appearance => {
        if let Some(version) = browsers.android {
          if version >= 131328 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 262144 && version <= 5439488 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
          if version >= 5177344 && version <= 5439488 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 131072 && version <= 5177344 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 720896 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 197120 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 4718592 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 196864 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::ScrollSnapType |
      Feature::ScrollSnapCoordinate |
      Feature::ScrollSnapDestination |
      Feature::ScrollSnapPointsX |
      Feature::ScrollSnapPointsY => {
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 589824 && version <= 656128 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 589824 && version <= 655616 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::FlowInto |
      Feature::FlowFrom |
      Feature::RegionFragment => {
        if let Some(version) = browsers.chrome {
          if version >= 983040 && version <= 1179648 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 458752 && version <= 720896 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 720896 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::ImageSet => {
        if let Some(version) = browsers.chrome {
          if version >= 1376256 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 393216 && version <= 590592 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393216 && version <= 590080 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::WritingMode => {
        if let Some(version) = browsers.android {
          if version >= 196608 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 524288 && version <= 3080192 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 328960 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 327680 && version <= 656128 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 2228224 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 327936 && version <= 655616 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 262144 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::CrossFade => {
        if let Some(version) = browsers.chrome {
          if version >= 1114112 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 327680 && version <= 590592 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 327936 && version <= 590080 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::PseudoClassReadOnly |
      Feature::PseudoClassReadWrite => {
        if let Some(version) = browsers.firefox {
          if version >= 196608 && version <= 5046272 {
            prefixes |= VendorPrefix::Moz;
          }
        }
      },
      Feature::TextEmphasis |
      Feature::TextEmphasisPosition |
      Feature::TextEmphasisStyle |
      Feature::TextEmphasisColor => {
        if let Some(version) = browsers.chrome {
          if version >= 1638400 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 458752 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 262144 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::DisplayGrid |
      Feature::InlineGrid |
      Feature::GridTemplateColumns |
      Feature::GridTemplateRows |
      Feature::GridRowStart |
      Feature::GridColumnStart |
      Feature::GridRowEnd |
      Feature::GridColumnEnd |
      Feature::GridRow |
      Feature::GridColumn |
      Feature::GridArea |
      Feature::GridTemplate |
      Feature::GridTemplateAreas |
      Feature::PlaceSelf |
      Feature::GridColumnAlign |
      Feature::GridRowAlign => {
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 983040 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
      },
      Feature::TextSpacing => {
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1179648 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 524288 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
      },
      Feature::PseudoClassAnyLink => {
        if let Some(version) = browsers.android {
          if version >= 263168 && version <= 263171 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 983040 && version <= 4194304 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 196608 && version <= 3211264 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 393216 && version <= 524544 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 3342336 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393472 && version <= 524288 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.samsung {
          if version >= 327680 && version <= 524800 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Isolate => {
        if let Some(version) = browsers.chrome {
          if version >= 1114112 && version <= 3080192 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.firefox {
          if version >= 655360 && version <= 3211264 {
            prefixes |= VendorPrefix::Moz;
          }
        }
        if let Some(version) = browsers.ios_saf {
          if version >= 589824 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 589824 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::Plaintext => {
        if let Some(version) = browsers.firefox {
          if version >= 655360 && version <= 3211264 {
            prefixes |= VendorPrefix::Moz;
          }
        }
      },
      Feature::IsolateOverride => {
        if let Some(version) = browsers.firefox {
          if version >= 1114112 && version <= 3211264 {
            prefixes |= VendorPrefix::Moz;
          }
        }
      },
      Feature::OverscrollBehavior => {
        if let Some(version) = browsers.edge {
          if version >= 786432 && version <= 1114112 {
            prefixes |= VendorPrefix::Ms;
          }
        }
        if let Some(version) = browsers.ie {
          if version >= 655360 && version <= 720896 {
            prefixes |= VendorPrefix::Ms;
          }
        }
      },
      Feature::ColorAdjust => {
        if let Some(version) = browsers.android {
          if version >= 6160384 && version <= 6160384 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.chrome {
          if version >= 1245184 && version <= 6422528 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.edge {
          if version >= 5177344 && version <= 6225920 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.opera {
          if version >= 983040 && version <= 5242880 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
        if let Some(version) = browsers.safari {
          if version >= 393216 && version <= 983040 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      },
      Feature::TextOrientation => {
        if let Some(version) = browsers.safari {
          if version >= 655616 && version <= 852224 {
            prefixes |= VendorPrefix::WebKit;
          }
        }
      }
    }
    prefixes
  }
}

pub fn is_flex_2009(browsers: Browsers) -> bool {
  if let Some(version) = browsers.android {
    if version >= 131328 && version <= 262656 {
      return true;
    }
  }
  if let Some(version) = browsers.chrome {
    if version >= 262144 && version <= 1310720 {
      return true;
    }
  }
  if let Some(version) = browsers.ios_saf {
    if version >= 197120 && version <= 393216 {
      return true;
    }
  }
  if let Some(version) = browsers.safari {
    if version >= 196864 && version <= 393216 {
      return true;
    }
  }
  false
}

pub fn is_webkit_gradient(browsers: Browsers) -> bool {
  if let Some(version) = browsers.android {
    if version >= 131328 && version <= 196608 {
      return true;
    }
  }
  if let Some(version) = browsers.chrome {
    if version >= 262144 && version <= 589824 {
      return true;
    }
  }
  if let Some(version) = browsers.ios_saf {
    if version >= 197120 && version <= 393216 {
      return true;
    }
  }
  if let Some(version) = browsers.safari {
    if version >= 262144 && version <= 393216 {
      return true;
    }
  }
  false
}
