//! Contains reexported crates and types used by the code generated by the lexer and parser macros,
//! as well as a prelude with some internal types.
//!
//! This way, the generated code can simply `use parce::internal_prelude::*` and not worry about it.
//! The user should not need to use this module directly,
//! and instead using `use parce::prelude::*` should be sufficient.

pub use lazy_static::lazy_static;
pub use regex::Regex;
pub use tinyvec::{tiny_vec, array_vec, TinyVec, ArrayVec};
pub use inventory;

pub use crate::parser::{*, automata::*};
pub use crate::lexer::*;

pub use core::any::TypeId as Rule;
