pub fn quote_string(input: impl AsRef<[u8]>, should_escape: impl Fn(u8) -> bool) -> Vec<u8> {
    let input = input.as_ref();
    let mut ret = Vec::with_capacity(input.len() + 2);

    ret.push(b'\x22');
    for c in input {
        if should_escape(*c) {
            ret.push(b'\\');
        }
        ret.push(*c);
    }
    ret.push(b'\x22');

    ret
}
