use super::rfc3501::is_quoted_specials;

pub fn quote_string(input: impl AsRef<[u8]>) -> Vec<u8> {
    let input = input.as_ref();
    let mut ret = Vec::with_capacity(input.len() + 2);

    ret.push(b'\x22');
    for c in input {
        if is_quoted_specials(*c) {
            ret.push(b'\\');
        }
        ret.push(*c);
    }
    ret.push(b'\x22');

    ret
}
