use std::sync::Arc;

use anyhow::Result;
use tokio::io::{AsyncRead, AsyncWrite};
use tokio_rustls::{
    client::TlsStream, rustls::ClientConfig as RustlsConfig, webpki::DNSNameRef, TlsConnector,
};

pub async fn upgrade<C>(c: C, hostname: impl AsRef<str>) -> Result<TlsStream<C>>
where
    C: AsyncRead + AsyncWrite + Unpin,
{
    let server_name = hostname.as_ref();

    let mut tls_config = RustlsConfig::new();
    tls_config
        .root_store
        .add_server_trust_anchors(&webpki_roots::TLS_SERVER_ROOTS);
    let tls_config = TlsConnector::from(Arc::new(tls_config));
    let dnsname = DNSNameRef::try_from_ascii_str(server_name).unwrap();
    let stream = tls_config.connect(dnsname, c).await?;

    Ok(stream)
}
