//! High-level IMAP Client
//! ---
//!
//! ```no_run
//! # use panorama_imap::client::Config;
//! # async fn client() -> anyhow::Result<()> {
//! let client = Config::builder()
//!     .hostname("your.domain".to_owned())
//!     .port(993)
//!     .open().await?;
//! # Ok(())
//! # }
//! ```

#[macro_use]
mod macros;

pub mod auth;
pub mod configurable_cert_verifier;
pub mod response_stream;

mod client;
mod codec;
mod inner;
mod upgrade;

pub use self::client::{ClientAuthenticated, ClientUnauthenticated, Config, ConfigBuilder};
pub use self::codec::{ImapCodec, TaggedCommand};

#[cfg(feature = "low-level")]
pub use self::inner::Inner;
