use tokio::io::{AsyncRead, AsyncWrite};

use anyhow::Result;

use crate::client::inner::Inner;
use crate::proto::{
    bytes::Bytes,
    command::{Command, CommandLogin},
};

pub trait Client: AsyncRead + AsyncWrite + Unpin + Sync + Send + 'static {}
impl<C> Client for C where C: Send + Sync + Unpin + AsyncWrite + AsyncRead + 'static {}

#[async_trait]
pub trait AuthMethod {
    async fn perform_auth<C>(&self, inner: &mut Inner<C>) -> Result<()>
    where
        C: Client;
}

pub struct Login {
    pub username: String,
    pub password: String,
}

#[async_trait]
impl AuthMethod for Login {
    async fn perform_auth<C>(&self, inner: &mut Inner<C>) -> Result<()>
    where
        C: Client,
    {
        let command = Command::Login(CommandLogin {
            userid: Bytes::from(self.username.clone()),
            password: Bytes::from(self.password.clone()),
        });

        let result = inner.execute(command).await?;
        info!("result: {:?}", result.wait().await?);

        Ok(())
    }
}
