use crate::proto::bytes::Bytes;

#[derive(Clone, Debug)]
pub enum Command {
    // Any state
    Capability,
    Noop,
    Logout,

    // Not authenticated
    Login(CommandLogin),
    Starttls,
    Authenticate,

    // Authenticated
    Select(CommandSelect),
    Examine,
    Create,
    Delete,
    Rename,
    Subscribe,
    Unsubscribe,
    List(CommandList),
    Lsub,
    Status,
    Append,

    // Selected
    Check,
    Close,
    Expunge,
    Search,
    Copy,
    Fetch(CommandFetch),
    Store,
    UidCopy,
    UidFetch(CommandFetch),
    UidStore,
    UidSearch(CommandSearch),

    // Extensions
    #[cfg(feature = "rfc2177")]
    Idle,
    #[cfg(feature = "rfc2177")]
    Done,
}

#[derive(Clone, Debug)]
pub struct CommandFetch {
    pub ids: Vec<u32>,
    pub items: FetchItems,
}

#[derive(Clone, Debug)]
pub struct CommandList {
    pub reference: Bytes,
    pub mailbox: Bytes,
}

#[derive(Clone, Debug)]
pub struct CommandLogin {
    pub username: Bytes,
    pub password: Bytes,
}

#[derive(Clone, Debug)]
pub struct CommandSearch {
    pub criteria: SearchCriteria,
}

#[derive(Clone, Debug)]
pub struct CommandSelect {
    pub mailbox: Bytes,
}

//

#[derive(Clone, Debug)]
pub enum FetchItems {
    All,
    Fast,
    Full,
    BodyPeek,
    Items(Vec<FetchAttr>),
    /// item set that panorama uses, TODO: remove when FetchItems has a builder
    PanoramaAll,
}

#[derive(Clone, Debug)]
pub enum FetchAttr {}

#[derive(Clone, Debug)]
pub enum SearchCriteria {
    All,
}
