macro_rules! client_expose {
    (
        async
        $fn_name:ident
        $(< $($lifetime:lifetime)* >)?
        ( $($arg_name:ident : $ty:ty),* $(,)? )
        $(-> $ret:ty)?
    ) => {
        #[allow(dead_code)]
        async fn $fn_name $(< $($lifetime)* >)? (&mut self, $($arg_name : $ty,)*) $(-> $ret)? {
            match self {
                Self::Encrypted(inner) => inner.$fn_name($($arg_name,)*).await,
                Self::Unencrypted(inner) => inner.$fn_name($($arg_name,)*).await,
            }
        }
    };
}
