pub enum Command<'a> {
    // Any state
    Capability,
    Noop,
    Logout,

    // Not authenticated
    Login(CommandLogin<'a>),
    Starttls,
    Authenticate,

    // Authenticated
    Select,
    Examine,
    Create,
    Delete,
    Rename,
    Subscribe,
    Unsubscribe,
    List,
    Lsub,
    Status,
    Append,

    // Selected
    Check,
    Close,
    Expunge,
    Search,
    Fetch,
    Store,
    Copy,
    Uid,

    // Extensions
    #[cfg(feature = "rfc2177-idle")]
    Idle,
}

pub struct CommandLogin<'a> {
    pub username: &'a str,
    pub password: &'a str,
}
