use tokio::io::{AsyncRead, AsyncWrite};

use crate::client::inner::Inner;
use crate::proto::command::{Command, CommandLogin};

pub trait Client: AsyncRead + AsyncWrite + Unpin + Sync + Send + 'static {}

#[async_trait]
pub trait AuthMethod {
    async fn perform_auth<C>(&self, inner: &mut Inner<C>)
    where
        C: Client;
}

pub struct Login {
    pub username: String,
    pub password: String,
}

#[async_trait]
impl AuthMethod for Login {
    async fn perform_auth<C>(&self, inner: &mut Inner<C>)
    where
        C: Client,
    {
        let command = Command::Login(CommandLogin {
            username: &self.username,
            password: &self.password,
        });

        let _result = inner.execute(command).await;
    }
}
