# General Mathematics Library for Rust,Inspired by Python Pandas Library.

## Examples

```rust
    use pandas_rs::pandas::Pd;
    let mut df = Pd::read_csv("./dataset/rows.csv").unwrap(); //read csv file
    let col = Pd::get_column_by_index(&df, 3); //return sum of column values
    let col = Pd::get_column(&df, "Station Latitude"); //return sum of column values
    let row = Pd::get_row_by_index(&df, 0); //return the index of rows
    let sum_col = Pd::sum_column(&df, "Station Latitude"); //return sum of column values
    let sum_row = Pd::sum_row(&df, 0); //return sum of column values
    let unique = Pd::unique(&col);
    
    // Delete all rows with missing values
    let new_df = Pd::dropna(&df, "any");

    println!("after dropna:{:?}", &new_df.len()); // after dropna operation

    println!("head:{:?}", Pd::head(&df)); //return the head 5 of csv_vec
    println!("tail:{:?}", Pd::tail(&df, 5)); //return the from tail 5 element of csv_vec
    println!("{:?}", col); // return the column  "Station Latitude"
    println!("{:?}", row); // return the column  "Station Latitude"
    println!("{:?}", sum_col); // return sum of  the column "Station Latitude"
    println!("{:?}", sum_row); // return sum of  the column "Station Latitude"
    println!("{:?}", unique); // return unique element of the column
```
