/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const _STDIO_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const PANDA_CORE_NAME: &'static [u8; 5usize] = b"core\0";
pub const PANDA_MSG_PREFIX: &'static [u8; 7usize] = b"PANDA[\0";
pub const PANDA_MSG_SUFFIX: &'static [u8; 3usize] = b"]:\0";
pub const PANDA_MSG_FMT: &'static [u8; 11usize] = b"PANDA[%s]:\0";
pub const PANDA_MSG: &'static [u8; 13usize] = b"PANDA[core]:\0";
pub const PANDA_LOG_NOTHING: u32 = 0;
pub const PANDA_LOG_ERROR: u32 = 1;
pub const PANDA_LOG_WARNING: u32 = 2;
pub const PANDA_LOG_INFO: u32 = 3;
pub const PANDA_LOG_DEBUG: u32 = 4;
pub const PANDA_LOG_LEVEL: u32 = 2;
pub const CONFIG_QEMU_CONFDIR: &'static [u8; 49usize] =
    b"/home/jam/dev/work/panda/build/install/etc/panda\0";
pub const CONFIG_QEMU_DATADIR: &'static [u8; 51usize] =
    b"/home/jam/dev/work/panda/build/install/share/panda\0";
pub const CONFIG_QEMU_DOCDIR: &'static [u8; 54usize] =
    b"/home/jam/dev/work/panda/build/install/share/doc/qemu\0";
pub const CONFIG_QEMU_MODDIR: &'static [u8; 49usize] =
    b"/home/jam/dev/work/panda/build/install/lib/panda\0";
pub const CONFIG_PANDA_PLUGINDIR: &'static [u8; 49usize] =
    b"/home/jam/dev/work/panda/build/install/lib/panda\0";
pub const CONFIG_QEMU_LOCALSTATEDIR: &'static [u8; 43usize] =
    b"/home/jam/dev/work/panda/build/install/var\0";
pub const CONFIG_QEMU_HELPERDIR: &'static [u8; 47usize] =
    b"/home/jam/dev/work/panda/build/install/libexec\0";
pub const CONFIG_QEMU_LOCALEDIR: &'static [u8; 52usize] =
    b"/home/jam/dev/work/panda/build/install/share/locale\0";
pub const HOST_X86_64: u32 = 1;
pub const CONFIG_POSIX: u32 = 1;
pub const CONFIG_LINUX: u32 = 1;
pub const CONFIG_SLIRP: u32 = 1;
pub const CONFIG_SMBD_COMMAND: &'static [u8; 15usize] = b"/usr/sbin/smbd\0";
pub const CONFIG_VDE: u32 = 1;
pub const CONFIG_L2TPV3: u32 = 1;
pub const CONFIG_LIBCAP: u32 = 1;
pub const CONFIG_OSS: u32 = 1;
pub const CONFIG_VNC: u32 = 1;
pub const CONFIG_VNC_SASL: u32 = 1;
pub const CONFIG_VNC_JPEG: u32 = 1;
pub const CONFIG_VNC_PNG: u32 = 1;
pub const CONFIG_FNMATCH: u32 = 1;
pub const QEMU_VERSION: &'static [u8; 6usize] = b"2.9.1\0";
pub const QEMU_VERSION_MAJOR: u32 = 2;
pub const QEMU_VERSION_MINOR: u32 = 9;
pub const QEMU_VERSION_MICRO: u32 = 1;
pub const CONFIG_CURSES: u32 = 1;
pub const CONFIG_UTIMENSAT: u32 = 1;
pub const CONFIG_PIPE2: u32 = 1;
pub const CONFIG_ACCEPT4: u32 = 1;
pub const CONFIG_SPLICE: u32 = 1;
pub const CONFIG_EVENTFD: u32 = 1;
pub const CONFIG_MEMFD: u32 = 1;
pub const CONFIG_FALLOCATE: u32 = 1;
pub const CONFIG_FALLOCATE_PUNCH_HOLE: u32 = 1;
pub const CONFIG_FALLOCATE_ZERO_RANGE: u32 = 1;
pub const CONFIG_POSIX_FALLOCATE: u32 = 1;
pub const CONFIG_SYNC_FILE_RANGE: u32 = 1;
pub const CONFIG_FIEMAP: u32 = 1;
pub const CONFIG_DUP3: u32 = 1;
pub const CONFIG_PPOLL: u32 = 1;
pub const CONFIG_PRCTL_PR_SET_TIMERSLACK: u32 = 1;
pub const CONFIG_EPOLL: u32 = 1;
pub const CONFIG_EPOLL_CREATE1: u32 = 1;
pub const CONFIG_SENDFILE: u32 = 1;
pub const CONFIG_TIMERFD: u32 = 1;
pub const CONFIG_SETNS: u32 = 1;
pub const CONFIG_CLOCK_ADJTIME: u32 = 1;
pub const CONFIG_SYNCFS: u32 = 1;
pub const CONFIG_INOTIFY: u32 = 1;
pub const CONFIG_INOTIFY1: u32 = 1;
pub const CONFIG_BRLAPI: u32 = 1;
pub const CONFIG_BLUEZ: u32 = 1;
pub const CONFIG_HAS_GLIB_SUBPROCESS_TESTS: u32 = 1;
pub const CONFIG_TLS_PRIORITY: &'static [u8; 7usize] = b"NORMAL\0";
pub const CONFIG_GNUTLS: u32 = 1;
pub const CONFIG_GNUTLS_RND: u32 = 1;
pub const CONFIG_NETTLE: u32 = 1;
pub const CONFIG_NETTLE_VERSION_MAJOR: u32 = 3;
pub const CONFIG_NETTLE_KDF: u32 = 1;
pub const CONFIG_TASN1: u32 = 1;
pub const HAVE_IFADDRS_H: u32 = 1;
pub const HAVE_FSXATTR: u32 = 1;
pub const CONFIG_VIRGL: u32 = 1;
pub const CONFIG_LLVM: u32 = 1;
pub const CONFIG_XEN_BACKEND: u32 = 1;
pub const CONFIG_XEN_CTRL_INTERFACE_VERSION: u32 = 480;
pub const CONFIG_LINUX_AIO: u32 = 1;
pub const CONFIG_ATTR: u32 = 1;
pub const CONFIG_VIRTFS: u32 = 1;
pub const CONFIG_VHOST_SCSI: u32 = 1;
pub const CONFIG_VHOST_VSOCK: u32 = 1;
pub const CONFIG_IOVEC: u32 = 1;
pub const CONFIG_PREADV: u32 = 1;
pub const CONFIG_FDT: u32 = 1;
pub const CONFIG_SIGNALFD: u32 = 1;
pub const CONFIG_PROTOBUF: u32 = 1;
pub const CONFIG_FDATASYNC: u32 = 1;
pub const CONFIG_MADVISE: u32 = 1;
pub const CONFIG_POSIX_MADVISE: u32 = 1;
pub const CONFIG_SPICE: u32 = 1;
pub const CONFIG_SMARTCARD: u32 = 1;
pub const CONFIG_USB_LIBUSB: u32 = 1;
pub const CONFIG_USB_REDIR: u32 = 1;
pub const CONFIG_AVX2_OPT: u32 = 1;
pub const CONFIG_LZO: u32 = 1;
pub const CONFIG_BZIP2: u32 = 1;
pub const CONFIG_SECCOMP: u32 = 1;
pub const CONFIG_QOM_CAST_DEBUG: u32 = 1;
pub const CONFIG_COROUTINE_POOL: u32 = 1;
pub const CONFIG_OPEN_BY_HANDLE: u32 = 1;
pub const CONFIG_LINUX_MAGIC_H: u32 = 1;
pub const CONFIG_PRAGMA_DIAGNOSTIC_AVAILABLE: u32 = 1;
pub const CONFIG_HAS_ENVIRON: u32 = 1;
pub const CONFIG_CPUID_H: u32 = 1;
pub const CONFIG_INT128: u32 = 1;
pub const CONFIG_ATOMIC64: u32 = 1;
pub const CONFIG_GETAUXVAL: u32 = 1;
pub const CONFIG_TPM: u32 = 1;
pub const CONFIG_TPM_PASSTHROUGH: u32 = 1;
pub const CONFIG_TRACE_LOG: u32 = 1;
pub const CONFIG_RDMA: u32 = 1;
pub const CONFIG_RTNETLINK: u32 = 1;
pub const CONFIG_REPLICATION: u32 = 1;
pub const CONFIG_AF_VSOCK: u32 = 1;
pub const CONFIG_SYSMACROS: u32 = 1;
pub const CONFIG_THREAD_SETNAME_BYTHREAD: u32 = 1;
pub const CONFIG_PTHREAD_SETNAME_NP: u32 = 1;
pub const HOST_DSOSUF: &'static [u8; 4usize] = b".so\0";
pub const CONFIG_NUMA: u32 = 1;
pub const TARGET_AARCH64: u32 = 1;
pub const TARGET_NAME: &'static [u8; 8usize] = b"aarch64\0";
pub const TARGET_ARM: u32 = 1;
pub const CONFIG_SOFTMMU: u32 = 1;
pub const TARGET_SUPPORTS_MTTCG: u32 = 1;
pub const CONFIG_I386_DIS: u32 = 1;
pub const CONFIG_ARM_DIS: u32 = 1;
pub const CONFIG_ARM_A64_DIS: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _SYS_SYSMACROS_H: u32 = 1;
pub const _BITS_SYSMACROS_H: u32 = 1;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\0";
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __ENUM_IDTYPE_T: u32 = 1;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __HAVE_FLOAT128: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 0;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _ALLOCA_H: u32 = 1;
pub const _STRING_H: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const _INTTYPES_H: u32 = 1;
pub const ____gwchar_t_defined: u32 = 1;
pub const __PRI64_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const __PRIPTR_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const PRId8: &'static [u8; 2usize] = b"d\0";
pub const PRId16: &'static [u8; 2usize] = b"d\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRId64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdLEAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST16: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIi8: &'static [u8; 2usize] = b"i\0";
pub const PRIi16: &'static [u8; 2usize] = b"i\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIi64: &'static [u8; 3usize] = b"li\0";
pub const PRIiLEAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST16: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST32: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIo8: &'static [u8; 2usize] = b"o\0";
pub const PRIo16: &'static [u8; 2usize] = b"o\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIo64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoLEAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST16: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIu8: &'static [u8; 2usize] = b"u\0";
pub const PRIu16: &'static [u8; 2usize] = b"u\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIu64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuLEAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST16: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIx8: &'static [u8; 2usize] = b"x\0";
pub const PRIx16: &'static [u8; 2usize] = b"x\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIx64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxLEAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST16: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIX8: &'static [u8; 2usize] = b"X\0";
pub const PRIX16: &'static [u8; 2usize] = b"X\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRIX64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXLEAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST16: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST32: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"ld\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"li\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"lo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"lu\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"lx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"lX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNd64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNi64: &'static [u8; 3usize] = b"li\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST32: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNu64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNo64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNx64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"ld\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"li\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"lo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"lu\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"lx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const _UNISTD_H: u32 = 1;
pub const _POSIX_VERSION: u32 = 200809;
pub const __POSIX2_THIS_VERSION: u32 = 200809;
pub const _POSIX2_VERSION: u32 = 200809;
pub const _POSIX2_C_VERSION: u32 = 200809;
pub const _POSIX2_C_BIND: u32 = 200809;
pub const _POSIX2_C_DEV: u32 = 200809;
pub const _POSIX2_SW_DEV: u32 = 200809;
pub const _POSIX2_LOCALEDEF: u32 = 200809;
pub const _XOPEN_VERSION: u32 = 700;
pub const _XOPEN_XCU_VERSION: u32 = 4;
pub const _XOPEN_XPG2: u32 = 1;
pub const _XOPEN_XPG3: u32 = 1;
pub const _XOPEN_XPG4: u32 = 1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: u32 = 1;
pub const _BITS_POSIX_OPT_H: u32 = 1;
pub const _POSIX_JOB_CONTROL: u32 = 1;
pub const _POSIX_SAVED_IDS: u32 = 1;
pub const _POSIX_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_SYNCHRONIZED_IO: u32 = 200809;
pub const _POSIX_FSYNC: u32 = 200809;
pub const _POSIX_MAPPED_FILES: u32 = 200809;
pub const _POSIX_MEMLOCK: u32 = 200809;
pub const _POSIX_MEMLOCK_RANGE: u32 = 200809;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200809;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 0;
pub const _POSIX_VDISABLE: u8 = 0u8;
pub const _POSIX_NO_TRUNC: u32 = 1;
pub const _XOPEN_REALTIME: u32 = 1;
pub const _XOPEN_REALTIME_THREADS: u32 = 1;
pub const _XOPEN_SHM: u32 = 1;
pub const _POSIX_THREADS: u32 = 200809;
pub const _POSIX_REENTRANT_FUNCTIONS: u32 = 1;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200809;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200809;
pub const _POSIX_THREAD_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_PRIO_PROTECT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_PROTECT: i32 = -1;
pub const _POSIX_SEMAPHORES: u32 = 200809;
pub const _POSIX_REALTIME_SIGNALS: u32 = 200809;
pub const _POSIX_ASYNCHRONOUS_IO: u32 = 200809;
pub const _POSIX_ASYNC_IO: u32 = 1;
pub const _LFS_ASYNCHRONOUS_IO: u32 = 1;
pub const _POSIX_PRIORITIZED_IO: u32 = 200809;
pub const _LFS64_ASYNCHRONOUS_IO: u32 = 1;
pub const _LFS_LARGEFILE: u32 = 1;
pub const _LFS64_LARGEFILE: u32 = 1;
pub const _LFS64_STDIO: u32 = 1;
pub const _POSIX_SHARED_MEMORY_OBJECTS: u32 = 200809;
pub const _POSIX_CPUTIME: u32 = 0;
pub const _POSIX_THREAD_CPUTIME: u32 = 0;
pub const _POSIX_REGEXP: u32 = 1;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200809;
pub const _POSIX_SHELL: u32 = 1;
pub const _POSIX_TIMEOUTS: u32 = 200809;
pub const _POSIX_SPIN_LOCKS: u32 = 200809;
pub const _POSIX_SPAWN: u32 = 200809;
pub const _POSIX_TIMERS: u32 = 200809;
pub const _POSIX_BARRIERS: u32 = 200809;
pub const _POSIX_MESSAGE_PASSING: u32 = 200809;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200809;
pub const _POSIX_MONOTONIC_CLOCK: u32 = 0;
pub const _POSIX_CLOCK_SELECTION: u32 = 200809;
pub const _POSIX_ADVISORY_INFO: u32 = 200809;
pub const _POSIX_IPV6: u32 = 200809;
pub const _POSIX_RAW_SOCKETS: u32 = 200809;
pub const _POSIX2_CHAR_TERM: u32 = 200809;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_V7_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V6_LPBIG_OFFBIG: i32 = -1;
pub const _XBS5_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _XBS5_LP64_OFF64: u32 = 1;
pub const __ILP32_OFF32_CFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFF32_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFFBIG_CFLAGS: &'static [u8; 48usize] =
    b"-m32 -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64\0";
pub const __ILP32_OFFBIG_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __LP64_OFF64_CFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const __LP64_OFF64_LDFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_OK: u32 = 0;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const _GETOPT_POSIX_H: u32 = 1;
pub const _GETOPT_CORE_H: u32 = 1;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const _TIME_H: u32 = 1;
pub const _BITS_TIME_H: u32 = 1;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const __struct_tm_defined: u32 = 1;
pub const __itimerspec_defined: u32 = 1;
pub const TIME_UTC: u32 = 1;
pub const _CTYPE_H: u32 = 1;
pub const _ERRNO_H: u32 = 1;
pub const _BITS_ERRNO_H: u32 = 1;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const EHWPOISON: u32 = 133;
pub const ENOTSUP: u32 = 95;
pub const _FCNTL_H: u32 = 1;
pub const __O_LARGEFILE: u32 = 0;
pub const F_GETLK64: u32 = 5;
pub const F_SETLK64: u32 = 6;
pub const F_SETLKW64: u32 = 7;
pub const O_ACCMODE: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_CREAT: u32 = 64;
pub const O_EXCL: u32 = 128;
pub const O_NOCTTY: u32 = 256;
pub const O_TRUNC: u32 = 512;
pub const O_APPEND: u32 = 1024;
pub const O_NONBLOCK: u32 = 2048;
pub const O_NDELAY: u32 = 2048;
pub const O_SYNC: u32 = 1052672;
pub const O_FSYNC: u32 = 1052672;
pub const O_ASYNC: u32 = 8192;
pub const __O_DIRECTORY: u32 = 65536;
pub const __O_NOFOLLOW: u32 = 131072;
pub const __O_CLOEXEC: u32 = 524288;
pub const __O_DIRECT: u32 = 16384;
pub const __O_NOATIME: u32 = 262144;
pub const __O_PATH: u32 = 2097152;
pub const __O_DSYNC: u32 = 4096;
pub const __O_TMPFILE: u32 = 4259840;
pub const F_GETLK: u32 = 5;
pub const F_SETLK: u32 = 6;
pub const F_SETLKW: u32 = 7;
pub const O_DIRECTORY: u32 = 65536;
pub const O_NOFOLLOW: u32 = 131072;
pub const O_CLOEXEC: u32 = 524288;
pub const O_DSYNC: u32 = 4096;
pub const O_RSYNC: u32 = 1052672;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const __F_SETOWN: u32 = 8;
pub const __F_GETOWN: u32 = 9;
pub const F_SETOWN: u32 = 8;
pub const F_GETOWN: u32 = 9;
pub const __F_SETSIG: u32 = 10;
pub const __F_GETSIG: u32 = 11;
pub const __F_SETOWN_EX: u32 = 15;
pub const __F_GETOWN_EX: u32 = 16;
pub const F_DUPFD_CLOEXEC: u32 = 1030;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 0;
pub const F_WRLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_EXLCK: u32 = 4;
pub const F_SHLCK: u32 = 8;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const FAPPEND: u32 = 1024;
pub const FFSYNC: u32 = 1052672;
pub const FASYNC: u32 = 8192;
pub const FNONBLOCK: u32 = 2048;
pub const FNDELAY: u32 = 2048;
pub const __POSIX_FADV_DONTNEED: u32 = 4;
pub const __POSIX_FADV_NOREUSE: u32 = 5;
pub const POSIX_FADV_NORMAL: u32 = 0;
pub const POSIX_FADV_RANDOM: u32 = 1;
pub const POSIX_FADV_SEQUENTIAL: u32 = 2;
pub const POSIX_FADV_WILLNEED: u32 = 3;
pub const POSIX_FADV_DONTNEED: u32 = 4;
pub const POSIX_FADV_NOREUSE: u32 = 5;
pub const AT_FDCWD: i32 = -100;
pub const AT_SYMLINK_NOFOLLOW: u32 = 256;
pub const AT_REMOVEDIR: u32 = 512;
pub const AT_SYMLINK_FOLLOW: u32 = 1024;
pub const AT_EACCESS: u32 = 512;
pub const _BITS_STAT_H: u32 = 1;
pub const _STAT_VER_KERNEL: u32 = 0;
pub const _STAT_VER_LINUX: u32 = 1;
pub const _MKNOD_VER_LINUX: u32 = 0;
pub const _STAT_VER: u32 = 1;
pub const __S_IFMT: u32 = 61440;
pub const __S_IFDIR: u32 = 16384;
pub const __S_IFCHR: u32 = 8192;
pub const __S_IFBLK: u32 = 24576;
pub const __S_IFREG: u32 = 32768;
pub const __S_IFIFO: u32 = 4096;
pub const __S_IFLNK: u32 = 40960;
pub const __S_IFSOCK: u32 = 49152;
pub const __S_ISUID: u32 = 2048;
pub const __S_ISGID: u32 = 1024;
pub const __S_ISVTX: u32 = 512;
pub const __S_IREAD: u32 = 256;
pub const __S_IWRITE: u32 = 128;
pub const __S_IEXEC: u32 = 64;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const S_IFMT: u32 = 61440;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFIFO: u32 = 4096;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXU: u32 = 448;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXG: u32 = 56;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_IRWXO: u32 = 7;
pub const _SYS_STAT_H: u32 = 1;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const ACCESSPERMS: u32 = 511;
pub const ALLPERMS: u32 = 4095;
pub const DEFFILEMODE: u32 = 438;
pub const S_BLKSIZE: u32 = 512;
pub const _MKNOD_VER: u32 = 0;
pub const _SYS_TIME_H: u32 = 1;
pub const _ASSERT_H: u32 = 1;
pub const _SETJMP_H: u32 = 1;
pub const _BITS_SETJMP_H: u32 = 1;
pub const _BITS_SIGNUM_H: u32 = 1;
pub const _BITS_SIGNUM_GENERIC_H: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGILL: u32 = 4;
pub const SIGABRT: u32 = 6;
pub const SIGFPE: u32 = 8;
pub const SIGSEGV: u32 = 11;
pub const SIGTERM: u32 = 15;
pub const SIGHUP: u32 = 1;
pub const SIGQUIT: u32 = 3;
pub const SIGTRAP: u32 = 5;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGPOLL: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 23;
pub const SIGIOT: u32 = 6;
pub const SIGCLD: u32 = 20;
pub const __SIGRTMIN: u32 = 32;
pub const __SIGRTMAX: u32 = 32;
pub const _NSIG: u32 = 33;
pub const SIGSTKFLT: u32 = 16;
pub const SIGPWR: u32 = 30;
pub const __sig_atomic_t_defined: u32 = 1;
pub const __siginfo_t_defined: u32 = 1;
pub const __SI_MAX_SIZE: u32 = 128;
pub const _BITS_SIGINFO_ARCH_H: u32 = 1;
pub const __SI_ERRNO_THEN_CODE: u32 = 1;
pub const __SI_HAVE_SIGSYS: u32 = 1;
pub const _BITS_SIGINFO_CONSTS_H: u32 = 1;
pub const __SI_ASYNCIO_AFTER_SIGIO: u32 = 1;
pub const __sigevent_t_defined: u32 = 1;
pub const __SIGEV_MAX_SIZE: u32 = 64;
pub const _BITS_SIGEVENT_CONSTS_H: u32 = 1;
pub const NSIG: u32 = 33;
pub const _BITS_SIGACTION_H: u32 = 1;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_INTERRUPT: u32 = 536870912;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SA_STACK: u32 = 134217728;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const _BITS_SIGCONTEXT_H: u32 = 1;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const __stack_t_defined: u32 = 1;
pub const _SYS_UCONTEXT_H: u32 = 1;
pub const __NGREG: u32 = 23;
pub const NGREG: u32 = 23;
pub const _BITS_SIGSTACK_H: u32 = 1;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const _BITS_SS_FLAGS_H: u32 = 1;
pub const __sigstack_defined: u32 = 1;
pub const _BITS_SIGTHREAD_H: u32 = 1;
pub const _SYS_WAIT_H: u32 = 1;
pub const WCOREFLAG: u32 = 128;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _SYS_MMAN_H: u32 = 1;
pub const MAP_32BIT: u32 = 64;
pub const MAP_GROWSDOWN: u32 = 256;
pub const MAP_DENYWRITE: u32 = 2048;
pub const MAP_EXECUTABLE: u32 = 4096;
pub const MAP_LOCKED: u32 = 8192;
pub const MAP_NORESERVE: u32 = 16384;
pub const MAP_POPULATE: u32 = 32768;
pub const MAP_NONBLOCK: u32 = 65536;
pub const MAP_STACK: u32 = 131072;
pub const MAP_HUGETLB: u32 = 262144;
pub const MAP_SYNC: u32 = 524288;
pub const MAP_FIXED_NOREPLACE: u32 = 1048576;
pub const PROT_READ: u32 = 1;
pub const PROT_WRITE: u32 = 2;
pub const PROT_EXEC: u32 = 4;
pub const PROT_NONE: u32 = 0;
pub const PROT_GROWSDOWN: u32 = 16777216;
pub const PROT_GROWSUP: u32 = 33554432;
pub const MAP_SHARED: u32 = 1;
pub const MAP_PRIVATE: u32 = 2;
pub const MAP_SHARED_VALIDATE: u32 = 3;
pub const MAP_TYPE: u32 = 15;
pub const MAP_FIXED: u32 = 16;
pub const MAP_FILE: u32 = 0;
pub const MAP_ANONYMOUS: u32 = 32;
pub const MAP_ANON: u32 = 32;
pub const MAP_HUGE_SHIFT: u32 = 26;
pub const MAP_HUGE_MASK: u32 = 63;
pub const MS_ASYNC: u32 = 1;
pub const MS_SYNC: u32 = 4;
pub const MS_INVALIDATE: u32 = 2;
pub const MADV_NORMAL: u32 = 0;
pub const MADV_RANDOM: u32 = 1;
pub const MADV_SEQUENTIAL: u32 = 2;
pub const MADV_WILLNEED: u32 = 3;
pub const MADV_DONTNEED: u32 = 4;
pub const MADV_FREE: u32 = 8;
pub const MADV_REMOVE: u32 = 9;
pub const MADV_DONTFORK: u32 = 10;
pub const MADV_DOFORK: u32 = 11;
pub const MADV_MERGEABLE: u32 = 12;
pub const MADV_UNMERGEABLE: u32 = 13;
pub const MADV_HUGEPAGE: u32 = 14;
pub const MADV_NOHUGEPAGE: u32 = 15;
pub const MADV_DONTDUMP: u32 = 16;
pub const MADV_DODUMP: u32 = 17;
pub const MADV_WIPEONFORK: u32 = 18;
pub const MADV_KEEPONFORK: u32 = 19;
pub const MADV_COLD: u32 = 20;
pub const MADV_PAGEOUT: u32 = 21;
pub const MADV_HWPOISON: u32 = 100;
pub const POSIX_MADV_NORMAL: u32 = 0;
pub const POSIX_MADV_RANDOM: u32 = 1;
pub const POSIX_MADV_SEQUENTIAL: u32 = 2;
pub const POSIX_MADV_WILLNEED: u32 = 3;
pub const POSIX_MADV_DONTNEED: u32 = 4;
pub const MCL_CURRENT: u32 = 1;
pub const MCL_FUTURE: u32 = 2;
pub const MCL_ONFAULT: u32 = 4;
pub const _SYS_SOCKET_H: u32 = 1;
pub const __iovec_defined: u32 = 1;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_FILE: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_AX25: u32 = 3;
pub const PF_IPX: u32 = 4;
pub const PF_APPLETALK: u32 = 5;
pub const PF_NETROM: u32 = 6;
pub const PF_BRIDGE: u32 = 7;
pub const PF_ATMPVC: u32 = 8;
pub const PF_X25: u32 = 9;
pub const PF_INET6: u32 = 10;
pub const PF_ROSE: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_NETBEUI: u32 = 13;
pub const PF_SECURITY: u32 = 14;
pub const PF_KEY: u32 = 15;
pub const PF_NETLINK: u32 = 16;
pub const PF_ROUTE: u32 = 16;
pub const PF_PACKET: u32 = 17;
pub const PF_ASH: u32 = 18;
pub const PF_ECONET: u32 = 19;
pub const PF_ATMSVC: u32 = 20;
pub const PF_RDS: u32 = 21;
pub const PF_SNA: u32 = 22;
pub const PF_IRDA: u32 = 23;
pub const PF_PPPOX: u32 = 24;
pub const PF_WANPIPE: u32 = 25;
pub const PF_LLC: u32 = 26;
pub const PF_IB: u32 = 27;
pub const PF_MPLS: u32 = 28;
pub const PF_CAN: u32 = 29;
pub const PF_TIPC: u32 = 30;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_IUCV: u32 = 32;
pub const PF_RXRPC: u32 = 33;
pub const PF_ISDN: u32 = 34;
pub const PF_PHONET: u32 = 35;
pub const PF_IEEE802154: u32 = 36;
pub const PF_CAIF: u32 = 37;
pub const PF_ALG: u32 = 38;
pub const PF_NFC: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_KCM: u32 = 41;
pub const PF_QIPCRTR: u32 = 42;
pub const PF_SMC: u32 = 43;
pub const PF_XDP: u32 = 44;
pub const PF_MAX: u32 = 45;
pub const AF_UNSPEC: u32 = 0;
pub const AF_LOCAL: u32 = 1;
pub const AF_UNIX: u32 = 1;
pub const AF_FILE: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_AX25: u32 = 3;
pub const AF_IPX: u32 = 4;
pub const AF_APPLETALK: u32 = 5;
pub const AF_NETROM: u32 = 6;
pub const AF_BRIDGE: u32 = 7;
pub const AF_ATMPVC: u32 = 8;
pub const AF_X25: u32 = 9;
pub const AF_INET6: u32 = 10;
pub const AF_ROSE: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_NETBEUI: u32 = 13;
pub const AF_SECURITY: u32 = 14;
pub const AF_KEY: u32 = 15;
pub const AF_NETLINK: u32 = 16;
pub const AF_ROUTE: u32 = 16;
pub const AF_PACKET: u32 = 17;
pub const AF_ASH: u32 = 18;
pub const AF_ECONET: u32 = 19;
pub const AF_ATMSVC: u32 = 20;
pub const AF_RDS: u32 = 21;
pub const AF_SNA: u32 = 22;
pub const AF_IRDA: u32 = 23;
pub const AF_PPPOX: u32 = 24;
pub const AF_WANPIPE: u32 = 25;
pub const AF_LLC: u32 = 26;
pub const AF_IB: u32 = 27;
pub const AF_MPLS: u32 = 28;
pub const AF_CAN: u32 = 29;
pub const AF_TIPC: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IUCV: u32 = 32;
pub const AF_RXRPC: u32 = 33;
pub const AF_ISDN: u32 = 34;
pub const AF_PHONET: u32 = 35;
pub const AF_IEEE802154: u32 = 36;
pub const AF_CAIF: u32 = 37;
pub const AF_ALG: u32 = 38;
pub const AF_NFC: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_KCM: u32 = 41;
pub const AF_QIPCRTR: u32 = 42;
pub const AF_SMC: u32 = 43;
pub const AF_XDP: u32 = 44;
pub const AF_MAX: u32 = 45;
pub const SOL_RAW: u32 = 255;
pub const SOL_DECNET: u32 = 261;
pub const SOL_X25: u32 = 262;
pub const SOL_PACKET: u32 = 263;
pub const SOL_ATM: u32 = 264;
pub const SOL_AAL: u32 = 265;
pub const SOL_IRDA: u32 = 266;
pub const SOL_NETBEUI: u32 = 267;
pub const SOL_LLC: u32 = 268;
pub const SOL_DCCP: u32 = 269;
pub const SOL_NETLINK: u32 = 270;
pub const SOL_TIPC: u32 = 271;
pub const SOL_RXRPC: u32 = 272;
pub const SOL_PPPOL2TP: u32 = 273;
pub const SOL_BLUETOOTH: u32 = 274;
pub const SOL_PNPIPE: u32 = 275;
pub const SOL_RDS: u32 = 276;
pub const SOL_IUCV: u32 = 277;
pub const SOL_CAIF: u32 = 278;
pub const SOL_ALG: u32 = 279;
pub const SOL_NFC: u32 = 280;
pub const SOL_KCM: u32 = 281;
pub const SOL_TLS: u32 = 282;
pub const SOL_XDP: u32 = 283;
pub const SOMAXCONN: u32 = 4096;
pub const _BITS_SOCKADDR_H: u32 = 1;
pub const _SS_SIZE: u32 = 128;
pub const __BITS_PER_LONG: u32 = 64;
pub const FIOSETOWN: u32 = 35073;
pub const SIOCSPGRP: u32 = 35074;
pub const FIOGETOWN: u32 = 35075;
pub const SIOCGPGRP: u32 = 35076;
pub const SIOCATMARK: u32 = 35077;
pub const SIOCGSTAMP_OLD: u32 = 35078;
pub const SIOCGSTAMPNS_OLD: u32 = 35079;
pub const SOL_SOCKET: u32 = 1;
pub const SO_DEBUG: u32 = 1;
pub const SO_REUSEADDR: u32 = 2;
pub const SO_TYPE: u32 = 3;
pub const SO_ERROR: u32 = 4;
pub const SO_DONTROUTE: u32 = 5;
pub const SO_BROADCAST: u32 = 6;
pub const SO_SNDBUF: u32 = 7;
pub const SO_RCVBUF: u32 = 8;
pub const SO_SNDBUFFORCE: u32 = 32;
pub const SO_RCVBUFFORCE: u32 = 33;
pub const SO_KEEPALIVE: u32 = 9;
pub const SO_OOBINLINE: u32 = 10;
pub const SO_NO_CHECK: u32 = 11;
pub const SO_PRIORITY: u32 = 12;
pub const SO_LINGER: u32 = 13;
pub const SO_BSDCOMPAT: u32 = 14;
pub const SO_REUSEPORT: u32 = 15;
pub const SO_PASSCRED: u32 = 16;
pub const SO_PEERCRED: u32 = 17;
pub const SO_RCVLOWAT: u32 = 18;
pub const SO_SNDLOWAT: u32 = 19;
pub const SO_RCVTIMEO_OLD: u32 = 20;
pub const SO_SNDTIMEO_OLD: u32 = 21;
pub const SO_SECURITY_AUTHENTICATION: u32 = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: u32 = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: u32 = 24;
pub const SO_BINDTODEVICE: u32 = 25;
pub const SO_ATTACH_FILTER: u32 = 26;
pub const SO_DETACH_FILTER: u32 = 27;
pub const SO_GET_FILTER: u32 = 26;
pub const SO_PEERNAME: u32 = 28;
pub const SO_ACCEPTCONN: u32 = 30;
pub const SO_PEERSEC: u32 = 31;
pub const SO_PASSSEC: u32 = 34;
pub const SO_MARK: u32 = 36;
pub const SO_PROTOCOL: u32 = 38;
pub const SO_DOMAIN: u32 = 39;
pub const SO_RXQ_OVFL: u32 = 40;
pub const SO_WIFI_STATUS: u32 = 41;
pub const SCM_WIFI_STATUS: u32 = 41;
pub const SO_PEEK_OFF: u32 = 42;
pub const SO_NOFCS: u32 = 43;
pub const SO_LOCK_FILTER: u32 = 44;
pub const SO_SELECT_ERR_QUEUE: u32 = 45;
pub const SO_BUSY_POLL: u32 = 46;
pub const SO_MAX_PACING_RATE: u32 = 47;
pub const SO_BPF_EXTENSIONS: u32 = 48;
pub const SO_INCOMING_CPU: u32 = 49;
pub const SO_ATTACH_BPF: u32 = 50;
pub const SO_DETACH_BPF: u32 = 27;
pub const SO_ATTACH_REUSEPORT_CBPF: u32 = 51;
pub const SO_ATTACH_REUSEPORT_EBPF: u32 = 52;
pub const SO_CNX_ADVICE: u32 = 53;
pub const SCM_TIMESTAMPING_OPT_STATS: u32 = 54;
pub const SO_MEMINFO: u32 = 55;
pub const SO_INCOMING_NAPI_ID: u32 = 56;
pub const SO_COOKIE: u32 = 57;
pub const SCM_TIMESTAMPING_PKTINFO: u32 = 58;
pub const SO_PEERGROUPS: u32 = 59;
pub const SO_ZEROCOPY: u32 = 60;
pub const SO_TXTIME: u32 = 61;
pub const SCM_TXTIME: u32 = 61;
pub const SO_BINDTOIFINDEX: u32 = 62;
pub const SO_TIMESTAMP_OLD: u32 = 29;
pub const SO_TIMESTAMPNS_OLD: u32 = 35;
pub const SO_TIMESTAMPING_OLD: u32 = 37;
pub const SO_TIMESTAMP_NEW: u32 = 63;
pub const SO_TIMESTAMPNS_NEW: u32 = 64;
pub const SO_TIMESTAMPING_NEW: u32 = 65;
pub const SO_RCVTIMEO_NEW: u32 = 66;
pub const SO_SNDTIMEO_NEW: u32 = 67;
pub const SO_DETACH_REUSEPORT_BPF: u32 = 68;
pub const SO_TIMESTAMP: u32 = 29;
pub const SO_TIMESTAMPNS: u32 = 35;
pub const SO_TIMESTAMPING: u32 = 37;
pub const SO_RCVTIMEO: u32 = 20;
pub const SO_SNDTIMEO: u32 = 21;
pub const SCM_TIMESTAMP: u32 = 29;
pub const SCM_TIMESTAMPNS: u32 = 35;
pub const SCM_TIMESTAMPING: u32 = 37;
pub const __osockaddr_defined: u32 = 1;
pub const _NETINET_IN_H: u32 = 1;
pub const __USE_KERNEL_IPV6_DEFS: u32 = 0;
pub const IP_OPTIONS: u32 = 4;
pub const IP_HDRINCL: u32 = 3;
pub const IP_TOS: u32 = 1;
pub const IP_TTL: u32 = 2;
pub const IP_RECVOPTS: u32 = 6;
pub const IP_RETOPTS: u32 = 7;
pub const IP_MULTICAST_IF: u32 = 32;
pub const IP_MULTICAST_TTL: u32 = 33;
pub const IP_MULTICAST_LOOP: u32 = 34;
pub const IP_ADD_MEMBERSHIP: u32 = 35;
pub const IP_DROP_MEMBERSHIP: u32 = 36;
pub const IP_UNBLOCK_SOURCE: u32 = 37;
pub const IP_BLOCK_SOURCE: u32 = 38;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 39;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 40;
pub const IP_MSFILTER: u32 = 41;
pub const MCAST_JOIN_GROUP: u32 = 42;
pub const MCAST_BLOCK_SOURCE: u32 = 43;
pub const MCAST_UNBLOCK_SOURCE: u32 = 44;
pub const MCAST_LEAVE_GROUP: u32 = 45;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 46;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 47;
pub const MCAST_MSFILTER: u32 = 48;
pub const IP_MULTICAST_ALL: u32 = 49;
pub const IP_UNICAST_IF: u32 = 50;
pub const MCAST_EXCLUDE: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const IP_ROUTER_ALERT: u32 = 5;
pub const IP_PKTINFO: u32 = 8;
pub const IP_PKTOPTIONS: u32 = 9;
pub const IP_PMTUDISC: u32 = 10;
pub const IP_MTU_DISCOVER: u32 = 10;
pub const IP_RECVERR: u32 = 11;
pub const IP_RECVTTL: u32 = 12;
pub const IP_RECVTOS: u32 = 13;
pub const IP_MTU: u32 = 14;
pub const IP_FREEBIND: u32 = 15;
pub const IP_IPSEC_POLICY: u32 = 16;
pub const IP_XFRM_POLICY: u32 = 17;
pub const IP_PASSSEC: u32 = 18;
pub const IP_TRANSPARENT: u32 = 19;
pub const IP_ORIGDSTADDR: u32 = 20;
pub const IP_RECVORIGDSTADDR: u32 = 20;
pub const IP_MINTTL: u32 = 21;
pub const IP_NODEFRAG: u32 = 22;
pub const IP_CHECKSUM: u32 = 23;
pub const IP_BIND_ADDRESS_NO_PORT: u32 = 24;
pub const IP_RECVFRAGSIZE: u32 = 25;
pub const IP_PMTUDISC_DONT: u32 = 0;
pub const IP_PMTUDISC_WANT: u32 = 1;
pub const IP_PMTUDISC_DO: u32 = 2;
pub const IP_PMTUDISC_PROBE: u32 = 3;
pub const IP_PMTUDISC_INTERFACE: u32 = 4;
pub const IP_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IP: u32 = 0;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MAX_MEMBERSHIPS: u32 = 20;
pub const IPV6_ADDRFORM: u32 = 1;
pub const IPV6_2292PKTINFO: u32 = 2;
pub const IPV6_2292HOPOPTS: u32 = 3;
pub const IPV6_2292DSTOPTS: u32 = 4;
pub const IPV6_2292RTHDR: u32 = 5;
pub const IPV6_2292PKTOPTIONS: u32 = 6;
pub const IPV6_CHECKSUM: u32 = 7;
pub const IPV6_2292HOPLIMIT: u32 = 8;
pub const IPV6_NEXTHOP: u32 = 9;
pub const IPV6_AUTHHDR: u32 = 10;
pub const IPV6_UNICAST_HOPS: u32 = 16;
pub const IPV6_MULTICAST_IF: u32 = 17;
pub const IPV6_MULTICAST_HOPS: u32 = 18;
pub const IPV6_MULTICAST_LOOP: u32 = 19;
pub const IPV6_JOIN_GROUP: u32 = 20;
pub const IPV6_LEAVE_GROUP: u32 = 21;
pub const IPV6_ROUTER_ALERT: u32 = 22;
pub const IPV6_MTU_DISCOVER: u32 = 23;
pub const IPV6_MTU: u32 = 24;
pub const IPV6_RECVERR: u32 = 25;
pub const IPV6_V6ONLY: u32 = 26;
pub const IPV6_JOIN_ANYCAST: u32 = 27;
pub const IPV6_LEAVE_ANYCAST: u32 = 28;
pub const IPV6_MULTICAST_ALL: u32 = 29;
pub const IPV6_ROUTER_ALERT_ISOLATE: u32 = 30;
pub const IPV6_IPSEC_POLICY: u32 = 34;
pub const IPV6_XFRM_POLICY: u32 = 35;
pub const IPV6_HDRINCL: u32 = 36;
pub const IPV6_RECVPKTINFO: u32 = 49;
pub const IPV6_PKTINFO: u32 = 50;
pub const IPV6_RECVHOPLIMIT: u32 = 51;
pub const IPV6_HOPLIMIT: u32 = 52;
pub const IPV6_RECVHOPOPTS: u32 = 53;
pub const IPV6_HOPOPTS: u32 = 54;
pub const IPV6_RTHDRDSTOPTS: u32 = 55;
pub const IPV6_RECVRTHDR: u32 = 56;
pub const IPV6_RTHDR: u32 = 57;
pub const IPV6_RECVDSTOPTS: u32 = 58;
pub const IPV6_DSTOPTS: u32 = 59;
pub const IPV6_RECVPATHMTU: u32 = 60;
pub const IPV6_PATHMTU: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_RECVTCLASS: u32 = 66;
pub const IPV6_TCLASS: u32 = 67;
pub const IPV6_AUTOFLOWLABEL: u32 = 70;
pub const IPV6_ADDR_PREFERENCES: u32 = 72;
pub const IPV6_MINHOPCOUNT: u32 = 73;
pub const IPV6_ORIGDSTADDR: u32 = 74;
pub const IPV6_RECVORIGDSTADDR: u32 = 74;
pub const IPV6_TRANSPARENT: u32 = 75;
pub const IPV6_UNICAST_IF: u32 = 76;
pub const IPV6_RECVFRAGSIZE: u32 = 77;
pub const IPV6_FREEBIND: u32 = 78;
pub const IPV6_ADD_MEMBERSHIP: u32 = 20;
pub const IPV6_DROP_MEMBERSHIP: u32 = 21;
pub const IPV6_RXHOPOPTS: u32 = 54;
pub const IPV6_RXDSTOPTS: u32 = 59;
pub const IPV6_PMTUDISC_DONT: u32 = 0;
pub const IPV6_PMTUDISC_WANT: u32 = 1;
pub const IPV6_PMTUDISC_DO: u32 = 2;
pub const IPV6_PMTUDISC_PROBE: u32 = 3;
pub const IPV6_PMTUDISC_INTERFACE: u32 = 4;
pub const IPV6_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IPV6: u32 = 41;
pub const SOL_ICMPV6: u32 = 58;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const _NETINET_TCP_H: u32 = 1;
pub const TCP_NODELAY: u32 = 1;
pub const TCP_MAXSEG: u32 = 2;
pub const TCP_CORK: u32 = 3;
pub const TCP_KEEPIDLE: u32 = 4;
pub const TCP_KEEPINTVL: u32 = 5;
pub const TCP_KEEPCNT: u32 = 6;
pub const TCP_SYNCNT: u32 = 7;
pub const TCP_LINGER2: u32 = 8;
pub const TCP_DEFER_ACCEPT: u32 = 9;
pub const TCP_WINDOW_CLAMP: u32 = 10;
pub const TCP_INFO: u32 = 11;
pub const TCP_QUICKACK: u32 = 12;
pub const TCP_CONGESTION: u32 = 13;
pub const TCP_MD5SIG: u32 = 14;
pub const TCP_COOKIE_TRANSACTIONS: u32 = 15;
pub const TCP_THIN_LINEAR_TIMEOUTS: u32 = 16;
pub const TCP_THIN_DUPACK: u32 = 17;
pub const TCP_USER_TIMEOUT: u32 = 18;
pub const TCP_REPAIR: u32 = 19;
pub const TCP_REPAIR_QUEUE: u32 = 20;
pub const TCP_QUEUE_SEQ: u32 = 21;
pub const TCP_REPAIR_OPTIONS: u32 = 22;
pub const TCP_FASTOPEN: u32 = 23;
pub const TCP_TIMESTAMP: u32 = 24;
pub const TCP_NOTSENT_LOWAT: u32 = 25;
pub const TCP_CC_INFO: u32 = 26;
pub const TCP_SAVE_SYN: u32 = 27;
pub const TCP_SAVED_SYN: u32 = 28;
pub const TCP_REPAIR_WINDOW: u32 = 29;
pub const TCP_FASTOPEN_CONNECT: u32 = 30;
pub const TCP_ULP: u32 = 31;
pub const TCP_MD5SIG_EXT: u32 = 32;
pub const TCP_FASTOPEN_KEY: u32 = 33;
pub const TCP_FASTOPEN_NO_COOKIE: u32 = 34;
pub const TCP_ZEROCOPY_RECEIVE: u32 = 35;
pub const TCP_INQ: u32 = 36;
pub const TCP_CM_INQ: u32 = 36;
pub const TCP_TX_DELAY: u32 = 37;
pub const TCP_REPAIR_ON: u32 = 1;
pub const TCP_REPAIR_OFF: u32 = 0;
pub const TCP_REPAIR_OFF_NO_WP: i32 = -1;
pub const TH_FIN: u32 = 1;
pub const TH_SYN: u32 = 2;
pub const TH_RST: u32 = 4;
pub const TH_PUSH: u32 = 8;
pub const TH_ACK: u32 = 16;
pub const TH_URG: u32 = 32;
pub const TCPOPT_EOL: u32 = 0;
pub const TCPOPT_NOP: u32 = 1;
pub const TCPOPT_MAXSEG: u32 = 2;
pub const TCPOLEN_MAXSEG: u32 = 4;
pub const TCPOPT_WINDOW: u32 = 3;
pub const TCPOLEN_WINDOW: u32 = 3;
pub const TCPOPT_SACK_PERMITTED: u32 = 4;
pub const TCPOLEN_SACK_PERMITTED: u32 = 2;
pub const TCPOPT_SACK: u32 = 5;
pub const TCPOPT_TIMESTAMP: u32 = 8;
pub const TCPOLEN_TIMESTAMP: u32 = 10;
pub const TCPOLEN_TSTAMP_APPA: u32 = 12;
pub const TCPOPT_TSTAMP_HDR: u32 = 16844810;
pub const TCP_MSS: u32 = 512;
pub const TCP_MAXWIN: u32 = 65535;
pub const TCP_MAX_WINSHIFT: u32 = 14;
pub const SOL_TCP: u32 = 6;
pub const TCPI_OPT_TIMESTAMPS: u32 = 1;
pub const TCPI_OPT_SACK: u32 = 2;
pub const TCPI_OPT_WSCALE: u32 = 4;
pub const TCPI_OPT_ECN: u32 = 8;
pub const TCPI_OPT_ECN_SEEN: u32 = 16;
pub const TCPI_OPT_SYN_DATA: u32 = 32;
pub const TCP_MD5SIG_MAXKEYLEN: u32 = 80;
pub const TCP_MD5SIG_FLAG_PREFIX: u32 = 1;
pub const TCP_COOKIE_MIN: u32 = 8;
pub const TCP_COOKIE_MAX: u32 = 16;
pub const TCP_COOKIE_PAIR_SIZE: u32 = 32;
pub const TCP_COOKIE_IN_ALWAYS: u32 = 1;
pub const TCP_COOKIE_OUT_NEVER: u32 = 2;
pub const TCP_S_DATA_IN: u32 = 4;
pub const TCP_S_DATA_OUT: u32 = 8;
pub const TCP_MSS_DEFAULT: u32 = 536;
pub const TCP_MSS_DESIRED: u32 = 1220;
pub const _ARPA_INET_H: u32 = 1;
pub const _NETDB_H: u32 = 1;
pub const _RPC_NETDB_H: u32 = 1;
pub const _PATH_HEQUIV: &'static [u8; 17usize] = b"/etc/hosts.equiv\0";
pub const _PATH_HOSTS: &'static [u8; 11usize] = b"/etc/hosts\0";
pub const _PATH_NETWORKS: &'static [u8; 14usize] = b"/etc/networks\0";
pub const _PATH_NSSWITCH_CONF: &'static [u8; 19usize] = b"/etc/nsswitch.conf\0";
pub const _PATH_PROTOCOLS: &'static [u8; 15usize] = b"/etc/protocols\0";
pub const _PATH_SERVICES: &'static [u8; 14usize] = b"/etc/services\0";
pub const HOST_NOT_FOUND: u32 = 1;
pub const TRY_AGAIN: u32 = 2;
pub const NO_RECOVERY: u32 = 3;
pub const NO_DATA: u32 = 4;
pub const NETDB_INTERNAL: i32 = -1;
pub const NETDB_SUCCESS: u32 = 0;
pub const NO_ADDRESS: u32 = 4;
pub const AI_PASSIVE: u32 = 1;
pub const AI_CANONNAME: u32 = 2;
pub const AI_NUMERICHOST: u32 = 4;
pub const AI_V4MAPPED: u32 = 8;
pub const AI_ALL: u32 = 16;
pub const AI_ADDRCONFIG: u32 = 32;
pub const AI_NUMERICSERV: u32 = 1024;
pub const EAI_BADFLAGS: i32 = -1;
pub const EAI_NONAME: i32 = -2;
pub const EAI_AGAIN: i32 = -3;
pub const EAI_FAIL: i32 = -4;
pub const EAI_FAMILY: i32 = -6;
pub const EAI_SOCKTYPE: i32 = -7;
pub const EAI_SERVICE: i32 = -8;
pub const EAI_MEMORY: i32 = -10;
pub const EAI_SYSTEM: i32 = -11;
pub const EAI_OVERFLOW: i32 = -12;
pub const NI_MAXHOST: u32 = 1025;
pub const NI_MAXSERV: u32 = 32;
pub const NI_NUMERICHOST: u32 = 1;
pub const NI_NUMERICSERV: u32 = 2;
pub const NI_NOFQDN: u32 = 4;
pub const NI_NAMEREQD: u32 = 8;
pub const NI_DGRAM: u32 = 16;
pub const _SYS_UN_H: u32 = 1;
pub const G_ANALYZER_ANALYZING: u32 = 0;
pub const FALSE: u32 = 0;
pub const G_GINT16_MODIFIER: &'static [u8; 2usize] = b"h\0";
pub const G_GINT16_FORMAT: &'static [u8; 3usize] = b"hi\0";
pub const G_GUINT16_FORMAT: &'static [u8; 3usize] = b"hu\0";
pub const G_GINT32_MODIFIER: &'static [u8; 1usize] = b"\0";
pub const G_GINT32_FORMAT: &'static [u8; 2usize] = b"i\0";
pub const G_GUINT32_FORMAT: &'static [u8; 2usize] = b"u\0";
pub const G_HAVE_GINT64: u32 = 1;
pub const G_GINT64_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GINT64_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_GUINT64_FORMAT: &'static [u8; 3usize] = b"lu\0";
pub const GLIB_SIZEOF_VOID_P: u32 = 8;
pub const GLIB_SIZEOF_LONG: u32 = 8;
pub const GLIB_SIZEOF_SIZE_T: u32 = 8;
pub const GLIB_SIZEOF_SSIZE_T: u32 = 8;
pub const G_GSIZE_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GSSIZE_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GSIZE_FORMAT: &'static [u8; 3usize] = b"lu\0";
pub const G_GSSIZE_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_GOFFSET_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GOFFSET_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_POLLFD_FORMAT: &'static [u8; 3usize] = b"%d\0";
pub const G_GINTPTR_MODIFIER: &'static [u8; 2usize] = b"l\0";
pub const G_GINTPTR_FORMAT: &'static [u8; 3usize] = b"li\0";
pub const G_GUINTPTR_FORMAT: &'static [u8; 3usize] = b"lu\0";
pub const GLIB_MAJOR_VERSION: u32 = 2;
pub const GLIB_MINOR_VERSION: u32 = 64;
pub const GLIB_MICRO_VERSION: u32 = 6;
pub const G_VA_COPY_AS_ARRAY: u32 = 1;
pub const G_HAVE_ISO_VARARGS: u32 = 1;
pub const G_HAVE_GROWING_STACK: u32 = 0;
pub const G_HAVE_GNUC_VISIBILITY: u32 = 1;
pub const G_HAVE_GNUC_VARARGS: u32 = 1;
pub const G_MODULE_SUFFIX: &'static [u8; 3usize] = b"so\0";
pub const G_PID_FORMAT: &'static [u8; 2usize] = b"i\0";
pub const GLIB_SYSDEF_AF_UNIX: u32 = 1;
pub const GLIB_SYSDEF_AF_INET: u32 = 2;
pub const GLIB_SYSDEF_AF_INET6: u32 = 10;
pub const GLIB_SYSDEF_MSG_OOB: u32 = 1;
pub const GLIB_SYSDEF_MSG_PEEK: u32 = 2;
pub const GLIB_SYSDEF_MSG_DONTROUTE: u32 = 4;
pub const G_DIR_SEPARATOR: u8 = 47u8;
pub const G_DIR_SEPARATOR_S: &'static [u8; 2usize] = b"/\0";
pub const G_SEARCHPATH_SEPARATOR: u8 = 58u8;
pub const G_SEARCHPATH_SEPARATOR_S: &'static [u8; 2usize] = b":\0";
pub const G_E: f64 = 2.718281828459045;
pub const G_LN2: f64 = 0.6931471805599453;
pub const G_LN10: f64 = 2.302585092994046;
pub const G_PI: f64 = 3.141592653589793;
pub const G_PI_2: f64 = 1.5707963267948966;
pub const G_PI_4: f64 = 0.7853981633974483;
pub const G_SQRT2: f64 = 1.4142135623730951;
pub const G_LITTLE_ENDIAN: u32 = 1234;
pub const G_BIG_ENDIAN: u32 = 4321;
pub const G_PDP_ENDIAN: u32 = 3412;
pub const G_IEEE754_FLOAT_BIAS: u32 = 127;
pub const G_IEEE754_DOUBLE_BIAS: u32 = 1023;
pub const G_LOG_2_BASE_10: f64 = 0.3010299956639812;
pub const G_DATALIST_FLAGS_MASK: u32 = 3;
pub const G_DATE_BAD_JULIAN: u32 = 0;
pub const G_DATE_BAD_DAY: u32 = 0;
pub const G_DATE_BAD_YEAR: u32 = 0;
pub const _DIRENT_H: u32 = 1;
pub const _DIRENT_MATCHES_DIRENT64: u32 = 1;
pub const MAXNAMLEN: u32 = 255;
pub const G_MEM_ALIGN: u32 = 8;
pub const G_HOOK_FLAG_USER_SHIFT: u32 = 4;
pub const G_PRIORITY_HIGH: i32 = -100;
pub const G_PRIORITY_DEFAULT: u32 = 0;
pub const G_PRIORITY_HIGH_IDLE: u32 = 100;
pub const G_PRIORITY_DEFAULT_IDLE: u32 = 200;
pub const G_PRIORITY_LOW: u32 = 300;
pub const G_SOURCE_REMOVE: u32 = 0;
pub const G_UNICHAR_MAX_DECOMPOSITION_LENGTH: u32 = 18;
pub const G_KEY_FILE_DESKTOP_GROUP: &'static [u8; 14usize] = b"Desktop Entry\0";
pub const G_KEY_FILE_DESKTOP_KEY_TYPE: &'static [u8; 5usize] = b"Type\0";
pub const G_KEY_FILE_DESKTOP_KEY_VERSION: &'static [u8; 8usize] = b"Version\0";
pub const G_KEY_FILE_DESKTOP_KEY_NAME: &'static [u8; 5usize] = b"Name\0";
pub const G_KEY_FILE_DESKTOP_KEY_GENERIC_NAME: &'static [u8; 12usize] = b"GenericName\0";
pub const G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY: &'static [u8; 10usize] = b"NoDisplay\0";
pub const G_KEY_FILE_DESKTOP_KEY_COMMENT: &'static [u8; 8usize] = b"Comment\0";
pub const G_KEY_FILE_DESKTOP_KEY_ICON: &'static [u8; 5usize] = b"Icon\0";
pub const G_KEY_FILE_DESKTOP_KEY_HIDDEN: &'static [u8; 7usize] = b"Hidden\0";
pub const G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN: &'static [u8; 11usize] = b"OnlyShowIn\0";
pub const G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN: &'static [u8; 10usize] = b"NotShowIn\0";
pub const G_KEY_FILE_DESKTOP_KEY_TRY_EXEC: &'static [u8; 8usize] = b"TryExec\0";
pub const G_KEY_FILE_DESKTOP_KEY_EXEC: &'static [u8; 5usize] = b"Exec\0";
pub const G_KEY_FILE_DESKTOP_KEY_PATH: &'static [u8; 5usize] = b"Path\0";
pub const G_KEY_FILE_DESKTOP_KEY_TERMINAL: &'static [u8; 9usize] = b"Terminal\0";
pub const G_KEY_FILE_DESKTOP_KEY_MIME_TYPE: &'static [u8; 9usize] = b"MimeType\0";
pub const G_KEY_FILE_DESKTOP_KEY_CATEGORIES: &'static [u8; 11usize] = b"Categories\0";
pub const G_KEY_FILE_DESKTOP_KEY_STARTUP_NOTIFY: &'static [u8; 14usize] = b"StartupNotify\0";
pub const G_KEY_FILE_DESKTOP_KEY_STARTUP_WM_CLASS: &'static [u8; 15usize] = b"StartupWMClass\0";
pub const G_KEY_FILE_DESKTOP_KEY_URL: &'static [u8; 4usize] = b"URL\0";
pub const G_KEY_FILE_DESKTOP_KEY_DBUS_ACTIVATABLE: &'static [u8; 16usize] = b"DBusActivatable\0";
pub const G_KEY_FILE_DESKTOP_KEY_ACTIONS: &'static [u8; 8usize] = b"Actions\0";
pub const G_KEY_FILE_DESKTOP_TYPE_APPLICATION: &'static [u8; 12usize] = b"Application\0";
pub const G_KEY_FILE_DESKTOP_TYPE_LINK: &'static [u8; 5usize] = b"Link\0";
pub const G_KEY_FILE_DESKTOP_TYPE_DIRECTORY: &'static [u8; 10usize] = b"Directory\0";
pub const G_LOG_LEVEL_USER_SHIFT: u32 = 8;
pub const G_OPTION_REMAINING: &'static [u8; 1usize] = b"\0";
pub const G_CSET_A_2_Z: &'static [u8; 27usize] = b"ABCDEFGHIJKLMNOPQRSTUVWXYZ\0";
pub const G_CSET_a_2_z: &'static [u8; 27usize] = b"abcdefghijklmnopqrstuvwxyz\0";
pub const G_CSET_DIGITS: &'static [u8; 11usize] = b"0123456789\0";
pub const G_CSET_LATINC: [u8; 31usize] = [
    192u8, 193u8, 194u8, 195u8, 196u8, 197u8, 198u8, 199u8, 200u8, 201u8, 202u8, 203u8, 204u8,
    205u8, 206u8, 207u8, 208u8, 209u8, 210u8, 211u8, 212u8, 213u8, 214u8, 216u8, 217u8, 218u8,
    219u8, 220u8, 221u8, 222u8, 0u8,
];
pub const G_CSET_LATINS: [u8; 33usize] = [
    223u8, 224u8, 225u8, 226u8, 227u8, 228u8, 229u8, 230u8, 231u8, 232u8, 233u8, 234u8, 235u8,
    236u8, 237u8, 238u8, 239u8, 240u8, 241u8, 242u8, 243u8, 244u8, 245u8, 246u8, 248u8, 249u8,
    250u8, 251u8, 252u8, 253u8, 254u8, 255u8, 0u8,
];
pub const G_STR_DELIMITERS: &'static [u8; 8usize] = b"_-|> <.\0";
pub const G_ASCII_DTOSTR_BUF_SIZE: u32 = 39;
pub const G_TEST_OPTION_ISOLATE_DIRS: &'static [u8; 13usize] = b"isolate_dirs\0";
pub const G_USEC_PER_SEC: u32 = 1000000;
pub const G_URI_RESERVED_CHARS_GENERIC_DELIMITERS: &'static [u8; 8usize] = b":/?#[]@\0";
pub const G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS: &'static [u8; 12usize] = b"!$&'()*+,;=\0";
pub const G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT: &'static [u8; 14usize] = b"!$&'()*+,;=:@\0";
pub const G_URI_RESERVED_CHARS_ALLOWED_IN_PATH: &'static [u8; 15usize] = b"!$&'()*+,;=:@/\0";
pub const G_URI_RESERVED_CHARS_ALLOWED_IN_USERINFO: &'static [u8; 13usize] = b"!$&'()*+,;=:\0";
pub const G_ALLOC_ONLY: u32 = 1;
pub const G_ALLOC_AND_FREE: u32 = 2;
pub const G_ALLOCATOR_LIST: u32 = 1;
pub const G_ALLOCATOR_SLIST: u32 = 2;
pub const G_ALLOCATOR_NODE: u32 = 3;
pub const _PTHREAD_H: u32 = 1;
pub const _SCHED_H: u32 = 1;
pub const _BITS_SCHED_H: u32 = 1;
pub const SCHED_OTHER: u32 = 0;
pub const SCHED_FIFO: u32 = 1;
pub const SCHED_RR: u32 = 2;
pub const _BITS_TYPES_STRUCT_SCHED_PARAM: u32 = 1;
pub const _BITS_CPU_SET_H: u32 = 1;
pub const __CPU_SETSIZE: u32 = 1024;
pub const PTHREAD_ONCE_INIT: u32 = 0;
pub const PTHREAD_BARRIER_SERIAL_THREAD: i32 = -1;
pub const O_LARGEFILE: u32 = 0;
pub const O_BINARY: u32 = 0;
pub const HOST_LONG_BITS: u32 = 64;
pub const QEMU_MADV_INVALID: i32 = -1;
pub const QEMU_MADV_WILLNEED: u32 = 3;
pub const QEMU_MADV_DONTNEED: u32 = 4;
pub const QEMU_MADV_DONTFORK: u32 = 10;
pub const QEMU_MADV_MERGEABLE: u32 = 12;
pub const QEMU_MADV_UNMERGEABLE: u32 = 13;
pub const QEMU_MADV_DODUMP: u32 = 17;
pub const QEMU_MADV_DONTDUMP: u32 = 16;
pub const QEMU_MADV_HUGEPAGE: u32 = 14;
pub const QEMU_MADV_NOHUGEPAGE: u32 = 15;
pub const QEMU_VMALLOC_ALIGN: u32 = 2097152;
pub const FMT_pid: &'static [u8; 3usize] = b"%d\0";
pub const _SYS_UIO_H: u32 = 1;
pub const _BITS_UIO_LIM_H: u32 = 1;
pub const __IOV_MAX: u32 = 1024;
pub const UIO_MAXIOV: u32 = 1024;
pub const QEMU_HW_VERSION: &'static [u8; 5usize] = b"2.5+\0";
pub const QDICT_BUCKET_MAX: u32 = 512;
pub const QEMU_COPYRIGHT: &'static [u8; 72usize] =
    b"Copyright (c) 2003-2017 Fabrice Bellard and the QEMU Project developers\0";
pub const QEMU_FILE_TYPE_BIOS: u32 = 0;
pub const QEMU_FILE_TYPE_KEYMAP: u32 = 1;
pub const CP_REG_SIZE_SHIFT: u32 = 52;
pub const CP_REG_SIZE_MASK: u64 = 67553994410557440;
pub const CP_REG_SIZE_U32: u64 = 9007199254740992;
pub const CP_REG_SIZE_U64: u64 = 13510798882111488;
pub const CP_REG_ARM: u64 = 4611686018427387904;
pub const CP_REG_ARCH_MASK: i64 = -72057594037927936;
pub const QEMU_PSCI_0_1_FN_BASE: u32 = 2512501342;
pub const QEMU_PSCI_0_2_FN_BASE: u32 = 2214592512;
pub const QEMU_PSCI_0_2_64BIT: u32 = 1073741824;
pub const QEMU_PSCI_0_2_FN64_BASE: u32 = 3288334336;
pub const QEMU_PSCI_0_2_RET_TOS_MIGRATION_NOT_REQUIRED: u32 = 2;
pub const QEMU_PSCI_0_2_RET_VERSION_0_2: u32 = 2;
pub const QEMU_PSCI_RET_SUCCESS: u32 = 0;
pub const QEMU_PSCI_RET_NOT_SUPPORTED: i32 = -1;
pub const QEMU_PSCI_RET_INVALID_PARAMS: i32 = -2;
pub const QEMU_PSCI_RET_DENIED: i32 = -3;
pub const QEMU_PSCI_RET_ALREADY_ON: i32 = -4;
pub const QEMU_PSCI_RET_ON_PENDING: i32 = -5;
pub const QEMU_PSCI_RET_INTERNAL_FAILURE: i32 = -6;
pub const QEMU_PSCI_RET_NOT_PRESENT: i32 = -7;
pub const QEMU_PSCI_RET_DISABLED: i32 = -8;
pub const QEMU_KVM_ARM_TARGET_CORTEX_A15: u32 = 0;
pub const QEMU_KVM_ARM_TARGET_CORTEX_A7: u32 = 1;
pub const QEMU_KVM_ARM_TARGET_AEM_V8: u32 = 0;
pub const QEMU_KVM_ARM_TARGET_FOUNDATION_V8: u32 = 1;
pub const QEMU_KVM_ARM_TARGET_CORTEX_A57: u32 = 2;
pub const QEMU_KVM_ARM_TARGET_XGENE_POTENZA: u32 = 3;
pub const QEMU_KVM_ARM_TARGET_CORTEX_A53: u32 = 4;
pub const CP_REG_ARM64: u64 = 6917529027641081856;
pub const CP_REG_ARM_COPROC_MASK: u32 = 268369920;
pub const CP_REG_ARM_COPROC_SHIFT: u32 = 16;
pub const CP_REG_ARM64_SYSREG: u32 = 1245184;
pub const CP_REG_ARM64_SYSREG_OP0_MASK: u32 = 49152;
pub const CP_REG_ARM64_SYSREG_OP0_SHIFT: u32 = 14;
pub const CP_REG_ARM64_SYSREG_OP1_MASK: u32 = 14336;
pub const CP_REG_ARM64_SYSREG_OP1_SHIFT: u32 = 11;
pub const CP_REG_ARM64_SYSREG_CRN_MASK: u32 = 1920;
pub const CP_REG_ARM64_SYSREG_CRN_SHIFT: u32 = 7;
pub const CP_REG_ARM64_SYSREG_CRM_MASK: u32 = 120;
pub const CP_REG_ARM64_SYSREG_CRM_SHIFT: u32 = 3;
pub const CP_REG_ARM64_SYSREG_OP2_MASK: u32 = 7;
pub const CP_REG_ARM64_SYSREG_OP2_SHIFT: u32 = 0;
pub const CP_REG_ARM64_SYSREG_CP: u32 = 19;
pub const TARGET_LONG_BITS: u32 = 64;
pub const TCG_GUEST_DEFAULT_MO: u32 = 0;
pub const TYPE_OBJECT: &'static [u8; 7usize] = b"object\0";
pub const OBJECT_CLASS_CAST_CACHE: u32 = 4;
pub const TYPE_INTERFACE: &'static [u8; 10usize] = b"interface\0";
pub const TYPE_IRQ: &'static [u8; 4usize] = b"irq\0";
pub const TYPE_HOTPLUG_HANDLER: &'static [u8; 16usize] = b"hotplug-handler\0";
pub const TYPE_DEVICE: &'static [u8; 7usize] = b"device\0";
pub const TYPE_BUS: &'static [u8; 4usize] = b"bus\0";
pub const QDEV_HOTPLUG_HANDLER_PROPERTY: &'static [u8; 16usize] = b"hotplug-handler\0";
pub const bfd_mach_m68000: u32 = 1;
pub const bfd_mach_m68008: u32 = 2;
pub const bfd_mach_m68010: u32 = 3;
pub const bfd_mach_m68020: u32 = 4;
pub const bfd_mach_m68030: u32 = 5;
pub const bfd_mach_m68040: u32 = 6;
pub const bfd_mach_m68060: u32 = 7;
pub const bfd_mach_cpu32: u32 = 8;
pub const bfd_mach_mcf5200: u32 = 9;
pub const bfd_mach_mcf5206e: u32 = 10;
pub const bfd_mach_mcf5307: u32 = 11;
pub const bfd_mach_mcf5407: u32 = 12;
pub const bfd_mach_mcf528x: u32 = 13;
pub const bfd_mach_mcfv4e: u32 = 14;
pub const bfd_mach_mcf521x: u32 = 15;
pub const bfd_mach_mcf5249: u32 = 16;
pub const bfd_mach_mcf547x: u32 = 17;
pub const bfd_mach_mcf548x: u32 = 18;
pub const bfd_mach_i960_core: u32 = 1;
pub const bfd_mach_i960_ka_sa: u32 = 2;
pub const bfd_mach_i960_kb_sb: u32 = 3;
pub const bfd_mach_i960_mc: u32 = 4;
pub const bfd_mach_i960_xa: u32 = 5;
pub const bfd_mach_i960_ca: u32 = 6;
pub const bfd_mach_i960_jx: u32 = 7;
pub const bfd_mach_i960_hx: u32 = 8;
pub const bfd_mach_sparc: u32 = 1;
pub const bfd_mach_sparc_sparclet: u32 = 2;
pub const bfd_mach_sparc_sparclite: u32 = 3;
pub const bfd_mach_sparc_v8plus: u32 = 4;
pub const bfd_mach_sparc_v8plusa: u32 = 5;
pub const bfd_mach_sparc_sparclite_le: u32 = 6;
pub const bfd_mach_sparc_v9: u32 = 7;
pub const bfd_mach_sparc_v9a: u32 = 8;
pub const bfd_mach_sparc_v8plusb: u32 = 9;
pub const bfd_mach_sparc_v9b: u32 = 10;
pub const bfd_mach_mips3000: u32 = 3000;
pub const bfd_mach_mips3900: u32 = 3900;
pub const bfd_mach_mips4000: u32 = 4000;
pub const bfd_mach_mips4010: u32 = 4010;
pub const bfd_mach_mips4100: u32 = 4100;
pub const bfd_mach_mips4300: u32 = 4300;
pub const bfd_mach_mips4400: u32 = 4400;
pub const bfd_mach_mips4600: u32 = 4600;
pub const bfd_mach_mips4650: u32 = 4650;
pub const bfd_mach_mips5000: u32 = 5000;
pub const bfd_mach_mips6000: u32 = 6000;
pub const bfd_mach_mips8000: u32 = 8000;
pub const bfd_mach_mips10000: u32 = 10000;
pub const bfd_mach_mips16: u32 = 16;
pub const bfd_mach_i386_i386: u32 = 0;
pub const bfd_mach_i386_i8086: u32 = 1;
pub const bfd_mach_i386_i386_intel_syntax: u32 = 2;
pub const bfd_mach_x86_64: u32 = 3;
pub const bfd_mach_x86_64_intel_syntax: u32 = 4;
pub const bfd_mach_h8300: u32 = 1;
pub const bfd_mach_h8300h: u32 = 2;
pub const bfd_mach_h8300s: u32 = 3;
pub const bfd_mach_ppc: u32 = 0;
pub const bfd_mach_ppc64: u32 = 1;
pub const bfd_mach_ppc_403: u32 = 403;
pub const bfd_mach_ppc_403gc: u32 = 4030;
pub const bfd_mach_ppc_e500: u32 = 500;
pub const bfd_mach_ppc_505: u32 = 505;
pub const bfd_mach_ppc_601: u32 = 601;
pub const bfd_mach_ppc_602: u32 = 602;
pub const bfd_mach_ppc_603: u32 = 603;
pub const bfd_mach_ppc_ec603e: u32 = 6031;
pub const bfd_mach_ppc_604: u32 = 604;
pub const bfd_mach_ppc_620: u32 = 620;
pub const bfd_mach_ppc_630: u32 = 630;
pub const bfd_mach_ppc_750: u32 = 750;
pub const bfd_mach_ppc_860: u32 = 860;
pub const bfd_mach_ppc_a35: u32 = 35;
pub const bfd_mach_ppc_rs64ii: u32 = 642;
pub const bfd_mach_ppc_rs64iii: u32 = 643;
pub const bfd_mach_ppc_7400: u32 = 7400;
pub const bfd_mach_hppa10: u32 = 10;
pub const bfd_mach_hppa11: u32 = 11;
pub const bfd_mach_hppa20: u32 = 20;
pub const bfd_mach_hppa20w: u32 = 25;
pub const bfd_mach_z8001: u32 = 1;
pub const bfd_mach_z8002: u32 = 2;
pub const bfd_mach_sh: u32 = 1;
pub const bfd_mach_sh2: u32 = 32;
pub const bfd_mach_sh_dsp: u32 = 45;
pub const bfd_mach_sh2a: u32 = 42;
pub const bfd_mach_sh2a_nofpu: u32 = 43;
pub const bfd_mach_sh2e: u32 = 46;
pub const bfd_mach_sh3: u32 = 48;
pub const bfd_mach_sh3_nommu: u32 = 49;
pub const bfd_mach_sh3_dsp: u32 = 61;
pub const bfd_mach_sh3e: u32 = 62;
pub const bfd_mach_sh4: u32 = 64;
pub const bfd_mach_sh4_nofpu: u32 = 65;
pub const bfd_mach_sh4_nommu_nofpu: u32 = 66;
pub const bfd_mach_sh4a: u32 = 74;
pub const bfd_mach_sh4a_nofpu: u32 = 75;
pub const bfd_mach_sh4al_dsp: u32 = 77;
pub const bfd_mach_sh5: u32 = 80;
pub const bfd_mach_alpha: u32 = 1;
pub const bfd_mach_alpha_ev4: u32 = 16;
pub const bfd_mach_alpha_ev5: u32 = 32;
pub const bfd_mach_alpha_ev6: u32 = 48;
pub const bfd_mach_arm_unknown: u32 = 0;
pub const bfd_mach_arm_2: u32 = 1;
pub const bfd_mach_arm_2a: u32 = 2;
pub const bfd_mach_arm_3: u32 = 3;
pub const bfd_mach_arm_3M: u32 = 4;
pub const bfd_mach_arm_4: u32 = 5;
pub const bfd_mach_arm_4T: u32 = 6;
pub const bfd_mach_arm_5: u32 = 7;
pub const bfd_mach_arm_5T: u32 = 8;
pub const bfd_mach_arm_5TE: u32 = 9;
pub const bfd_mach_arm_XScale: u32 = 10;
pub const bfd_mach_arm_ep9312: u32 = 11;
pub const bfd_mach_arm_iWMMXt: u32 = 12;
pub const bfd_mach_arm_iWMMXt2: u32 = 13;
pub const bfd_mach_v850: u32 = 0;
pub const bfd_mach_arc_base: u32 = 0;
pub const bfd_mach_m32r: u32 = 0;
pub const bfd_mach_cris_v0_v10: u32 = 255;
pub const bfd_mach_cris_v32: u32 = 32;
pub const bfd_mach_cris_v10_v32: u32 = 1032;
pub const bfd_mach_ia64_elf64: u32 = 64;
pub const bfd_mach_ia64_elf32: u32 = 32;
pub const bfd_mach_nios2: u32 = 0;
pub const bfd_mach_nios2r1: u32 = 1;
pub const bfd_mach_nios2r2: u32 = 2;
pub const bfd_mach_lm32: u32 = 1;
pub const bfd_mach_s390_31: u32 = 31;
pub const bfd_mach_s390_64: u32 = 64;
pub const INSN_HAS_RELOC: u32 = 2147483648;
pub const INSN_ARM_BE32: u32 = 65536;
pub const HWADDR_BITS: u32 = 64;
pub const TARGET_FMT_plx: &'static [u8; 7usize] = b"%016lx\0";
pub const HWADDR_PRId: &'static [u8; 3usize] = b"ld\0";
pub const HWADDR_PRIi: &'static [u8; 3usize] = b"li\0";
pub const HWADDR_PRIo: &'static [u8; 3usize] = b"lo\0";
pub const HWADDR_PRIu: &'static [u8; 3usize] = b"lu\0";
pub const HWADDR_PRIx: &'static [u8; 3usize] = b"lx\0";
pub const HWADDR_PRIX: &'static [u8; 3usize] = b"lX\0";
pub const _SEMAPHORE_H: u32 = 1;
pub const __SIZEOF_SEM_T: u32 = 32;
pub const QEMU_THREAD_JOINABLE: u32 = 0;
pub const QEMU_THREAD_DETACHED: u32 = 1;
pub const VADDR_PRId: &'static [u8; 3usize] = b"ld\0";
pub const VADDR_PRIu: &'static [u8; 3usize] = b"lu\0";
pub const VADDR_PRIo: &'static [u8; 3usize] = b"lo\0";
pub const VADDR_PRIx: &'static [u8; 3usize] = b"lx\0";
pub const VADDR_PRIX: &'static [u8; 3usize] = b"lX\0";
pub const TYPE_CPU: &'static [u8; 4usize] = b"cpu\0";
pub const TB_JMP_CACHE_BITS: u32 = 12;
pub const TB_JMP_CACHE_SIZE: u32 = 4096;
pub const SSTEP_ENABLE: u32 = 1;
pub const SSTEP_NOIRQ: u32 = 2;
pub const SSTEP_NOTIMER: u32 = 4;
pub const BP_MEM_READ: u32 = 1;
pub const BP_MEM_WRITE: u32 = 2;
pub const BP_MEM_ACCESS: u32 = 3;
pub const BP_STOP_BEFORE_ACCESS: u32 = 4;
pub const BP_GDB: u32 = 16;
pub const BP_CPU: u32 = 32;
pub const BP_ANY: u32 = 48;
pub const BP_WATCHPOINT_HIT_READ: u32 = 64;
pub const BP_WATCHPOINT_HIT_WRITE: u32 = 128;
pub const BP_WATCHPOINT_HIT: u32 = 192;
pub const GDB_RDONE: u32 = 1;
pub const GDB_RSTEP: u32 = 2;
pub const GDB_RCONT: u32 = 4;
pub const GDB_RCONT_BREAK: u32 = 8;
pub const UNASSIGNED_CPU_INDEX: i32 = -1;
pub const TYPE_ARM_CPU: &'static [u8; 8usize] = b"arm-cpu\0";
pub const TYPE_AARCH64_CPU: &'static [u8; 12usize] = b"aarch64-cpu\0";
pub const ARM_AFF0_SHIFT: u32 = 0;
pub const ARM_AFF0_MASK: u32 = 255;
pub const ARM_AFF1_SHIFT: u32 = 8;
pub const ARM_AFF1_MASK: u32 = 65280;
pub const ARM_AFF2_SHIFT: u32 = 16;
pub const ARM_AFF2_MASK: u32 = 16711680;
pub const ARM_AFF3_SHIFT: u32 = 32;
pub const ARM_AFF3_MASK: u64 = 1095216660480;
pub const ARM_DEFAULT_CPUS_PER_CLUSTER: u32 = 8;
pub const ARM32_AFFINITY_MASK: u32 = 16777215;
pub const ARM64_AFFINITY_MASK: u64 = 1095233437695;
pub const ARM64_AFFINITY_INVALID: i64 = -1095233437696;
pub const TCG_TARGET_INSN_UNIT_SIZE: u32 = 4;
pub const TCG_TARGET_TLB_DISPLACEMENT_BITS: u32 = 24;
pub const TCG_TARGET_NB_REGS: u32 = 32;
pub const TCG_TARGET_STACK_ALIGN: u32 = 16;
pub const TCG_TARGET_CALL_ALIGN_ARGS: u32 = 1;
pub const TCG_TARGET_CALL_STACK_OFFSET: u32 = 0;
pub const TCG_TARGET_HAS_div_i32: u32 = 1;
pub const TCG_TARGET_HAS_rem_i32: u32 = 1;
pub const TCG_TARGET_HAS_ext8s_i32: u32 = 1;
pub const TCG_TARGET_HAS_ext16s_i32: u32 = 1;
pub const TCG_TARGET_HAS_ext8u_i32: u32 = 1;
pub const TCG_TARGET_HAS_ext16u_i32: u32 = 1;
pub const TCG_TARGET_HAS_bswap16_i32: u32 = 1;
pub const TCG_TARGET_HAS_bswap32_i32: u32 = 1;
pub const TCG_TARGET_HAS_not_i32: u32 = 1;
pub const TCG_TARGET_HAS_neg_i32: u32 = 1;
pub const TCG_TARGET_HAS_rot_i32: u32 = 1;
pub const TCG_TARGET_HAS_andc_i32: u32 = 1;
pub const TCG_TARGET_HAS_orc_i32: u32 = 1;
pub const TCG_TARGET_HAS_eqv_i32: u32 = 1;
pub const TCG_TARGET_HAS_nand_i32: u32 = 0;
pub const TCG_TARGET_HAS_nor_i32: u32 = 0;
pub const TCG_TARGET_HAS_clz_i32: u32 = 1;
pub const TCG_TARGET_HAS_ctz_i32: u32 = 1;
pub const TCG_TARGET_HAS_ctpop_i32: u32 = 0;
pub const TCG_TARGET_HAS_deposit_i32: u32 = 1;
pub const TCG_TARGET_HAS_extract_i32: u32 = 1;
pub const TCG_TARGET_HAS_sextract_i32: u32 = 1;
pub const TCG_TARGET_HAS_movcond_i32: u32 = 1;
pub const TCG_TARGET_HAS_add2_i32: u32 = 1;
pub const TCG_TARGET_HAS_sub2_i32: u32 = 1;
pub const TCG_TARGET_HAS_mulu2_i32: u32 = 0;
pub const TCG_TARGET_HAS_muls2_i32: u32 = 0;
pub const TCG_TARGET_HAS_muluh_i32: u32 = 0;
pub const TCG_TARGET_HAS_mulsh_i32: u32 = 0;
pub const TCG_TARGET_HAS_extrl_i64_i32: u32 = 0;
pub const TCG_TARGET_HAS_extrh_i64_i32: u32 = 0;
pub const TCG_TARGET_HAS_div_i64: u32 = 1;
pub const TCG_TARGET_HAS_rem_i64: u32 = 1;
pub const TCG_TARGET_HAS_ext8s_i64: u32 = 1;
pub const TCG_TARGET_HAS_ext16s_i64: u32 = 1;
pub const TCG_TARGET_HAS_ext32s_i64: u32 = 1;
pub const TCG_TARGET_HAS_ext8u_i64: u32 = 1;
pub const TCG_TARGET_HAS_ext16u_i64: u32 = 1;
pub const TCG_TARGET_HAS_ext32u_i64: u32 = 1;
pub const TCG_TARGET_HAS_bswap16_i64: u32 = 1;
pub const TCG_TARGET_HAS_bswap32_i64: u32 = 1;
pub const TCG_TARGET_HAS_bswap64_i64: u32 = 1;
pub const TCG_TARGET_HAS_not_i64: u32 = 1;
pub const TCG_TARGET_HAS_neg_i64: u32 = 1;
pub const TCG_TARGET_HAS_rot_i64: u32 = 1;
pub const TCG_TARGET_HAS_andc_i64: u32 = 1;
pub const TCG_TARGET_HAS_orc_i64: u32 = 1;
pub const TCG_TARGET_HAS_eqv_i64: u32 = 1;
pub const TCG_TARGET_HAS_nand_i64: u32 = 0;
pub const TCG_TARGET_HAS_nor_i64: u32 = 0;
pub const TCG_TARGET_HAS_clz_i64: u32 = 1;
pub const TCG_TARGET_HAS_ctz_i64: u32 = 1;
pub const TCG_TARGET_HAS_ctpop_i64: u32 = 0;
pub const TCG_TARGET_HAS_deposit_i64: u32 = 1;
pub const TCG_TARGET_HAS_extract_i64: u32 = 1;
pub const TCG_TARGET_HAS_sextract_i64: u32 = 1;
pub const TCG_TARGET_HAS_movcond_i64: u32 = 1;
pub const TCG_TARGET_HAS_add2_i64: u32 = 1;
pub const TCG_TARGET_HAS_sub2_i64: u32 = 1;
pub const TCG_TARGET_HAS_mulu2_i64: u32 = 0;
pub const TCG_TARGET_HAS_muls2_i64: u32 = 0;
pub const TCG_TARGET_HAS_muluh_i64: u32 = 1;
pub const TCG_TARGET_HAS_mulsh_i64: u32 = 1;
pub const TARGET_LONG_SIZE: u32 = 8;
pub const TARGET_FMT_lx: &'static [u8; 7usize] = b"%016lx\0";
pub const TARGET_FMT_ld: &'static [u8; 4usize] = b"%ld\0";
pub const TARGET_FMT_lu: &'static [u8; 4usize] = b"%lu\0";
pub const CPU_VTLB_SIZE: u32 = 8;
pub const CPU_TLB_ENTRY_BITS: u32 = 5;
pub const EXCP_UDEF: u32 = 1;
pub const EXCP_SWI: u32 = 2;
pub const EXCP_PREFETCH_ABORT: u32 = 3;
pub const EXCP_DATA_ABORT: u32 = 4;
pub const EXCP_IRQ: u32 = 5;
pub const EXCP_FIQ: u32 = 6;
pub const EXCP_BKPT: u32 = 7;
pub const EXCP_EXCEPTION_EXIT: u32 = 8;
pub const EXCP_KERNEL_TRAP: u32 = 9;
pub const EXCP_HVC: u32 = 11;
pub const EXCP_HYP_TRAP: u32 = 12;
pub const EXCP_SMC: u32 = 13;
pub const EXCP_VIRQ: u32 = 14;
pub const EXCP_VFIQ: u32 = 15;
pub const EXCP_SEMIHOST: u32 = 16;
pub const EXCP_NOCP: u32 = 17;
pub const EXCP_INVSTATE: u32 = 18;
pub const ARMV7M_EXCP_RESET: u32 = 1;
pub const ARMV7M_EXCP_NMI: u32 = 2;
pub const ARMV7M_EXCP_HARD: u32 = 3;
pub const ARMV7M_EXCP_MEM: u32 = 4;
pub const ARMV7M_EXCP_BUS: u32 = 5;
pub const ARMV7M_EXCP_USAGE: u32 = 6;
pub const ARMV7M_EXCP_SVC: u32 = 11;
pub const ARMV7M_EXCP_DEBUG: u32 = 12;
pub const ARMV7M_EXCP_PENDSV: u32 = 14;
pub const ARMV7M_EXCP_SYSTICK: u32 = 15;
pub const ARM_CPU_IRQ: u32 = 0;
pub const ARM_CPU_FIQ: u32 = 1;
pub const ARM_CPU_VIRQ: u32 = 2;
pub const ARM_CPU_VFIQ: u32 = 3;
pub const NB_MMU_MODES: u32 = 7;
pub const TARGET_INSN_START_EXTRA_WORDS: u32 = 2;
pub const ARM_INSN_START_WORD2_MASK: u32 = 67108863;
pub const ARM_INSN_START_WORD2_SHIFT: u32 = 14;
pub const GTIMER_PHYS: u32 = 0;
pub const GTIMER_VIRT: u32 = 1;
pub const GTIMER_HYP: u32 = 2;
pub const GTIMER_SEC: u32 = 3;
pub const NUM_GTIMERS: u32 = 4;
pub const SCTLR_M: u32 = 1;
pub const SCTLR_A: u32 = 2;
pub const SCTLR_C: u32 = 4;
pub const SCTLR_W: u32 = 8;
pub const SCTLR_SA: u32 = 8;
pub const SCTLR_P: u32 = 16;
pub const SCTLR_SA0: u32 = 16;
pub const SCTLR_D: u32 = 32;
pub const SCTLR_CP15BEN: u32 = 32;
pub const SCTLR_L: u32 = 64;
pub const SCTLR_B: u32 = 128;
pub const SCTLR_ITD: u32 = 128;
pub const SCTLR_S: u32 = 256;
pub const SCTLR_SED: u32 = 256;
pub const SCTLR_R: u32 = 512;
pub const SCTLR_UMA: u32 = 512;
pub const SCTLR_F: u32 = 1024;
pub const SCTLR_SW: u32 = 1024;
pub const SCTLR_Z: u32 = 2048;
pub const SCTLR_I: u32 = 4096;
pub const SCTLR_V: u32 = 8192;
pub const SCTLR_RR: u32 = 16384;
pub const SCTLR_DZE: u32 = 16384;
pub const SCTLR_L4: u32 = 32768;
pub const SCTLR_UCT: u32 = 32768;
pub const SCTLR_DT: u32 = 65536;
pub const SCTLR_nTWI: u32 = 65536;
pub const SCTLR_HA: u32 = 131072;
pub const SCTLR_BR: u32 = 131072;
pub const SCTLR_IT: u32 = 262144;
pub const SCTLR_nTWE: u32 = 262144;
pub const SCTLR_WXN: u32 = 524288;
pub const SCTLR_ST: u32 = 1048576;
pub const SCTLR_UWXN: u32 = 1048576;
pub const SCTLR_FI: u32 = 2097152;
pub const SCTLR_U: u32 = 4194304;
pub const SCTLR_XP: u32 = 8388608;
pub const SCTLR_VE: u32 = 16777216;
pub const SCTLR_E0E: u32 = 16777216;
pub const SCTLR_EE: u32 = 33554432;
pub const SCTLR_L2: u32 = 67108864;
pub const SCTLR_UCI: u32 = 67108864;
pub const SCTLR_NMFI: u32 = 134217728;
pub const SCTLR_TRE: u32 = 268435456;
pub const SCTLR_AFE: u32 = 536870912;
pub const SCTLR_TE: u32 = 1073741824;
pub const CPTR_TCPAC: u32 = 2147483648;
pub const CPTR_TTA: u32 = 1048576;
pub const CPTR_TFP: u32 = 1024;
pub const MDCR_EPMAD: u32 = 2097152;
pub const MDCR_EDAD: u32 = 1048576;
pub const MDCR_SPME: u32 = 131072;
pub const MDCR_SDD: u32 = 65536;
pub const MDCR_SPD: u32 = 49152;
pub const MDCR_TDRA: u32 = 2048;
pub const MDCR_TDOSA: u32 = 1024;
pub const MDCR_TDA: u32 = 512;
pub const MDCR_TDE: u32 = 256;
pub const MDCR_HPME: u32 = 128;
pub const MDCR_TPM: u32 = 64;
pub const MDCR_TPMCR: u32 = 32;
pub const SDCR_VALID_MASK: u32 = 3325952;
pub const CPSR_M: u32 = 31;
pub const CPSR_T: u32 = 32;
pub const CPSR_F: u32 = 64;
pub const CPSR_I: u32 = 128;
pub const CPSR_A: u32 = 256;
pub const CPSR_E: u32 = 512;
pub const CPSR_IT_2_7: u32 = 64512;
pub const CPSR_GE: u32 = 983040;
pub const CPSR_IL: u32 = 1048576;
pub const CPSR_RESERVED: u32 = 14680064;
pub const CPSR_J: u32 = 16777216;
pub const CPSR_IT_0_1: u32 = 100663296;
pub const CPSR_Q: u32 = 134217728;
pub const CPSR_V: u32 = 268435456;
pub const CPSR_C: u32 = 536870912;
pub const CPSR_Z: u32 = 1073741824;
pub const CPSR_N: u32 = 2147483648;
pub const CPSR_NZCV: u32 = 4026531840;
pub const CPSR_AIF: u32 = 448;
pub const CPSR_IT: u32 = 100727808;
pub const CACHED_CPSR_BITS: u32 = 4262460896;
pub const CPSR_USER: u32 = 4161732608;
pub const CPSR_EXEC: u32 = 118553632;
pub const CPSR_ERET_MASK: i32 = -14680065;
pub const TTBCR_N: u32 = 7;
pub const TTBCR_T0SZ: u32 = 7;
pub const TTBCR_PD0: u32 = 16;
pub const TTBCR_PD1: u32 = 32;
pub const TTBCR_EPD0: u32 = 128;
pub const TTBCR_IRGN0: u32 = 768;
pub const TTBCR_ORGN0: u32 = 3072;
pub const TTBCR_SH0: u32 = 12288;
pub const TTBCR_T1SZ: u32 = 196608;
pub const TTBCR_A1: u32 = 4194304;
pub const TTBCR_EPD1: u32 = 8388608;
pub const TTBCR_IRGN1: u32 = 50331648;
pub const TTBCR_ORGN1: u32 = 201326592;
pub const TTBCR_SH1: u32 = 268435456;
pub const TTBCR_EAE: u32 = 2147483648;
pub const PSTATE_SP: u32 = 1;
pub const PSTATE_M: u32 = 15;
pub const PSTATE_nRW: u32 = 16;
pub const PSTATE_F: u32 = 64;
pub const PSTATE_I: u32 = 128;
pub const PSTATE_A: u32 = 256;
pub const PSTATE_D: u32 = 512;
pub const PSTATE_IL: u32 = 1048576;
pub const PSTATE_SS: u32 = 2097152;
pub const PSTATE_V: u32 = 268435456;
pub const PSTATE_C: u32 = 536870912;
pub const PSTATE_Z: u32 = 1073741824;
pub const PSTATE_N: u32 = 2147483648;
pub const PSTATE_NZCV: u32 = 4026531840;
pub const PSTATE_DAIF: u32 = 960;
pub const CACHED_PSTATE_BITS: u32 = 4026532800;
pub const PSTATE_MODE_EL3h: u32 = 13;
pub const PSTATE_MODE_EL3t: u32 = 12;
pub const PSTATE_MODE_EL2h: u32 = 9;
pub const PSTATE_MODE_EL2t: u32 = 8;
pub const PSTATE_MODE_EL1h: u32 = 5;
pub const PSTATE_MODE_EL1t: u32 = 4;
pub const PSTATE_MODE_EL0t: u32 = 0;
pub const HCR_VM: u32 = 1;
pub const HCR_SWIO: u32 = 2;
pub const HCR_PTW: u32 = 4;
pub const HCR_FMO: u32 = 8;
pub const HCR_IMO: u32 = 16;
pub const HCR_AMO: u32 = 32;
pub const HCR_VF: u32 = 64;
pub const HCR_VI: u32 = 128;
pub const HCR_VSE: u32 = 256;
pub const HCR_FB: u32 = 512;
pub const HCR_BSU_MASK: u32 = 3072;
pub const HCR_DC: u32 = 4096;
pub const HCR_TWI: u32 = 8192;
pub const HCR_TWE: u32 = 16384;
pub const HCR_TID0: u32 = 32768;
pub const HCR_TID1: u32 = 65536;
pub const HCR_TID2: u32 = 131072;
pub const HCR_TID3: u32 = 262144;
pub const HCR_TSC: u32 = 524288;
pub const HCR_TIDCP: u32 = 1048576;
pub const HCR_TACR: u32 = 2097152;
pub const HCR_TSW: u32 = 4194304;
pub const HCR_TPC: u32 = 8388608;
pub const HCR_TPU: u32 = 16777216;
pub const HCR_TTLB: u32 = 33554432;
pub const HCR_TVM: u32 = 67108864;
pub const HCR_TGE: u32 = 134217728;
pub const HCR_TDZ: u32 = 268435456;
pub const HCR_HCD: u32 = 536870912;
pub const HCR_TRVM: u32 = 1073741824;
pub const HCR_RW: u32 = 2147483648;
pub const HCR_CD: u64 = 4294967296;
pub const HCR_ID: u64 = 8589934592;
pub const HCR_MASK: u64 = 17179869183;
pub const SCR_NS: u32 = 1;
pub const SCR_IRQ: u32 = 2;
pub const SCR_FIQ: u32 = 4;
pub const SCR_EA: u32 = 8;
pub const SCR_FW: u32 = 16;
pub const SCR_AW: u32 = 32;
pub const SCR_NET: u32 = 64;
pub const SCR_SMD: u32 = 128;
pub const SCR_HCE: u32 = 256;
pub const SCR_SIF: u32 = 512;
pub const SCR_RW: u32 = 1024;
pub const SCR_ST: u32 = 2048;
pub const SCR_TWI: u32 = 4096;
pub const SCR_TWE: u32 = 8192;
pub const SCR_AARCH32_MASK: u32 = 13311;
pub const SCR_AARCH64_MASK: u32 = 16319;
pub const FPSR_MASK: u32 = 4160749727;
pub const FPCR_MASK: u32 = 133668608;
pub const ARM_VFP_FPSID: u32 = 0;
pub const ARM_VFP_FPSCR: u32 = 1;
pub const ARM_VFP_MVFR2: u32 = 5;
pub const ARM_VFP_MVFR1: u32 = 6;
pub const ARM_VFP_MVFR0: u32 = 7;
pub const ARM_VFP_FPEXC: u32 = 8;
pub const ARM_VFP_FPINST: u32 = 9;
pub const ARM_VFP_FPINST2: u32 = 10;
pub const ARM_IWMMXT_wCID: u32 = 0;
pub const ARM_IWMMXT_wCon: u32 = 1;
pub const ARM_IWMMXT_wCSSF: u32 = 2;
pub const ARM_IWMMXT_wCASF: u32 = 3;
pub const ARM_IWMMXT_wCGR0: u32 = 8;
pub const ARM_IWMMXT_wCGR1: u32 = 9;
pub const ARM_IWMMXT_wCGR2: u32 = 10;
pub const ARM_IWMMXT_wCGR3: u32 = 11;
pub const CP_REG_AA64_SHIFT: u32 = 28;
pub const CP_REG_AA64_MASK: u32 = 268435456;
pub const CP_REG_NS_SHIFT: u32 = 29;
pub const CP_REG_NS_MASK: u32 = 536870912;
pub const ARM_CP_SPECIAL: u32 = 1;
pub const ARM_CP_CONST: u32 = 2;
pub const ARM_CP_64BIT: u32 = 4;
pub const ARM_CP_SUPPRESS_TB_END: u32 = 8;
pub const ARM_CP_OVERRIDE: u32 = 16;
pub const ARM_CP_ALIAS: u32 = 32;
pub const ARM_CP_IO: u32 = 64;
pub const ARM_CP_NO_RAW: u32 = 128;
pub const ARM_CP_NOP: u32 = 257;
pub const ARM_CP_WFI: u32 = 513;
pub const ARM_CP_NZCV: u32 = 769;
pub const ARM_CP_CURRENTEL: u32 = 1025;
pub const ARM_CP_DC_ZVA: u32 = 1281;
pub const ARM_LAST_SPECIAL: u32 = 1281;
pub const ARM_CP_SENTINEL: u32 = 65535;
pub const ARM_CP_FLAG_MASK: u32 = 255;
pub const PL3_R: u32 = 128;
pub const PL3_W: u32 = 64;
pub const PL2_R: u32 = 160;
pub const PL2_W: u32 = 80;
pub const PL1_R: u32 = 168;
pub const PL1_W: u32 = 84;
pub const PL0_R: u32 = 170;
pub const PL0_W: u32 = 85;
pub const PL3_RW: u32 = 192;
pub const PL2_RW: u32 = 240;
pub const PL1_RW: u32 = 252;
pub const PL0_RW: u32 = 255;
pub const CP_ANY: u32 = 255;
pub const ARM_CPUID_TI915T: u32 = 1409454418;
pub const ARM_CPUID_TI925T: u32 = 1409454674;
pub const TARGET_PAGE_BITS_MIN: u32 = 10;
pub const TARGET_PHYS_ADDR_SPACE_BITS: u32 = 48;
pub const TARGET_VIRT_ADDR_SPACE_BITS: u32 = 64;
pub const MMU_USER_IDX: u32 = 0;
pub const RAM_ADDR_FMT: &'static [u8; 4usize] = b"%lx\0";
pub const DIRTY_MEMORY_VGA: u32 = 0;
pub const DIRTY_MEMORY_CODE: u32 = 1;
pub const DIRTY_MEMORY_MIGRATION: u32 = 2;
pub const DIRTY_MEMORY_NUM: u32 = 3;
pub const MAX_PHYS_ADDR_SPACE_BITS: u32 = 62;
pub const TYPE_MEMORY_REGION: &'static [u8; 19usize] = b"qemu:memory-region\0";
pub const MEMTX_OK: u32 = 0;
pub const MEMTX_ERROR: u32 = 1;
pub const MEMTX_DECODE_ERROR: u32 = 2;
pub const EXCP_INTERRUPT: u32 = 65536;
pub const EXCP_HLT: u32 = 65537;
pub const EXCP_DEBUG: u32 = 65538;
pub const EXCP_HALTED: u32 = 65539;
pub const EXCP_YIELD: u32 = 65540;
pub const EXCP_ATOMIC: u32 = 65541;
pub const PAGE_READ: u32 = 1;
pub const PAGE_WRITE: u32 = 2;
pub const PAGE_EXEC: u32 = 4;
pub const PAGE_BITS: u32 = 7;
pub const PAGE_VALID: u32 = 8;
pub const PAGE_WRITE_ORG: u32 = 16;
pub const CPU_INTERRUPT_HARD: u32 = 2;
pub const CPU_INTERRUPT_EXITTB: u32 = 4;
pub const CPU_INTERRUPT_HALT: u32 = 32;
pub const CPU_INTERRUPT_DEBUG: u32 = 128;
pub const CPU_INTERRUPT_RESET: u32 = 1024;
pub const CPU_INTERRUPT_TGT_EXT_0: u32 = 8;
pub const CPU_INTERRUPT_TGT_EXT_1: u32 = 16;
pub const CPU_INTERRUPT_TGT_EXT_2: u32 = 64;
pub const CPU_INTERRUPT_TGT_EXT_3: u32 = 512;
pub const CPU_INTERRUPT_TGT_EXT_4: u32 = 4096;
pub const CPU_INTERRUPT_TGT_INT_0: u32 = 256;
pub const CPU_INTERRUPT_TGT_INT_1: u32 = 2048;
pub const CPU_INTERRUPT_TGT_INT_2: u32 = 8192;
pub const CPU_INTERRUPT_SSTEP_MASK: u32 = 4698;
pub const ARM_TBFLAG_AARCH64_STATE_SHIFT: u32 = 31;
pub const ARM_TBFLAG_AARCH64_STATE_MASK: u32 = 2147483648;
pub const ARM_TBFLAG_MMUIDX_SHIFT: u32 = 28;
pub const ARM_TBFLAG_MMUIDX_MASK: u32 = 1879048192;
pub const ARM_TBFLAG_SS_ACTIVE_SHIFT: u32 = 27;
pub const ARM_TBFLAG_SS_ACTIVE_MASK: u32 = 134217728;
pub const ARM_TBFLAG_PSTATE_SS_SHIFT: u32 = 26;
pub const ARM_TBFLAG_PSTATE_SS_MASK: u32 = 67108864;
pub const ARM_TBFLAG_FPEXC_EL_SHIFT: u32 = 24;
pub const ARM_TBFLAG_FPEXC_EL_MASK: u32 = 50331648;
pub const ARM_TBFLAG_THUMB_SHIFT: u32 = 0;
pub const ARM_TBFLAG_THUMB_MASK: u32 = 1;
pub const ARM_TBFLAG_VECLEN_SHIFT: u32 = 1;
pub const ARM_TBFLAG_VECLEN_MASK: u32 = 14;
pub const ARM_TBFLAG_VECSTRIDE_SHIFT: u32 = 4;
pub const ARM_TBFLAG_VECSTRIDE_MASK: u32 = 48;
pub const ARM_TBFLAG_VFPEN_SHIFT: u32 = 7;
pub const ARM_TBFLAG_VFPEN_MASK: u32 = 128;
pub const ARM_TBFLAG_CONDEXEC_SHIFT: u32 = 8;
pub const ARM_TBFLAG_CONDEXEC_MASK: u32 = 65280;
pub const ARM_TBFLAG_SCTLR_B_SHIFT: u32 = 16;
pub const ARM_TBFLAG_SCTLR_B_MASK: u32 = 65536;
pub const ARM_TBFLAG_XSCALE_CPAR_SHIFT: u32 = 17;
pub const ARM_TBFLAG_XSCALE_CPAR_MASK: u32 = 393216;
pub const ARM_TBFLAG_NS_SHIFT: u32 = 19;
pub const ARM_TBFLAG_NS_MASK: u32 = 524288;
pub const ARM_TBFLAG_BE_DATA_SHIFT: u32 = 20;
pub const ARM_TBFLAG_BE_DATA_MASK: u32 = 1048576;
pub const ARM_TBFLAG_TBI0_SHIFT: u32 = 0;
pub const ARM_TBFLAG_TBI0_MASK: u32 = 1;
pub const ARM_TBFLAG_TBI1_SHIFT: u32 = 1;
pub const ARM_TBFLAG_TBI1_MASK: u32 = 2;
pub const TARGET_PTR_FMT: &'static [u8; 7usize] = b"%016lx\0";
pub const TARGET_PID_FMT: &'static [u8; 3usize] = b"%u\0";
pub const QHT_MODE_AUTO_RESIZE: u32 = 1;
pub const CODE_GEN_HTABLE_BITS: u32 = 15;
pub const CODE_GEN_HTABLE_SIZE: u32 = 32768;
pub const DISAS_NEXT: u32 = 0;
pub const DISAS_JUMP: u32 = 1;
pub const DISAS_UPDATE: u32 = 2;
pub const DISAS_TB_JUMP: u32 = 3;
pub const CPU_LOG_TB_OUT_ASM: u32 = 1;
pub const CPU_LOG_TB_IN_ASM: u32 = 2;
pub const CPU_LOG_TB_OP: u32 = 4;
pub const CPU_LOG_TB_OP_OPT: u32 = 8;
pub const CPU_LOG_INT: u32 = 16;
pub const CPU_LOG_EXEC: u32 = 32;
pub const CPU_LOG_PCALL: u32 = 64;
pub const CPU_LOG_TB_CPU: u32 = 256;
pub const CPU_LOG_RESET: u32 = 512;
pub const LOG_UNIMP: u32 = 1024;
pub const LOG_GUEST_ERROR: u32 = 2048;
pub const CPU_LOG_MMU: u32 = 4096;
pub const CPU_LOG_TB_NOCHAIN: u32 = 8192;
pub const CPU_LOG_PAGE: u32 = 16384;
pub const LOG_TRACE: u32 = 32768;
pub const CPU_LOG_TB_OP_IND: u32 = 65536;
pub const CPU_LOG_TAINT_OPS: u32 = 268435456;
pub const CPU_LOG_RR: u32 = 536870912;
pub const CPU_LOG_LLVM_IR: u32 = 1073741824;
pub const CPU_LOG_LLVM_ASM: u32 = 2147483648;
pub const CODE_GEN_ALIGN: u32 = 16;
pub const CODE_GEN_AVG_BLOCK_SIZE: u32 = 400;
pub const CF_COUNT_MASK: u32 = 32767;
pub const CF_LAST_IO: u32 = 32768;
pub const CF_NOCACHE: u32 = 65536;
pub const CF_USE_ICOUNT: u32 = 131072;
pub const CF_IGNORE_ICOUNT: u32 = 262144;
pub const TB_JMP_RESET_OFFSET_INVALID: u32 = 65535;
pub const GETPC_ADJ: u32 = 2;
pub const MAX_OP_PER_INSTR: u32 = 266;
pub const MAX_OPC_PARAM_PER_ARG: u32 = 1;
pub const MAX_OPC_PARAM_IARGS: u32 = 5;
pub const MAX_OPC_PARAM_OARGS: u32 = 1;
pub const MAX_OPC_PARAM_ARGS: u32 = 6;
pub const MAX_OPC_PARAM: u32 = 10;
pub const OPC_BUF_SIZE: u32 = 640;
pub const OPC_MAX_SIZE: u32 = 374;
pub const OPPARAM_BUF_SIZE: u32 = 6400;
pub const CPU_TEMP_BUF_NLONGS: u32 = 128;
pub const TCG_TARGET_REG_BITS: u32 = 64;
pub const TCG_PRIlx: &'static [u8; 3usize] = b"lx\0";
pub const TCG_PRIld: &'static [u8; 3usize] = b"ld\0";
pub const TCG_OVERSIZED_GUEST: u32 = 0;
pub const TCG_TARGET_HAS_div2_i32: u32 = 0;
pub const TCG_TARGET_HAS_div2_i64: u32 = 0;
pub const TARGET_INSN_START_WORDS: u32 = 3;
pub const TCG_POOL_CHUNK_SIZE: u32 = 32768;
pub const TCG_MAX_TEMPS: u32 = 512;
pub const TCG_MAX_INSNS: u32 = 512;
pub const TCG_STATIC_CALL_ARGS_SIZE: u32 = 128;
pub const TCG_CALL_NO_READ_GLOBALS: u32 = 16;
pub const TCG_CALL_NO_WRITE_GLOBALS: u32 = 32;
pub const TCG_CALL_NO_SIDE_EFFECTS: u32 = 64;
pub const TCG_CALL_NO_RWG: u32 = 16;
pub const TCG_CALL_NO_WG: u32 = 32;
pub const TCG_CALL_NO_SE: u32 = 64;
pub const TCG_CALL_NO_RWG_SE: u32 = 80;
pub const TCG_CALL_NO_WG_SE: u32 = 96;
pub const DEAD_ARG: u32 = 4;
pub const SYNC_ARG: u32 = 1;
pub const TCG_CT_ALIAS: u32 = 128;
pub const TCG_CT_IALIAS: u32 = 64;
pub const TCG_CT_NEWREG: u32 = 32;
pub const TCG_CT_REG: u32 = 1;
pub const TCG_CT_CONST: u32 = 2;
pub const TCG_MAX_OP_ARGS: u32 = 16;
pub const TB_EXIT_MASK: u32 = 3;
pub const TB_EXIT_IDX0: u32 = 0;
pub const TB_EXIT_IDX1: u32 = 1;
pub const TB_EXIT_ICOUNT_EXPIRED: u32 = 2;
pub const TB_EXIT_REQUESTED: u32 = 3;
pub const MAX_PANDA_PLUGINS: u32 = 16;
pub const MAX_PANDA_PLUGIN_ARGS: u32 = 32;
pub const _DLFCN_H: u32 = 1;
pub const RTLD_LAZY: u32 = 1;
pub const RTLD_NOW: u32 = 2;
pub const RTLD_BINDING_MASK: u32 = 3;
pub const RTLD_NOLOAD: u32 = 4;
pub const RTLD_DEEPBIND: u32 = 8;
pub const RTLD_GLOBAL: u32 = 256;
pub const RTLD_LOCAL: u32 = 0;
pub const RTLD_NODELETE: u32 = 4096;
pub const PPP_MAX_CB: u32 = 256;
pub const MAX_MEM_LEVEL: u32 = 9;
pub const MAX_WBITS: u32 = 15;
pub const ZLIB_VERSION: &'static [u8; 7usize] = b"1.2.11\0";
pub const ZLIB_VERNUM: u32 = 4784;
pub const ZLIB_VER_MAJOR: u32 = 1;
pub const ZLIB_VER_MINOR: u32 = 2;
pub const ZLIB_VER_REVISION: u32 = 11;
pub const ZLIB_VER_SUBREVISION: u32 = 0;
pub const Z_NO_FLUSH: u32 = 0;
pub const Z_PARTIAL_FLUSH: u32 = 1;
pub const Z_SYNC_FLUSH: u32 = 2;
pub const Z_FULL_FLUSH: u32 = 3;
pub const Z_FINISH: u32 = 4;
pub const Z_BLOCK: u32 = 5;
pub const Z_TREES: u32 = 6;
pub const Z_OK: u32 = 0;
pub const Z_STREAM_END: u32 = 1;
pub const Z_NEED_DICT: u32 = 2;
pub const Z_ERRNO: i32 = -1;
pub const Z_STREAM_ERROR: i32 = -2;
pub const Z_DATA_ERROR: i32 = -3;
pub const Z_MEM_ERROR: i32 = -4;
pub const Z_BUF_ERROR: i32 = -5;
pub const Z_VERSION_ERROR: i32 = -6;
pub const Z_NO_COMPRESSION: u32 = 0;
pub const Z_BEST_SPEED: u32 = 1;
pub const Z_BEST_COMPRESSION: u32 = 9;
pub const Z_DEFAULT_COMPRESSION: i32 = -1;
pub const Z_FILTERED: u32 = 1;
pub const Z_HUFFMAN_ONLY: u32 = 2;
pub const Z_RLE: u32 = 3;
pub const Z_FIXED: u32 = 4;
pub const Z_DEFAULT_STRATEGY: u32 = 0;
pub const Z_BINARY: u32 = 0;
pub const Z_TEXT: u32 = 1;
pub const Z_ASCII: u32 = 1;
pub const Z_UNKNOWN: u32 = 2;
pub const Z_DEFLATED: u32 = 8;
pub const Z_NULL: u32 = 0;
pub const PROTOBUF_C__SERVICE_DESCRIPTOR_MAGIC: u32 = 336960451;
pub const PROTOBUF_C__MESSAGE_DESCRIPTOR_MAGIC: u32 = 682290937;
pub const PROTOBUF_C__ENUM_DESCRIPTOR_MAGIC: u32 = 289609135;
pub const PROTOBUF_C_VERSION: &'static [u8; 6usize] = b"1.3.3\0";
pub const PROTOBUF_C_VERSION_NUMBER: u32 = 1003003;
pub const PROTOBUF_C_MIN_COMPILER_VERSION: u32 = 1000000;
pub type size_t = ::std::os::raw::c_ulong;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
pub type off_t = __off_t;
pub type ssize_t = __ssize_t;
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
extern "C" {
    pub fn gnu_dev_major(__dev: __dev_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_minor(__dev: __dev_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_makedev(
        __major: ::std::os::raw::c_uint,
        __minor: ::std::os::raw::c_uint,
    ) -> __dev_t;
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> size_t;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: size_t,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn reallocarray(
        __ptr: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: size_t,
        __size: size_t,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        __pwcs: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcstombs(
        __s: *mut ::std::os::raw::c_char,
        __pwcs: *const wchar_t,
        __n: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
        __l: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: size_t) -> size_t;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: size_t,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(__l: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(__ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: size_t,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn explicit_bzero(__s: *mut ::std::os::raw::c_void, __n: size_t);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __gwchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
extern "C" {
    pub fn imaxabs(__n: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub type useconds_t = __useconds_t;
pub type socklen_t = __socklen_t;
extern "C" {
    pub fn access(
        __name: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(
        __fd: ::std::os::raw::c_int,
        __offset: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> __off_t;
}
extern "C" {
    pub fn close(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn write(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pread(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: size_t,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwrite(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pipe(__pipedes: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alarm(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sleep(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn ualarm(__value: __useconds_t, __interval: __useconds_t) -> __useconds_t;
}
extern "C" {
    pub fn usleep(__useconds: __useconds_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(
        __fd: ::std::os::raw::c_int,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chdir(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchdir(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getcwd(
        __buf: *mut ::std::os::raw::c_char,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwd(__buf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn dup(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(__fd: ::std::os::raw::c_int, __fd2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __environ: *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn execve(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fexecve(
        __fd: ::std::os::raw::c_int,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        __file: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nice(__inc: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _exit(__status: ::std::os::raw::c_int);
}
pub const _PC_LINK_MAX: ::std::os::raw::c_uint = 0;
pub const _PC_MAX_CANON: ::std::os::raw::c_uint = 1;
pub const _PC_MAX_INPUT: ::std::os::raw::c_uint = 2;
pub const _PC_NAME_MAX: ::std::os::raw::c_uint = 3;
pub const _PC_PATH_MAX: ::std::os::raw::c_uint = 4;
pub const _PC_PIPE_BUF: ::std::os::raw::c_uint = 5;
pub const _PC_CHOWN_RESTRICTED: ::std::os::raw::c_uint = 6;
pub const _PC_NO_TRUNC: ::std::os::raw::c_uint = 7;
pub const _PC_VDISABLE: ::std::os::raw::c_uint = 8;
pub const _PC_SYNC_IO: ::std::os::raw::c_uint = 9;
pub const _PC_ASYNC_IO: ::std::os::raw::c_uint = 10;
pub const _PC_PRIO_IO: ::std::os::raw::c_uint = 11;
pub const _PC_SOCK_MAXBUF: ::std::os::raw::c_uint = 12;
pub const _PC_FILESIZEBITS: ::std::os::raw::c_uint = 13;
pub const _PC_REC_INCR_XFER_SIZE: ::std::os::raw::c_uint = 14;
pub const _PC_REC_MAX_XFER_SIZE: ::std::os::raw::c_uint = 15;
pub const _PC_REC_MIN_XFER_SIZE: ::std::os::raw::c_uint = 16;
pub const _PC_REC_XFER_ALIGN: ::std::os::raw::c_uint = 17;
pub const _PC_ALLOC_SIZE_MIN: ::std::os::raw::c_uint = 18;
pub const _PC_SYMLINK_MAX: ::std::os::raw::c_uint = 19;
pub const _PC_2_SYMLINKS: ::std::os::raw::c_uint = 20;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub const _SC_ARG_MAX: ::std::os::raw::c_uint = 0;
pub const _SC_CHILD_MAX: ::std::os::raw::c_uint = 1;
pub const _SC_CLK_TCK: ::std::os::raw::c_uint = 2;
pub const _SC_NGROUPS_MAX: ::std::os::raw::c_uint = 3;
pub const _SC_OPEN_MAX: ::std::os::raw::c_uint = 4;
pub const _SC_STREAM_MAX: ::std::os::raw::c_uint = 5;
pub const _SC_TZNAME_MAX: ::std::os::raw::c_uint = 6;
pub const _SC_JOB_CONTROL: ::std::os::raw::c_uint = 7;
pub const _SC_SAVED_IDS: ::std::os::raw::c_uint = 8;
pub const _SC_REALTIME_SIGNALS: ::std::os::raw::c_uint = 9;
pub const _SC_PRIORITY_SCHEDULING: ::std::os::raw::c_uint = 10;
pub const _SC_TIMERS: ::std::os::raw::c_uint = 11;
pub const _SC_ASYNCHRONOUS_IO: ::std::os::raw::c_uint = 12;
pub const _SC_PRIORITIZED_IO: ::std::os::raw::c_uint = 13;
pub const _SC_SYNCHRONIZED_IO: ::std::os::raw::c_uint = 14;
pub const _SC_FSYNC: ::std::os::raw::c_uint = 15;
pub const _SC_MAPPED_FILES: ::std::os::raw::c_uint = 16;
pub const _SC_MEMLOCK: ::std::os::raw::c_uint = 17;
pub const _SC_MEMLOCK_RANGE: ::std::os::raw::c_uint = 18;
pub const _SC_MEMORY_PROTECTION: ::std::os::raw::c_uint = 19;
pub const _SC_MESSAGE_PASSING: ::std::os::raw::c_uint = 20;
pub const _SC_SEMAPHORES: ::std::os::raw::c_uint = 21;
pub const _SC_SHARED_MEMORY_OBJECTS: ::std::os::raw::c_uint = 22;
pub const _SC_AIO_LISTIO_MAX: ::std::os::raw::c_uint = 23;
pub const _SC_AIO_MAX: ::std::os::raw::c_uint = 24;
pub const _SC_AIO_PRIO_DELTA_MAX: ::std::os::raw::c_uint = 25;
pub const _SC_DELAYTIMER_MAX: ::std::os::raw::c_uint = 26;
pub const _SC_MQ_OPEN_MAX: ::std::os::raw::c_uint = 27;
pub const _SC_MQ_PRIO_MAX: ::std::os::raw::c_uint = 28;
pub const _SC_VERSION: ::std::os::raw::c_uint = 29;
pub const _SC_PAGESIZE: ::std::os::raw::c_uint = 30;
pub const _SC_RTSIG_MAX: ::std::os::raw::c_uint = 31;
pub const _SC_SEM_NSEMS_MAX: ::std::os::raw::c_uint = 32;
pub const _SC_SEM_VALUE_MAX: ::std::os::raw::c_uint = 33;
pub const _SC_SIGQUEUE_MAX: ::std::os::raw::c_uint = 34;
pub const _SC_TIMER_MAX: ::std::os::raw::c_uint = 35;
pub const _SC_BC_BASE_MAX: ::std::os::raw::c_uint = 36;
pub const _SC_BC_DIM_MAX: ::std::os::raw::c_uint = 37;
pub const _SC_BC_SCALE_MAX: ::std::os::raw::c_uint = 38;
pub const _SC_BC_STRING_MAX: ::std::os::raw::c_uint = 39;
pub const _SC_COLL_WEIGHTS_MAX: ::std::os::raw::c_uint = 40;
pub const _SC_EQUIV_CLASS_MAX: ::std::os::raw::c_uint = 41;
pub const _SC_EXPR_NEST_MAX: ::std::os::raw::c_uint = 42;
pub const _SC_LINE_MAX: ::std::os::raw::c_uint = 43;
pub const _SC_RE_DUP_MAX: ::std::os::raw::c_uint = 44;
pub const _SC_CHARCLASS_NAME_MAX: ::std::os::raw::c_uint = 45;
pub const _SC_2_VERSION: ::std::os::raw::c_uint = 46;
pub const _SC_2_C_BIND: ::std::os::raw::c_uint = 47;
pub const _SC_2_C_DEV: ::std::os::raw::c_uint = 48;
pub const _SC_2_FORT_DEV: ::std::os::raw::c_uint = 49;
pub const _SC_2_FORT_RUN: ::std::os::raw::c_uint = 50;
pub const _SC_2_SW_DEV: ::std::os::raw::c_uint = 51;
pub const _SC_2_LOCALEDEF: ::std::os::raw::c_uint = 52;
pub const _SC_PII: ::std::os::raw::c_uint = 53;
pub const _SC_PII_XTI: ::std::os::raw::c_uint = 54;
pub const _SC_PII_SOCKET: ::std::os::raw::c_uint = 55;
pub const _SC_PII_INTERNET: ::std::os::raw::c_uint = 56;
pub const _SC_PII_OSI: ::std::os::raw::c_uint = 57;
pub const _SC_POLL: ::std::os::raw::c_uint = 58;
pub const _SC_SELECT: ::std::os::raw::c_uint = 59;
pub const _SC_UIO_MAXIOV: ::std::os::raw::c_uint = 60;
pub const _SC_IOV_MAX: ::std::os::raw::c_uint = 60;
pub const _SC_PII_INTERNET_STREAM: ::std::os::raw::c_uint = 61;
pub const _SC_PII_INTERNET_DGRAM: ::std::os::raw::c_uint = 62;
pub const _SC_PII_OSI_COTS: ::std::os::raw::c_uint = 63;
pub const _SC_PII_OSI_CLTS: ::std::os::raw::c_uint = 64;
pub const _SC_PII_OSI_M: ::std::os::raw::c_uint = 65;
pub const _SC_T_IOV_MAX: ::std::os::raw::c_uint = 66;
pub const _SC_THREADS: ::std::os::raw::c_uint = 67;
pub const _SC_THREAD_SAFE_FUNCTIONS: ::std::os::raw::c_uint = 68;
pub const _SC_GETGR_R_SIZE_MAX: ::std::os::raw::c_uint = 69;
pub const _SC_GETPW_R_SIZE_MAX: ::std::os::raw::c_uint = 70;
pub const _SC_LOGIN_NAME_MAX: ::std::os::raw::c_uint = 71;
pub const _SC_TTY_NAME_MAX: ::std::os::raw::c_uint = 72;
pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: ::std::os::raw::c_uint = 73;
pub const _SC_THREAD_KEYS_MAX: ::std::os::raw::c_uint = 74;
pub const _SC_THREAD_STACK_MIN: ::std::os::raw::c_uint = 75;
pub const _SC_THREAD_THREADS_MAX: ::std::os::raw::c_uint = 76;
pub const _SC_THREAD_ATTR_STACKADDR: ::std::os::raw::c_uint = 77;
pub const _SC_THREAD_ATTR_STACKSIZE: ::std::os::raw::c_uint = 78;
pub const _SC_THREAD_PRIORITY_SCHEDULING: ::std::os::raw::c_uint = 79;
pub const _SC_THREAD_PRIO_INHERIT: ::std::os::raw::c_uint = 80;
pub const _SC_THREAD_PRIO_PROTECT: ::std::os::raw::c_uint = 81;
pub const _SC_THREAD_PROCESS_SHARED: ::std::os::raw::c_uint = 82;
pub const _SC_NPROCESSORS_CONF: ::std::os::raw::c_uint = 83;
pub const _SC_NPROCESSORS_ONLN: ::std::os::raw::c_uint = 84;
pub const _SC_PHYS_PAGES: ::std::os::raw::c_uint = 85;
pub const _SC_AVPHYS_PAGES: ::std::os::raw::c_uint = 86;
pub const _SC_ATEXIT_MAX: ::std::os::raw::c_uint = 87;
pub const _SC_PASS_MAX: ::std::os::raw::c_uint = 88;
pub const _SC_XOPEN_VERSION: ::std::os::raw::c_uint = 89;
pub const _SC_XOPEN_XCU_VERSION: ::std::os::raw::c_uint = 90;
pub const _SC_XOPEN_UNIX: ::std::os::raw::c_uint = 91;
pub const _SC_XOPEN_CRYPT: ::std::os::raw::c_uint = 92;
pub const _SC_XOPEN_ENH_I18N: ::std::os::raw::c_uint = 93;
pub const _SC_XOPEN_SHM: ::std::os::raw::c_uint = 94;
pub const _SC_2_CHAR_TERM: ::std::os::raw::c_uint = 95;
pub const _SC_2_C_VERSION: ::std::os::raw::c_uint = 96;
pub const _SC_2_UPE: ::std::os::raw::c_uint = 97;
pub const _SC_XOPEN_XPG2: ::std::os::raw::c_uint = 98;
pub const _SC_XOPEN_XPG3: ::std::os::raw::c_uint = 99;
pub const _SC_XOPEN_XPG4: ::std::os::raw::c_uint = 100;
pub const _SC_CHAR_BIT: ::std::os::raw::c_uint = 101;
pub const _SC_CHAR_MAX: ::std::os::raw::c_uint = 102;
pub const _SC_CHAR_MIN: ::std::os::raw::c_uint = 103;
pub const _SC_INT_MAX: ::std::os::raw::c_uint = 104;
pub const _SC_INT_MIN: ::std::os::raw::c_uint = 105;
pub const _SC_LONG_BIT: ::std::os::raw::c_uint = 106;
pub const _SC_WORD_BIT: ::std::os::raw::c_uint = 107;
pub const _SC_MB_LEN_MAX: ::std::os::raw::c_uint = 108;
pub const _SC_NZERO: ::std::os::raw::c_uint = 109;
pub const _SC_SSIZE_MAX: ::std::os::raw::c_uint = 110;
pub const _SC_SCHAR_MAX: ::std::os::raw::c_uint = 111;
pub const _SC_SCHAR_MIN: ::std::os::raw::c_uint = 112;
pub const _SC_SHRT_MAX: ::std::os::raw::c_uint = 113;
pub const _SC_SHRT_MIN: ::std::os::raw::c_uint = 114;
pub const _SC_UCHAR_MAX: ::std::os::raw::c_uint = 115;
pub const _SC_UINT_MAX: ::std::os::raw::c_uint = 116;
pub const _SC_ULONG_MAX: ::std::os::raw::c_uint = 117;
pub const _SC_USHRT_MAX: ::std::os::raw::c_uint = 118;
pub const _SC_NL_ARGMAX: ::std::os::raw::c_uint = 119;
pub const _SC_NL_LANGMAX: ::std::os::raw::c_uint = 120;
pub const _SC_NL_MSGMAX: ::std::os::raw::c_uint = 121;
pub const _SC_NL_NMAX: ::std::os::raw::c_uint = 122;
pub const _SC_NL_SETMAX: ::std::os::raw::c_uint = 123;
pub const _SC_NL_TEXTMAX: ::std::os::raw::c_uint = 124;
pub const _SC_XBS5_ILP32_OFF32: ::std::os::raw::c_uint = 125;
pub const _SC_XBS5_ILP32_OFFBIG: ::std::os::raw::c_uint = 126;
pub const _SC_XBS5_LP64_OFF64: ::std::os::raw::c_uint = 127;
pub const _SC_XBS5_LPBIG_OFFBIG: ::std::os::raw::c_uint = 128;
pub const _SC_XOPEN_LEGACY: ::std::os::raw::c_uint = 129;
pub const _SC_XOPEN_REALTIME: ::std::os::raw::c_uint = 130;
pub const _SC_XOPEN_REALTIME_THREADS: ::std::os::raw::c_uint = 131;
pub const _SC_ADVISORY_INFO: ::std::os::raw::c_uint = 132;
pub const _SC_BARRIERS: ::std::os::raw::c_uint = 133;
pub const _SC_BASE: ::std::os::raw::c_uint = 134;
pub const _SC_C_LANG_SUPPORT: ::std::os::raw::c_uint = 135;
pub const _SC_C_LANG_SUPPORT_R: ::std::os::raw::c_uint = 136;
pub const _SC_CLOCK_SELECTION: ::std::os::raw::c_uint = 137;
pub const _SC_CPUTIME: ::std::os::raw::c_uint = 138;
pub const _SC_THREAD_CPUTIME: ::std::os::raw::c_uint = 139;
pub const _SC_DEVICE_IO: ::std::os::raw::c_uint = 140;
pub const _SC_DEVICE_SPECIFIC: ::std::os::raw::c_uint = 141;
pub const _SC_DEVICE_SPECIFIC_R: ::std::os::raw::c_uint = 142;
pub const _SC_FD_MGMT: ::std::os::raw::c_uint = 143;
pub const _SC_FIFO: ::std::os::raw::c_uint = 144;
pub const _SC_PIPE: ::std::os::raw::c_uint = 145;
pub const _SC_FILE_ATTRIBUTES: ::std::os::raw::c_uint = 146;
pub const _SC_FILE_LOCKING: ::std::os::raw::c_uint = 147;
pub const _SC_FILE_SYSTEM: ::std::os::raw::c_uint = 148;
pub const _SC_MONOTONIC_CLOCK: ::std::os::raw::c_uint = 149;
pub const _SC_MULTI_PROCESS: ::std::os::raw::c_uint = 150;
pub const _SC_SINGLE_PROCESS: ::std::os::raw::c_uint = 151;
pub const _SC_NETWORKING: ::std::os::raw::c_uint = 152;
pub const _SC_READER_WRITER_LOCKS: ::std::os::raw::c_uint = 153;
pub const _SC_SPIN_LOCKS: ::std::os::raw::c_uint = 154;
pub const _SC_REGEXP: ::std::os::raw::c_uint = 155;
pub const _SC_REGEX_VERSION: ::std::os::raw::c_uint = 156;
pub const _SC_SHELL: ::std::os::raw::c_uint = 157;
pub const _SC_SIGNALS: ::std::os::raw::c_uint = 158;
pub const _SC_SPAWN: ::std::os::raw::c_uint = 159;
pub const _SC_SPORADIC_SERVER: ::std::os::raw::c_uint = 160;
pub const _SC_THREAD_SPORADIC_SERVER: ::std::os::raw::c_uint = 161;
pub const _SC_SYSTEM_DATABASE: ::std::os::raw::c_uint = 162;
pub const _SC_SYSTEM_DATABASE_R: ::std::os::raw::c_uint = 163;
pub const _SC_TIMEOUTS: ::std::os::raw::c_uint = 164;
pub const _SC_TYPED_MEMORY_OBJECTS: ::std::os::raw::c_uint = 165;
pub const _SC_USER_GROUPS: ::std::os::raw::c_uint = 166;
pub const _SC_USER_GROUPS_R: ::std::os::raw::c_uint = 167;
pub const _SC_2_PBS: ::std::os::raw::c_uint = 168;
pub const _SC_2_PBS_ACCOUNTING: ::std::os::raw::c_uint = 169;
pub const _SC_2_PBS_LOCATE: ::std::os::raw::c_uint = 170;
pub const _SC_2_PBS_MESSAGE: ::std::os::raw::c_uint = 171;
pub const _SC_2_PBS_TRACK: ::std::os::raw::c_uint = 172;
pub const _SC_SYMLOOP_MAX: ::std::os::raw::c_uint = 173;
pub const _SC_STREAMS: ::std::os::raw::c_uint = 174;
pub const _SC_2_PBS_CHECKPOINT: ::std::os::raw::c_uint = 175;
pub const _SC_V6_ILP32_OFF32: ::std::os::raw::c_uint = 176;
pub const _SC_V6_ILP32_OFFBIG: ::std::os::raw::c_uint = 177;
pub const _SC_V6_LP64_OFF64: ::std::os::raw::c_uint = 178;
pub const _SC_V6_LPBIG_OFFBIG: ::std::os::raw::c_uint = 179;
pub const _SC_HOST_NAME_MAX: ::std::os::raw::c_uint = 180;
pub const _SC_TRACE: ::std::os::raw::c_uint = 181;
pub const _SC_TRACE_EVENT_FILTER: ::std::os::raw::c_uint = 182;
pub const _SC_TRACE_INHERIT: ::std::os::raw::c_uint = 183;
pub const _SC_TRACE_LOG: ::std::os::raw::c_uint = 184;
pub const _SC_LEVEL1_ICACHE_SIZE: ::std::os::raw::c_uint = 185;
pub const _SC_LEVEL1_ICACHE_ASSOC: ::std::os::raw::c_uint = 186;
pub const _SC_LEVEL1_ICACHE_LINESIZE: ::std::os::raw::c_uint = 187;
pub const _SC_LEVEL1_DCACHE_SIZE: ::std::os::raw::c_uint = 188;
pub const _SC_LEVEL1_DCACHE_ASSOC: ::std::os::raw::c_uint = 189;
pub const _SC_LEVEL1_DCACHE_LINESIZE: ::std::os::raw::c_uint = 190;
pub const _SC_LEVEL2_CACHE_SIZE: ::std::os::raw::c_uint = 191;
pub const _SC_LEVEL2_CACHE_ASSOC: ::std::os::raw::c_uint = 192;
pub const _SC_LEVEL2_CACHE_LINESIZE: ::std::os::raw::c_uint = 193;
pub const _SC_LEVEL3_CACHE_SIZE: ::std::os::raw::c_uint = 194;
pub const _SC_LEVEL3_CACHE_ASSOC: ::std::os::raw::c_uint = 195;
pub const _SC_LEVEL3_CACHE_LINESIZE: ::std::os::raw::c_uint = 196;
pub const _SC_LEVEL4_CACHE_SIZE: ::std::os::raw::c_uint = 197;
pub const _SC_LEVEL4_CACHE_ASSOC: ::std::os::raw::c_uint = 198;
pub const _SC_LEVEL4_CACHE_LINESIZE: ::std::os::raw::c_uint = 199;
pub const _SC_IPV6: ::std::os::raw::c_uint = 235;
pub const _SC_RAW_SOCKETS: ::std::os::raw::c_uint = 236;
pub const _SC_V7_ILP32_OFF32: ::std::os::raw::c_uint = 237;
pub const _SC_V7_ILP32_OFFBIG: ::std::os::raw::c_uint = 238;
pub const _SC_V7_LP64_OFF64: ::std::os::raw::c_uint = 239;
pub const _SC_V7_LPBIG_OFFBIG: ::std::os::raw::c_uint = 240;
pub const _SC_SS_REPL_MAX: ::std::os::raw::c_uint = 241;
pub const _SC_TRACE_EVENT_NAME_MAX: ::std::os::raw::c_uint = 242;
pub const _SC_TRACE_NAME_MAX: ::std::os::raw::c_uint = 243;
pub const _SC_TRACE_SYS_MAX: ::std::os::raw::c_uint = 244;
pub const _SC_TRACE_USER_EVENT_MAX: ::std::os::raw::c_uint = 245;
pub const _SC_XOPEN_STREAMS: ::std::os::raw::c_uint = 246;
pub const _SC_THREAD_ROBUST_PRIO_INHERIT: ::std::os::raw::c_uint = 247;
pub const _SC_THREAD_ROBUST_PRIO_PROTECT: ::std::os::raw::c_uint = 248;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub const _CS_PATH: ::std::os::raw::c_uint = 0;
pub const _CS_V6_WIDTH_RESTRICTED_ENVS: ::std::os::raw::c_uint = 1;
pub const _CS_GNU_LIBC_VERSION: ::std::os::raw::c_uint = 2;
pub const _CS_GNU_LIBPTHREAD_VERSION: ::std::os::raw::c_uint = 3;
pub const _CS_V5_WIDTH_RESTRICTED_ENVS: ::std::os::raw::c_uint = 4;
pub const _CS_V7_WIDTH_RESTRICTED_ENVS: ::std::os::raw::c_uint = 5;
pub const _CS_LFS_CFLAGS: ::std::os::raw::c_uint = 1000;
pub const _CS_LFS_LDFLAGS: ::std::os::raw::c_uint = 1001;
pub const _CS_LFS_LIBS: ::std::os::raw::c_uint = 1002;
pub const _CS_LFS_LINTFLAGS: ::std::os::raw::c_uint = 1003;
pub const _CS_LFS64_CFLAGS: ::std::os::raw::c_uint = 1004;
pub const _CS_LFS64_LDFLAGS: ::std::os::raw::c_uint = 1005;
pub const _CS_LFS64_LIBS: ::std::os::raw::c_uint = 1006;
pub const _CS_LFS64_LINTFLAGS: ::std::os::raw::c_uint = 1007;
pub const _CS_XBS5_ILP32_OFF32_CFLAGS: ::std::os::raw::c_uint = 1100;
pub const _CS_XBS5_ILP32_OFF32_LDFLAGS: ::std::os::raw::c_uint = 1101;
pub const _CS_XBS5_ILP32_OFF32_LIBS: ::std::os::raw::c_uint = 1102;
pub const _CS_XBS5_ILP32_OFF32_LINTFLAGS: ::std::os::raw::c_uint = 1103;
pub const _CS_XBS5_ILP32_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1104;
pub const _CS_XBS5_ILP32_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1105;
pub const _CS_XBS5_ILP32_OFFBIG_LIBS: ::std::os::raw::c_uint = 1106;
pub const _CS_XBS5_ILP32_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1107;
pub const _CS_XBS5_LP64_OFF64_CFLAGS: ::std::os::raw::c_uint = 1108;
pub const _CS_XBS5_LP64_OFF64_LDFLAGS: ::std::os::raw::c_uint = 1109;
pub const _CS_XBS5_LP64_OFF64_LIBS: ::std::os::raw::c_uint = 1110;
pub const _CS_XBS5_LP64_OFF64_LINTFLAGS: ::std::os::raw::c_uint = 1111;
pub const _CS_XBS5_LPBIG_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1112;
pub const _CS_XBS5_LPBIG_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1113;
pub const _CS_XBS5_LPBIG_OFFBIG_LIBS: ::std::os::raw::c_uint = 1114;
pub const _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1115;
pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: ::std::os::raw::c_uint = 1116;
pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: ::std::os::raw::c_uint = 1117;
pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: ::std::os::raw::c_uint = 1118;
pub const _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS: ::std::os::raw::c_uint = 1119;
pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1120;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1121;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: ::std::os::raw::c_uint = 1122;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1123;
pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: ::std::os::raw::c_uint = 1124;
pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: ::std::os::raw::c_uint = 1125;
pub const _CS_POSIX_V6_LP64_OFF64_LIBS: ::std::os::raw::c_uint = 1126;
pub const _CS_POSIX_V6_LP64_OFF64_LINTFLAGS: ::std::os::raw::c_uint = 1127;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1128;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1129;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: ::std::os::raw::c_uint = 1130;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1131;
pub const _CS_POSIX_V7_ILP32_OFF32_CFLAGS: ::std::os::raw::c_uint = 1132;
pub const _CS_POSIX_V7_ILP32_OFF32_LDFLAGS: ::std::os::raw::c_uint = 1133;
pub const _CS_POSIX_V7_ILP32_OFF32_LIBS: ::std::os::raw::c_uint = 1134;
pub const _CS_POSIX_V7_ILP32_OFF32_LINTFLAGS: ::std::os::raw::c_uint = 1135;
pub const _CS_POSIX_V7_ILP32_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1136;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1137;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LIBS: ::std::os::raw::c_uint = 1138;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1139;
pub const _CS_POSIX_V7_LP64_OFF64_CFLAGS: ::std::os::raw::c_uint = 1140;
pub const _CS_POSIX_V7_LP64_OFF64_LDFLAGS: ::std::os::raw::c_uint = 1141;
pub const _CS_POSIX_V7_LP64_OFF64_LIBS: ::std::os::raw::c_uint = 1142;
pub const _CS_POSIX_V7_LP64_OFF64_LINTFLAGS: ::std::os::raw::c_uint = 1143;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS: ::std::os::raw::c_uint = 1144;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS: ::std::os::raw::c_uint = 1145;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LIBS: ::std::os::raw::c_uint = 1146;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS: ::std::os::raw::c_uint = 1147;
pub const _CS_V6_ENV: ::std::os::raw::c_uint = 1148;
pub const _CS_V7_ENV: ::std::os::raw::c_uint = 1149;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
extern "C" {
    pub fn pathconf(
        __path: *const ::std::os::raw::c_char,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fpathconf(
        __fd: ::std::os::raw::c_int,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sysconf(__name: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn confstr(
        __name: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn getpid() -> __pid_t;
}
extern "C" {
    pub fn getppid() -> __pid_t;
}
extern "C" {
    pub fn getpgrp() -> __pid_t;
}
extern "C" {
    pub fn __getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn setpgid(__pid: __pid_t, __pgid: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpgrp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> __pid_t;
}
extern "C" {
    pub fn getsid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getuid() -> __uid_t;
}
extern "C" {
    pub fn geteuid() -> __uid_t;
}
extern "C" {
    pub fn getgid() -> __gid_t;
}
extern "C" {
    pub fn getegid() -> __gid_t;
}
extern "C" {
    pub fn getgroups(__size: ::std::os::raw::c_int, __list: *mut __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setreuid(__ruid: __uid_t, __euid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setregid(__rgid: __gid_t, __egid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setegid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> __pid_t;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyname(__fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isatty(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyslot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        __fromfd: ::std::os::raw::c_int,
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn symlinkat(
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlinkat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn unlink(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        __fd: ::std::os::raw::c_int,
        __name: *const ::std::os::raw::c_char,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmdir(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcgetpgrp(__fd: ::std::os::raw::c_int) -> __pid_t;
}
extern "C" {
    pub fn tcsetpgrp(__fd: ::std::os::raw::c_int, __pgrp_id: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getlogin_r(
        __name: *mut ::std::os::raw::c_char,
        __name_len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setlogin(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn getopt(
        ___argc: ::std::os::raw::c_int,
        ___argv: *const *mut ::std::os::raw::c_char,
        __shortopts: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(__name: *mut ::std::os::raw::c_char, __len: size_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostname(
        __name: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostid(__id: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdomainname(
        __name: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        __name: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vhangup() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn revoke(__file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn profil(
        __sample_buffer: *mut ::std::os::raw::c_ushort,
        __size: size_t,
        __offset: size_t,
        __scale: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acct(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn daemon(
        __nochdir: ::std::os::raw::c_int,
        __noclose: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chroot(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(__prompt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fsync(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn truncate(
        __file: *const ::std::os::raw::c_char,
        __length: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(__fd: ::std::os::raw::c_int, __length: __off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn brk(__addr: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sbrk(__delta: isize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn syscall(__sysno: ::std::os::raw::c_long, ...) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lockf(
        __fd: ::std::os::raw::c_int,
        __cmd: ::std::os::raw::c_int,
        __len: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdatasync(__fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn crypt(
        __key: *const ::std::os::raw::c_char,
        __salt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getentropy(
        __buffer: *mut ::std::os::raw::c_void,
        __length: size_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn time(__timer: *mut time_t) -> time_t;
}
extern "C" {
    pub fn difftime(__time1: time_t, __time0: time_t) -> f64;
}
extern "C" {
    pub fn mktime(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strftime_l(
        __s: *mut ::std::os::raw::c_char,
        __maxsize: size_t,
        __format: *const ::std::os::raw::c_char,
        __tp: *const tm,
        __loc: locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn gmtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(__timer: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn gmtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(__timer: *const time_t, __tp: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn asctime(__tp: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime(__timer: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn asctime_r(
        __tp: *const tm,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        __timer: *const time_t,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut __tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub static mut __daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 2usize];
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub fn timegm(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn timelocal(__tp: *mut tm) -> time_t;
}
extern "C" {
    pub fn dysize(__year: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nanosleep(
        __requested_time: *const timespec,
        __remaining: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_nanosleep(
        __clock_id: clockid_t,
        __flags: ::std::os::raw::c_int,
        __req: *const timespec,
        __rem: *mut timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_getcpuclockid(__pid: pid_t, __clock_id: *mut clockid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_create(
        __clock_id: clockid_t,
        __evp: *mut sigevent,
        __timerid: *mut timer_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_delete(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_settime(
        __timerid: timer_t,
        __flags: ::std::os::raw::c_int,
        __value: *const itimerspec,
        __ovalue: *mut itimerspec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_gettime(__timerid: timer_t, __value: *mut itimerspec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timer_getoverrun(__timerid: timer_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(
        __ts: *mut timespec,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const _ISupper: ::std::os::raw::c_uint = 256;
pub const _ISlower: ::std::os::raw::c_uint = 512;
pub const _ISalpha: ::std::os::raw::c_uint = 1024;
pub const _ISdigit: ::std::os::raw::c_uint = 2048;
pub const _ISxdigit: ::std::os::raw::c_uint = 4096;
pub const _ISspace: ::std::os::raw::c_uint = 8192;
pub const _ISprint: ::std::os::raw::c_uint = 16384;
pub const _ISgraph: ::std::os::raw::c_uint = 32768;
pub const _ISblank: ::std::os::raw::c_uint = 1;
pub const _IScntrl: ::std::os::raw::c_uint = 2;
pub const _ISpunct: ::std::os::raw::c_uint = 4;
pub const _ISalnum: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
extern "C" {
    pub fn __ctype_b_loc() -> *mut *const ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn __ctype_tolower_loc() -> *mut *const __int32_t;
}
extern "C" {
    pub fn __ctype_toupper_loc() -> *mut *const __int32_t;
}
extern "C" {
    pub fn isalnum(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isalpha(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iscntrl(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isdigit(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn islower(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isgraph(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isprint(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ispunct(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isspace(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isupper(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isxdigit(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tolower(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn toupper(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isblank(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isascii(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn toascii(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _toupper(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _tolower(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isalnum_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isalpha_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iscntrl_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isdigit_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn islower_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isgraph_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isprint_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ispunct_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isspace_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isupper_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isxdigit_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isblank_l(arg1: ::std::os::raw::c_int, arg2: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __tolower_l(__c: ::std::os::raw::c_int, __l: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tolower_l(__c: ::std::os::raw::c_int, __l: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __toupper_l(__c: ::std::os::raw::c_int, __l: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn toupper_l(__c: ::std::os::raw::c_int, __l: locale_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __errno_location() -> *mut ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct flock {
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
    pub l_start: __off_t,
    pub l_len: __off_t,
    pub l_pid: __pid_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat {
    pub st_dev: __dev_t,
    pub st_ino: __ino_t,
    pub st_nlink: __nlink_t,
    pub st_mode: __mode_t,
    pub st_uid: __uid_t,
    pub st_gid: __gid_t,
    pub __pad0: ::std::os::raw::c_int,
    pub st_rdev: __dev_t,
    pub st_size: __off_t,
    pub st_blksize: __blksize_t,
    pub st_blocks: __blkcnt_t,
    pub st_atim: timespec,
    pub st_mtim: timespec,
    pub st_ctim: timespec,
    pub __glibc_reserved: [__syscall_slong_t; 3usize],
}
extern "C" {
    pub fn fcntl(
        __fd: ::std::os::raw::c_int,
        __cmd: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn open(
        __file: *const ::std::os::raw::c_char,
        __oflag: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn openat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __oflag: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn creat(__file: *const ::std::os::raw::c_char, __mode: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_fadvise(
        __fd: ::std::os::raw::c_int,
        __offset: off_t,
        __len: off_t,
        __advise: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_fallocate(
        __fd: ::std::os::raw::c_int,
        __offset: off_t,
        __len: off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stat(__file: *const ::std::os::raw::c_char, __buf: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstat(__fd: ::std::os::raw::c_int, __buf: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstatat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __buf: *mut stat,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstat(__file: *const ::std::os::raw::c_char, __buf: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chmod(__file: *const ::std::os::raw::c_char, __mode: __mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchmod(__file: *const ::std::os::raw::c_char, __mode: __mode_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmod(__fd: ::std::os::raw::c_int, __mode: __mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmodat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __mode: __mode_t,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umask(__mask: __mode_t) -> __mode_t;
}
extern "C" {
    pub fn mkdir(__path: *const ::std::os::raw::c_char, __mode: __mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __mode: __mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknod(
        __path: *const ::std::os::raw::c_char,
        __mode: __mode_t,
        __dev: __dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknodat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __mode: __mode_t,
        __dev: __dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifo(__path: *const ::std::os::raw::c_char, __mode: __mode_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifoat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __mode: __mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimensat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __times: *const timespec,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimens(__fd: ::std::os::raw::c_int, __times: *const timespec)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fxstat(
        __ver: ::std::os::raw::c_int,
        __fildes: ::std::os::raw::c_int,
        __stat_buf: *mut stat,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __xstat(
        __ver: ::std::os::raw::c_int,
        __filename: *const ::std::os::raw::c_char,
        __stat_buf: *mut stat,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __lxstat(
        __ver: ::std::os::raw::c_int,
        __filename: *const ::std::os::raw::c_char,
        __stat_buf: *mut stat,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fxstatat(
        __ver: ::std::os::raw::c_int,
        __fildes: ::std::os::raw::c_int,
        __filename: *const ::std::os::raw::c_char,
        __stat_buf: *mut stat,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __xmknod(
        __ver: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __mode: __mode_t,
        __dev: *mut __dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __xmknodat(
        __ver: ::std::os::raw::c_int,
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __mode: __mode_t,
        __dev: *mut __dev_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
extern "C" {
    pub fn gettimeofday(
        __tv: *mut timeval,
        __tz: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn settimeofday(__tv: *const timeval, __tz: *const timezone) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn adjtime(__delta: *const timeval, __olddelta: *mut timeval) -> ::std::os::raw::c_int;
}
pub const __itimer_which_ITIMER_REAL: __itimer_which = 0;
pub const __itimer_which_ITIMER_VIRTUAL: __itimer_which = 1;
pub const __itimer_which_ITIMER_PROF: __itimer_which = 2;
pub type __itimer_which = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
pub type __itimer_which_t = ::std::os::raw::c_int;
extern "C" {
    pub fn getitimer(__which: __itimer_which_t, __value: *mut itimerval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setitimer(
        __which: __itimer_which_t,
        __new: *const itimerval,
        __old: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimes(
        __file: *const ::std::os::raw::c_char,
        __tvp: *const timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lutimes(
        __file: *const ::std::os::raw::c_char,
        __tvp: *const timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimes(__fd: ::std::os::raw::c_int, __tvp: *const timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __assert_fail(
        __assertion: *const ::std::os::raw::c_char,
        __file: *const ::std::os::raw::c_char,
        __line: ::std::os::raw::c_uint,
        __function: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn __assert_perror_fail(
        __errnum: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __line: ::std::os::raw::c_uint,
        __function: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn __assert(
        __assertion: *const ::std::os::raw::c_char,
        __file: *const ::std::os::raw::c_char,
        __line: ::std::os::raw::c_int,
    );
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
pub type jmp_buf = [__jmp_buf_tag; 1usize];
extern "C" {
    pub fn setjmp(__env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __sigsetjmp(
        __env: *mut __jmp_buf_tag,
        __savemask: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _setjmp(__env: *mut __jmp_buf_tag) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn longjmp(__env: *mut __jmp_buf_tag, __val: ::std::os::raw::c_int);
}
extern "C" {
    pub fn _longjmp(__env: *mut __jmp_buf_tag, __val: ::std::os::raw::c_int);
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
extern "C" {
    pub fn siglongjmp(__env: *mut __jmp_buf_tag, __val: ::std::os::raw::c_int);
}
pub type sig_atomic_t = __sig_atomic_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
pub type __sigval_t = sigval;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub __pad0: ::std::os::raw::c_int,
    pub _sifields: siginfo_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 28usize],
    pub _kill: siginfo_t__bindgen_ty_1__bindgen_ty_1,
    pub _timer: siginfo_t__bindgen_ty_1__bindgen_ty_2,
    pub _rt: siginfo_t__bindgen_ty_1__bindgen_ty_3,
    pub _sigchld: siginfo_t__bindgen_ty_1__bindgen_ty_4,
    pub _sigfault: siginfo_t__bindgen_ty_1__bindgen_ty_5,
    pub _sigpoll: siginfo_t__bindgen_ty_1__bindgen_ty_6,
    pub _sigsys: siginfo_t__bindgen_ty_1__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    pub si_tid: ::std::os::raw::c_int,
    pub si_overrun: ::std::os::raw::c_int,
    pub si_sigval: __sigval_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_3 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_sigval: __sigval_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_4 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_utime: __clock_t,
    pub si_stime: __clock_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5 {
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_addr_lsb: ::std::os::raw::c_short,
    pub _bounds: siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1 {
    pub _addr_bnd: siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1,
    pub _pkey: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1 {
    pub _lower: *mut ::std::os::raw::c_void,
    pub _upper: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_6 {
    pub si_band: ::std::os::raw::c_long,
    pub si_fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_7 {
    pub _call_addr: *mut ::std::os::raw::c_void,
    pub _syscall: ::std::os::raw::c_int,
    pub _arch: ::std::os::raw::c_uint,
}
pub const SI_ASYNCNL: ::std::os::raw::c_int = -60;
pub const SI_DETHREAD: ::std::os::raw::c_int = -7;
pub const SI_TKILL: ::std::os::raw::c_int = -6;
pub const SI_SIGIO: ::std::os::raw::c_int = -5;
pub const SI_ASYNCIO: ::std::os::raw::c_int = -4;
pub const SI_MESGQ: ::std::os::raw::c_int = -3;
pub const SI_TIMER: ::std::os::raw::c_int = -2;
pub const SI_QUEUE: ::std::os::raw::c_int = -1;
pub const SI_USER: ::std::os::raw::c_int = 0;
pub const SI_KERNEL: ::std::os::raw::c_int = 128;
pub type _bindgen_ty_5 = ::std::os::raw::c_int;
pub const ILL_ILLOPC: ::std::os::raw::c_uint = 1;
pub const ILL_ILLOPN: ::std::os::raw::c_uint = 2;
pub const ILL_ILLADR: ::std::os::raw::c_uint = 3;
pub const ILL_ILLTRP: ::std::os::raw::c_uint = 4;
pub const ILL_PRVOPC: ::std::os::raw::c_uint = 5;
pub const ILL_PRVREG: ::std::os::raw::c_uint = 6;
pub const ILL_COPROC: ::std::os::raw::c_uint = 7;
pub const ILL_BADSTK: ::std::os::raw::c_uint = 8;
pub const ILL_BADIADDR: ::std::os::raw::c_uint = 9;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
pub const FPE_INTDIV: ::std::os::raw::c_uint = 1;
pub const FPE_INTOVF: ::std::os::raw::c_uint = 2;
pub const FPE_FLTDIV: ::std::os::raw::c_uint = 3;
pub const FPE_FLTOVF: ::std::os::raw::c_uint = 4;
pub const FPE_FLTUND: ::std::os::raw::c_uint = 5;
pub const FPE_FLTRES: ::std::os::raw::c_uint = 6;
pub const FPE_FLTINV: ::std::os::raw::c_uint = 7;
pub const FPE_FLTSUB: ::std::os::raw::c_uint = 8;
pub const FPE_FLTUNK: ::std::os::raw::c_uint = 14;
pub const FPE_CONDTRAP: ::std::os::raw::c_uint = 15;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
pub const SEGV_MAPERR: ::std::os::raw::c_uint = 1;
pub const SEGV_ACCERR: ::std::os::raw::c_uint = 2;
pub const SEGV_BNDERR: ::std::os::raw::c_uint = 3;
pub const SEGV_PKUERR: ::std::os::raw::c_uint = 4;
pub const SEGV_ACCADI: ::std::os::raw::c_uint = 5;
pub const SEGV_ADIDERR: ::std::os::raw::c_uint = 6;
pub const SEGV_ADIPERR: ::std::os::raw::c_uint = 7;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
pub const BUS_ADRALN: ::std::os::raw::c_uint = 1;
pub const BUS_ADRERR: ::std::os::raw::c_uint = 2;
pub const BUS_OBJERR: ::std::os::raw::c_uint = 3;
pub const BUS_MCEERR_AR: ::std::os::raw::c_uint = 4;
pub const BUS_MCEERR_AO: ::std::os::raw::c_uint = 5;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
pub const CLD_EXITED: ::std::os::raw::c_uint = 1;
pub const CLD_KILLED: ::std::os::raw::c_uint = 2;
pub const CLD_DUMPED: ::std::os::raw::c_uint = 3;
pub const CLD_TRAPPED: ::std::os::raw::c_uint = 4;
pub const CLD_STOPPED: ::std::os::raw::c_uint = 5;
pub const CLD_CONTINUED: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_10 = ::std::os::raw::c_uint;
pub const POLL_IN: ::std::os::raw::c_uint = 1;
pub const POLL_OUT: ::std::os::raw::c_uint = 2;
pub const POLL_MSG: ::std::os::raw::c_uint = 3;
pub const POLL_ERR: ::std::os::raw::c_uint = 4;
pub const POLL_PRI: ::std::os::raw::c_uint = 5;
pub const POLL_HUP: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
pub type sigval_t = __sigval_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_value: __sigval_t,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_notify: ::std::os::raw::c_int,
    pub _sigev_un: sigevent__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigevent__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 12usize],
    pub _tid: __pid_t,
    pub _sigev_thread: sigevent__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent__bindgen_ty_1__bindgen_ty_1 {
    pub _function: ::std::option::Option<unsafe extern "C" fn(arg1: __sigval_t)>,
    pub _attribute: *mut pthread_attr_t,
}
pub type sigevent_t = sigevent;
pub const SIGEV_SIGNAL: ::std::os::raw::c_uint = 0;
pub const SIGEV_NONE: ::std::os::raw::c_uint = 1;
pub const SIGEV_THREAD: ::std::os::raw::c_uint = 2;
pub const SIGEV_THREAD_ID: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
pub type __sighandler_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
extern "C" {
    pub fn __sysv_signal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t)
        -> __sighandler_t;
}
extern "C" {
    pub fn signal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t) -> __sighandler_t;
}
extern "C" {
    pub fn kill(__pid: __pid_t, __sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn killpg(__pgrp: __pid_t, __sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn raise(__sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ssignal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t) -> __sighandler_t;
}
extern "C" {
    pub fn gsignal(__sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psignal(__sig: ::std::os::raw::c_int, __s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn psiginfo(__pinfo: *const siginfo_t, __s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sigblock(__mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsetmask(__mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siggetmask() -> ::std::os::raw::c_int;
}
pub type sig_t = __sighandler_t;
extern "C" {
    pub fn sigemptyset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset(__set: *mut sigset_t, __signo: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(__set: *mut sigset_t, __signo: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(
        __set: *const sigset_t,
        __signo: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_handler: sigaction__bindgen_ty_1,
    pub sa_mask: __sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub sa_handler: __sighandler_t,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo_t,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
extern "C" {
    pub fn sigprocmask(
        __how: ::std::os::raw::c_int,
        __set: *const sigset_t,
        __oset: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsuspend(__set: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction(
        __sig: ::std::os::raw::c_int,
        __act: *const sigaction,
        __oact: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        __set: *const sigset_t,
        __sig: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwaitinfo(__set: *const sigset_t, __info: *mut siginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigtimedwait(
        __set: *const sigset_t,
        __info: *mut siginfo_t,
        __timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigqueue(
        __pid: __pid_t,
        __sig: ::std::os::raw::c_int,
        __val: sigval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static _sys_siglist: [*const ::std::os::raw::c_char; 65usize];
}
extern "C" {
    pub static sys_siglist: [*const ::std::os::raw::c_char; 65usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpx_sw_bytes {
    pub magic1: __uint32_t,
    pub extended_size: __uint32_t,
    pub xstate_bv: __uint64_t,
    pub xstate_size: __uint32_t,
    pub __glibc_reserved1: [__uint32_t; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub __glibc_reserved1: [::std::os::raw::c_ushort; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_fpxreg; 8usize],
    pub _xmm: [_xmmreg; 16usize],
    pub __glibc_reserved1: [__uint32_t; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigcontext {
    pub r8: __uint64_t,
    pub r9: __uint64_t,
    pub r10: __uint64_t,
    pub r11: __uint64_t,
    pub r12: __uint64_t,
    pub r13: __uint64_t,
    pub r14: __uint64_t,
    pub r15: __uint64_t,
    pub rdi: __uint64_t,
    pub rsi: __uint64_t,
    pub rbp: __uint64_t,
    pub rbx: __uint64_t,
    pub rdx: __uint64_t,
    pub rax: __uint64_t,
    pub rcx: __uint64_t,
    pub rsp: __uint64_t,
    pub rip: __uint64_t,
    pub eflags: __uint64_t,
    pub cs: ::std::os::raw::c_ushort,
    pub gs: ::std::os::raw::c_ushort,
    pub fs: ::std::os::raw::c_ushort,
    pub __pad0: ::std::os::raw::c_ushort,
    pub err: __uint64_t,
    pub trapno: __uint64_t,
    pub oldmask: __uint64_t,
    pub cr2: __uint64_t,
    pub __bindgen_anon_1: sigcontext__bindgen_ty_1,
    pub __reserved1: [__uint64_t; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigcontext__bindgen_ty_1 {
    pub fpstate: *mut _fpstate,
    pub __fpstate_word: __uint64_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xsave_hdr {
    pub xstate_bv: __uint64_t,
    pub __glibc_reserved1: [__uint64_t; 2usize],
    pub __glibc_reserved2: [__uint64_t; 5usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ymmh_state {
    pub ymmh_space: [__uint32_t; 64usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _xstate {
    pub fpstate: _fpstate,
    pub xstate_hdr: _xsave_hdr,
    pub ymmh: _ymmh_state,
}
extern "C" {
    pub fn sigreturn(__scp: *mut sigcontext) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_t {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_flags: ::std::os::raw::c_int,
    pub ss_size: size_t,
}
pub type greg_t = ::std::os::raw::c_longlong;
pub type gregset_t = [greg_t; 23usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub __glibc_reserved1: [::std::os::raw::c_ushort; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_libc_fpxreg; 8usize],
    pub _xmm: [_libc_xmmreg; 16usize],
    pub __glibc_reserved1: [__uint32_t; 24usize],
}
pub type fpregset_t = *mut _libc_fpstate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mcontext_t {
    pub gregs: gregset_t,
    pub fpregs: fpregset_t,
    pub __reserved1: [::std::os::raw::c_ulonglong; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucontext_t {
    pub uc_flags: ::std::os::raw::c_ulong,
    pub uc_link: *mut ucontext_t,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
    pub uc_sigmask: sigset_t,
    pub __fpregs_mem: _libc_fpstate,
    pub __ssp: [::std::os::raw::c_ulonglong; 4usize],
}
extern "C" {
    pub fn siginterrupt(
        __sig: ::std::os::raw::c_int,
        __interrupt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const SS_ONSTACK: ::std::os::raw::c_uint = 1;
pub const SS_DISABLE: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
extern "C" {
    pub fn sigaltstack(__ss: *const stack_t, __oss: *mut stack_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_onstack: ::std::os::raw::c_int,
}
extern "C" {
    pub fn sigstack(__ss: *mut sigstack, __oss: *mut sigstack) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_sigmask(
        __how: ::std::os::raw::c_int,
        __newmask: *const __sigset_t,
        __oldmask: *mut __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_kill(
        __threadid: pthread_t,
        __signo: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmin() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmax() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wait(__stat_loc: *mut ::std::os::raw::c_int) -> __pid_t;
}
extern "C" {
    pub fn waitpid(
        __pid: __pid_t,
        __stat_loc: *mut ::std::os::raw::c_int,
        __options: ::std::os::raw::c_int,
    ) -> __pid_t;
}
extern "C" {
    pub fn waitid(
        __idtype: idtype_t,
        __id: __id_t,
        __infop: *mut siginfo_t,
        __options: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    _unused: [u8; 0],
}
extern "C" {
    pub fn wait3(
        __stat_loc: *mut ::std::os::raw::c_int,
        __options: ::std::os::raw::c_int,
        __usage: *mut rusage,
    ) -> __pid_t;
}
extern "C" {
    pub fn wait4(
        __pid: __pid_t,
        __stat_loc: *mut ::std::os::raw::c_int,
        __options: ::std::os::raw::c_int,
        __usage: *mut rusage,
    ) -> __pid_t;
}
extern "C" {
    pub fn mmap(
        __addr: *mut ::std::os::raw::c_void,
        __len: size_t,
        __prot: ::std::os::raw::c_int,
        __flags: ::std::os::raw::c_int,
        __fd: ::std::os::raw::c_int,
        __offset: __off_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn munmap(__addr: *mut ::std::os::raw::c_void, __len: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mprotect(
        __addr: *mut ::std::os::raw::c_void,
        __len: size_t,
        __prot: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn msync(
        __addr: *mut ::std::os::raw::c_void,
        __len: size_t,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn madvise(
        __addr: *mut ::std::os::raw::c_void,
        __len: size_t,
        __advice: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn posix_madvise(
        __addr: *mut ::std::os::raw::c_void,
        __len: size_t,
        __advice: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mlock(__addr: *const ::std::os::raw::c_void, __len: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn munlock(__addr: *const ::std::os::raw::c_void, __len: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mlockall(__flags: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn munlockall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mincore(
        __start: *mut ::std::os::raw::c_void,
        __len: size_t,
        __vec: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shm_open(
        __name: *const ::std::os::raw::c_char,
        __oflag: ::std::os::raw::c_int,
        __mode: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shm_unlink(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: size_t,
}
pub const __socket_type_SOCK_STREAM: __socket_type = 1;
pub const __socket_type_SOCK_DGRAM: __socket_type = 2;
pub const __socket_type_SOCK_RAW: __socket_type = 3;
pub const __socket_type_SOCK_RDM: __socket_type = 4;
pub const __socket_type_SOCK_SEQPACKET: __socket_type = 5;
pub const __socket_type_SOCK_DCCP: __socket_type = 6;
pub const __socket_type_SOCK_PACKET: __socket_type = 10;
pub const __socket_type_SOCK_CLOEXEC: __socket_type = 524288;
pub const __socket_type_SOCK_NONBLOCK: __socket_type = 2048;
pub type __socket_type = ::std::os::raw::c_uint;
pub type sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::std::os::raw::c_char; 118usize],
    pub __ss_align: ::std::os::raw::c_ulong,
}
pub const MSG_OOB: ::std::os::raw::c_uint = 1;
pub const MSG_PEEK: ::std::os::raw::c_uint = 2;
pub const MSG_DONTROUTE: ::std::os::raw::c_uint = 4;
pub const MSG_CTRUNC: ::std::os::raw::c_uint = 8;
pub const MSG_PROXY: ::std::os::raw::c_uint = 16;
pub const MSG_TRUNC: ::std::os::raw::c_uint = 32;
pub const MSG_DONTWAIT: ::std::os::raw::c_uint = 64;
pub const MSG_EOR: ::std::os::raw::c_uint = 128;
pub const MSG_WAITALL: ::std::os::raw::c_uint = 256;
pub const MSG_FIN: ::std::os::raw::c_uint = 512;
pub const MSG_SYN: ::std::os::raw::c_uint = 1024;
pub const MSG_CONFIRM: ::std::os::raw::c_uint = 2048;
pub const MSG_RST: ::std::os::raw::c_uint = 4096;
pub const MSG_ERRQUEUE: ::std::os::raw::c_uint = 8192;
pub const MSG_NOSIGNAL: ::std::os::raw::c_uint = 16384;
pub const MSG_MORE: ::std::os::raw::c_uint = 32768;
pub const MSG_WAITFORONE: ::std::os::raw::c_uint = 65536;
pub const MSG_BATCH: ::std::os::raw::c_uint = 262144;
pub const MSG_ZEROCOPY: ::std::os::raw::c_uint = 67108864;
pub const MSG_FASTOPEN: ::std::os::raw::c_uint = 536870912;
pub const MSG_CMSG_CLOEXEC: ::std::os::raw::c_uint = 1073741824;
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: size_t,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: size_t,
    pub msg_flags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug)]
pub struct cmsghdr {
    pub cmsg_len: size_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
    pub __cmsg_data: __IncompleteArrayField<::std::os::raw::c_uchar>,
}
extern "C" {
    pub fn __cmsg_nxthdr(__mhdr: *mut msghdr, __cmsg: *mut cmsghdr) -> *mut cmsghdr;
}
pub const SCM_RIGHTS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct osockaddr {
    pub sa_family: ::std::os::raw::c_ushort,
    pub sa_data: [::std::os::raw::c_uchar; 14usize],
}
pub const SHUT_RD: ::std::os::raw::c_uint = 0;
pub const SHUT_WR: ::std::os::raw::c_uint = 1;
pub const SHUT_RDWR: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
extern "C" {
    pub fn socket(
        __domain: ::std::os::raw::c_int,
        __type: ::std::os::raw::c_int,
        __protocol: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socketpair(
        __domain: ::std::os::raw::c_int,
        __type: ::std::os::raw::c_int,
        __protocol: ::std::os::raw::c_int,
        __fds: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bind(
        __fd: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __len: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsockname(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn connect(
        __fd: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __len: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpeername(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn send(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn recv(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn sendto(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __addr_len: socklen_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn recvfrom(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __n: size_t,
        __flags: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __addr_len: *mut socklen_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn sendmsg(
        __fd: ::std::os::raw::c_int,
        __message: *const msghdr,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn recvmsg(
        __fd: ::std::os::raw::c_int,
        __message: *mut msghdr,
        __flags: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn getsockopt(
        __fd: ::std::os::raw::c_int,
        __level: ::std::os::raw::c_int,
        __optname: ::std::os::raw::c_int,
        __optval: *mut ::std::os::raw::c_void,
        __optlen: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsockopt(
        __fd: ::std::os::raw::c_int,
        __level: ::std::os::raw::c_int,
        __optname: ::std::os::raw::c_int,
        __optval: *const ::std::os::raw::c_void,
        __optlen: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn listen(__fd: ::std::os::raw::c_int, __n: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn accept(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __addr_len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shutdown(
        __fd: ::std::os::raw::c_int,
        __how: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sockatmark(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isfdtype(
        __fd: ::std::os::raw::c_int,
        __fdtype: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type in_addr_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_int,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
pub const IPPROTO_IP: ::std::os::raw::c_uint = 0;
pub const IPPROTO_ICMP: ::std::os::raw::c_uint = 1;
pub const IPPROTO_IGMP: ::std::os::raw::c_uint = 2;
pub const IPPROTO_IPIP: ::std::os::raw::c_uint = 4;
pub const IPPROTO_TCP: ::std::os::raw::c_uint = 6;
pub const IPPROTO_EGP: ::std::os::raw::c_uint = 8;
pub const IPPROTO_PUP: ::std::os::raw::c_uint = 12;
pub const IPPROTO_UDP: ::std::os::raw::c_uint = 17;
pub const IPPROTO_IDP: ::std::os::raw::c_uint = 22;
pub const IPPROTO_TP: ::std::os::raw::c_uint = 29;
pub const IPPROTO_DCCP: ::std::os::raw::c_uint = 33;
pub const IPPROTO_IPV6: ::std::os::raw::c_uint = 41;
pub const IPPROTO_RSVP: ::std::os::raw::c_uint = 46;
pub const IPPROTO_GRE: ::std::os::raw::c_uint = 47;
pub const IPPROTO_ESP: ::std::os::raw::c_uint = 50;
pub const IPPROTO_AH: ::std::os::raw::c_uint = 51;
pub const IPPROTO_MTP: ::std::os::raw::c_uint = 92;
pub const IPPROTO_BEETPH: ::std::os::raw::c_uint = 94;
pub const IPPROTO_ENCAP: ::std::os::raw::c_uint = 98;
pub const IPPROTO_PIM: ::std::os::raw::c_uint = 103;
pub const IPPROTO_COMP: ::std::os::raw::c_uint = 108;
pub const IPPROTO_SCTP: ::std::os::raw::c_uint = 132;
pub const IPPROTO_UDPLITE: ::std::os::raw::c_uint = 136;
pub const IPPROTO_MPLS: ::std::os::raw::c_uint = 137;
pub const IPPROTO_RAW: ::std::os::raw::c_uint = 255;
pub const IPPROTO_MAX: ::std::os::raw::c_uint = 256;
pub type _bindgen_ty_17 = ::std::os::raw::c_uint;
pub const IPPROTO_HOPOPTS: ::std::os::raw::c_uint = 0;
pub const IPPROTO_ROUTING: ::std::os::raw::c_uint = 43;
pub const IPPROTO_FRAGMENT: ::std::os::raw::c_uint = 44;
pub const IPPROTO_ICMPV6: ::std::os::raw::c_uint = 58;
pub const IPPROTO_NONE: ::std::os::raw::c_uint = 59;
pub const IPPROTO_DSTOPTS: ::std::os::raw::c_uint = 60;
pub const IPPROTO_MH: ::std::os::raw::c_uint = 135;
pub type _bindgen_ty_18 = ::std::os::raw::c_uint;
pub type in_port_t = u16;
pub const IPPORT_ECHO: ::std::os::raw::c_uint = 7;
pub const IPPORT_DISCARD: ::std::os::raw::c_uint = 9;
pub const IPPORT_SYSTAT: ::std::os::raw::c_uint = 11;
pub const IPPORT_DAYTIME: ::std::os::raw::c_uint = 13;
pub const IPPORT_NETSTAT: ::std::os::raw::c_uint = 15;
pub const IPPORT_FTP: ::std::os::raw::c_uint = 21;
pub const IPPORT_TELNET: ::std::os::raw::c_uint = 23;
pub const IPPORT_SMTP: ::std::os::raw::c_uint = 25;
pub const IPPORT_TIMESERVER: ::std::os::raw::c_uint = 37;
pub const IPPORT_NAMESERVER: ::std::os::raw::c_uint = 42;
pub const IPPORT_WHOIS: ::std::os::raw::c_uint = 43;
pub const IPPORT_MTP: ::std::os::raw::c_uint = 57;
pub const IPPORT_TFTP: ::std::os::raw::c_uint = 69;
pub const IPPORT_RJE: ::std::os::raw::c_uint = 77;
pub const IPPORT_FINGER: ::std::os::raw::c_uint = 79;
pub const IPPORT_TTYLINK: ::std::os::raw::c_uint = 87;
pub const IPPORT_SUPDUP: ::std::os::raw::c_uint = 95;
pub const IPPORT_EXECSERVER: ::std::os::raw::c_uint = 512;
pub const IPPORT_LOGINSERVER: ::std::os::raw::c_uint = 513;
pub const IPPORT_CMDSERVER: ::std::os::raw::c_uint = 514;
pub const IPPORT_EFSSERVER: ::std::os::raw::c_uint = 520;
pub const IPPORT_BIFFUDP: ::std::os::raw::c_uint = 512;
pub const IPPORT_WHOSERVER: ::std::os::raw::c_uint = 513;
pub const IPPORT_ROUTESERVER: ::std::os::raw::c_uint = 520;
pub const IPPORT_USERRESERVED: ::std::os::raw::c_uint = 5000;
pub type _bindgen_ty_19 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __in6_u: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [u8; 16usize],
    pub __u6_addr16: [u16; 8usize],
    pub __u6_addr32: [u32; 4usize],
}
extern "C" {
    pub static in6addr_any: in6_addr;
}
extern "C" {
    pub static in6addr_loopback: in6_addr;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_uchar; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: u32,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
    pub imr_sourceaddr: in_addr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_msfilter {
    pub imsf_multiaddr: in_addr,
    pub imsf_interface: in_addr,
    pub imsf_fmode: u32,
    pub imsf_numsrc: u32,
    pub imsf_slist: [in_addr; 1usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct group_filter {
    pub gf_interface: u32,
    pub gf_group: sockaddr_storage,
    pub gf_fmode: u32,
    pub gf_numsrc: u32,
    pub gf_slist: [sockaddr_storage; 1usize],
}
extern "C" {
    pub fn ntohl(__netlong: u32) -> u32;
}
extern "C" {
    pub fn ntohs(__netshort: u16) -> u16;
}
extern "C" {
    pub fn htonl(__hostlong: u32) -> u32;
}
extern "C" {
    pub fn htons(__hostshort: u16) -> u16;
}
extern "C" {
    pub fn bindresvport(
        __sockfd: ::std::os::raw::c_int,
        __sock_in: *mut sockaddr_in,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bindresvport6(
        __sockfd: ::std::os::raw::c_int,
        __sock_in: *mut sockaddr_in6,
    ) -> ::std::os::raw::c_int;
}
pub type tcp_seq = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tcphdr {
    pub __bindgen_anon_1: tcphdr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tcphdr__bindgen_ty_1 {
    pub __bindgen_anon_1: tcphdr__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: tcphdr__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tcphdr__bindgen_ty_1__bindgen_ty_1 {
    pub th_sport: u16,
    pub th_dport: u16,
    pub th_seq: tcp_seq,
    pub th_ack: tcp_seq,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub th_flags: u8,
    pub th_win: u16,
    pub th_sum: u16,
    pub th_urp: u16,
}
impl tcphdr__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn th_x2(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_th_x2(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn th_off(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_th_off(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(th_x2: u8, th_off: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let th_x2: u8 = unsafe { ::std::mem::transmute(th_x2) };
            th_x2 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let th_off: u8 = unsafe { ::std::mem::transmute(th_off) };
            th_off as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tcphdr__bindgen_ty_1__bindgen_ty_2 {
    pub source: u16,
    pub dest: u16,
    pub seq: u32,
    pub ack_seq: u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub window: u16,
    pub check: u16,
    pub urg_ptr: u16,
}
impl tcphdr__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn res1(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u16) }
    }
    #[inline]
    pub fn set_res1(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn doff(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u16) }
    }
    #[inline]
    pub fn set_doff(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn fin(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_fin(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn syn(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_syn(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rst(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_rst(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn psh(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_psh(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ack(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_ack(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urg(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_urg(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn res2(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_res2(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        res1: u16,
        doff: u16,
        fin: u16,
        syn: u16,
        rst: u16,
        psh: u16,
        ack: u16,
        urg: u16,
        res2: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let res1: u16 = unsafe { ::std::mem::transmute(res1) };
            res1 as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let doff: u16 = unsafe { ::std::mem::transmute(doff) };
            doff as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let fin: u16 = unsafe { ::std::mem::transmute(fin) };
            fin as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let syn: u16 = unsafe { ::std::mem::transmute(syn) };
            syn as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let rst: u16 = unsafe { ::std::mem::transmute(rst) };
            rst as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let psh: u16 = unsafe { ::std::mem::transmute(psh) };
            psh as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let ack: u16 = unsafe { ::std::mem::transmute(ack) };
            ack as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let urg: u16 = unsafe { ::std::mem::transmute(urg) };
            urg as u64
        });
        __bindgen_bitfield_unit.set(14usize, 2u8, {
            let res2: u16 = unsafe { ::std::mem::transmute(res2) };
            res2 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const TCP_ESTABLISHED: ::std::os::raw::c_uint = 1;
pub const TCP_SYN_SENT: ::std::os::raw::c_uint = 2;
pub const TCP_SYN_RECV: ::std::os::raw::c_uint = 3;
pub const TCP_FIN_WAIT1: ::std::os::raw::c_uint = 4;
pub const TCP_FIN_WAIT2: ::std::os::raw::c_uint = 5;
pub const TCP_TIME_WAIT: ::std::os::raw::c_uint = 6;
pub const TCP_CLOSE: ::std::os::raw::c_uint = 7;
pub const TCP_CLOSE_WAIT: ::std::os::raw::c_uint = 8;
pub const TCP_LAST_ACK: ::std::os::raw::c_uint = 9;
pub const TCP_LISTEN: ::std::os::raw::c_uint = 10;
pub const TCP_CLOSING: ::std::os::raw::c_uint = 11;
pub type _bindgen_ty_20 = ::std::os::raw::c_uint;
pub const tcp_ca_state_TCP_CA_Open: tcp_ca_state = 0;
pub const tcp_ca_state_TCP_CA_Disorder: tcp_ca_state = 1;
pub const tcp_ca_state_TCP_CA_CWR: tcp_ca_state = 2;
pub const tcp_ca_state_TCP_CA_Recovery: tcp_ca_state = 3;
pub const tcp_ca_state_TCP_CA_Loss: tcp_ca_state = 4;
pub type tcp_ca_state = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tcp_info {
    pub tcpi_state: u8,
    pub tcpi_ca_state: u8,
    pub tcpi_retransmits: u8,
    pub tcpi_probes: u8,
    pub tcpi_backoff: u8,
    pub tcpi_options: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub tcpi_rto: u32,
    pub tcpi_ato: u32,
    pub tcpi_snd_mss: u32,
    pub tcpi_rcv_mss: u32,
    pub tcpi_unacked: u32,
    pub tcpi_sacked: u32,
    pub tcpi_lost: u32,
    pub tcpi_retrans: u32,
    pub tcpi_fackets: u32,
    pub tcpi_last_data_sent: u32,
    pub tcpi_last_ack_sent: u32,
    pub tcpi_last_data_recv: u32,
    pub tcpi_last_ack_recv: u32,
    pub tcpi_pmtu: u32,
    pub tcpi_rcv_ssthresh: u32,
    pub tcpi_rtt: u32,
    pub tcpi_rttvar: u32,
    pub tcpi_snd_ssthresh: u32,
    pub tcpi_snd_cwnd: u32,
    pub tcpi_advmss: u32,
    pub tcpi_reordering: u32,
    pub tcpi_rcv_rtt: u32,
    pub tcpi_rcv_space: u32,
    pub tcpi_total_retrans: u32,
}
impl tcp_info {
    #[inline]
    pub fn tcpi_snd_wscale(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_tcpi_snd_wscale(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn tcpi_rcv_wscale(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_tcpi_rcv_wscale(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        tcpi_snd_wscale: u8,
        tcpi_rcv_wscale: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let tcpi_snd_wscale: u8 = unsafe { ::std::mem::transmute(tcpi_snd_wscale) };
            tcpi_snd_wscale as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let tcpi_rcv_wscale: u8 = unsafe { ::std::mem::transmute(tcpi_rcv_wscale) };
            tcpi_rcv_wscale as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tcp_md5sig {
    pub tcpm_addr: sockaddr_storage,
    pub tcpm_flags: u8,
    pub tcpm_prefixlen: u8,
    pub tcpm_keylen: u16,
    pub __tcpm_pad: u32,
    pub tcpm_key: [u8; 80usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tcp_repair_opt {
    pub opt_code: u32,
    pub opt_val: u32,
}
pub const TCP_NO_QUEUE: ::std::os::raw::c_uint = 0;
pub const TCP_RECV_QUEUE: ::std::os::raw::c_uint = 1;
pub const TCP_SEND_QUEUE: ::std::os::raw::c_uint = 2;
pub const TCP_QUEUES_NR: ::std::os::raw::c_uint = 3;
pub type _bindgen_ty_21 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tcp_cookie_transactions {
    pub tcpct_flags: u16,
    pub __tcpct_pad1: u8,
    pub tcpct_cookie_desired: u8,
    pub tcpct_s_data_desired: u16,
    pub tcpct_used: u16,
    pub tcpct_value: [u8; 536usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tcp_repair_window {
    pub snd_wl1: u32,
    pub snd_wnd: u32,
    pub max_window: u32,
    pub rcv_wnd: u32,
    pub rcv_wup: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tcp_zerocopy_receive {
    pub address: u64,
    pub length: u32,
    pub recv_skip_hint: u32,
}
extern "C" {
    pub fn inet_addr(__cp: *const ::std::os::raw::c_char) -> in_addr_t;
}
extern "C" {
    pub fn inet_lnaof(__in: in_addr) -> in_addr_t;
}
extern "C" {
    pub fn inet_makeaddr(__net: in_addr_t, __host: in_addr_t) -> in_addr;
}
extern "C" {
    pub fn inet_netof(__in: in_addr) -> in_addr_t;
}
extern "C" {
    pub fn inet_network(__cp: *const ::std::os::raw::c_char) -> in_addr_t;
}
extern "C" {
    pub fn inet_ntoa(__in: in_addr) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_pton(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_ntop(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_void,
        __buf: *mut ::std::os::raw::c_char,
        __len: socklen_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_aton(
        __cp: *const ::std::os::raw::c_char,
        __inp: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_neta(
        __net: in_addr_t,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_net_ntop(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_void,
        __bits: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn inet_net_pton(
        __af: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_void,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet_nsap_addr(
        __cp: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_uchar,
        __len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn inet_nsap_ntoa(
        __len: ::std::os::raw::c_int,
        __cp: *const ::std::os::raw::c_uchar,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rpcent {
    pub r_name: *mut ::std::os::raw::c_char,
    pub r_aliases: *mut *mut ::std::os::raw::c_char,
    pub r_number: ::std::os::raw::c_int,
}
extern "C" {
    pub fn setrpcent(__stayopen: ::std::os::raw::c_int);
}
extern "C" {
    pub fn endrpcent();
}
extern "C" {
    pub fn getrpcbyname(__name: *const ::std::os::raw::c_char) -> *mut rpcent;
}
extern "C" {
    pub fn getrpcbynumber(__number: ::std::os::raw::c_int) -> *mut rpcent;
}
extern "C" {
    pub fn getrpcent() -> *mut rpcent;
}
extern "C" {
    pub fn getrpcbyname_r(
        __name: *const ::std::os::raw::c_char,
        __result_buf: *mut rpcent,
        __buffer: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut rpcent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrpcbynumber_r(
        __number: ::std::os::raw::c_int,
        __result_buf: *mut rpcent,
        __buffer: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut rpcent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrpcent_r(
        __result_buf: *mut rpcent,
        __buffer: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut rpcent,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netent {
    pub n_name: *mut ::std::os::raw::c_char,
    pub n_aliases: *mut *mut ::std::os::raw::c_char,
    pub n_addrtype: ::std::os::raw::c_int,
    pub n_net: u32,
}
extern "C" {
    pub fn __h_errno_location() -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn herror(__str: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn hstrerror(__err_num: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_int,
    pub h_length: ::std::os::raw::c_int,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn sethostent(__stay_open: ::std::os::raw::c_int);
}
extern "C" {
    pub fn endhostent();
}
extern "C" {
    pub fn gethostent() -> *mut hostent;
}
extern "C" {
    pub fn gethostbyaddr(
        __addr: *const ::std::os::raw::c_void,
        __len: __socklen_t,
        __type: ::std::os::raw::c_int,
    ) -> *mut hostent;
}
extern "C" {
    pub fn gethostbyname(__name: *const ::std::os::raw::c_char) -> *mut hostent;
}
extern "C" {
    pub fn gethostbyname2(
        __name: *const ::std::os::raw::c_char,
        __af: ::std::os::raw::c_int,
    ) -> *mut hostent;
}
extern "C" {
    pub fn gethostent_r(
        __result_buf: *mut hostent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut hostent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostbyaddr_r(
        __addr: *const ::std::os::raw::c_void,
        __len: __socklen_t,
        __type: ::std::os::raw::c_int,
        __result_buf: *mut hostent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut hostent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostbyname_r(
        __name: *const ::std::os::raw::c_char,
        __result_buf: *mut hostent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut hostent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostbyname2_r(
        __name: *const ::std::os::raw::c_char,
        __af: ::std::os::raw::c_int,
        __result_buf: *mut hostent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut hostent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setnetent(__stay_open: ::std::os::raw::c_int);
}
extern "C" {
    pub fn endnetent();
}
extern "C" {
    pub fn getnetent() -> *mut netent;
}
extern "C" {
    pub fn getnetbyaddr(__net: u32, __type: ::std::os::raw::c_int) -> *mut netent;
}
extern "C" {
    pub fn getnetbyname(__name: *const ::std::os::raw::c_char) -> *mut netent;
}
extern "C" {
    pub fn getnetent_r(
        __result_buf: *mut netent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut netent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getnetbyaddr_r(
        __net: u32,
        __type: ::std::os::raw::c_int,
        __result_buf: *mut netent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut netent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getnetbyname_r(
        __name: *const ::std::os::raw::c_char,
        __result_buf: *mut netent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut netent,
        __h_errnop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servent {
    pub s_name: *mut ::std::os::raw::c_char,
    pub s_aliases: *mut *mut ::std::os::raw::c_char,
    pub s_port: ::std::os::raw::c_int,
    pub s_proto: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn setservent(__stay_open: ::std::os::raw::c_int);
}
extern "C" {
    pub fn endservent();
}
extern "C" {
    pub fn getservent() -> *mut servent;
}
extern "C" {
    pub fn getservbyname(
        __name: *const ::std::os::raw::c_char,
        __proto: *const ::std::os::raw::c_char,
    ) -> *mut servent;
}
extern "C" {
    pub fn getservbyport(
        __port: ::std::os::raw::c_int,
        __proto: *const ::std::os::raw::c_char,
    ) -> *mut servent;
}
extern "C" {
    pub fn getservent_r(
        __result_buf: *mut servent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut servent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getservbyname_r(
        __name: *const ::std::os::raw::c_char,
        __proto: *const ::std::os::raw::c_char,
        __result_buf: *mut servent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut servent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getservbyport_r(
        __port: ::std::os::raw::c_int,
        __proto: *const ::std::os::raw::c_char,
        __result_buf: *mut servent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut servent,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct protoent {
    pub p_name: *mut ::std::os::raw::c_char,
    pub p_aliases: *mut *mut ::std::os::raw::c_char,
    pub p_proto: ::std::os::raw::c_int,
}
extern "C" {
    pub fn setprotoent(__stay_open: ::std::os::raw::c_int);
}
extern "C" {
    pub fn endprotoent();
}
extern "C" {
    pub fn getprotoent() -> *mut protoent;
}
extern "C" {
    pub fn getprotobyname(__name: *const ::std::os::raw::c_char) -> *mut protoent;
}
extern "C" {
    pub fn getprotobynumber(__proto: ::std::os::raw::c_int) -> *mut protoent;
}
extern "C" {
    pub fn getprotoent_r(
        __result_buf: *mut protoent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut protoent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprotobyname_r(
        __name: *const ::std::os::raw::c_char,
        __result_buf: *mut protoent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut protoent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprotobynumber_r(
        __proto: ::std::os::raw::c_int,
        __result_buf: *mut protoent,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
        __result: *mut *mut protoent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setnetgrent(__netgroup: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn endnetgrent();
}
extern "C" {
    pub fn getnetgrent(
        __hostp: *mut *mut ::std::os::raw::c_char,
        __userp: *mut *mut ::std::os::raw::c_char,
        __domainp: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn innetgr(
        __netgroup: *const ::std::os::raw::c_char,
        __host: *const ::std::os::raw::c_char,
        __user: *const ::std::os::raw::c_char,
        __domain: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getnetgrent_r(
        __hostp: *mut *mut ::std::os::raw::c_char,
        __userp: *mut *mut ::std::os::raw::c_char,
        __domainp: *mut *mut ::std::os::raw::c_char,
        __buffer: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rcmd(
        __ahost: *mut *mut ::std::os::raw::c_char,
        __rport: ::std::os::raw::c_ushort,
        __locuser: *const ::std::os::raw::c_char,
        __remuser: *const ::std::os::raw::c_char,
        __cmd: *const ::std::os::raw::c_char,
        __fd2p: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rcmd_af(
        __ahost: *mut *mut ::std::os::raw::c_char,
        __rport: ::std::os::raw::c_ushort,
        __locuser: *const ::std::os::raw::c_char,
        __remuser: *const ::std::os::raw::c_char,
        __cmd: *const ::std::os::raw::c_char,
        __fd2p: *mut ::std::os::raw::c_int,
        __af: sa_family_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rexec(
        __ahost: *mut *mut ::std::os::raw::c_char,
        __rport: ::std::os::raw::c_int,
        __name: *const ::std::os::raw::c_char,
        __pass: *const ::std::os::raw::c_char,
        __cmd: *const ::std::os::raw::c_char,
        __fd2p: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rexec_af(
        __ahost: *mut *mut ::std::os::raw::c_char,
        __rport: ::std::os::raw::c_int,
        __name: *const ::std::os::raw::c_char,
        __pass: *const ::std::os::raw::c_char,
        __cmd: *const ::std::os::raw::c_char,
        __fd2p: *mut ::std::os::raw::c_int,
        __af: sa_family_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruserok(
        __rhost: *const ::std::os::raw::c_char,
        __suser: ::std::os::raw::c_int,
        __remuser: *const ::std::os::raw::c_char,
        __locuser: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruserok_af(
        __rhost: *const ::std::os::raw::c_char,
        __suser: ::std::os::raw::c_int,
        __remuser: *const ::std::os::raw::c_char,
        __locuser: *const ::std::os::raw::c_char,
        __af: sa_family_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iruserok(
        __raddr: u32,
        __suser: ::std::os::raw::c_int,
        __remuser: *const ::std::os::raw::c_char,
        __locuser: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iruserok_af(
        __raddr: *const ::std::os::raw::c_void,
        __suser: ::std::os::raw::c_int,
        __remuser: *const ::std::os::raw::c_char,
        __locuser: *const ::std::os::raw::c_char,
        __af: sa_family_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rresvport(__alport: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rresvport_af(
        __alport: *mut ::std::os::raw::c_int,
        __af: sa_family_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct addrinfo {
    pub ai_flags: ::std::os::raw::c_int,
    pub ai_family: ::std::os::raw::c_int,
    pub ai_socktype: ::std::os::raw::c_int,
    pub ai_protocol: ::std::os::raw::c_int,
    pub ai_addrlen: socklen_t,
    pub ai_addr: *mut sockaddr,
    pub ai_canonname: *mut ::std::os::raw::c_char,
    pub ai_next: *mut addrinfo,
}
extern "C" {
    pub fn getaddrinfo(
        __name: *const ::std::os::raw::c_char,
        __service: *const ::std::os::raw::c_char,
        __req: *const addrinfo,
        __pai: *mut *mut addrinfo,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn freeaddrinfo(__ai: *mut addrinfo);
}
extern "C" {
    pub fn gai_strerror(__ecode: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn getnameinfo(
        __sa: *const sockaddr,
        __salen: socklen_t,
        __host: *mut ::std::os::raw::c_char,
        __hostlen: socklen_t,
        __serv: *mut ::std::os::raw::c_char,
        __servlen: socklen_t,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_un {
    pub sun_family: sa_family_t,
    pub sun_path: [::std::os::raw::c_char; 108usize],
}
extern "C" {
    pub fn os_set_line_buffering();
}
extern "C" {
    pub fn os_set_proc_name(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn os_setup_signal_handling();
}
extern "C" {
    pub fn os_daemonize();
}
extern "C" {
    pub fn os_setup_post();
}
extern "C" {
    pub fn os_mlock() -> ::std::os::raw::c_int;
}
pub type qemu_timeval = timeval;
pub type qemu_timespec = timespec;
extern "C" {
    pub fn qemu_utimens(
        path: *const ::std::os::raw::c_char,
        times: *const qemu_timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn is_daemonized() -> bool;
}
extern "C" {
    #[doc = " qemu_alloc_stack:"]
    #[doc = " @sz: pointer to a size_t holding the requested usable stack size"]
    #[doc = ""]
    #[doc = " Allocate memory that can be used as a stack, for instance for"]
    #[doc = " coroutines. If the memory cannot be allocated, this function"]
    #[doc = " will abort (like g_malloc()). This function also inserts an"]
    #[doc = " additional guard page to catch a potential stack overflow."]
    #[doc = " Note that the memory required for the guard page and alignment"]
    #[doc = " and minimal stack size restrictions will increase the value of sz."]
    #[doc = ""]
    #[doc = " The allocated stack must be freed with qemu_free_stack()."]
    #[doc = ""]
    #[doc = " Returns: pointer to (the lowest address of) the stack memory."]
    pub fn qemu_alloc_stack(sz: *mut size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " qemu_free_stack:"]
    #[doc = " @stack: stack to free"]
    #[doc = " @sz: size of stack in bytes"]
    #[doc = ""]
    #[doc = " Free a stack allocated via qemu_alloc_stack(). Note that sz must"]
    #[doc = " be exactly the adjusted stack size returned by qemu_alloc_stack."]
    pub fn qemu_free_stack(stack: *mut ::std::os::raw::c_void, sz: size_t);
}
pub type gint8 = ::std::os::raw::c_schar;
pub type guint8 = ::std::os::raw::c_uchar;
pub type gint16 = ::std::os::raw::c_short;
pub type guint16 = ::std::os::raw::c_ushort;
pub type gint32 = ::std::os::raw::c_int;
pub type guint32 = ::std::os::raw::c_uint;
pub type gint64 = ::std::os::raw::c_long;
pub type guint64 = ::std::os::raw::c_ulong;
pub type gssize = ::std::os::raw::c_long;
pub type gsize = ::std::os::raw::c_ulong;
pub type goffset = gint64;
pub type gintptr = ::std::os::raw::c_long;
pub type guintptr = ::std::os::raw::c_ulong;
pub type GPid = ::std::os::raw::c_int;
pub type gchar = ::std::os::raw::c_char;
pub type gshort = ::std::os::raw::c_short;
pub type glong = ::std::os::raw::c_long;
pub type gint = ::std::os::raw::c_int;
pub type gboolean = gint;
pub type guchar = ::std::os::raw::c_uchar;
pub type gushort = ::std::os::raw::c_ushort;
pub type gulong = ::std::os::raw::c_ulong;
pub type guint = ::std::os::raw::c_uint;
pub type gfloat = f32;
pub type gdouble = f64;
pub type gpointer = *mut ::std::os::raw::c_void;
pub type gconstpointer = *const ::std::os::raw::c_void;
pub type GCompareFunc =
    ::std::option::Option<unsafe extern "C" fn(a: gconstpointer, b: gconstpointer) -> gint>;
pub type GCompareDataFunc = ::std::option::Option<
    unsafe extern "C" fn(a: gconstpointer, b: gconstpointer, user_data: gpointer) -> gint,
>;
pub type GEqualFunc =
    ::std::option::Option<unsafe extern "C" fn(a: gconstpointer, b: gconstpointer) -> gboolean>;
pub type GDestroyNotify = ::std::option::Option<unsafe extern "C" fn(data: gpointer)>;
pub type GFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer, user_data: gpointer)>;
pub type GHashFunc = ::std::option::Option<unsafe extern "C" fn(key: gconstpointer) -> guint>;
pub type GHFunc = ::std::option::Option<
    unsafe extern "C" fn(key: gpointer, value: gpointer, user_data: gpointer),
>;
#[doc = " GCopyFunc:"]
#[doc = " @src: (not nullable): A pointer to the data which should be copied"]
#[doc = " @data: Additional data"]
#[doc = ""]
#[doc = " A function of this signature is used to copy the node data"]
#[doc = " when doing a deep-copy of a tree."]
#[doc = ""]
#[doc = " Returns: (not nullable): A pointer to the copy"]
#[doc = ""]
#[doc = " Since: 2.4"]
pub type GCopyFunc =
    ::std::option::Option<unsafe extern "C" fn(src: gconstpointer, data: gpointer) -> gpointer>;
#[doc = " GFreeFunc:"]
#[doc = " @data: a data pointer"]
#[doc = ""]
#[doc = " Declares a type of function which takes an arbitrary"]
#[doc = " data pointer argument and has no return value. It is"]
#[doc = " not currently used in GLib or GTK+."]
pub type GFreeFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer)>;
#[doc = " GTranslateFunc:"]
#[doc = " @str: the untranslated string"]
#[doc = " @data: user data specified when installing the function, e.g."]
#[doc = "  in g_option_group_set_translate_func()"]
#[doc = ""]
#[doc = " The type of functions which are used to translate user-visible"]
#[doc = " strings, for <option>--help</option> output."]
#[doc = ""]
#[doc = " Returns: a translation of the string for the current locale."]
#[doc = "  The returned string is owned by GLib and must not be freed."]
pub type GTranslateFunc =
    ::std::option::Option<unsafe extern "C" fn(str_: *const gchar, data: gpointer) -> *const gchar>;
pub type GDoubleIEEE754 = _GDoubleIEEE754;
pub type GFloatIEEE754 = _GFloatIEEE754;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GFloatIEEE754 {
    pub v_float: gfloat,
    pub mpn: _GFloatIEEE754__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _GFloatIEEE754__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl _GFloatIEEE754__bindgen_ty_1 {
    #[inline]
    pub fn mantissa(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 23u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 23u8, val as u64)
        }
    }
    #[inline]
    pub fn biased_exponent(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_biased_exponent(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn sign(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mantissa: guint,
        biased_exponent: guint,
        sign: guint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 23u8, {
            let mantissa: u32 = unsafe { ::std::mem::transmute(mantissa) };
            mantissa as u64
        });
        __bindgen_bitfield_unit.set(23usize, 8u8, {
            let biased_exponent: u32 = unsafe { ::std::mem::transmute(biased_exponent) };
            biased_exponent as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let sign: u32 = unsafe { ::std::mem::transmute(sign) };
            sign as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GDoubleIEEE754 {
    pub v_double: gdouble,
    pub mpn: _GDoubleIEEE754__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _GDoubleIEEE754__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl _GDoubleIEEE754__bindgen_ty_1 {
    #[inline]
    pub fn mantissa_low(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa_low(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn mantissa_high(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa_high(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn biased_exponent(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(52usize, 11u8) as u32) }
    }
    #[inline]
    pub fn set_biased_exponent(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(52usize, 11u8, val as u64)
        }
    }
    #[inline]
    pub fn sign(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(63usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(63usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mantissa_low: guint,
        mantissa_high: guint,
        biased_exponent: guint,
        sign: guint,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 32u8, {
            let mantissa_low: u32 = unsafe { ::std::mem::transmute(mantissa_low) };
            mantissa_low as u64
        });
        __bindgen_bitfield_unit.set(32usize, 20u8, {
            let mantissa_high: u32 = unsafe { ::std::mem::transmute(mantissa_high) };
            mantissa_high as u64
        });
        __bindgen_bitfield_unit.set(52usize, 11u8, {
            let biased_exponent: u32 = unsafe { ::std::mem::transmute(biased_exponent) };
            biased_exponent as u64
        });
        __bindgen_bitfield_unit.set(63usize, 1u8, {
            let sign: u32 = unsafe { ::std::mem::transmute(sign) };
            sign as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type GTimeVal = _GTimeVal;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTimeVal {
    pub tv_sec: glong,
    pub tv_usec: glong,
}
pub type grefcount = gint;
pub type gatomicrefcount = gint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBytes {
    _unused: [u8; 0],
}
pub type GBytes = _GBytes;
pub type GArray = _GArray;
pub type GByteArray = _GByteArray;
pub type GPtrArray = _GPtrArray;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GArray {
    pub data: *mut gchar,
    pub len: guint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GByteArray {
    pub data: *mut guint8,
    pub len: guint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPtrArray {
    pub pdata: *mut gpointer,
    pub len: guint,
}
extern "C" {
    pub fn g_array_new(
        zero_terminated: gboolean,
        clear_: gboolean,
        element_size: guint,
    ) -> *mut GArray;
}
extern "C" {
    pub fn g_array_steal(array: *mut GArray, len: *mut gsize) -> gpointer;
}
extern "C" {
    pub fn g_array_sized_new(
        zero_terminated: gboolean,
        clear_: gboolean,
        element_size: guint,
        reserved_size: guint,
    ) -> *mut GArray;
}
extern "C" {
    pub fn g_array_copy(array: *mut GArray) -> *mut GArray;
}
extern "C" {
    pub fn g_array_free(array: *mut GArray, free_segment: gboolean) -> *mut gchar;
}
extern "C" {
    pub fn g_array_ref(array: *mut GArray) -> *mut GArray;
}
extern "C" {
    pub fn g_array_unref(array: *mut GArray);
}
extern "C" {
    pub fn g_array_get_element_size(array: *mut GArray) -> guint;
}
extern "C" {
    pub fn g_array_append_vals(array: *mut GArray, data: gconstpointer, len: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_prepend_vals(array: *mut GArray, data: gconstpointer, len: guint)
        -> *mut GArray;
}
extern "C" {
    pub fn g_array_insert_vals(
        array: *mut GArray,
        index_: guint,
        data: gconstpointer,
        len: guint,
    ) -> *mut GArray;
}
extern "C" {
    pub fn g_array_set_size(array: *mut GArray, length: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_remove_index(array: *mut GArray, index_: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_remove_index_fast(array: *mut GArray, index_: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_remove_range(array: *mut GArray, index_: guint, length: guint) -> *mut GArray;
}
extern "C" {
    pub fn g_array_sort(array: *mut GArray, compare_func: GCompareFunc);
}
extern "C" {
    pub fn g_array_sort_with_data(
        array: *mut GArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_array_binary_search(
        array: *mut GArray,
        target: gconstpointer,
        compare_func: GCompareFunc,
        out_match_index: *mut guint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_array_set_clear_func(array: *mut GArray, clear_func: GDestroyNotify);
}
extern "C" {
    pub fn g_ptr_array_new() -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_new_with_free_func(element_free_func: GDestroyNotify) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_steal(array: *mut GPtrArray, len: *mut gsize) -> *mut gpointer;
}
extern "C" {
    pub fn g_ptr_array_copy(
        array: *mut GPtrArray,
        func: GCopyFunc,
        user_data: gpointer,
    ) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_sized_new(reserved_size: guint) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_new_full(
        reserved_size: guint,
        element_free_func: GDestroyNotify,
    ) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_free(array: *mut GPtrArray, free_seg: gboolean) -> *mut gpointer;
}
extern "C" {
    pub fn g_ptr_array_ref(array: *mut GPtrArray) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_unref(array: *mut GPtrArray);
}
extern "C" {
    pub fn g_ptr_array_set_free_func(array: *mut GPtrArray, element_free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_ptr_array_set_size(array: *mut GPtrArray, length: gint);
}
extern "C" {
    pub fn g_ptr_array_remove_index(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_remove_index_fast(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_steal_index(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_steal_index_fast(array: *mut GPtrArray, index_: guint) -> gpointer;
}
extern "C" {
    pub fn g_ptr_array_remove(array: *mut GPtrArray, data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_ptr_array_remove_fast(array: *mut GPtrArray, data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_ptr_array_remove_range(
        array: *mut GPtrArray,
        index_: guint,
        length: guint,
    ) -> *mut GPtrArray;
}
extern "C" {
    pub fn g_ptr_array_add(array: *mut GPtrArray, data: gpointer);
}
extern "C" {
    pub fn g_ptr_array_extend(
        array_to_extend: *mut GPtrArray,
        array: *mut GPtrArray,
        func: GCopyFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_ptr_array_extend_and_steal(array_to_extend: *mut GPtrArray, array: *mut GPtrArray);
}
extern "C" {
    pub fn g_ptr_array_insert(array: *mut GPtrArray, index_: gint, data: gpointer);
}
extern "C" {
    pub fn g_ptr_array_sort(array: *mut GPtrArray, compare_func: GCompareFunc);
}
extern "C" {
    pub fn g_ptr_array_sort_with_data(
        array: *mut GPtrArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_ptr_array_foreach(array: *mut GPtrArray, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_ptr_array_find(
        haystack: *mut GPtrArray,
        needle: gconstpointer,
        index_: *mut guint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_ptr_array_find_with_equal_func(
        haystack: *mut GPtrArray,
        needle: gconstpointer,
        equal_func: GEqualFunc,
        index_: *mut guint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_byte_array_new() -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_new_take(data: *mut guint8, len: gsize) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_steal(array: *mut GByteArray, len: *mut gsize) -> *mut guint8;
}
extern "C" {
    pub fn g_byte_array_sized_new(reserved_size: guint) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_free(array: *mut GByteArray, free_segment: gboolean) -> *mut guint8;
}
extern "C" {
    pub fn g_byte_array_free_to_bytes(array: *mut GByteArray) -> *mut GBytes;
}
extern "C" {
    pub fn g_byte_array_ref(array: *mut GByteArray) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_unref(array: *mut GByteArray);
}
extern "C" {
    pub fn g_byte_array_append(
        array: *mut GByteArray,
        data: *const guint8,
        len: guint,
    ) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_prepend(
        array: *mut GByteArray,
        data: *const guint8,
        len: guint,
    ) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_set_size(array: *mut GByteArray, length: guint) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_remove_index(array: *mut GByteArray, index_: guint) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_remove_index_fast(array: *mut GByteArray, index_: guint)
        -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_remove_range(
        array: *mut GByteArray,
        index_: guint,
        length: guint,
    ) -> *mut GByteArray;
}
extern "C" {
    pub fn g_byte_array_sort(array: *mut GByteArray, compare_func: GCompareFunc);
}
extern "C" {
    pub fn g_byte_array_sort_with_data(
        array: *mut GByteArray,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_atomic_int_get(atomic: *const gint) -> gint;
}
extern "C" {
    pub fn g_atomic_int_set(atomic: *mut gint, newval: gint);
}
extern "C" {
    pub fn g_atomic_int_inc(atomic: *mut gint);
}
extern "C" {
    pub fn g_atomic_int_dec_and_test(atomic: *mut gint) -> gboolean;
}
extern "C" {
    pub fn g_atomic_int_compare_and_exchange(
        atomic: *mut gint,
        oldval: gint,
        newval: gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_atomic_int_add(atomic: *mut gint, val: gint) -> gint;
}
extern "C" {
    pub fn g_atomic_int_and(atomic: *mut guint, val: guint) -> guint;
}
extern "C" {
    pub fn g_atomic_int_or(atomic: *mut guint, val: guint) -> guint;
}
extern "C" {
    pub fn g_atomic_int_xor(atomic: *mut guint, val: guint) -> guint;
}
extern "C" {
    pub fn g_atomic_pointer_get(atomic: *const ::std::os::raw::c_void) -> gpointer;
}
extern "C" {
    pub fn g_atomic_pointer_set(atomic: *mut ::std::os::raw::c_void, newval: gpointer);
}
extern "C" {
    pub fn g_atomic_pointer_compare_and_exchange(
        atomic: *mut ::std::os::raw::c_void,
        oldval: gpointer,
        newval: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_atomic_pointer_add(atomic: *mut ::std::os::raw::c_void, val: gssize) -> gssize;
}
extern "C" {
    pub fn g_atomic_pointer_and(atomic: *mut ::std::os::raw::c_void, val: gsize) -> gsize;
}
extern "C" {
    pub fn g_atomic_pointer_or(atomic: *mut ::std::os::raw::c_void, val: gsize) -> gsize;
}
extern "C" {
    pub fn g_atomic_pointer_xor(atomic: *mut ::std::os::raw::c_void, val: gsize) -> gsize;
}
extern "C" {
    pub fn g_atomic_int_exchange_and_add(atomic: *mut gint, val: gint) -> gint;
}
pub type GQuark = guint32;
extern "C" {
    pub fn g_quark_try_string(string: *const gchar) -> GQuark;
}
extern "C" {
    pub fn g_quark_from_static_string(string: *const gchar) -> GQuark;
}
extern "C" {
    pub fn g_quark_from_string(string: *const gchar) -> GQuark;
}
extern "C" {
    pub fn g_quark_to_string(quark: GQuark) -> *const gchar;
}
extern "C" {
    pub fn g_intern_string(string: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_intern_static_string(string: *const gchar) -> *const gchar;
}
#[doc = " GError:"]
#[doc = " @domain: error domain, e.g. #G_FILE_ERROR"]
#[doc = " @code: error code, e.g. %G_FILE_ERROR_NOENT"]
#[doc = " @message: human-readable informative error message"]
#[doc = ""]
#[doc = " The `GError` structure contains information about"]
#[doc = " an error that has occurred."]
pub type GError = _GError;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GError {
    pub domain: GQuark,
    pub code: gint,
    pub message: *mut gchar,
}
extern "C" {
    pub fn g_error_new(domain: GQuark, code: gint, format: *const gchar, ...) -> *mut GError;
}
extern "C" {
    pub fn g_error_new_literal(domain: GQuark, code: gint, message: *const gchar) -> *mut GError;
}
extern "C" {
    pub fn g_error_new_valist(
        domain: GQuark,
        code: gint,
        format: *const gchar,
        args: *mut __va_list_tag,
    ) -> *mut GError;
}
extern "C" {
    pub fn g_error_free(error: *mut GError);
}
extern "C" {
    pub fn g_error_copy(error: *const GError) -> *mut GError;
}
extern "C" {
    pub fn g_error_matches(error: *const GError, domain: GQuark, code: gint) -> gboolean;
}
extern "C" {
    pub fn g_set_error(
        err: *mut *mut GError,
        domain: GQuark,
        code: gint,
        format: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_set_error_literal(
        err: *mut *mut GError,
        domain: GQuark,
        code: gint,
        message: *const gchar,
    );
}
extern "C" {
    pub fn g_propagate_error(dest: *mut *mut GError, src: *mut GError);
}
extern "C" {
    pub fn g_clear_error(err: *mut *mut GError);
}
extern "C" {
    pub fn g_prefix_error(err: *mut *mut GError, format: *const gchar, ...);
}
extern "C" {
    pub fn g_propagate_prefixed_error(
        dest: *mut *mut GError,
        src: *mut GError,
        format: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_get_user_name() -> *const gchar;
}
extern "C" {
    pub fn g_get_real_name() -> *const gchar;
}
extern "C" {
    pub fn g_get_home_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_tmp_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_host_name() -> *const gchar;
}
extern "C" {
    pub fn g_get_prgname() -> *const gchar;
}
extern "C" {
    pub fn g_set_prgname(prgname: *const gchar);
}
extern "C" {
    pub fn g_get_application_name() -> *const gchar;
}
extern "C" {
    pub fn g_set_application_name(application_name: *const gchar);
}
extern "C" {
    pub fn g_get_os_info(key_name: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_reload_user_special_dirs_cache();
}
extern "C" {
    pub fn g_get_user_data_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_user_config_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_user_cache_dir() -> *const gchar;
}
extern "C" {
    pub fn g_get_system_data_dirs() -> *const *const gchar;
}
extern "C" {
    pub fn g_get_system_config_dirs() -> *const *const gchar;
}
extern "C" {
    pub fn g_get_user_runtime_dir() -> *const gchar;
}
pub const GUserDirectory_G_USER_DIRECTORY_DESKTOP: GUserDirectory = 0;
pub const GUserDirectory_G_USER_DIRECTORY_DOCUMENTS: GUserDirectory = 1;
pub const GUserDirectory_G_USER_DIRECTORY_DOWNLOAD: GUserDirectory = 2;
pub const GUserDirectory_G_USER_DIRECTORY_MUSIC: GUserDirectory = 3;
pub const GUserDirectory_G_USER_DIRECTORY_PICTURES: GUserDirectory = 4;
pub const GUserDirectory_G_USER_DIRECTORY_PUBLIC_SHARE: GUserDirectory = 5;
pub const GUserDirectory_G_USER_DIRECTORY_TEMPLATES: GUserDirectory = 6;
pub const GUserDirectory_G_USER_DIRECTORY_VIDEOS: GUserDirectory = 7;
pub const GUserDirectory_G_USER_N_DIRECTORIES: GUserDirectory = 8;
#[doc = " GUserDirectory:"]
#[doc = " @G_USER_DIRECTORY_DESKTOP: the user's Desktop directory"]
#[doc = " @G_USER_DIRECTORY_DOCUMENTS: the user's Documents directory"]
#[doc = " @G_USER_DIRECTORY_DOWNLOAD: the user's Downloads directory"]
#[doc = " @G_USER_DIRECTORY_MUSIC: the user's Music directory"]
#[doc = " @G_USER_DIRECTORY_PICTURES: the user's Pictures directory"]
#[doc = " @G_USER_DIRECTORY_PUBLIC_SHARE: the user's shared directory"]
#[doc = " @G_USER_DIRECTORY_TEMPLATES: the user's Templates directory"]
#[doc = " @G_USER_DIRECTORY_VIDEOS: the user's Movies directory"]
#[doc = " @G_USER_N_DIRECTORIES: the number of enum values"]
#[doc = ""]
#[doc = " These are logical ids for special directories which are defined"]
#[doc = " depending on the platform used. You should use g_get_user_special_dir()"]
#[doc = " to retrieve the full path associated to the logical id."]
#[doc = ""]
#[doc = " The #GUserDirectory enumeration can be extended at later date. Not"]
#[doc = " every platform has a directory for every logical id in this"]
#[doc = " enumeration."]
#[doc = ""]
#[doc = " Since: 2.14"]
pub type GUserDirectory = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_get_user_special_dir(directory: GUserDirectory) -> *const gchar;
}
#[doc = " GDebugKey:"]
#[doc = " @key: the string"]
#[doc = " @value: the flag"]
#[doc = ""]
#[doc = " Associates a string with a bit flag."]
#[doc = " Used in g_parse_debug_string()."]
pub type GDebugKey = _GDebugKey;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDebugKey {
    pub key: *const gchar,
    pub value: guint,
}
extern "C" {
    pub fn g_parse_debug_string(
        string: *const gchar,
        keys: *const GDebugKey,
        nkeys: guint,
    ) -> guint;
}
extern "C" {
    pub fn g_snprintf(string: *mut gchar, n: gulong, format: *const gchar, ...) -> gint;
}
extern "C" {
    pub fn g_vsnprintf(
        string: *mut gchar,
        n: gulong,
        format: *const gchar,
        args: *mut __va_list_tag,
    ) -> gint;
}
extern "C" {
    pub fn g_nullify_pointer(nullify_location: *mut gpointer);
}
pub const GFormatSizeFlags_G_FORMAT_SIZE_DEFAULT: GFormatSizeFlags = 0;
pub const GFormatSizeFlags_G_FORMAT_SIZE_LONG_FORMAT: GFormatSizeFlags = 1;
pub const GFormatSizeFlags_G_FORMAT_SIZE_IEC_UNITS: GFormatSizeFlags = 2;
pub const GFormatSizeFlags_G_FORMAT_SIZE_BITS: GFormatSizeFlags = 4;
pub type GFormatSizeFlags = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_format_size_full(size: guint64, flags: GFormatSizeFlags) -> *mut gchar;
}
extern "C" {
    pub fn g_format_size(size: guint64) -> *mut gchar;
}
extern "C" {
    pub fn g_format_size_for_display(size: goffset) -> *mut gchar;
}
#[doc = " GVoidFunc:"]
#[doc = ""]
#[doc = " Declares a type of function which takes no arguments"]
#[doc = " and has no return value. It is used to specify the type"]
#[doc = " function passed to g_atexit()."]
pub type GVoidFunc = ::std::option::Option<unsafe extern "C" fn()>;
extern "C" {
    pub fn g_atexit(func: GVoidFunc);
}
extern "C" {
    pub fn g_find_program_in_path(program: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_bit_nth_lsf(mask: gulong, nth_bit: gint) -> gint;
}
extern "C" {
    pub fn g_bit_nth_msf(mask: gulong, nth_bit: gint) -> gint;
}
extern "C" {
    pub fn g_bit_storage(number: gulong) -> guint;
}
extern "C" {
    pub fn g_thread_error_quark() -> GQuark;
}
pub const GThreadError_G_THREAD_ERROR_AGAIN: GThreadError = 0;
pub type GThreadError = ::std::os::raw::c_uint;
pub type GThreadFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer) -> gpointer>;
pub type GThread = _GThread;
pub type GMutex = _GMutex;
pub type GRecMutex = _GRecMutex;
pub type GRWLock = _GRWLock;
pub type GCond = _GCond;
pub type GPrivate = _GPrivate;
pub type GOnce = _GOnce;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GMutex {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRWLock {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCond {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRecMutex {
    pub p: gpointer,
    pub i: [guint; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPrivate {
    pub p: gpointer,
    pub notify: GDestroyNotify,
    pub future: [gpointer; 2usize],
}
pub const GOnceStatus_G_ONCE_STATUS_NOTCALLED: GOnceStatus = 0;
pub const GOnceStatus_G_ONCE_STATUS_PROGRESS: GOnceStatus = 1;
pub const GOnceStatus_G_ONCE_STATUS_READY: GOnceStatus = 2;
pub type GOnceStatus = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOnce {
    pub status: GOnceStatus,
    pub retval: gpointer,
}
extern "C" {
    pub fn g_thread_ref(thread: *mut GThread) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_unref(thread: *mut GThread);
}
extern "C" {
    pub fn g_thread_new(name: *const gchar, func: GThreadFunc, data: gpointer) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_try_new(
        name: *const gchar,
        func: GThreadFunc,
        data: gpointer,
        error: *mut *mut GError,
    ) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_self() -> *mut GThread;
}
extern "C" {
    pub fn g_thread_exit(retval: gpointer);
}
extern "C" {
    pub fn g_thread_join(thread: *mut GThread) -> gpointer;
}
extern "C" {
    pub fn g_thread_yield();
}
extern "C" {
    pub fn g_mutex_init(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_mutex_clear(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_mutex_lock(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_mutex_trylock(mutex: *mut GMutex) -> gboolean;
}
extern "C" {
    pub fn g_mutex_unlock(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_rw_lock_init(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_clear(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_writer_lock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_writer_trylock(rw_lock: *mut GRWLock) -> gboolean;
}
extern "C" {
    pub fn g_rw_lock_writer_unlock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_reader_lock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rw_lock_reader_trylock(rw_lock: *mut GRWLock) -> gboolean;
}
extern "C" {
    pub fn g_rw_lock_reader_unlock(rw_lock: *mut GRWLock);
}
extern "C" {
    pub fn g_rec_mutex_init(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_rec_mutex_clear(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_rec_mutex_lock(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_rec_mutex_trylock(rec_mutex: *mut GRecMutex) -> gboolean;
}
extern "C" {
    pub fn g_rec_mutex_unlock(rec_mutex: *mut GRecMutex);
}
extern "C" {
    pub fn g_cond_init(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_clear(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_wait(cond: *mut GCond, mutex: *mut GMutex);
}
extern "C" {
    pub fn g_cond_signal(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_broadcast(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_wait_until(cond: *mut GCond, mutex: *mut GMutex, end_time: gint64) -> gboolean;
}
extern "C" {
    pub fn g_private_get(key: *mut GPrivate) -> gpointer;
}
extern "C" {
    pub fn g_private_set(key: *mut GPrivate, value: gpointer);
}
extern "C" {
    pub fn g_private_replace(key: *mut GPrivate, value: gpointer);
}
extern "C" {
    pub fn g_once_impl(once: *mut GOnce, func: GThreadFunc, arg: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_once_init_enter(location: *mut ::std::os::raw::c_void) -> gboolean;
}
extern "C" {
    pub fn g_once_init_leave(location: *mut ::std::os::raw::c_void, result: gsize);
}
extern "C" {
    pub fn g_get_num_processors() -> guint;
}
#[doc = " GMutexLocker:"]
#[doc = ""]
#[doc = " Opaque type. See g_mutex_locker_new() for details."]
#[doc = " Since: 2.44"]
pub type GMutexLocker = ::std::os::raw::c_void;
#[doc = " GRecMutexLocker:"]
#[doc = ""]
#[doc = " Opaque type. See g_rec_mutex_locker_new() for details."]
#[doc = " Since: 2.60"]
pub type GRecMutexLocker = ::std::os::raw::c_void;
#[doc = " GRWLockWriterLocker:"]
#[doc = ""]
#[doc = " Opaque type. See g_rw_lock_writer_locker_new() for details."]
#[doc = " Since: 2.62"]
pub type GRWLockWriterLocker = ::std::os::raw::c_void;
#[doc = " GRWLockReaderLocker:"]
#[doc = ""]
#[doc = " Opaque type. See g_rw_lock_reader_locker_new() for details."]
#[doc = " Since: 2.62"]
pub type GRWLockReaderLocker = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAsyncQueue {
    _unused: [u8; 0],
}
pub type GAsyncQueue = _GAsyncQueue;
extern "C" {
    pub fn g_async_queue_new() -> *mut GAsyncQueue;
}
extern "C" {
    pub fn g_async_queue_new_full(item_free_func: GDestroyNotify) -> *mut GAsyncQueue;
}
extern "C" {
    pub fn g_async_queue_lock(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_unlock(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_ref(queue: *mut GAsyncQueue) -> *mut GAsyncQueue;
}
extern "C" {
    pub fn g_async_queue_unref(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_ref_unlocked(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_unref_and_unlock(queue: *mut GAsyncQueue);
}
extern "C" {
    pub fn g_async_queue_push(queue: *mut GAsyncQueue, data: gpointer);
}
extern "C" {
    pub fn g_async_queue_push_unlocked(queue: *mut GAsyncQueue, data: gpointer);
}
extern "C" {
    pub fn g_async_queue_push_sorted(
        queue: *mut GAsyncQueue,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_queue_push_sorted_unlocked(
        queue: *mut GAsyncQueue,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_queue_pop(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_pop_unlocked(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_try_pop(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_try_pop_unlocked(queue: *mut GAsyncQueue) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_timeout_pop(queue: *mut GAsyncQueue, timeout: guint64) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_timeout_pop_unlocked(
        queue: *mut GAsyncQueue,
        timeout: guint64,
    ) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_length(queue: *mut GAsyncQueue) -> gint;
}
extern "C" {
    pub fn g_async_queue_length_unlocked(queue: *mut GAsyncQueue) -> gint;
}
extern "C" {
    pub fn g_async_queue_sort(queue: *mut GAsyncQueue, func: GCompareDataFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_async_queue_sort_unlocked(
        queue: *mut GAsyncQueue,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_async_queue_remove(queue: *mut GAsyncQueue, item: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_async_queue_remove_unlocked(queue: *mut GAsyncQueue, item: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_async_queue_push_front(queue: *mut GAsyncQueue, item: gpointer);
}
extern "C" {
    pub fn g_async_queue_push_front_unlocked(queue: *mut GAsyncQueue, item: gpointer);
}
extern "C" {
    pub fn g_async_queue_timed_pop(queue: *mut GAsyncQueue, end_time: *mut GTimeVal) -> gpointer;
}
extern "C" {
    pub fn g_async_queue_timed_pop_unlocked(
        queue: *mut GAsyncQueue,
        end_time: *mut GTimeVal,
    ) -> gpointer;
}
extern "C" {
    pub fn g_on_error_query(prg_name: *const gchar);
}
extern "C" {
    pub fn g_on_error_stack_trace(prg_name: *const gchar);
}
extern "C" {
    pub fn g_base64_encode_step(
        in_: *const guchar,
        len: gsize,
        break_lines: gboolean,
        out: *mut gchar,
        state: *mut gint,
        save: *mut gint,
    ) -> gsize;
}
extern "C" {
    pub fn g_base64_encode_close(
        break_lines: gboolean,
        out: *mut gchar,
        state: *mut gint,
        save: *mut gint,
    ) -> gsize;
}
extern "C" {
    pub fn g_base64_encode(data: *const guchar, len: gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_base64_decode_step(
        in_: *const gchar,
        len: gsize,
        out: *mut guchar,
        state: *mut gint,
        save: *mut guint,
    ) -> gsize;
}
extern "C" {
    pub fn g_base64_decode(text: *const gchar, out_len: *mut gsize) -> *mut guchar;
}
extern "C" {
    pub fn g_base64_decode_inplace(text: *mut gchar, out_len: *mut gsize) -> *mut guchar;
}
extern "C" {
    pub fn g_bit_lock(address: *mut gint, lock_bit: gint);
}
extern "C" {
    pub fn g_bit_trylock(address: *mut gint, lock_bit: gint) -> gboolean;
}
extern "C" {
    pub fn g_bit_unlock(address: *mut gint, lock_bit: gint);
}
extern "C" {
    pub fn g_pointer_bit_lock(address: *mut ::std::os::raw::c_void, lock_bit: gint);
}
extern "C" {
    pub fn g_pointer_bit_trylock(address: *mut ::std::os::raw::c_void, lock_bit: gint) -> gboolean;
}
extern "C" {
    pub fn g_pointer_bit_unlock(address: *mut ::std::os::raw::c_void, lock_bit: gint);
}
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_INVALID_URI: GBookmarkFileError = 0;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_INVALID_VALUE: GBookmarkFileError = 1;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED: GBookmarkFileError = 2;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND: GBookmarkFileError = 3;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_READ: GBookmarkFileError = 4;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_UNKNOWN_ENCODING: GBookmarkFileError = 5;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_WRITE: GBookmarkFileError = 6;
pub const GBookmarkFileError_G_BOOKMARK_FILE_ERROR_FILE_NOT_FOUND: GBookmarkFileError = 7;
#[doc = " GBookmarkFileError:"]
#[doc = " @G_BOOKMARK_FILE_ERROR_INVALID_URI: URI was ill-formed"]
#[doc = " @G_BOOKMARK_FILE_ERROR_INVALID_VALUE: a requested field was not found"]
#[doc = " @G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED: a requested application did"]
#[doc = "     not register a bookmark"]
#[doc = " @G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND: a requested URI was not found"]
#[doc = " @G_BOOKMARK_FILE_ERROR_READ: document was ill formed"]
#[doc = " @G_BOOKMARK_FILE_ERROR_UNKNOWN_ENCODING: the text being parsed was"]
#[doc = "     in an unknown encoding"]
#[doc = " @G_BOOKMARK_FILE_ERROR_WRITE: an error occurred while writing"]
#[doc = " @G_BOOKMARK_FILE_ERROR_FILE_NOT_FOUND: requested file was not found"]
#[doc = ""]
#[doc = " Error codes returned by bookmark file parsing."]
pub type GBookmarkFileError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_bookmark_file_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GBookmarkFile {
    _unused: [u8; 0],
}
#[doc = " GBookmarkFile:"]
#[doc = ""]
#[doc = " The `GBookmarkFile` structure contains only"]
#[doc = " private data and should not be directly accessed."]
pub type GBookmarkFile = _GBookmarkFile;
extern "C" {
    pub fn g_bookmark_file_new() -> *mut GBookmarkFile;
}
extern "C" {
    pub fn g_bookmark_file_free(bookmark: *mut GBookmarkFile);
}
extern "C" {
    pub fn g_bookmark_file_load_from_file(
        bookmark: *mut GBookmarkFile,
        filename: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_load_from_data(
        bookmark: *mut GBookmarkFile,
        data: *const gchar,
        length: gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_load_from_data_dirs(
        bookmark: *mut GBookmarkFile,
        file: *const gchar,
        full_path: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_to_data(
        bookmark: *mut GBookmarkFile,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_to_file(
        bookmark: *mut GBookmarkFile,
        filename: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_title(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        title: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_title(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_description(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        description: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_description(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_mime_type(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        mime_type: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_mime_type(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_groups(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        groups: *mut *const gchar,
        length: gsize,
    );
}
extern "C" {
    pub fn g_bookmark_file_add_group(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        group: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_has_group(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        group: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_groups(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_add_application(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        exec: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_has_application(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_applications(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_set_app_info(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        exec: *const gchar,
        count: gint,
        stamp: time_t,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_app_info(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        exec: *mut *mut gchar,
        count: *mut guint,
        stamp: *mut time_t,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_is_private(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        is_private: gboolean,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_is_private(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_icon(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        href: *const gchar,
        mime_type: *const gchar,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_icon(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        href: *mut *mut gchar,
        mime_type: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_set_added(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        added: time_t,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_added(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> time_t;
}
extern "C" {
    pub fn g_bookmark_file_set_modified(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        modified: time_t,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_modified(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> time_t;
}
extern "C" {
    pub fn g_bookmark_file_set_visited(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        visited: time_t,
    );
}
extern "C" {
    pub fn g_bookmark_file_get_visited(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> time_t;
}
extern "C" {
    pub fn g_bookmark_file_has_item(bookmark: *mut GBookmarkFile, uri: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_get_size(bookmark: *mut GBookmarkFile) -> gint;
}
extern "C" {
    pub fn g_bookmark_file_get_uris(
        bookmark: *mut GBookmarkFile,
        length: *mut gsize,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_bookmark_file_remove_group(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        group: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_remove_application(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        name: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_remove_item(
        bookmark: *mut GBookmarkFile,
        uri: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bookmark_file_move_item(
        bookmark: *mut GBookmarkFile,
        old_uri: *const gchar,
        new_uri: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_bytes_new(data: gconstpointer, size: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_take(data: gpointer, size: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_static(data: gconstpointer, size: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_with_free_func(
        data: gconstpointer,
        size: gsize,
        free_func: GDestroyNotify,
        user_data: gpointer,
    ) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_new_from_bytes(bytes: *mut GBytes, offset: gsize, length: gsize) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_get_data(bytes: *mut GBytes, size: *mut gsize) -> gconstpointer;
}
extern "C" {
    pub fn g_bytes_get_size(bytes: *mut GBytes) -> gsize;
}
extern "C" {
    pub fn g_bytes_ref(bytes: *mut GBytes) -> *mut GBytes;
}
extern "C" {
    pub fn g_bytes_unref(bytes: *mut GBytes);
}
extern "C" {
    pub fn g_bytes_unref_to_data(bytes: *mut GBytes, size: *mut gsize) -> gpointer;
}
extern "C" {
    pub fn g_bytes_unref_to_array(bytes: *mut GBytes) -> *mut GByteArray;
}
extern "C" {
    pub fn g_bytes_hash(bytes: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_bytes_equal(bytes1: gconstpointer, bytes2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_bytes_compare(bytes1: gconstpointer, bytes2: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_get_charset(charset: *mut *const ::std::os::raw::c_char) -> gboolean;
}
extern "C" {
    pub fn g_get_codeset() -> *mut gchar;
}
extern "C" {
    pub fn g_get_console_charset(charset: *mut *const ::std::os::raw::c_char) -> gboolean;
}
extern "C" {
    pub fn g_get_language_names() -> *const *const gchar;
}
extern "C" {
    pub fn g_get_language_names_with_category(category_name: *const gchar) -> *const *const gchar;
}
extern "C" {
    pub fn g_get_locale_variants(locale: *const gchar) -> *mut *mut gchar;
}
pub const GChecksumType_G_CHECKSUM_MD5: GChecksumType = 0;
pub const GChecksumType_G_CHECKSUM_SHA1: GChecksumType = 1;
pub const GChecksumType_G_CHECKSUM_SHA256: GChecksumType = 2;
pub const GChecksumType_G_CHECKSUM_SHA512: GChecksumType = 3;
pub const GChecksumType_G_CHECKSUM_SHA384: GChecksumType = 4;
#[doc = " GChecksumType:"]
#[doc = " @G_CHECKSUM_MD5: Use the MD5 hashing algorithm"]
#[doc = " @G_CHECKSUM_SHA1: Use the SHA-1 hashing algorithm"]
#[doc = " @G_CHECKSUM_SHA256: Use the SHA-256 hashing algorithm"]
#[doc = " @G_CHECKSUM_SHA384: Use the SHA-384 hashing algorithm (Since: 2.51)"]
#[doc = " @G_CHECKSUM_SHA512: Use the SHA-512 hashing algorithm (Since: 2.36)"]
#[doc = ""]
#[doc = " The hashing algorithm to be used by #GChecksum when performing the"]
#[doc = " digest of some data."]
#[doc = ""]
#[doc = " Note that the #GChecksumType enumeration may be extended at a later"]
#[doc = " date to include new hashing algorithm types."]
#[doc = ""]
#[doc = " Since: 2.16"]
pub type GChecksumType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GChecksum {
    _unused: [u8; 0],
}
#[doc = " GChecksum:"]
#[doc = ""]
#[doc = " An opaque structure representing a checksumming operation."]
#[doc = " To create a new GChecksum, use g_checksum_new(). To free"]
#[doc = " a GChecksum, use g_checksum_free()."]
#[doc = ""]
#[doc = " Since: 2.16"]
pub type GChecksum = _GChecksum;
extern "C" {
    pub fn g_checksum_type_get_length(checksum_type: GChecksumType) -> gssize;
}
extern "C" {
    pub fn g_checksum_new(checksum_type: GChecksumType) -> *mut GChecksum;
}
extern "C" {
    pub fn g_checksum_reset(checksum: *mut GChecksum);
}
extern "C" {
    pub fn g_checksum_copy(checksum: *const GChecksum) -> *mut GChecksum;
}
extern "C" {
    pub fn g_checksum_free(checksum: *mut GChecksum);
}
extern "C" {
    pub fn g_checksum_update(checksum: *mut GChecksum, data: *const guchar, length: gssize);
}
extern "C" {
    pub fn g_checksum_get_string(checksum: *mut GChecksum) -> *const gchar;
}
extern "C" {
    pub fn g_checksum_get_digest(
        checksum: *mut GChecksum,
        buffer: *mut guint8,
        digest_len: *mut gsize,
    );
}
extern "C" {
    pub fn g_compute_checksum_for_data(
        checksum_type: GChecksumType,
        data: *const guchar,
        length: gsize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_checksum_for_string(
        checksum_type: GChecksumType,
        str_: *const gchar,
        length: gssize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_checksum_for_bytes(
        checksum_type: GChecksumType,
        data: *mut GBytes,
    ) -> *mut gchar;
}
pub const GConvertError_G_CONVERT_ERROR_NO_CONVERSION: GConvertError = 0;
pub const GConvertError_G_CONVERT_ERROR_ILLEGAL_SEQUENCE: GConvertError = 1;
pub const GConvertError_G_CONVERT_ERROR_FAILED: GConvertError = 2;
pub const GConvertError_G_CONVERT_ERROR_PARTIAL_INPUT: GConvertError = 3;
pub const GConvertError_G_CONVERT_ERROR_BAD_URI: GConvertError = 4;
pub const GConvertError_G_CONVERT_ERROR_NOT_ABSOLUTE_PATH: GConvertError = 5;
pub const GConvertError_G_CONVERT_ERROR_NO_MEMORY: GConvertError = 6;
pub const GConvertError_G_CONVERT_ERROR_EMBEDDED_NUL: GConvertError = 7;
#[doc = " GConvertError:"]
#[doc = " @G_CONVERT_ERROR_NO_CONVERSION: Conversion between the requested character"]
#[doc = "     sets is not supported."]
#[doc = " @G_CONVERT_ERROR_ILLEGAL_SEQUENCE: Invalid byte sequence in conversion input;"]
#[doc = "    or the character sequence could not be represented in the target"]
#[doc = "    character set."]
#[doc = " @G_CONVERT_ERROR_FAILED: Conversion failed for some reason."]
#[doc = " @G_CONVERT_ERROR_PARTIAL_INPUT: Partial character sequence at end of input."]
#[doc = " @G_CONVERT_ERROR_BAD_URI: URI is invalid."]
#[doc = " @G_CONVERT_ERROR_NOT_ABSOLUTE_PATH: Pathname is not an absolute path."]
#[doc = " @G_CONVERT_ERROR_NO_MEMORY: No memory available. Since: 2.40"]
#[doc = " @G_CONVERT_ERROR_EMBEDDED_NUL: An embedded NUL character is present in"]
#[doc = "     conversion output where a NUL-terminated string is expected."]
#[doc = "     Since: 2.56"]
#[doc = ""]
#[doc = " Error codes returned by character set conversion routines."]
pub type GConvertError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_convert_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIConv {
    _unused: [u8; 0],
}
#[doc = " GIConv: (skip)"]
#[doc = ""]
#[doc = " The GIConv struct wraps an iconv() conversion descriptor. It contains"]
#[doc = " private data and should only be accessed using the following functions."]
pub type GIConv = *mut _GIConv;
extern "C" {
    pub fn g_iconv_open(to_codeset: *const gchar, from_codeset: *const gchar) -> GIConv;
}
extern "C" {
    pub fn g_iconv(
        converter: GIConv,
        inbuf: *mut *mut gchar,
        inbytes_left: *mut gsize,
        outbuf: *mut *mut gchar,
        outbytes_left: *mut gsize,
    ) -> gsize;
}
extern "C" {
    pub fn g_iconv_close(converter: GIConv) -> gint;
}
extern "C" {
    pub fn g_convert(
        str_: *const gchar,
        len: gssize,
        to_codeset: *const gchar,
        from_codeset: *const gchar,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_convert_with_iconv(
        str_: *const gchar,
        len: gssize,
        converter: GIConv,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_convert_with_fallback(
        str_: *const gchar,
        len: gssize,
        to_codeset: *const gchar,
        from_codeset: *const gchar,
        fallback: *const gchar,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_locale_to_utf8(
        opsysstring: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_locale_from_utf8(
        utf8string: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_to_utf8(
        opsysstring: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_from_utf8(
        utf8string: *const gchar,
        len: gssize,
        bytes_read: *mut gsize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_from_uri(
        uri: *const gchar,
        hostname: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_to_uri(
        filename: *const gchar,
        hostname: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_filename_display_name(filename: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_get_filename_charsets(filename_charsets: *mut *mut *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_filename_display_basename(filename: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_uri_list_extract_uris(uri_list: *const gchar) -> *mut *mut gchar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GData {
    _unused: [u8; 0],
}
pub type GData = _GData;
pub type GDataForeachFunc = ::std::option::Option<
    unsafe extern "C" fn(key_id: GQuark, data: gpointer, user_data: gpointer),
>;
extern "C" {
    pub fn g_datalist_init(datalist: *mut *mut GData);
}
extern "C" {
    pub fn g_datalist_clear(datalist: *mut *mut GData);
}
extern "C" {
    pub fn g_datalist_id_get_data(datalist: *mut *mut GData, key_id: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_datalist_id_set_data_full(
        datalist: *mut *mut GData,
        key_id: GQuark,
        data: gpointer,
        destroy_func: GDestroyNotify,
    );
}
pub type GDuplicateFunc =
    ::std::option::Option<unsafe extern "C" fn(data: gpointer, user_data: gpointer) -> gpointer>;
extern "C" {
    pub fn g_datalist_id_dup_data(
        datalist: *mut *mut GData,
        key_id: GQuark,
        dup_func: GDuplicateFunc,
        user_data: gpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_datalist_id_replace_data(
        datalist: *mut *mut GData,
        key_id: GQuark,
        oldval: gpointer,
        newval: gpointer,
        destroy: GDestroyNotify,
        old_destroy: *mut GDestroyNotify,
    ) -> gboolean;
}
extern "C" {
    pub fn g_datalist_id_remove_no_notify(datalist: *mut *mut GData, key_id: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_datalist_foreach(
        datalist: *mut *mut GData,
        func: GDataForeachFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_datalist_set_flags(datalist: *mut *mut GData, flags: guint);
}
extern "C" {
    pub fn g_datalist_unset_flags(datalist: *mut *mut GData, flags: guint);
}
extern "C" {
    pub fn g_datalist_get_flags(datalist: *mut *mut GData) -> guint;
}
extern "C" {
    pub fn g_dataset_destroy(dataset_location: gconstpointer);
}
extern "C" {
    pub fn g_dataset_id_get_data(dataset_location: gconstpointer, key_id: GQuark) -> gpointer;
}
extern "C" {
    pub fn g_datalist_get_data(datalist: *mut *mut GData, key: *const gchar) -> gpointer;
}
extern "C" {
    pub fn g_dataset_id_set_data_full(
        dataset_location: gconstpointer,
        key_id: GQuark,
        data: gpointer,
        destroy_func: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_dataset_id_remove_no_notify(
        dataset_location: gconstpointer,
        key_id: GQuark,
    ) -> gpointer;
}
extern "C" {
    pub fn g_dataset_foreach(
        dataset_location: gconstpointer,
        func: GDataForeachFunc,
        user_data: gpointer,
    );
}
pub type GTime = gint32;
pub type GDateYear = guint16;
pub type GDateDay = guint8;
pub type GDate = _GDate;
pub const GDateDMY_G_DATE_DAY: GDateDMY = 0;
pub const GDateDMY_G_DATE_MONTH: GDateDMY = 1;
pub const GDateDMY_G_DATE_YEAR: GDateDMY = 2;
pub type GDateDMY = ::std::os::raw::c_uint;
pub const GDateWeekday_G_DATE_BAD_WEEKDAY: GDateWeekday = 0;
pub const GDateWeekday_G_DATE_MONDAY: GDateWeekday = 1;
pub const GDateWeekday_G_DATE_TUESDAY: GDateWeekday = 2;
pub const GDateWeekday_G_DATE_WEDNESDAY: GDateWeekday = 3;
pub const GDateWeekday_G_DATE_THURSDAY: GDateWeekday = 4;
pub const GDateWeekday_G_DATE_FRIDAY: GDateWeekday = 5;
pub const GDateWeekday_G_DATE_SATURDAY: GDateWeekday = 6;
pub const GDateWeekday_G_DATE_SUNDAY: GDateWeekday = 7;
pub type GDateWeekday = ::std::os::raw::c_uint;
pub const GDateMonth_G_DATE_BAD_MONTH: GDateMonth = 0;
pub const GDateMonth_G_DATE_JANUARY: GDateMonth = 1;
pub const GDateMonth_G_DATE_FEBRUARY: GDateMonth = 2;
pub const GDateMonth_G_DATE_MARCH: GDateMonth = 3;
pub const GDateMonth_G_DATE_APRIL: GDateMonth = 4;
pub const GDateMonth_G_DATE_MAY: GDateMonth = 5;
pub const GDateMonth_G_DATE_JUNE: GDateMonth = 6;
pub const GDateMonth_G_DATE_JULY: GDateMonth = 7;
pub const GDateMonth_G_DATE_AUGUST: GDateMonth = 8;
pub const GDateMonth_G_DATE_SEPTEMBER: GDateMonth = 9;
pub const GDateMonth_G_DATE_OCTOBER: GDateMonth = 10;
pub const GDateMonth_G_DATE_NOVEMBER: GDateMonth = 11;
pub const GDateMonth_G_DATE_DECEMBER: GDateMonth = 12;
pub type GDateMonth = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _GDate {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
impl _GDate {
    #[inline]
    pub fn julian_days(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_julian_days(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn julian(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_julian(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dmy(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(33usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dmy(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(33usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn day(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(34usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_day(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(34usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub fn month(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_month(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn year(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(44usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_year(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(44usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        julian_days: guint,
        julian: guint,
        dmy: guint,
        day: guint,
        month: guint,
        year: guint,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 32u8, {
            let julian_days: u32 = unsafe { ::std::mem::transmute(julian_days) };
            julian_days as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let julian: u32 = unsafe { ::std::mem::transmute(julian) };
            julian as u64
        });
        __bindgen_bitfield_unit.set(33usize, 1u8, {
            let dmy: u32 = unsafe { ::std::mem::transmute(dmy) };
            dmy as u64
        });
        __bindgen_bitfield_unit.set(34usize, 6u8, {
            let day: u32 = unsafe { ::std::mem::transmute(day) };
            day as u64
        });
        __bindgen_bitfield_unit.set(40usize, 4u8, {
            let month: u32 = unsafe { ::std::mem::transmute(month) };
            month as u64
        });
        __bindgen_bitfield_unit.set(44usize, 16u8, {
            let year: u32 = unsafe { ::std::mem::transmute(year) };
            year as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn g_date_new() -> *mut GDate;
}
extern "C" {
    pub fn g_date_new_dmy(day: GDateDay, month: GDateMonth, year: GDateYear) -> *mut GDate;
}
extern "C" {
    pub fn g_date_new_julian(julian_day: guint32) -> *mut GDate;
}
extern "C" {
    pub fn g_date_free(date: *mut GDate);
}
extern "C" {
    pub fn g_date_copy(date: *const GDate) -> *mut GDate;
}
extern "C" {
    pub fn g_date_valid(date: *const GDate) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_day(day: GDateDay) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_month(month: GDateMonth) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_year(year: GDateYear) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_weekday(weekday: GDateWeekday) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_julian(julian_date: guint32) -> gboolean;
}
extern "C" {
    pub fn g_date_valid_dmy(day: GDateDay, month: GDateMonth, year: GDateYear) -> gboolean;
}
extern "C" {
    pub fn g_date_get_weekday(date: *const GDate) -> GDateWeekday;
}
extern "C" {
    pub fn g_date_get_month(date: *const GDate) -> GDateMonth;
}
extern "C" {
    pub fn g_date_get_year(date: *const GDate) -> GDateYear;
}
extern "C" {
    pub fn g_date_get_day(date: *const GDate) -> GDateDay;
}
extern "C" {
    pub fn g_date_get_julian(date: *const GDate) -> guint32;
}
extern "C" {
    pub fn g_date_get_day_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_get_monday_week_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_get_sunday_week_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_get_iso8601_week_of_year(date: *const GDate) -> guint;
}
extern "C" {
    pub fn g_date_clear(date: *mut GDate, n_dates: guint);
}
extern "C" {
    pub fn g_date_set_parse(date: *mut GDate, str_: *const gchar);
}
extern "C" {
    pub fn g_date_set_time_t(date: *mut GDate, timet: time_t);
}
extern "C" {
    pub fn g_date_set_time_val(date: *mut GDate, timeval: *mut GTimeVal);
}
extern "C" {
    pub fn g_date_set_time(date: *mut GDate, time_: GTime);
}
extern "C" {
    pub fn g_date_set_month(date: *mut GDate, month: GDateMonth);
}
extern "C" {
    pub fn g_date_set_day(date: *mut GDate, day: GDateDay);
}
extern "C" {
    pub fn g_date_set_year(date: *mut GDate, year: GDateYear);
}
extern "C" {
    pub fn g_date_set_dmy(date: *mut GDate, day: GDateDay, month: GDateMonth, y: GDateYear);
}
extern "C" {
    pub fn g_date_set_julian(date: *mut GDate, julian_date: guint32);
}
extern "C" {
    pub fn g_date_is_first_of_month(date: *const GDate) -> gboolean;
}
extern "C" {
    pub fn g_date_is_last_of_month(date: *const GDate) -> gboolean;
}
extern "C" {
    pub fn g_date_add_days(date: *mut GDate, n_days: guint);
}
extern "C" {
    pub fn g_date_subtract_days(date: *mut GDate, n_days: guint);
}
extern "C" {
    pub fn g_date_add_months(date: *mut GDate, n_months: guint);
}
extern "C" {
    pub fn g_date_subtract_months(date: *mut GDate, n_months: guint);
}
extern "C" {
    pub fn g_date_add_years(date: *mut GDate, n_years: guint);
}
extern "C" {
    pub fn g_date_subtract_years(date: *mut GDate, n_years: guint);
}
extern "C" {
    pub fn g_date_is_leap_year(year: GDateYear) -> gboolean;
}
extern "C" {
    pub fn g_date_get_days_in_month(month: GDateMonth, year: GDateYear) -> guint8;
}
extern "C" {
    pub fn g_date_get_monday_weeks_in_year(year: GDateYear) -> guint8;
}
extern "C" {
    pub fn g_date_get_sunday_weeks_in_year(year: GDateYear) -> guint8;
}
extern "C" {
    pub fn g_date_days_between(date1: *const GDate, date2: *const GDate) -> gint;
}
extern "C" {
    pub fn g_date_compare(lhs: *const GDate, rhs: *const GDate) -> gint;
}
extern "C" {
    pub fn g_date_to_struct_tm(date: *const GDate, tm: *mut tm);
}
extern "C" {
    pub fn g_date_clamp(date: *mut GDate, min_date: *const GDate, max_date: *const GDate);
}
extern "C" {
    pub fn g_date_order(date1: *mut GDate, date2: *mut GDate);
}
extern "C" {
    pub fn g_date_strftime(
        s: *mut gchar,
        slen: gsize,
        format: *const gchar,
        date: *const GDate,
    ) -> gsize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTimeZone {
    _unused: [u8; 0],
}
pub type GTimeZone = _GTimeZone;
pub const GTimeType_G_TIME_TYPE_STANDARD: GTimeType = 0;
pub const GTimeType_G_TIME_TYPE_DAYLIGHT: GTimeType = 1;
pub const GTimeType_G_TIME_TYPE_UNIVERSAL: GTimeType = 2;
#[doc = " GTimeType:"]
#[doc = " @G_TIME_TYPE_STANDARD: the time is in local standard time"]
#[doc = " @G_TIME_TYPE_DAYLIGHT: the time is in local daylight time"]
#[doc = " @G_TIME_TYPE_UNIVERSAL: the time is in UTC"]
#[doc = ""]
#[doc = " Disambiguates a given time in two ways."]
#[doc = ""]
#[doc = " First, specifies if the given time is in universal or local time."]
#[doc = ""]
#[doc = " Second, if the time is in local time, specifies if it is local"]
#[doc = " standard time or local daylight time.  This is important for the case"]
#[doc = " where the same local time occurs twice (during daylight savings time"]
#[doc = " transitions, for example)."]
pub type GTimeType = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_time_zone_new(identifier: *const gchar) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_new_utc() -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_new_local() -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_new_offset(seconds: gint32) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_ref(tz: *mut GTimeZone) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_time_zone_unref(tz: *mut GTimeZone);
}
extern "C" {
    pub fn g_time_zone_find_interval(tz: *mut GTimeZone, type_: GTimeType, time_: gint64) -> gint;
}
extern "C" {
    pub fn g_time_zone_adjust_time(
        tz: *mut GTimeZone,
        type_: GTimeType,
        time_: *mut gint64,
    ) -> gint;
}
extern "C" {
    pub fn g_time_zone_get_abbreviation(tz: *mut GTimeZone, interval: gint) -> *const gchar;
}
extern "C" {
    pub fn g_time_zone_get_offset(tz: *mut GTimeZone, interval: gint) -> gint32;
}
extern "C" {
    pub fn g_time_zone_is_dst(tz: *mut GTimeZone, interval: gint) -> gboolean;
}
extern "C" {
    pub fn g_time_zone_get_identifier(tz: *mut GTimeZone) -> *const gchar;
}
#[doc = " GTimeSpan:"]
#[doc = ""]
#[doc = " A value representing an interval of time, in microseconds."]
#[doc = ""]
#[doc = " Since: 2.26"]
pub type GTimeSpan = gint64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDateTime {
    _unused: [u8; 0],
}
#[doc = " GDateTime:"]
#[doc = ""]
#[doc = " `GDateTime` is an opaque structure whose members"]
#[doc = " cannot be accessed directly."]
#[doc = ""]
#[doc = " Since: 2.26"]
pub type GDateTime = _GDateTime;
extern "C" {
    pub fn g_date_time_unref(datetime: *mut GDateTime);
}
extern "C" {
    pub fn g_date_time_ref(datetime: *mut GDateTime) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_now(tz: *mut GTimeZone) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_now_local() -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_now_utc() -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_unix_local(t: gint64) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_unix_utc(t: gint64) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_timeval_local(tv: *const GTimeVal) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_timeval_utc(tv: *const GTimeVal) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_from_iso8601(
        text: *const gchar,
        default_tz: *mut GTimeZone,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new(
        tz: *mut GTimeZone,
        year: gint,
        month: gint,
        day: gint,
        hour: gint,
        minute: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_local(
        year: gint,
        month: gint,
        day: gint,
        hour: gint,
        minute: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_new_utc(
        year: gint,
        month: gint,
        day: gint,
        hour: gint,
        minute: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add(datetime: *mut GDateTime, timespan: GTimeSpan) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_years(datetime: *mut GDateTime, years: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_months(datetime: *mut GDateTime, months: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_weeks(datetime: *mut GDateTime, weeks: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_days(datetime: *mut GDateTime, days: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_hours(datetime: *mut GDateTime, hours: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_minutes(datetime: *mut GDateTime, minutes: gint) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_seconds(datetime: *mut GDateTime, seconds: gdouble) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_add_full(
        datetime: *mut GDateTime,
        years: gint,
        months: gint,
        days: gint,
        hours: gint,
        minutes: gint,
        seconds: gdouble,
    ) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_compare(dt1: gconstpointer, dt2: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_date_time_difference(end: *mut GDateTime, begin: *mut GDateTime) -> GTimeSpan;
}
extern "C" {
    pub fn g_date_time_hash(datetime: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_date_time_equal(dt1: gconstpointer, dt2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_date_time_get_ymd(
        datetime: *mut GDateTime,
        year: *mut gint,
        month: *mut gint,
        day: *mut gint,
    );
}
extern "C" {
    pub fn g_date_time_get_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_month(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_day_of_month(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_week_numbering_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_week_of_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_day_of_week(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_day_of_year(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_hour(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_minute(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_second(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_microsecond(datetime: *mut GDateTime) -> gint;
}
extern "C" {
    pub fn g_date_time_get_seconds(datetime: *mut GDateTime) -> gdouble;
}
extern "C" {
    pub fn g_date_time_to_unix(datetime: *mut GDateTime) -> gint64;
}
extern "C" {
    pub fn g_date_time_to_timeval(datetime: *mut GDateTime, tv: *mut GTimeVal) -> gboolean;
}
extern "C" {
    pub fn g_date_time_get_utc_offset(datetime: *mut GDateTime) -> GTimeSpan;
}
extern "C" {
    pub fn g_date_time_get_timezone(datetime: *mut GDateTime) -> *mut GTimeZone;
}
extern "C" {
    pub fn g_date_time_get_timezone_abbreviation(datetime: *mut GDateTime) -> *const gchar;
}
extern "C" {
    pub fn g_date_time_is_daylight_savings(datetime: *mut GDateTime) -> gboolean;
}
extern "C" {
    pub fn g_date_time_to_timezone(datetime: *mut GDateTime, tz: *mut GTimeZone) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_to_local(datetime: *mut GDateTime) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_to_utc(datetime: *mut GDateTime) -> *mut GDateTime;
}
extern "C" {
    pub fn g_date_time_format(datetime: *mut GDateTime, format: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_date_time_format_iso8601(datetime: *mut GDateTime) -> *mut gchar;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct dirent {
    pub d_ino: __ino_t,
    pub d_off: __off_t,
    pub d_reclen: ::std::os::raw::c_ushort,
    pub d_type: ::std::os::raw::c_uchar,
    pub d_name: [::std::os::raw::c_char; 256usize],
}
pub const DT_UNKNOWN: ::std::os::raw::c_uint = 0;
pub const DT_FIFO: ::std::os::raw::c_uint = 1;
pub const DT_CHR: ::std::os::raw::c_uint = 2;
pub const DT_DIR: ::std::os::raw::c_uint = 4;
pub const DT_BLK: ::std::os::raw::c_uint = 6;
pub const DT_REG: ::std::os::raw::c_uint = 8;
pub const DT_LNK: ::std::os::raw::c_uint = 10;
pub const DT_SOCK: ::std::os::raw::c_uint = 12;
pub const DT_WHT: ::std::os::raw::c_uint = 14;
pub type _bindgen_ty_22 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
extern "C" {
    pub fn opendir(__name: *const ::std::os::raw::c_char) -> *mut DIR;
}
extern "C" {
    pub fn fdopendir(__fd: ::std::os::raw::c_int) -> *mut DIR;
}
extern "C" {
    pub fn closedir(__dirp: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readdir(__dirp: *mut DIR) -> *mut dirent;
}
extern "C" {
    pub fn readdir_r(
        __dirp: *mut DIR,
        __entry: *mut dirent,
        __result: *mut *mut dirent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewinddir(__dirp: *mut DIR);
}
extern "C" {
    pub fn seekdir(__dirp: *mut DIR, __pos: ::std::os::raw::c_long);
}
extern "C" {
    pub fn telldir(__dirp: *mut DIR) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn dirfd(__dirp: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scandir(
        __dir: *const ::std::os::raw::c_char,
        __namelist: *mut *mut *mut dirent,
        __selector: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
        >,
        __cmp: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *const dirent,
                arg2: *mut *const dirent,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alphasort(__e1: *mut *const dirent, __e2: *mut *const dirent) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdirentries(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __nbytes: size_t,
        __basep: *mut __off_t,
    ) -> __ssize_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GDir {
    _unused: [u8; 0],
}
pub type GDir = _GDir;
extern "C" {
    pub fn g_dir_open(path: *const gchar, flags: guint, error: *mut *mut GError) -> *mut GDir;
}
extern "C" {
    pub fn g_dir_read_name(dir: *mut GDir) -> *const gchar;
}
extern "C" {
    pub fn g_dir_rewind(dir: *mut GDir);
}
extern "C" {
    pub fn g_dir_close(dir: *mut GDir);
}
extern "C" {
    pub fn g_getenv(variable: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_setenv(variable: *const gchar, value: *const gchar, overwrite: gboolean) -> gboolean;
}
extern "C" {
    pub fn g_unsetenv(variable: *const gchar);
}
extern "C" {
    pub fn g_listenv() -> *mut *mut gchar;
}
extern "C" {
    pub fn g_get_environ() -> *mut *mut gchar;
}
extern "C" {
    pub fn g_environ_getenv(envp: *mut *mut gchar, variable: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_environ_setenv(
        envp: *mut *mut gchar,
        variable: *const gchar,
        value: *const gchar,
        overwrite: gboolean,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_environ_unsetenv(envp: *mut *mut gchar, variable: *const gchar) -> *mut *mut gchar;
}
pub const GFileError_G_FILE_ERROR_EXIST: GFileError = 0;
pub const GFileError_G_FILE_ERROR_ISDIR: GFileError = 1;
pub const GFileError_G_FILE_ERROR_ACCES: GFileError = 2;
pub const GFileError_G_FILE_ERROR_NAMETOOLONG: GFileError = 3;
pub const GFileError_G_FILE_ERROR_NOENT: GFileError = 4;
pub const GFileError_G_FILE_ERROR_NOTDIR: GFileError = 5;
pub const GFileError_G_FILE_ERROR_NXIO: GFileError = 6;
pub const GFileError_G_FILE_ERROR_NODEV: GFileError = 7;
pub const GFileError_G_FILE_ERROR_ROFS: GFileError = 8;
pub const GFileError_G_FILE_ERROR_TXTBSY: GFileError = 9;
pub const GFileError_G_FILE_ERROR_FAULT: GFileError = 10;
pub const GFileError_G_FILE_ERROR_LOOP: GFileError = 11;
pub const GFileError_G_FILE_ERROR_NOSPC: GFileError = 12;
pub const GFileError_G_FILE_ERROR_NOMEM: GFileError = 13;
pub const GFileError_G_FILE_ERROR_MFILE: GFileError = 14;
pub const GFileError_G_FILE_ERROR_NFILE: GFileError = 15;
pub const GFileError_G_FILE_ERROR_BADF: GFileError = 16;
pub const GFileError_G_FILE_ERROR_INVAL: GFileError = 17;
pub const GFileError_G_FILE_ERROR_PIPE: GFileError = 18;
pub const GFileError_G_FILE_ERROR_AGAIN: GFileError = 19;
pub const GFileError_G_FILE_ERROR_INTR: GFileError = 20;
pub const GFileError_G_FILE_ERROR_IO: GFileError = 21;
pub const GFileError_G_FILE_ERROR_PERM: GFileError = 22;
pub const GFileError_G_FILE_ERROR_NOSYS: GFileError = 23;
pub const GFileError_G_FILE_ERROR_FAILED: GFileError = 24;
pub type GFileError = ::std::os::raw::c_uint;
pub const GFileTest_G_FILE_TEST_IS_REGULAR: GFileTest = 1;
pub const GFileTest_G_FILE_TEST_IS_SYMLINK: GFileTest = 2;
pub const GFileTest_G_FILE_TEST_IS_DIR: GFileTest = 4;
pub const GFileTest_G_FILE_TEST_IS_EXECUTABLE: GFileTest = 8;
pub const GFileTest_G_FILE_TEST_EXISTS: GFileTest = 16;
pub type GFileTest = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_file_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_file_error_from_errno(err_no: gint) -> GFileError;
}
extern "C" {
    pub fn g_file_test(filename: *const gchar, test: GFileTest) -> gboolean;
}
extern "C" {
    pub fn g_file_get_contents(
        filename: *const gchar,
        contents: *mut *mut gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_file_set_contents(
        filename: *const gchar,
        contents: *const gchar,
        length: gssize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_file_read_link(filename: *const gchar, error: *mut *mut GError) -> *mut gchar;
}
extern "C" {
    pub fn g_mkdtemp(tmpl: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_mkdtemp_full(tmpl: *mut gchar, mode: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_mkstemp(tmpl: *mut gchar) -> gint;
}
extern "C" {
    pub fn g_mkstemp_full(tmpl: *mut gchar, flags: gint, mode: gint) -> gint;
}
extern "C" {
    pub fn g_file_open_tmp(
        tmpl: *const gchar,
        name_used: *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gint;
}
extern "C" {
    pub fn g_dir_make_tmp(tmpl: *const gchar, error: *mut *mut GError) -> *mut gchar;
}
extern "C" {
    pub fn g_build_path(separator: *const gchar, first_element: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_build_pathv(separator: *const gchar, args: *mut *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_build_filename(first_element: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_build_filenamev(args: *mut *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_build_filename_valist(first_element: *const gchar, args: *mut va_list) -> *mut gchar;
}
extern "C" {
    pub fn g_mkdir_with_parents(pathname: *const gchar, mode: gint) -> gint;
}
extern "C" {
    pub fn g_path_is_absolute(file_name: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_path_skip_root(file_name: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_basename(file_name: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_get_current_dir() -> *mut gchar;
}
extern "C" {
    pub fn g_path_get_basename(file_name: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_path_get_dirname(file_name: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_canonicalize_filename(filename: *const gchar, relative_to: *const gchar)
        -> *mut gchar;
}
extern "C" {
    pub fn g_strip_context(msgid: *const gchar, msgval: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_dgettext(domain: *const gchar, msgid: *const gchar) -> *const gchar;
}
extern "C" {
    pub fn g_dcgettext(domain: *const gchar, msgid: *const gchar, category: gint) -> *const gchar;
}
extern "C" {
    pub fn g_dngettext(
        domain: *const gchar,
        msgid: *const gchar,
        msgid_plural: *const gchar,
        n: gulong,
    ) -> *const gchar;
}
extern "C" {
    pub fn g_dpgettext(
        domain: *const gchar,
        msgctxtid: *const gchar,
        msgidoffset: gsize,
    ) -> *const gchar;
}
extern "C" {
    pub fn g_dpgettext2(
        domain: *const gchar,
        context: *const gchar,
        msgid: *const gchar,
    ) -> *const gchar;
}
#[doc = " GMemVTable:"]
#[doc = " @malloc: function to use for allocating memory."]
#[doc = " @realloc: function to use for reallocating memory."]
#[doc = " @free: function to use to free memory."]
#[doc = " @calloc: function to use for allocating zero-filled memory."]
#[doc = " @try_malloc: function to use for allocating memory without a default error handler."]
#[doc = " @try_realloc: function to use for reallocating memory without a default error handler."]
#[doc = ""]
#[doc = " A set of functions used to perform memory allocation. The same #GMemVTable must"]
#[doc = " be used for all allocations in the same program; a call to g_mem_set_vtable(),"]
#[doc = " if it exists, should be prior to any use of GLib."]
#[doc = ""]
#[doc = " This functions related to this has been deprecated in 2.46, and no longer work."]
pub type GMemVTable = _GMemVTable;
extern "C" {
    pub fn g_free(mem: gpointer);
}
extern "C" {
    pub fn g_clear_pointer(pp: *mut gpointer, destroy: GDestroyNotify);
}
extern "C" {
    pub fn g_malloc(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_malloc0(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_realloc(mem: gpointer, n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc0(n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_realloc(mem: gpointer, n_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_malloc_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_malloc0_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_realloc_n(mem: gpointer, n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_malloc0_n(n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
extern "C" {
    pub fn g_try_realloc_n(mem: gpointer, n_blocks: gsize, n_block_bytes: gsize) -> gpointer;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMemVTable {
    pub malloc: ::std::option::Option<unsafe extern "C" fn(n_bytes: gsize) -> gpointer>,
    pub realloc:
        ::std::option::Option<unsafe extern "C" fn(mem: gpointer, n_bytes: gsize) -> gpointer>,
    pub free: ::std::option::Option<unsafe extern "C" fn(mem: gpointer)>,
    pub calloc: ::std::option::Option<
        unsafe extern "C" fn(n_blocks: gsize, n_block_bytes: gsize) -> gpointer,
    >,
    pub try_malloc: ::std::option::Option<unsafe extern "C" fn(n_bytes: gsize) -> gpointer>,
    pub try_realloc:
        ::std::option::Option<unsafe extern "C" fn(mem: gpointer, n_bytes: gsize) -> gpointer>,
}
extern "C" {
    pub fn g_mem_set_vtable(vtable: *mut GMemVTable);
}
extern "C" {
    pub fn g_mem_is_system_malloc() -> gboolean;
}
extern "C" {
    pub static mut g_mem_gc_friendly: gboolean;
}
extern "C" {
    pub static mut glib_mem_profiler_table: *mut GMemVTable;
}
extern "C" {
    pub fn g_mem_profile();
}
pub type GNode = _GNode;
pub const GTraverseFlags_G_TRAVERSE_LEAVES: GTraverseFlags = 1;
pub const GTraverseFlags_G_TRAVERSE_NON_LEAVES: GTraverseFlags = 2;
pub const GTraverseFlags_G_TRAVERSE_ALL: GTraverseFlags = 3;
pub const GTraverseFlags_G_TRAVERSE_MASK: GTraverseFlags = 3;
pub const GTraverseFlags_G_TRAVERSE_LEAFS: GTraverseFlags = 1;
pub const GTraverseFlags_G_TRAVERSE_NON_LEAFS: GTraverseFlags = 2;
pub type GTraverseFlags = ::std::os::raw::c_uint;
pub const GTraverseType_G_IN_ORDER: GTraverseType = 0;
pub const GTraverseType_G_PRE_ORDER: GTraverseType = 1;
pub const GTraverseType_G_POST_ORDER: GTraverseType = 2;
pub const GTraverseType_G_LEVEL_ORDER: GTraverseType = 3;
pub type GTraverseType = ::std::os::raw::c_uint;
pub type GNodeTraverseFunc =
    ::std::option::Option<unsafe extern "C" fn(node: *mut GNode, data: gpointer) -> gboolean>;
pub type GNodeForeachFunc =
    ::std::option::Option<unsafe extern "C" fn(node: *mut GNode, data: gpointer)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GNode {
    pub data: gpointer,
    pub next: *mut GNode,
    pub prev: *mut GNode,
    pub parent: *mut GNode,
    pub children: *mut GNode,
}
extern "C" {
    pub fn g_node_new(data: gpointer) -> *mut GNode;
}
extern "C" {
    pub fn g_node_destroy(root: *mut GNode);
}
extern "C" {
    pub fn g_node_unlink(node: *mut GNode);
}
extern "C" {
    pub fn g_node_copy_deep(node: *mut GNode, copy_func: GCopyFunc, data: gpointer) -> *mut GNode;
}
extern "C" {
    pub fn g_node_copy(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_insert(parent: *mut GNode, position: gint, node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_insert_before(
        parent: *mut GNode,
        sibling: *mut GNode,
        node: *mut GNode,
    ) -> *mut GNode;
}
extern "C" {
    pub fn g_node_insert_after(
        parent: *mut GNode,
        sibling: *mut GNode,
        node: *mut GNode,
    ) -> *mut GNode;
}
extern "C" {
    pub fn g_node_prepend(parent: *mut GNode, node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_n_nodes(root: *mut GNode, flags: GTraverseFlags) -> guint;
}
extern "C" {
    pub fn g_node_get_root(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_is_ancestor(node: *mut GNode, descendant: *mut GNode) -> gboolean;
}
extern "C" {
    pub fn g_node_depth(node: *mut GNode) -> guint;
}
extern "C" {
    pub fn g_node_find(
        root: *mut GNode,
        order: GTraverseType,
        flags: GTraverseFlags,
        data: gpointer,
    ) -> *mut GNode;
}
extern "C" {
    pub fn g_node_traverse(
        root: *mut GNode,
        order: GTraverseType,
        flags: GTraverseFlags,
        max_depth: gint,
        func: GNodeTraverseFunc,
        data: gpointer,
    );
}
extern "C" {
    pub fn g_node_max_height(root: *mut GNode) -> guint;
}
extern "C" {
    pub fn g_node_children_foreach(
        node: *mut GNode,
        flags: GTraverseFlags,
        func: GNodeForeachFunc,
        data: gpointer,
    );
}
extern "C" {
    pub fn g_node_reverse_children(node: *mut GNode);
}
extern "C" {
    pub fn g_node_n_children(node: *mut GNode) -> guint;
}
extern "C" {
    pub fn g_node_nth_child(node: *mut GNode, n: guint) -> *mut GNode;
}
extern "C" {
    pub fn g_node_last_child(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_find_child(node: *mut GNode, flags: GTraverseFlags, data: gpointer)
        -> *mut GNode;
}
extern "C" {
    pub fn g_node_child_position(node: *mut GNode, child: *mut GNode) -> gint;
}
extern "C" {
    pub fn g_node_child_index(node: *mut GNode, data: gpointer) -> gint;
}
extern "C" {
    pub fn g_node_first_sibling(node: *mut GNode) -> *mut GNode;
}
extern "C" {
    pub fn g_node_last_sibling(node: *mut GNode) -> *mut GNode;
}
pub type GList = _GList;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GList {
    pub data: gpointer,
    pub next: *mut GList,
    pub prev: *mut GList,
}
extern "C" {
    pub fn g_list_alloc() -> *mut GList;
}
extern "C" {
    pub fn g_list_free(list: *mut GList);
}
extern "C" {
    pub fn g_list_free_1(list: *mut GList);
}
extern "C" {
    pub fn g_list_free_full(list: *mut GList, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_list_append(list: *mut GList, data: gpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_prepend(list: *mut GList, data: gpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert(list: *mut GList, data: gpointer, position: gint) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_sorted(list: *mut GList, data: gpointer, func: GCompareFunc)
        -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_sorted_with_data(
        list: *mut GList,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_before(
        list: *mut GList,
        sibling: *mut GList,
        data: gpointer,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_insert_before_link(
        list: *mut GList,
        sibling: *mut GList,
        link_: *mut GList,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_concat(list1: *mut GList, list2: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_remove(list: *mut GList, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_remove_all(list: *mut GList, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_remove_link(list: *mut GList, llink: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_delete_link(list: *mut GList, link_: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_reverse(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_copy(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_copy_deep(list: *mut GList, func: GCopyFunc, user_data: gpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_nth(list: *mut GList, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_list_nth_prev(list: *mut GList, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_list_find(list: *mut GList, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_list_find_custom(
        list: *mut GList,
        data: gconstpointer,
        func: GCompareFunc,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_position(list: *mut GList, llink: *mut GList) -> gint;
}
extern "C" {
    pub fn g_list_index(list: *mut GList, data: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_list_last(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_first(list: *mut GList) -> *mut GList;
}
extern "C" {
    pub fn g_list_length(list: *mut GList) -> guint;
}
extern "C" {
    pub fn g_list_foreach(list: *mut GList, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_list_sort(list: *mut GList, compare_func: GCompareFunc) -> *mut GList;
}
extern "C" {
    pub fn g_list_sort_with_data(
        list: *mut GList,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_list_nth_data(list: *mut GList, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_clear_list(list_ptr: *mut *mut GList, destroy: GDestroyNotify);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHashTable {
    _unused: [u8; 0],
}
pub type GHashTable = _GHashTable;
pub type GHRFunc = ::std::option::Option<
    unsafe extern "C" fn(key: gpointer, value: gpointer, user_data: gpointer) -> gboolean,
>;
pub type GHashTableIter = _GHashTableIter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHashTableIter {
    pub dummy1: gpointer,
    pub dummy2: gpointer,
    pub dummy3: gpointer,
    pub dummy4: ::std::os::raw::c_int,
    pub dummy5: gboolean,
    pub dummy6: gpointer,
}
extern "C" {
    pub fn g_hash_table_new(hash_func: GHashFunc, key_equal_func: GEqualFunc) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_new_full(
        hash_func: GHashFunc,
        key_equal_func: GEqualFunc,
        key_destroy_func: GDestroyNotify,
        value_destroy_func: GDestroyNotify,
    ) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_destroy(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_insert(
        hash_table: *mut GHashTable,
        key: gpointer,
        value: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_replace(
        hash_table: *mut GHashTable,
        key: gpointer,
        value: gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_add(hash_table: *mut GHashTable, key: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_remove(hash_table: *mut GHashTable, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_remove_all(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_steal(hash_table: *mut GHashTable, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_steal_extended(
        hash_table: *mut GHashTable,
        lookup_key: gconstpointer,
        stolen_key: *mut gpointer,
        stolen_value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_steal_all(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_lookup(hash_table: *mut GHashTable, key: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_hash_table_contains(hash_table: *mut GHashTable, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_lookup_extended(
        hash_table: *mut GHashTable,
        lookup_key: gconstpointer,
        orig_key: *mut gpointer,
        value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_foreach(hash_table: *mut GHashTable, func: GHFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_hash_table_find(
        hash_table: *mut GHashTable,
        predicate: GHRFunc,
        user_data: gpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_hash_table_foreach_remove(
        hash_table: *mut GHashTable,
        func: GHRFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_hash_table_foreach_steal(
        hash_table: *mut GHashTable,
        func: GHRFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_hash_table_size(hash_table: *mut GHashTable) -> guint;
}
extern "C" {
    pub fn g_hash_table_get_keys(hash_table: *mut GHashTable) -> *mut GList;
}
extern "C" {
    pub fn g_hash_table_get_values(hash_table: *mut GHashTable) -> *mut GList;
}
extern "C" {
    pub fn g_hash_table_get_keys_as_array(
        hash_table: *mut GHashTable,
        length: *mut guint,
    ) -> *mut gpointer;
}
extern "C" {
    pub fn g_hash_table_iter_init(iter: *mut GHashTableIter, hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_hash_table_iter_next(
        iter: *mut GHashTableIter,
        key: *mut gpointer,
        value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_hash_table_iter_get_hash_table(iter: *mut GHashTableIter) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_iter_remove(iter: *mut GHashTableIter);
}
extern "C" {
    pub fn g_hash_table_iter_replace(iter: *mut GHashTableIter, value: gpointer);
}
extern "C" {
    pub fn g_hash_table_iter_steal(iter: *mut GHashTableIter);
}
extern "C" {
    pub fn g_hash_table_ref(hash_table: *mut GHashTable) -> *mut GHashTable;
}
extern "C" {
    pub fn g_hash_table_unref(hash_table: *mut GHashTable);
}
extern "C" {
    pub fn g_str_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_str_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_int_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_int_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_int64_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_int64_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_double_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_double_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_direct_hash(v: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_direct_equal(v1: gconstpointer, v2: gconstpointer) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHmac {
    _unused: [u8; 0],
}
#[doc = " GHmac:"]
#[doc = ""]
#[doc = " An opaque structure representing a HMAC operation."]
#[doc = " To create a new GHmac, use g_hmac_new(). To free"]
#[doc = " a GHmac, use g_hmac_unref()."]
#[doc = ""]
#[doc = " Since: 2.30"]
pub type GHmac = _GHmac;
extern "C" {
    pub fn g_hmac_new(digest_type: GChecksumType, key: *const guchar, key_len: gsize)
        -> *mut GHmac;
}
extern "C" {
    pub fn g_hmac_copy(hmac: *const GHmac) -> *mut GHmac;
}
extern "C" {
    pub fn g_hmac_ref(hmac: *mut GHmac) -> *mut GHmac;
}
extern "C" {
    pub fn g_hmac_unref(hmac: *mut GHmac);
}
extern "C" {
    pub fn g_hmac_update(hmac: *mut GHmac, data: *const guchar, length: gssize);
}
extern "C" {
    pub fn g_hmac_get_string(hmac: *mut GHmac) -> *const gchar;
}
extern "C" {
    pub fn g_hmac_get_digest(hmac: *mut GHmac, buffer: *mut guint8, digest_len: *mut gsize);
}
extern "C" {
    pub fn g_compute_hmac_for_data(
        digest_type: GChecksumType,
        key: *const guchar,
        key_len: gsize,
        data: *const guchar,
        length: gsize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_hmac_for_string(
        digest_type: GChecksumType,
        key: *const guchar,
        key_len: gsize,
        str_: *const gchar,
        length: gssize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_compute_hmac_for_bytes(
        digest_type: GChecksumType,
        key: *mut GBytes,
        data: *mut GBytes,
    ) -> *mut gchar;
}
pub type GHook = _GHook;
pub type GHookList = _GHookList;
pub type GHookCompareFunc =
    ::std::option::Option<unsafe extern "C" fn(new_hook: *mut GHook, sibling: *mut GHook) -> gint>;
pub type GHookFindFunc =
    ::std::option::Option<unsafe extern "C" fn(hook: *mut GHook, data: gpointer) -> gboolean>;
pub type GHookMarshaller =
    ::std::option::Option<unsafe extern "C" fn(hook: *mut GHook, marshal_data: gpointer)>;
pub type GHookCheckMarshaller = ::std::option::Option<
    unsafe extern "C" fn(hook: *mut GHook, marshal_data: gpointer) -> gboolean,
>;
pub type GHookFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer)>;
pub type GHookCheckFunc = ::std::option::Option<unsafe extern "C" fn(data: gpointer) -> gboolean>;
pub type GHookFinalizeFunc =
    ::std::option::Option<unsafe extern "C" fn(hook_list: *mut GHookList, hook: *mut GHook)>;
pub const GHookFlagMask_G_HOOK_FLAG_ACTIVE: GHookFlagMask = 1;
pub const GHookFlagMask_G_HOOK_FLAG_IN_CALL: GHookFlagMask = 2;
pub const GHookFlagMask_G_HOOK_FLAG_MASK: GHookFlagMask = 15;
pub type GHookFlagMask = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHookList {
    pub seq_id: gulong,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub hooks: *mut GHook,
    pub dummy3: gpointer,
    pub finalize_hook: GHookFinalizeFunc,
    pub dummy: [gpointer; 2usize],
}
impl _GHookList {
    #[inline]
    pub fn hook_size(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_hook_size(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn is_setup(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_setup(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        hook_size: guint,
        is_setup: guint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let hook_size: u32 = unsafe { ::std::mem::transmute(hook_size) };
            hook_size as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let is_setup: u32 = unsafe { ::std::mem::transmute(is_setup) };
            is_setup as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHook {
    pub data: gpointer,
    pub next: *mut GHook,
    pub prev: *mut GHook,
    pub ref_count: guint,
    pub hook_id: gulong,
    pub flags: guint,
    pub func: gpointer,
    pub destroy: GDestroyNotify,
}
extern "C" {
    pub fn g_hook_list_init(hook_list: *mut GHookList, hook_size: guint);
}
extern "C" {
    pub fn g_hook_list_clear(hook_list: *mut GHookList);
}
extern "C" {
    pub fn g_hook_alloc(hook_list: *mut GHookList) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_free(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_ref(hook_list: *mut GHookList, hook: *mut GHook) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_unref(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_destroy(hook_list: *mut GHookList, hook_id: gulong) -> gboolean;
}
extern "C" {
    pub fn g_hook_destroy_link(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_prepend(hook_list: *mut GHookList, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_insert_before(hook_list: *mut GHookList, sibling: *mut GHook, hook: *mut GHook);
}
extern "C" {
    pub fn g_hook_insert_sorted(
        hook_list: *mut GHookList,
        hook: *mut GHook,
        func: GHookCompareFunc,
    );
}
extern "C" {
    pub fn g_hook_get(hook_list: *mut GHookList, hook_id: gulong) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        func: GHookFindFunc,
        data: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find_data(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        data: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find_func(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        func: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_find_func_data(
        hook_list: *mut GHookList,
        need_valids: gboolean,
        func: gpointer,
        data: gpointer,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_first_valid(hook_list: *mut GHookList, may_be_in_call: gboolean) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_next_valid(
        hook_list: *mut GHookList,
        hook: *mut GHook,
        may_be_in_call: gboolean,
    ) -> *mut GHook;
}
extern "C" {
    pub fn g_hook_compare_ids(new_hook: *mut GHook, sibling: *mut GHook) -> gint;
}
extern "C" {
    pub fn g_hook_list_invoke(hook_list: *mut GHookList, may_recurse: gboolean);
}
extern "C" {
    pub fn g_hook_list_invoke_check(hook_list: *mut GHookList, may_recurse: gboolean);
}
extern "C" {
    pub fn g_hook_list_marshal(
        hook_list: *mut GHookList,
        may_recurse: gboolean,
        marshaller: GHookMarshaller,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_hook_list_marshal_check(
        hook_list: *mut GHookList,
        may_recurse: gboolean,
        marshaller: GHookCheckMarshaller,
        marshal_data: gpointer,
    );
}
extern "C" {
    pub fn g_hostname_is_non_ascii(hostname: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_hostname_is_ascii_encoded(hostname: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_hostname_is_ip_address(hostname: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_hostname_to_ascii(hostname: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_hostname_to_unicode(hostname: *const gchar) -> *mut gchar;
}
pub type GPollFD = _GPollFD;
#[doc = " GPollFunc:"]
#[doc = " @ufds: an array of #GPollFD elements"]
#[doc = " @nfsd: the number of elements in @ufds"]
#[doc = " @timeout_: the maximum time to wait for an event of the file descriptors."]
#[doc = "     A negative value indicates an infinite timeout."]
#[doc = ""]
#[doc = " Specifies the type of function passed to g_main_context_set_poll_func()."]
#[doc = " The semantics of the function should match those of the poll() system call."]
#[doc = ""]
#[doc = " Returns: the number of #GPollFD elements which have events or errors"]
#[doc = "     reported, or -1 if an error occurred."]
pub type GPollFunc = ::std::option::Option<
    unsafe extern "C" fn(ufds: *mut GPollFD, nfsd: guint, timeout_: gint) -> gint,
>;
#[doc = " GPollFD:"]
#[doc = " @fd: the file descriptor to poll (or a HANDLE on Win32)"]
#[doc = " @events: a bitwise combination from #GIOCondition, specifying which"]
#[doc = "     events should be polled for. Typically for reading from a file"]
#[doc = "     descriptor you would use %G_IO_IN | %G_IO_HUP | %G_IO_ERR, and"]
#[doc = "     for writing you would use %G_IO_OUT | %G_IO_ERR."]
#[doc = " @revents: a bitwise combination of flags from #GIOCondition, returned"]
#[doc = "     from the poll() function to indicate which events occurred."]
#[doc = ""]
#[doc = " Represents a file descriptor, which events to poll for, and which events"]
#[doc = " occurred."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPollFD {
    pub fd: gint,
    pub events: gushort,
    pub revents: gushort,
}
extern "C" {
    #[doc = " G_POLLFD_FORMAT:"]
    #[doc = ""]
    #[doc = " A format specifier that can be used in printf()-style format strings"]
    #[doc = " when printing the @fd member of a #GPollFD."]
    pub fn g_poll(fds: *mut GPollFD, nfds: guint, timeout: gint) -> gint;
}
pub type GSList = _GSList;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSList {
    pub data: gpointer,
    pub next: *mut GSList,
}
extern "C" {
    pub fn g_slist_alloc() -> *mut GSList;
}
extern "C" {
    pub fn g_slist_free(list: *mut GSList);
}
extern "C" {
    pub fn g_slist_free_1(list: *mut GSList);
}
extern "C" {
    pub fn g_slist_free_full(list: *mut GSList, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_slist_append(list: *mut GSList, data: gpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_prepend(list: *mut GSList, data: gpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert(list: *mut GSList, data: gpointer, position: gint) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert_sorted(
        list: *mut GSList,
        data: gpointer,
        func: GCompareFunc,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert_sorted_with_data(
        list: *mut GSList,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_insert_before(
        slist: *mut GSList,
        sibling: *mut GSList,
        data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_concat(list1: *mut GSList, list2: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_remove(list: *mut GSList, data: gconstpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_remove_all(list: *mut GSList, data: gconstpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_remove_link(list: *mut GSList, link_: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_delete_link(list: *mut GSList, link_: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_reverse(list: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_copy(list: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_copy_deep(
        list: *mut GSList,
        func: GCopyFunc,
        user_data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_nth(list: *mut GSList, n: guint) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_find(list: *mut GSList, data: gconstpointer) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_find_custom(
        list: *mut GSList,
        data: gconstpointer,
        func: GCompareFunc,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_position(list: *mut GSList, llink: *mut GSList) -> gint;
}
extern "C" {
    pub fn g_slist_index(list: *mut GSList, data: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_slist_last(list: *mut GSList) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_length(list: *mut GSList) -> guint;
}
extern "C" {
    pub fn g_slist_foreach(list: *mut GSList, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_slist_sort(list: *mut GSList, compare_func: GCompareFunc) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_sort_with_data(
        list: *mut GSList,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    ) -> *mut GSList;
}
extern "C" {
    pub fn g_slist_nth_data(list: *mut GSList, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_clear_slist(slist_ptr: *mut *mut GSList, destroy: GDestroyNotify);
}
pub const GIOCondition_G_IO_IN: GIOCondition = 1;
pub const GIOCondition_G_IO_OUT: GIOCondition = 4;
pub const GIOCondition_G_IO_PRI: GIOCondition = 2;
pub const GIOCondition_G_IO_ERR: GIOCondition = 8;
pub const GIOCondition_G_IO_HUP: GIOCondition = 16;
pub const GIOCondition_G_IO_NVAL: GIOCondition = 32;
pub type GIOCondition = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMainContext {
    _unused: [u8; 0],
}
#[doc = " GMainContext:"]
#[doc = ""]
#[doc = " The `GMainContext` struct is an opaque data"]
#[doc = " type representing a set of sources to be handled in a main loop."]
pub type GMainContext = _GMainContext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMainLoop {
    _unused: [u8; 0],
}
#[doc = " GMainLoop:"]
#[doc = ""]
#[doc = " The `GMainLoop` struct is an opaque data type"]
#[doc = " representing the main event loop of a GLib or GTK+ application."]
pub type GMainLoop = _GMainLoop;
#[doc = " GSource:"]
#[doc = ""]
#[doc = " The `GSource` struct is an opaque data type"]
#[doc = " representing an event source."]
pub type GSource = _GSource;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSourcePrivate {
    _unused: [u8; 0],
}
pub type GSourcePrivate = _GSourcePrivate;
#[doc = " GSourceCallbackFuncs:"]
#[doc = " @ref: Called when a reference is added to the callback object"]
#[doc = " @unref: Called when a reference to the callback object is dropped"]
#[doc = " @get: Called to extract the callback function and data from the"]
#[doc = "     callback object."]
#[doc = ""]
#[doc = " The `GSourceCallbackFuncs` struct contains"]
#[doc = " functions for managing callback objects."]
pub type GSourceCallbackFuncs = _GSourceCallbackFuncs;
#[doc = " GSourceFuncs:"]
#[doc = " @prepare: Called before all the file descriptors are polled. If the"]
#[doc = "     source can determine that it is ready here (without waiting for the"]
#[doc = "     results of the poll() call) it should return %TRUE. It can also return"]
#[doc = "     a @timeout_ value which should be the maximum timeout (in milliseconds)"]
#[doc = "     which should be passed to the poll() call. The actual timeout used will"]
#[doc = "     be -1 if all sources returned -1, or it will be the minimum of all"]
#[doc = "     the @timeout_ values returned which were >= 0.  Since 2.36 this may"]
#[doc = "     be %NULL, in which case the effect is as if the function always returns"]
#[doc = "     %FALSE with a timeout of -1.  If @prepare returns a"]
#[doc = "     timeout and the source also has a ready time set, then the"]
#[doc = "     lower of the two will be used."]
#[doc = " @check: Called after all the file descriptors are polled. The source"]
#[doc = "     should return %TRUE if it is ready to be dispatched. Note that some"]
#[doc = "     time may have passed since the previous prepare function was called,"]
#[doc = "     so the source should be checked again here.  Since 2.36 this may"]
#[doc = "     be %NULL, in which case the effect is as if the function always returns"]
#[doc = "     %FALSE."]
#[doc = " @dispatch: Called to dispatch the event source, after it has returned"]
#[doc = "     %TRUE in either its @prepare or its @check function, or if a ready time"]
#[doc = "     has been reached. The @dispatch function receives a callback function and"]
#[doc = "     user data. The callback function may be %NULL if the source was never"]
#[doc = "     connected to a callback using g_source_set_callback(). The @dispatch"]
#[doc = "     function should call the callback function with @user_data and whatever"]
#[doc = "     additional parameters are needed for this type of event source. The"]
#[doc = "     return value of the @dispatch function should be #G_SOURCE_REMOVE if the"]
#[doc = "     source should be removed or #G_SOURCE_CONTINUE to keep it."]
#[doc = " @finalize: Called when the source is finalized. At this point, the source"]
#[doc = "     will have been destroyed, had its callback cleared, and have been removed"]
#[doc = "     from its #GMainContext, but it will still have its final reference count,"]
#[doc = "     so methods can be called on it from within this function."]
#[doc = ""]
#[doc = " The `GSourceFuncs` struct contains a table of"]
#[doc = " functions used to handle event sources in a generic manner."]
#[doc = ""]
#[doc = " For idle sources, the prepare and check functions always return %TRUE"]
#[doc = " to indicate that the source is always ready to be processed. The prepare"]
#[doc = " function also returns a timeout value of 0 to ensure that the poll() call"]
#[doc = " doesn't block (since that would be time wasted which could have been spent"]
#[doc = " running the idle function)."]
#[doc = ""]
#[doc = " For timeout sources, the prepare and check functions both return %TRUE"]
#[doc = " if the timeout interval has expired. The prepare function also returns"]
#[doc = " a timeout value to ensure that the poll() call doesn't block too long"]
#[doc = " and miss the next timeout."]
#[doc = ""]
#[doc = " For file descriptor sources, the prepare function typically returns %FALSE,"]
#[doc = " since it must wait until poll() has been called before it knows whether"]
#[doc = " any events need to be processed. It sets the returned timeout to -1 to"]
#[doc = " indicate that it doesn't mind how long the poll() call blocks. In the"]
#[doc = " check function, it tests the results of the poll() call to see if the"]
#[doc = " required condition has been met, and returns %TRUE if so."]
pub type GSourceFuncs = _GSourceFuncs;
#[doc = " GSourceFunc:"]
#[doc = " @user_data: data passed to the function, set when the source was"]
#[doc = "     created with one of the above functions"]
#[doc = ""]
#[doc = " Specifies the type of function passed to g_timeout_add(),"]
#[doc = " g_timeout_add_full(), g_idle_add(), and g_idle_add_full()."]
#[doc = ""]
#[doc = " When calling g_source_set_callback(), you may need to cast a function of a"]
#[doc = " different type to this type. Use G_SOURCE_FUNC() to avoid warnings about"]
#[doc = " incompatible function types."]
#[doc = ""]
#[doc = " Returns: %FALSE if the source should be removed. #G_SOURCE_CONTINUE and"]
#[doc = " #G_SOURCE_REMOVE are more memorable names for the return value."]
pub type GSourceFunc = ::std::option::Option<unsafe extern "C" fn(user_data: gpointer) -> gboolean>;
#[doc = " GChildWatchFunc:"]
#[doc = " @pid: the process id of the child process"]
#[doc = " @status: Status information about the child process, encoded"]
#[doc = "     in a platform-specific manner"]
#[doc = " @user_data: user data passed to g_child_watch_add()"]
#[doc = ""]
#[doc = " Prototype of a #GChildWatchSource callback, called when a child"]
#[doc = " process has exited.  To interpret @status, see the documentation"]
#[doc = " for g_spawn_check_exit_status()."]
pub type GChildWatchFunc =
    ::std::option::Option<unsafe extern "C" fn(pid: GPid, status: gint, user_data: gpointer)>;
#[doc = " GSourceDisposeFunc:"]
#[doc = " @source: #GSource that is currently being disposed"]
#[doc = ""]
#[doc = " Dispose function for @source. See g_source_set_dispose_function() for"]
#[doc = " details."]
#[doc = ""]
#[doc = " Since: 2.64"]
pub type GSourceDisposeFunc = ::std::option::Option<unsafe extern "C" fn(source: *mut GSource)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSource {
    pub callback_data: gpointer,
    pub callback_funcs: *mut GSourceCallbackFuncs,
    pub source_funcs: *const GSourceFuncs,
    pub ref_count: guint,
    pub context: *mut GMainContext,
    pub priority: gint,
    pub flags: guint,
    pub source_id: guint,
    pub poll_fds: *mut GSList,
    pub prev: *mut GSource,
    pub next: *mut GSource,
    pub name: *mut ::std::os::raw::c_char,
    pub priv_: *mut GSourcePrivate,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSourceCallbackFuncs {
    pub ref_: ::std::option::Option<unsafe extern "C" fn(cb_data: gpointer)>,
    pub unref: ::std::option::Option<unsafe extern "C" fn(cb_data: gpointer)>,
    pub get: ::std::option::Option<
        unsafe extern "C" fn(
            cb_data: gpointer,
            source: *mut GSource,
            func: *mut GSourceFunc,
            data: *mut gpointer,
        ),
    >,
}
#[doc = " GSourceDummyMarshal:"]
#[doc = ""]
#[doc = " This is just a placeholder for #GClosureMarshal,"]
#[doc = " which cannot be used here for dependency reasons."]
pub type GSourceDummyMarshal = ::std::option::Option<unsafe extern "C" fn()>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSourceFuncs {
    pub prepare: ::std::option::Option<
        unsafe extern "C" fn(source: *mut GSource, timeout_: *mut gint) -> gboolean,
    >,
    pub check: ::std::option::Option<unsafe extern "C" fn(source: *mut GSource) -> gboolean>,
    pub dispatch: ::std::option::Option<
        unsafe extern "C" fn(
            source: *mut GSource,
            callback: GSourceFunc,
            user_data: gpointer,
        ) -> gboolean,
    >,
    pub finalize: ::std::option::Option<unsafe extern "C" fn(source: *mut GSource)>,
    pub closure_callback: GSourceFunc,
    pub closure_marshal: GSourceDummyMarshal,
}
extern "C" {
    pub fn g_main_context_new() -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_ref(context: *mut GMainContext) -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_unref(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_default() -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_iteration(context: *mut GMainContext, may_block: gboolean) -> gboolean;
}
extern "C" {
    pub fn g_main_context_pending(context: *mut GMainContext) -> gboolean;
}
extern "C" {
    pub fn g_main_context_find_source_by_id(
        context: *mut GMainContext,
        source_id: guint,
    ) -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_find_source_by_user_data(
        context: *mut GMainContext,
        user_data: gpointer,
    ) -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_find_source_by_funcs_user_data(
        context: *mut GMainContext,
        funcs: *mut GSourceFuncs,
        user_data: gpointer,
    ) -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_wakeup(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_acquire(context: *mut GMainContext) -> gboolean;
}
extern "C" {
    pub fn g_main_context_release(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_is_owner(context: *mut GMainContext) -> gboolean;
}
extern "C" {
    pub fn g_main_context_wait(
        context: *mut GMainContext,
        cond: *mut GCond,
        mutex: *mut GMutex,
    ) -> gboolean;
}
extern "C" {
    pub fn g_main_context_prepare(context: *mut GMainContext, priority: *mut gint) -> gboolean;
}
extern "C" {
    pub fn g_main_context_query(
        context: *mut GMainContext,
        max_priority: gint,
        timeout_: *mut gint,
        fds: *mut GPollFD,
        n_fds: gint,
    ) -> gint;
}
extern "C" {
    pub fn g_main_context_check(
        context: *mut GMainContext,
        max_priority: gint,
        fds: *mut GPollFD,
        n_fds: gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_main_context_dispatch(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_set_poll_func(context: *mut GMainContext, func: GPollFunc);
}
extern "C" {
    pub fn g_main_context_get_poll_func(context: *mut GMainContext) -> GPollFunc;
}
extern "C" {
    pub fn g_main_context_add_poll(context: *mut GMainContext, fd: *mut GPollFD, priority: gint);
}
extern "C" {
    pub fn g_main_context_remove_poll(context: *mut GMainContext, fd: *mut GPollFD);
}
extern "C" {
    pub fn g_main_depth() -> gint;
}
extern "C" {
    pub fn g_main_current_source() -> *mut GSource;
}
extern "C" {
    pub fn g_main_context_push_thread_default(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_pop_thread_default(context: *mut GMainContext);
}
extern "C" {
    pub fn g_main_context_get_thread_default() -> *mut GMainContext;
}
extern "C" {
    pub fn g_main_context_ref_thread_default() -> *mut GMainContext;
}
#[doc = " GMainContextPusher:"]
#[doc = ""]
#[doc = " Opaque type. See g_main_context_pusher_new() for details."]
#[doc = ""]
#[doc = " Since: 2.64"]
pub type GMainContextPusher = ::std::os::raw::c_void;
extern "C" {
    pub fn g_main_loop_new(context: *mut GMainContext, is_running: gboolean) -> *mut GMainLoop;
}
extern "C" {
    pub fn g_main_loop_run(loop_: *mut GMainLoop);
}
extern "C" {
    pub fn g_main_loop_quit(loop_: *mut GMainLoop);
}
extern "C" {
    pub fn g_main_loop_ref(loop_: *mut GMainLoop) -> *mut GMainLoop;
}
extern "C" {
    pub fn g_main_loop_unref(loop_: *mut GMainLoop);
}
extern "C" {
    pub fn g_main_loop_is_running(loop_: *mut GMainLoop) -> gboolean;
}
extern "C" {
    pub fn g_main_loop_get_context(loop_: *mut GMainLoop) -> *mut GMainContext;
}
extern "C" {
    pub fn g_source_new(source_funcs: *mut GSourceFuncs, struct_size: guint) -> *mut GSource;
}
extern "C" {
    pub fn g_source_set_dispose_function(source: *mut GSource, dispose: GSourceDisposeFunc);
}
extern "C" {
    pub fn g_source_ref(source: *mut GSource) -> *mut GSource;
}
extern "C" {
    pub fn g_source_unref(source: *mut GSource);
}
extern "C" {
    pub fn g_source_attach(source: *mut GSource, context: *mut GMainContext) -> guint;
}
extern "C" {
    pub fn g_source_destroy(source: *mut GSource);
}
extern "C" {
    pub fn g_source_set_priority(source: *mut GSource, priority: gint);
}
extern "C" {
    pub fn g_source_get_priority(source: *mut GSource) -> gint;
}
extern "C" {
    pub fn g_source_set_can_recurse(source: *mut GSource, can_recurse: gboolean);
}
extern "C" {
    pub fn g_source_get_can_recurse(source: *mut GSource) -> gboolean;
}
extern "C" {
    pub fn g_source_get_id(source: *mut GSource) -> guint;
}
extern "C" {
    pub fn g_source_get_context(source: *mut GSource) -> *mut GMainContext;
}
extern "C" {
    pub fn g_source_set_callback(
        source: *mut GSource,
        func: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_source_set_funcs(source: *mut GSource, funcs: *mut GSourceFuncs);
}
extern "C" {
    pub fn g_source_is_destroyed(source: *mut GSource) -> gboolean;
}
extern "C" {
    pub fn g_source_set_name(source: *mut GSource, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_source_get_name(source: *mut GSource) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_source_set_name_by_id(tag: guint, name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_source_set_ready_time(source: *mut GSource, ready_time: gint64);
}
extern "C" {
    pub fn g_source_get_ready_time(source: *mut GSource) -> gint64;
}
extern "C" {
    pub fn g_source_add_unix_fd(source: *mut GSource, fd: gint, events: GIOCondition) -> gpointer;
}
extern "C" {
    pub fn g_source_modify_unix_fd(source: *mut GSource, tag: gpointer, new_events: GIOCondition);
}
extern "C" {
    pub fn g_source_remove_unix_fd(source: *mut GSource, tag: gpointer);
}
extern "C" {
    pub fn g_source_query_unix_fd(source: *mut GSource, tag: gpointer) -> GIOCondition;
}
extern "C" {
    pub fn g_source_set_callback_indirect(
        source: *mut GSource,
        callback_data: gpointer,
        callback_funcs: *mut GSourceCallbackFuncs,
    );
}
extern "C" {
    pub fn g_source_add_poll(source: *mut GSource, fd: *mut GPollFD);
}
extern "C" {
    pub fn g_source_remove_poll(source: *mut GSource, fd: *mut GPollFD);
}
extern "C" {
    pub fn g_source_add_child_source(source: *mut GSource, child_source: *mut GSource);
}
extern "C" {
    pub fn g_source_remove_child_source(source: *mut GSource, child_source: *mut GSource);
}
extern "C" {
    pub fn g_source_get_current_time(source: *mut GSource, timeval: *mut GTimeVal);
}
extern "C" {
    pub fn g_source_get_time(source: *mut GSource) -> gint64;
}
extern "C" {
    pub fn g_idle_source_new() -> *mut GSource;
}
extern "C" {
    pub fn g_child_watch_source_new(pid: GPid) -> *mut GSource;
}
extern "C" {
    pub fn g_timeout_source_new(interval: guint) -> *mut GSource;
}
extern "C" {
    pub fn g_timeout_source_new_seconds(interval: guint) -> *mut GSource;
}
extern "C" {
    pub fn g_get_current_time(result: *mut GTimeVal);
}
extern "C" {
    pub fn g_get_monotonic_time() -> gint64;
}
extern "C" {
    pub fn g_get_real_time() -> gint64;
}
extern "C" {
    pub fn g_source_remove(tag: guint) -> gboolean;
}
extern "C" {
    pub fn g_source_remove_by_user_data(user_data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_source_remove_by_funcs_user_data(
        funcs: *mut GSourceFuncs,
        user_data: gpointer,
    ) -> gboolean;
}
#[doc = " GClearHandleFunc:"]
#[doc = " @handle_id: the handle ID to clear"]
#[doc = ""]
#[doc = " Specifies the type of function passed to g_clear_handle_id()."]
#[doc = " The implementation is expected to free the resource identified"]
#[doc = " by @handle_id; for instance, if @handle_id is a #GSource ID,"]
#[doc = " g_source_remove() can be used."]
#[doc = ""]
#[doc = " Since: 2.56"]
pub type GClearHandleFunc = ::std::option::Option<unsafe extern "C" fn(handle_id: guint)>;
extern "C" {
    pub fn g_clear_handle_id(tag_ptr: *mut guint, clear_func: GClearHandleFunc);
}
extern "C" {
    pub fn g_timeout_add_full(
        priority: gint,
        interval: guint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_timeout_add(interval: guint, function: GSourceFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_timeout_add_seconds_full(
        priority: gint,
        interval: guint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_timeout_add_seconds(interval: guint, function: GSourceFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_child_watch_add_full(
        priority: gint,
        pid: GPid,
        function: GChildWatchFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_child_watch_add(pid: GPid, function: GChildWatchFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_idle_add(function: GSourceFunc, data: gpointer) -> guint;
}
extern "C" {
    pub fn g_idle_add_full(
        priority: gint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_idle_remove_by_data(data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_main_context_invoke_full(
        context: *mut GMainContext,
        priority: gint,
        function: GSourceFunc,
        data: gpointer,
        notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_main_context_invoke(context: *mut GMainContext, function: GSourceFunc, data: gpointer);
}
extern "C" {
    pub static mut g_timeout_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_child_watch_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_idle_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_unix_signal_funcs: GSourceFuncs;
}
extern "C" {
    pub static mut g_unix_fd_source_funcs: GSourceFuncs;
}
#[doc = " gunichar:"]
#[doc = ""]
#[doc = " A type which can hold any UTF-32 or UCS-4 character code,"]
#[doc = " also known as a Unicode code point."]
#[doc = ""]
#[doc = " If you want to produce the UTF-8 representation of a #gunichar,"]
#[doc = " use g_ucs4_to_utf8(). See also g_utf8_to_ucs4() for the reverse"]
#[doc = " process."]
#[doc = ""]
#[doc = " To print/scan values of this type as integer, use"]
#[doc = " %G_GINT32_MODIFIER and/or %G_GUINT32_FORMAT."]
#[doc = ""]
#[doc = " The notation to express a Unicode code point in running text is"]
#[doc = " as a hexadecimal number with four to six digits and uppercase"]
#[doc = " letters, prefixed by the string \"U+\". Leading zeros are omitted,"]
#[doc = " unless the code point would have fewer than four hexadecimal digits."]
#[doc = " For example, \"U+0041 LATIN CAPITAL LETTER A\". To print a code point"]
#[doc = " in the U+-notation, use the format string \"U+\\%04\"G_GINT32_FORMAT\"X\"."]
#[doc = " To scan, use the format string \"U+\\%06\"G_GINT32_FORMAT\"X\"."]
#[doc = ""]
#[doc = " |["]
#[doc = " gunichar c;"]
#[doc = " sscanf (\"U+0041\", \"U+%06\"G_GINT32_FORMAT\"X\", &amp;c)"]
#[doc = " g_print (\"Read U+%04\"G_GINT32_FORMAT\"X\", c);"]
#[doc = " ]|"]
pub type gunichar = guint32;
#[doc = " gunichar2:"]
#[doc = ""]
#[doc = " A type which can hold any UTF-16 code"]
#[doc = " point<footnote id=\"utf16_surrogate_pairs\">UTF-16 also has so called"]
#[doc = " <firstterm>surrogate pairs</firstterm> to encode characters beyond"]
#[doc = " the BMP as pairs of 16bit numbers. Surrogate pairs cannot be stored"]
#[doc = " in a single gunichar2 field, but all GLib functions accepting gunichar2"]
#[doc = " arrays will correctly interpret surrogate pairs.</footnote>."]
#[doc = ""]
#[doc = " To print/scan values of this type to/from text you need to convert"]
#[doc = " to/from UTF-8, using g_utf16_to_utf8()/g_utf8_to_utf16()."]
#[doc = ""]
#[doc = " To print/scan values of this type as integer, use"]
#[doc = " %G_GINT16_MODIFIER and/or %G_GUINT16_FORMAT."]
pub type gunichar2 = guint16;
pub const GUnicodeType_G_UNICODE_CONTROL: GUnicodeType = 0;
pub const GUnicodeType_G_UNICODE_FORMAT: GUnicodeType = 1;
pub const GUnicodeType_G_UNICODE_UNASSIGNED: GUnicodeType = 2;
pub const GUnicodeType_G_UNICODE_PRIVATE_USE: GUnicodeType = 3;
pub const GUnicodeType_G_UNICODE_SURROGATE: GUnicodeType = 4;
pub const GUnicodeType_G_UNICODE_LOWERCASE_LETTER: GUnicodeType = 5;
pub const GUnicodeType_G_UNICODE_MODIFIER_LETTER: GUnicodeType = 6;
pub const GUnicodeType_G_UNICODE_OTHER_LETTER: GUnicodeType = 7;
pub const GUnicodeType_G_UNICODE_TITLECASE_LETTER: GUnicodeType = 8;
pub const GUnicodeType_G_UNICODE_UPPERCASE_LETTER: GUnicodeType = 9;
pub const GUnicodeType_G_UNICODE_SPACING_MARK: GUnicodeType = 10;
pub const GUnicodeType_G_UNICODE_ENCLOSING_MARK: GUnicodeType = 11;
pub const GUnicodeType_G_UNICODE_NON_SPACING_MARK: GUnicodeType = 12;
pub const GUnicodeType_G_UNICODE_DECIMAL_NUMBER: GUnicodeType = 13;
pub const GUnicodeType_G_UNICODE_LETTER_NUMBER: GUnicodeType = 14;
pub const GUnicodeType_G_UNICODE_OTHER_NUMBER: GUnicodeType = 15;
pub const GUnicodeType_G_UNICODE_CONNECT_PUNCTUATION: GUnicodeType = 16;
pub const GUnicodeType_G_UNICODE_DASH_PUNCTUATION: GUnicodeType = 17;
pub const GUnicodeType_G_UNICODE_CLOSE_PUNCTUATION: GUnicodeType = 18;
pub const GUnicodeType_G_UNICODE_FINAL_PUNCTUATION: GUnicodeType = 19;
pub const GUnicodeType_G_UNICODE_INITIAL_PUNCTUATION: GUnicodeType = 20;
pub const GUnicodeType_G_UNICODE_OTHER_PUNCTUATION: GUnicodeType = 21;
pub const GUnicodeType_G_UNICODE_OPEN_PUNCTUATION: GUnicodeType = 22;
pub const GUnicodeType_G_UNICODE_CURRENCY_SYMBOL: GUnicodeType = 23;
pub const GUnicodeType_G_UNICODE_MODIFIER_SYMBOL: GUnicodeType = 24;
pub const GUnicodeType_G_UNICODE_MATH_SYMBOL: GUnicodeType = 25;
pub const GUnicodeType_G_UNICODE_OTHER_SYMBOL: GUnicodeType = 26;
pub const GUnicodeType_G_UNICODE_LINE_SEPARATOR: GUnicodeType = 27;
pub const GUnicodeType_G_UNICODE_PARAGRAPH_SEPARATOR: GUnicodeType = 28;
pub const GUnicodeType_G_UNICODE_SPACE_SEPARATOR: GUnicodeType = 29;
#[doc = " GUnicodeType:"]
#[doc = " @G_UNICODE_CONTROL: General category \"Other, Control\" (Cc)"]
#[doc = " @G_UNICODE_FORMAT: General category \"Other, Format\" (Cf)"]
#[doc = " @G_UNICODE_UNASSIGNED: General category \"Other, Not Assigned\" (Cn)"]
#[doc = " @G_UNICODE_PRIVATE_USE: General category \"Other, Private Use\" (Co)"]
#[doc = " @G_UNICODE_SURROGATE: General category \"Other, Surrogate\" (Cs)"]
#[doc = " @G_UNICODE_LOWERCASE_LETTER: General category \"Letter, Lowercase\" (Ll)"]
#[doc = " @G_UNICODE_MODIFIER_LETTER: General category \"Letter, Modifier\" (Lm)"]
#[doc = " @G_UNICODE_OTHER_LETTER: General category \"Letter, Other\" (Lo)"]
#[doc = " @G_UNICODE_TITLECASE_LETTER: General category \"Letter, Titlecase\" (Lt)"]
#[doc = " @G_UNICODE_UPPERCASE_LETTER: General category \"Letter, Uppercase\" (Lu)"]
#[doc = " @G_UNICODE_SPACING_MARK: General category \"Mark, Spacing\" (Mc)"]
#[doc = " @G_UNICODE_ENCLOSING_MARK: General category \"Mark, Enclosing\" (Me)"]
#[doc = " @G_UNICODE_NON_SPACING_MARK: General category \"Mark, Nonspacing\" (Mn)"]
#[doc = " @G_UNICODE_DECIMAL_NUMBER: General category \"Number, Decimal Digit\" (Nd)"]
#[doc = " @G_UNICODE_LETTER_NUMBER: General category \"Number, Letter\" (Nl)"]
#[doc = " @G_UNICODE_OTHER_NUMBER: General category \"Number, Other\" (No)"]
#[doc = " @G_UNICODE_CONNECT_PUNCTUATION: General category \"Punctuation, Connector\" (Pc)"]
#[doc = " @G_UNICODE_DASH_PUNCTUATION: General category \"Punctuation, Dash\" (Pd)"]
#[doc = " @G_UNICODE_CLOSE_PUNCTUATION: General category \"Punctuation, Close\" (Pe)"]
#[doc = " @G_UNICODE_FINAL_PUNCTUATION: General category \"Punctuation, Final quote\" (Pf)"]
#[doc = " @G_UNICODE_INITIAL_PUNCTUATION: General category \"Punctuation, Initial quote\" (Pi)"]
#[doc = " @G_UNICODE_OTHER_PUNCTUATION: General category \"Punctuation, Other\" (Po)"]
#[doc = " @G_UNICODE_OPEN_PUNCTUATION: General category \"Punctuation, Open\" (Ps)"]
#[doc = " @G_UNICODE_CURRENCY_SYMBOL: General category \"Symbol, Currency\" (Sc)"]
#[doc = " @G_UNICODE_MODIFIER_SYMBOL: General category \"Symbol, Modifier\" (Sk)"]
#[doc = " @G_UNICODE_MATH_SYMBOL: General category \"Symbol, Math\" (Sm)"]
#[doc = " @G_UNICODE_OTHER_SYMBOL: General category \"Symbol, Other\" (So)"]
#[doc = " @G_UNICODE_LINE_SEPARATOR: General category \"Separator, Line\" (Zl)"]
#[doc = " @G_UNICODE_PARAGRAPH_SEPARATOR: General category \"Separator, Paragraph\" (Zp)"]
#[doc = " @G_UNICODE_SPACE_SEPARATOR: General category \"Separator, Space\" (Zs)"]
#[doc = ""]
#[doc = " These are the possible character classifications from the"]
#[doc = " Unicode specification."]
#[doc = " See [Unicode Character Database](http://www.unicode.org/reports/tr44/#General_Category_Values)."]
pub type GUnicodeType = ::std::os::raw::c_uint;
pub const GUnicodeBreakType_G_UNICODE_BREAK_MANDATORY: GUnicodeBreakType = 0;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CARRIAGE_RETURN: GUnicodeBreakType = 1;
pub const GUnicodeBreakType_G_UNICODE_BREAK_LINE_FEED: GUnicodeBreakType = 2;
pub const GUnicodeBreakType_G_UNICODE_BREAK_COMBINING_MARK: GUnicodeBreakType = 3;
pub const GUnicodeBreakType_G_UNICODE_BREAK_SURROGATE: GUnicodeBreakType = 4;
pub const GUnicodeBreakType_G_UNICODE_BREAK_ZERO_WIDTH_SPACE: GUnicodeBreakType = 5;
pub const GUnicodeBreakType_G_UNICODE_BREAK_INSEPARABLE: GUnicodeBreakType = 6;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NON_BREAKING_GLUE: GUnicodeBreakType = 7;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CONTINGENT: GUnicodeBreakType = 8;
pub const GUnicodeBreakType_G_UNICODE_BREAK_SPACE: GUnicodeBreakType = 9;
pub const GUnicodeBreakType_G_UNICODE_BREAK_AFTER: GUnicodeBreakType = 10;
pub const GUnicodeBreakType_G_UNICODE_BREAK_BEFORE: GUnicodeBreakType = 11;
pub const GUnicodeBreakType_G_UNICODE_BREAK_BEFORE_AND_AFTER: GUnicodeBreakType = 12;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HYPHEN: GUnicodeBreakType = 13;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NON_STARTER: GUnicodeBreakType = 14;
pub const GUnicodeBreakType_G_UNICODE_BREAK_OPEN_PUNCTUATION: GUnicodeBreakType = 15;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CLOSE_PUNCTUATION: GUnicodeBreakType = 16;
pub const GUnicodeBreakType_G_UNICODE_BREAK_QUOTATION: GUnicodeBreakType = 17;
pub const GUnicodeBreakType_G_UNICODE_BREAK_EXCLAMATION: GUnicodeBreakType = 18;
pub const GUnicodeBreakType_G_UNICODE_BREAK_IDEOGRAPHIC: GUnicodeBreakType = 19;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NUMERIC: GUnicodeBreakType = 20;
pub const GUnicodeBreakType_G_UNICODE_BREAK_INFIX_SEPARATOR: GUnicodeBreakType = 21;
pub const GUnicodeBreakType_G_UNICODE_BREAK_SYMBOL: GUnicodeBreakType = 22;
pub const GUnicodeBreakType_G_UNICODE_BREAK_ALPHABETIC: GUnicodeBreakType = 23;
pub const GUnicodeBreakType_G_UNICODE_BREAK_PREFIX: GUnicodeBreakType = 24;
pub const GUnicodeBreakType_G_UNICODE_BREAK_POSTFIX: GUnicodeBreakType = 25;
pub const GUnicodeBreakType_G_UNICODE_BREAK_COMPLEX_CONTEXT: GUnicodeBreakType = 26;
pub const GUnicodeBreakType_G_UNICODE_BREAK_AMBIGUOUS: GUnicodeBreakType = 27;
pub const GUnicodeBreakType_G_UNICODE_BREAK_UNKNOWN: GUnicodeBreakType = 28;
pub const GUnicodeBreakType_G_UNICODE_BREAK_NEXT_LINE: GUnicodeBreakType = 29;
pub const GUnicodeBreakType_G_UNICODE_BREAK_WORD_JOINER: GUnicodeBreakType = 30;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_L_JAMO: GUnicodeBreakType = 31;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_V_JAMO: GUnicodeBreakType = 32;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_T_JAMO: GUnicodeBreakType = 33;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_LV_SYLLABLE: GUnicodeBreakType = 34;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE: GUnicodeBreakType = 35;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CLOSE_PARANTHESIS: GUnicodeBreakType = 36;
pub const GUnicodeBreakType_G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER: GUnicodeBreakType = 37;
pub const GUnicodeBreakType_G_UNICODE_BREAK_HEBREW_LETTER: GUnicodeBreakType = 38;
pub const GUnicodeBreakType_G_UNICODE_BREAK_REGIONAL_INDICATOR: GUnicodeBreakType = 39;
pub const GUnicodeBreakType_G_UNICODE_BREAK_EMOJI_BASE: GUnicodeBreakType = 40;
pub const GUnicodeBreakType_G_UNICODE_BREAK_EMOJI_MODIFIER: GUnicodeBreakType = 41;
pub const GUnicodeBreakType_G_UNICODE_BREAK_ZERO_WIDTH_JOINER: GUnicodeBreakType = 42;
#[doc = " GUnicodeBreakType:"]
#[doc = " @G_UNICODE_BREAK_MANDATORY: Mandatory Break (BK)"]
#[doc = " @G_UNICODE_BREAK_CARRIAGE_RETURN: Carriage Return (CR)"]
#[doc = " @G_UNICODE_BREAK_LINE_FEED: Line Feed (LF)"]
#[doc = " @G_UNICODE_BREAK_COMBINING_MARK: Attached Characters and Combining Marks (CM)"]
#[doc = " @G_UNICODE_BREAK_SURROGATE: Surrogates (SG)"]
#[doc = " @G_UNICODE_BREAK_ZERO_WIDTH_SPACE: Zero Width Space (ZW)"]
#[doc = " @G_UNICODE_BREAK_INSEPARABLE: Inseparable (IN)"]
#[doc = " @G_UNICODE_BREAK_NON_BREAKING_GLUE: Non-breaking (\"Glue\") (GL)"]
#[doc = " @G_UNICODE_BREAK_CONTINGENT: Contingent Break Opportunity (CB)"]
#[doc = " @G_UNICODE_BREAK_SPACE: Space (SP)"]
#[doc = " @G_UNICODE_BREAK_AFTER: Break Opportunity After (BA)"]
#[doc = " @G_UNICODE_BREAK_BEFORE: Break Opportunity Before (BB)"]
#[doc = " @G_UNICODE_BREAK_BEFORE_AND_AFTER: Break Opportunity Before and After (B2)"]
#[doc = " @G_UNICODE_BREAK_HYPHEN: Hyphen (HY)"]
#[doc = " @G_UNICODE_BREAK_NON_STARTER: Nonstarter (NS)"]
#[doc = " @G_UNICODE_BREAK_OPEN_PUNCTUATION: Opening Punctuation (OP)"]
#[doc = " @G_UNICODE_BREAK_CLOSE_PUNCTUATION: Closing Punctuation (CL)"]
#[doc = " @G_UNICODE_BREAK_QUOTATION: Ambiguous Quotation (QU)"]
#[doc = " @G_UNICODE_BREAK_EXCLAMATION: Exclamation/Interrogation (EX)"]
#[doc = " @G_UNICODE_BREAK_IDEOGRAPHIC: Ideographic (ID)"]
#[doc = " @G_UNICODE_BREAK_NUMERIC: Numeric (NU)"]
#[doc = " @G_UNICODE_BREAK_INFIX_SEPARATOR: Infix Separator (Numeric) (IS)"]
#[doc = " @G_UNICODE_BREAK_SYMBOL: Symbols Allowing Break After (SY)"]
#[doc = " @G_UNICODE_BREAK_ALPHABETIC: Ordinary Alphabetic and Symbol Characters (AL)"]
#[doc = " @G_UNICODE_BREAK_PREFIX: Prefix (Numeric) (PR)"]
#[doc = " @G_UNICODE_BREAK_POSTFIX: Postfix (Numeric) (PO)"]
#[doc = " @G_UNICODE_BREAK_COMPLEX_CONTEXT: Complex Content Dependent (South East Asian) (SA)"]
#[doc = " @G_UNICODE_BREAK_AMBIGUOUS: Ambiguous (Alphabetic or Ideographic) (AI)"]
#[doc = " @G_UNICODE_BREAK_UNKNOWN: Unknown (XX)"]
#[doc = " @G_UNICODE_BREAK_NEXT_LINE: Next Line (NL)"]
#[doc = " @G_UNICODE_BREAK_WORD_JOINER: Word Joiner (WJ)"]
#[doc = " @G_UNICODE_BREAK_HANGUL_L_JAMO: Hangul L Jamo (JL)"]
#[doc = " @G_UNICODE_BREAK_HANGUL_V_JAMO: Hangul V Jamo (JV)"]
#[doc = " @G_UNICODE_BREAK_HANGUL_T_JAMO: Hangul T Jamo (JT)"]
#[doc = " @G_UNICODE_BREAK_HANGUL_LV_SYLLABLE: Hangul LV Syllable (H2)"]
#[doc = " @G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE: Hangul LVT Syllable (H3)"]
#[doc = " @G_UNICODE_BREAK_CLOSE_PARANTHESIS: Closing Parenthesis (CP). Since 2.28"]
#[doc = " @G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER: Conditional Japanese Starter (CJ). Since: 2.32"]
#[doc = " @G_UNICODE_BREAK_HEBREW_LETTER: Hebrew Letter (HL). Since: 2.32"]
#[doc = " @G_UNICODE_BREAK_REGIONAL_INDICATOR: Regional Indicator (RI). Since: 2.36"]
#[doc = " @G_UNICODE_BREAK_EMOJI_BASE: Emoji Base (EB). Since: 2.50"]
#[doc = " @G_UNICODE_BREAK_EMOJI_MODIFIER: Emoji Modifier (EM). Since: 2.50"]
#[doc = " @G_UNICODE_BREAK_ZERO_WIDTH_JOINER: Zero Width Joiner (ZWJ). Since: 2.50"]
#[doc = ""]
#[doc = " These are the possible line break classifications."]
#[doc = ""]
#[doc = " Since new unicode versions may add new types here, applications should be ready"]
#[doc = " to handle unknown values. They may be regarded as %G_UNICODE_BREAK_UNKNOWN."]
#[doc = ""]
#[doc = " See [Unicode Line Breaking Algorithm](http://www.unicode.org/unicode/reports/tr14/)."]
pub type GUnicodeBreakType = ::std::os::raw::c_uint;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INVALID_CODE: GUnicodeScript = -1;
pub const GUnicodeScript_G_UNICODE_SCRIPT_COMMON: GUnicodeScript = 0;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INHERITED: GUnicodeScript = 1;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ARABIC: GUnicodeScript = 2;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ARMENIAN: GUnicodeScript = 3;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BENGALI: GUnicodeScript = 4;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BOPOMOFO: GUnicodeScript = 5;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CHEROKEE: GUnicodeScript = 6;
pub const GUnicodeScript_G_UNICODE_SCRIPT_COPTIC: GUnicodeScript = 7;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CYRILLIC: GUnicodeScript = 8;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DESERET: GUnicodeScript = 9;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DEVANAGARI: GUnicodeScript = 10;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ETHIOPIC: GUnicodeScript = 11;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GEORGIAN: GUnicodeScript = 12;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GOTHIC: GUnicodeScript = 13;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GREEK: GUnicodeScript = 14;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GUJARATI: GUnicodeScript = 15;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GURMUKHI: GUnicodeScript = 16;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HAN: GUnicodeScript = 17;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HANGUL: GUnicodeScript = 18;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HEBREW: GUnicodeScript = 19;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HIRAGANA: GUnicodeScript = 20;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KANNADA: GUnicodeScript = 21;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KATAKANA: GUnicodeScript = 22;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHMER: GUnicodeScript = 23;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LAO: GUnicodeScript = 24;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LATIN: GUnicodeScript = 25;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MALAYALAM: GUnicodeScript = 26;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MONGOLIAN: GUnicodeScript = 27;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MYANMAR: GUnicodeScript = 28;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OGHAM: GUnicodeScript = 29;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_ITALIC: GUnicodeScript = 30;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ORIYA: GUnicodeScript = 31;
pub const GUnicodeScript_G_UNICODE_SCRIPT_RUNIC: GUnicodeScript = 32;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SINHALA: GUnicodeScript = 33;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SYRIAC: GUnicodeScript = 34;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAMIL: GUnicodeScript = 35;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TELUGU: GUnicodeScript = 36;
pub const GUnicodeScript_G_UNICODE_SCRIPT_THAANA: GUnicodeScript = 37;
pub const GUnicodeScript_G_UNICODE_SCRIPT_THAI: GUnicodeScript = 38;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TIBETAN: GUnicodeScript = 39;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL: GUnicodeScript = 40;
pub const GUnicodeScript_G_UNICODE_SCRIPT_YI: GUnicodeScript = 41;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAGALOG: GUnicodeScript = 42;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HANUNOO: GUnicodeScript = 43;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BUHID: GUnicodeScript = 44;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAGBANWA: GUnicodeScript = 45;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BRAILLE: GUnicodeScript = 46;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CYPRIOT: GUnicodeScript = 47;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LIMBU: GUnicodeScript = 48;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OSMANYA: GUnicodeScript = 49;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SHAVIAN: GUnicodeScript = 50;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LINEAR_B: GUnicodeScript = 51;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAI_LE: GUnicodeScript = 52;
pub const GUnicodeScript_G_UNICODE_SCRIPT_UGARITIC: GUnicodeScript = 53;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NEW_TAI_LUE: GUnicodeScript = 54;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BUGINESE: GUnicodeScript = 55;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GLAGOLITIC: GUnicodeScript = 56;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TIFINAGH: GUnicodeScript = 57;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SYLOTI_NAGRI: GUnicodeScript = 58;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_PERSIAN: GUnicodeScript = 59;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHAROSHTHI: GUnicodeScript = 60;
pub const GUnicodeScript_G_UNICODE_SCRIPT_UNKNOWN: GUnicodeScript = 61;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BALINESE: GUnicodeScript = 62;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CUNEIFORM: GUnicodeScript = 63;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PHOENICIAN: GUnicodeScript = 64;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PHAGS_PA: GUnicodeScript = 65;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NKO: GUnicodeScript = 66;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KAYAH_LI: GUnicodeScript = 67;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LEPCHA: GUnicodeScript = 68;
pub const GUnicodeScript_G_UNICODE_SCRIPT_REJANG: GUnicodeScript = 69;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SUNDANESE: GUnicodeScript = 70;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SAURASHTRA: GUnicodeScript = 71;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CHAM: GUnicodeScript = 72;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OL_CHIKI: GUnicodeScript = 73;
pub const GUnicodeScript_G_UNICODE_SCRIPT_VAI: GUnicodeScript = 74;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CARIAN: GUnicodeScript = 75;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LYCIAN: GUnicodeScript = 76;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LYDIAN: GUnicodeScript = 77;
pub const GUnicodeScript_G_UNICODE_SCRIPT_AVESTAN: GUnicodeScript = 78;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BAMUM: GUnicodeScript = 79;
pub const GUnicodeScript_G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS: GUnicodeScript = 80;
pub const GUnicodeScript_G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC: GUnicodeScript = 81;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI: GUnicodeScript = 82;
pub const GUnicodeScript_G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN: GUnicodeScript = 83;
pub const GUnicodeScript_G_UNICODE_SCRIPT_JAVANESE: GUnicodeScript = 84;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KAITHI: GUnicodeScript = 85;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LISU: GUnicodeScript = 86;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEETEI_MAYEK: GUnicodeScript = 87;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN: GUnicodeScript = 88;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_TURKIC: GUnicodeScript = 89;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SAMARITAN: GUnicodeScript = 90;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAI_THAM: GUnicodeScript = 91;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAI_VIET: GUnicodeScript = 92;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BATAK: GUnicodeScript = 93;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BRAHMI: GUnicodeScript = 94;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MANDAIC: GUnicodeScript = 95;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CHAKMA: GUnicodeScript = 96;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEROITIC_CURSIVE: GUnicodeScript = 97;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS: GUnicodeScript = 98;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MIAO: GUnicodeScript = 99;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SHARADA: GUnicodeScript = 100;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SORA_SOMPENG: GUnicodeScript = 101;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TAKRI: GUnicodeScript = 102;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BASSA_VAH: GUnicodeScript = 103;
pub const GUnicodeScript_G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN: GUnicodeScript = 104;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DUPLOYAN: GUnicodeScript = 105;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ELBASAN: GUnicodeScript = 106;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GRANTHA: GUnicodeScript = 107;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHOJKI: GUnicodeScript = 108;
pub const GUnicodeScript_G_UNICODE_SCRIPT_KHUDAWADI: GUnicodeScript = 109;
pub const GUnicodeScript_G_UNICODE_SCRIPT_LINEAR_A: GUnicodeScript = 110;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MAHAJANI: GUnicodeScript = 111;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MANICHAEAN: GUnicodeScript = 112;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MENDE_KIKAKUI: GUnicodeScript = 113;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MODI: GUnicodeScript = 114;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MRO: GUnicodeScript = 115;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NABATAEAN: GUnicodeScript = 116;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN: GUnicodeScript = 117;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_PERMIC: GUnicodeScript = 118;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PAHAWH_HMONG: GUnicodeScript = 119;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PALMYRENE: GUnicodeScript = 120;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PAU_CIN_HAU: GUnicodeScript = 121;
pub const GUnicodeScript_G_UNICODE_SCRIPT_PSALTER_PAHLAVI: GUnicodeScript = 122;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SIDDHAM: GUnicodeScript = 123;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TIRHUTA: GUnicodeScript = 124;
pub const GUnicodeScript_G_UNICODE_SCRIPT_WARANG_CITI: GUnicodeScript = 125;
pub const GUnicodeScript_G_UNICODE_SCRIPT_AHOM: GUnicodeScript = 126;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS: GUnicodeScript = 127;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HATRAN: GUnicodeScript = 128;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MULTANI: GUnicodeScript = 129;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_HUNGARIAN: GUnicodeScript = 130;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SIGNWRITING: GUnicodeScript = 131;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ADLAM: GUnicodeScript = 132;
pub const GUnicodeScript_G_UNICODE_SCRIPT_BHAIKSUKI: GUnicodeScript = 133;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MARCHEN: GUnicodeScript = 134;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NEWA: GUnicodeScript = 135;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OSAGE: GUnicodeScript = 136;
pub const GUnicodeScript_G_UNICODE_SCRIPT_TANGUT: GUnicodeScript = 137;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MASARAM_GONDI: GUnicodeScript = 138;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NUSHU: GUnicodeScript = 139;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SOYOMBO: GUnicodeScript = 140;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ZANABAZAR_SQUARE: GUnicodeScript = 141;
pub const GUnicodeScript_G_UNICODE_SCRIPT_DOGRA: GUnicodeScript = 142;
pub const GUnicodeScript_G_UNICODE_SCRIPT_GUNJALA_GONDI: GUnicodeScript = 143;
pub const GUnicodeScript_G_UNICODE_SCRIPT_HANIFI_ROHINGYA: GUnicodeScript = 144;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MAKASAR: GUnicodeScript = 145;
pub const GUnicodeScript_G_UNICODE_SCRIPT_MEDEFAIDRIN: GUnicodeScript = 146;
pub const GUnicodeScript_G_UNICODE_SCRIPT_OLD_SOGDIAN: GUnicodeScript = 147;
pub const GUnicodeScript_G_UNICODE_SCRIPT_SOGDIAN: GUnicodeScript = 148;
pub const GUnicodeScript_G_UNICODE_SCRIPT_ELYMAIC: GUnicodeScript = 149;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NANDINAGARI: GUnicodeScript = 150;
pub const GUnicodeScript_G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG: GUnicodeScript = 151;
pub const GUnicodeScript_G_UNICODE_SCRIPT_WANCHO: GUnicodeScript = 152;
#[doc = " GUnicodeScript:"]
#[doc = " @G_UNICODE_SCRIPT_INVALID_CODE:"]
#[doc = "                               a value never returned from g_unichar_get_script()"]
#[doc = " @G_UNICODE_SCRIPT_COMMON:     a character used by multiple different scripts"]
#[doc = " @G_UNICODE_SCRIPT_INHERITED:  a mark glyph that takes its script from the"]
#[doc = "                               base glyph to which it is attached"]
#[doc = " @G_UNICODE_SCRIPT_ARABIC:     Arabic"]
#[doc = " @G_UNICODE_SCRIPT_ARMENIAN:   Armenian"]
#[doc = " @G_UNICODE_SCRIPT_BENGALI:    Bengali"]
#[doc = " @G_UNICODE_SCRIPT_BOPOMOFO:   Bopomofo"]
#[doc = " @G_UNICODE_SCRIPT_CHEROKEE:   Cherokee"]
#[doc = " @G_UNICODE_SCRIPT_COPTIC:     Coptic"]
#[doc = " @G_UNICODE_SCRIPT_CYRILLIC:   Cyrillic"]
#[doc = " @G_UNICODE_SCRIPT_DESERET:    Deseret"]
#[doc = " @G_UNICODE_SCRIPT_DEVANAGARI: Devanagari"]
#[doc = " @G_UNICODE_SCRIPT_ETHIOPIC:   Ethiopic"]
#[doc = " @G_UNICODE_SCRIPT_GEORGIAN:   Georgian"]
#[doc = " @G_UNICODE_SCRIPT_GOTHIC:     Gothic"]
#[doc = " @G_UNICODE_SCRIPT_GREEK:      Greek"]
#[doc = " @G_UNICODE_SCRIPT_GUJARATI:   Gujarati"]
#[doc = " @G_UNICODE_SCRIPT_GURMUKHI:   Gurmukhi"]
#[doc = " @G_UNICODE_SCRIPT_HAN:        Han"]
#[doc = " @G_UNICODE_SCRIPT_HANGUL:     Hangul"]
#[doc = " @G_UNICODE_SCRIPT_HEBREW:     Hebrew"]
#[doc = " @G_UNICODE_SCRIPT_HIRAGANA:   Hiragana"]
#[doc = " @G_UNICODE_SCRIPT_KANNADA:    Kannada"]
#[doc = " @G_UNICODE_SCRIPT_KATAKANA:   Katakana"]
#[doc = " @G_UNICODE_SCRIPT_KHMER:      Khmer"]
#[doc = " @G_UNICODE_SCRIPT_LAO:        Lao"]
#[doc = " @G_UNICODE_SCRIPT_LATIN:      Latin"]
#[doc = " @G_UNICODE_SCRIPT_MALAYALAM:  Malayalam"]
#[doc = " @G_UNICODE_SCRIPT_MONGOLIAN:  Mongolian"]
#[doc = " @G_UNICODE_SCRIPT_MYANMAR:    Myanmar"]
#[doc = " @G_UNICODE_SCRIPT_OGHAM:      Ogham"]
#[doc = " @G_UNICODE_SCRIPT_OLD_ITALIC: Old Italic"]
#[doc = " @G_UNICODE_SCRIPT_ORIYA:      Oriya"]
#[doc = " @G_UNICODE_SCRIPT_RUNIC:      Runic"]
#[doc = " @G_UNICODE_SCRIPT_SINHALA:    Sinhala"]
#[doc = " @G_UNICODE_SCRIPT_SYRIAC:     Syriac"]
#[doc = " @G_UNICODE_SCRIPT_TAMIL:      Tamil"]
#[doc = " @G_UNICODE_SCRIPT_TELUGU:     Telugu"]
#[doc = " @G_UNICODE_SCRIPT_THAANA:     Thaana"]
#[doc = " @G_UNICODE_SCRIPT_THAI:       Thai"]
#[doc = " @G_UNICODE_SCRIPT_TIBETAN:    Tibetan"]
#[doc = " @G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL:"]
#[doc = "                               Canadian Aboriginal"]
#[doc = " @G_UNICODE_SCRIPT_YI:         Yi"]
#[doc = " @G_UNICODE_SCRIPT_TAGALOG:    Tagalog"]
#[doc = " @G_UNICODE_SCRIPT_HANUNOO:    Hanunoo"]
#[doc = " @G_UNICODE_SCRIPT_BUHID:      Buhid"]
#[doc = " @G_UNICODE_SCRIPT_TAGBANWA:   Tagbanwa"]
#[doc = " @G_UNICODE_SCRIPT_BRAILLE:    Braille"]
#[doc = " @G_UNICODE_SCRIPT_CYPRIOT:    Cypriot"]
#[doc = " @G_UNICODE_SCRIPT_LIMBU:      Limbu"]
#[doc = " @G_UNICODE_SCRIPT_OSMANYA:    Osmanya"]
#[doc = " @G_UNICODE_SCRIPT_SHAVIAN:    Shavian"]
#[doc = " @G_UNICODE_SCRIPT_LINEAR_B:   Linear B"]
#[doc = " @G_UNICODE_SCRIPT_TAI_LE:     Tai Le"]
#[doc = " @G_UNICODE_SCRIPT_UGARITIC:   Ugaritic"]
#[doc = " @G_UNICODE_SCRIPT_NEW_TAI_LUE:"]
#[doc = "                               New Tai Lue"]
#[doc = " @G_UNICODE_SCRIPT_BUGINESE:   Buginese"]
#[doc = " @G_UNICODE_SCRIPT_GLAGOLITIC: Glagolitic"]
#[doc = " @G_UNICODE_SCRIPT_TIFINAGH:   Tifinagh"]
#[doc = " @G_UNICODE_SCRIPT_SYLOTI_NAGRI:"]
#[doc = "                               Syloti Nagri"]
#[doc = " @G_UNICODE_SCRIPT_OLD_PERSIAN:"]
#[doc = "                               Old Persian"]
#[doc = " @G_UNICODE_SCRIPT_KHAROSHTHI: Kharoshthi"]
#[doc = " @G_UNICODE_SCRIPT_UNKNOWN:    an unassigned code point"]
#[doc = " @G_UNICODE_SCRIPT_BALINESE:   Balinese"]
#[doc = " @G_UNICODE_SCRIPT_CUNEIFORM:  Cuneiform"]
#[doc = " @G_UNICODE_SCRIPT_PHOENICIAN: Phoenician"]
#[doc = " @G_UNICODE_SCRIPT_PHAGS_PA:   Phags-pa"]
#[doc = " @G_UNICODE_SCRIPT_NKO:        N'Ko"]
#[doc = " @G_UNICODE_SCRIPT_KAYAH_LI:   Kayah Li. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_LEPCHA:     Lepcha. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_REJANG:     Rejang. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_SUNDANESE:  Sundanese. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_SAURASHTRA: Saurashtra. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_CHAM:       Cham. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_OL_CHIKI:   Ol Chiki. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_VAI:        Vai. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_CARIAN:     Carian. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_LYCIAN:     Lycian. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_LYDIAN:     Lydian. Since 2.16.3"]
#[doc = " @G_UNICODE_SCRIPT_AVESTAN:    Avestan. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_BAMUM:      Bamum. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS:"]
#[doc = "                               Egyptian Hieroglpyhs. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC:"]
#[doc = "                               Imperial Aramaic. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI:"]
#[doc = "                               Inscriptional Pahlavi. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN:"]
#[doc = "                               Inscriptional Parthian. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_JAVANESE:   Javanese. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_KAITHI:     Kaithi. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_LISU:       Lisu. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_MEETEI_MAYEK:"]
#[doc = "                               Meetei Mayek. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN:"]
#[doc = "                               Old South Arabian. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_OLD_TURKIC: Old Turkic. Since 2.28"]
#[doc = " @G_UNICODE_SCRIPT_SAMARITAN:  Samaritan. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_TAI_THAM:   Tai Tham. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_TAI_VIET:   Tai Viet. Since 2.26"]
#[doc = " @G_UNICODE_SCRIPT_BATAK:      Batak. Since 2.28"]
#[doc = " @G_UNICODE_SCRIPT_BRAHMI:     Brahmi. Since 2.28"]
#[doc = " @G_UNICODE_SCRIPT_MANDAIC:    Mandaic. Since 2.28"]
#[doc = " @G_UNICODE_SCRIPT_CHAKMA:               Chakma. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_MEROITIC_CURSIVE:     Meroitic Cursive. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS: Meroitic Hieroglyphs. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_MIAO:                 Miao. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_SHARADA:              Sharada. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_SORA_SOMPENG:         Sora Sompeng. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_TAKRI:                Takri. Since: 2.32"]
#[doc = " @G_UNICODE_SCRIPT_BASSA_VAH:            Bassa. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN:   Caucasian Albanian. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_DUPLOYAN:             Duployan. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_ELBASAN:              Elbasan. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_GRANTHA:              Grantha. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_KHOJKI:               Kjohki. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_KHUDAWADI:            Khudawadi, Sindhi. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_LINEAR_A:             Linear A. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_MAHAJANI:             Mahajani. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_MANICHAEAN:           Manichaean. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_MENDE_KIKAKUI:        Mende Kikakui. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_MODI:                 Modi. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_MRO:                  Mro. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_NABATAEAN:            Nabataean. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN:    Old North Arabian. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_OLD_PERMIC:           Old Permic. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_PAHAWH_HMONG:         Pahawh Hmong. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_PALMYRENE:            Palmyrene. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_PAU_CIN_HAU:          Pau Cin Hau. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_PSALTER_PAHLAVI:      Psalter Pahlavi. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_SIDDHAM:              Siddham. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_TIRHUTA:              Tirhuta. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_WARANG_CITI:          Warang Citi. Since: 2.42"]
#[doc = " @G_UNICODE_SCRIPT_AHOM:                 Ahom. Since: 2.48"]
#[doc = " @G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS: Anatolian Hieroglyphs. Since: 2.48"]
#[doc = " @G_UNICODE_SCRIPT_HATRAN:               Hatran. Since: 2.48"]
#[doc = " @G_UNICODE_SCRIPT_MULTANI:              Multani. Since: 2.48"]
#[doc = " @G_UNICODE_SCRIPT_OLD_HUNGARIAN:        Old Hungarian. Since: 2.48"]
#[doc = " @G_UNICODE_SCRIPT_SIGNWRITING:          Signwriting. Since: 2.48"]
#[doc = " @G_UNICODE_SCRIPT_ADLAM:                Adlam. Since: 2.50"]
#[doc = " @G_UNICODE_SCRIPT_BHAIKSUKI:            Bhaiksuki. Since: 2.50"]
#[doc = " @G_UNICODE_SCRIPT_MARCHEN:              Marchen. Since: 2.50"]
#[doc = " @G_UNICODE_SCRIPT_NEWA:                 Newa. Since: 2.50"]
#[doc = " @G_UNICODE_SCRIPT_OSAGE:                Osage. Since: 2.50"]
#[doc = " @G_UNICODE_SCRIPT_TANGUT:               Tangut. Since: 2.50"]
#[doc = " @G_UNICODE_SCRIPT_MASARAM_GONDI:        Masaram Gondi. Since: 2.54"]
#[doc = " @G_UNICODE_SCRIPT_NUSHU:                Nushu. Since: 2.54"]
#[doc = " @G_UNICODE_SCRIPT_SOYOMBO:              Soyombo. Since: 2.54"]
#[doc = " @G_UNICODE_SCRIPT_ZANABAZAR_SQUARE:     Zanabazar Square. Since: 2.54"]
#[doc = " @G_UNICODE_SCRIPT_DOGRA:                Dogra. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_GUNJALA_GONDI:        Gunjala Gondi. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_HANIFI_ROHINGYA:      Hanifi Rohingya. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_MAKASAR:              Makasar. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_MEDEFAIDRIN:          Medefaidrin. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_OLD_SOGDIAN:          Old Sogdian. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_SOGDIAN:              Sogdian. Since: 2.58"]
#[doc = " @G_UNICODE_SCRIPT_ELYMAIC:              Elym. Since: 2.62"]
#[doc = " @G_UNICODE_SCRIPT_NANDINAGARI:          Nand. Since: 2.62"]
#[doc = " @G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG: Rohg. Since: 2.62"]
#[doc = " @G_UNICODE_SCRIPT_WANCHO:               Wcho. Since: 2.62"]
#[doc = ""]
#[doc = " The #GUnicodeScript enumeration identifies different writing"]
#[doc = " systems. The values correspond to the names as defined in the"]
#[doc = " Unicode standard. The enumeration has been added in GLib 2.14,"]
#[doc = " and is interchangeable with #PangoScript."]
#[doc = ""]
#[doc = " Note that new types may be added in the future. Applications"]
#[doc = " should be ready to handle unknown values."]
#[doc = " See [Unicode Standard Annex #24: Script names](http://www.unicode.org/reports/tr24/)."]
pub type GUnicodeScript = ::std::os::raw::c_int;
extern "C" {
    pub fn g_unicode_script_to_iso15924(script: GUnicodeScript) -> guint32;
}
extern "C" {
    pub fn g_unicode_script_from_iso15924(iso15924: guint32) -> GUnicodeScript;
}
extern "C" {
    pub fn g_unichar_isalnum(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isalpha(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iscntrl(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isdigit(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isgraph(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_islower(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isprint(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_ispunct(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isspace(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isupper(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isxdigit(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_istitle(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_isdefined(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iswide(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iswide_cjk(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_iszerowidth(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_ismark(c: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_toupper(c: gunichar) -> gunichar;
}
extern "C" {
    pub fn g_unichar_tolower(c: gunichar) -> gunichar;
}
extern "C" {
    pub fn g_unichar_totitle(c: gunichar) -> gunichar;
}
extern "C" {
    pub fn g_unichar_digit_value(c: gunichar) -> gint;
}
extern "C" {
    pub fn g_unichar_xdigit_value(c: gunichar) -> gint;
}
extern "C" {
    pub fn g_unichar_type(c: gunichar) -> GUnicodeType;
}
extern "C" {
    pub fn g_unichar_break_type(c: gunichar) -> GUnicodeBreakType;
}
extern "C" {
    pub fn g_unichar_combining_class(uc: gunichar) -> gint;
}
extern "C" {
    pub fn g_unichar_get_mirror_char(ch: gunichar, mirrored_ch: *mut gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_get_script(ch: gunichar) -> GUnicodeScript;
}
extern "C" {
    pub fn g_unichar_validate(ch: gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_compose(a: gunichar, b: gunichar, ch: *mut gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_decompose(ch: gunichar, a: *mut gunichar, b: *mut gunichar) -> gboolean;
}
extern "C" {
    pub fn g_unichar_fully_decompose(
        ch: gunichar,
        compat: gboolean,
        result: *mut gunichar,
        result_len: gsize,
    ) -> gsize;
}
extern "C" {
    pub fn g_unicode_canonical_ordering(string: *mut gunichar, len: gsize);
}
extern "C" {
    pub fn g_unicode_canonical_decomposition(ch: gunichar, result_len: *mut gsize)
        -> *mut gunichar;
}
extern "C" {
    pub static g_utf8_skip: *const gchar;
}
extern "C" {
    pub fn g_utf8_get_char(p: *const gchar) -> gunichar;
}
extern "C" {
    pub fn g_utf8_get_char_validated(p: *const gchar, max_len: gssize) -> gunichar;
}
extern "C" {
    pub fn g_utf8_offset_to_pointer(str_: *const gchar, offset: glong) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_pointer_to_offset(str_: *const gchar, pos: *const gchar) -> glong;
}
extern "C" {
    pub fn g_utf8_prev_char(p: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_find_next_char(p: *const gchar, end: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_find_prev_char(str_: *const gchar, p: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strlen(p: *const gchar, max: gssize) -> glong;
}
extern "C" {
    pub fn g_utf8_substring(str_: *const gchar, start_pos: glong, end_pos: glong) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strncpy(dest: *mut gchar, src: *const gchar, n: gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strchr(p: *const gchar, len: gssize, c: gunichar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strrchr(p: *const gchar, len: gssize, c: gunichar) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strreverse(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_to_utf16(
        str_: *const gchar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar2;
}
extern "C" {
    pub fn g_utf8_to_ucs4(
        str_: *const gchar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar;
}
extern "C" {
    pub fn g_utf8_to_ucs4_fast(
        str_: *const gchar,
        len: glong,
        items_written: *mut glong,
    ) -> *mut gunichar;
}
extern "C" {
    pub fn g_utf16_to_ucs4(
        str_: *const gunichar2,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar;
}
extern "C" {
    pub fn g_utf16_to_utf8(
        str_: *const gunichar2,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_ucs4_to_utf16(
        str_: *const gunichar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gunichar2;
}
extern "C" {
    pub fn g_ucs4_to_utf8(
        str_: *const gunichar,
        len: glong,
        items_read: *mut glong,
        items_written: *mut glong,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_unichar_to_utf8(c: gunichar, outbuf: *mut gchar) -> gint;
}
extern "C" {
    pub fn g_utf8_validate(str_: *const gchar, max_len: gssize, end: *mut *const gchar)
        -> gboolean;
}
extern "C" {
    pub fn g_utf8_validate_len(
        str_: *const gchar,
        max_len: gsize,
        end: *mut *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_utf8_strup(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_strdown(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_casefold(str_: *const gchar, len: gssize) -> *mut gchar;
}
pub const GNormalizeMode_G_NORMALIZE_DEFAULT: GNormalizeMode = 0;
pub const GNormalizeMode_G_NORMALIZE_NFD: GNormalizeMode = 0;
pub const GNormalizeMode_G_NORMALIZE_DEFAULT_COMPOSE: GNormalizeMode = 1;
pub const GNormalizeMode_G_NORMALIZE_NFC: GNormalizeMode = 1;
pub const GNormalizeMode_G_NORMALIZE_ALL: GNormalizeMode = 2;
pub const GNormalizeMode_G_NORMALIZE_NFKD: GNormalizeMode = 2;
pub const GNormalizeMode_G_NORMALIZE_ALL_COMPOSE: GNormalizeMode = 3;
pub const GNormalizeMode_G_NORMALIZE_NFKC: GNormalizeMode = 3;
#[doc = " GNormalizeMode:"]
#[doc = " @G_NORMALIZE_DEFAULT: standardize differences that do not affect the"]
#[doc = "     text content, such as the above-mentioned accent representation"]
#[doc = " @G_NORMALIZE_NFD: another name for %G_NORMALIZE_DEFAULT"]
#[doc = " @G_NORMALIZE_DEFAULT_COMPOSE: like %G_NORMALIZE_DEFAULT, but with"]
#[doc = "     composed forms rather than a maximally decomposed form"]
#[doc = " @G_NORMALIZE_NFC: another name for %G_NORMALIZE_DEFAULT_COMPOSE"]
#[doc = " @G_NORMALIZE_ALL: beyond %G_NORMALIZE_DEFAULT also standardize the"]
#[doc = "     \"compatibility\" characters in Unicode, such as SUPERSCRIPT THREE"]
#[doc = "     to the standard forms (in this case DIGIT THREE). Formatting"]
#[doc = "     information may be lost but for most text operations such"]
#[doc = "     characters should be considered the same"]
#[doc = " @G_NORMALIZE_NFKD: another name for %G_NORMALIZE_ALL"]
#[doc = " @G_NORMALIZE_ALL_COMPOSE: like %G_NORMALIZE_ALL, but with composed"]
#[doc = "     forms rather than a maximally decomposed form"]
#[doc = " @G_NORMALIZE_NFKC: another name for %G_NORMALIZE_ALL_COMPOSE"]
#[doc = ""]
#[doc = " Defines how a Unicode string is transformed in a canonical"]
#[doc = " form, standardizing such issues as whether a character with"]
#[doc = " an accent is represented as a base character and combining"]
#[doc = " accent or as a single precomposed character. Unicode strings"]
#[doc = " should generally be normalized before comparing them."]
pub type GNormalizeMode = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_utf8_normalize(str_: *const gchar, len: gssize, mode: GNormalizeMode) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_collate(str1: *const gchar, str2: *const gchar) -> gint;
}
extern "C" {
    pub fn g_utf8_collate_key(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_collate_key_for_filename(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_utf8_make_valid(str_: *const gchar, len: gssize) -> *mut gchar;
}
pub type GString = _GString;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GString {
    pub str_: *mut gchar,
    pub len: gsize,
    pub allocated_len: gsize,
}
extern "C" {
    pub fn g_string_new(init: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_new_len(init: *const gchar, len: gssize) -> *mut GString;
}
extern "C" {
    pub fn g_string_sized_new(dfl_size: gsize) -> *mut GString;
}
extern "C" {
    pub fn g_string_free(string: *mut GString, free_segment: gboolean) -> *mut gchar;
}
extern "C" {
    pub fn g_string_free_to_bytes(string: *mut GString) -> *mut GBytes;
}
extern "C" {
    pub fn g_string_equal(v: *const GString, v2: *const GString) -> gboolean;
}
extern "C" {
    pub fn g_string_hash(str_: *const GString) -> guint;
}
extern "C" {
    pub fn g_string_assign(string: *mut GString, rval: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_truncate(string: *mut GString, len: gsize) -> *mut GString;
}
extern "C" {
    pub fn g_string_set_size(string: *mut GString, len: gsize) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert_len(
        string: *mut GString,
        pos: gssize,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_append(string: *mut GString, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_append_len(
        string: *mut GString,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_append_c(string: *mut GString, c: gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_append_unichar(string: *mut GString, wc: gunichar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend(string: *mut GString, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend_c(string: *mut GString, c: gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend_unichar(string: *mut GString, wc: gunichar) -> *mut GString;
}
extern "C" {
    pub fn g_string_prepend_len(
        string: *mut GString,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert(string: *mut GString, pos: gssize, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert_c(string: *mut GString, pos: gssize, c: gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_insert_unichar(string: *mut GString, pos: gssize, wc: gunichar)
        -> *mut GString;
}
extern "C" {
    pub fn g_string_overwrite(string: *mut GString, pos: gsize, val: *const gchar) -> *mut GString;
}
extern "C" {
    pub fn g_string_overwrite_len(
        string: *mut GString,
        pos: gsize,
        val: *const gchar,
        len: gssize,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_erase(string: *mut GString, pos: gssize, len: gssize) -> *mut GString;
}
extern "C" {
    pub fn g_string_ascii_down(string: *mut GString) -> *mut GString;
}
extern "C" {
    pub fn g_string_ascii_up(string: *mut GString) -> *mut GString;
}
extern "C" {
    pub fn g_string_vprintf(string: *mut GString, format: *const gchar, args: *mut __va_list_tag);
}
extern "C" {
    pub fn g_string_printf(string: *mut GString, format: *const gchar, ...);
}
extern "C" {
    pub fn g_string_append_vprintf(
        string: *mut GString,
        format: *const gchar,
        args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_string_append_printf(string: *mut GString, format: *const gchar, ...);
}
extern "C" {
    pub fn g_string_append_uri_escaped(
        string: *mut GString,
        unescaped: *const gchar,
        reserved_chars_allowed: *const gchar,
        allow_utf8: gboolean,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_string_down(string: *mut GString) -> *mut GString;
}
extern "C" {
    pub fn g_string_up(string: *mut GString) -> *mut GString;
}
pub type GIOChannel = _GIOChannel;
pub type GIOFuncs = _GIOFuncs;
pub const GIOError_G_IO_ERROR_NONE: GIOError = 0;
pub const GIOError_G_IO_ERROR_AGAIN: GIOError = 1;
pub const GIOError_G_IO_ERROR_INVAL: GIOError = 2;
pub const GIOError_G_IO_ERROR_UNKNOWN: GIOError = 3;
pub type GIOError = ::std::os::raw::c_uint;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_FBIG: GIOChannelError = 0;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_INVAL: GIOChannelError = 1;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_IO: GIOChannelError = 2;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_ISDIR: GIOChannelError = 3;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_NOSPC: GIOChannelError = 4;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_NXIO: GIOChannelError = 5;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_OVERFLOW: GIOChannelError = 6;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_PIPE: GIOChannelError = 7;
pub const GIOChannelError_G_IO_CHANNEL_ERROR_FAILED: GIOChannelError = 8;
pub type GIOChannelError = ::std::os::raw::c_uint;
pub const GIOStatus_G_IO_STATUS_ERROR: GIOStatus = 0;
pub const GIOStatus_G_IO_STATUS_NORMAL: GIOStatus = 1;
pub const GIOStatus_G_IO_STATUS_EOF: GIOStatus = 2;
pub const GIOStatus_G_IO_STATUS_AGAIN: GIOStatus = 3;
pub type GIOStatus = ::std::os::raw::c_uint;
pub const GSeekType_G_SEEK_CUR: GSeekType = 0;
pub const GSeekType_G_SEEK_SET: GSeekType = 1;
pub const GSeekType_G_SEEK_END: GSeekType = 2;
pub type GSeekType = ::std::os::raw::c_uint;
pub const GIOFlags_G_IO_FLAG_APPEND: GIOFlags = 1;
pub const GIOFlags_G_IO_FLAG_NONBLOCK: GIOFlags = 2;
pub const GIOFlags_G_IO_FLAG_IS_READABLE: GIOFlags = 4;
pub const GIOFlags_G_IO_FLAG_IS_WRITABLE: GIOFlags = 8;
pub const GIOFlags_G_IO_FLAG_IS_WRITEABLE: GIOFlags = 8;
pub const GIOFlags_G_IO_FLAG_IS_SEEKABLE: GIOFlags = 16;
pub const GIOFlags_G_IO_FLAG_MASK: GIOFlags = 31;
pub const GIOFlags_G_IO_FLAG_GET_MASK: GIOFlags = 31;
pub const GIOFlags_G_IO_FLAG_SET_MASK: GIOFlags = 3;
pub type GIOFlags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOChannel {
    pub ref_count: gint,
    pub funcs: *mut GIOFuncs,
    pub encoding: *mut gchar,
    pub read_cd: GIConv,
    pub write_cd: GIConv,
    pub line_term: *mut gchar,
    pub line_term_len: guint,
    pub buf_size: gsize,
    pub read_buf: *mut GString,
    pub encoded_read_buf: *mut GString,
    pub write_buf: *mut GString,
    pub partial_write_buf: [gchar; 6usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub reserved1: gpointer,
    pub reserved2: gpointer,
}
impl _GIOChannel {
    #[inline]
    pub fn use_buffer(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_use_buffer(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn do_encode(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_do_encode(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn close_on_unref(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_close_on_unref(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_readable(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_readable(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_writeable(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_writeable(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_seekable(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_seekable(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        use_buffer: guint,
        do_encode: guint,
        close_on_unref: guint,
        is_readable: guint,
        is_writeable: guint,
        is_seekable: guint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let use_buffer: u32 = unsafe { ::std::mem::transmute(use_buffer) };
            use_buffer as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let do_encode: u32 = unsafe { ::std::mem::transmute(do_encode) };
            do_encode as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let close_on_unref: u32 = unsafe { ::std::mem::transmute(close_on_unref) };
            close_on_unref as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_readable: u32 = unsafe { ::std::mem::transmute(is_readable) };
            is_readable as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_writeable: u32 = unsafe { ::std::mem::transmute(is_writeable) };
            is_writeable as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_seekable: u32 = unsafe { ::std::mem::transmute(is_seekable) };
            is_seekable as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type GIOFunc = ::std::option::Option<
    unsafe extern "C" fn(
        source: *mut GIOChannel,
        condition: GIOCondition,
        data: gpointer,
    ) -> gboolean,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GIOFuncs {
    pub io_read: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            buf: *mut gchar,
            count: gsize,
            bytes_read: *mut gsize,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_write: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            buf: *const gchar,
            count: gsize,
            bytes_written: *mut gsize,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_seek: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            offset: gint64,
            type_: GSeekType,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_close: ::std::option::Option<
        unsafe extern "C" fn(channel: *mut GIOChannel, err: *mut *mut GError) -> GIOStatus,
    >,
    pub io_create_watch: ::std::option::Option<
        unsafe extern "C" fn(channel: *mut GIOChannel, condition: GIOCondition) -> *mut GSource,
    >,
    pub io_free: ::std::option::Option<unsafe extern "C" fn(channel: *mut GIOChannel)>,
    pub io_set_flags: ::std::option::Option<
        unsafe extern "C" fn(
            channel: *mut GIOChannel,
            flags: GIOFlags,
            err: *mut *mut GError,
        ) -> GIOStatus,
    >,
    pub io_get_flags:
        ::std::option::Option<unsafe extern "C" fn(channel: *mut GIOChannel) -> GIOFlags>,
}
extern "C" {
    pub fn g_io_channel_init(channel: *mut GIOChannel);
}
extern "C" {
    pub fn g_io_channel_ref(channel: *mut GIOChannel) -> *mut GIOChannel;
}
extern "C" {
    pub fn g_io_channel_unref(channel: *mut GIOChannel);
}
extern "C" {
    pub fn g_io_channel_read(
        channel: *mut GIOChannel,
        buf: *mut gchar,
        count: gsize,
        bytes_read: *mut gsize,
    ) -> GIOError;
}
extern "C" {
    pub fn g_io_channel_write(
        channel: *mut GIOChannel,
        buf: *const gchar,
        count: gsize,
        bytes_written: *mut gsize,
    ) -> GIOError;
}
extern "C" {
    pub fn g_io_channel_seek(
        channel: *mut GIOChannel,
        offset: gint64,
        type_: GSeekType,
    ) -> GIOError;
}
extern "C" {
    pub fn g_io_channel_close(channel: *mut GIOChannel);
}
extern "C" {
    pub fn g_io_channel_shutdown(
        channel: *mut GIOChannel,
        flush: gboolean,
        err: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_add_watch_full(
        channel: *mut GIOChannel,
        priority: gint,
        condition: GIOCondition,
        func: GIOFunc,
        user_data: gpointer,
        notify: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_io_create_watch(channel: *mut GIOChannel, condition: GIOCondition) -> *mut GSource;
}
extern "C" {
    pub fn g_io_add_watch(
        channel: *mut GIOChannel,
        condition: GIOCondition,
        func: GIOFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_io_channel_set_buffer_size(channel: *mut GIOChannel, size: gsize);
}
extern "C" {
    pub fn g_io_channel_get_buffer_size(channel: *mut GIOChannel) -> gsize;
}
extern "C" {
    pub fn g_io_channel_get_buffer_condition(channel: *mut GIOChannel) -> GIOCondition;
}
extern "C" {
    pub fn g_io_channel_set_flags(
        channel: *mut GIOChannel,
        flags: GIOFlags,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_get_flags(channel: *mut GIOChannel) -> GIOFlags;
}
extern "C" {
    pub fn g_io_channel_set_line_term(
        channel: *mut GIOChannel,
        line_term: *const gchar,
        length: gint,
    );
}
extern "C" {
    pub fn g_io_channel_get_line_term(channel: *mut GIOChannel, length: *mut gint) -> *const gchar;
}
extern "C" {
    pub fn g_io_channel_set_buffered(channel: *mut GIOChannel, buffered: gboolean);
}
extern "C" {
    pub fn g_io_channel_get_buffered(channel: *mut GIOChannel) -> gboolean;
}
extern "C" {
    pub fn g_io_channel_set_encoding(
        channel: *mut GIOChannel,
        encoding: *const gchar,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_get_encoding(channel: *mut GIOChannel) -> *const gchar;
}
extern "C" {
    pub fn g_io_channel_set_close_on_unref(channel: *mut GIOChannel, do_close: gboolean);
}
extern "C" {
    pub fn g_io_channel_get_close_on_unref(channel: *mut GIOChannel) -> gboolean;
}
extern "C" {
    pub fn g_io_channel_flush(channel: *mut GIOChannel, error: *mut *mut GError) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_line(
        channel: *mut GIOChannel,
        str_return: *mut *mut gchar,
        length: *mut gsize,
        terminator_pos: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_line_string(
        channel: *mut GIOChannel,
        buffer: *mut GString,
        terminator_pos: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_to_end(
        channel: *mut GIOChannel,
        str_return: *mut *mut gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_chars(
        channel: *mut GIOChannel,
        buf: *mut gchar,
        count: gsize,
        bytes_read: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_read_unichar(
        channel: *mut GIOChannel,
        thechar: *mut gunichar,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_write_chars(
        channel: *mut GIOChannel,
        buf: *const gchar,
        count: gssize,
        bytes_written: *mut gsize,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_write_unichar(
        channel: *mut GIOChannel,
        thechar: gunichar,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_seek_position(
        channel: *mut GIOChannel,
        offset: gint64,
        type_: GSeekType,
        error: *mut *mut GError,
    ) -> GIOStatus;
}
extern "C" {
    pub fn g_io_channel_new_file(
        filename: *const gchar,
        mode: *const gchar,
        error: *mut *mut GError,
    ) -> *mut GIOChannel;
}
extern "C" {
    pub fn g_io_channel_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_io_channel_error_from_errno(en: gint) -> GIOChannelError;
}
extern "C" {
    pub fn g_io_channel_unix_new(fd: ::std::os::raw::c_int) -> *mut GIOChannel;
}
extern "C" {
    pub fn g_io_channel_unix_get_fd(channel: *mut GIOChannel) -> gint;
}
extern "C" {
    pub static mut g_io_watch_funcs: GSourceFuncs;
}
pub const GKeyFileError_G_KEY_FILE_ERROR_UNKNOWN_ENCODING: GKeyFileError = 0;
pub const GKeyFileError_G_KEY_FILE_ERROR_PARSE: GKeyFileError = 1;
pub const GKeyFileError_G_KEY_FILE_ERROR_NOT_FOUND: GKeyFileError = 2;
pub const GKeyFileError_G_KEY_FILE_ERROR_KEY_NOT_FOUND: GKeyFileError = 3;
pub const GKeyFileError_G_KEY_FILE_ERROR_GROUP_NOT_FOUND: GKeyFileError = 4;
pub const GKeyFileError_G_KEY_FILE_ERROR_INVALID_VALUE: GKeyFileError = 5;
pub type GKeyFileError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_key_file_error_quark() -> GQuark;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GKeyFile {
    _unused: [u8; 0],
}
pub type GKeyFile = _GKeyFile;
pub const GKeyFileFlags_G_KEY_FILE_NONE: GKeyFileFlags = 0;
pub const GKeyFileFlags_G_KEY_FILE_KEEP_COMMENTS: GKeyFileFlags = 1;
pub const GKeyFileFlags_G_KEY_FILE_KEEP_TRANSLATIONS: GKeyFileFlags = 2;
pub type GKeyFileFlags = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_key_file_new() -> *mut GKeyFile;
}
extern "C" {
    pub fn g_key_file_ref(key_file: *mut GKeyFile) -> *mut GKeyFile;
}
extern "C" {
    pub fn g_key_file_unref(key_file: *mut GKeyFile);
}
extern "C" {
    pub fn g_key_file_free(key_file: *mut GKeyFile);
}
extern "C" {
    pub fn g_key_file_set_list_separator(key_file: *mut GKeyFile, separator: gchar);
}
extern "C" {
    pub fn g_key_file_load_from_file(
        key_file: *mut GKeyFile,
        file: *const gchar,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_data(
        key_file: *mut GKeyFile,
        data: *const gchar,
        length: gsize,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_bytes(
        key_file: *mut GKeyFile,
        bytes: *mut GBytes,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_dirs(
        key_file: *mut GKeyFile,
        file: *const gchar,
        search_dirs: *mut *const gchar,
        full_path: *mut *mut gchar,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_load_from_data_dirs(
        key_file: *mut GKeyFile,
        file: *const gchar,
        full_path: *mut *mut gchar,
        flags: GKeyFileFlags,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_to_data(
        key_file: *mut GKeyFile,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_save_to_file(
        key_file: *mut GKeyFile,
        filename: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_get_start_group(key_file: *mut GKeyFile) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_get_groups(key_file: *mut GKeyFile, length: *mut gsize) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_get_keys(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_has_group(key_file: *mut GKeyFile, group_name: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_key_file_has_key(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_get_value(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_value(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: *const gchar,
    );
}
extern "C" {
    pub fn g_key_file_get_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        string: *const gchar,
    );
}
extern "C" {
    pub fn g_key_file_get_locale_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_get_locale_for_key(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_locale_string(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        string: *const gchar,
    );
}
extern "C" {
    pub fn g_key_file_get_boolean(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_set_boolean(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gboolean,
    );
}
extern "C" {
    pub fn g_key_file_get_integer(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gint;
}
extern "C" {
    pub fn g_key_file_set_integer(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gint,
    );
}
extern "C" {
    pub fn g_key_file_get_int64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gint64;
}
extern "C" {
    pub fn g_key_file_set_int64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gint64,
    );
}
extern "C" {
    pub fn g_key_file_get_uint64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> guint64;
}
extern "C" {
    pub fn g_key_file_set_uint64(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: guint64,
    );
}
extern "C" {
    pub fn g_key_file_get_double(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gdouble;
}
extern "C" {
    pub fn g_key_file_set_double(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        value: gdouble,
    );
}
extern "C" {
    pub fn g_key_file_get_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *const *const gchar,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_locale_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_key_file_set_locale_string_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        locale: *const gchar,
        list: *const *const gchar,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_boolean_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gboolean;
}
extern "C" {
    pub fn g_key_file_set_boolean_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *mut gboolean,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_integer_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gint;
}
extern "C" {
    pub fn g_key_file_set_double_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *mut gdouble,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_get_double_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        length: *mut gsize,
        error: *mut *mut GError,
    ) -> *mut gdouble;
}
extern "C" {
    pub fn g_key_file_set_integer_list(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        list: *mut gint,
        length: gsize,
    );
}
extern "C" {
    pub fn g_key_file_set_comment(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        comment: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_get_comment(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_key_file_remove_comment(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_remove_key(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        key: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_key_file_remove_group(
        key_file: *mut GKeyFile,
        group_name: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMappedFile {
    _unused: [u8; 0],
}
pub type GMappedFile = _GMappedFile;
extern "C" {
    pub fn g_mapped_file_new(
        filename: *const gchar,
        writable: gboolean,
        error: *mut *mut GError,
    ) -> *mut GMappedFile;
}
extern "C" {
    pub fn g_mapped_file_new_from_fd(
        fd: gint,
        writable: gboolean,
        error: *mut *mut GError,
    ) -> *mut GMappedFile;
}
extern "C" {
    pub fn g_mapped_file_get_length(file: *mut GMappedFile) -> gsize;
}
extern "C" {
    pub fn g_mapped_file_get_contents(file: *mut GMappedFile) -> *mut gchar;
}
extern "C" {
    pub fn g_mapped_file_get_bytes(file: *mut GMappedFile) -> *mut GBytes;
}
extern "C" {
    pub fn g_mapped_file_ref(file: *mut GMappedFile) -> *mut GMappedFile;
}
extern "C" {
    pub fn g_mapped_file_unref(file: *mut GMappedFile);
}
extern "C" {
    pub fn g_mapped_file_free(file: *mut GMappedFile);
}
pub const GMarkupError_G_MARKUP_ERROR_BAD_UTF8: GMarkupError = 0;
pub const GMarkupError_G_MARKUP_ERROR_EMPTY: GMarkupError = 1;
pub const GMarkupError_G_MARKUP_ERROR_PARSE: GMarkupError = 2;
pub const GMarkupError_G_MARKUP_ERROR_UNKNOWN_ELEMENT: GMarkupError = 3;
pub const GMarkupError_G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE: GMarkupError = 4;
pub const GMarkupError_G_MARKUP_ERROR_INVALID_CONTENT: GMarkupError = 5;
pub const GMarkupError_G_MARKUP_ERROR_MISSING_ATTRIBUTE: GMarkupError = 6;
#[doc = " GMarkupError:"]
#[doc = " @G_MARKUP_ERROR_BAD_UTF8: text being parsed was not valid UTF-8"]
#[doc = " @G_MARKUP_ERROR_EMPTY: document contained nothing, or only whitespace"]
#[doc = " @G_MARKUP_ERROR_PARSE: document was ill-formed"]
#[doc = " @G_MARKUP_ERROR_UNKNOWN_ELEMENT: error should be set by #GMarkupParser"]
#[doc = "     functions; element wasn't known"]
#[doc = " @G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE: error should be set by #GMarkupParser"]
#[doc = "     functions; attribute wasn't known"]
#[doc = " @G_MARKUP_ERROR_INVALID_CONTENT: error should be set by #GMarkupParser"]
#[doc = "     functions; content was invalid"]
#[doc = " @G_MARKUP_ERROR_MISSING_ATTRIBUTE: error should be set by #GMarkupParser"]
#[doc = "     functions; a required attribute was missing"]
#[doc = ""]
#[doc = " Error codes returned by markup parsing."]
pub type GMarkupError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_markup_error_quark() -> GQuark;
}
pub const GMarkupParseFlags_G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG: GMarkupParseFlags = 1;
pub const GMarkupParseFlags_G_MARKUP_TREAT_CDATA_AS_TEXT: GMarkupParseFlags = 2;
pub const GMarkupParseFlags_G_MARKUP_PREFIX_ERROR_POSITION: GMarkupParseFlags = 4;
pub const GMarkupParseFlags_G_MARKUP_IGNORE_QUALIFIED: GMarkupParseFlags = 8;
#[doc = " GMarkupParseFlags:"]
#[doc = " @G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG: flag you should not use"]
#[doc = " @G_MARKUP_TREAT_CDATA_AS_TEXT: When this flag is set, CDATA marked"]
#[doc = "     sections are not passed literally to the @passthrough function of"]
#[doc = "     the parser. Instead, the content of the section (without the"]
#[doc = "     `<![CDATA[` and `]]>`) is"]
#[doc = "     passed to the @text function. This flag was added in GLib 2.12"]
#[doc = " @G_MARKUP_PREFIX_ERROR_POSITION: Normally errors caught by GMarkup"]
#[doc = "     itself have line/column information prefixed to them to let the"]
#[doc = "     caller know the location of the error. When this flag is set the"]
#[doc = "     location information is also prefixed to errors generated by the"]
#[doc = "     #GMarkupParser implementation functions"]
#[doc = " @G_MARKUP_IGNORE_QUALIFIED: Ignore (don't report) qualified"]
#[doc = "     attributes and tags, along with their contents.  A qualified"]
#[doc = "     attribute or tag is one that contains ':' in its name (ie: is in"]
#[doc = "     another namespace).  Since: 2.40."]
#[doc = ""]
#[doc = " Flags that affect the behaviour of the parser."]
pub type GMarkupParseFlags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMarkupParseContext {
    _unused: [u8; 0],
}
#[doc = " GMarkupParseContext:"]
#[doc = ""]
#[doc = " A parse context is used to parse a stream of bytes that"]
#[doc = " you expect to contain marked-up text."]
#[doc = ""]
#[doc = " See g_markup_parse_context_new(), #GMarkupParser, and so"]
#[doc = " on for more details."]
pub type GMarkupParseContext = _GMarkupParseContext;
pub type GMarkupParser = _GMarkupParser;
#[doc = " GMarkupParser:"]
#[doc = " @start_element: Callback to invoke when the opening tag of an element"]
#[doc = "     is seen. The callback's @attribute_names and @attribute_values parameters"]
#[doc = "     are %NULL-terminated."]
#[doc = " @end_element: Callback to invoke when the closing tag of an element"]
#[doc = "     is seen. Note that this is also called for empty tags like"]
#[doc = "     `<empty/>`."]
#[doc = " @text: Callback to invoke when some text is seen (text is always"]
#[doc = "     inside an element). Note that the text of an element may be spread"]
#[doc = "     over multiple calls of this function. If the"]
#[doc = "     %G_MARKUP_TREAT_CDATA_AS_TEXT flag is set, this function is also"]
#[doc = "     called for the content of CDATA marked sections."]
#[doc = " @passthrough: Callback to invoke for comments, processing instructions"]
#[doc = "     and doctype declarations; if you're re-writing the parsed document,"]
#[doc = "     write the passthrough text back out in the same position. If the"]
#[doc = "     %G_MARKUP_TREAT_CDATA_AS_TEXT flag is not set, this function is also"]
#[doc = "     called for CDATA marked sections."]
#[doc = " @error: Callback to invoke when an error occurs."]
#[doc = ""]
#[doc = " Any of the fields in #GMarkupParser can be %NULL, in which case they"]
#[doc = " will be ignored. Except for the @error function, any of these callbacks"]
#[doc = " can set an error; in particular the %G_MARKUP_ERROR_UNKNOWN_ELEMENT,"]
#[doc = " %G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, and %G_MARKUP_ERROR_INVALID_CONTENT"]
#[doc = " errors are intended to be set from these callbacks. If you set an error"]
#[doc = " from a callback, g_markup_parse_context_parse() will report that error"]
#[doc = " back to its caller."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMarkupParser {
    pub start_element: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            element_name: *const gchar,
            attribute_names: *mut *const gchar,
            attribute_values: *mut *const gchar,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub end_element: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            element_name: *const gchar,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub text: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            text: *const gchar,
            text_len: gsize,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub passthrough: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            passthrough_text: *const gchar,
            text_len: gsize,
            user_data: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub error: ::std::option::Option<
        unsafe extern "C" fn(
            context: *mut GMarkupParseContext,
            error: *mut GError,
            user_data: gpointer,
        ),
    >,
}
extern "C" {
    pub fn g_markup_parse_context_new(
        parser: *const GMarkupParser,
        flags: GMarkupParseFlags,
        user_data: gpointer,
        user_data_dnotify: GDestroyNotify,
    ) -> *mut GMarkupParseContext;
}
extern "C" {
    pub fn g_markup_parse_context_ref(
        context: *mut GMarkupParseContext,
    ) -> *mut GMarkupParseContext;
}
extern "C" {
    pub fn g_markup_parse_context_unref(context: *mut GMarkupParseContext);
}
extern "C" {
    pub fn g_markup_parse_context_free(context: *mut GMarkupParseContext);
}
extern "C" {
    pub fn g_markup_parse_context_parse(
        context: *mut GMarkupParseContext,
        text: *const gchar,
        text_len: gssize,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_markup_parse_context_push(
        context: *mut GMarkupParseContext,
        parser: *const GMarkupParser,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_markup_parse_context_pop(context: *mut GMarkupParseContext) -> gpointer;
}
extern "C" {
    pub fn g_markup_parse_context_end_parse(
        context: *mut GMarkupParseContext,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_markup_parse_context_get_element(context: *mut GMarkupParseContext) -> *const gchar;
}
extern "C" {
    pub fn g_markup_parse_context_get_element_stack(
        context: *mut GMarkupParseContext,
    ) -> *const GSList;
}
extern "C" {
    pub fn g_markup_parse_context_get_position(
        context: *mut GMarkupParseContext,
        line_number: *mut gint,
        char_number: *mut gint,
    );
}
extern "C" {
    pub fn g_markup_parse_context_get_user_data(context: *mut GMarkupParseContext) -> gpointer;
}
extern "C" {
    pub fn g_markup_escape_text(text: *const gchar, length: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_markup_printf_escaped(format: *const ::std::os::raw::c_char, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_markup_vprintf_escaped(
        format: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> *mut gchar;
}
pub const GMarkupCollectType_G_MARKUP_COLLECT_INVALID: GMarkupCollectType = 0;
pub const GMarkupCollectType_G_MARKUP_COLLECT_STRING: GMarkupCollectType = 1;
pub const GMarkupCollectType_G_MARKUP_COLLECT_STRDUP: GMarkupCollectType = 2;
pub const GMarkupCollectType_G_MARKUP_COLLECT_BOOLEAN: GMarkupCollectType = 3;
pub const GMarkupCollectType_G_MARKUP_COLLECT_TRISTATE: GMarkupCollectType = 4;
pub const GMarkupCollectType_G_MARKUP_COLLECT_OPTIONAL: GMarkupCollectType = 65536;
pub type GMarkupCollectType = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_markup_collect_attributes(
        element_name: *const gchar,
        attribute_names: *mut *const gchar,
        attribute_values: *mut *const gchar,
        error: *mut *mut GError,
        first_type: GMarkupCollectType,
        first_attr: *const gchar,
        ...
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariantType {
    _unused: [u8; 0],
}
#[doc = " GVariantType:"]
#[doc = ""]
#[doc = " A type in the GVariant type system."]
#[doc = ""]
#[doc = " Two types may not be compared by value; use g_variant_type_equal() or"]
#[doc = " g_variant_type_is_subtype_of().  May be copied using"]
#[doc = " g_variant_type_copy() and freed using g_variant_type_free()."]
pub type GVariantType = _GVariantType;
extern "C" {
    pub fn g_variant_type_string_is_valid(type_string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_string_scan(
        string: *const gchar,
        limit: *const gchar,
        endptr: *mut *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_free(type_: *mut GVariantType);
}
extern "C" {
    pub fn g_variant_type_copy(type_: *const GVariantType) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new(type_string: *const gchar) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_get_string_length(type_: *const GVariantType) -> gsize;
}
extern "C" {
    pub fn g_variant_type_peek_string(type_: *const GVariantType) -> *const gchar;
}
extern "C" {
    pub fn g_variant_type_dup_string(type_: *const GVariantType) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_type_is_definite(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_container(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_basic(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_maybe(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_array(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_tuple(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_dict_entry(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_variant(type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_hash(type_: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_variant_type_equal(type1: gconstpointer, type2: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_is_subtype_of(
        type_: *const GVariantType,
        supertype: *const GVariantType,
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_type_element(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_first(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_next(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_n_items(type_: *const GVariantType) -> gsize;
}
extern "C" {
    pub fn g_variant_type_key(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_value(type_: *const GVariantType) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_array(element: *const GVariantType) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_maybe(element: *const GVariantType) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_tuple(
        items: *const *const GVariantType,
        length: gint,
    ) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_new_dict_entry(
        key: *const GVariantType,
        value: *const GVariantType,
    ) -> *mut GVariantType;
}
extern "C" {
    pub fn g_variant_type_checked_(arg1: *const gchar) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_type_string_get_depth_(type_string: *const gchar) -> gsize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariant {
    _unused: [u8; 0],
}
pub type GVariant = _GVariant;
pub const GVariantClass_G_VARIANT_CLASS_BOOLEAN: GVariantClass = 98;
pub const GVariantClass_G_VARIANT_CLASS_BYTE: GVariantClass = 121;
pub const GVariantClass_G_VARIANT_CLASS_INT16: GVariantClass = 110;
pub const GVariantClass_G_VARIANT_CLASS_UINT16: GVariantClass = 113;
pub const GVariantClass_G_VARIANT_CLASS_INT32: GVariantClass = 105;
pub const GVariantClass_G_VARIANT_CLASS_UINT32: GVariantClass = 117;
pub const GVariantClass_G_VARIANT_CLASS_INT64: GVariantClass = 120;
pub const GVariantClass_G_VARIANT_CLASS_UINT64: GVariantClass = 116;
pub const GVariantClass_G_VARIANT_CLASS_HANDLE: GVariantClass = 104;
pub const GVariantClass_G_VARIANT_CLASS_DOUBLE: GVariantClass = 100;
pub const GVariantClass_G_VARIANT_CLASS_STRING: GVariantClass = 115;
pub const GVariantClass_G_VARIANT_CLASS_OBJECT_PATH: GVariantClass = 111;
pub const GVariantClass_G_VARIANT_CLASS_SIGNATURE: GVariantClass = 103;
pub const GVariantClass_G_VARIANT_CLASS_VARIANT: GVariantClass = 118;
pub const GVariantClass_G_VARIANT_CLASS_MAYBE: GVariantClass = 109;
pub const GVariantClass_G_VARIANT_CLASS_ARRAY: GVariantClass = 97;
pub const GVariantClass_G_VARIANT_CLASS_TUPLE: GVariantClass = 40;
pub const GVariantClass_G_VARIANT_CLASS_DICT_ENTRY: GVariantClass = 123;
pub type GVariantClass = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_variant_unref(value: *mut GVariant);
}
extern "C" {
    pub fn g_variant_ref(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_ref_sink(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_floating(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_take_ref(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_type(value: *mut GVariant) -> *const GVariantType;
}
extern "C" {
    pub fn g_variant_get_type_string(value: *mut GVariant) -> *const gchar;
}
extern "C" {
    pub fn g_variant_is_of_type(value: *mut GVariant, type_: *const GVariantType) -> gboolean;
}
extern "C" {
    pub fn g_variant_is_container(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_classify(value: *mut GVariant) -> GVariantClass;
}
extern "C" {
    pub fn g_variant_new_boolean(value: gboolean) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_byte(value: guint8) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_int16(value: gint16) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_uint16(value: guint16) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_int32(value: gint32) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_uint32(value: guint32) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_int64(value: gint64) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_uint64(value: guint64) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_handle(value: gint32) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_double(value: gdouble) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_string(string: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_take_string(string: *mut gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_printf(format_string: *const gchar, ...) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_object_path(object_path: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_object_path(string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_new_signature(signature: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_signature(string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_new_variant(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_strv(strv: *const *const gchar, length: gssize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_objv(strv: *const *const gchar, length: gssize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_bytestring(string: *const gchar) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_bytestring_array(
        strv: *const *const gchar,
        length: gssize,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_fixed_array(
        element_type: *const GVariantType,
        elements: gconstpointer,
        n_elements: gsize,
        element_size: gsize,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_boolean(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_get_byte(value: *mut GVariant) -> guint8;
}
extern "C" {
    pub fn g_variant_get_int16(value: *mut GVariant) -> gint16;
}
extern "C" {
    pub fn g_variant_get_uint16(value: *mut GVariant) -> guint16;
}
extern "C" {
    pub fn g_variant_get_int32(value: *mut GVariant) -> gint32;
}
extern "C" {
    pub fn g_variant_get_uint32(value: *mut GVariant) -> guint32;
}
extern "C" {
    pub fn g_variant_get_int64(value: *mut GVariant) -> gint64;
}
extern "C" {
    pub fn g_variant_get_uint64(value: *mut GVariant) -> guint64;
}
extern "C" {
    pub fn g_variant_get_handle(value: *mut GVariant) -> gint32;
}
extern "C" {
    pub fn g_variant_get_double(value: *mut GVariant) -> gdouble;
}
extern "C" {
    pub fn g_variant_get_variant(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_string(value: *mut GVariant, length: *mut gsize) -> *const gchar;
}
extern "C" {
    pub fn g_variant_dup_string(value: *mut GVariant, length: *mut gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_get_strv(value: *mut GVariant, length: *mut gsize) -> *mut *const gchar;
}
extern "C" {
    pub fn g_variant_dup_strv(value: *mut GVariant, length: *mut gsize) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_variant_get_objv(value: *mut GVariant, length: *mut gsize) -> *mut *const gchar;
}
extern "C" {
    pub fn g_variant_dup_objv(value: *mut GVariant, length: *mut gsize) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_variant_get_bytestring(value: *mut GVariant) -> *const gchar;
}
extern "C" {
    pub fn g_variant_dup_bytestring(value: *mut GVariant, length: *mut gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_get_bytestring_array(
        value: *mut GVariant,
        length: *mut gsize,
    ) -> *mut *const gchar;
}
extern "C" {
    pub fn g_variant_dup_bytestring_array(
        value: *mut GVariant,
        length: *mut gsize,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_variant_new_maybe(
        child_type: *const GVariantType,
        child: *mut GVariant,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_array(
        child_type: *const GVariantType,
        children: *const *mut GVariant,
        n_children: gsize,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_tuple(children: *const *mut GVariant, n_children: gsize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_dict_entry(key: *mut GVariant, value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_maybe(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_n_children(value: *mut GVariant) -> gsize;
}
extern "C" {
    pub fn g_variant_get_child(
        value: *mut GVariant,
        index_: gsize,
        format_string: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_variant_get_child_value(value: *mut GVariant, index_: gsize) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_lookup(
        dictionary: *mut GVariant,
        key: *const gchar,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_lookup_value(
        dictionary: *mut GVariant,
        key: *const gchar,
        expected_type: *const GVariantType,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_fixed_array(
        value: *mut GVariant,
        n_elements: *mut gsize,
        element_size: gsize,
    ) -> gconstpointer;
}
extern "C" {
    pub fn g_variant_get_size(value: *mut GVariant) -> gsize;
}
extern "C" {
    pub fn g_variant_get_data(value: *mut GVariant) -> gconstpointer;
}
extern "C" {
    pub fn g_variant_get_data_as_bytes(value: *mut GVariant) -> *mut GBytes;
}
extern "C" {
    pub fn g_variant_store(value: *mut GVariant, data: gpointer);
}
extern "C" {
    pub fn g_variant_print(value: *mut GVariant, type_annotate: gboolean) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_print_string(
        value: *mut GVariant,
        string: *mut GString,
        type_annotate: gboolean,
    ) -> *mut GString;
}
extern "C" {
    pub fn g_variant_hash(value: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_variant_equal(one: gconstpointer, two: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_variant_get_normal_form(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_is_normal_form(value: *mut GVariant) -> gboolean;
}
extern "C" {
    pub fn g_variant_byteswap(value: *mut GVariant) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_from_bytes(
        type_: *const GVariantType,
        bytes: *mut GBytes,
        trusted: gboolean,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_from_data(
        type_: *const GVariantType,
        data: gconstpointer,
        size: gsize,
        trusted: gboolean,
        notify: GDestroyNotify,
        user_data: gpointer,
    ) -> *mut GVariant;
}
pub type GVariantIter = _GVariantIter;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariantIter {
    pub x: [gsize; 16usize],
}
extern "C" {
    pub fn g_variant_iter_new(value: *mut GVariant) -> *mut GVariantIter;
}
extern "C" {
    pub fn g_variant_iter_init(iter: *mut GVariantIter, value: *mut GVariant) -> gsize;
}
extern "C" {
    pub fn g_variant_iter_copy(iter: *mut GVariantIter) -> *mut GVariantIter;
}
extern "C" {
    pub fn g_variant_iter_n_children(iter: *mut GVariantIter) -> gsize;
}
extern "C" {
    pub fn g_variant_iter_free(iter: *mut GVariantIter);
}
extern "C" {
    pub fn g_variant_iter_next_value(iter: *mut GVariantIter) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_iter_next(
        iter: *mut GVariantIter,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_iter_loop(
        iter: *mut GVariantIter,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
pub type GVariantBuilder = _GVariantBuilder;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GVariantBuilder {
    pub u: _GVariantBuilder__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GVariantBuilder__bindgen_ty_1 {
    pub s: _GVariantBuilder__bindgen_ty_1__bindgen_ty_1,
    pub x: [gsize; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariantBuilder__bindgen_ty_1__bindgen_ty_1 {
    pub partial_magic: gsize,
    pub type_: *const GVariantType,
    pub y: [gsize; 14usize],
}
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_FAILED: GVariantParseError = 0;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_BASIC_TYPE_EXPECTED: GVariantParseError = 1;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_CANNOT_INFER_TYPE: GVariantParseError = 2;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_DEFINITE_TYPE_EXPECTED: GVariantParseError = 3;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INPUT_NOT_AT_END: GVariantParseError = 4;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_CHARACTER: GVariantParseError = 5;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_FORMAT_STRING: GVariantParseError = 6;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_OBJECT_PATH: GVariantParseError = 7;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_SIGNATURE: GVariantParseError = 8;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_INVALID_TYPE_STRING: GVariantParseError = 9;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_NO_COMMON_TYPE: GVariantParseError = 10;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_NUMBER_OUT_OF_RANGE: GVariantParseError = 11;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_NUMBER_TOO_BIG: GVariantParseError = 12;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_TYPE_ERROR: GVariantParseError = 13;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_UNEXPECTED_TOKEN: GVariantParseError = 14;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_UNKNOWN_KEYWORD: GVariantParseError = 15;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_UNTERMINATED_STRING_CONSTANT:
    GVariantParseError = 16;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_VALUE_EXPECTED: GVariantParseError = 17;
pub const GVariantParseError_G_VARIANT_PARSE_ERROR_RECURSION: GVariantParseError = 18;
pub type GVariantParseError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_variant_parser_get_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_variant_parse_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_variant_builder_new(type_: *const GVariantType) -> *mut GVariantBuilder;
}
extern "C" {
    pub fn g_variant_builder_unref(builder: *mut GVariantBuilder);
}
extern "C" {
    pub fn g_variant_builder_ref(builder: *mut GVariantBuilder) -> *mut GVariantBuilder;
}
extern "C" {
    pub fn g_variant_builder_init(builder: *mut GVariantBuilder, type_: *const GVariantType);
}
extern "C" {
    pub fn g_variant_builder_end(builder: *mut GVariantBuilder) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_builder_clear(builder: *mut GVariantBuilder);
}
extern "C" {
    pub fn g_variant_builder_open(builder: *mut GVariantBuilder, type_: *const GVariantType);
}
extern "C" {
    pub fn g_variant_builder_close(builder: *mut GVariantBuilder);
}
extern "C" {
    pub fn g_variant_builder_add_value(builder: *mut GVariantBuilder, value: *mut GVariant);
}
extern "C" {
    pub fn g_variant_builder_add(builder: *mut GVariantBuilder, format_string: *const gchar, ...);
}
extern "C" {
    pub fn g_variant_builder_add_parsed(builder: *mut GVariantBuilder, format: *const gchar, ...);
}
extern "C" {
    pub fn g_variant_new(format_string: *const gchar, ...) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get(value: *mut GVariant, format_string: *const gchar, ...);
}
extern "C" {
    pub fn g_variant_new_va(
        format_string: *const gchar,
        endptr: *mut *const gchar,
        app: *mut va_list,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_get_va(
        value: *mut GVariant,
        format_string: *const gchar,
        endptr: *mut *const gchar,
        app: *mut va_list,
    );
}
extern "C" {
    pub fn g_variant_check_format_string(
        value: *mut GVariant,
        format_string: *const gchar,
        copy_only: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_parse(
        type_: *const GVariantType,
        text: *const gchar,
        limit: *const gchar,
        endptr: *mut *const gchar,
        error: *mut *mut GError,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_parsed(format: *const gchar, ...) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_new_parsed_va(format: *const gchar, app: *mut va_list) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_parse_error_print_context(
        error: *mut GError,
        source_str: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_variant_compare(one: gconstpointer, two: gconstpointer) -> gint;
}
pub type GVariantDict = _GVariantDict;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GVariantDict {
    pub u: _GVariantDict__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GVariantDict__bindgen_ty_1 {
    pub s: _GVariantDict__bindgen_ty_1__bindgen_ty_1,
    pub x: [gsize; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GVariantDict__bindgen_ty_1__bindgen_ty_1 {
    pub asv: *mut GVariant,
    pub partial_magic: gsize,
    pub y: [gsize; 14usize],
}
extern "C" {
    pub fn g_variant_dict_new(from_asv: *mut GVariant) -> *mut GVariantDict;
}
extern "C" {
    pub fn g_variant_dict_init(dict: *mut GVariantDict, from_asv: *mut GVariant);
}
extern "C" {
    pub fn g_variant_dict_lookup(
        dict: *mut GVariantDict,
        key: *const gchar,
        format_string: *const gchar,
        ...
    ) -> gboolean;
}
extern "C" {
    pub fn g_variant_dict_lookup_value(
        dict: *mut GVariantDict,
        key: *const gchar,
        expected_type: *const GVariantType,
    ) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_dict_contains(dict: *mut GVariantDict, key: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_dict_insert(
        dict: *mut GVariantDict,
        key: *const gchar,
        format_string: *const gchar,
        ...
    );
}
extern "C" {
    pub fn g_variant_dict_insert_value(
        dict: *mut GVariantDict,
        key: *const gchar,
        value: *mut GVariant,
    );
}
extern "C" {
    pub fn g_variant_dict_remove(dict: *mut GVariantDict, key: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_variant_dict_clear(dict: *mut GVariantDict);
}
extern "C" {
    pub fn g_variant_dict_end(dict: *mut GVariantDict) -> *mut GVariant;
}
extern "C" {
    pub fn g_variant_dict_ref(dict: *mut GVariantDict) -> *mut GVariantDict;
}
extern "C" {
    pub fn g_variant_dict_unref(dict: *mut GVariantDict);
}
extern "C" {
    pub fn g_printf_string_upper_bound(format: *const gchar, args: *mut __va_list_tag) -> gsize;
}
pub const GLogLevelFlags_G_LOG_FLAG_RECURSION: GLogLevelFlags = 1;
pub const GLogLevelFlags_G_LOG_FLAG_FATAL: GLogLevelFlags = 2;
pub const GLogLevelFlags_G_LOG_LEVEL_ERROR: GLogLevelFlags = 4;
pub const GLogLevelFlags_G_LOG_LEVEL_CRITICAL: GLogLevelFlags = 8;
pub const GLogLevelFlags_G_LOG_LEVEL_WARNING: GLogLevelFlags = 16;
pub const GLogLevelFlags_G_LOG_LEVEL_MESSAGE: GLogLevelFlags = 32;
pub const GLogLevelFlags_G_LOG_LEVEL_INFO: GLogLevelFlags = 64;
pub const GLogLevelFlags_G_LOG_LEVEL_DEBUG: GLogLevelFlags = 128;
pub const GLogLevelFlags_G_LOG_LEVEL_MASK: GLogLevelFlags = -4;
pub type GLogLevelFlags = ::std::os::raw::c_int;
pub type GLogFunc = ::std::option::Option<
    unsafe extern "C" fn(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        user_data: gpointer,
    ),
>;
extern "C" {
    pub fn g_log_set_handler(
        log_domain: *const gchar,
        log_levels: GLogLevelFlags,
        log_func: GLogFunc,
        user_data: gpointer,
    ) -> guint;
}
extern "C" {
    pub fn g_log_set_handler_full(
        log_domain: *const gchar,
        log_levels: GLogLevelFlags,
        log_func: GLogFunc,
        user_data: gpointer,
        destroy: GDestroyNotify,
    ) -> guint;
}
extern "C" {
    pub fn g_log_remove_handler(log_domain: *const gchar, handler_id: guint);
}
extern "C" {
    pub fn g_log_default_handler(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        unused_data: gpointer,
    );
}
extern "C" {
    pub fn g_log_set_default_handler(log_func: GLogFunc, user_data: gpointer) -> GLogFunc;
}
extern "C" {
    pub fn g_log(log_domain: *const gchar, log_level: GLogLevelFlags, format: *const gchar, ...);
}
extern "C" {
    pub fn g_logv(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        format: *const gchar,
        args: *mut __va_list_tag,
    );
}
extern "C" {
    pub fn g_log_set_fatal_mask(
        log_domain: *const gchar,
        fatal_mask: GLogLevelFlags,
    ) -> GLogLevelFlags;
}
extern "C" {
    pub fn g_log_set_always_fatal(fatal_mask: GLogLevelFlags) -> GLogLevelFlags;
}
pub const GLogWriterOutput_G_LOG_WRITER_HANDLED: GLogWriterOutput = 1;
pub const GLogWriterOutput_G_LOG_WRITER_UNHANDLED: GLogWriterOutput = 0;
#[doc = " GLogWriterOutput:"]
#[doc = " @G_LOG_WRITER_HANDLED: Log writer has handled the log entry."]
#[doc = " @G_LOG_WRITER_UNHANDLED: Log writer could not handle the log entry."]
#[doc = ""]
#[doc = " Return values from #GLogWriterFuncs to indicate whether the given log entry"]
#[doc = " was successfully handled by the writer, or whether there was an error in"]
#[doc = " handling it (and hence a fallback writer should be used)."]
#[doc = ""]
#[doc = " If a #GLogWriterFunc ignores a log entry, it should return"]
#[doc = " %G_LOG_WRITER_HANDLED."]
#[doc = ""]
#[doc = " Since: 2.50"]
pub type GLogWriterOutput = ::std::os::raw::c_uint;
#[doc = " GLogField:"]
#[doc = " @key: field name (UTF-8 string)"]
#[doc = " @value: field value (arbitrary bytes)"]
#[doc = " @length: length of @value, in bytes, or -1 if it is nul-terminated"]
#[doc = ""]
#[doc = " Structure representing a single field in a structured log entry. See"]
#[doc = " g_log_structured() for details."]
#[doc = ""]
#[doc = " Log fields may contain arbitrary values, including binary with embedded nul"]
#[doc = " bytes. If the field contains a string, the string must be UTF-8 encoded and"]
#[doc = " have a trailing nul byte. Otherwise, @length must be set to a non-negative"]
#[doc = " value."]
#[doc = ""]
#[doc = " Since: 2.50"]
pub type GLogField = _GLogField;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GLogField {
    pub key: *const gchar,
    pub value: gconstpointer,
    pub length: gssize,
}
#[doc = " GLogWriterFunc:"]
#[doc = " @log_level: log level of the message"]
#[doc = " @fields: (array length=n_fields): fields forming the message"]
#[doc = " @n_fields: number of @fields"]
#[doc = " @user_data: user data passed to g_log_set_writer_func()"]
#[doc = ""]
#[doc = " Writer function for log entries. A log entry is a collection of one or more"]
#[doc = " #GLogFields, using the standard [field names from journal"]
#[doc = " specification](https://www.freedesktop.org/software/systemd/man/systemd.journal-fields.html)."]
#[doc = " See g_log_structured() for more information."]
#[doc = ""]
#[doc = " Writer functions must ignore fields which they do not recognise, unless they"]
#[doc = " can write arbitrary binary output, as field values may be arbitrary binary."]
#[doc = ""]
#[doc = " @log_level is guaranteed to be included in @fields as the `PRIORITY` field,"]
#[doc = " but is provided separately for convenience of deciding whether or where to"]
#[doc = " output the log entry."]
#[doc = ""]
#[doc = " Writer functions should return %G_LOG_WRITER_HANDLED if they handled the log"]
#[doc = " message successfully or if they deliberately ignored it. If there was an"]
#[doc = " error handling the message (for example, if the writer function is meant to"]
#[doc = " send messages to a remote logging server and there is a network error), it"]
#[doc = " should return %G_LOG_WRITER_UNHANDLED. This allows writer functions to be"]
#[doc = " chained and fall back to simpler handlers in case of failure."]
#[doc = ""]
#[doc = " Returns: %G_LOG_WRITER_HANDLED if the log entry was handled successfully;"]
#[doc = "    %G_LOG_WRITER_UNHANDLED otherwise"]
#[doc = " Since: 2.50"]
pub type GLogWriterFunc = ::std::option::Option<
    unsafe extern "C" fn(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput,
>;
extern "C" {
    pub fn g_log_structured(log_domain: *const gchar, log_level: GLogLevelFlags, ...);
}
extern "C" {
    pub fn g_log_structured_array(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
    );
}
extern "C" {
    pub fn g_log_variant(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        fields: *mut GVariant,
    );
}
extern "C" {
    pub fn g_log_set_writer_func(
        func: GLogWriterFunc,
        user_data: gpointer,
        user_data_free: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_log_writer_supports_color(output_fd: gint) -> gboolean;
}
extern "C" {
    pub fn g_log_writer_is_journald(output_fd: gint) -> gboolean;
}
extern "C" {
    pub fn g_log_writer_format_fields(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        use_color: gboolean,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_log_writer_journald(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput;
}
extern "C" {
    pub fn g_log_writer_standard_streams(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput;
}
extern "C" {
    pub fn g_log_writer_default(
        log_level: GLogLevelFlags,
        fields: *const GLogField,
        n_fields: gsize,
        user_data: gpointer,
    ) -> GLogWriterOutput;
}
extern "C" {
    pub fn _g_log_fallback_handler(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        unused_data: gpointer,
    );
}
extern "C" {
    pub fn g_return_if_fail_warning(
        log_domain: *const ::std::os::raw::c_char,
        pretty_function: *const ::std::os::raw::c_char,
        expression: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_warn_message(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        warnexpr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assert_warning(
        log_domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        pretty_function: *const ::std::os::raw::c_char,
        expression: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_log_structured_standard(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        file: *const gchar,
        line: *const gchar,
        func: *const gchar,
        message_format: *const gchar,
        ...
    );
}
#[doc = " GPrintFunc:"]
#[doc = " @string: the message to output"]
#[doc = ""]
#[doc = " Specifies the type of the print handler functions."]
#[doc = " These are called with the complete formatted string to output."]
pub type GPrintFunc = ::std::option::Option<unsafe extern "C" fn(string: *const gchar)>;
extern "C" {
    pub fn g_print(format: *const gchar, ...);
}
extern "C" {
    pub fn g_set_print_handler(func: GPrintFunc) -> GPrintFunc;
}
extern "C" {
    pub fn g_printerr(format: *const gchar, ...);
}
extern "C" {
    pub fn g_set_printerr_handler(func: GPrintFunc) -> GPrintFunc;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOptionContext {
    _unused: [u8; 0],
}
#[doc = " GOptionContext:"]
#[doc = ""]
#[doc = " A `GOptionContext` struct defines which options"]
#[doc = " are accepted by the commandline option parser. The struct has only private"]
#[doc = " fields and should not be directly accessed."]
pub type GOptionContext = _GOptionContext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOptionGroup {
    _unused: [u8; 0],
}
#[doc = " GOptionGroup:"]
#[doc = ""]
#[doc = " A `GOptionGroup` struct defines the options in a single"]
#[doc = " group. The struct has only private fields and should not be directly accessed."]
#[doc = ""]
#[doc = " All options in a group share the same translation function. Libraries which"]
#[doc = " need to parse commandline options are expected to provide a function for"]
#[doc = " getting a `GOptionGroup` holding their options, which"]
#[doc = " the application can then add to its #GOptionContext."]
pub type GOptionGroup = _GOptionGroup;
pub type GOptionEntry = _GOptionEntry;
pub const GOptionFlags_G_OPTION_FLAG_NONE: GOptionFlags = 0;
pub const GOptionFlags_G_OPTION_FLAG_HIDDEN: GOptionFlags = 1;
pub const GOptionFlags_G_OPTION_FLAG_IN_MAIN: GOptionFlags = 2;
pub const GOptionFlags_G_OPTION_FLAG_REVERSE: GOptionFlags = 4;
pub const GOptionFlags_G_OPTION_FLAG_NO_ARG: GOptionFlags = 8;
pub const GOptionFlags_G_OPTION_FLAG_FILENAME: GOptionFlags = 16;
pub const GOptionFlags_G_OPTION_FLAG_OPTIONAL_ARG: GOptionFlags = 32;
pub const GOptionFlags_G_OPTION_FLAG_NOALIAS: GOptionFlags = 64;
#[doc = " GOptionFlags:"]
#[doc = " @G_OPTION_FLAG_NONE: No flags. Since: 2.42."]
#[doc = " @G_OPTION_FLAG_HIDDEN: The option doesn't appear in `--help` output."]
#[doc = " @G_OPTION_FLAG_IN_MAIN: The option appears in the main section of the"]
#[doc = "     `--help` output, even if it is defined in a group."]
#[doc = " @G_OPTION_FLAG_REVERSE: For options of the %G_OPTION_ARG_NONE kind, this"]
#[doc = "     flag indicates that the sense of the option is reversed."]
#[doc = " @G_OPTION_FLAG_NO_ARG: For options of the %G_OPTION_ARG_CALLBACK kind,"]
#[doc = "     this flag indicates that the callback does not take any argument"]
#[doc = "     (like a %G_OPTION_ARG_NONE option). Since 2.8"]
#[doc = " @G_OPTION_FLAG_FILENAME: For options of the %G_OPTION_ARG_CALLBACK"]
#[doc = "     kind, this flag indicates that the argument should be passed to the"]
#[doc = "     callback in the GLib filename encoding rather than UTF-8. Since 2.8"]
#[doc = " @G_OPTION_FLAG_OPTIONAL_ARG: For options of the %G_OPTION_ARG_CALLBACK"]
#[doc = "     kind, this flag indicates that the argument supply is optional."]
#[doc = "     If no argument is given then data of %GOptionParseFunc will be"]
#[doc = "     set to NULL. Since 2.8"]
#[doc = " @G_OPTION_FLAG_NOALIAS: This flag turns off the automatic conflict"]
#[doc = "     resolution which prefixes long option names with `groupname-` if"]
#[doc = "     there is a conflict. This option should only be used in situations"]
#[doc = "     where aliasing is necessary to model some legacy commandline interface."]
#[doc = "     It is not safe to use this option, unless all option groups are under"]
#[doc = "     your direct control. Since 2.8."]
#[doc = ""]
#[doc = " Flags which modify individual options."]
pub type GOptionFlags = ::std::os::raw::c_uint;
pub const GOptionArg_G_OPTION_ARG_NONE: GOptionArg = 0;
pub const GOptionArg_G_OPTION_ARG_STRING: GOptionArg = 1;
pub const GOptionArg_G_OPTION_ARG_INT: GOptionArg = 2;
pub const GOptionArg_G_OPTION_ARG_CALLBACK: GOptionArg = 3;
pub const GOptionArg_G_OPTION_ARG_FILENAME: GOptionArg = 4;
pub const GOptionArg_G_OPTION_ARG_STRING_ARRAY: GOptionArg = 5;
pub const GOptionArg_G_OPTION_ARG_FILENAME_ARRAY: GOptionArg = 6;
pub const GOptionArg_G_OPTION_ARG_DOUBLE: GOptionArg = 7;
pub const GOptionArg_G_OPTION_ARG_INT64: GOptionArg = 8;
#[doc = " GOptionArg:"]
#[doc = " @G_OPTION_ARG_NONE: No extra argument. This is useful for simple flags."]
#[doc = " @G_OPTION_ARG_STRING: The option takes a UTF-8 string argument."]
#[doc = " @G_OPTION_ARG_INT: The option takes an integer argument."]
#[doc = " @G_OPTION_ARG_CALLBACK: The option provides a callback (of type"]
#[doc = "     #GOptionArgFunc) to parse the extra argument."]
#[doc = " @G_OPTION_ARG_FILENAME: The option takes a filename as argument, which will"]
#[doc = "be in the GLib filename encoding rather than UTF-8."]
#[doc = " @G_OPTION_ARG_STRING_ARRAY: The option takes a string argument, multiple"]
#[doc = "     uses of the option are collected into an array of strings."]
#[doc = " @G_OPTION_ARG_FILENAME_ARRAY: The option takes a filename as argument,"]
#[doc = "     multiple uses of the option are collected into an array of strings."]
#[doc = " @G_OPTION_ARG_DOUBLE: The option takes a double argument. The argument"]
#[doc = "     can be formatted either for the user's locale or for the \"C\" locale."]
#[doc = "     Since 2.12"]
#[doc = " @G_OPTION_ARG_INT64: The option takes a 64-bit integer. Like"]
#[doc = "     %G_OPTION_ARG_INT but for larger numbers. The number can be in"]
#[doc = "     decimal base, or in hexadecimal (when prefixed with `0x`, for"]
#[doc = "     example, `0xffffffff`). Since 2.12"]
#[doc = ""]
#[doc = " The #GOptionArg enum values determine which type of extra argument the"]
#[doc = " options expect to find. If an option expects an extra argument, it can"]
#[doc = " be specified in several ways; with a short option: `-x arg`, with a long"]
#[doc = " option: `--name arg` or combined in a single argument: `--name=arg`."]
pub type GOptionArg = ::std::os::raw::c_uint;
#[doc = " GOptionArgFunc:"]
#[doc = " @option_name: The name of the option being parsed. This will be either a"]
#[doc = "  single dash followed by a single letter (for a short name) or two dashes"]
#[doc = "  followed by a long option name."]
#[doc = " @value: The value to be parsed."]
#[doc = " @data: User data added to the #GOptionGroup containing the option when it"]
#[doc = "  was created with g_option_group_new()"]
#[doc = " @error: A return location for errors. The error code %G_OPTION_ERROR_FAILED"]
#[doc = "  is intended to be used for errors in #GOptionArgFunc callbacks."]
#[doc = ""]
#[doc = " The type of function to be passed as callback for %G_OPTION_ARG_CALLBACK"]
#[doc = " options."]
#[doc = ""]
#[doc = " Returns: %TRUE if the option was successfully parsed, %FALSE if an error"]
#[doc = "  occurred, in which case @error should be set with g_set_error()"]
pub type GOptionArgFunc = ::std::option::Option<
    unsafe extern "C" fn(
        option_name: *const gchar,
        value: *const gchar,
        data: gpointer,
        error: *mut *mut GError,
    ) -> gboolean,
>;
#[doc = " GOptionParseFunc:"]
#[doc = " @context: The active #GOptionContext"]
#[doc = " @group: The group to which the function belongs"]
#[doc = " @data: User data added to the #GOptionGroup containing the option when it"]
#[doc = "  was created with g_option_group_new()"]
#[doc = " @error: A return location for error details"]
#[doc = ""]
#[doc = " The type of function that can be called before and after parsing."]
#[doc = ""]
#[doc = " Returns: %TRUE if the function completed successfully, %FALSE if an error"]
#[doc = "  occurred, in which case @error should be set with g_set_error()"]
pub type GOptionParseFunc = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut GOptionContext,
        group: *mut GOptionGroup,
        data: gpointer,
        error: *mut *mut GError,
    ) -> gboolean,
>;
#[doc = " GOptionErrorFunc:"]
#[doc = " @context: The active #GOptionContext"]
#[doc = " @group: The group to which the function belongs"]
#[doc = " @data: User data added to the #GOptionGroup containing the option when it"]
#[doc = "  was created with g_option_group_new()"]
#[doc = " @error: The #GError containing details about the parse error"]
#[doc = ""]
#[doc = " The type of function to be used as callback when a parse error occurs."]
pub type GOptionErrorFunc = ::std::option::Option<
    unsafe extern "C" fn(
        context: *mut GOptionContext,
        group: *mut GOptionGroup,
        data: gpointer,
        error: *mut *mut GError,
    ),
>;
pub const GOptionError_G_OPTION_ERROR_UNKNOWN_OPTION: GOptionError = 0;
pub const GOptionError_G_OPTION_ERROR_BAD_VALUE: GOptionError = 1;
pub const GOptionError_G_OPTION_ERROR_FAILED: GOptionError = 2;
#[doc = " GOptionError:"]
#[doc = " @G_OPTION_ERROR_UNKNOWN_OPTION: An option was not known to the parser."]
#[doc = "  This error will only be reported, if the parser hasn't been instructed"]
#[doc = "  to ignore unknown options, see g_option_context_set_ignore_unknown_options()."]
#[doc = " @G_OPTION_ERROR_BAD_VALUE: A value couldn't be parsed."]
#[doc = " @G_OPTION_ERROR_FAILED: A #GOptionArgFunc callback failed."]
#[doc = ""]
#[doc = " Error codes returned by option parsing."]
pub type GOptionError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_option_error_quark() -> GQuark;
}
#[doc = " GOptionEntry:"]
#[doc = " @long_name: The long name of an option can be used to specify it"]
#[doc = "     in a commandline as `--long_name`. Every option must have a"]
#[doc = "     long name. To resolve conflicts if multiple option groups contain"]
#[doc = "     the same long name, it is also possible to specify the option as"]
#[doc = "     `--groupname-long_name`."]
#[doc = " @short_name: If an option has a short name, it can be specified"]
#[doc = "     `-short_name` in a commandline. @short_name must be  a printable"]
#[doc = "     ASCII character different from '-', or zero if the option has no"]
#[doc = "     short name."]
#[doc = " @flags: Flags from #GOptionFlags"]
#[doc = " @arg: The type of the option, as a #GOptionArg"]
#[doc = " @arg_data: If the @arg type is %G_OPTION_ARG_CALLBACK, then @arg_data"]
#[doc = "     must point to a #GOptionArgFunc callback function, which will be"]
#[doc = "     called to handle the extra argument. Otherwise, @arg_data is a"]
#[doc = "     pointer to a location to store the value, the required type of"]
#[doc = "     the location depends on the @arg type:"]
#[doc = "     - %G_OPTION_ARG_NONE: %gboolean"]
#[doc = "     - %G_OPTION_ARG_STRING: %gchar*"]
#[doc = "     - %G_OPTION_ARG_INT: %gint"]
#[doc = "     - %G_OPTION_ARG_FILENAME: %gchar*"]
#[doc = "     - %G_OPTION_ARG_STRING_ARRAY: %gchar**"]
#[doc = "     - %G_OPTION_ARG_FILENAME_ARRAY: %gchar**"]
#[doc = "     - %G_OPTION_ARG_DOUBLE: %gdouble"]
#[doc = "     If @arg type is %G_OPTION_ARG_STRING or %G_OPTION_ARG_FILENAME,"]
#[doc = "     the location will contain a newly allocated string if the option"]
#[doc = "     was given. That string needs to be freed by the callee using g_free()."]
#[doc = "     Likewise if @arg type is %G_OPTION_ARG_STRING_ARRAY or"]
#[doc = "     %G_OPTION_ARG_FILENAME_ARRAY, the data should be freed using g_strfreev()."]
#[doc = " @description: the description for the option in `--help`"]
#[doc = "     output. The @description is translated using the @translate_func"]
#[doc = "     of the group, see g_option_group_set_translation_domain()."]
#[doc = " @arg_description: The placeholder to use for the extra argument parsed"]
#[doc = "     by the option in `--help` output. The @arg_description is translated"]
#[doc = "     using the @translate_func of the group, see"]
#[doc = "     g_option_group_set_translation_domain()."]
#[doc = ""]
#[doc = " A GOptionEntry struct defines a single option. To have an effect, they"]
#[doc = " must be added to a #GOptionGroup with g_option_context_add_main_entries()"]
#[doc = " or g_option_group_add_entries()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GOptionEntry {
    pub long_name: *const gchar,
    pub short_name: gchar,
    pub flags: gint,
    pub arg: GOptionArg,
    pub arg_data: gpointer,
    pub description: *const gchar,
    pub arg_description: *const gchar,
}
extern "C" {
    pub fn g_option_context_new(parameter_string: *const gchar) -> *mut GOptionContext;
}
extern "C" {
    pub fn g_option_context_set_summary(context: *mut GOptionContext, summary: *const gchar);
}
extern "C" {
    pub fn g_option_context_get_summary(context: *mut GOptionContext) -> *const gchar;
}
extern "C" {
    pub fn g_option_context_set_description(
        context: *mut GOptionContext,
        description: *const gchar,
    );
}
extern "C" {
    pub fn g_option_context_get_description(context: *mut GOptionContext) -> *const gchar;
}
extern "C" {
    pub fn g_option_context_free(context: *mut GOptionContext);
}
extern "C" {
    pub fn g_option_context_set_help_enabled(context: *mut GOptionContext, help_enabled: gboolean);
}
extern "C" {
    pub fn g_option_context_get_help_enabled(context: *mut GOptionContext) -> gboolean;
}
extern "C" {
    pub fn g_option_context_set_ignore_unknown_options(
        context: *mut GOptionContext,
        ignore_unknown: gboolean,
    );
}
extern "C" {
    pub fn g_option_context_get_ignore_unknown_options(context: *mut GOptionContext) -> gboolean;
}
extern "C" {
    pub fn g_option_context_set_strict_posix(context: *mut GOptionContext, strict_posix: gboolean);
}
extern "C" {
    pub fn g_option_context_get_strict_posix(context: *mut GOptionContext) -> gboolean;
}
extern "C" {
    pub fn g_option_context_add_main_entries(
        context: *mut GOptionContext,
        entries: *const GOptionEntry,
        translation_domain: *const gchar,
    );
}
extern "C" {
    pub fn g_option_context_parse(
        context: *mut GOptionContext,
        argc: *mut gint,
        argv: *mut *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_option_context_parse_strv(
        context: *mut GOptionContext,
        arguments: *mut *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_option_context_set_translate_func(
        context: *mut GOptionContext,
        func: GTranslateFunc,
        data: gpointer,
        destroy_notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_option_context_set_translation_domain(
        context: *mut GOptionContext,
        domain: *const gchar,
    );
}
extern "C" {
    pub fn g_option_context_add_group(context: *mut GOptionContext, group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_context_set_main_group(context: *mut GOptionContext, group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_context_get_main_group(context: *mut GOptionContext) -> *mut GOptionGroup;
}
extern "C" {
    pub fn g_option_context_get_help(
        context: *mut GOptionContext,
        main_help: gboolean,
        group: *mut GOptionGroup,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_option_group_new(
        name: *const gchar,
        description: *const gchar,
        help_description: *const gchar,
        user_data: gpointer,
        destroy: GDestroyNotify,
    ) -> *mut GOptionGroup;
}
extern "C" {
    pub fn g_option_group_set_parse_hooks(
        group: *mut GOptionGroup,
        pre_parse_func: GOptionParseFunc,
        post_parse_func: GOptionParseFunc,
    );
}
extern "C" {
    pub fn g_option_group_set_error_hook(group: *mut GOptionGroup, error_func: GOptionErrorFunc);
}
extern "C" {
    pub fn g_option_group_free(group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_group_ref(group: *mut GOptionGroup) -> *mut GOptionGroup;
}
extern "C" {
    pub fn g_option_group_unref(group: *mut GOptionGroup);
}
extern "C" {
    pub fn g_option_group_add_entries(group: *mut GOptionGroup, entries: *const GOptionEntry);
}
extern "C" {
    pub fn g_option_group_set_translate_func(
        group: *mut GOptionGroup,
        func: GTranslateFunc,
        data: gpointer,
        destroy_notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_option_group_set_translation_domain(group: *mut GOptionGroup, domain: *const gchar);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GPatternSpec {
    _unused: [u8; 0],
}
pub type GPatternSpec = _GPatternSpec;
extern "C" {
    pub fn g_pattern_spec_new(pattern: *const gchar) -> *mut GPatternSpec;
}
extern "C" {
    pub fn g_pattern_spec_free(pspec: *mut GPatternSpec);
}
extern "C" {
    pub fn g_pattern_spec_equal(pspec1: *mut GPatternSpec, pspec2: *mut GPatternSpec) -> gboolean;
}
extern "C" {
    pub fn g_pattern_match(
        pspec: *mut GPatternSpec,
        string_length: guint,
        string: *const gchar,
        string_reversed: *const gchar,
    ) -> gboolean;
}
extern "C" {
    pub fn g_pattern_match_string(pspec: *mut GPatternSpec, string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_pattern_match_simple(pattern: *const gchar, string: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_spaced_primes_closest(num: guint) -> guint;
}
extern "C" {
    pub fn g_qsort_with_data(
        pbase: gconstpointer,
        total_elems: gint,
        size: gsize,
        compare_func: GCompareDataFunc,
        user_data: gpointer,
    );
}
pub type GQueue = _GQueue;
#[doc = " GQueue:"]
#[doc = " @head: a pointer to the first element of the queue"]
#[doc = " @tail: a pointer to the last element of the queue"]
#[doc = " @length: the number of elements in the queue"]
#[doc = ""]
#[doc = " Contains the public fields of a"]
#[doc = " [Queue][glib-Double-ended-Queues]."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GQueue {
    pub head: *mut GList,
    pub tail: *mut GList,
    pub length: guint,
}
extern "C" {
    pub fn g_queue_new() -> *mut GQueue;
}
extern "C" {
    pub fn g_queue_free(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_free_full(queue: *mut GQueue, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_queue_init(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_clear(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_is_empty(queue: *mut GQueue) -> gboolean;
}
extern "C" {
    pub fn g_queue_clear_full(queue: *mut GQueue, free_func: GDestroyNotify);
}
extern "C" {
    pub fn g_queue_get_length(queue: *mut GQueue) -> guint;
}
extern "C" {
    pub fn g_queue_reverse(queue: *mut GQueue);
}
extern "C" {
    pub fn g_queue_copy(queue: *mut GQueue) -> *mut GQueue;
}
extern "C" {
    pub fn g_queue_foreach(queue: *mut GQueue, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_queue_find(queue: *mut GQueue, data: gconstpointer) -> *mut GList;
}
extern "C" {
    pub fn g_queue_find_custom(
        queue: *mut GQueue,
        data: gconstpointer,
        func: GCompareFunc,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_queue_sort(queue: *mut GQueue, compare_func: GCompareDataFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_queue_push_head(queue: *mut GQueue, data: gpointer);
}
extern "C" {
    pub fn g_queue_push_tail(queue: *mut GQueue, data: gpointer);
}
extern "C" {
    pub fn g_queue_push_nth(queue: *mut GQueue, data: gpointer, n: gint);
}
extern "C" {
    pub fn g_queue_pop_head(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_pop_tail(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_pop_nth(queue: *mut GQueue, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_queue_peek_head(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_peek_tail(queue: *mut GQueue) -> gpointer;
}
extern "C" {
    pub fn g_queue_peek_nth(queue: *mut GQueue, n: guint) -> gpointer;
}
extern "C" {
    pub fn g_queue_index(queue: *mut GQueue, data: gconstpointer) -> gint;
}
extern "C" {
    pub fn g_queue_remove(queue: *mut GQueue, data: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_queue_remove_all(queue: *mut GQueue, data: gconstpointer) -> guint;
}
extern "C" {
    pub fn g_queue_insert_before(queue: *mut GQueue, sibling: *mut GList, data: gpointer);
}
extern "C" {
    pub fn g_queue_insert_before_link(queue: *mut GQueue, sibling: *mut GList, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_insert_after(queue: *mut GQueue, sibling: *mut GList, data: gpointer);
}
extern "C" {
    pub fn g_queue_insert_after_link(queue: *mut GQueue, sibling: *mut GList, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_insert_sorted(
        queue: *mut GQueue,
        data: gpointer,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_queue_push_head_link(queue: *mut GQueue, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_push_tail_link(queue: *mut GQueue, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_push_nth_link(queue: *mut GQueue, n: gint, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_pop_head_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_pop_tail_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_pop_nth_link(queue: *mut GQueue, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_queue_peek_head_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_peek_tail_link(queue: *mut GQueue) -> *mut GList;
}
extern "C" {
    pub fn g_queue_peek_nth_link(queue: *mut GQueue, n: guint) -> *mut GList;
}
extern "C" {
    pub fn g_queue_link_index(queue: *mut GQueue, link_: *mut GList) -> gint;
}
extern "C" {
    pub fn g_queue_unlink(queue: *mut GQueue, link_: *mut GList);
}
extern "C" {
    pub fn g_queue_delete_link(queue: *mut GQueue, link_: *mut GList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRand {
    _unused: [u8; 0],
}
pub type GRand = _GRand;
extern "C" {
    pub fn g_rand_new_with_seed(seed: guint32) -> *mut GRand;
}
extern "C" {
    pub fn g_rand_new_with_seed_array(seed: *const guint32, seed_length: guint) -> *mut GRand;
}
extern "C" {
    pub fn g_rand_new() -> *mut GRand;
}
extern "C" {
    pub fn g_rand_free(rand_: *mut GRand);
}
extern "C" {
    pub fn g_rand_copy(rand_: *mut GRand) -> *mut GRand;
}
extern "C" {
    pub fn g_rand_set_seed(rand_: *mut GRand, seed: guint32);
}
extern "C" {
    pub fn g_rand_set_seed_array(rand_: *mut GRand, seed: *const guint32, seed_length: guint);
}
extern "C" {
    pub fn g_rand_int(rand_: *mut GRand) -> guint32;
}
extern "C" {
    pub fn g_rand_int_range(rand_: *mut GRand, begin: gint32, end: gint32) -> gint32;
}
extern "C" {
    pub fn g_rand_double(rand_: *mut GRand) -> gdouble;
}
extern "C" {
    pub fn g_rand_double_range(rand_: *mut GRand, begin: gdouble, end: gdouble) -> gdouble;
}
extern "C" {
    pub fn g_random_set_seed(seed: guint32);
}
extern "C" {
    pub fn g_random_int() -> guint32;
}
extern "C" {
    pub fn g_random_int_range(begin: gint32, end: gint32) -> gint32;
}
extern "C" {
    pub fn g_random_double() -> gdouble;
}
extern "C" {
    pub fn g_random_double_range(begin: gdouble, end: gdouble) -> gdouble;
}
extern "C" {
    pub fn g_rc_box_alloc(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_alloc0(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_dup(block_size: gsize, mem_block: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_acquire(mem_block: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_rc_box_release(mem_block: gpointer);
}
extern "C" {
    pub fn g_rc_box_release_full(mem_block: gpointer, clear_func: GDestroyNotify);
}
extern "C" {
    pub fn g_rc_box_get_size(mem_block: gpointer) -> gsize;
}
extern "C" {
    pub fn g_atomic_rc_box_alloc(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_alloc0(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_dup(block_size: gsize, mem_block: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_acquire(mem_block: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_atomic_rc_box_release(mem_block: gpointer);
}
extern "C" {
    pub fn g_atomic_rc_box_release_full(mem_block: gpointer, clear_func: GDestroyNotify);
}
extern "C" {
    pub fn g_atomic_rc_box_get_size(mem_block: gpointer) -> gsize;
}
extern "C" {
    pub fn g_ref_count_init(rc: *mut grefcount);
}
extern "C" {
    pub fn g_ref_count_inc(rc: *mut grefcount);
}
extern "C" {
    pub fn g_ref_count_dec(rc: *mut grefcount) -> gboolean;
}
extern "C" {
    pub fn g_ref_count_compare(rc: *mut grefcount, val: gint) -> gboolean;
}
extern "C" {
    pub fn g_atomic_ref_count_init(arc: *mut gatomicrefcount);
}
extern "C" {
    pub fn g_atomic_ref_count_inc(arc: *mut gatomicrefcount);
}
extern "C" {
    pub fn g_atomic_ref_count_dec(arc: *mut gatomicrefcount) -> gboolean;
}
extern "C" {
    pub fn g_atomic_ref_count_compare(arc: *mut gatomicrefcount, val: gint) -> gboolean;
}
extern "C" {
    pub fn g_ref_string_new(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_new_len(
        str_: *const ::std::os::raw::c_char,
        len: gssize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_new_intern(
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_acquire(str_: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_ref_string_release(str_: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_ref_string_length(str_: *mut ::std::os::raw::c_char) -> gsize;
}
#[doc = " GRefString:"]
#[doc = ""]
#[doc = " A typedef for a reference-counted string. A pointer to a #GRefString can be"]
#[doc = " treated like a standard `char*` array by all code, but can additionally have"]
#[doc = " `g_ref_string_*()` methods called on it. `g_ref_string_*()` methods cannot be"]
#[doc = " called on `char*` arrays not allocated using g_ref_string_new()."]
#[doc = ""]
#[doc = " If using #GRefString with autocleanups, g_autoptr() must be used rather than"]
#[doc = " g_autofree(), so that the reference counting metadata is also freed."]
#[doc = ""]
#[doc = " Since: 2.58"]
pub type GRefString = ::std::os::raw::c_char;
pub const GRegexError_G_REGEX_ERROR_COMPILE: GRegexError = 0;
pub const GRegexError_G_REGEX_ERROR_OPTIMIZE: GRegexError = 1;
pub const GRegexError_G_REGEX_ERROR_REPLACE: GRegexError = 2;
pub const GRegexError_G_REGEX_ERROR_MATCH: GRegexError = 3;
pub const GRegexError_G_REGEX_ERROR_INTERNAL: GRegexError = 4;
pub const GRegexError_G_REGEX_ERROR_STRAY_BACKSLASH: GRegexError = 101;
pub const GRegexError_G_REGEX_ERROR_MISSING_CONTROL_CHAR: GRegexError = 102;
pub const GRegexError_G_REGEX_ERROR_UNRECOGNIZED_ESCAPE: GRegexError = 103;
pub const GRegexError_G_REGEX_ERROR_QUANTIFIERS_OUT_OF_ORDER: GRegexError = 104;
pub const GRegexError_G_REGEX_ERROR_QUANTIFIER_TOO_BIG: GRegexError = 105;
pub const GRegexError_G_REGEX_ERROR_UNTERMINATED_CHARACTER_CLASS: GRegexError = 106;
pub const GRegexError_G_REGEX_ERROR_INVALID_ESCAPE_IN_CHARACTER_CLASS: GRegexError = 107;
pub const GRegexError_G_REGEX_ERROR_RANGE_OUT_OF_ORDER: GRegexError = 108;
pub const GRegexError_G_REGEX_ERROR_NOTHING_TO_REPEAT: GRegexError = 109;
pub const GRegexError_G_REGEX_ERROR_UNRECOGNIZED_CHARACTER: GRegexError = 112;
pub const GRegexError_G_REGEX_ERROR_POSIX_NAMED_CLASS_OUTSIDE_CLASS: GRegexError = 113;
pub const GRegexError_G_REGEX_ERROR_UNMATCHED_PARENTHESIS: GRegexError = 114;
pub const GRegexError_G_REGEX_ERROR_INEXISTENT_SUBPATTERN_REFERENCE: GRegexError = 115;
pub const GRegexError_G_REGEX_ERROR_UNTERMINATED_COMMENT: GRegexError = 118;
pub const GRegexError_G_REGEX_ERROR_EXPRESSION_TOO_LARGE: GRegexError = 120;
pub const GRegexError_G_REGEX_ERROR_MEMORY_ERROR: GRegexError = 121;
pub const GRegexError_G_REGEX_ERROR_VARIABLE_LENGTH_LOOKBEHIND: GRegexError = 125;
pub const GRegexError_G_REGEX_ERROR_MALFORMED_CONDITION: GRegexError = 126;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_CONDITIONAL_BRANCHES: GRegexError = 127;
pub const GRegexError_G_REGEX_ERROR_ASSERTION_EXPECTED: GRegexError = 128;
pub const GRegexError_G_REGEX_ERROR_UNKNOWN_POSIX_CLASS_NAME: GRegexError = 130;
pub const GRegexError_G_REGEX_ERROR_POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED: GRegexError = 131;
pub const GRegexError_G_REGEX_ERROR_HEX_CODE_TOO_LARGE: GRegexError = 134;
pub const GRegexError_G_REGEX_ERROR_INVALID_CONDITION: GRegexError = 135;
pub const GRegexError_G_REGEX_ERROR_SINGLE_BYTE_MATCH_IN_LOOKBEHIND: GRegexError = 136;
pub const GRegexError_G_REGEX_ERROR_INFINITE_LOOP: GRegexError = 140;
pub const GRegexError_G_REGEX_ERROR_MISSING_SUBPATTERN_NAME_TERMINATOR: GRegexError = 142;
pub const GRegexError_G_REGEX_ERROR_DUPLICATE_SUBPATTERN_NAME: GRegexError = 143;
pub const GRegexError_G_REGEX_ERROR_MALFORMED_PROPERTY: GRegexError = 146;
pub const GRegexError_G_REGEX_ERROR_UNKNOWN_PROPERTY: GRegexError = 147;
pub const GRegexError_G_REGEX_ERROR_SUBPATTERN_NAME_TOO_LONG: GRegexError = 148;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_SUBPATTERNS: GRegexError = 149;
pub const GRegexError_G_REGEX_ERROR_INVALID_OCTAL_VALUE: GRegexError = 151;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_BRANCHES_IN_DEFINE: GRegexError = 154;
pub const GRegexError_G_REGEX_ERROR_DEFINE_REPETION: GRegexError = 155;
pub const GRegexError_G_REGEX_ERROR_INCONSISTENT_NEWLINE_OPTIONS: GRegexError = 156;
pub const GRegexError_G_REGEX_ERROR_MISSING_BACK_REFERENCE: GRegexError = 157;
pub const GRegexError_G_REGEX_ERROR_INVALID_RELATIVE_REFERENCE: GRegexError = 158;
pub const GRegexError_G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN: GRegexError = 159;
pub const GRegexError_G_REGEX_ERROR_UNKNOWN_BACKTRACKING_CONTROL_VERB: GRegexError = 160;
pub const GRegexError_G_REGEX_ERROR_NUMBER_TOO_BIG: GRegexError = 161;
pub const GRegexError_G_REGEX_ERROR_MISSING_SUBPATTERN_NAME: GRegexError = 162;
pub const GRegexError_G_REGEX_ERROR_MISSING_DIGIT: GRegexError = 163;
pub const GRegexError_G_REGEX_ERROR_INVALID_DATA_CHARACTER: GRegexError = 164;
pub const GRegexError_G_REGEX_ERROR_EXTRA_SUBPATTERN_NAME: GRegexError = 165;
pub const GRegexError_G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED: GRegexError = 166;
pub const GRegexError_G_REGEX_ERROR_INVALID_CONTROL_CHAR: GRegexError = 168;
pub const GRegexError_G_REGEX_ERROR_MISSING_NAME: GRegexError = 169;
pub const GRegexError_G_REGEX_ERROR_NOT_SUPPORTED_IN_CLASS: GRegexError = 171;
pub const GRegexError_G_REGEX_ERROR_TOO_MANY_FORWARD_REFERENCES: GRegexError = 172;
pub const GRegexError_G_REGEX_ERROR_NAME_TOO_LONG: GRegexError = 175;
pub const GRegexError_G_REGEX_ERROR_CHARACTER_VALUE_TOO_LARGE: GRegexError = 176;
#[doc = " GRegexError:"]
#[doc = " @G_REGEX_ERROR_COMPILE: Compilation of the regular expression failed."]
#[doc = " @G_REGEX_ERROR_OPTIMIZE: Optimization of the regular expression failed."]
#[doc = " @G_REGEX_ERROR_REPLACE: Replacement failed due to an ill-formed replacement"]
#[doc = "     string."]
#[doc = " @G_REGEX_ERROR_MATCH: The match process failed."]
#[doc = " @G_REGEX_ERROR_INTERNAL: Internal error of the regular expression engine."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_STRAY_BACKSLASH: \"\\\\\" at end of pattern. Since 2.16"]
#[doc = " @G_REGEX_ERROR_MISSING_CONTROL_CHAR: \"\\\\c\" at end of pattern. Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNRECOGNIZED_ESCAPE: Unrecognized character follows \"\\\\\"."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_QUANTIFIERS_OUT_OF_ORDER: Numbers out of order in \"{}\""]
#[doc = "     quantifier. Since 2.16"]
#[doc = " @G_REGEX_ERROR_QUANTIFIER_TOO_BIG: Number too big in \"{}\" quantifier."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNTERMINATED_CHARACTER_CLASS: Missing terminating \"]\" for"]
#[doc = "     character class. Since 2.16"]
#[doc = " @G_REGEX_ERROR_INVALID_ESCAPE_IN_CHARACTER_CLASS: Invalid escape sequence"]
#[doc = "     in character class. Since 2.16"]
#[doc = " @G_REGEX_ERROR_RANGE_OUT_OF_ORDER: Range out of order in character class."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_NOTHING_TO_REPEAT: Nothing to repeat. Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNRECOGNIZED_CHARACTER: Unrecognized character after \"(?\","]
#[doc = "     \"(?<\" or \"(?P\". Since 2.16"]
#[doc = " @G_REGEX_ERROR_POSIX_NAMED_CLASS_OUTSIDE_CLASS: POSIX named classes are"]
#[doc = "     supported only within a class. Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNMATCHED_PARENTHESIS: Missing terminating \")\" or \")\""]
#[doc = "     without opening \"(\". Since 2.16"]
#[doc = " @G_REGEX_ERROR_INEXISTENT_SUBPATTERN_REFERENCE: Reference to non-existent"]
#[doc = "     subpattern. Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNTERMINATED_COMMENT: Missing terminating \")\" after comment."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_EXPRESSION_TOO_LARGE: Regular expression too large."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_MEMORY_ERROR: Failed to get memory. Since 2.16"]
#[doc = " @G_REGEX_ERROR_VARIABLE_LENGTH_LOOKBEHIND: Lookbehind assertion is not"]
#[doc = "     fixed length. Since 2.16"]
#[doc = " @G_REGEX_ERROR_MALFORMED_CONDITION: Malformed number or name after \"(?(\"."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_TOO_MANY_CONDITIONAL_BRANCHES: Conditional group contains"]
#[doc = "     more than two branches. Since 2.16"]
#[doc = " @G_REGEX_ERROR_ASSERTION_EXPECTED: Assertion expected after \"(?(\"."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNKNOWN_POSIX_CLASS_NAME: Unknown POSIX class name."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED: POSIX collating"]
#[doc = "     elements are not supported. Since 2.16"]
#[doc = " @G_REGEX_ERROR_HEX_CODE_TOO_LARGE: Character value in \"\\\\x{...}\" sequence"]
#[doc = "     is too large. Since 2.16"]
#[doc = " @G_REGEX_ERROR_INVALID_CONDITION: Invalid condition \"(?(0)\". Since 2.16"]
#[doc = " @G_REGEX_ERROR_SINGLE_BYTE_MATCH_IN_LOOKBEHIND: \\\\C not allowed in"]
#[doc = "     lookbehind assertion. Since 2.16"]
#[doc = " @G_REGEX_ERROR_INFINITE_LOOP: Recursive call could loop indefinitely."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_MISSING_SUBPATTERN_NAME_TERMINATOR: Missing terminator"]
#[doc = "     in subpattern name. Since 2.16"]
#[doc = " @G_REGEX_ERROR_DUPLICATE_SUBPATTERN_NAME: Two named subpatterns have"]
#[doc = "     the same name. Since 2.16"]
#[doc = " @G_REGEX_ERROR_MALFORMED_PROPERTY: Malformed \"\\\\P\" or \"\\\\p\" sequence."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_UNKNOWN_PROPERTY: Unknown property name after \"\\\\P\" or"]
#[doc = "     \"\\\\p\". Since 2.16"]
#[doc = " @G_REGEX_ERROR_SUBPATTERN_NAME_TOO_LONG: Subpattern name is too long"]
#[doc = "     (maximum 32 characters). Since 2.16"]
#[doc = " @G_REGEX_ERROR_TOO_MANY_SUBPATTERNS: Too many named subpatterns (maximum"]
#[doc = "     10,000). Since 2.16"]
#[doc = " @G_REGEX_ERROR_INVALID_OCTAL_VALUE: Octal value is greater than \"\\\\377\"."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_TOO_MANY_BRANCHES_IN_DEFINE: \"DEFINE\" group contains more"]
#[doc = "     than one branch. Since 2.16"]
#[doc = " @G_REGEX_ERROR_DEFINE_REPETION: Repeating a \"DEFINE\" group is not allowed."]
#[doc = "     This error is never raised. Since: 2.16 Deprecated: 2.34"]
#[doc = " @G_REGEX_ERROR_INCONSISTENT_NEWLINE_OPTIONS: Inconsistent newline options."]
#[doc = "     Since 2.16"]
#[doc = " @G_REGEX_ERROR_MISSING_BACK_REFERENCE: \"\\\\g\" is not followed by a braced,"]
#[doc = "      angle-bracketed, or quoted name or number, or by a plain number. Since: 2.16"]
#[doc = " @G_REGEX_ERROR_INVALID_RELATIVE_REFERENCE: relative reference must not be zero. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN: the backtracing"]
#[doc = "     control verb used does not allow an argument. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_UNKNOWN_BACKTRACKING_CONTROL_VERB: unknown backtracing"]
#[doc = "     control verb. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_NUMBER_TOO_BIG: number is too big in escape sequence. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_MISSING_SUBPATTERN_NAME: Missing subpattern name. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_MISSING_DIGIT: Missing digit. Since 2.34"]
#[doc = " @G_REGEX_ERROR_INVALID_DATA_CHARACTER: In JavaScript compatibility mode,"]
#[doc = "     \"[\" is an invalid data character. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_EXTRA_SUBPATTERN_NAME: different names for subpatterns of the"]
#[doc = "     same number are not allowed. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED: the backtracing control"]
#[doc = "     verb requires an argument. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_INVALID_CONTROL_CHAR: \"\\\\c\" must be followed by an ASCII"]
#[doc = "     character. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_MISSING_NAME: \"\\\\k\" is not followed by a braced, angle-bracketed, or"]
#[doc = "     quoted name. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_NOT_SUPPORTED_IN_CLASS: \"\\\\N\" is not supported in a class. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_TOO_MANY_FORWARD_REFERENCES: too many forward references. Since: 2.34"]
#[doc = " @G_REGEX_ERROR_NAME_TOO_LONG: the name is too long in \"(*MARK)\", \"(*PRUNE)\","]
#[doc = "     \"(*SKIP)\", or \"(*THEN)\". Since: 2.34"]
#[doc = " @G_REGEX_ERROR_CHARACTER_VALUE_TOO_LARGE: the character value in the \\\\u sequence is"]
#[doc = "     too large. Since: 2.34"]
#[doc = ""]
#[doc = " Error codes returned by regular expressions functions."]
#[doc = ""]
#[doc = " Since: 2.14"]
pub type GRegexError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_regex_error_quark() -> GQuark;
}
pub const GRegexCompileFlags_G_REGEX_CASELESS: GRegexCompileFlags = 1;
pub const GRegexCompileFlags_G_REGEX_MULTILINE: GRegexCompileFlags = 2;
pub const GRegexCompileFlags_G_REGEX_DOTALL: GRegexCompileFlags = 4;
pub const GRegexCompileFlags_G_REGEX_EXTENDED: GRegexCompileFlags = 8;
pub const GRegexCompileFlags_G_REGEX_ANCHORED: GRegexCompileFlags = 16;
pub const GRegexCompileFlags_G_REGEX_DOLLAR_ENDONLY: GRegexCompileFlags = 32;
pub const GRegexCompileFlags_G_REGEX_UNGREEDY: GRegexCompileFlags = 512;
pub const GRegexCompileFlags_G_REGEX_RAW: GRegexCompileFlags = 2048;
pub const GRegexCompileFlags_G_REGEX_NO_AUTO_CAPTURE: GRegexCompileFlags = 4096;
pub const GRegexCompileFlags_G_REGEX_OPTIMIZE: GRegexCompileFlags = 8192;
pub const GRegexCompileFlags_G_REGEX_FIRSTLINE: GRegexCompileFlags = 262144;
pub const GRegexCompileFlags_G_REGEX_DUPNAMES: GRegexCompileFlags = 524288;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_CR: GRegexCompileFlags = 1048576;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_LF: GRegexCompileFlags = 2097152;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_CRLF: GRegexCompileFlags = 3145728;
pub const GRegexCompileFlags_G_REGEX_NEWLINE_ANYCRLF: GRegexCompileFlags = 5242880;
pub const GRegexCompileFlags_G_REGEX_BSR_ANYCRLF: GRegexCompileFlags = 8388608;
pub const GRegexCompileFlags_G_REGEX_JAVASCRIPT_COMPAT: GRegexCompileFlags = 33554432;
#[doc = " GRegexCompileFlags:"]
#[doc = " @G_REGEX_CASELESS: Letters in the pattern match both upper- and"]
#[doc = "     lowercase letters. This option can be changed within a pattern"]
#[doc = "     by a \"(?i)\" option setting."]
#[doc = " @G_REGEX_MULTILINE: By default, GRegex treats the strings as consisting"]
#[doc = "     of a single line of characters (even if it actually contains"]
#[doc = "     newlines). The \"start of line\" metacharacter (\"^\") matches only"]
#[doc = "     at the start of the string, while the \"end of line\" metacharacter"]
#[doc = "     (\"$\") matches only at the end of the string, or before a terminating"]
#[doc = "     newline (unless #G_REGEX_DOLLAR_ENDONLY is set). When"]
#[doc = "     #G_REGEX_MULTILINE is set, the \"start of line\" and \"end of line\""]
#[doc = "     constructs match immediately following or immediately before any"]
#[doc = "     newline in the string, respectively, as well as at the very start"]
#[doc = "     and end. This can be changed within a pattern by a \"(?m)\" option"]
#[doc = "     setting."]
#[doc = " @G_REGEX_DOTALL: A dot metacharacter (\".\") in the pattern matches all"]
#[doc = "     characters, including newlines. Without it, newlines are excluded."]
#[doc = "     This option can be changed within a pattern by a (\"?s\") option setting."]
#[doc = " @G_REGEX_EXTENDED: Whitespace data characters in the pattern are"]
#[doc = "     totally ignored except when escaped or inside a character class."]
#[doc = "     Whitespace does not include the VT character (code 11). In addition,"]
#[doc = "     characters between an unescaped \"#\" outside a character class and"]
#[doc = "     the next newline character, inclusive, are also ignored. This can"]
#[doc = "     be changed within a pattern by a \"(?x)\" option setting."]
#[doc = " @G_REGEX_ANCHORED: The pattern is forced to be \"anchored\", that is,"]
#[doc = "     it is constrained to match only at the first matching point in the"]
#[doc = "     string that is being searched. This effect can also be achieved by"]
#[doc = "     appropriate constructs in the pattern itself such as the \"^\""]
#[doc = "     metacharacter."]
#[doc = " @G_REGEX_DOLLAR_ENDONLY: A dollar metacharacter (\"$\") in the pattern"]
#[doc = "     matches only at the end of the string. Without this option, a"]
#[doc = "     dollar also matches immediately before the final character if"]
#[doc = "     it is a newline (but not before any other newlines). This option"]
#[doc = "     is ignored if #G_REGEX_MULTILINE is set."]
#[doc = " @G_REGEX_UNGREEDY: Inverts the \"greediness\" of the quantifiers so that"]
#[doc = "     they are not greedy by default, but become greedy if followed by \"?\"."]
#[doc = "     It can also be set by a \"(?U)\" option setting within the pattern."]
#[doc = " @G_REGEX_RAW: Usually strings must be valid UTF-8 strings, using this"]
#[doc = "     flag they are considered as a raw sequence of bytes."]
#[doc = " @G_REGEX_NO_AUTO_CAPTURE: Disables the use of numbered capturing"]
#[doc = "     parentheses in the pattern. Any opening parenthesis that is not"]
#[doc = "     followed by \"?\" behaves as if it were followed by \"?:\" but named"]
#[doc = "     parentheses can still be used for capturing (and they acquire numbers"]
#[doc = "     in the usual way)."]
#[doc = " @G_REGEX_OPTIMIZE: Optimize the regular expression. If the pattern will"]
#[doc = "     be used many times, then it may be worth the effort to optimize it"]
#[doc = "     to improve the speed of matches."]
#[doc = " @G_REGEX_FIRSTLINE: Limits an unanchored pattern to match before (or at) the"]
#[doc = "     first newline. Since: 2.34"]
#[doc = " @G_REGEX_DUPNAMES: Names used to identify capturing subpatterns need not"]
#[doc = "     be unique. This can be helpful for certain types of pattern when it"]
#[doc = "     is known that only one instance of the named subpattern can ever be"]
#[doc = "     matched."]
#[doc = " @G_REGEX_NEWLINE_CR: Usually any newline character or character sequence is"]
#[doc = "     recognized. If this option is set, the only recognized newline character"]
#[doc = "     is '\\r'."]
#[doc = " @G_REGEX_NEWLINE_LF: Usually any newline character or character sequence is"]
#[doc = "     recognized. If this option is set, the only recognized newline character"]
#[doc = "     is '\\n'."]
#[doc = " @G_REGEX_NEWLINE_CRLF: Usually any newline character or character sequence is"]
#[doc = "     recognized. If this option is set, the only recognized newline character"]
#[doc = "     sequence is '\\r\\n'."]
#[doc = " @G_REGEX_NEWLINE_ANYCRLF: Usually any newline character or character sequence"]
#[doc = "     is recognized. If this option is set, the only recognized newline character"]
#[doc = "     sequences are '\\r', '\\n', and '\\r\\n'. Since: 2.34"]
#[doc = " @G_REGEX_BSR_ANYCRLF: Usually any newline character or character sequence"]
#[doc = "     is recognised. If this option is set, then \"\\R\" only recognizes the newline"]
#[doc = "    characters '\\r', '\\n' and '\\r\\n'. Since: 2.34"]
#[doc = " @G_REGEX_JAVASCRIPT_COMPAT: Changes behaviour so that it is compatible with"]
#[doc = "     JavaScript rather than PCRE. Since: 2.34"]
#[doc = ""]
#[doc = " Flags specifying compile-time options."]
#[doc = ""]
#[doc = " Since: 2.14"]
pub type GRegexCompileFlags = ::std::os::raw::c_uint;
pub const GRegexMatchFlags_G_REGEX_MATCH_ANCHORED: GRegexMatchFlags = 16;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTBOL: GRegexMatchFlags = 128;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTEOL: GRegexMatchFlags = 256;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTEMPTY: GRegexMatchFlags = 1024;
pub const GRegexMatchFlags_G_REGEX_MATCH_PARTIAL: GRegexMatchFlags = 32768;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_CR: GRegexMatchFlags = 1048576;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_LF: GRegexMatchFlags = 2097152;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_CRLF: GRegexMatchFlags = 3145728;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_ANY: GRegexMatchFlags = 4194304;
pub const GRegexMatchFlags_G_REGEX_MATCH_NEWLINE_ANYCRLF: GRegexMatchFlags = 5242880;
pub const GRegexMatchFlags_G_REGEX_MATCH_BSR_ANYCRLF: GRegexMatchFlags = 8388608;
pub const GRegexMatchFlags_G_REGEX_MATCH_BSR_ANY: GRegexMatchFlags = 16777216;
pub const GRegexMatchFlags_G_REGEX_MATCH_PARTIAL_SOFT: GRegexMatchFlags = 32768;
pub const GRegexMatchFlags_G_REGEX_MATCH_PARTIAL_HARD: GRegexMatchFlags = 134217728;
pub const GRegexMatchFlags_G_REGEX_MATCH_NOTEMPTY_ATSTART: GRegexMatchFlags = 268435456;
#[doc = " GRegexMatchFlags:"]
#[doc = " @G_REGEX_MATCH_ANCHORED: The pattern is forced to be \"anchored\", that is,"]
#[doc = "     it is constrained to match only at the first matching point in the"]
#[doc = "     string that is being searched. This effect can also be achieved by"]
#[doc = "     appropriate constructs in the pattern itself such as the \"^\""]
#[doc = "     metacharacter."]
#[doc = " @G_REGEX_MATCH_NOTBOL: Specifies that first character of the string is"]
#[doc = "     not the beginning of a line, so the circumflex metacharacter should"]
#[doc = "     not match before it. Setting this without #G_REGEX_MULTILINE (at"]
#[doc = "     compile time) causes circumflex never to match. This option affects"]
#[doc = "     only the behaviour of the circumflex metacharacter, it does not"]
#[doc = "     affect \"\\A\"."]
#[doc = " @G_REGEX_MATCH_NOTEOL: Specifies that the end of the subject string is"]
#[doc = "     not the end of a line, so the dollar metacharacter should not match"]
#[doc = "     it nor (except in multiline mode) a newline immediately before it."]
#[doc = "     Setting this without #G_REGEX_MULTILINE (at compile time) causes"]
#[doc = "     dollar never to match. This option affects only the behaviour of"]
#[doc = "     the dollar metacharacter, it does not affect \"\\Z\" or \"\\z\"."]
#[doc = " @G_REGEX_MATCH_NOTEMPTY: An empty string is not considered to be a valid"]
#[doc = "     match if this option is set. If there are alternatives in the pattern,"]
#[doc = "     they are tried. If all the alternatives match the empty string, the"]
#[doc = "     entire match fails. For example, if the pattern \"a?b?\" is applied to"]
#[doc = "     a string not beginning with \"a\" or \"b\", it matches the empty string"]
#[doc = "     at the start of the string. With this flag set, this match is not"]
#[doc = "     valid, so GRegex searches further into the string for occurrences"]
#[doc = "     of \"a\" or \"b\"."]
#[doc = " @G_REGEX_MATCH_PARTIAL: Turns on the partial matching feature, for more"]
#[doc = "     documentation on partial matching see g_match_info_is_partial_match()."]
#[doc = " @G_REGEX_MATCH_NEWLINE_CR: Overrides the newline definition set when"]
#[doc = "     creating a new #GRegex, setting the '\\r' character as line terminator."]
#[doc = " @G_REGEX_MATCH_NEWLINE_LF: Overrides the newline definition set when"]
#[doc = "     creating a new #GRegex, setting the '\\n' character as line terminator."]
#[doc = " @G_REGEX_MATCH_NEWLINE_CRLF: Overrides the newline definition set when"]
#[doc = "     creating a new #GRegex, setting the '\\r\\n' characters sequence as line terminator."]
#[doc = " @G_REGEX_MATCH_NEWLINE_ANY: Overrides the newline definition set when"]
#[doc = "     creating a new #GRegex, any Unicode newline sequence"]
#[doc = "     is recognised as a newline. These are '\\r', '\\n' and '\\rn', and the"]
#[doc = "     single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),"]
#[doc = "     U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and"]
#[doc = "     U+2029 PARAGRAPH SEPARATOR."]
#[doc = " @G_REGEX_MATCH_NEWLINE_ANYCRLF: Overrides the newline definition set when"]
#[doc = "     creating a new #GRegex; any '\\r', '\\n', or '\\r\\n' character sequence"]
#[doc = "     is recognized as a newline. Since: 2.34"]
#[doc = " @G_REGEX_MATCH_BSR_ANYCRLF: Overrides the newline definition for \"\\R\" set when"]
#[doc = "     creating a new #GRegex; only '\\r', '\\n', or '\\r\\n' character sequences"]
#[doc = "     are recognized as a newline by \"\\R\". Since: 2.34"]
#[doc = " @G_REGEX_MATCH_BSR_ANY: Overrides the newline definition for \"\\R\" set when"]
#[doc = "     creating a new #GRegex; any Unicode newline character or character sequence"]
#[doc = "     are recognized as a newline by \"\\R\". These are '\\r', '\\n' and '\\rn', and the"]
#[doc = "     single characters U+000B LINE TABULATION, U+000C FORM FEED (FF),"]
#[doc = "     U+0085 NEXT LINE (NEL), U+2028 LINE SEPARATOR and"]
#[doc = "     U+2029 PARAGRAPH SEPARATOR. Since: 2.34"]
#[doc = " @G_REGEX_MATCH_PARTIAL_SOFT: An alias for #G_REGEX_MATCH_PARTIAL. Since: 2.34"]
#[doc = " @G_REGEX_MATCH_PARTIAL_HARD: Turns on the partial matching feature. In contrast to"]
#[doc = "     to #G_REGEX_MATCH_PARTIAL_SOFT, this stops matching as soon as a partial match"]
#[doc = "     is found, without continuing to search for a possible complete match. See"]
#[doc = "     g_match_info_is_partial_match() for more information. Since: 2.34"]
#[doc = " @G_REGEX_MATCH_NOTEMPTY_ATSTART: Like #G_REGEX_MATCH_NOTEMPTY, but only applied to"]
#[doc = "     the start of the matched string. For anchored"]
#[doc = "     patterns this can only happen for pattern containing \"\\K\". Since: 2.34"]
#[doc = ""]
#[doc = " Flags specifying match-time options."]
#[doc = ""]
#[doc = " Since: 2.14"]
pub type GRegexMatchFlags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRegex {
    _unused: [u8; 0],
}
#[doc = " GRegex:"]
#[doc = ""]
#[doc = " A GRegex is the \"compiled\" form of a regular expression pattern."]
#[doc = " This structure is opaque and its fields cannot be accessed directly."]
#[doc = ""]
#[doc = " Since: 2.14"]
pub type GRegex = _GRegex;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMatchInfo {
    _unused: [u8; 0],
}
#[doc = " GMatchInfo:"]
#[doc = ""]
#[doc = " A GMatchInfo is an opaque struct used to return information about"]
#[doc = " matches."]
pub type GMatchInfo = _GMatchInfo;
#[doc = " GRegexEvalCallback:"]
#[doc = " @match_info: the #GMatchInfo generated by the match."]
#[doc = "     Use g_match_info_get_regex() and g_match_info_get_string() if you"]
#[doc = "     need the #GRegex or the matched string."]
#[doc = " @result: a #GString containing the new string"]
#[doc = " @user_data: user data passed to g_regex_replace_eval()"]
#[doc = ""]
#[doc = " Specifies the type of the function passed to g_regex_replace_eval()."]
#[doc = " It is called for each occurrence of the pattern in the string passed"]
#[doc = " to g_regex_replace_eval(), and it should append the replacement to"]
#[doc = " @result."]
#[doc = ""]
#[doc = " Returns: %FALSE to continue the replacement process, %TRUE to stop it"]
#[doc = ""]
#[doc = " Since: 2.14"]
pub type GRegexEvalCallback = ::std::option::Option<
    unsafe extern "C" fn(
        match_info: *const GMatchInfo,
        result: *mut GString,
        user_data: gpointer,
    ) -> gboolean,
>;
extern "C" {
    pub fn g_regex_new(
        pattern: *const gchar,
        compile_options: GRegexCompileFlags,
        match_options: GRegexMatchFlags,
        error: *mut *mut GError,
    ) -> *mut GRegex;
}
extern "C" {
    pub fn g_regex_ref(regex: *mut GRegex) -> *mut GRegex;
}
extern "C" {
    pub fn g_regex_unref(regex: *mut GRegex);
}
extern "C" {
    pub fn g_regex_get_pattern(regex: *const GRegex) -> *const gchar;
}
extern "C" {
    pub fn g_regex_get_max_backref(regex: *const GRegex) -> gint;
}
extern "C" {
    pub fn g_regex_get_capture_count(regex: *const GRegex) -> gint;
}
extern "C" {
    pub fn g_regex_get_has_cr_or_lf(regex: *const GRegex) -> gboolean;
}
extern "C" {
    pub fn g_regex_get_max_lookbehind(regex: *const GRegex) -> gint;
}
extern "C" {
    pub fn g_regex_get_string_number(regex: *const GRegex, name: *const gchar) -> gint;
}
extern "C" {
    pub fn g_regex_escape_string(string: *const gchar, length: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_escape_nul(string: *const gchar, length: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_get_compile_flags(regex: *const GRegex) -> GRegexCompileFlags;
}
extern "C" {
    pub fn g_regex_get_match_flags(regex: *const GRegex) -> GRegexMatchFlags;
}
extern "C" {
    pub fn g_regex_match_simple(
        pattern: *const gchar,
        string: *const gchar,
        compile_options: GRegexCompileFlags,
        match_options: GRegexMatchFlags,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match(
        regex: *const GRegex,
        string: *const gchar,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match_full(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match_all(
        regex: *const GRegex,
        string: *const gchar,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_match_all_full(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        match_info: *mut *mut GMatchInfo,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_regex_split_simple(
        pattern: *const gchar,
        string: *const gchar,
        compile_options: GRegexCompileFlags,
        match_options: GRegexMatchFlags,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_regex_split(
        regex: *const GRegex,
        string: *const gchar,
        match_options: GRegexMatchFlags,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_regex_split_full(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        max_tokens: gint,
        error: *mut *mut GError,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_regex_replace(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        replacement: *const gchar,
        match_options: GRegexMatchFlags,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_replace_literal(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        replacement: *const gchar,
        match_options: GRegexMatchFlags,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_replace_eval(
        regex: *const GRegex,
        string: *const gchar,
        string_len: gssize,
        start_position: gint,
        match_options: GRegexMatchFlags,
        eval: GRegexEvalCallback,
        user_data: gpointer,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_regex_check_replacement(
        replacement: *const gchar,
        has_references: *mut gboolean,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_match_info_get_regex(match_info: *const GMatchInfo) -> *mut GRegex;
}
extern "C" {
    pub fn g_match_info_get_string(match_info: *const GMatchInfo) -> *const gchar;
}
extern "C" {
    pub fn g_match_info_ref(match_info: *mut GMatchInfo) -> *mut GMatchInfo;
}
extern "C" {
    pub fn g_match_info_unref(match_info: *mut GMatchInfo);
}
extern "C" {
    pub fn g_match_info_free(match_info: *mut GMatchInfo);
}
extern "C" {
    pub fn g_match_info_next(match_info: *mut GMatchInfo, error: *mut *mut GError) -> gboolean;
}
extern "C" {
    pub fn g_match_info_matches(match_info: *const GMatchInfo) -> gboolean;
}
extern "C" {
    pub fn g_match_info_get_match_count(match_info: *const GMatchInfo) -> gint;
}
extern "C" {
    pub fn g_match_info_is_partial_match(match_info: *const GMatchInfo) -> gboolean;
}
extern "C" {
    pub fn g_match_info_expand_references(
        match_info: *const GMatchInfo,
        string_to_expand: *const gchar,
        error: *mut *mut GError,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_match_info_fetch(match_info: *const GMatchInfo, match_num: gint) -> *mut gchar;
}
extern "C" {
    pub fn g_match_info_fetch_pos(
        match_info: *const GMatchInfo,
        match_num: gint,
        start_pos: *mut gint,
        end_pos: *mut gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_match_info_fetch_named(
        match_info: *const GMatchInfo,
        name: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_match_info_fetch_named_pos(
        match_info: *const GMatchInfo,
        name: *const gchar,
        start_pos: *mut gint,
        end_pos: *mut gint,
    ) -> gboolean;
}
extern "C" {
    pub fn g_match_info_fetch_all(match_info: *const GMatchInfo) -> *mut *mut gchar;
}
pub type GScanner = _GScanner;
pub type GScannerConfig = _GScannerConfig;
pub type GTokenValue = _GTokenValue;
pub type GScannerMsgFunc = ::std::option::Option<
    unsafe extern "C" fn(scanner: *mut GScanner, message: *mut gchar, error: gboolean),
>;
pub const GErrorType_G_ERR_UNKNOWN: GErrorType = 0;
pub const GErrorType_G_ERR_UNEXP_EOF: GErrorType = 1;
pub const GErrorType_G_ERR_UNEXP_EOF_IN_STRING: GErrorType = 2;
pub const GErrorType_G_ERR_UNEXP_EOF_IN_COMMENT: GErrorType = 3;
pub const GErrorType_G_ERR_NON_DIGIT_IN_CONST: GErrorType = 4;
pub const GErrorType_G_ERR_DIGIT_RADIX: GErrorType = 5;
pub const GErrorType_G_ERR_FLOAT_RADIX: GErrorType = 6;
pub const GErrorType_G_ERR_FLOAT_MALFORMED: GErrorType = 7;
pub type GErrorType = ::std::os::raw::c_uint;
pub const GTokenType_G_TOKEN_EOF: GTokenType = 0;
pub const GTokenType_G_TOKEN_LEFT_PAREN: GTokenType = 40;
pub const GTokenType_G_TOKEN_RIGHT_PAREN: GTokenType = 41;
pub const GTokenType_G_TOKEN_LEFT_CURLY: GTokenType = 123;
pub const GTokenType_G_TOKEN_RIGHT_CURLY: GTokenType = 125;
pub const GTokenType_G_TOKEN_LEFT_BRACE: GTokenType = 91;
pub const GTokenType_G_TOKEN_RIGHT_BRACE: GTokenType = 93;
pub const GTokenType_G_TOKEN_EQUAL_SIGN: GTokenType = 61;
pub const GTokenType_G_TOKEN_COMMA: GTokenType = 44;
pub const GTokenType_G_TOKEN_NONE: GTokenType = 256;
pub const GTokenType_G_TOKEN_ERROR: GTokenType = 257;
pub const GTokenType_G_TOKEN_CHAR: GTokenType = 258;
pub const GTokenType_G_TOKEN_BINARY: GTokenType = 259;
pub const GTokenType_G_TOKEN_OCTAL: GTokenType = 260;
pub const GTokenType_G_TOKEN_INT: GTokenType = 261;
pub const GTokenType_G_TOKEN_HEX: GTokenType = 262;
pub const GTokenType_G_TOKEN_FLOAT: GTokenType = 263;
pub const GTokenType_G_TOKEN_STRING: GTokenType = 264;
pub const GTokenType_G_TOKEN_SYMBOL: GTokenType = 265;
pub const GTokenType_G_TOKEN_IDENTIFIER: GTokenType = 266;
pub const GTokenType_G_TOKEN_IDENTIFIER_NULL: GTokenType = 267;
pub const GTokenType_G_TOKEN_COMMENT_SINGLE: GTokenType = 268;
pub const GTokenType_G_TOKEN_COMMENT_MULTI: GTokenType = 269;
pub const GTokenType_G_TOKEN_LAST: GTokenType = 270;
pub type GTokenType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GTokenValue {
    pub v_symbol: gpointer,
    pub v_identifier: *mut gchar,
    pub v_binary: gulong,
    pub v_octal: gulong,
    pub v_int: gulong,
    pub v_int64: guint64,
    pub v_float: gdouble,
    pub v_hex: gulong,
    pub v_string: *mut gchar,
    pub v_comment: *mut gchar,
    pub v_char: guchar,
    pub v_error: guint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GScannerConfig {
    pub cset_skip_characters: *mut gchar,
    pub cset_identifier_first: *mut gchar,
    pub cset_identifier_nth: *mut gchar,
    pub cpair_comment_single: *mut gchar,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub padding_dummy: guint,
}
impl _GScannerConfig {
    #[inline]
    pub fn case_sensitive(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_case_sensitive(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_comment_multi(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_comment_multi(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn skip_comment_single(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_skip_comment_single(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_comment_multi(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_comment_multi(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_identifier(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_identifier(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_identifier_1char(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_identifier_1char(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_identifier_NULL(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_identifier_NULL(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_symbols(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_symbols(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_binary(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_binary(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_octal(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_octal(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_float(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_float(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_hex(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_hex(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_hex_dollar(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_hex_dollar(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_string_sq(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_string_sq(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scan_string_dq(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scan_string_dq(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn numbers_2_int(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_numbers_2_int(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn int_2_float(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_int_2_float(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn identifier_2_string(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_identifier_2_string(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn char_2_token(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_char_2_token(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn symbol_2_token(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_symbol_2_token(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scope_0_fallback(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scope_0_fallback(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn store_int64(&self) -> guint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_store_int64(&mut self, val: guint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        case_sensitive: guint,
        skip_comment_multi: guint,
        skip_comment_single: guint,
        scan_comment_multi: guint,
        scan_identifier: guint,
        scan_identifier_1char: guint,
        scan_identifier_NULL: guint,
        scan_symbols: guint,
        scan_binary: guint,
        scan_octal: guint,
        scan_float: guint,
        scan_hex: guint,
        scan_hex_dollar: guint,
        scan_string_sq: guint,
        scan_string_dq: guint,
        numbers_2_int: guint,
        int_2_float: guint,
        identifier_2_string: guint,
        char_2_token: guint,
        symbol_2_token: guint,
        scope_0_fallback: guint,
        store_int64: guint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let case_sensitive: u32 = unsafe { ::std::mem::transmute(case_sensitive) };
            case_sensitive as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let skip_comment_multi: u32 = unsafe { ::std::mem::transmute(skip_comment_multi) };
            skip_comment_multi as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let skip_comment_single: u32 = unsafe { ::std::mem::transmute(skip_comment_single) };
            skip_comment_single as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let scan_comment_multi: u32 = unsafe { ::std::mem::transmute(scan_comment_multi) };
            scan_comment_multi as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let scan_identifier: u32 = unsafe { ::std::mem::transmute(scan_identifier) };
            scan_identifier as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let scan_identifier_1char: u32 =
                unsafe { ::std::mem::transmute(scan_identifier_1char) };
            scan_identifier_1char as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let scan_identifier_NULL: u32 = unsafe { ::std::mem::transmute(scan_identifier_NULL) };
            scan_identifier_NULL as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let scan_symbols: u32 = unsafe { ::std::mem::transmute(scan_symbols) };
            scan_symbols as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let scan_binary: u32 = unsafe { ::std::mem::transmute(scan_binary) };
            scan_binary as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let scan_octal: u32 = unsafe { ::std::mem::transmute(scan_octal) };
            scan_octal as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let scan_float: u32 = unsafe { ::std::mem::transmute(scan_float) };
            scan_float as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let scan_hex: u32 = unsafe { ::std::mem::transmute(scan_hex) };
            scan_hex as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let scan_hex_dollar: u32 = unsafe { ::std::mem::transmute(scan_hex_dollar) };
            scan_hex_dollar as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let scan_string_sq: u32 = unsafe { ::std::mem::transmute(scan_string_sq) };
            scan_string_sq as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let scan_string_dq: u32 = unsafe { ::std::mem::transmute(scan_string_dq) };
            scan_string_dq as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let numbers_2_int: u32 = unsafe { ::std::mem::transmute(numbers_2_int) };
            numbers_2_int as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let int_2_float: u32 = unsafe { ::std::mem::transmute(int_2_float) };
            int_2_float as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let identifier_2_string: u32 = unsafe { ::std::mem::transmute(identifier_2_string) };
            identifier_2_string as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let char_2_token: u32 = unsafe { ::std::mem::transmute(char_2_token) };
            char_2_token as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let symbol_2_token: u32 = unsafe { ::std::mem::transmute(symbol_2_token) };
            symbol_2_token as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let scope_0_fallback: u32 = unsafe { ::std::mem::transmute(scope_0_fallback) };
            scope_0_fallback as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let store_int64: u32 = unsafe { ::std::mem::transmute(store_int64) };
            store_int64 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GScanner {
    pub user_data: gpointer,
    pub max_parse_errors: guint,
    pub parse_errors: guint,
    pub input_name: *const gchar,
    pub qdata: *mut GData,
    pub config: *mut GScannerConfig,
    pub token: GTokenType,
    pub value: GTokenValue,
    pub line: guint,
    pub position: guint,
    pub next_token: GTokenType,
    pub next_value: GTokenValue,
    pub next_line: guint,
    pub next_position: guint,
    pub symbol_table: *mut GHashTable,
    pub input_fd: gint,
    pub text: *const gchar,
    pub text_end: *const gchar,
    pub buffer: *mut gchar,
    pub scope_id: guint,
    pub msg_handler: GScannerMsgFunc,
}
extern "C" {
    pub fn g_scanner_new(config_templ: *const GScannerConfig) -> *mut GScanner;
}
extern "C" {
    pub fn g_scanner_destroy(scanner: *mut GScanner);
}
extern "C" {
    pub fn g_scanner_input_file(scanner: *mut GScanner, input_fd: gint);
}
extern "C" {
    pub fn g_scanner_sync_file_offset(scanner: *mut GScanner);
}
extern "C" {
    pub fn g_scanner_input_text(scanner: *mut GScanner, text: *const gchar, text_len: guint);
}
extern "C" {
    pub fn g_scanner_get_next_token(scanner: *mut GScanner) -> GTokenType;
}
extern "C" {
    pub fn g_scanner_peek_next_token(scanner: *mut GScanner) -> GTokenType;
}
extern "C" {
    pub fn g_scanner_cur_token(scanner: *mut GScanner) -> GTokenType;
}
extern "C" {
    pub fn g_scanner_cur_value(scanner: *mut GScanner) -> GTokenValue;
}
extern "C" {
    pub fn g_scanner_cur_line(scanner: *mut GScanner) -> guint;
}
extern "C" {
    pub fn g_scanner_cur_position(scanner: *mut GScanner) -> guint;
}
extern "C" {
    pub fn g_scanner_eof(scanner: *mut GScanner) -> gboolean;
}
extern "C" {
    pub fn g_scanner_set_scope(scanner: *mut GScanner, scope_id: guint) -> guint;
}
extern "C" {
    pub fn g_scanner_scope_add_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        symbol: *const gchar,
        value: gpointer,
    );
}
extern "C" {
    pub fn g_scanner_scope_remove_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        symbol: *const gchar,
    );
}
extern "C" {
    pub fn g_scanner_scope_lookup_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        symbol: *const gchar,
    ) -> gpointer;
}
extern "C" {
    pub fn g_scanner_scope_foreach_symbol(
        scanner: *mut GScanner,
        scope_id: guint,
        func: GHFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_scanner_lookup_symbol(scanner: *mut GScanner, symbol: *const gchar) -> gpointer;
}
extern "C" {
    pub fn g_scanner_unexp_token(
        scanner: *mut GScanner,
        expected_token: GTokenType,
        identifier_spec: *const gchar,
        symbol_spec: *const gchar,
        symbol_name: *const gchar,
        message: *const gchar,
        is_error: gint,
    );
}
extern "C" {
    pub fn g_scanner_error(scanner: *mut GScanner, format: *const gchar, ...);
}
extern "C" {
    pub fn g_scanner_warn(scanner: *mut GScanner, format: *const gchar, ...);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSequence {
    _unused: [u8; 0],
}
pub type GSequence = _GSequence;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSequenceNode {
    _unused: [u8; 0],
}
pub type GSequenceIter = _GSequenceNode;
pub type GSequenceIterCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(a: *mut GSequenceIter, b: *mut GSequenceIter, data: gpointer) -> gint,
>;
extern "C" {
    pub fn g_sequence_new(data_destroy: GDestroyNotify) -> *mut GSequence;
}
extern "C" {
    pub fn g_sequence_free(seq: *mut GSequence);
}
extern "C" {
    pub fn g_sequence_get_length(seq: *mut GSequence) -> gint;
}
extern "C" {
    pub fn g_sequence_foreach(seq: *mut GSequence, func: GFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_sequence_foreach_range(
        begin: *mut GSequenceIter,
        end: *mut GSequenceIter,
        func: GFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_sort(seq: *mut GSequence, cmp_func: GCompareDataFunc, cmp_data: gpointer);
}
extern "C" {
    pub fn g_sequence_sort_iter(
        seq: *mut GSequence,
        cmp_func: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_is_empty(seq: *mut GSequence) -> gboolean;
}
extern "C" {
    pub fn g_sequence_get_begin_iter(seq: *mut GSequence) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_get_end_iter(seq: *mut GSequence) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_get_iter_at_pos(seq: *mut GSequence, pos: gint) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_append(seq: *mut GSequence, data: gpointer) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_prepend(seq: *mut GSequence, data: gpointer) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_insert_before(iter: *mut GSequenceIter, data: gpointer)
        -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_move(src: *mut GSequenceIter, dest: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_swap(a: *mut GSequenceIter, b: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_insert_sorted(
        seq: *mut GSequence,
        data: gpointer,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_insert_sorted_iter(
        seq: *mut GSequence,
        data: gpointer,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_sort_changed(
        iter: *mut GSequenceIter,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_sort_changed_iter(
        iter: *mut GSequenceIter,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    );
}
extern "C" {
    pub fn g_sequence_remove(iter: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_remove_range(begin: *mut GSequenceIter, end: *mut GSequenceIter);
}
extern "C" {
    pub fn g_sequence_move_range(
        dest: *mut GSequenceIter,
        begin: *mut GSequenceIter,
        end: *mut GSequenceIter,
    );
}
extern "C" {
    pub fn g_sequence_search(
        seq: *mut GSequence,
        data: gpointer,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_search_iter(
        seq: *mut GSequence,
        data: gpointer,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_lookup(
        seq: *mut GSequence,
        data: gpointer,
        cmp_func: GCompareDataFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_lookup_iter(
        seq: *mut GSequence,
        data: gpointer,
        iter_cmp: GSequenceIterCompareFunc,
        cmp_data: gpointer,
    ) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_get(iter: *mut GSequenceIter) -> gpointer;
}
extern "C" {
    pub fn g_sequence_set(iter: *mut GSequenceIter, data: gpointer);
}
extern "C" {
    pub fn g_sequence_iter_is_begin(iter: *mut GSequenceIter) -> gboolean;
}
extern "C" {
    pub fn g_sequence_iter_is_end(iter: *mut GSequenceIter) -> gboolean;
}
extern "C" {
    pub fn g_sequence_iter_next(iter: *mut GSequenceIter) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_iter_prev(iter: *mut GSequenceIter) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_iter_get_position(iter: *mut GSequenceIter) -> gint;
}
extern "C" {
    pub fn g_sequence_iter_move(iter: *mut GSequenceIter, delta: gint) -> *mut GSequenceIter;
}
extern "C" {
    pub fn g_sequence_iter_get_sequence(iter: *mut GSequenceIter) -> *mut GSequence;
}
extern "C" {
    pub fn g_sequence_iter_compare(a: *mut GSequenceIter, b: *mut GSequenceIter) -> gint;
}
extern "C" {
    pub fn g_sequence_range_get_midpoint(
        begin: *mut GSequenceIter,
        end: *mut GSequenceIter,
    ) -> *mut GSequenceIter;
}
pub const GShellError_G_SHELL_ERROR_BAD_QUOTING: GShellError = 0;
pub const GShellError_G_SHELL_ERROR_EMPTY_STRING: GShellError = 1;
pub const GShellError_G_SHELL_ERROR_FAILED: GShellError = 2;
pub type GShellError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_shell_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_shell_quote(unquoted_string: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_shell_unquote(quoted_string: *const gchar, error: *mut *mut GError) -> *mut gchar;
}
extern "C" {
    pub fn g_shell_parse_argv(
        command_line: *const gchar,
        argcp: *mut gint,
        argvp: *mut *mut *mut gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_slice_alloc(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_slice_alloc0(block_size: gsize) -> gpointer;
}
extern "C" {
    pub fn g_slice_copy(block_size: gsize, mem_block: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_slice_free1(block_size: gsize, mem_block: gpointer);
}
extern "C" {
    pub fn g_slice_free_chain_with_offset(
        block_size: gsize,
        mem_chain: gpointer,
        next_offset: gsize,
    );
}
pub const GSliceConfig_G_SLICE_CONFIG_ALWAYS_MALLOC: GSliceConfig = 1;
pub const GSliceConfig_G_SLICE_CONFIG_BYPASS_MAGAZINES: GSliceConfig = 2;
pub const GSliceConfig_G_SLICE_CONFIG_WORKING_SET_MSECS: GSliceConfig = 3;
pub const GSliceConfig_G_SLICE_CONFIG_COLOR_INCREMENT: GSliceConfig = 4;
pub const GSliceConfig_G_SLICE_CONFIG_CHUNK_SIZES: GSliceConfig = 5;
pub const GSliceConfig_G_SLICE_CONFIG_CONTENTION_COUNTER: GSliceConfig = 6;
pub type GSliceConfig = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_slice_set_config(ckey: GSliceConfig, value: gint64);
}
extern "C" {
    pub fn g_slice_get_config(ckey: GSliceConfig) -> gint64;
}
extern "C" {
    pub fn g_slice_get_config_state(
        ckey: GSliceConfig,
        address: gint64,
        n_values: *mut guint,
    ) -> *mut gint64;
}
pub const GSpawnError_G_SPAWN_ERROR_FORK: GSpawnError = 0;
pub const GSpawnError_G_SPAWN_ERROR_READ: GSpawnError = 1;
pub const GSpawnError_G_SPAWN_ERROR_CHDIR: GSpawnError = 2;
pub const GSpawnError_G_SPAWN_ERROR_ACCES: GSpawnError = 3;
pub const GSpawnError_G_SPAWN_ERROR_PERM: GSpawnError = 4;
pub const GSpawnError_G_SPAWN_ERROR_TOO_BIG: GSpawnError = 5;
pub const GSpawnError_G_SPAWN_ERROR_2BIG: GSpawnError = 5;
pub const GSpawnError_G_SPAWN_ERROR_NOEXEC: GSpawnError = 6;
pub const GSpawnError_G_SPAWN_ERROR_NAMETOOLONG: GSpawnError = 7;
pub const GSpawnError_G_SPAWN_ERROR_NOENT: GSpawnError = 8;
pub const GSpawnError_G_SPAWN_ERROR_NOMEM: GSpawnError = 9;
pub const GSpawnError_G_SPAWN_ERROR_NOTDIR: GSpawnError = 10;
pub const GSpawnError_G_SPAWN_ERROR_LOOP: GSpawnError = 11;
pub const GSpawnError_G_SPAWN_ERROR_TXTBUSY: GSpawnError = 12;
pub const GSpawnError_G_SPAWN_ERROR_IO: GSpawnError = 13;
pub const GSpawnError_G_SPAWN_ERROR_NFILE: GSpawnError = 14;
pub const GSpawnError_G_SPAWN_ERROR_MFILE: GSpawnError = 15;
pub const GSpawnError_G_SPAWN_ERROR_INVAL: GSpawnError = 16;
pub const GSpawnError_G_SPAWN_ERROR_ISDIR: GSpawnError = 17;
pub const GSpawnError_G_SPAWN_ERROR_LIBBAD: GSpawnError = 18;
pub const GSpawnError_G_SPAWN_ERROR_FAILED: GSpawnError = 19;
#[doc = " GSpawnError:"]
#[doc = " @G_SPAWN_ERROR_FORK: Fork failed due to lack of memory."]
#[doc = " @G_SPAWN_ERROR_READ: Read or select on pipes failed."]
#[doc = " @G_SPAWN_ERROR_CHDIR: Changing to working directory failed."]
#[doc = " @G_SPAWN_ERROR_ACCES: execv() returned `EACCES`"]
#[doc = " @G_SPAWN_ERROR_PERM: execv() returned `EPERM`"]
#[doc = " @G_SPAWN_ERROR_TOO_BIG: execv() returned `E2BIG`"]
#[doc = " @G_SPAWN_ERROR_2BIG: deprecated alias for %G_SPAWN_ERROR_TOO_BIG (deprecated since GLib 2.32)"]
#[doc = " @G_SPAWN_ERROR_NOEXEC: execv() returned `ENOEXEC`"]
#[doc = " @G_SPAWN_ERROR_NAMETOOLONG: execv() returned `ENAMETOOLONG`"]
#[doc = " @G_SPAWN_ERROR_NOENT: execv() returned `ENOENT`"]
#[doc = " @G_SPAWN_ERROR_NOMEM: execv() returned `ENOMEM`"]
#[doc = " @G_SPAWN_ERROR_NOTDIR: execv() returned `ENOTDIR`"]
#[doc = " @G_SPAWN_ERROR_LOOP: execv() returned `ELOOP`"]
#[doc = " @G_SPAWN_ERROR_TXTBUSY: execv() returned `ETXTBUSY`"]
#[doc = " @G_SPAWN_ERROR_IO: execv() returned `EIO`"]
#[doc = " @G_SPAWN_ERROR_NFILE: execv() returned `ENFILE`"]
#[doc = " @G_SPAWN_ERROR_MFILE: execv() returned `EMFILE`"]
#[doc = " @G_SPAWN_ERROR_INVAL: execv() returned `EINVAL`"]
#[doc = " @G_SPAWN_ERROR_ISDIR: execv() returned `EISDIR`"]
#[doc = " @G_SPAWN_ERROR_LIBBAD: execv() returned `ELIBBAD`"]
#[doc = " @G_SPAWN_ERROR_FAILED: Some other fatal failure,"]
#[doc = "   `error->message` should explain."]
#[doc = ""]
#[doc = " Error codes returned by spawning processes."]
pub type GSpawnError = ::std::os::raw::c_uint;
#[doc = " GSpawnChildSetupFunc:"]
#[doc = " @user_data: (closure): user data to pass to the function."]
#[doc = ""]
#[doc = " Specifies the type of the setup function passed to g_spawn_async(),"]
#[doc = " g_spawn_sync() and g_spawn_async_with_pipes(), which can, in very"]
#[doc = " limited ways, be used to affect the child's execution."]
#[doc = ""]
#[doc = " On POSIX platforms, the function is called in the child after GLib"]
#[doc = " has performed all the setup it plans to perform, but before calling"]
#[doc = " exec(). Actions taken in this function will only affect the child,"]
#[doc = " not the parent."]
#[doc = ""]
#[doc = " On Windows, the function is called in the parent. Its usefulness on"]
#[doc = " Windows is thus questionable. In many cases executing the child setup"]
#[doc = " function in the parent can have ill effects, and you should be very"]
#[doc = " careful when porting software to Windows that uses child setup"]
#[doc = " functions."]
#[doc = ""]
#[doc = " However, even on POSIX, you are extremely limited in what you can"]
#[doc = " safely do from a #GSpawnChildSetupFunc, because any mutexes that were"]
#[doc = " held by other threads in the parent process at the time of the fork()"]
#[doc = " will still be locked in the child process, and they will never be"]
#[doc = " unlocked (since the threads that held them don't exist in the child)."]
#[doc = " POSIX allows only async-signal-safe functions (see signal(7)) to be"]
#[doc = " called in the child between fork() and exec(), which drastically limits"]
#[doc = " the usefulness of child setup functions."]
#[doc = ""]
#[doc = " In particular, it is not safe to call any function which may"]
#[doc = " call malloc(), which includes POSIX functions such as setenv()."]
#[doc = " If you need to set up the child environment differently from"]
#[doc = " the parent, you should use g_get_environ(), g_environ_setenv(),"]
#[doc = " and g_environ_unsetenv(), and then pass the complete environment"]
#[doc = " list to the `g_spawn...` function."]
pub type GSpawnChildSetupFunc = ::std::option::Option<unsafe extern "C" fn(user_data: gpointer)>;
pub const GSpawnFlags_G_SPAWN_DEFAULT: GSpawnFlags = 0;
pub const GSpawnFlags_G_SPAWN_LEAVE_DESCRIPTORS_OPEN: GSpawnFlags = 1;
pub const GSpawnFlags_G_SPAWN_DO_NOT_REAP_CHILD: GSpawnFlags = 2;
pub const GSpawnFlags_G_SPAWN_SEARCH_PATH: GSpawnFlags = 4;
pub const GSpawnFlags_G_SPAWN_STDOUT_TO_DEV_NULL: GSpawnFlags = 8;
pub const GSpawnFlags_G_SPAWN_STDERR_TO_DEV_NULL: GSpawnFlags = 16;
pub const GSpawnFlags_G_SPAWN_CHILD_INHERITS_STDIN: GSpawnFlags = 32;
pub const GSpawnFlags_G_SPAWN_FILE_AND_ARGV_ZERO: GSpawnFlags = 64;
pub const GSpawnFlags_G_SPAWN_SEARCH_PATH_FROM_ENVP: GSpawnFlags = 128;
pub const GSpawnFlags_G_SPAWN_CLOEXEC_PIPES: GSpawnFlags = 256;
#[doc = " GSpawnFlags:"]
#[doc = " @G_SPAWN_DEFAULT: no flags, default behaviour"]
#[doc = " @G_SPAWN_LEAVE_DESCRIPTORS_OPEN: the parent's open file descriptors will"]
#[doc = "     be inherited by the child; otherwise all descriptors except stdin,"]
#[doc = "     stdout and stderr will be closed before calling exec() in the child."]
#[doc = " @G_SPAWN_DO_NOT_REAP_CHILD: the child will not be automatically reaped;"]
#[doc = "     you must use g_child_watch_add() yourself (or call waitpid() or handle"]
#[doc = "     `SIGCHLD` yourself), or the child will become a zombie."]
#[doc = " @G_SPAWN_SEARCH_PATH: `argv[0]` need not be an absolute path, it will be"]
#[doc = "     looked for in the user's `PATH`."]
#[doc = " @G_SPAWN_STDOUT_TO_DEV_NULL: the child's standard output will be discarded,"]
#[doc = "     instead of going to the same location as the parent's standard output."]
#[doc = " @G_SPAWN_STDERR_TO_DEV_NULL: the child's standard error will be discarded."]
#[doc = " @G_SPAWN_CHILD_INHERITS_STDIN: the child will inherit the parent's standard"]
#[doc = "     input (by default, the child's standard input is attached to `/dev/null`)."]
#[doc = " @G_SPAWN_FILE_AND_ARGV_ZERO: the first element of `argv` is the file to"]
#[doc = "     execute, while the remaining elements are the actual argument vector"]
#[doc = "     to pass to the file. Normally g_spawn_async_with_pipes() uses `argv[0]`"]
#[doc = "     as the file to execute, and passes all of `argv` to the child."]
#[doc = " @G_SPAWN_SEARCH_PATH_FROM_ENVP: if `argv[0]` is not an abolute path,"]
#[doc = "     it will be looked for in the `PATH` from the passed child environment."]
#[doc = "     Since: 2.34"]
#[doc = " @G_SPAWN_CLOEXEC_PIPES: create all pipes with the `O_CLOEXEC` flag set."]
#[doc = "     Since: 2.40"]
#[doc = ""]
#[doc = " Flags passed to g_spawn_sync(), g_spawn_async() and g_spawn_async_with_pipes()."]
pub type GSpawnFlags = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_spawn_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_spawn_exit_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_spawn_async(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        child_pid: *mut GPid,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_async_with_pipes(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        child_pid: *mut GPid,
        standard_input: *mut gint,
        standard_output: *mut gint,
        standard_error: *mut gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_async_with_fds(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        child_pid: *mut GPid,
        stdin_fd: gint,
        stdout_fd: gint,
        stderr_fd: gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_sync(
        working_directory: *const gchar,
        argv: *mut *mut gchar,
        envp: *mut *mut gchar,
        flags: GSpawnFlags,
        child_setup: GSpawnChildSetupFunc,
        user_data: gpointer,
        standard_output: *mut *mut gchar,
        standard_error: *mut *mut gchar,
        exit_status: *mut gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_command_line_sync(
        command_line: *const gchar,
        standard_output: *mut *mut gchar,
        standard_error: *mut *mut gchar,
        exit_status: *mut gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_command_line_async(
        command_line: *const gchar,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_spawn_check_exit_status(exit_status: gint, error: *mut *mut GError) -> gboolean;
}
extern "C" {
    pub fn g_spawn_close_pid(pid: GPid);
}
pub const GAsciiType_G_ASCII_ALNUM: GAsciiType = 1;
pub const GAsciiType_G_ASCII_ALPHA: GAsciiType = 2;
pub const GAsciiType_G_ASCII_CNTRL: GAsciiType = 4;
pub const GAsciiType_G_ASCII_DIGIT: GAsciiType = 8;
pub const GAsciiType_G_ASCII_GRAPH: GAsciiType = 16;
pub const GAsciiType_G_ASCII_LOWER: GAsciiType = 32;
pub const GAsciiType_G_ASCII_PRINT: GAsciiType = 64;
pub const GAsciiType_G_ASCII_PUNCT: GAsciiType = 128;
pub const GAsciiType_G_ASCII_SPACE: GAsciiType = 256;
pub const GAsciiType_G_ASCII_UPPER: GAsciiType = 512;
pub const GAsciiType_G_ASCII_XDIGIT: GAsciiType = 1024;
pub type GAsciiType = ::std::os::raw::c_uint;
extern "C" {
    pub static g_ascii_table: *const guint16;
}
extern "C" {
    pub fn g_ascii_tolower(c: gchar) -> gchar;
}
extern "C" {
    pub fn g_ascii_toupper(c: gchar) -> gchar;
}
extern "C" {
    pub fn g_ascii_digit_value(c: gchar) -> gint;
}
extern "C" {
    pub fn g_ascii_xdigit_value(c: gchar) -> gint;
}
extern "C" {
    pub fn g_strdelimit(
        string: *mut gchar,
        delimiters: *const gchar,
        new_delimiter: gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strcanon(
        string: *mut gchar,
        valid_chars: *const gchar,
        substitutor: gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strerror(errnum: gint) -> *const gchar;
}
extern "C" {
    pub fn g_strsignal(signum: gint) -> *const gchar;
}
extern "C" {
    pub fn g_strreverse(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strlcpy(dest: *mut gchar, src: *const gchar, dest_size: gsize) -> gsize;
}
extern "C" {
    pub fn g_strlcat(dest: *mut gchar, src: *const gchar, dest_size: gsize) -> gsize;
}
extern "C" {
    pub fn g_strstr_len(
        haystack: *const gchar,
        haystack_len: gssize,
        needle: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strrstr(haystack: *const gchar, needle: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strrstr_len(
        haystack: *const gchar,
        haystack_len: gssize,
        needle: *const gchar,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_str_has_suffix(str_: *const gchar, suffix: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_str_has_prefix(str_: *const gchar, prefix: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_strtod(nptr: *const gchar, endptr: *mut *mut gchar) -> gdouble;
}
extern "C" {
    pub fn g_ascii_strtod(nptr: *const gchar, endptr: *mut *mut gchar) -> gdouble;
}
extern "C" {
    pub fn g_ascii_strtoull(nptr: *const gchar, endptr: *mut *mut gchar, base: guint) -> guint64;
}
extern "C" {
    pub fn g_ascii_strtoll(nptr: *const gchar, endptr: *mut *mut gchar, base: guint) -> gint64;
}
extern "C" {
    pub fn g_ascii_dtostr(buffer: *mut gchar, buf_len: gint, d: gdouble) -> *mut gchar;
}
extern "C" {
    pub fn g_ascii_formatd(
        buffer: *mut gchar,
        buf_len: gint,
        format: *const gchar,
        d: gdouble,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_strchug(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strchomp(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_ascii_strcasecmp(s1: *const gchar, s2: *const gchar) -> gint;
}
extern "C" {
    pub fn g_ascii_strncasecmp(s1: *const gchar, s2: *const gchar, n: gsize) -> gint;
}
extern "C" {
    pub fn g_ascii_strdown(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_ascii_strup(str_: *const gchar, len: gssize) -> *mut gchar;
}
extern "C" {
    pub fn g_str_is_ascii(str_: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_strcasecmp(s1: *const gchar, s2: *const gchar) -> gint;
}
extern "C" {
    pub fn g_strncasecmp(s1: *const gchar, s2: *const gchar, n: guint) -> gint;
}
extern "C" {
    pub fn g_strdown(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strup(string: *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strdup(str_: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strdup_printf(format: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_strdup_vprintf(format: *const gchar, args: *mut __va_list_tag) -> *mut gchar;
}
extern "C" {
    pub fn g_strndup(str_: *const gchar, n: gsize) -> *mut gchar;
}
extern "C" {
    pub fn g_strnfill(length: gsize, fill_char: gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strconcat(string1: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_strjoin(separator: *const gchar, ...) -> *mut gchar;
}
extern "C" {
    pub fn g_strcompress(source: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strescape(source: *const gchar, exceptions: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_memdup(mem: gconstpointer, byte_size: guint) -> gpointer;
}
pub type GStrv = *mut *mut gchar;
extern "C" {
    pub fn g_strsplit(
        string: *const gchar,
        delimiter: *const gchar,
        max_tokens: gint,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_strsplit_set(
        string: *const gchar,
        delimiters: *const gchar,
        max_tokens: gint,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_strjoinv(separator: *const gchar, str_array: *mut *mut gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_strfreev(str_array: *mut *mut gchar);
}
extern "C" {
    pub fn g_strdupv(str_array: *mut *mut gchar) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_strv_length(str_array: *mut *mut gchar) -> guint;
}
extern "C" {
    pub fn g_stpcpy(dest: *mut gchar, src: *const ::std::os::raw::c_char) -> *mut gchar;
}
extern "C" {
    pub fn g_str_to_ascii(str_: *const gchar, from_locale: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_str_tokenize_and_fold(
        string: *const gchar,
        translit_locale: *const gchar,
        ascii_alternates: *mut *mut *mut gchar,
    ) -> *mut *mut gchar;
}
extern "C" {
    pub fn g_str_match_string(
        search_term: *const gchar,
        potential_hit: *const gchar,
        accept_alternates: gboolean,
    ) -> gboolean;
}
extern "C" {
    pub fn g_strv_contains(strv: *const *const gchar, str_: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_strv_equal(strv1: *const *const gchar, strv2: *const *const gchar) -> gboolean;
}
pub const GNumberParserError_G_NUMBER_PARSER_ERROR_INVALID: GNumberParserError = 0;
pub const GNumberParserError_G_NUMBER_PARSER_ERROR_OUT_OF_BOUNDS: GNumberParserError = 1;
#[doc = " GNumberParserError:"]
#[doc = " @G_NUMBER_PARSER_ERROR_INVALID: String was not a valid number."]
#[doc = " @G_NUMBER_PARSER_ERROR_OUT_OF_BOUNDS: String was a number, but out of bounds."]
#[doc = ""]
#[doc = " Error codes returned by functions converting a string to a number."]
#[doc = ""]
#[doc = " Since: 2.54"]
pub type GNumberParserError = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_number_parser_error_quark() -> GQuark;
}
extern "C" {
    pub fn g_ascii_string_to_signed(
        str_: *const gchar,
        base: guint,
        min: gint64,
        max: gint64,
        out_num: *mut gint64,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_ascii_string_to_unsigned(
        str_: *const gchar,
        base: guint,
        min: guint64,
        max: guint64,
        out_num: *mut guint64,
        error: *mut *mut GError,
    ) -> gboolean;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GStringChunk {
    _unused: [u8; 0],
}
pub type GStringChunk = _GStringChunk;
extern "C" {
    pub fn g_string_chunk_new(size: gsize) -> *mut GStringChunk;
}
extern "C" {
    pub fn g_string_chunk_free(chunk: *mut GStringChunk);
}
extern "C" {
    pub fn g_string_chunk_clear(chunk: *mut GStringChunk);
}
extern "C" {
    pub fn g_string_chunk_insert(chunk: *mut GStringChunk, string: *const gchar) -> *mut gchar;
}
extern "C" {
    pub fn g_string_chunk_insert_len(
        chunk: *mut GStringChunk,
        string: *const gchar,
        len: gssize,
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_string_chunk_insert_const(
        chunk: *mut GStringChunk,
        string: *const gchar,
    ) -> *mut gchar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestCase {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestSuite {
    _unused: [u8; 0],
}
pub type GTestFunc = ::std::option::Option<unsafe extern "C" fn()>;
pub type GTestDataFunc = ::std::option::Option<unsafe extern "C" fn(user_data: gconstpointer)>;
pub type GTestFixtureFunc =
    ::std::option::Option<unsafe extern "C" fn(fixture: gpointer, user_data: gconstpointer)>;
extern "C" {
    pub fn g_strcmp0(
        str1: *const ::std::os::raw::c_char,
        str2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_test_minimized_result(
        minimized_quantity: f64,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn g_test_maximized_result(
        maximized_quantity: f64,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn g_test_init(
        argc: *mut ::std::os::raw::c_int,
        argv: *mut *mut *mut ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn g_test_subprocess() -> gboolean;
}
extern "C" {
    pub fn g_test_run() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_test_add_func(testpath: *const ::std::os::raw::c_char, test_func: GTestFunc);
}
extern "C" {
    pub fn g_test_add_data_func(
        testpath: *const ::std::os::raw::c_char,
        test_data: gconstpointer,
        test_func: GTestDataFunc,
    );
}
extern "C" {
    pub fn g_test_add_data_func_full(
        testpath: *const ::std::os::raw::c_char,
        test_data: gpointer,
        test_func: GTestDataFunc,
        data_free_func: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_test_fail();
}
extern "C" {
    pub fn g_test_incomplete(msg: *const gchar);
}
extern "C" {
    pub fn g_test_skip(msg: *const gchar);
}
extern "C" {
    pub fn g_test_failed() -> gboolean;
}
extern "C" {
    pub fn g_test_set_nonfatal_assertions();
}
extern "C" {
    pub fn g_test_message(format: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn g_test_bug_base(uri_pattern: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_test_bug(bug_uri_snippet: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_test_summary(summary: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn g_test_timer_start();
}
extern "C" {
    pub fn g_test_timer_elapsed() -> f64;
}
extern "C" {
    pub fn g_test_timer_last() -> f64;
}
extern "C" {
    pub fn g_test_queue_free(gfree_pointer: gpointer);
}
extern "C" {
    pub fn g_test_queue_destroy(destroy_func: GDestroyNotify, destroy_data: gpointer);
}
pub const GTestTrapFlags_G_TEST_TRAP_SILENCE_STDOUT: GTestTrapFlags = 128;
pub const GTestTrapFlags_G_TEST_TRAP_SILENCE_STDERR: GTestTrapFlags = 256;
pub const GTestTrapFlags_G_TEST_TRAP_INHERIT_STDIN: GTestTrapFlags = 512;
#[doc = " GTestTrapFlags:"]
#[doc = " @G_TEST_TRAP_SILENCE_STDOUT: Redirect stdout of the test child to"]
#[doc = "     `/dev/null` so it cannot be observed on the console during test"]
#[doc = "     runs. The actual output is still captured though to allow later"]
#[doc = "     tests with g_test_trap_assert_stdout()."]
#[doc = " @G_TEST_TRAP_SILENCE_STDERR: Redirect stderr of the test child to"]
#[doc = "     `/dev/null` so it cannot be observed on the console during test"]
#[doc = "     runs. The actual output is still captured though to allow later"]
#[doc = "     tests with g_test_trap_assert_stderr()."]
#[doc = " @G_TEST_TRAP_INHERIT_STDIN: If this flag is given, stdin of the"]
#[doc = "     child process is shared with stdin of its parent process."]
#[doc = "     It is redirected to `/dev/null` otherwise."]
#[doc = ""]
#[doc = " Test traps are guards around forked tests."]
#[doc = " These flags determine what traps to set."]
#[doc = ""]
#[doc = " Deprecated: 2.38: #GTestTrapFlags is used only with g_test_trap_fork(),"]
#[doc = " which is deprecated. g_test_trap_subprocess() uses"]
#[doc = " #GTestSubprocessFlags."]
pub type GTestTrapFlags = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_test_trap_fork(usec_timeout: guint64, test_trap_flags: GTestTrapFlags) -> gboolean;
}
pub const GTestSubprocessFlags_G_TEST_SUBPROCESS_INHERIT_STDIN: GTestSubprocessFlags = 1;
pub const GTestSubprocessFlags_G_TEST_SUBPROCESS_INHERIT_STDOUT: GTestSubprocessFlags = 2;
pub const GTestSubprocessFlags_G_TEST_SUBPROCESS_INHERIT_STDERR: GTestSubprocessFlags = 4;
pub type GTestSubprocessFlags = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_test_trap_subprocess(
        test_path: *const ::std::os::raw::c_char,
        usec_timeout: guint64,
        test_flags: GTestSubprocessFlags,
    );
}
extern "C" {
    pub fn g_test_trap_has_passed() -> gboolean;
}
extern "C" {
    pub fn g_test_trap_reached_timeout() -> gboolean;
}
extern "C" {
    pub fn g_test_rand_int() -> gint32;
}
extern "C" {
    pub fn g_test_rand_int_range(begin: gint32, end: gint32) -> gint32;
}
extern "C" {
    pub fn g_test_rand_double() -> f64;
}
extern "C" {
    pub fn g_test_rand_double_range(range_start: f64, range_end: f64) -> f64;
}
extern "C" {
    pub fn g_test_create_case(
        test_name: *const ::std::os::raw::c_char,
        data_size: gsize,
        test_data: gconstpointer,
        data_setup: GTestFixtureFunc,
        data_test: GTestFixtureFunc,
        data_teardown: GTestFixtureFunc,
    ) -> *mut GTestCase;
}
extern "C" {
    pub fn g_test_create_suite(suite_name: *const ::std::os::raw::c_char) -> *mut GTestSuite;
}
extern "C" {
    pub fn g_test_get_root() -> *mut GTestSuite;
}
extern "C" {
    pub fn g_test_suite_add(suite: *mut GTestSuite, test_case: *mut GTestCase);
}
extern "C" {
    pub fn g_test_suite_add_suite(suite: *mut GTestSuite, nestedsuite: *mut GTestSuite);
}
extern "C" {
    pub fn g_test_run_suite(suite: *mut GTestSuite) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn g_test_trap_assertions(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        assertion_flags: guint64,
        pattern: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        message: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_expr(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_cmpstr(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
        arg1: *const ::std::os::raw::c_char,
        cmp: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_cmpnum(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
        arg1: u128,
        cmp: *const ::std::os::raw::c_char,
        arg2: u128,
        numtype: ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn g_assertion_message_error(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
        error: *const GError,
        error_domain: GQuark,
        error_code: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn g_test_add_vtable(
        testpath: *const ::std::os::raw::c_char,
        data_size: gsize,
        test_data: gconstpointer,
        data_setup: GTestFixtureFunc,
        data_test: GTestFixtureFunc,
        data_teardown: GTestFixtureFunc,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestConfig {
    pub test_initialized: gboolean,
    pub test_quick: gboolean,
    pub test_perf: gboolean,
    pub test_verbose: gboolean,
    pub test_quiet: gboolean,
    pub test_undefined: gboolean,
}
extern "C" {
    pub static g_test_config_vars: *const GTestConfig;
}
pub const GTestResult_G_TEST_RUN_SUCCESS: GTestResult = 0;
pub const GTestResult_G_TEST_RUN_SKIPPED: GTestResult = 1;
pub const GTestResult_G_TEST_RUN_FAILURE: GTestResult = 2;
pub const GTestResult_G_TEST_RUN_INCOMPLETE: GTestResult = 3;
pub type GTestResult = ::std::os::raw::c_uint;
pub const GTestLogType_G_TEST_LOG_NONE: GTestLogType = 0;
pub const GTestLogType_G_TEST_LOG_ERROR: GTestLogType = 1;
pub const GTestLogType_G_TEST_LOG_START_BINARY: GTestLogType = 2;
pub const GTestLogType_G_TEST_LOG_LIST_CASE: GTestLogType = 3;
pub const GTestLogType_G_TEST_LOG_SKIP_CASE: GTestLogType = 4;
pub const GTestLogType_G_TEST_LOG_START_CASE: GTestLogType = 5;
pub const GTestLogType_G_TEST_LOG_STOP_CASE: GTestLogType = 6;
pub const GTestLogType_G_TEST_LOG_MIN_RESULT: GTestLogType = 7;
pub const GTestLogType_G_TEST_LOG_MAX_RESULT: GTestLogType = 8;
pub const GTestLogType_G_TEST_LOG_MESSAGE: GTestLogType = 9;
pub const GTestLogType_G_TEST_LOG_START_SUITE: GTestLogType = 10;
pub const GTestLogType_G_TEST_LOG_STOP_SUITE: GTestLogType = 11;
pub type GTestLogType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestLogMsg {
    pub log_type: GTestLogType,
    pub n_strings: guint,
    pub strings: *mut *mut gchar,
    pub n_nums: guint,
    pub nums: *mut u128,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GTestLogBuffer {
    pub data: *mut GString,
    pub msgs: *mut GSList,
}
extern "C" {
    pub fn g_test_log_type_name(log_type: GTestLogType) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_test_log_buffer_new() -> *mut GTestLogBuffer;
}
extern "C" {
    pub fn g_test_log_buffer_free(tbuffer: *mut GTestLogBuffer);
}
extern "C" {
    pub fn g_test_log_buffer_push(
        tbuffer: *mut GTestLogBuffer,
        n_bytes: guint,
        bytes: *const guint8,
    );
}
extern "C" {
    pub fn g_test_log_buffer_pop(tbuffer: *mut GTestLogBuffer) -> *mut GTestLogMsg;
}
extern "C" {
    pub fn g_test_log_msg_free(tmsg: *mut GTestLogMsg);
}
#[doc = " GTestLogFatalFunc:"]
#[doc = " @log_domain: the log domain of the message"]
#[doc = " @log_level: the log level of the message (including the fatal and recursion flags)"]
#[doc = " @message: the message to process"]
#[doc = " @user_data: user data, set in g_test_log_set_fatal_handler()"]
#[doc = ""]
#[doc = " Specifies the prototype of fatal log handler functions."]
#[doc = ""]
#[doc = " Returns: %TRUE if the program should abort, %FALSE otherwise"]
#[doc = ""]
#[doc = " Since: 2.22"]
pub type GTestLogFatalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        message: *const gchar,
        user_data: gpointer,
    ) -> gboolean,
>;
extern "C" {
    pub fn g_test_log_set_fatal_handler(log_func: GTestLogFatalFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_test_expect_message(
        log_domain: *const gchar,
        log_level: GLogLevelFlags,
        pattern: *const gchar,
    );
}
extern "C" {
    pub fn g_test_assert_expected_messages_internal(
        domain: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
    );
}
pub const GTestFileType_G_TEST_DIST: GTestFileType = 0;
pub const GTestFileType_G_TEST_BUILT: GTestFileType = 1;
pub type GTestFileType = ::std::os::raw::c_uint;
extern "C" {
    pub fn g_test_build_filename(
        file_type: GTestFileType,
        first_path: *const gchar,
        ...
    ) -> *mut gchar;
}
extern "C" {
    pub fn g_test_get_dir(file_type: GTestFileType) -> *const gchar;
}
extern "C" {
    pub fn g_test_get_filename(
        file_type: GTestFileType,
        first_path: *const gchar,
        ...
    ) -> *const gchar;
}
pub type GThreadPool = _GThreadPool;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GThreadPool {
    pub func: GFunc,
    pub user_data: gpointer,
    pub exclusive: gboolean,
}
extern "C" {
    pub fn g_thread_pool_new(
        func: GFunc,
        user_data: gpointer,
        max_threads: gint,
        exclusive: gboolean,
        error: *mut *mut GError,
    ) -> *mut GThreadPool;
}
extern "C" {
    pub fn g_thread_pool_free(pool: *mut GThreadPool, immediate: gboolean, wait_: gboolean);
}
extern "C" {
    pub fn g_thread_pool_push(
        pool: *mut GThreadPool,
        data: gpointer,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_thread_pool_unprocessed(pool: *mut GThreadPool) -> guint;
}
extern "C" {
    pub fn g_thread_pool_set_sort_function(
        pool: *mut GThreadPool,
        func: GCompareDataFunc,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_thread_pool_move_to_front(pool: *mut GThreadPool, data: gpointer) -> gboolean;
}
extern "C" {
    pub fn g_thread_pool_set_max_threads(
        pool: *mut GThreadPool,
        max_threads: gint,
        error: *mut *mut GError,
    ) -> gboolean;
}
extern "C" {
    pub fn g_thread_pool_get_max_threads(pool: *mut GThreadPool) -> gint;
}
extern "C" {
    pub fn g_thread_pool_get_num_threads(pool: *mut GThreadPool) -> guint;
}
extern "C" {
    pub fn g_thread_pool_set_max_unused_threads(max_threads: gint);
}
extern "C" {
    pub fn g_thread_pool_get_max_unused_threads() -> gint;
}
extern "C" {
    pub fn g_thread_pool_get_num_unused_threads() -> guint;
}
extern "C" {
    pub fn g_thread_pool_stop_unused_threads();
}
extern "C" {
    pub fn g_thread_pool_set_max_idle_time(interval: guint);
}
extern "C" {
    pub fn g_thread_pool_get_max_idle_time() -> guint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTimer {
    _unused: [u8; 0],
}
pub type GTimer = _GTimer;
extern "C" {
    pub fn g_timer_new() -> *mut GTimer;
}
extern "C" {
    pub fn g_timer_destroy(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_start(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_stop(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_reset(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_continue(timer: *mut GTimer);
}
extern "C" {
    pub fn g_timer_elapsed(timer: *mut GTimer, microseconds: *mut gulong) -> gdouble;
}
extern "C" {
    pub fn g_timer_is_active(timer: *mut GTimer) -> gboolean;
}
extern "C" {
    pub fn g_usleep(microseconds: gulong);
}
extern "C" {
    pub fn g_time_val_add(time_: *mut GTimeVal, microseconds: glong);
}
extern "C" {
    pub fn g_time_val_from_iso8601(iso_date: *const gchar, time_: *mut GTimeVal) -> gboolean;
}
extern "C" {
    pub fn g_time_val_to_iso8601(time_: *mut GTimeVal) -> *mut gchar;
}
pub type GTrashStack = _GTrashStack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTrashStack {
    pub next: *mut GTrashStack,
}
extern "C" {
    pub fn g_trash_stack_push(stack_p: *mut *mut GTrashStack, data_p: gpointer);
}
extern "C" {
    pub fn g_trash_stack_pop(stack_p: *mut *mut GTrashStack) -> gpointer;
}
extern "C" {
    pub fn g_trash_stack_peek(stack_p: *mut *mut GTrashStack) -> gpointer;
}
extern "C" {
    pub fn g_trash_stack_height(stack_p: *mut *mut GTrashStack) -> guint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTree {
    _unused: [u8; 0],
}
pub type GTree = _GTree;
pub type GTraverseFunc = ::std::option::Option<
    unsafe extern "C" fn(key: gpointer, value: gpointer, data: gpointer) -> gboolean,
>;
extern "C" {
    pub fn g_tree_new(key_compare_func: GCompareFunc) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_new_with_data(
        key_compare_func: GCompareDataFunc,
        key_compare_data: gpointer,
    ) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_new_full(
        key_compare_func: GCompareDataFunc,
        key_compare_data: gpointer,
        key_destroy_func: GDestroyNotify,
        value_destroy_func: GDestroyNotify,
    ) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_ref(tree: *mut GTree) -> *mut GTree;
}
extern "C" {
    pub fn g_tree_unref(tree: *mut GTree);
}
extern "C" {
    pub fn g_tree_destroy(tree: *mut GTree);
}
extern "C" {
    pub fn g_tree_insert(tree: *mut GTree, key: gpointer, value: gpointer);
}
extern "C" {
    pub fn g_tree_replace(tree: *mut GTree, key: gpointer, value: gpointer);
}
extern "C" {
    pub fn g_tree_remove(tree: *mut GTree, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_tree_steal(tree: *mut GTree, key: gconstpointer) -> gboolean;
}
extern "C" {
    pub fn g_tree_lookup(tree: *mut GTree, key: gconstpointer) -> gpointer;
}
extern "C" {
    pub fn g_tree_lookup_extended(
        tree: *mut GTree,
        lookup_key: gconstpointer,
        orig_key: *mut gpointer,
        value: *mut gpointer,
    ) -> gboolean;
}
extern "C" {
    pub fn g_tree_foreach(tree: *mut GTree, func: GTraverseFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_tree_traverse(
        tree: *mut GTree,
        traverse_func: GTraverseFunc,
        traverse_type: GTraverseType,
        user_data: gpointer,
    );
}
extern "C" {
    pub fn g_tree_search(
        tree: *mut GTree,
        search_func: GCompareFunc,
        user_data: gconstpointer,
    ) -> gpointer;
}
extern "C" {
    pub fn g_tree_height(tree: *mut GTree) -> gint;
}
extern "C" {
    pub fn g_tree_nnodes(tree: *mut GTree) -> gint;
}
extern "C" {
    pub fn g_uri_unescape_string(
        escaped_string: *const ::std::os::raw::c_char,
        illegal_characters: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uri_unescape_segment(
        escaped_string: *const ::std::os::raw::c_char,
        escaped_string_end: *const ::std::os::raw::c_char,
        illegal_characters: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uri_parse_scheme(uri: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uri_escape_string(
        unescaped: *const ::std::os::raw::c_char,
        reserved_chars_allowed: *const ::std::os::raw::c_char,
        allow_utf8: gboolean,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn g_uuid_string_is_valid(str_: *const gchar) -> gboolean;
}
extern "C" {
    pub fn g_uuid_string_random() -> *mut gchar;
}
extern "C" {
    pub static glib_major_version: guint;
}
extern "C" {
    pub static glib_minor_version: guint;
}
extern "C" {
    pub static glib_micro_version: guint;
}
extern "C" {
    pub static glib_interface_age: guint;
}
extern "C" {
    pub static glib_binary_age: guint;
}
extern "C" {
    pub fn glib_check_version(
        required_major: guint,
        required_minor: guint,
        required_micro: guint,
    ) -> *const gchar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GAllocator {
    _unused: [u8; 0],
}
pub type GAllocator = _GAllocator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GMemChunk {
    _unused: [u8; 0],
}
pub type GMemChunk = _GMemChunk;
extern "C" {
    pub fn g_mem_chunk_new(
        name: *const gchar,
        atom_size: gint,
        area_size: gsize,
        type_: gint,
    ) -> *mut GMemChunk;
}
extern "C" {
    pub fn g_mem_chunk_destroy(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_alloc(mem_chunk: *mut GMemChunk) -> gpointer;
}
extern "C" {
    pub fn g_mem_chunk_alloc0(mem_chunk: *mut GMemChunk) -> gpointer;
}
extern "C" {
    pub fn g_mem_chunk_free(mem_chunk: *mut GMemChunk, mem: gpointer);
}
extern "C" {
    pub fn g_mem_chunk_clean(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_reset(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_print(mem_chunk: *mut GMemChunk);
}
extern "C" {
    pub fn g_mem_chunk_info();
}
extern "C" {
    pub fn g_blow_chunks();
}
extern "C" {
    pub fn g_allocator_new(name: *const gchar, n_preallocs: guint) -> *mut GAllocator;
}
extern "C" {
    pub fn g_allocator_free(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_list_push_allocator(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_list_pop_allocator();
}
extern "C" {
    pub fn g_slist_push_allocator(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_slist_pop_allocator();
}
extern "C" {
    pub fn g_node_push_allocator(allocator: *mut GAllocator);
}
extern "C" {
    pub fn g_node_pop_allocator();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCache {
    _unused: [u8; 0],
}
pub type GCache = _GCache;
pub type GCacheNewFunc = ::std::option::Option<unsafe extern "C" fn(key: gpointer) -> gpointer>;
pub type GCacheDupFunc = ::std::option::Option<unsafe extern "C" fn(value: gpointer) -> gpointer>;
pub type GCacheDestroyFunc = ::std::option::Option<unsafe extern "C" fn(value: gpointer)>;
extern "C" {
    pub fn g_cache_new(
        value_new_func: GCacheNewFunc,
        value_destroy_func: GCacheDestroyFunc,
        key_dup_func: GCacheDupFunc,
        key_destroy_func: GCacheDestroyFunc,
        hash_key_func: GHashFunc,
        hash_value_func: GHashFunc,
        key_equal_func: GEqualFunc,
    ) -> *mut GCache;
}
extern "C" {
    pub fn g_cache_destroy(cache: *mut GCache);
}
extern "C" {
    pub fn g_cache_insert(cache: *mut GCache, key: gpointer) -> gpointer;
}
extern "C" {
    pub fn g_cache_remove(cache: *mut GCache, value: gconstpointer);
}
extern "C" {
    pub fn g_cache_key_foreach(cache: *mut GCache, func: GHFunc, user_data: gpointer);
}
extern "C" {
    pub fn g_cache_value_foreach(cache: *mut GCache, func: GHFunc, user_data: gpointer);
}
pub type GCompletion = _GCompletion;
pub type GCompletionFunc =
    ::std::option::Option<unsafe extern "C" fn(arg1: gpointer) -> *mut gchar>;
pub type GCompletionStrncmpFunc = ::std::option::Option<
    unsafe extern "C" fn(s1: *const gchar, s2: *const gchar, n: gsize) -> gint,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GCompletion {
    pub items: *mut GList,
    pub func: GCompletionFunc,
    pub prefix: *mut gchar,
    pub cache: *mut GList,
    pub strncmp_func: GCompletionStrncmpFunc,
}
extern "C" {
    pub fn g_completion_new(func: GCompletionFunc) -> *mut GCompletion;
}
extern "C" {
    pub fn g_completion_add_items(cmp: *mut GCompletion, items: *mut GList);
}
extern "C" {
    pub fn g_completion_remove_items(cmp: *mut GCompletion, items: *mut GList);
}
extern "C" {
    pub fn g_completion_clear_items(cmp: *mut GCompletion);
}
extern "C" {
    pub fn g_completion_complete(
        cmp: *mut GCompletion,
        prefix: *const gchar,
        new_prefix: *mut *mut gchar,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_completion_complete_utf8(
        cmp: *mut GCompletion,
        prefix: *const gchar,
        new_prefix: *mut *mut gchar,
    ) -> *mut GList;
}
extern "C" {
    pub fn g_completion_set_compare(cmp: *mut GCompletion, strncmp_func: GCompletionStrncmpFunc);
}
extern "C" {
    pub fn g_completion_free(cmp: *mut GCompletion);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GRelation {
    _unused: [u8; 0],
}
pub type GRelation = _GRelation;
pub type GTuples = _GTuples;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GTuples {
    pub len: guint,
}
extern "C" {
    pub fn g_relation_new(fields: gint) -> *mut GRelation;
}
extern "C" {
    pub fn g_relation_destroy(relation: *mut GRelation);
}
extern "C" {
    pub fn g_relation_index(
        relation: *mut GRelation,
        field: gint,
        hash_func: GHashFunc,
        key_equal_func: GEqualFunc,
    );
}
extern "C" {
    pub fn g_relation_insert(relation: *mut GRelation, ...);
}
extern "C" {
    pub fn g_relation_delete(relation: *mut GRelation, key: gconstpointer, field: gint) -> gint;
}
extern "C" {
    pub fn g_relation_select(
        relation: *mut GRelation,
        key: gconstpointer,
        field: gint,
    ) -> *mut GTuples;
}
extern "C" {
    pub fn g_relation_count(relation: *mut GRelation, key: gconstpointer, field: gint) -> gint;
}
extern "C" {
    pub fn g_relation_exists(relation: *mut GRelation, ...) -> gboolean;
}
extern "C" {
    pub fn g_relation_print(relation: *mut GRelation);
}
extern "C" {
    pub fn g_tuples_destroy(tuples: *mut GTuples);
}
extern "C" {
    pub fn g_tuples_index(tuples: *mut GTuples, index_: gint, field: gint) -> gpointer;
}
pub const GThreadPriority_G_THREAD_PRIORITY_LOW: GThreadPriority = 0;
pub const GThreadPriority_G_THREAD_PRIORITY_NORMAL: GThreadPriority = 1;
pub const GThreadPriority_G_THREAD_PRIORITY_HIGH: GThreadPriority = 2;
pub const GThreadPriority_G_THREAD_PRIORITY_URGENT: GThreadPriority = 3;
pub type GThreadPriority = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GThread {
    pub func: GThreadFunc,
    pub data: gpointer,
    pub joinable: gboolean,
    pub priority: GThreadPriority,
}
pub type GThreadFunctions = _GThreadFunctions;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GThreadFunctions {
    pub mutex_new: ::std::option::Option<unsafe extern "C" fn() -> *mut GMutex>,
    pub mutex_lock: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex)>,
    pub mutex_trylock: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex) -> gboolean>,
    pub mutex_unlock: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex)>,
    pub mutex_free: ::std::option::Option<unsafe extern "C" fn(mutex: *mut GMutex)>,
    pub cond_new: ::std::option::Option<unsafe extern "C" fn() -> *mut GCond>,
    pub cond_signal: ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond)>,
    pub cond_broadcast: ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond)>,
    pub cond_wait:
        ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond, mutex: *mut GMutex)>,
    pub cond_timed_wait: ::std::option::Option<
        unsafe extern "C" fn(
            cond: *mut GCond,
            mutex: *mut GMutex,
            end_time: *mut GTimeVal,
        ) -> gboolean,
    >,
    pub cond_free: ::std::option::Option<unsafe extern "C" fn(cond: *mut GCond)>,
    pub private_new:
        ::std::option::Option<unsafe extern "C" fn(destructor: GDestroyNotify) -> *mut GPrivate>,
    pub private_get:
        ::std::option::Option<unsafe extern "C" fn(private_key: *mut GPrivate) -> gpointer>,
    pub private_set:
        ::std::option::Option<unsafe extern "C" fn(private_key: *mut GPrivate, data: gpointer)>,
    pub thread_create: ::std::option::Option<
        unsafe extern "C" fn(
            func: GThreadFunc,
            data: gpointer,
            stack_size: gulong,
            joinable: gboolean,
            bound: gboolean,
            priority: GThreadPriority,
            thread: gpointer,
            error: *mut *mut GError,
        ),
    >,
    pub thread_yield: ::std::option::Option<unsafe extern "C" fn()>,
    pub thread_join: ::std::option::Option<unsafe extern "C" fn(thread: gpointer)>,
    pub thread_exit: ::std::option::Option<unsafe extern "C" fn()>,
    pub thread_set_priority:
        ::std::option::Option<unsafe extern "C" fn(thread: gpointer, priority: GThreadPriority)>,
    pub thread_self: ::std::option::Option<unsafe extern "C" fn(thread: gpointer)>,
    pub thread_equal: ::std::option::Option<
        unsafe extern "C" fn(thread1: gpointer, thread2: gpointer) -> gboolean,
    >,
}
extern "C" {
    pub static mut g_thread_functions_for_glib_use: GThreadFunctions;
}
extern "C" {
    pub static mut g_thread_use_default_impl: gboolean;
}
extern "C" {
    pub static mut g_thread_gettime: ::std::option::Option<unsafe extern "C" fn() -> guint64>;
}
extern "C" {
    pub fn g_thread_create(
        func: GThreadFunc,
        data: gpointer,
        joinable: gboolean,
        error: *mut *mut GError,
    ) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_create_full(
        func: GThreadFunc,
        data: gpointer,
        stack_size: gulong,
        joinable: gboolean,
        bound: gboolean,
        priority: GThreadPriority,
        error: *mut *mut GError,
    ) -> *mut GThread;
}
extern "C" {
    pub fn g_thread_set_priority(thread: *mut GThread, priority: GThreadPriority);
}
extern "C" {
    pub fn g_thread_foreach(thread_func: GFunc, user_data: gpointer);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sched_param {
    pub sched_priority: ::std::os::raw::c_int,
}
pub type __cpu_mask = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_set_t {
    pub __bits: [__cpu_mask; 16usize],
}
extern "C" {
    pub fn __sched_cpucount(__setsize: size_t, __setp: *const cpu_set_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __sched_cpualloc(__count: size_t) -> *mut cpu_set_t;
}
extern "C" {
    pub fn __sched_cpufree(__set: *mut cpu_set_t);
}
extern "C" {
    pub fn sched_setparam(__pid: __pid_t, __param: *const sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getparam(__pid: __pid_t, __param: *mut sched_param) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_setscheduler(
        __pid: __pid_t,
        __policy: ::std::os::raw::c_int,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_getscheduler(__pid: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_yield() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_max(__algorithm: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_min(__algorithm: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_rr_get_interval(__pid: __pid_t, __t: *mut timespec) -> ::std::os::raw::c_int;
}
pub const PTHREAD_CREATE_JOINABLE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_CREATE_DETACHED: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_23 = ::std::os::raw::c_uint;
pub const PTHREAD_MUTEX_TIMED_NP: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_RECURSIVE_NP: ::std::os::raw::c_uint = 1;
pub const PTHREAD_MUTEX_ERRORCHECK_NP: ::std::os::raw::c_uint = 2;
pub const PTHREAD_MUTEX_ADAPTIVE_NP: ::std::os::raw::c_uint = 3;
pub const PTHREAD_MUTEX_NORMAL: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_RECURSIVE: ::std::os::raw::c_uint = 1;
pub const PTHREAD_MUTEX_ERRORCHECK: ::std::os::raw::c_uint = 2;
pub const PTHREAD_MUTEX_DEFAULT: ::std::os::raw::c_uint = 0;
pub type _bindgen_ty_24 = ::std::os::raw::c_uint;
pub const PTHREAD_MUTEX_STALLED: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_STALLED_NP: ::std::os::raw::c_uint = 0;
pub const PTHREAD_MUTEX_ROBUST: ::std::os::raw::c_uint = 1;
pub const PTHREAD_MUTEX_ROBUST_NP: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_25 = ::std::os::raw::c_uint;
pub const PTHREAD_PRIO_NONE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_PRIO_INHERIT: ::std::os::raw::c_uint = 1;
pub const PTHREAD_PRIO_PROTECT: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_26 = ::std::os::raw::c_uint;
pub const PTHREAD_RWLOCK_PREFER_READER_NP: ::std::os::raw::c_uint = 0;
pub const PTHREAD_RWLOCK_PREFER_WRITER_NP: ::std::os::raw::c_uint = 1;
pub const PTHREAD_RWLOCK_PREFER_WRITER_NONRECURSIVE_NP: ::std::os::raw::c_uint = 2;
pub const PTHREAD_RWLOCK_DEFAULT_NP: ::std::os::raw::c_uint = 0;
pub type _bindgen_ty_27 = ::std::os::raw::c_uint;
pub const PTHREAD_INHERIT_SCHED: ::std::os::raw::c_uint = 0;
pub const PTHREAD_EXPLICIT_SCHED: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_28 = ::std::os::raw::c_uint;
pub const PTHREAD_SCOPE_SYSTEM: ::std::os::raw::c_uint = 0;
pub const PTHREAD_SCOPE_PROCESS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_29 = ::std::os::raw::c_uint;
pub const PTHREAD_PROCESS_PRIVATE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_PROCESS_SHARED: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_30 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _pthread_cleanup_buffer {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __canceltype: ::std::os::raw::c_int,
    pub __prev: *mut _pthread_cleanup_buffer,
}
pub const PTHREAD_CANCEL_ENABLE: ::std::os::raw::c_uint = 0;
pub const PTHREAD_CANCEL_DISABLE: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_31 = ::std::os::raw::c_uint;
pub const PTHREAD_CANCEL_DEFERRED: ::std::os::raw::c_uint = 0;
pub const PTHREAD_CANCEL_ASYNCHRONOUS: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_32 = ::std::os::raw::c_uint;
extern "C" {
    pub fn pthread_create(
        __newthread: *mut pthread_t,
        __attr: *const pthread_attr_t,
        __start_routine: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_exit(__retval: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn pthread_join(
        __th: pthread_t,
        __thread_return: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_detach(__th: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_self() -> pthread_t;
}
extern "C" {
    pub fn pthread_equal(__thread1: pthread_t, __thread2: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_init(__attr: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_destroy(__attr: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getdetachstate(
        __attr: *const pthread_attr_t,
        __detachstate: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setdetachstate(
        __attr: *mut pthread_attr_t,
        __detachstate: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getguardsize(
        __attr: *const pthread_attr_t,
        __guardsize: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setguardsize(
        __attr: *mut pthread_attr_t,
        __guardsize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedparam(
        __attr: *const pthread_attr_t,
        __param: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedparam(
        __attr: *mut pthread_attr_t,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedpolicy(
        __attr: *const pthread_attr_t,
        __policy: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedpolicy(
        __attr: *mut pthread_attr_t,
        __policy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getinheritsched(
        __attr: *const pthread_attr_t,
        __inherit: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setinheritsched(
        __attr: *mut pthread_attr_t,
        __inherit: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getscope(
        __attr: *const pthread_attr_t,
        __scope: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setscope(
        __attr: *mut pthread_attr_t,
        __scope: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstackaddr(
        __attr: *const pthread_attr_t,
        __stackaddr: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstackaddr(
        __attr: *mut pthread_attr_t,
        __stackaddr: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstacksize(
        __attr: *const pthread_attr_t,
        __stacksize: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstacksize(
        __attr: *mut pthread_attr_t,
        __stacksize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstack(
        __attr: *const pthread_attr_t,
        __stackaddr: *mut *mut ::std::os::raw::c_void,
        __stacksize: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstack(
        __attr: *mut pthread_attr_t,
        __stackaddr: *mut ::std::os::raw::c_void,
        __stacksize: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedparam(
        __target_thread: pthread_t,
        __policy: ::std::os::raw::c_int,
        __param: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getschedparam(
        __target_thread: pthread_t,
        __policy: *mut ::std::os::raw::c_int,
        __param: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedprio(
        __target_thread: pthread_t,
        __prio: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_once(
        __once_control: *mut pthread_once_t,
        __init_routine: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcancelstate(
        __state: ::std::os::raw::c_int,
        __oldstate: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcanceltype(
        __type: ::std::os::raw::c_int,
        __oldtype: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cancel(__th: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_testcancel();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_unwind_buf_t {
    pub __cancel_jmp_buf: [__pthread_unwind_buf_t__bindgen_ty_1; 1usize],
    pub __pad: [*mut ::std::os::raw::c_void; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_unwind_buf_t__bindgen_ty_1 {
    pub __cancel_jmp_buf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cleanup_frame {
    pub __cancel_routine:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __cancel_arg: *mut ::std::os::raw::c_void,
    pub __do_it: ::std::os::raw::c_int,
    pub __cancel_type: ::std::os::raw::c_int,
}
extern "C" {
    pub fn __pthread_register_cancel(__buf: *mut __pthread_unwind_buf_t);
}
extern "C" {
    pub fn __pthread_unregister_cancel(__buf: *mut __pthread_unwind_buf_t);
}
extern "C" {
    pub fn __pthread_unwind_next(__buf: *mut __pthread_unwind_buf_t);
}
extern "C" {
    pub fn pthread_mutex_init(
        __mutex: *mut pthread_mutex_t,
        __mutexattr: *const pthread_mutexattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_destroy(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_trylock(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_lock(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_timedlock(
        __mutex: *mut pthread_mutex_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_unlock(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_getprioceiling(
        __mutex: *const pthread_mutex_t,
        __prioceiling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_setprioceiling(
        __mutex: *mut pthread_mutex_t,
        __prioceiling: ::std::os::raw::c_int,
        __old_ceiling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_consistent(__mutex: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_init(__attr: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_destroy(__attr: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getpshared(
        __attr: *const pthread_mutexattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setpshared(
        __attr: *mut pthread_mutexattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_gettype(
        __attr: *const pthread_mutexattr_t,
        __kind: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_settype(
        __attr: *mut pthread_mutexattr_t,
        __kind: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprotocol(
        __attr: *const pthread_mutexattr_t,
        __protocol: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprotocol(
        __attr: *mut pthread_mutexattr_t,
        __protocol: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprioceiling(
        __attr: *const pthread_mutexattr_t,
        __prioceiling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprioceiling(
        __attr: *mut pthread_mutexattr_t,
        __prioceiling: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getrobust(
        __attr: *const pthread_mutexattr_t,
        __robustness: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setrobust(
        __attr: *mut pthread_mutexattr_t,
        __robustness: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_init(
        __rwlock: *mut pthread_rwlock_t,
        __attr: *const pthread_rwlockattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_destroy(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_rdlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_tryrdlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_timedrdlock(
        __rwlock: *mut pthread_rwlock_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_wrlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_trywrlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_timedwrlock(
        __rwlock: *mut pthread_rwlock_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_unlock(__rwlock: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_init(__attr: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_destroy(__attr: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_getpshared(
        __attr: *const pthread_rwlockattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_setpshared(
        __attr: *mut pthread_rwlockattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_getkind_np(
        __attr: *const pthread_rwlockattr_t,
        __pref: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_setkind_np(
        __attr: *mut pthread_rwlockattr_t,
        __pref: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_init(
        __cond: *mut pthread_cond_t,
        __cond_attr: *const pthread_condattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_destroy(__cond: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_signal(__cond: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_broadcast(__cond: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_wait(
        __cond: *mut pthread_cond_t,
        __mutex: *mut pthread_mutex_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_timedwait(
        __cond: *mut pthread_cond_t,
        __mutex: *mut pthread_mutex_t,
        __abstime: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_init(__attr: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_destroy(__attr: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getpshared(
        __attr: *const pthread_condattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setpshared(
        __attr: *mut pthread_condattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getclock(
        __attr: *const pthread_condattr_t,
        __clock_id: *mut __clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setclock(
        __attr: *mut pthread_condattr_t,
        __clock_id: __clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_init(
        __lock: *mut pthread_spinlock_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_destroy(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_lock(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_trylock(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_spin_unlock(__lock: *mut pthread_spinlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_init(
        __barrier: *mut pthread_barrier_t,
        __attr: *const pthread_barrierattr_t,
        __count: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_destroy(__barrier: *mut pthread_barrier_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrier_wait(__barrier: *mut pthread_barrier_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_init(__attr: *mut pthread_barrierattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_destroy(__attr: *mut pthread_barrierattr_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_getpshared(
        __attr: *const pthread_barrierattr_t,
        __pshared: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_barrierattr_setpshared(
        __attr: *mut pthread_barrierattr_t,
        __pshared: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_create(
        __key: *mut pthread_key_t,
        __destr_function: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_delete(__key: pthread_key_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getspecific(__key: pthread_key_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn pthread_setspecific(
        __key: pthread_key_t,
        __pointer: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getcpuclockid(
        __thread_id: pthread_t,
        __clock_id: *mut __clockid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_atfork(
        __prepare: ::std::option::Option<unsafe extern "C" fn()>,
        __parent: ::std::option::Option<unsafe extern "C" fn()>,
        __child: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GStaticMutex {
    pub mutex: *mut GMutex,
    pub unused: pthread_mutex_t,
}
extern "C" {
    pub fn g_static_mutex_init(mutex: *mut GStaticMutex);
}
extern "C" {
    pub fn g_static_mutex_free(mutex: *mut GStaticMutex);
}
extern "C" {
    pub fn g_static_mutex_get_mutex_impl(mutex: *mut GStaticMutex) -> *mut GMutex;
}
pub type GStaticRecMutex = _GStaticRecMutex;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GStaticRecMutex {
    pub mutex: GStaticMutex,
    pub depth: guint,
    pub unused: _GStaticRecMutex__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _GStaticRecMutex__bindgen_ty_1 {
    pub owner: pthread_t,
    pub dummy: gdouble,
}
extern "C" {
    pub fn g_static_rec_mutex_init(mutex: *mut GStaticRecMutex);
}
extern "C" {
    pub fn g_static_rec_mutex_lock(mutex: *mut GStaticRecMutex);
}
extern "C" {
    pub fn g_static_rec_mutex_trylock(mutex: *mut GStaticRecMutex) -> gboolean;
}
extern "C" {
    pub fn g_static_rec_mutex_unlock(mutex: *mut GStaticRecMutex);
}
extern "C" {
    pub fn g_static_rec_mutex_lock_full(mutex: *mut GStaticRecMutex, depth: guint);
}
extern "C" {
    pub fn g_static_rec_mutex_unlock_full(mutex: *mut GStaticRecMutex) -> guint;
}
extern "C" {
    pub fn g_static_rec_mutex_free(mutex: *mut GStaticRecMutex);
}
pub type GStaticRWLock = _GStaticRWLock;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _GStaticRWLock {
    pub mutex: GStaticMutex,
    pub read_cond: *mut GCond,
    pub write_cond: *mut GCond,
    pub read_counter: guint,
    pub have_writer: gboolean,
    pub want_to_read: guint,
    pub want_to_write: guint,
}
extern "C" {
    pub fn g_static_rw_lock_init(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_reader_lock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_reader_trylock(lock: *mut GStaticRWLock) -> gboolean;
}
extern "C" {
    pub fn g_static_rw_lock_reader_unlock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_writer_lock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_writer_trylock(lock: *mut GStaticRWLock) -> gboolean;
}
extern "C" {
    pub fn g_static_rw_lock_writer_unlock(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_static_rw_lock_free(lock: *mut GStaticRWLock);
}
extern "C" {
    pub fn g_private_new(notify: GDestroyNotify) -> *mut GPrivate;
}
pub type GStaticPrivate = _GStaticPrivate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GStaticPrivate {
    pub index: guint,
}
extern "C" {
    pub fn g_static_private_init(private_key: *mut GStaticPrivate);
}
extern "C" {
    pub fn g_static_private_get(private_key: *mut GStaticPrivate) -> gpointer;
}
extern "C" {
    pub fn g_static_private_set(
        private_key: *mut GStaticPrivate,
        data: gpointer,
        notify: GDestroyNotify,
    );
}
extern "C" {
    pub fn g_static_private_free(private_key: *mut GStaticPrivate);
}
extern "C" {
    pub fn g_once_init_enter_impl(location: *mut gsize) -> gboolean;
}
extern "C" {
    pub fn g_thread_init(vtable: gpointer);
}
extern "C" {
    pub fn g_thread_init_with_errorcheck_mutexes(vtable: gpointer);
}
extern "C" {
    pub fn g_thread_get_initialized() -> gboolean;
}
extern "C" {
    pub static mut g_threads_got_initialized: gboolean;
}
extern "C" {
    pub fn g_mutex_new() -> *mut GMutex;
}
extern "C" {
    pub fn g_mutex_free(mutex: *mut GMutex);
}
extern "C" {
    pub fn g_cond_new() -> *mut GCond;
}
extern "C" {
    pub fn g_cond_free(cond: *mut GCond);
}
extern "C" {
    pub fn g_cond_timed_wait(
        cond: *mut GCond,
        mutex: *mut GMutex,
        timeval: *mut GTimeVal,
    ) -> gboolean;
}
pub type GAsyncQueue_autoptr = *mut GAsyncQueue;
pub type GAsyncQueue_listautoptr = *mut GList;
pub type GAsyncQueue_slistautoptr = *mut GSList;
pub type GAsyncQueue_queueautoptr = *mut GQueue;
pub type GBookmarkFile_autoptr = *mut GBookmarkFile;
pub type GBookmarkFile_listautoptr = *mut GList;
pub type GBookmarkFile_slistautoptr = *mut GSList;
pub type GBookmarkFile_queueautoptr = *mut GQueue;
pub type GBytes_autoptr = *mut GBytes;
pub type GBytes_listautoptr = *mut GList;
pub type GBytes_slistautoptr = *mut GSList;
pub type GBytes_queueautoptr = *mut GQueue;
pub type GChecksum_autoptr = *mut GChecksum;
pub type GChecksum_listautoptr = *mut GList;
pub type GChecksum_slistautoptr = *mut GSList;
pub type GChecksum_queueautoptr = *mut GQueue;
pub type GDateTime_autoptr = *mut GDateTime;
pub type GDateTime_listautoptr = *mut GList;
pub type GDateTime_slistautoptr = *mut GSList;
pub type GDateTime_queueautoptr = *mut GQueue;
pub type GDate_autoptr = *mut GDate;
pub type GDate_listautoptr = *mut GList;
pub type GDate_slistautoptr = *mut GSList;
pub type GDate_queueautoptr = *mut GQueue;
pub type GDir_autoptr = *mut GDir;
pub type GDir_listautoptr = *mut GList;
pub type GDir_slistautoptr = *mut GSList;
pub type GDir_queueautoptr = *mut GQueue;
pub type GError_autoptr = *mut GError;
pub type GError_listautoptr = *mut GList;
pub type GError_slistautoptr = *mut GSList;
pub type GError_queueautoptr = *mut GQueue;
pub type GHashTable_autoptr = *mut GHashTable;
pub type GHashTable_listautoptr = *mut GList;
pub type GHashTable_slistautoptr = *mut GSList;
pub type GHashTable_queueautoptr = *mut GQueue;
pub type GHmac_autoptr = *mut GHmac;
pub type GHmac_listautoptr = *mut GList;
pub type GHmac_slistautoptr = *mut GSList;
pub type GHmac_queueautoptr = *mut GQueue;
pub type GIOChannel_autoptr = *mut GIOChannel;
pub type GIOChannel_listautoptr = *mut GList;
pub type GIOChannel_slistautoptr = *mut GSList;
pub type GIOChannel_queueautoptr = *mut GQueue;
pub type GKeyFile_autoptr = *mut GKeyFile;
pub type GKeyFile_listautoptr = *mut GList;
pub type GKeyFile_slistautoptr = *mut GSList;
pub type GKeyFile_queueautoptr = *mut GQueue;
pub type GList_autoptr = *mut GList;
pub type GList_listautoptr = *mut GList;
pub type GList_slistautoptr = *mut GSList;
pub type GList_queueautoptr = *mut GQueue;
pub type GArray_autoptr = *mut GArray;
pub type GArray_listautoptr = *mut GList;
pub type GArray_slistautoptr = *mut GSList;
pub type GArray_queueautoptr = *mut GQueue;
pub type GPtrArray_autoptr = *mut GPtrArray;
pub type GPtrArray_listautoptr = *mut GList;
pub type GPtrArray_slistautoptr = *mut GSList;
pub type GPtrArray_queueautoptr = *mut GQueue;
pub type GByteArray_autoptr = *mut GByteArray;
pub type GByteArray_listautoptr = *mut GList;
pub type GByteArray_slistautoptr = *mut GSList;
pub type GByteArray_queueautoptr = *mut GQueue;
pub type GMainContext_autoptr = *mut GMainContext;
pub type GMainContext_listautoptr = *mut GList;
pub type GMainContext_slistautoptr = *mut GSList;
pub type GMainContext_queueautoptr = *mut GQueue;
pub type GMainContextPusher_autoptr = *mut GMainContextPusher;
pub type GMainContextPusher_listautoptr = *mut GList;
pub type GMainContextPusher_slistautoptr = *mut GSList;
pub type GMainContextPusher_queueautoptr = *mut GQueue;
pub type GMainLoop_autoptr = *mut GMainLoop;
pub type GMainLoop_listautoptr = *mut GList;
pub type GMainLoop_slistautoptr = *mut GSList;
pub type GMainLoop_queueautoptr = *mut GQueue;
pub type GSource_autoptr = *mut GSource;
pub type GSource_listautoptr = *mut GList;
pub type GSource_slistautoptr = *mut GSList;
pub type GSource_queueautoptr = *mut GQueue;
pub type GMappedFile_autoptr = *mut GMappedFile;
pub type GMappedFile_listautoptr = *mut GList;
pub type GMappedFile_slistautoptr = *mut GSList;
pub type GMappedFile_queueautoptr = *mut GQueue;
pub type GMarkupParseContext_autoptr = *mut GMarkupParseContext;
pub type GMarkupParseContext_listautoptr = *mut GList;
pub type GMarkupParseContext_slistautoptr = *mut GSList;
pub type GMarkupParseContext_queueautoptr = *mut GQueue;
pub type GNode_autoptr = *mut GNode;
pub type GNode_listautoptr = *mut GList;
pub type GNode_slistautoptr = *mut GSList;
pub type GNode_queueautoptr = *mut GQueue;
pub type GOptionContext_autoptr = *mut GOptionContext;
pub type GOptionContext_listautoptr = *mut GList;
pub type GOptionContext_slistautoptr = *mut GSList;
pub type GOptionContext_queueautoptr = *mut GQueue;
pub type GOptionGroup_autoptr = *mut GOptionGroup;
pub type GOptionGroup_listautoptr = *mut GList;
pub type GOptionGroup_slistautoptr = *mut GSList;
pub type GOptionGroup_queueautoptr = *mut GQueue;
pub type GPatternSpec_autoptr = *mut GPatternSpec;
pub type GPatternSpec_listautoptr = *mut GList;
pub type GPatternSpec_slistautoptr = *mut GSList;
pub type GPatternSpec_queueautoptr = *mut GQueue;
pub type GQueue_autoptr = *mut GQueue;
pub type GQueue_listautoptr = *mut GList;
pub type GQueue_slistautoptr = *mut GSList;
pub type GQueue_queueautoptr = *mut GQueue;
pub type GRand_autoptr = *mut GRand;
pub type GRand_listautoptr = *mut GList;
pub type GRand_slistautoptr = *mut GSList;
pub type GRand_queueautoptr = *mut GQueue;
pub type GRegex_autoptr = *mut GRegex;
pub type GRegex_listautoptr = *mut GList;
pub type GRegex_slistautoptr = *mut GSList;
pub type GRegex_queueautoptr = *mut GQueue;
pub type GMatchInfo_autoptr = *mut GMatchInfo;
pub type GMatchInfo_listautoptr = *mut GList;
pub type GMatchInfo_slistautoptr = *mut GSList;
pub type GMatchInfo_queueautoptr = *mut GQueue;
pub type GScanner_autoptr = *mut GScanner;
pub type GScanner_listautoptr = *mut GList;
pub type GScanner_slistautoptr = *mut GSList;
pub type GScanner_queueautoptr = *mut GQueue;
pub type GSequence_autoptr = *mut GSequence;
pub type GSequence_listautoptr = *mut GList;
pub type GSequence_slistautoptr = *mut GSList;
pub type GSequence_queueautoptr = *mut GQueue;
pub type GSList_autoptr = *mut GSList;
pub type GSList_listautoptr = *mut GList;
pub type GSList_slistautoptr = *mut GSList;
pub type GSList_queueautoptr = *mut GQueue;
pub type GString_autoptr = *mut GString;
pub type GString_listautoptr = *mut GList;
pub type GString_slistautoptr = *mut GSList;
pub type GString_queueautoptr = *mut GQueue;
pub type GStringChunk_autoptr = *mut GStringChunk;
pub type GStringChunk_listautoptr = *mut GList;
pub type GStringChunk_slistautoptr = *mut GSList;
pub type GStringChunk_queueautoptr = *mut GQueue;
pub type GThread_autoptr = *mut GThread;
pub type GThread_listautoptr = *mut GList;
pub type GThread_slistautoptr = *mut GSList;
pub type GThread_queueautoptr = *mut GQueue;
pub type GMutexLocker_autoptr = *mut GMutexLocker;
pub type GMutexLocker_listautoptr = *mut GList;
pub type GMutexLocker_slistautoptr = *mut GSList;
pub type GMutexLocker_queueautoptr = *mut GQueue;
pub type GRecMutexLocker_autoptr = *mut GRecMutexLocker;
pub type GRecMutexLocker_listautoptr = *mut GList;
pub type GRecMutexLocker_slistautoptr = *mut GSList;
pub type GRecMutexLocker_queueautoptr = *mut GQueue;
pub type GRWLockWriterLocker_autoptr = *mut GRWLockWriterLocker;
pub type GRWLockWriterLocker_listautoptr = *mut GList;
pub type GRWLockWriterLocker_slistautoptr = *mut GSList;
pub type GRWLockWriterLocker_queueautoptr = *mut GQueue;
pub type GRWLockReaderLocker_autoptr = *mut GRWLockReaderLocker;
pub type GRWLockReaderLocker_listautoptr = *mut GList;
pub type GRWLockReaderLocker_slistautoptr = *mut GSList;
pub type GRWLockReaderLocker_queueautoptr = *mut GQueue;
pub type GTimer_autoptr = *mut GTimer;
pub type GTimer_listautoptr = *mut GList;
pub type GTimer_slistautoptr = *mut GSList;
pub type GTimer_queueautoptr = *mut GQueue;
pub type GTimeZone_autoptr = *mut GTimeZone;
pub type GTimeZone_listautoptr = *mut GList;
pub type GTimeZone_slistautoptr = *mut GSList;
pub type GTimeZone_queueautoptr = *mut GQueue;
pub type GTree_autoptr = *mut GTree;
pub type GTree_listautoptr = *mut GList;
pub type GTree_slistautoptr = *mut GSList;
pub type GTree_queueautoptr = *mut GQueue;
pub type GVariant_autoptr = *mut GVariant;
pub type GVariant_listautoptr = *mut GList;
pub type GVariant_slistautoptr = *mut GSList;
pub type GVariant_queueautoptr = *mut GQueue;
pub type GVariantBuilder_autoptr = *mut GVariantBuilder;
pub type GVariantBuilder_listautoptr = *mut GList;
pub type GVariantBuilder_slistautoptr = *mut GSList;
pub type GVariantBuilder_queueautoptr = *mut GQueue;
pub type GVariantIter_autoptr = *mut GVariantIter;
pub type GVariantIter_listautoptr = *mut GList;
pub type GVariantIter_slistautoptr = *mut GSList;
pub type GVariantIter_queueautoptr = *mut GQueue;
pub type GVariantDict_autoptr = *mut GVariantDict;
pub type GVariantDict_listautoptr = *mut GList;
pub type GVariantDict_slistautoptr = *mut GSList;
pub type GVariantDict_queueautoptr = *mut GQueue;
pub type GVariantType_autoptr = *mut GVariantType;
pub type GVariantType_listautoptr = *mut GList;
pub type GVariantType_slistautoptr = *mut GSList;
pub type GVariantType_queueautoptr = *mut GQueue;
pub type GRefString_autoptr = *mut GRefString;
pub type GRefString_listautoptr = *mut GList;
pub type GRefString_slistautoptr = *mut GSList;
pub type GRefString_queueautoptr = *mut GQueue;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AdapterInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AioContext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AllwinnerAHCIState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AudioState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BdrvDirtyBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BdrvDirtyBitmapIter {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockBackend {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockBackendRootState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDriverState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Chardev {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CompatProperty {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUAddressSpace {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DisplayChangeListener {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DisplayState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DisplaySurface {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriveInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Error {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EventNotifier {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FWCfgIoState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FWCfgMemState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FWCfgState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HCIInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct I2CBus {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct I2SCodec {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISABus {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISADevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IsaDma {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LoadStateEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MACAddr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MachineClass {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MachineState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryMappingList {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationIncomingState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationParams {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Monitor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MonitorDef {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MouseTransformInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MSIMessage {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetClientState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetFilterState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NICInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PcGuestInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIBridge {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIBus {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIDevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIEAERErr {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIEAERLog {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIEAERMsg {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIEPort {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIESlot {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIExpressDevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIExpressHost {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIHostDeviceAddress {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCIHostState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCMachineClass {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCMachineState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCMCIACardState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PixelFormat {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PostcopyDiscardState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEMUBH {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QemuConsole {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEMUFile {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QemuOpt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QemuOpts {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEMUSGList {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEMUTimer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEMUTimerListGroup {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RAMBlock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Range {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SerialState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SHPCDevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SMBusDevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SSIBus {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uWireSlave {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VirtIODevice {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Visitor {
    _unused: [u8; 0],
}
extern "C" {
    pub fn qemu_daemon(
        nochdir: ::std::os::raw::c_int,
        noclose: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_try_memalign(alignment: size_t, size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qemu_memalign(alignment: size_t, size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qemu_anon_ram_alloc(size: size_t, align: *mut u64) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qemu_vfree(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn qemu_anon_ram_free(ptr: *mut ::std::os::raw::c_void, size: size_t);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct qemu_signalfd_siginfo {
    pub ssi_signo: u32,
    pub ssi_errno: i32,
    pub ssi_code: i32,
    pub ssi_pid: u32,
    pub ssi_uid: u32,
    pub ssi_fd: i32,
    pub ssi_tid: u32,
    pub ssi_band: u32,
    pub ssi_overrun: u32,
    pub ssi_trapno: u32,
    pub ssi_status: i32,
    pub ssi_int: i32,
    pub ssi_ptr: u64,
    pub ssi_utime: u64,
    pub ssi_stime: u64,
    pub ssi_addr: u64,
    pub pad: [u8; 48usize],
}
extern "C" {
    pub fn qemu_signalfd(mask: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction_invoke(action: *mut sigaction, info: *mut qemu_signalfd_siginfo);
}
extern "C" {
    pub fn qemu_madvise(
        addr: *mut ::std::os::raw::c_void,
        len: size_t,
        advice: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_open(
        name: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_close(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_dup(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_create_pidfile(filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_get_thread_id() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readv(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn writev(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
    ) -> ssize_t;
}
extern "C" {
    pub fn preadv(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwritev(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
        __offset: __off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn qemu_set_cloexec(fd: ::std::os::raw::c_int);
}
extern "C" {
    pub fn qemu_set_hw_version(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn qemu_hw_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fips_set_state(requested: bool);
}
extern "C" {
    pub fn fips_get_state() -> bool;
}
extern "C" {
    pub fn qemu_get_local_state_pathname(
        relative_pathname: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qemu_init_exec_dir(argv0: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn qemu_get_exec_dir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " qemu_getauxval:"]
    #[doc = " @type: the auxiliary vector key to lookup"]
    #[doc = ""]
    #[doc = " Search the auxiliary vector for @type, returning the value"]
    #[doc = " or 0 if @type is not present."]
    pub fn qemu_getauxval(type_: ::std::os::raw::c_ulong) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn qemu_set_tty_echo(fd: ::std::os::raw::c_int, echo: bool);
}
extern "C" {
    pub fn os_mem_prealloc(
        fd: ::std::os::raw::c_int,
        area: *mut ::std::os::raw::c_char,
        sz: size_t,
        smp_cpus: ::std::os::raw::c_int,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn qemu_read_password(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " qemu_get_pid_name:"]
    #[doc = " @pid: pid of a process"]
    #[doc = ""]
    #[doc = " For given @pid fetch its name. Caller is responsible for"]
    #[doc = " freeing the string when no longer needed."]
    #[doc = " Returns allocated string on success, NULL on failure."]
    pub fn qemu_get_pid_name(pid: pid_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " qemu_fork:"]
    #[doc = ""]
    #[doc = " A version of fork that avoids signal handler race"]
    #[doc = " conditions that can lead to child process getting"]
    #[doc = " signals that are otherwise only expected by the"]
    #[doc = " parent. It also resets all signal handlers to the"]
    #[doc = " default settings."]
    #[doc = ""]
    #[doc = " Returns 0 to child process, pid number to parent"]
    #[doc = " or -1 on failure."]
    pub fn qemu_fork(errp: *mut *mut Error) -> pid_t;
}
extern "C" {
    pub fn panda_set_library_mode(arg1: bool);
}
extern "C" {
    pub fn panda_get_library_mode() -> bool;
}
pub type fprintf_function = ::std::option::Option<
    unsafe extern "C" fn(
        f: *mut FILE,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DUMMY_Q_ENTRY {
    pub next: DUMMY_Q_ENTRY__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DUMMY_Q_ENTRY__bindgen_ty_1 {
    pub tqe_next: *mut DUMMY_Q_ENTRY,
    pub tqe_prev: *mut *mut DUMMY_Q_ENTRY,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DUMMY_Q {
    pub head: DUMMY_Q_DUMMY_Q_HEAD,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DUMMY_Q_DUMMY_Q_HEAD {
    pub tqh_first: *mut DUMMY_Q_ENTRY,
    pub tqh_last: *mut *mut DUMMY_Q_ENTRY,
}
pub const QType_QTYPE_NONE: QType = 0;
pub const QType_QTYPE_QNULL: QType = 1;
pub const QType_QTYPE_QINT: QType = 2;
pub const QType_QTYPE_QSTRING: QType = 3;
pub const QType_QTYPE_QDICT: QType = 4;
pub const QType_QTYPE_QLIST: QType = 5;
pub const QType_QTYPE_QFLOAT: QType = 6;
pub const QType_QTYPE_QBOOL: QType = 7;
pub const QType_QTYPE__MAX: QType = 8;
pub type QType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct anyList {
    pub next: *mut anyList,
    pub value: *mut QObject,
}
extern "C" {
    pub fn qapi_free_anyList(obj: *mut anyList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct boolList {
    pub next: *mut boolList,
    pub value: bool,
}
extern "C" {
    pub fn qapi_free_boolList(obj: *mut boolList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int16List {
    pub next: *mut int16List,
    pub value: i16,
}
extern "C" {
    pub fn qapi_free_int16List(obj: *mut int16List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int32List {
    pub next: *mut int32List,
    pub value: i32,
}
extern "C" {
    pub fn qapi_free_int32List(obj: *mut int32List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int64List {
    pub next: *mut int64List,
    pub value: i64,
}
extern "C" {
    pub fn qapi_free_int64List(obj: *mut int64List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int8List {
    pub next: *mut int8List,
    pub value: i8,
}
extern "C" {
    pub fn qapi_free_int8List(obj: *mut int8List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct intList {
    pub next: *mut intList,
    pub value: i64,
}
extern "C" {
    pub fn qapi_free_intList(obj: *mut intList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct numberList {
    pub next: *mut numberList,
    pub value: f64,
}
extern "C" {
    pub fn qapi_free_numberList(obj: *mut numberList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sizeList {
    pub next: *mut sizeList,
    pub value: u64,
}
extern "C" {
    pub fn qapi_free_sizeList(obj: *mut sizeList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct strList {
    pub next: *mut strList,
    pub value: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_strList(obj: *mut strList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint16List {
    pub next: *mut uint16List,
    pub value: u16,
}
extern "C" {
    pub fn qapi_free_uint16List(obj: *mut uint16List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint32List {
    pub next: *mut uint32List,
    pub value: u32,
}
extern "C" {
    pub fn qapi_free_uint32List(obj: *mut uint32List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint64List {
    pub next: *mut uint64List,
    pub value: u64,
}
extern "C" {
    pub fn qapi_free_uint64List(obj: *mut uint64List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint8List {
    pub next: *mut uint8List,
    pub value: u8,
}
extern "C" {
    pub fn qapi_free_uint8List(obj: *mut uint8List);
}
pub const ACPISlotType_ACPI_SLOT_TYPE_DIMM: ACPISlotType = 0;
pub const ACPISlotType_ACPI_SLOT_TYPE_CPU: ACPISlotType = 1;
pub const ACPISlotType_ACPI_SLOT_TYPE__MAX: ACPISlotType = 2;
pub type ACPISlotType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ACPISlotType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const ActionCompletionMode_ACTION_COMPLETION_MODE_INDIVIDUAL: ActionCompletionMode = 0;
pub const ActionCompletionMode_ACTION_COMPLETION_MODE_GROUPED: ActionCompletionMode = 1;
pub const ActionCompletionMode_ACTION_COMPLETION_MODE__MAX: ActionCompletionMode = 2;
pub type ActionCompletionMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ActionCompletionMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BiosAtaTranslation_BIOS_ATA_TRANSLATION_AUTO: BiosAtaTranslation = 0;
pub const BiosAtaTranslation_BIOS_ATA_TRANSLATION_NONE: BiosAtaTranslation = 1;
pub const BiosAtaTranslation_BIOS_ATA_TRANSLATION_LBA: BiosAtaTranslation = 2;
pub const BiosAtaTranslation_BIOS_ATA_TRANSLATION_LARGE: BiosAtaTranslation = 3;
pub const BiosAtaTranslation_BIOS_ATA_TRANSLATION_RECHS: BiosAtaTranslation = 4;
pub const BiosAtaTranslation_BIOS_ATA_TRANSLATION__MAX: BiosAtaTranslation = 5;
pub type BiosAtaTranslation = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BiosAtaTranslation_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlkdebugEvent_BLKDBG_L1_UPDATE: BlkdebugEvent = 0;
pub const BlkdebugEvent_BLKDBG_L1_GROW_ALLOC_TABLE: BlkdebugEvent = 1;
pub const BlkdebugEvent_BLKDBG_L1_GROW_WRITE_TABLE: BlkdebugEvent = 2;
pub const BlkdebugEvent_BLKDBG_L1_GROW_ACTIVATE_TABLE: BlkdebugEvent = 3;
pub const BlkdebugEvent_BLKDBG_L2_LOAD: BlkdebugEvent = 4;
pub const BlkdebugEvent_BLKDBG_L2_UPDATE: BlkdebugEvent = 5;
pub const BlkdebugEvent_BLKDBG_L2_UPDATE_COMPRESSED: BlkdebugEvent = 6;
pub const BlkdebugEvent_BLKDBG_L2_ALLOC_COW_READ: BlkdebugEvent = 7;
pub const BlkdebugEvent_BLKDBG_L2_ALLOC_WRITE: BlkdebugEvent = 8;
pub const BlkdebugEvent_BLKDBG_READ_AIO: BlkdebugEvent = 9;
pub const BlkdebugEvent_BLKDBG_READ_BACKING_AIO: BlkdebugEvent = 10;
pub const BlkdebugEvent_BLKDBG_READ_COMPRESSED: BlkdebugEvent = 11;
pub const BlkdebugEvent_BLKDBG_WRITE_AIO: BlkdebugEvent = 12;
pub const BlkdebugEvent_BLKDBG_WRITE_COMPRESSED: BlkdebugEvent = 13;
pub const BlkdebugEvent_BLKDBG_VMSTATE_LOAD: BlkdebugEvent = 14;
pub const BlkdebugEvent_BLKDBG_VMSTATE_SAVE: BlkdebugEvent = 15;
pub const BlkdebugEvent_BLKDBG_COW_READ: BlkdebugEvent = 16;
pub const BlkdebugEvent_BLKDBG_COW_WRITE: BlkdebugEvent = 17;
pub const BlkdebugEvent_BLKDBG_REFTABLE_LOAD: BlkdebugEvent = 18;
pub const BlkdebugEvent_BLKDBG_REFTABLE_GROW: BlkdebugEvent = 19;
pub const BlkdebugEvent_BLKDBG_REFTABLE_UPDATE: BlkdebugEvent = 20;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_LOAD: BlkdebugEvent = 21;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_UPDATE: BlkdebugEvent = 22;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_UPDATE_PART: BlkdebugEvent = 23;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_ALLOC: BlkdebugEvent = 24;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_ALLOC_HOOKUP: BlkdebugEvent = 25;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_ALLOC_WRITE: BlkdebugEvent = 26;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_ALLOC_WRITE_BLOCKS: BlkdebugEvent = 27;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_ALLOC_WRITE_TABLE: BlkdebugEvent = 28;
pub const BlkdebugEvent_BLKDBG_REFBLOCK_ALLOC_SWITCH_TABLE: BlkdebugEvent = 29;
pub const BlkdebugEvent_BLKDBG_CLUSTER_ALLOC: BlkdebugEvent = 30;
pub const BlkdebugEvent_BLKDBG_CLUSTER_ALLOC_BYTES: BlkdebugEvent = 31;
pub const BlkdebugEvent_BLKDBG_CLUSTER_FREE: BlkdebugEvent = 32;
pub const BlkdebugEvent_BLKDBG_FLUSH_TO_OS: BlkdebugEvent = 33;
pub const BlkdebugEvent_BLKDBG_FLUSH_TO_DISK: BlkdebugEvent = 34;
pub const BlkdebugEvent_BLKDBG_PWRITEV_RMW_HEAD: BlkdebugEvent = 35;
pub const BlkdebugEvent_BLKDBG_PWRITEV_RMW_AFTER_HEAD: BlkdebugEvent = 36;
pub const BlkdebugEvent_BLKDBG_PWRITEV_RMW_TAIL: BlkdebugEvent = 37;
pub const BlkdebugEvent_BLKDBG_PWRITEV_RMW_AFTER_TAIL: BlkdebugEvent = 38;
pub const BlkdebugEvent_BLKDBG_PWRITEV: BlkdebugEvent = 39;
pub const BlkdebugEvent_BLKDBG_PWRITEV_ZERO: BlkdebugEvent = 40;
pub const BlkdebugEvent_BLKDBG_PWRITEV_DONE: BlkdebugEvent = 41;
pub const BlkdebugEvent_BLKDBG_EMPTY_IMAGE_PREPARE: BlkdebugEvent = 42;
pub const BlkdebugEvent_BLKDBG__MAX: BlkdebugEvent = 43;
pub type BlkdebugEvent = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlkdebugEvent_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockDeviceIoStatus_BLOCK_DEVICE_IO_STATUS_OK: BlockDeviceIoStatus = 0;
pub const BlockDeviceIoStatus_BLOCK_DEVICE_IO_STATUS_FAILED: BlockDeviceIoStatus = 1;
pub const BlockDeviceIoStatus_BLOCK_DEVICE_IO_STATUS_NOSPACE: BlockDeviceIoStatus = 2;
pub const BlockDeviceIoStatus_BLOCK_DEVICE_IO_STATUS__MAX: BlockDeviceIoStatus = 3;
pub type BlockDeviceIoStatus = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockDeviceIoStatus_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockErrorAction_BLOCK_ERROR_ACTION_IGNORE: BlockErrorAction = 0;
pub const BlockErrorAction_BLOCK_ERROR_ACTION_REPORT: BlockErrorAction = 1;
pub const BlockErrorAction_BLOCK_ERROR_ACTION_STOP: BlockErrorAction = 2;
pub const BlockErrorAction_BLOCK_ERROR_ACTION__MAX: BlockErrorAction = 3;
pub type BlockErrorAction = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockErrorAction_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockJobType_BLOCK_JOB_TYPE_COMMIT: BlockJobType = 0;
pub const BlockJobType_BLOCK_JOB_TYPE_STREAM: BlockJobType = 1;
pub const BlockJobType_BLOCK_JOB_TYPE_MIRROR: BlockJobType = 2;
pub const BlockJobType_BLOCK_JOB_TYPE_BACKUP: BlockJobType = 3;
pub const BlockJobType_BLOCK_JOB_TYPE__MAX: BlockJobType = 4;
pub type BlockJobType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockJobType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockdevAioOptions_BLOCKDEV_AIO_OPTIONS_THREADS: BlockdevAioOptions = 0;
pub const BlockdevAioOptions_BLOCKDEV_AIO_OPTIONS_NATIVE: BlockdevAioOptions = 1;
pub const BlockdevAioOptions_BLOCKDEV_AIO_OPTIONS__MAX: BlockdevAioOptions = 2;
pub type BlockdevAioOptions = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockdevAioOptions_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockdevChangeReadOnlyMode_BLOCKDEV_CHANGE_READ_ONLY_MODE_RETAIN:
    BlockdevChangeReadOnlyMode = 0;
pub const BlockdevChangeReadOnlyMode_BLOCKDEV_CHANGE_READ_ONLY_MODE_READ_ONLY:
    BlockdevChangeReadOnlyMode = 1;
pub const BlockdevChangeReadOnlyMode_BLOCKDEV_CHANGE_READ_ONLY_MODE_READ_WRITE:
    BlockdevChangeReadOnlyMode = 2;
pub const BlockdevChangeReadOnlyMode_BLOCKDEV_CHANGE_READ_ONLY_MODE__MAX:
    BlockdevChangeReadOnlyMode = 3;
pub type BlockdevChangeReadOnlyMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockdevChangeReadOnlyMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockdevDetectZeroesOptions_BLOCKDEV_DETECT_ZEROES_OPTIONS_OFF:
    BlockdevDetectZeroesOptions = 0;
pub const BlockdevDetectZeroesOptions_BLOCKDEV_DETECT_ZEROES_OPTIONS_ON:
    BlockdevDetectZeroesOptions = 1;
pub const BlockdevDetectZeroesOptions_BLOCKDEV_DETECT_ZEROES_OPTIONS_UNMAP:
    BlockdevDetectZeroesOptions = 2;
pub const BlockdevDetectZeroesOptions_BLOCKDEV_DETECT_ZEROES_OPTIONS__MAX:
    BlockdevDetectZeroesOptions = 3;
pub type BlockdevDetectZeroesOptions = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockdevDetectZeroesOptions_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockdevDiscardOptions_BLOCKDEV_DISCARD_OPTIONS_IGNORE: BlockdevDiscardOptions = 0;
pub const BlockdevDiscardOptions_BLOCKDEV_DISCARD_OPTIONS_UNMAP: BlockdevDiscardOptions = 1;
pub const BlockdevDiscardOptions_BLOCKDEV_DISCARD_OPTIONS__MAX: BlockdevDiscardOptions = 2;
pub type BlockdevDiscardOptions = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockdevDiscardOptions_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockdevDriver_BLOCKDEV_DRIVER_BLKDEBUG: BlockdevDriver = 0;
pub const BlockdevDriver_BLOCKDEV_DRIVER_BLKVERIFY: BlockdevDriver = 1;
pub const BlockdevDriver_BLOCKDEV_DRIVER_BOCHS: BlockdevDriver = 2;
pub const BlockdevDriver_BLOCKDEV_DRIVER_CLOOP: BlockdevDriver = 3;
pub const BlockdevDriver_BLOCKDEV_DRIVER_DMG: BlockdevDriver = 4;
pub const BlockdevDriver_BLOCKDEV_DRIVER_FILE: BlockdevDriver = 5;
pub const BlockdevDriver_BLOCKDEV_DRIVER_FTP: BlockdevDriver = 6;
pub const BlockdevDriver_BLOCKDEV_DRIVER_FTPS: BlockdevDriver = 7;
pub const BlockdevDriver_BLOCKDEV_DRIVER_GLUSTER: BlockdevDriver = 8;
pub const BlockdevDriver_BLOCKDEV_DRIVER_HOST_CDROM: BlockdevDriver = 9;
pub const BlockdevDriver_BLOCKDEV_DRIVER_HOST_DEVICE: BlockdevDriver = 10;
pub const BlockdevDriver_BLOCKDEV_DRIVER_HTTP: BlockdevDriver = 11;
pub const BlockdevDriver_BLOCKDEV_DRIVER_HTTPS: BlockdevDriver = 12;
pub const BlockdevDriver_BLOCKDEV_DRIVER_ISCSI: BlockdevDriver = 13;
pub const BlockdevDriver_BLOCKDEV_DRIVER_LUKS: BlockdevDriver = 14;
pub const BlockdevDriver_BLOCKDEV_DRIVER_NBD: BlockdevDriver = 15;
pub const BlockdevDriver_BLOCKDEV_DRIVER_NFS: BlockdevDriver = 16;
pub const BlockdevDriver_BLOCKDEV_DRIVER_NULL_AIO: BlockdevDriver = 17;
pub const BlockdevDriver_BLOCKDEV_DRIVER_NULL_CO: BlockdevDriver = 18;
pub const BlockdevDriver_BLOCKDEV_DRIVER_PARALLELS: BlockdevDriver = 19;
pub const BlockdevDriver_BLOCKDEV_DRIVER_QCOW: BlockdevDriver = 20;
pub const BlockdevDriver_BLOCKDEV_DRIVER_QCOW2: BlockdevDriver = 21;
pub const BlockdevDriver_BLOCKDEV_DRIVER_QED: BlockdevDriver = 22;
pub const BlockdevDriver_BLOCKDEV_DRIVER_QUORUM: BlockdevDriver = 23;
pub const BlockdevDriver_BLOCKDEV_DRIVER_RAW: BlockdevDriver = 24;
pub const BlockdevDriver_BLOCKDEV_DRIVER_RBD: BlockdevDriver = 25;
pub const BlockdevDriver_BLOCKDEV_DRIVER_REPLICATION: BlockdevDriver = 26;
pub const BlockdevDriver_BLOCKDEV_DRIVER_SHEEPDOG: BlockdevDriver = 27;
pub const BlockdevDriver_BLOCKDEV_DRIVER_SSH: BlockdevDriver = 28;
pub const BlockdevDriver_BLOCKDEV_DRIVER_VDI: BlockdevDriver = 29;
pub const BlockdevDriver_BLOCKDEV_DRIVER_VHDX: BlockdevDriver = 30;
pub const BlockdevDriver_BLOCKDEV_DRIVER_VMDK: BlockdevDriver = 31;
pub const BlockdevDriver_BLOCKDEV_DRIVER_VPC: BlockdevDriver = 32;
pub const BlockdevDriver_BLOCKDEV_DRIVER_VVFAT: BlockdevDriver = 33;
pub const BlockdevDriver_BLOCKDEV_DRIVER__MAX: BlockdevDriver = 34;
pub type BlockdevDriver = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockdevDriver_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const BlockdevOnError_BLOCKDEV_ON_ERROR_REPORT: BlockdevOnError = 0;
pub const BlockdevOnError_BLOCKDEV_ON_ERROR_IGNORE: BlockdevOnError = 1;
pub const BlockdevOnError_BLOCKDEV_ON_ERROR_ENOSPC: BlockdevOnError = 2;
pub const BlockdevOnError_BLOCKDEV_ON_ERROR_STOP: BlockdevOnError = 3;
pub const BlockdevOnError_BLOCKDEV_ON_ERROR_AUTO: BlockdevOnError = 4;
pub const BlockdevOnError_BLOCKDEV_ON_ERROR__MAX: BlockdevOnError = 5;
pub type BlockdevOnError = ::std::os::raw::c_uint;
extern "C" {
    pub static mut BlockdevOnError_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const COLOMessage_COLO_MESSAGE_CHECKPOINT_READY: COLOMessage = 0;
pub const COLOMessage_COLO_MESSAGE_CHECKPOINT_REQUEST: COLOMessage = 1;
pub const COLOMessage_COLO_MESSAGE_CHECKPOINT_REPLY: COLOMessage = 2;
pub const COLOMessage_COLO_MESSAGE_VMSTATE_SEND: COLOMessage = 3;
pub const COLOMessage_COLO_MESSAGE_VMSTATE_SIZE: COLOMessage = 4;
pub const COLOMessage_COLO_MESSAGE_VMSTATE_RECEIVED: COLOMessage = 5;
pub const COLOMessage_COLO_MESSAGE_VMSTATE_LOADED: COLOMessage = 6;
pub const COLOMessage_COLO_MESSAGE__MAX: COLOMessage = 7;
pub type COLOMessage = ::std::os::raw::c_uint;
extern "C" {
    pub static mut COLOMessage_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const COLOMode_COLO_MODE_UNKNOWN: COLOMode = 0;
pub const COLOMode_COLO_MODE_PRIMARY: COLOMode = 1;
pub const COLOMode_COLO_MODE_SECONDARY: COLOMode = 2;
pub const COLOMode_COLO_MODE__MAX: COLOMode = 3;
pub type COLOMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut COLOMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_FILE: ChardevBackendKind = 0;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_SERIAL: ChardevBackendKind = 1;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_PARALLEL: ChardevBackendKind = 2;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_PIPE: ChardevBackendKind = 3;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_SOCKET: ChardevBackendKind = 4;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_UDP: ChardevBackendKind = 5;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_PTY: ChardevBackendKind = 6;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_NULL: ChardevBackendKind = 7;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_MUX: ChardevBackendKind = 8;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_MSMOUSE: ChardevBackendKind = 9;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_WCTABLET: ChardevBackendKind = 10;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_BRAILLE: ChardevBackendKind = 11;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_TESTDEV: ChardevBackendKind = 12;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_STDIO: ChardevBackendKind = 13;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_CONSOLE: ChardevBackendKind = 14;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_SPICEVMC: ChardevBackendKind = 15;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_SPICEPORT: ChardevBackendKind = 16;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_VC: ChardevBackendKind = 17;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_RINGBUF: ChardevBackendKind = 18;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND_MEMORY: ChardevBackendKind = 19;
pub const ChardevBackendKind_CHARDEV_BACKEND_KIND__MAX: ChardevBackendKind = 20;
pub type ChardevBackendKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ChardevBackendKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const CommandLineParameterType_COMMAND_LINE_PARAMETER_TYPE_STRING: CommandLineParameterType = 0;
pub const CommandLineParameterType_COMMAND_LINE_PARAMETER_TYPE_BOOLEAN: CommandLineParameterType =
    1;
pub const CommandLineParameterType_COMMAND_LINE_PARAMETER_TYPE_NUMBER: CommandLineParameterType = 2;
pub const CommandLineParameterType_COMMAND_LINE_PARAMETER_TYPE_SIZE: CommandLineParameterType = 3;
pub const CommandLineParameterType_COMMAND_LINE_PARAMETER_TYPE__MAX: CommandLineParameterType = 4;
pub type CommandLineParameterType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut CommandLineParameterType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const CpuInfoArch_CPU_INFO_ARCH_X86: CpuInfoArch = 0;
pub const CpuInfoArch_CPU_INFO_ARCH_SPARC: CpuInfoArch = 1;
pub const CpuInfoArch_CPU_INFO_ARCH_PPC: CpuInfoArch = 2;
pub const CpuInfoArch_CPU_INFO_ARCH_MIPS: CpuInfoArch = 3;
pub const CpuInfoArch_CPU_INFO_ARCH_TRICORE: CpuInfoArch = 4;
pub const CpuInfoArch_CPU_INFO_ARCH_OTHER: CpuInfoArch = 5;
pub const CpuInfoArch_CPU_INFO_ARCH__MAX: CpuInfoArch = 6;
pub type CpuInfoArch = ::std::os::raw::c_uint;
extern "C" {
    pub static mut CpuInfoArch_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const CpuModelCompareResult_CPU_MODEL_COMPARE_RESULT_INCOMPATIBLE: CpuModelCompareResult = 0;
pub const CpuModelCompareResult_CPU_MODEL_COMPARE_RESULT_IDENTICAL: CpuModelCompareResult = 1;
pub const CpuModelCompareResult_CPU_MODEL_COMPARE_RESULT_SUPERSET: CpuModelCompareResult = 2;
pub const CpuModelCompareResult_CPU_MODEL_COMPARE_RESULT_SUBSET: CpuModelCompareResult = 3;
pub const CpuModelCompareResult_CPU_MODEL_COMPARE_RESULT__MAX: CpuModelCompareResult = 4;
pub type CpuModelCompareResult = ::std::os::raw::c_uint;
extern "C" {
    pub static mut CpuModelCompareResult_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const CpuModelExpansionType_CPU_MODEL_EXPANSION_TYPE_STATIC: CpuModelExpansionType = 0;
pub const CpuModelExpansionType_CPU_MODEL_EXPANSION_TYPE_FULL: CpuModelExpansionType = 1;
pub const CpuModelExpansionType_CPU_MODEL_EXPANSION_TYPE__MAX: CpuModelExpansionType = 2;
pub type CpuModelExpansionType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut CpuModelExpansionType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const DataFormat_DATA_FORMAT_UTF8: DataFormat = 0;
pub const DataFormat_DATA_FORMAT_BASE64: DataFormat = 1;
pub const DataFormat_DATA_FORMAT__MAX: DataFormat = 2;
pub type DataFormat = ::std::os::raw::c_uint;
extern "C" {
    pub static mut DataFormat_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const DirtyBitmapStatus_DIRTY_BITMAP_STATUS_ACTIVE: DirtyBitmapStatus = 0;
pub const DirtyBitmapStatus_DIRTY_BITMAP_STATUS_DISABLED: DirtyBitmapStatus = 1;
pub const DirtyBitmapStatus_DIRTY_BITMAP_STATUS_FROZEN: DirtyBitmapStatus = 2;
pub const DirtyBitmapStatus_DIRTY_BITMAP_STATUS__MAX: DirtyBitmapStatus = 3;
pub type DirtyBitmapStatus = ::std::os::raw::c_uint;
extern "C" {
    pub static mut DirtyBitmapStatus_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const DumpGuestMemoryFormat_DUMP_GUEST_MEMORY_FORMAT_ELF: DumpGuestMemoryFormat = 0;
pub const DumpGuestMemoryFormat_DUMP_GUEST_MEMORY_FORMAT_KDUMP_ZLIB: DumpGuestMemoryFormat = 1;
pub const DumpGuestMemoryFormat_DUMP_GUEST_MEMORY_FORMAT_KDUMP_LZO: DumpGuestMemoryFormat = 2;
pub const DumpGuestMemoryFormat_DUMP_GUEST_MEMORY_FORMAT_KDUMP_SNAPPY: DumpGuestMemoryFormat = 3;
pub const DumpGuestMemoryFormat_DUMP_GUEST_MEMORY_FORMAT__MAX: DumpGuestMemoryFormat = 4;
pub type DumpGuestMemoryFormat = ::std::os::raw::c_uint;
extern "C" {
    pub static mut DumpGuestMemoryFormat_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const DumpStatus_DUMP_STATUS_NONE: DumpStatus = 0;
pub const DumpStatus_DUMP_STATUS_ACTIVE: DumpStatus = 1;
pub const DumpStatus_DUMP_STATUS_COMPLETED: DumpStatus = 2;
pub const DumpStatus_DUMP_STATUS_FAILED: DumpStatus = 3;
pub const DumpStatus_DUMP_STATUS__MAX: DumpStatus = 4;
pub type DumpStatus = ::std::os::raw::c_uint;
extern "C" {
    pub static mut DumpStatus_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const FailoverStatus_FAILOVER_STATUS_NONE: FailoverStatus = 0;
pub const FailoverStatus_FAILOVER_STATUS_REQUIRE: FailoverStatus = 1;
pub const FailoverStatus_FAILOVER_STATUS_ACTIVE: FailoverStatus = 2;
pub const FailoverStatus_FAILOVER_STATUS_COMPLETED: FailoverStatus = 3;
pub const FailoverStatus_FAILOVER_STATUS_RELAUNCH: FailoverStatus = 4;
pub const FailoverStatus_FAILOVER_STATUS__MAX: FailoverStatus = 5;
pub type FailoverStatus = ::std::os::raw::c_uint;
extern "C" {
    pub static mut FailoverStatus_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const FloppyDriveType_FLOPPY_DRIVE_TYPE_144: FloppyDriveType = 0;
pub const FloppyDriveType_FLOPPY_DRIVE_TYPE_288: FloppyDriveType = 1;
pub const FloppyDriveType_FLOPPY_DRIVE_TYPE_120: FloppyDriveType = 2;
pub const FloppyDriveType_FLOPPY_DRIVE_TYPE_NONE: FloppyDriveType = 3;
pub const FloppyDriveType_FLOPPY_DRIVE_TYPE_AUTO: FloppyDriveType = 4;
pub const FloppyDriveType_FLOPPY_DRIVE_TYPE__MAX: FloppyDriveType = 5;
pub type FloppyDriveType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut FloppyDriveType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const GuestPanicAction_GUEST_PANIC_ACTION_PAUSE: GuestPanicAction = 0;
pub const GuestPanicAction_GUEST_PANIC_ACTION_POWEROFF: GuestPanicAction = 1;
pub const GuestPanicAction_GUEST_PANIC_ACTION__MAX: GuestPanicAction = 2;
pub type GuestPanicAction = ::std::os::raw::c_uint;
extern "C" {
    pub static mut GuestPanicAction_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const GuestPanicInformationType_GUEST_PANIC_INFORMATION_TYPE_HYPER_V:
    GuestPanicInformationType = 0;
pub const GuestPanicInformationType_GUEST_PANIC_INFORMATION_TYPE__MAX: GuestPanicInformationType =
    1;
pub type GuestPanicInformationType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut GuestPanicInformationType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const HostMemPolicy_HOST_MEM_POLICY_DEFAULT: HostMemPolicy = 0;
pub const HostMemPolicy_HOST_MEM_POLICY_PREFERRED: HostMemPolicy = 1;
pub const HostMemPolicy_HOST_MEM_POLICY_BIND: HostMemPolicy = 2;
pub const HostMemPolicy_HOST_MEM_POLICY_INTERLEAVE: HostMemPolicy = 3;
pub const HostMemPolicy_HOST_MEM_POLICY__MAX: HostMemPolicy = 4;
pub type HostMemPolicy = ::std::os::raw::c_uint;
extern "C" {
    pub static mut HostMemPolicy_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const ImageInfoSpecificKind_IMAGE_INFO_SPECIFIC_KIND_QCOW2: ImageInfoSpecificKind = 0;
pub const ImageInfoSpecificKind_IMAGE_INFO_SPECIFIC_KIND_VMDK: ImageInfoSpecificKind = 1;
pub const ImageInfoSpecificKind_IMAGE_INFO_SPECIFIC_KIND_LUKS: ImageInfoSpecificKind = 2;
pub const ImageInfoSpecificKind_IMAGE_INFO_SPECIFIC_KIND__MAX: ImageInfoSpecificKind = 3;
pub type ImageInfoSpecificKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ImageInfoSpecificKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const InputAxis_INPUT_AXIS_X: InputAxis = 0;
pub const InputAxis_INPUT_AXIS_Y: InputAxis = 1;
pub const InputAxis_INPUT_AXIS__MAX: InputAxis = 2;
pub type InputAxis = ::std::os::raw::c_uint;
extern "C" {
    pub static mut InputAxis_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const InputButton_INPUT_BUTTON_LEFT: InputButton = 0;
pub const InputButton_INPUT_BUTTON_MIDDLE: InputButton = 1;
pub const InputButton_INPUT_BUTTON_RIGHT: InputButton = 2;
pub const InputButton_INPUT_BUTTON_WHEEL_UP: InputButton = 3;
pub const InputButton_INPUT_BUTTON_WHEEL_DOWN: InputButton = 4;
pub const InputButton_INPUT_BUTTON_SIDE: InputButton = 5;
pub const InputButton_INPUT_BUTTON_EXTRA: InputButton = 6;
pub const InputButton_INPUT_BUTTON__MAX: InputButton = 7;
pub type InputButton = ::std::os::raw::c_uint;
extern "C" {
    pub static mut InputButton_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const InputEventKind_INPUT_EVENT_KIND_KEY: InputEventKind = 0;
pub const InputEventKind_INPUT_EVENT_KIND_BTN: InputEventKind = 1;
pub const InputEventKind_INPUT_EVENT_KIND_REL: InputEventKind = 2;
pub const InputEventKind_INPUT_EVENT_KIND_ABS: InputEventKind = 3;
pub const InputEventKind_INPUT_EVENT_KIND__MAX: InputEventKind = 4;
pub type InputEventKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut InputEventKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const IoOperationType_IO_OPERATION_TYPE_READ: IoOperationType = 0;
pub const IoOperationType_IO_OPERATION_TYPE_WRITE: IoOperationType = 1;
pub const IoOperationType_IO_OPERATION_TYPE__MAX: IoOperationType = 2;
pub type IoOperationType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut IoOperationType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const IscsiHeaderDigest_QAPI_ISCSI_HEADER_DIGEST_CRC32C: IscsiHeaderDigest = 0;
pub const IscsiHeaderDigest_QAPI_ISCSI_HEADER_DIGEST_NONE: IscsiHeaderDigest = 1;
pub const IscsiHeaderDigest_QAPI_ISCSI_HEADER_DIGEST_CRC32C_NONE: IscsiHeaderDigest = 2;
pub const IscsiHeaderDigest_QAPI_ISCSI_HEADER_DIGEST_NONE_CRC32C: IscsiHeaderDigest = 3;
pub const IscsiHeaderDigest_QAPI_ISCSI_HEADER_DIGEST__MAX: IscsiHeaderDigest = 4;
pub type IscsiHeaderDigest = ::std::os::raw::c_uint;
extern "C" {
    pub static mut IscsiHeaderDigest_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const IscsiTransport_ISCSI_TRANSPORT_TCP: IscsiTransport = 0;
pub const IscsiTransport_ISCSI_TRANSPORT_ISER: IscsiTransport = 1;
pub const IscsiTransport_ISCSI_TRANSPORT__MAX: IscsiTransport = 2;
pub type IscsiTransport = ::std::os::raw::c_uint;
extern "C" {
    pub static mut IscsiTransport_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const JSONType_JSON_TYPE_STRING: JSONType = 0;
pub const JSONType_JSON_TYPE_NUMBER: JSONType = 1;
pub const JSONType_JSON_TYPE_INT: JSONType = 2;
pub const JSONType_JSON_TYPE_BOOLEAN: JSONType = 3;
pub const JSONType_JSON_TYPE_NULL: JSONType = 4;
pub const JSONType_JSON_TYPE_OBJECT: JSONType = 5;
pub const JSONType_JSON_TYPE_ARRAY: JSONType = 6;
pub const JSONType_JSON_TYPE_VALUE: JSONType = 7;
pub const JSONType_JSON_TYPE__MAX: JSONType = 8;
pub type JSONType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut JSONType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const KeyValueKind_KEY_VALUE_KIND_NUMBER: KeyValueKind = 0;
pub const KeyValueKind_KEY_VALUE_KIND_QCODE: KeyValueKind = 1;
pub const KeyValueKind_KEY_VALUE_KIND__MAX: KeyValueKind = 2;
pub type KeyValueKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut KeyValueKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const LostTickPolicy_LOST_TICK_POLICY_DISCARD: LostTickPolicy = 0;
pub const LostTickPolicy_LOST_TICK_POLICY_DELAY: LostTickPolicy = 1;
pub const LostTickPolicy_LOST_TICK_POLICY_MERGE: LostTickPolicy = 2;
pub const LostTickPolicy_LOST_TICK_POLICY_SLEW: LostTickPolicy = 3;
pub const LostTickPolicy_LOST_TICK_POLICY__MAX: LostTickPolicy = 4;
pub type LostTickPolicy = ::std::os::raw::c_uint;
extern "C" {
    pub static mut LostTickPolicy_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const MemoryDeviceInfoKind_MEMORY_DEVICE_INFO_KIND_DIMM: MemoryDeviceInfoKind = 0;
pub const MemoryDeviceInfoKind_MEMORY_DEVICE_INFO_KIND__MAX: MemoryDeviceInfoKind = 1;
pub type MemoryDeviceInfoKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MemoryDeviceInfoKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const MigrationCapability_MIGRATION_CAPABILITY_XBZRLE: MigrationCapability = 0;
pub const MigrationCapability_MIGRATION_CAPABILITY_RDMA_PIN_ALL: MigrationCapability = 1;
pub const MigrationCapability_MIGRATION_CAPABILITY_AUTO_CONVERGE: MigrationCapability = 2;
pub const MigrationCapability_MIGRATION_CAPABILITY_ZERO_BLOCKS: MigrationCapability = 3;
pub const MigrationCapability_MIGRATION_CAPABILITY_COMPRESS: MigrationCapability = 4;
pub const MigrationCapability_MIGRATION_CAPABILITY_EVENTS: MigrationCapability = 5;
pub const MigrationCapability_MIGRATION_CAPABILITY_POSTCOPY_RAM: MigrationCapability = 6;
pub const MigrationCapability_MIGRATION_CAPABILITY_X_COLO: MigrationCapability = 7;
pub const MigrationCapability_MIGRATION_CAPABILITY_RELEASE_RAM: MigrationCapability = 8;
pub const MigrationCapability_MIGRATION_CAPABILITY__MAX: MigrationCapability = 9;
pub type MigrationCapability = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MigrationCapability_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const MigrationParameter_MIGRATION_PARAMETER_COMPRESS_LEVEL: MigrationParameter = 0;
pub const MigrationParameter_MIGRATION_PARAMETER_COMPRESS_THREADS: MigrationParameter = 1;
pub const MigrationParameter_MIGRATION_PARAMETER_DECOMPRESS_THREADS: MigrationParameter = 2;
pub const MigrationParameter_MIGRATION_PARAMETER_CPU_THROTTLE_INITIAL: MigrationParameter = 3;
pub const MigrationParameter_MIGRATION_PARAMETER_CPU_THROTTLE_INCREMENT: MigrationParameter = 4;
pub const MigrationParameter_MIGRATION_PARAMETER_TLS_CREDS: MigrationParameter = 5;
pub const MigrationParameter_MIGRATION_PARAMETER_TLS_HOSTNAME: MigrationParameter = 6;
pub const MigrationParameter_MIGRATION_PARAMETER_MAX_BANDWIDTH: MigrationParameter = 7;
pub const MigrationParameter_MIGRATION_PARAMETER_DOWNTIME_LIMIT: MigrationParameter = 8;
pub const MigrationParameter_MIGRATION_PARAMETER_X_CHECKPOINT_DELAY: MigrationParameter = 9;
pub const MigrationParameter_MIGRATION_PARAMETER__MAX: MigrationParameter = 10;
pub type MigrationParameter = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MigrationParameter_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const MigrationStatus_MIGRATION_STATUS_NONE: MigrationStatus = 0;
pub const MigrationStatus_MIGRATION_STATUS_SETUP: MigrationStatus = 1;
pub const MigrationStatus_MIGRATION_STATUS_CANCELLING: MigrationStatus = 2;
pub const MigrationStatus_MIGRATION_STATUS_CANCELLED: MigrationStatus = 3;
pub const MigrationStatus_MIGRATION_STATUS_ACTIVE: MigrationStatus = 4;
pub const MigrationStatus_MIGRATION_STATUS_POSTCOPY_ACTIVE: MigrationStatus = 5;
pub const MigrationStatus_MIGRATION_STATUS_COMPLETED: MigrationStatus = 6;
pub const MigrationStatus_MIGRATION_STATUS_FAILED: MigrationStatus = 7;
pub const MigrationStatus_MIGRATION_STATUS_COLO: MigrationStatus = 8;
pub const MigrationStatus_MIGRATION_STATUS__MAX: MigrationStatus = 9;
pub type MigrationStatus = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MigrationStatus_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const MirrorSyncMode_MIRROR_SYNC_MODE_TOP: MirrorSyncMode = 0;
pub const MirrorSyncMode_MIRROR_SYNC_MODE_FULL: MirrorSyncMode = 1;
pub const MirrorSyncMode_MIRROR_SYNC_MODE_NONE: MirrorSyncMode = 2;
pub const MirrorSyncMode_MIRROR_SYNC_MODE_INCREMENTAL: MirrorSyncMode = 3;
pub const MirrorSyncMode_MIRROR_SYNC_MODE__MAX: MirrorSyncMode = 4;
pub type MirrorSyncMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MirrorSyncMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NFSTransport_NFS_TRANSPORT_INET: NFSTransport = 0;
pub const NFSTransport_NFS_TRANSPORT__MAX: NFSTransport = 1;
pub type NFSTransport = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NFSTransport_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NetClientDriver_NET_CLIENT_DRIVER_NONE: NetClientDriver = 0;
pub const NetClientDriver_NET_CLIENT_DRIVER_NIC: NetClientDriver = 1;
pub const NetClientDriver_NET_CLIENT_DRIVER_USER: NetClientDriver = 2;
pub const NetClientDriver_NET_CLIENT_DRIVER_TAP: NetClientDriver = 3;
pub const NetClientDriver_NET_CLIENT_DRIVER_L2TPV3: NetClientDriver = 4;
pub const NetClientDriver_NET_CLIENT_DRIVER_SOCKET: NetClientDriver = 5;
pub const NetClientDriver_NET_CLIENT_DRIVER_VDE: NetClientDriver = 6;
pub const NetClientDriver_NET_CLIENT_DRIVER_DUMP: NetClientDriver = 7;
pub const NetClientDriver_NET_CLIENT_DRIVER_BRIDGE: NetClientDriver = 8;
pub const NetClientDriver_NET_CLIENT_DRIVER_HUBPORT: NetClientDriver = 9;
pub const NetClientDriver_NET_CLIENT_DRIVER_NETMAP: NetClientDriver = 10;
pub const NetClientDriver_NET_CLIENT_DRIVER_VHOST_USER: NetClientDriver = 11;
pub const NetClientDriver_NET_CLIENT_DRIVER__MAX: NetClientDriver = 12;
pub type NetClientDriver = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NetClientDriver_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NetFilterDirection_NET_FILTER_DIRECTION_ALL: NetFilterDirection = 0;
pub const NetFilterDirection_NET_FILTER_DIRECTION_RX: NetFilterDirection = 1;
pub const NetFilterDirection_NET_FILTER_DIRECTION_TX: NetFilterDirection = 2;
pub const NetFilterDirection_NET_FILTER_DIRECTION__MAX: NetFilterDirection = 3;
pub type NetFilterDirection = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NetFilterDirection_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_NONE: NetLegacyOptionsType = 0;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_NIC: NetLegacyOptionsType = 1;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_USER: NetLegacyOptionsType = 2;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_TAP: NetLegacyOptionsType = 3;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_L2TPV3: NetLegacyOptionsType = 4;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_SOCKET: NetLegacyOptionsType = 5;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_VDE: NetLegacyOptionsType = 6;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_DUMP: NetLegacyOptionsType = 7;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_BRIDGE: NetLegacyOptionsType = 8;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_NETMAP: NetLegacyOptionsType = 9;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE_VHOST_USER: NetLegacyOptionsType = 10;
pub const NetLegacyOptionsType_NET_LEGACY_OPTIONS_TYPE__MAX: NetLegacyOptionsType = 11;
pub type NetLegacyOptionsType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NetLegacyOptionsType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NetworkAddressFamily_NETWORK_ADDRESS_FAMILY_IPV4: NetworkAddressFamily = 0;
pub const NetworkAddressFamily_NETWORK_ADDRESS_FAMILY_IPV6: NetworkAddressFamily = 1;
pub const NetworkAddressFamily_NETWORK_ADDRESS_FAMILY_UNIX: NetworkAddressFamily = 2;
pub const NetworkAddressFamily_NETWORK_ADDRESS_FAMILY_VSOCK: NetworkAddressFamily = 3;
pub const NetworkAddressFamily_NETWORK_ADDRESS_FAMILY_UNKNOWN: NetworkAddressFamily = 4;
pub const NetworkAddressFamily_NETWORK_ADDRESS_FAMILY__MAX: NetworkAddressFamily = 5;
pub type NetworkAddressFamily = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NetworkAddressFamily_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NewImageMode_NEW_IMAGE_MODE_EXISTING: NewImageMode = 0;
pub const NewImageMode_NEW_IMAGE_MODE_ABSOLUTE_PATHS: NewImageMode = 1;
pub const NewImageMode_NEW_IMAGE_MODE__MAX: NewImageMode = 2;
pub type NewImageMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NewImageMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const NumaOptionsType_NUMA_OPTIONS_TYPE_NODE: NumaOptionsType = 0;
pub const NumaOptionsType_NUMA_OPTIONS_TYPE__MAX: NumaOptionsType = 1;
pub type NumaOptionsType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut NumaOptionsType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const OnOffAuto_ON_OFF_AUTO_AUTO: OnOffAuto = 0;
pub const OnOffAuto_ON_OFF_AUTO_ON: OnOffAuto = 1;
pub const OnOffAuto_ON_OFF_AUTO_OFF: OnOffAuto = 2;
pub const OnOffAuto_ON_OFF_AUTO__MAX: OnOffAuto = 3;
pub type OnOffAuto = ::std::os::raw::c_uint;
extern "C" {
    pub static mut OnOffAuto_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const OnOffSplit_ON_OFF_SPLIT_ON: OnOffSplit = 0;
pub const OnOffSplit_ON_OFF_SPLIT_OFF: OnOffSplit = 1;
pub const OnOffSplit_ON_OFF_SPLIT_SPLIT: OnOffSplit = 2;
pub const OnOffSplit_ON_OFF_SPLIT__MAX: OnOffSplit = 3;
pub type OnOffSplit = ::std::os::raw::c_uint;
extern "C" {
    pub static mut OnOffSplit_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const PreallocMode_PREALLOC_MODE_OFF: PreallocMode = 0;
pub const PreallocMode_PREALLOC_MODE_METADATA: PreallocMode = 1;
pub const PreallocMode_PREALLOC_MODE_FALLOC: PreallocMode = 2;
pub const PreallocMode_PREALLOC_MODE_FULL: PreallocMode = 3;
pub const PreallocMode_PREALLOC_MODE__MAX: PreallocMode = 4;
pub type PreallocMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut PreallocMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoBlockFormat_Q_CRYPTO_BLOCK_FORMAT_QCOW: QCryptoBlockFormat = 0;
pub const QCryptoBlockFormat_Q_CRYPTO_BLOCK_FORMAT_LUKS: QCryptoBlockFormat = 1;
pub const QCryptoBlockFormat_Q_CRYPTO_BLOCK_FORMAT__MAX: QCryptoBlockFormat = 2;
pub type QCryptoBlockFormat = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoBlockFormat_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_AES_128: QCryptoCipherAlgorithm = 0;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_AES_192: QCryptoCipherAlgorithm = 1;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_AES_256: QCryptoCipherAlgorithm = 2;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_DES_RFB: QCryptoCipherAlgorithm = 3;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_3DES: QCryptoCipherAlgorithm = 4;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_CAST5_128: QCryptoCipherAlgorithm = 5;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_SERPENT_128: QCryptoCipherAlgorithm = 6;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_SERPENT_192: QCryptoCipherAlgorithm = 7;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_SERPENT_256: QCryptoCipherAlgorithm = 8;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_TWOFISH_128: QCryptoCipherAlgorithm = 9;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_TWOFISH_192: QCryptoCipherAlgorithm = 10;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG_TWOFISH_256: QCryptoCipherAlgorithm = 11;
pub const QCryptoCipherAlgorithm_QCRYPTO_CIPHER_ALG__MAX: QCryptoCipherAlgorithm = 12;
pub type QCryptoCipherAlgorithm = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoCipherAlgorithm_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoCipherMode_QCRYPTO_CIPHER_MODE_ECB: QCryptoCipherMode = 0;
pub const QCryptoCipherMode_QCRYPTO_CIPHER_MODE_CBC: QCryptoCipherMode = 1;
pub const QCryptoCipherMode_QCRYPTO_CIPHER_MODE_XTS: QCryptoCipherMode = 2;
pub const QCryptoCipherMode_QCRYPTO_CIPHER_MODE_CTR: QCryptoCipherMode = 3;
pub const QCryptoCipherMode_QCRYPTO_CIPHER_MODE__MAX: QCryptoCipherMode = 4;
pub type QCryptoCipherMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoCipherMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_MD5: QCryptoHashAlgorithm = 0;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_SHA1: QCryptoHashAlgorithm = 1;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_SHA224: QCryptoHashAlgorithm = 2;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_SHA256: QCryptoHashAlgorithm = 3;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_SHA384: QCryptoHashAlgorithm = 4;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_SHA512: QCryptoHashAlgorithm = 5;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG_RIPEMD160: QCryptoHashAlgorithm = 6;
pub const QCryptoHashAlgorithm_QCRYPTO_HASH_ALG__MAX: QCryptoHashAlgorithm = 7;
pub type QCryptoHashAlgorithm = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoHashAlgorithm_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoIVGenAlgorithm_QCRYPTO_IVGEN_ALG_PLAIN: QCryptoIVGenAlgorithm = 0;
pub const QCryptoIVGenAlgorithm_QCRYPTO_IVGEN_ALG_PLAIN64: QCryptoIVGenAlgorithm = 1;
pub const QCryptoIVGenAlgorithm_QCRYPTO_IVGEN_ALG_ESSIV: QCryptoIVGenAlgorithm = 2;
pub const QCryptoIVGenAlgorithm_QCRYPTO_IVGEN_ALG__MAX: QCryptoIVGenAlgorithm = 3;
pub type QCryptoIVGenAlgorithm = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoIVGenAlgorithm_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoSecretFormat_QCRYPTO_SECRET_FORMAT_RAW: QCryptoSecretFormat = 0;
pub const QCryptoSecretFormat_QCRYPTO_SECRET_FORMAT_BASE64: QCryptoSecretFormat = 1;
pub const QCryptoSecretFormat_QCRYPTO_SECRET_FORMAT__MAX: QCryptoSecretFormat = 2;
pub type QCryptoSecretFormat = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoSecretFormat_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QCryptoTLSCredsEndpoint_QCRYPTO_TLS_CREDS_ENDPOINT_CLIENT: QCryptoTLSCredsEndpoint = 0;
pub const QCryptoTLSCredsEndpoint_QCRYPTO_TLS_CREDS_ENDPOINT_SERVER: QCryptoTLSCredsEndpoint = 1;
pub const QCryptoTLSCredsEndpoint_QCRYPTO_TLS_CREDS_ENDPOINT__MAX: QCryptoTLSCredsEndpoint = 2;
pub type QCryptoTLSCredsEndpoint = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QCryptoTLSCredsEndpoint_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QKeyCode_Q_KEY_CODE_UNMAPPED: QKeyCode = 0;
pub const QKeyCode_Q_KEY_CODE_SHIFT: QKeyCode = 1;
pub const QKeyCode_Q_KEY_CODE_SHIFT_R: QKeyCode = 2;
pub const QKeyCode_Q_KEY_CODE_ALT: QKeyCode = 3;
pub const QKeyCode_Q_KEY_CODE_ALT_R: QKeyCode = 4;
pub const QKeyCode_Q_KEY_CODE_ALTGR: QKeyCode = 5;
pub const QKeyCode_Q_KEY_CODE_ALTGR_R: QKeyCode = 6;
pub const QKeyCode_Q_KEY_CODE_CTRL: QKeyCode = 7;
pub const QKeyCode_Q_KEY_CODE_CTRL_R: QKeyCode = 8;
pub const QKeyCode_Q_KEY_CODE_MENU: QKeyCode = 9;
pub const QKeyCode_Q_KEY_CODE_ESC: QKeyCode = 10;
pub const QKeyCode_Q_KEY_CODE_1: QKeyCode = 11;
pub const QKeyCode_Q_KEY_CODE_2: QKeyCode = 12;
pub const QKeyCode_Q_KEY_CODE_3: QKeyCode = 13;
pub const QKeyCode_Q_KEY_CODE_4: QKeyCode = 14;
pub const QKeyCode_Q_KEY_CODE_5: QKeyCode = 15;
pub const QKeyCode_Q_KEY_CODE_6: QKeyCode = 16;
pub const QKeyCode_Q_KEY_CODE_7: QKeyCode = 17;
pub const QKeyCode_Q_KEY_CODE_8: QKeyCode = 18;
pub const QKeyCode_Q_KEY_CODE_9: QKeyCode = 19;
pub const QKeyCode_Q_KEY_CODE_0: QKeyCode = 20;
pub const QKeyCode_Q_KEY_CODE_MINUS: QKeyCode = 21;
pub const QKeyCode_Q_KEY_CODE_EQUAL: QKeyCode = 22;
pub const QKeyCode_Q_KEY_CODE_BACKSPACE: QKeyCode = 23;
pub const QKeyCode_Q_KEY_CODE_TAB: QKeyCode = 24;
pub const QKeyCode_Q_KEY_CODE_Q: QKeyCode = 25;
pub const QKeyCode_Q_KEY_CODE_W: QKeyCode = 26;
pub const QKeyCode_Q_KEY_CODE_E: QKeyCode = 27;
pub const QKeyCode_Q_KEY_CODE_R: QKeyCode = 28;
pub const QKeyCode_Q_KEY_CODE_T: QKeyCode = 29;
pub const QKeyCode_Q_KEY_CODE_Y: QKeyCode = 30;
pub const QKeyCode_Q_KEY_CODE_U: QKeyCode = 31;
pub const QKeyCode_Q_KEY_CODE_I: QKeyCode = 32;
pub const QKeyCode_Q_KEY_CODE_O: QKeyCode = 33;
pub const QKeyCode_Q_KEY_CODE_P: QKeyCode = 34;
pub const QKeyCode_Q_KEY_CODE_BRACKET_LEFT: QKeyCode = 35;
pub const QKeyCode_Q_KEY_CODE_BRACKET_RIGHT: QKeyCode = 36;
pub const QKeyCode_Q_KEY_CODE_RET: QKeyCode = 37;
pub const QKeyCode_Q_KEY_CODE_A: QKeyCode = 38;
pub const QKeyCode_Q_KEY_CODE_S: QKeyCode = 39;
pub const QKeyCode_Q_KEY_CODE_D: QKeyCode = 40;
pub const QKeyCode_Q_KEY_CODE_F: QKeyCode = 41;
pub const QKeyCode_Q_KEY_CODE_G: QKeyCode = 42;
pub const QKeyCode_Q_KEY_CODE_H: QKeyCode = 43;
pub const QKeyCode_Q_KEY_CODE_J: QKeyCode = 44;
pub const QKeyCode_Q_KEY_CODE_K: QKeyCode = 45;
pub const QKeyCode_Q_KEY_CODE_L: QKeyCode = 46;
pub const QKeyCode_Q_KEY_CODE_SEMICOLON: QKeyCode = 47;
pub const QKeyCode_Q_KEY_CODE_APOSTROPHE: QKeyCode = 48;
pub const QKeyCode_Q_KEY_CODE_GRAVE_ACCENT: QKeyCode = 49;
pub const QKeyCode_Q_KEY_CODE_BACKSLASH: QKeyCode = 50;
pub const QKeyCode_Q_KEY_CODE_Z: QKeyCode = 51;
pub const QKeyCode_Q_KEY_CODE_X: QKeyCode = 52;
pub const QKeyCode_Q_KEY_CODE_C: QKeyCode = 53;
pub const QKeyCode_Q_KEY_CODE_V: QKeyCode = 54;
pub const QKeyCode_Q_KEY_CODE_B: QKeyCode = 55;
pub const QKeyCode_Q_KEY_CODE_N: QKeyCode = 56;
pub const QKeyCode_Q_KEY_CODE_M: QKeyCode = 57;
pub const QKeyCode_Q_KEY_CODE_COMMA: QKeyCode = 58;
pub const QKeyCode_Q_KEY_CODE_DOT: QKeyCode = 59;
pub const QKeyCode_Q_KEY_CODE_SLASH: QKeyCode = 60;
pub const QKeyCode_Q_KEY_CODE_ASTERISK: QKeyCode = 61;
pub const QKeyCode_Q_KEY_CODE_SPC: QKeyCode = 62;
pub const QKeyCode_Q_KEY_CODE_CAPS_LOCK: QKeyCode = 63;
pub const QKeyCode_Q_KEY_CODE_F1: QKeyCode = 64;
pub const QKeyCode_Q_KEY_CODE_F2: QKeyCode = 65;
pub const QKeyCode_Q_KEY_CODE_F3: QKeyCode = 66;
pub const QKeyCode_Q_KEY_CODE_F4: QKeyCode = 67;
pub const QKeyCode_Q_KEY_CODE_F5: QKeyCode = 68;
pub const QKeyCode_Q_KEY_CODE_F6: QKeyCode = 69;
pub const QKeyCode_Q_KEY_CODE_F7: QKeyCode = 70;
pub const QKeyCode_Q_KEY_CODE_F8: QKeyCode = 71;
pub const QKeyCode_Q_KEY_CODE_F9: QKeyCode = 72;
pub const QKeyCode_Q_KEY_CODE_F10: QKeyCode = 73;
pub const QKeyCode_Q_KEY_CODE_NUM_LOCK: QKeyCode = 74;
pub const QKeyCode_Q_KEY_CODE_SCROLL_LOCK: QKeyCode = 75;
pub const QKeyCode_Q_KEY_CODE_KP_DIVIDE: QKeyCode = 76;
pub const QKeyCode_Q_KEY_CODE_KP_MULTIPLY: QKeyCode = 77;
pub const QKeyCode_Q_KEY_CODE_KP_SUBTRACT: QKeyCode = 78;
pub const QKeyCode_Q_KEY_CODE_KP_ADD: QKeyCode = 79;
pub const QKeyCode_Q_KEY_CODE_KP_ENTER: QKeyCode = 80;
pub const QKeyCode_Q_KEY_CODE_KP_DECIMAL: QKeyCode = 81;
pub const QKeyCode_Q_KEY_CODE_SYSRQ: QKeyCode = 82;
pub const QKeyCode_Q_KEY_CODE_KP_0: QKeyCode = 83;
pub const QKeyCode_Q_KEY_CODE_KP_1: QKeyCode = 84;
pub const QKeyCode_Q_KEY_CODE_KP_2: QKeyCode = 85;
pub const QKeyCode_Q_KEY_CODE_KP_3: QKeyCode = 86;
pub const QKeyCode_Q_KEY_CODE_KP_4: QKeyCode = 87;
pub const QKeyCode_Q_KEY_CODE_KP_5: QKeyCode = 88;
pub const QKeyCode_Q_KEY_CODE_KP_6: QKeyCode = 89;
pub const QKeyCode_Q_KEY_CODE_KP_7: QKeyCode = 90;
pub const QKeyCode_Q_KEY_CODE_KP_8: QKeyCode = 91;
pub const QKeyCode_Q_KEY_CODE_KP_9: QKeyCode = 92;
pub const QKeyCode_Q_KEY_CODE_LESS: QKeyCode = 93;
pub const QKeyCode_Q_KEY_CODE_F11: QKeyCode = 94;
pub const QKeyCode_Q_KEY_CODE_F12: QKeyCode = 95;
pub const QKeyCode_Q_KEY_CODE_PRINT: QKeyCode = 96;
pub const QKeyCode_Q_KEY_CODE_HOME: QKeyCode = 97;
pub const QKeyCode_Q_KEY_CODE_PGUP: QKeyCode = 98;
pub const QKeyCode_Q_KEY_CODE_PGDN: QKeyCode = 99;
pub const QKeyCode_Q_KEY_CODE_END: QKeyCode = 100;
pub const QKeyCode_Q_KEY_CODE_LEFT: QKeyCode = 101;
pub const QKeyCode_Q_KEY_CODE_UP: QKeyCode = 102;
pub const QKeyCode_Q_KEY_CODE_DOWN: QKeyCode = 103;
pub const QKeyCode_Q_KEY_CODE_RIGHT: QKeyCode = 104;
pub const QKeyCode_Q_KEY_CODE_INSERT: QKeyCode = 105;
pub const QKeyCode_Q_KEY_CODE_DELETE: QKeyCode = 106;
pub const QKeyCode_Q_KEY_CODE_STOP: QKeyCode = 107;
pub const QKeyCode_Q_KEY_CODE_AGAIN: QKeyCode = 108;
pub const QKeyCode_Q_KEY_CODE_PROPS: QKeyCode = 109;
pub const QKeyCode_Q_KEY_CODE_UNDO: QKeyCode = 110;
pub const QKeyCode_Q_KEY_CODE_FRONT: QKeyCode = 111;
pub const QKeyCode_Q_KEY_CODE_COPY: QKeyCode = 112;
pub const QKeyCode_Q_KEY_CODE_OPEN: QKeyCode = 113;
pub const QKeyCode_Q_KEY_CODE_PASTE: QKeyCode = 114;
pub const QKeyCode_Q_KEY_CODE_FIND: QKeyCode = 115;
pub const QKeyCode_Q_KEY_CODE_CUT: QKeyCode = 116;
pub const QKeyCode_Q_KEY_CODE_LF: QKeyCode = 117;
pub const QKeyCode_Q_KEY_CODE_HELP: QKeyCode = 118;
pub const QKeyCode_Q_KEY_CODE_META_L: QKeyCode = 119;
pub const QKeyCode_Q_KEY_CODE_META_R: QKeyCode = 120;
pub const QKeyCode_Q_KEY_CODE_COMPOSE: QKeyCode = 121;
pub const QKeyCode_Q_KEY_CODE_PAUSE: QKeyCode = 122;
pub const QKeyCode_Q_KEY_CODE_RO: QKeyCode = 123;
pub const QKeyCode_Q_KEY_CODE_HIRAGANA: QKeyCode = 124;
pub const QKeyCode_Q_KEY_CODE_HENKAN: QKeyCode = 125;
pub const QKeyCode_Q_KEY_CODE_YEN: QKeyCode = 126;
pub const QKeyCode_Q_KEY_CODE_KP_COMMA: QKeyCode = 127;
pub const QKeyCode_Q_KEY_CODE_KP_EQUALS: QKeyCode = 128;
pub const QKeyCode_Q_KEY_CODE_POWER: QKeyCode = 129;
pub const QKeyCode_Q_KEY_CODE__MAX: QKeyCode = 130;
pub type QKeyCode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QKeyCode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QapiErrorClass_QAPI_ERROR_CLASS_GENERICERROR: QapiErrorClass = 0;
pub const QapiErrorClass_QAPI_ERROR_CLASS_COMMANDNOTFOUND: QapiErrorClass = 1;
pub const QapiErrorClass_QAPI_ERROR_CLASS_DEVICEENCRYPTED: QapiErrorClass = 2;
pub const QapiErrorClass_QAPI_ERROR_CLASS_DEVICENOTACTIVE: QapiErrorClass = 3;
pub const QapiErrorClass_QAPI_ERROR_CLASS_DEVICENOTFOUND: QapiErrorClass = 4;
pub const QapiErrorClass_QAPI_ERROR_CLASS_KVMMISSINGCAP: QapiErrorClass = 5;
pub const QapiErrorClass_QAPI_ERROR_CLASS__MAX: QapiErrorClass = 6;
pub type QapiErrorClass = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QapiErrorClass_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const Qcow2OverlapCheckMode_QCOW2_OVERLAP_CHECK_MODE_NONE: Qcow2OverlapCheckMode = 0;
pub const Qcow2OverlapCheckMode_QCOW2_OVERLAP_CHECK_MODE_CONSTANT: Qcow2OverlapCheckMode = 1;
pub const Qcow2OverlapCheckMode_QCOW2_OVERLAP_CHECK_MODE_CACHED: Qcow2OverlapCheckMode = 2;
pub const Qcow2OverlapCheckMode_QCOW2_OVERLAP_CHECK_MODE_ALL: Qcow2OverlapCheckMode = 3;
pub const Qcow2OverlapCheckMode_QCOW2_OVERLAP_CHECK_MODE__MAX: Qcow2OverlapCheckMode = 4;
pub type Qcow2OverlapCheckMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Qcow2OverlapCheckMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QuorumOpType_QUORUM_OP_TYPE_READ: QuorumOpType = 0;
pub const QuorumOpType_QUORUM_OP_TYPE_WRITE: QuorumOpType = 1;
pub const QuorumOpType_QUORUM_OP_TYPE_FLUSH: QuorumOpType = 2;
pub const QuorumOpType_QUORUM_OP_TYPE__MAX: QuorumOpType = 3;
pub type QuorumOpType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QuorumOpType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const QuorumReadPattern_QUORUM_READ_PATTERN_QUORUM: QuorumReadPattern = 0;
pub const QuorumReadPattern_QUORUM_READ_PATTERN_FIFO: QuorumReadPattern = 1;
pub const QuorumReadPattern_QUORUM_READ_PATTERN__MAX: QuorumReadPattern = 2;
pub type QuorumReadPattern = ::std::os::raw::c_uint;
extern "C" {
    pub static mut QuorumReadPattern_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const ReplayMode_REPLAY_MODE_NONE: ReplayMode = 0;
pub const ReplayMode_REPLAY_MODE_RECORD: ReplayMode = 1;
pub const ReplayMode_REPLAY_MODE_PLAY: ReplayMode = 2;
pub const ReplayMode_REPLAY_MODE__MAX: ReplayMode = 3;
pub type ReplayMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ReplayMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const ReplicationMode_REPLICATION_MODE_PRIMARY: ReplicationMode = 0;
pub const ReplicationMode_REPLICATION_MODE_SECONDARY: ReplicationMode = 1;
pub const ReplicationMode_REPLICATION_MODE__MAX: ReplicationMode = 2;
pub type ReplicationMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ReplicationMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const RockerPortAutoneg_ROCKER_PORT_AUTONEG_OFF: RockerPortAutoneg = 0;
pub const RockerPortAutoneg_ROCKER_PORT_AUTONEG_ON: RockerPortAutoneg = 1;
pub const RockerPortAutoneg_ROCKER_PORT_AUTONEG__MAX: RockerPortAutoneg = 2;
pub type RockerPortAutoneg = ::std::os::raw::c_uint;
extern "C" {
    pub static mut RockerPortAutoneg_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const RockerPortDuplex_ROCKER_PORT_DUPLEX_HALF: RockerPortDuplex = 0;
pub const RockerPortDuplex_ROCKER_PORT_DUPLEX_FULL: RockerPortDuplex = 1;
pub const RockerPortDuplex_ROCKER_PORT_DUPLEX__MAX: RockerPortDuplex = 2;
pub type RockerPortDuplex = ::std::os::raw::c_uint;
extern "C" {
    pub static mut RockerPortDuplex_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const RunState_RUN_STATE_DEBUG: RunState = 0;
pub const RunState_RUN_STATE_INMIGRATE: RunState = 1;
pub const RunState_RUN_STATE_INTERNAL_ERROR: RunState = 2;
pub const RunState_RUN_STATE_IO_ERROR: RunState = 3;
pub const RunState_RUN_STATE_PAUSED: RunState = 4;
pub const RunState_RUN_STATE_POSTMIGRATE: RunState = 5;
pub const RunState_RUN_STATE_PRELAUNCH: RunState = 6;
pub const RunState_RUN_STATE_FINISH_MIGRATE: RunState = 7;
pub const RunState_RUN_STATE_RESTORE_VM: RunState = 8;
pub const RunState_RUN_STATE_RUNNING: RunState = 9;
pub const RunState_RUN_STATE_SAVE_VM: RunState = 10;
pub const RunState_RUN_STATE_SHUTDOWN: RunState = 11;
pub const RunState_RUN_STATE_SUSPENDED: RunState = 12;
pub const RunState_RUN_STATE_WATCHDOG: RunState = 13;
pub const RunState_RUN_STATE_GUEST_PANICKED: RunState = 14;
pub const RunState_RUN_STATE_COLO: RunState = 15;
pub const RunState_RUN_STATE__MAX: RunState = 16;
pub type RunState = ::std::os::raw::c_uint;
extern "C" {
    pub static mut RunState_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const RxState_RX_STATE_NORMAL: RxState = 0;
pub const RxState_RX_STATE_NONE: RxState = 1;
pub const RxState_RX_STATE_ALL: RxState = 2;
pub const RxState_RX_STATE__MAX: RxState = 3;
pub type RxState = ::std::os::raw::c_uint;
extern "C" {
    pub static mut RxState_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const SchemaMetaType_SCHEMA_META_TYPE_BUILTIN: SchemaMetaType = 0;
pub const SchemaMetaType_SCHEMA_META_TYPE_ENUM: SchemaMetaType = 1;
pub const SchemaMetaType_SCHEMA_META_TYPE_ARRAY: SchemaMetaType = 2;
pub const SchemaMetaType_SCHEMA_META_TYPE_OBJECT: SchemaMetaType = 3;
pub const SchemaMetaType_SCHEMA_META_TYPE_ALTERNATE: SchemaMetaType = 4;
pub const SchemaMetaType_SCHEMA_META_TYPE_COMMAND: SchemaMetaType = 5;
pub const SchemaMetaType_SCHEMA_META_TYPE_EVENT: SchemaMetaType = 6;
pub const SchemaMetaType_SCHEMA_META_TYPE__MAX: SchemaMetaType = 7;
pub type SchemaMetaType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut SchemaMetaType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const SocketAddressFlatType_SOCKET_ADDRESS_FLAT_TYPE_INET: SocketAddressFlatType = 0;
pub const SocketAddressFlatType_SOCKET_ADDRESS_FLAT_TYPE_UNIX: SocketAddressFlatType = 1;
pub const SocketAddressFlatType_SOCKET_ADDRESS_FLAT_TYPE_VSOCK: SocketAddressFlatType = 2;
pub const SocketAddressFlatType_SOCKET_ADDRESS_FLAT_TYPE_FD: SocketAddressFlatType = 3;
pub const SocketAddressFlatType_SOCKET_ADDRESS_FLAT_TYPE__MAX: SocketAddressFlatType = 4;
pub type SocketAddressFlatType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut SocketAddressFlatType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const SocketAddressKind_SOCKET_ADDRESS_KIND_INET: SocketAddressKind = 0;
pub const SocketAddressKind_SOCKET_ADDRESS_KIND_UNIX: SocketAddressKind = 1;
pub const SocketAddressKind_SOCKET_ADDRESS_KIND_VSOCK: SocketAddressKind = 2;
pub const SocketAddressKind_SOCKET_ADDRESS_KIND_FD: SocketAddressKind = 3;
pub const SocketAddressKind_SOCKET_ADDRESS_KIND__MAX: SocketAddressKind = 4;
pub type SocketAddressKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut SocketAddressKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const SpiceQueryMouseMode_SPICE_QUERY_MOUSE_MODE_CLIENT: SpiceQueryMouseMode = 0;
pub const SpiceQueryMouseMode_SPICE_QUERY_MOUSE_MODE_SERVER: SpiceQueryMouseMode = 1;
pub const SpiceQueryMouseMode_SPICE_QUERY_MOUSE_MODE_UNKNOWN: SpiceQueryMouseMode = 2;
pub const SpiceQueryMouseMode_SPICE_QUERY_MOUSE_MODE__MAX: SpiceQueryMouseMode = 3;
pub type SpiceQueryMouseMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut SpiceQueryMouseMode_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const TpmModel_TPM_MODEL_TPM_TIS: TpmModel = 0;
pub const TpmModel_TPM_MODEL__MAX: TpmModel = 1;
pub type TpmModel = ::std::os::raw::c_uint;
extern "C" {
    pub static mut TpmModel_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const TpmType_TPM_TYPE_PASSTHROUGH: TpmType = 0;
pub const TpmType_TPM_TYPE__MAX: TpmType = 1;
pub type TpmType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut TpmType_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const TpmTypeOptionsKind_TPM_TYPE_OPTIONS_KIND_PASSTHROUGH: TpmTypeOptionsKind = 0;
pub const TpmTypeOptionsKind_TPM_TYPE_OPTIONS_KIND__MAX: TpmTypeOptionsKind = 1;
pub type TpmTypeOptionsKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut TpmTypeOptionsKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const TraceEventState_TRACE_EVENT_STATE_UNAVAILABLE: TraceEventState = 0;
pub const TraceEventState_TRACE_EVENT_STATE_DISABLED: TraceEventState = 1;
pub const TraceEventState_TRACE_EVENT_STATE_ENABLED: TraceEventState = 2;
pub const TraceEventState_TRACE_EVENT_STATE__MAX: TraceEventState = 3;
pub type TraceEventState = ::std::os::raw::c_uint;
extern "C" {
    pub static mut TraceEventState_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_ABORT: TransactionActionKind = 0;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_BLOCK_DIRTY_BITMAP_ADD:
    TransactionActionKind = 1;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_BLOCK_DIRTY_BITMAP_CLEAR:
    TransactionActionKind = 2;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_BLOCKDEV_BACKUP: TransactionActionKind = 3;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_BLOCKDEV_SNAPSHOT: TransactionActionKind =
    4;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_BLOCKDEV_SNAPSHOT_INTERNAL_SYNC:
    TransactionActionKind = 5;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_BLOCKDEV_SNAPSHOT_SYNC:
    TransactionActionKind = 6;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND_DRIVE_BACKUP: TransactionActionKind = 7;
pub const TransactionActionKind_TRANSACTION_ACTION_KIND__MAX: TransactionActionKind = 8;
pub type TransactionActionKind = ::std::os::raw::c_uint;
extern "C" {
    pub static mut TransactionActionKind_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_NONE: VncPrimaryAuth = 0;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_VNC: VncPrimaryAuth = 1;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_RA2: VncPrimaryAuth = 2;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_RA2NE: VncPrimaryAuth = 3;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_TIGHT: VncPrimaryAuth = 4;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_ULTRA: VncPrimaryAuth = 5;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_TLS: VncPrimaryAuth = 6;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_VENCRYPT: VncPrimaryAuth = 7;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH_SASL: VncPrimaryAuth = 8;
pub const VncPrimaryAuth_VNC_PRIMARY_AUTH__MAX: VncPrimaryAuth = 9;
pub type VncPrimaryAuth = ::std::os::raw::c_uint;
extern "C" {
    pub static mut VncPrimaryAuth_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_PLAIN: VncVencryptSubAuth = 0;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_TLS_NONE: VncVencryptSubAuth = 1;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_X509_NONE: VncVencryptSubAuth = 2;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_TLS_VNC: VncVencryptSubAuth = 3;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_X509_VNC: VncVencryptSubAuth = 4;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_TLS_PLAIN: VncVencryptSubAuth = 5;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_X509_PLAIN: VncVencryptSubAuth = 6;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_TLS_SASL: VncVencryptSubAuth = 7;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH_X509_SASL: VncVencryptSubAuth = 8;
pub const VncVencryptSubAuth_VNC_VENCRYPT_SUB_AUTH__MAX: VncVencryptSubAuth = 9;
pub type VncVencryptSubAuth = ::std::os::raw::c_uint;
extern "C" {
    pub static mut VncVencryptSubAuth_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_RESET: WatchdogExpirationAction = 0;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_SHUTDOWN: WatchdogExpirationAction =
    1;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_POWEROFF: WatchdogExpirationAction =
    2;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_PAUSE: WatchdogExpirationAction = 3;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_DEBUG: WatchdogExpirationAction = 4;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_NONE: WatchdogExpirationAction = 5;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION_INJECT_NMI: WatchdogExpirationAction =
    6;
pub const WatchdogExpirationAction_WATCHDOG_EXPIRATION_ACTION__MAX: WatchdogExpirationAction = 7;
pub type WatchdogExpirationAction = ::std::os::raw::c_uint;
extern "C" {
    pub static mut WatchdogExpirationAction_lookup: [*const ::std::os::raw::c_char; 0usize];
}
pub const X86CPURegister32_X86_CPU_REGISTER32_EAX: X86CPURegister32 = 0;
pub const X86CPURegister32_X86_CPU_REGISTER32_EBX: X86CPURegister32 = 1;
pub const X86CPURegister32_X86_CPU_REGISTER32_ECX: X86CPURegister32 = 2;
pub const X86CPURegister32_X86_CPU_REGISTER32_EDX: X86CPURegister32 = 3;
pub const X86CPURegister32_X86_CPU_REGISTER32_ESP: X86CPURegister32 = 4;
pub const X86CPURegister32_X86_CPU_REGISTER32_EBP: X86CPURegister32 = 5;
pub const X86CPURegister32_X86_CPU_REGISTER32_ESI: X86CPURegister32 = 6;
pub const X86CPURegister32_X86_CPU_REGISTER32_EDI: X86CPURegister32 = 7;
pub const X86CPURegister32_X86_CPU_REGISTER32__MAX: X86CPURegister32 = 8;
pub type X86CPURegister32 = ::std::os::raw::c_uint;
extern "C" {
    pub static mut X86CPURegister32_lookup: [*const ::std::os::raw::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ACPIOSTInfo {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub slot: *mut ::std::os::raw::c_char,
    pub slot_type: ACPISlotType,
    pub source: i64,
    pub status: i64,
}
extern "C" {
    pub fn qapi_free_ACPIOSTInfo(obj: *mut ACPIOSTInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ACPIOSTInfoList {
    pub next: *mut ACPIOSTInfoList,
    pub value: *mut ACPIOSTInfo,
}
extern "C" {
    pub fn qapi_free_ACPIOSTInfoList(obj: *mut ACPIOSTInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Abort {
    pub qapi_dummy_for_empty_struct: ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_Abort(obj: *mut Abort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AcpiTableOptions {
    pub has_sig: bool,
    pub sig: *mut ::std::os::raw::c_char,
    pub has_rev: bool,
    pub rev: u8,
    pub has_oem_id: bool,
    pub oem_id: *mut ::std::os::raw::c_char,
    pub has_oem_table_id: bool,
    pub oem_table_id: *mut ::std::os::raw::c_char,
    pub has_oem_rev: bool,
    pub oem_rev: u32,
    pub has_asl_compiler_id: bool,
    pub asl_compiler_id: *mut ::std::os::raw::c_char,
    pub has_asl_compiler_rev: bool,
    pub asl_compiler_rev: u32,
    pub has_file: bool,
    pub file: *mut ::std::os::raw::c_char,
    pub has_data: bool,
    pub data: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_AcpiTableOptions(obj: *mut AcpiTableOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AddfdInfo {
    pub fdset_id: i64,
    pub fd: i64,
}
extern "C" {
    pub fn qapi_free_AddfdInfo(obj: *mut AddfdInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BalloonInfo {
    pub actual: i64,
}
extern "C" {
    pub fn qapi_free_BalloonInfo(obj: *mut BalloonInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlkdebugInjectErrorOptions {
    pub event: BlkdebugEvent,
    pub has_state: bool,
    pub state: i64,
    pub has_q_errno: bool,
    pub q_errno: i64,
    pub has_sector: bool,
    pub sector: i64,
    pub has_once: bool,
    pub once: bool,
    pub has_immediately: bool,
    pub immediately: bool,
}
extern "C" {
    pub fn qapi_free_BlkdebugInjectErrorOptions(obj: *mut BlkdebugInjectErrorOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlkdebugInjectErrorOptionsList {
    pub next: *mut BlkdebugInjectErrorOptionsList,
    pub value: *mut BlkdebugInjectErrorOptions,
}
extern "C" {
    pub fn qapi_free_BlkdebugInjectErrorOptionsList(obj: *mut BlkdebugInjectErrorOptionsList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlkdebugSetStateOptions {
    pub event: BlkdebugEvent,
    pub has_state: bool,
    pub state: i64,
    pub new_state: i64,
}
extern "C" {
    pub fn qapi_free_BlkdebugSetStateOptions(obj: *mut BlkdebugSetStateOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlkdebugSetStateOptionsList {
    pub next: *mut BlkdebugSetStateOptionsList,
    pub value: *mut BlkdebugSetStateOptions,
}
extern "C" {
    pub fn qapi_free_BlkdebugSetStateOptionsList(obj: *mut BlkdebugSetStateOptionsList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDeviceInfo {
    pub file: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub ro: bool,
    pub drv: *mut ::std::os::raw::c_char,
    pub has_backing_file: bool,
    pub backing_file: *mut ::std::os::raw::c_char,
    pub backing_file_depth: i64,
    pub encrypted: bool,
    pub encryption_key_missing: bool,
    pub detect_zeroes: BlockdevDetectZeroesOptions,
    pub bps: i64,
    pub bps_rd: i64,
    pub bps_wr: i64,
    pub iops: i64,
    pub iops_rd: i64,
    pub iops_wr: i64,
    pub image: *mut ImageInfo,
    pub has_bps_max: bool,
    pub bps_max: i64,
    pub has_bps_rd_max: bool,
    pub bps_rd_max: i64,
    pub has_bps_wr_max: bool,
    pub bps_wr_max: i64,
    pub has_iops_max: bool,
    pub iops_max: i64,
    pub has_iops_rd_max: bool,
    pub iops_rd_max: i64,
    pub has_iops_wr_max: bool,
    pub iops_wr_max: i64,
    pub has_bps_max_length: bool,
    pub bps_max_length: i64,
    pub has_bps_rd_max_length: bool,
    pub bps_rd_max_length: i64,
    pub has_bps_wr_max_length: bool,
    pub bps_wr_max_length: i64,
    pub has_iops_max_length: bool,
    pub iops_max_length: i64,
    pub has_iops_rd_max_length: bool,
    pub iops_rd_max_length: i64,
    pub has_iops_wr_max_length: bool,
    pub iops_wr_max_length: i64,
    pub has_iops_size: bool,
    pub iops_size: i64,
    pub has_group: bool,
    pub group: *mut ::std::os::raw::c_char,
    pub cache: *mut BlockdevCacheInfo,
    pub write_threshold: i64,
}
extern "C" {
    pub fn qapi_free_BlockDeviceInfo(obj: *mut BlockDeviceInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDeviceInfoList {
    pub next: *mut BlockDeviceInfoList,
    pub value: *mut BlockDeviceInfo,
}
extern "C" {
    pub fn qapi_free_BlockDeviceInfoList(obj: *mut BlockDeviceInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDeviceMapEntry {
    pub start: i64,
    pub length: i64,
    pub depth: i64,
    pub zero: bool,
    pub data: bool,
    pub has_offset: bool,
    pub offset: i64,
}
extern "C" {
    pub fn qapi_free_BlockDeviceMapEntry(obj: *mut BlockDeviceMapEntry);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDeviceStats {
    pub rd_bytes: i64,
    pub wr_bytes: i64,
    pub rd_operations: i64,
    pub wr_operations: i64,
    pub flush_operations: i64,
    pub flush_total_time_ns: i64,
    pub wr_total_time_ns: i64,
    pub rd_total_time_ns: i64,
    pub wr_highest_offset: i64,
    pub rd_merged: i64,
    pub wr_merged: i64,
    pub has_idle_time_ns: bool,
    pub idle_time_ns: i64,
    pub failed_rd_operations: i64,
    pub failed_wr_operations: i64,
    pub failed_flush_operations: i64,
    pub invalid_rd_operations: i64,
    pub invalid_wr_operations: i64,
    pub invalid_flush_operations: i64,
    pub account_invalid: bool,
    pub account_failed: bool,
    pub timed_stats: *mut BlockDeviceTimedStatsList,
}
extern "C" {
    pub fn qapi_free_BlockDeviceStats(obj: *mut BlockDeviceStats);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDeviceTimedStats {
    pub interval_length: i64,
    pub min_rd_latency_ns: i64,
    pub max_rd_latency_ns: i64,
    pub avg_rd_latency_ns: i64,
    pub min_wr_latency_ns: i64,
    pub max_wr_latency_ns: i64,
    pub avg_wr_latency_ns: i64,
    pub min_flush_latency_ns: i64,
    pub max_flush_latency_ns: i64,
    pub avg_flush_latency_ns: i64,
    pub avg_rd_queue_depth: f64,
    pub avg_wr_queue_depth: f64,
}
extern "C" {
    pub fn qapi_free_BlockDeviceTimedStats(obj: *mut BlockDeviceTimedStats);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDeviceTimedStatsList {
    pub next: *mut BlockDeviceTimedStatsList,
    pub value: *mut BlockDeviceTimedStats,
}
extern "C" {
    pub fn qapi_free_BlockDeviceTimedStatsList(obj: *mut BlockDeviceTimedStatsList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDirtyBitmap {
    pub node: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_BlockDirtyBitmap(obj: *mut BlockDirtyBitmap);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDirtyBitmapAdd {
    pub node: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub has_granularity: bool,
    pub granularity: u32,
}
extern "C" {
    pub fn qapi_free_BlockDirtyBitmapAdd(obj: *mut BlockDirtyBitmapAdd);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDirtyInfo {
    pub has_name: bool,
    pub name: *mut ::std::os::raw::c_char,
    pub count: i64,
    pub granularity: u32,
    pub status: DirtyBitmapStatus,
}
extern "C" {
    pub fn qapi_free_BlockDirtyInfo(obj: *mut BlockDirtyInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockDirtyInfoList {
    pub next: *mut BlockDirtyInfoList,
    pub value: *mut BlockDirtyInfo,
}
extern "C" {
    pub fn qapi_free_BlockDirtyInfoList(obj: *mut BlockDirtyInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockIOThrottle {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub bps: i64,
    pub bps_rd: i64,
    pub bps_wr: i64,
    pub iops: i64,
    pub iops_rd: i64,
    pub iops_wr: i64,
    pub has_bps_max: bool,
    pub bps_max: i64,
    pub has_bps_rd_max: bool,
    pub bps_rd_max: i64,
    pub has_bps_wr_max: bool,
    pub bps_wr_max: i64,
    pub has_iops_max: bool,
    pub iops_max: i64,
    pub has_iops_rd_max: bool,
    pub iops_rd_max: i64,
    pub has_iops_wr_max: bool,
    pub iops_wr_max: i64,
    pub has_bps_max_length: bool,
    pub bps_max_length: i64,
    pub has_bps_rd_max_length: bool,
    pub bps_rd_max_length: i64,
    pub has_bps_wr_max_length: bool,
    pub bps_wr_max_length: i64,
    pub has_iops_max_length: bool,
    pub iops_max_length: i64,
    pub has_iops_rd_max_length: bool,
    pub iops_rd_max_length: i64,
    pub has_iops_wr_max_length: bool,
    pub iops_wr_max_length: i64,
    pub has_iops_size: bool,
    pub iops_size: i64,
    pub has_group: bool,
    pub group: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_BlockIOThrottle(obj: *mut BlockIOThrottle);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockInfo {
    pub device: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub removable: bool,
    pub locked: bool,
    pub has_inserted: bool,
    pub inserted: *mut BlockDeviceInfo,
    pub has_tray_open: bool,
    pub tray_open: bool,
    pub has_io_status: bool,
    pub io_status: BlockDeviceIoStatus,
    pub has_dirty_bitmaps: bool,
    pub dirty_bitmaps: *mut BlockDirtyInfoList,
}
extern "C" {
    pub fn qapi_free_BlockInfo(obj: *mut BlockInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockInfoList {
    pub next: *mut BlockInfoList,
    pub value: *mut BlockInfo,
}
extern "C" {
    pub fn qapi_free_BlockInfoList(obj: *mut BlockInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockJobInfo {
    pub type_: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub len: i64,
    pub offset: i64,
    pub busy: bool,
    pub paused: bool,
    pub speed: i64,
    pub io_status: BlockDeviceIoStatus,
    pub ready: bool,
}
extern "C" {
    pub fn qapi_free_BlockJobInfo(obj: *mut BlockJobInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockJobInfoList {
    pub next: *mut BlockJobInfoList,
    pub value: *mut BlockJobInfo,
}
extern "C" {
    pub fn qapi_free_BlockJobInfoList(obj: *mut BlockJobInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockStats {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub stats: *mut BlockDeviceStats,
    pub has_parent: bool,
    pub parent: *mut BlockStats,
    pub has_backing: bool,
    pub backing: *mut BlockStats,
}
extern "C" {
    pub fn qapi_free_BlockStats(obj: *mut BlockStats);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockStatsList {
    pub next: *mut BlockStatsList,
    pub value: *mut BlockStats,
}
extern "C" {
    pub fn qapi_free_BlockStatsList(obj: *mut BlockStatsList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevBackup {
    pub has_job_id: bool,
    pub job_id: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub target: *mut ::std::os::raw::c_char,
    pub sync: MirrorSyncMode,
    pub has_speed: bool,
    pub speed: i64,
    pub has_compress: bool,
    pub compress: bool,
    pub has_on_source_error: bool,
    pub on_source_error: BlockdevOnError,
    pub has_on_target_error: bool,
    pub on_target_error: BlockdevOnError,
}
extern "C" {
    pub fn qapi_free_BlockdevBackup(obj: *mut BlockdevBackup);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevCacheInfo {
    pub writeback: bool,
    pub direct: bool,
    pub no_flush: bool,
}
extern "C" {
    pub fn qapi_free_BlockdevCacheInfo(obj: *mut BlockdevCacheInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevCacheOptions {
    pub has_direct: bool,
    pub direct: bool,
    pub has_no_flush: bool,
    pub no_flush: bool,
}
extern "C" {
    pub fn qapi_free_BlockdevCacheOptions(obj: *mut BlockdevCacheOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsBlkdebug {
    pub image: *mut BlockdevRef,
    pub has_config: bool,
    pub config: *mut ::std::os::raw::c_char,
    pub has_align: bool,
    pub align: i64,
    pub has_max_transfer: bool,
    pub max_transfer: i32,
    pub has_opt_write_zero: bool,
    pub opt_write_zero: i32,
    pub has_max_write_zero: bool,
    pub max_write_zero: i32,
    pub has_opt_discard: bool,
    pub opt_discard: i32,
    pub has_max_discard: bool,
    pub max_discard: i32,
    pub has_inject_error: bool,
    pub inject_error: *mut BlkdebugInjectErrorOptionsList,
    pub has_set_state: bool,
    pub set_state: *mut BlkdebugSetStateOptionsList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsBlkverify {
    pub test: *mut BlockdevRef,
    pub raw: *mut BlockdevRef,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsGenericFormat {
    pub file: *mut BlockdevRef,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsFile {
    pub filename: *mut ::std::os::raw::c_char,
    pub has_aio: bool,
    pub aio: BlockdevAioOptions,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsCurlFtp {
    pub url: *mut ::std::os::raw::c_char,
    pub has_readahead: bool,
    pub readahead: i64,
    pub has_timeout: bool,
    pub timeout: i64,
    pub has_username: bool,
    pub username: *mut ::std::os::raw::c_char,
    pub has_password_secret: bool,
    pub password_secret: *mut ::std::os::raw::c_char,
    pub has_proxy_username: bool,
    pub proxy_username: *mut ::std::os::raw::c_char,
    pub has_proxy_password_secret: bool,
    pub proxy_password_secret: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsCurlFtps {
    pub url: *mut ::std::os::raw::c_char,
    pub has_readahead: bool,
    pub readahead: i64,
    pub has_timeout: bool,
    pub timeout: i64,
    pub has_username: bool,
    pub username: *mut ::std::os::raw::c_char,
    pub has_password_secret: bool,
    pub password_secret: *mut ::std::os::raw::c_char,
    pub has_proxy_username: bool,
    pub proxy_username: *mut ::std::os::raw::c_char,
    pub has_proxy_password_secret: bool,
    pub proxy_password_secret: *mut ::std::os::raw::c_char,
    pub has_sslverify: bool,
    pub sslverify: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsGluster {
    pub volume: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
    pub server: *mut SocketAddressFlatList,
    pub has_debug: bool,
    pub debug: i64,
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsCurlHttp {
    pub url: *mut ::std::os::raw::c_char,
    pub has_readahead: bool,
    pub readahead: i64,
    pub has_timeout: bool,
    pub timeout: i64,
    pub has_username: bool,
    pub username: *mut ::std::os::raw::c_char,
    pub has_password_secret: bool,
    pub password_secret: *mut ::std::os::raw::c_char,
    pub has_proxy_username: bool,
    pub proxy_username: *mut ::std::os::raw::c_char,
    pub has_proxy_password_secret: bool,
    pub proxy_password_secret: *mut ::std::os::raw::c_char,
    pub has_cookie: bool,
    pub cookie: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsCurlHttps {
    pub url: *mut ::std::os::raw::c_char,
    pub has_readahead: bool,
    pub readahead: i64,
    pub has_timeout: bool,
    pub timeout: i64,
    pub has_username: bool,
    pub username: *mut ::std::os::raw::c_char,
    pub has_password_secret: bool,
    pub password_secret: *mut ::std::os::raw::c_char,
    pub has_proxy_username: bool,
    pub proxy_username: *mut ::std::os::raw::c_char,
    pub has_proxy_password_secret: bool,
    pub proxy_password_secret: *mut ::std::os::raw::c_char,
    pub has_cookie: bool,
    pub cookie: *mut ::std::os::raw::c_char,
    pub has_sslverify: bool,
    pub sslverify: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsIscsi {
    pub transport: IscsiTransport,
    pub portal: *mut ::std::os::raw::c_char,
    pub target: *mut ::std::os::raw::c_char,
    pub has_lun: bool,
    pub lun: i64,
    pub has_user: bool,
    pub user: *mut ::std::os::raw::c_char,
    pub has_password_secret: bool,
    pub password_secret: *mut ::std::os::raw::c_char,
    pub has_initiator_name: bool,
    pub initiator_name: *mut ::std::os::raw::c_char,
    pub has_header_digest: bool,
    pub header_digest: IscsiHeaderDigest,
    pub has_timeout: bool,
    pub timeout: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsLUKS {
    pub file: *mut BlockdevRef,
    pub has_key_secret: bool,
    pub key_secret: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsNbd {
    pub server: *mut SocketAddressFlat,
    pub has_export: bool,
    pub export: *mut ::std::os::raw::c_char,
    pub has_tls_creds: bool,
    pub tls_creds: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsNfs {
    pub server: *mut NFSServer,
    pub path: *mut ::std::os::raw::c_char,
    pub has_user: bool,
    pub user: i64,
    pub has_group: bool,
    pub group: i64,
    pub has_tcp_syn_count: bool,
    pub tcp_syn_count: i64,
    pub has_readahead_size: bool,
    pub readahead_size: i64,
    pub has_page_cache_size: bool,
    pub page_cache_size: i64,
    pub has_debug: bool,
    pub debug: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsNull {
    pub has_size: bool,
    pub size: i64,
    pub has_latency_ns: bool,
    pub latency_ns: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsQcow2 {
    pub file: *mut BlockdevRef,
    pub has_backing: bool,
    pub backing: *mut BlockdevRef,
    pub has_lazy_refcounts: bool,
    pub lazy_refcounts: bool,
    pub has_pass_discard_request: bool,
    pub pass_discard_request: bool,
    pub has_pass_discard_snapshot: bool,
    pub pass_discard_snapshot: bool,
    pub has_pass_discard_other: bool,
    pub pass_discard_other: bool,
    pub has_overlap_check: bool,
    pub overlap_check: *mut Qcow2OverlapChecks,
    pub has_cache_size: bool,
    pub cache_size: i64,
    pub has_l2_cache_size: bool,
    pub l2_cache_size: i64,
    pub has_refcount_cache_size: bool,
    pub refcount_cache_size: i64,
    pub has_cache_clean_interval: bool,
    pub cache_clean_interval: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsGenericCOWFormat {
    pub file: *mut BlockdevRef,
    pub has_backing: bool,
    pub backing: *mut BlockdevRef,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsQuorum {
    pub has_blkverify: bool,
    pub blkverify: bool,
    pub children: *mut BlockdevRefList,
    pub vote_threshold: i64,
    pub has_rewrite_corrupted: bool,
    pub rewrite_corrupted: bool,
    pub has_read_pattern: bool,
    pub read_pattern: QuorumReadPattern,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsRaw {
    pub file: *mut BlockdevRef,
    pub has_offset: bool,
    pub offset: i64,
    pub has_size: bool,
    pub size: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsRbd {
    pub pool: *mut ::std::os::raw::c_char,
    pub image: *mut ::std::os::raw::c_char,
    pub has_conf: bool,
    pub conf: *mut ::std::os::raw::c_char,
    pub has_snapshot: bool,
    pub snapshot: *mut ::std::os::raw::c_char,
    pub has_user: bool,
    pub user: *mut ::std::os::raw::c_char,
    pub has_server: bool,
    pub server: *mut InetSocketAddressBaseList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsReplication {
    pub file: *mut BlockdevRef,
    pub mode: ReplicationMode,
    pub has_top_id: bool,
    pub top_id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsSheepdog {
    pub server: *mut SocketAddressFlat,
    pub vdi: *mut ::std::os::raw::c_char,
    pub has_snap_id: bool,
    pub snap_id: u32,
    pub has_tag: bool,
    pub tag: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsSsh {
    pub server: *mut InetSocketAddress,
    pub path: *mut ::std::os::raw::c_char,
    pub has_user: bool,
    pub user: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsVVFAT {
    pub dir: *mut ::std::os::raw::c_char,
    pub has_fat_type: bool,
    pub fat_type: i64,
    pub has_floppy: bool,
    pub floppy: bool,
    pub has_label: bool,
    pub label: *mut ::std::os::raw::c_char,
    pub has_rw: bool,
    pub rw: bool,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct BlockdevOptions {
    pub driver: BlockdevDriver,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub has_discard: bool,
    pub discard: BlockdevDiscardOptions,
    pub has_cache: bool,
    pub cache: *mut BlockdevCacheOptions,
    pub has_read_only: bool,
    pub read_only: bool,
    pub has_detect_zeroes: bool,
    pub detect_zeroes: BlockdevDetectZeroesOptions,
    pub u: BlockdevOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BlockdevOptions__bindgen_ty_1 {
    pub blkdebug: BlockdevOptionsBlkdebug,
    pub blkverify: BlockdevOptionsBlkverify,
    pub bochs: BlockdevOptionsGenericFormat,
    pub cloop: BlockdevOptionsGenericFormat,
    pub dmg: BlockdevOptionsGenericFormat,
    pub file: BlockdevOptionsFile,
    pub ftp: BlockdevOptionsCurlFtp,
    pub ftps: BlockdevOptionsCurlFtps,
    pub gluster: BlockdevOptionsGluster,
    pub host_cdrom: BlockdevOptionsFile,
    pub host_device: BlockdevOptionsFile,
    pub http: BlockdevOptionsCurlHttp,
    pub https: BlockdevOptionsCurlHttps,
    pub iscsi: BlockdevOptionsIscsi,
    pub luks: BlockdevOptionsLUKS,
    pub nbd: BlockdevOptionsNbd,
    pub nfs: BlockdevOptionsNfs,
    pub null_aio: BlockdevOptionsNull,
    pub null_co: BlockdevOptionsNull,
    pub parallels: BlockdevOptionsGenericFormat,
    pub qcow2: BlockdevOptionsQcow2,
    pub qcow: BlockdevOptionsGenericCOWFormat,
    pub qed: BlockdevOptionsGenericCOWFormat,
    pub quorum: BlockdevOptionsQuorum,
    pub raw: BlockdevOptionsRaw,
    pub rbd: BlockdevOptionsRbd,
    pub replication: BlockdevOptionsReplication,
    pub sheepdog: BlockdevOptionsSheepdog,
    pub ssh: BlockdevOptionsSsh,
    pub vdi: BlockdevOptionsGenericFormat,
    pub vhdx: BlockdevOptionsGenericFormat,
    pub vmdk: BlockdevOptionsGenericCOWFormat,
    pub vpc: BlockdevOptionsGenericFormat,
    pub vvfat: BlockdevOptionsVVFAT,
}
extern "C" {
    pub fn qapi_free_BlockdevOptions(obj: *mut BlockdevOptions);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsBlkdebug(obj: *mut BlockdevOptionsBlkdebug);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsBlkverify(obj: *mut BlockdevOptionsBlkverify);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevOptionsCurlBase {
    pub url: *mut ::std::os::raw::c_char,
    pub has_readahead: bool,
    pub readahead: i64,
    pub has_timeout: bool,
    pub timeout: i64,
    pub has_username: bool,
    pub username: *mut ::std::os::raw::c_char,
    pub has_password_secret: bool,
    pub password_secret: *mut ::std::os::raw::c_char,
    pub has_proxy_username: bool,
    pub proxy_username: *mut ::std::os::raw::c_char,
    pub has_proxy_password_secret: bool,
    pub proxy_password_secret: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsCurlBase(obj: *mut BlockdevOptionsCurlBase);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsCurlFtp(obj: *mut BlockdevOptionsCurlFtp);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsCurlFtps(obj: *mut BlockdevOptionsCurlFtps);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsCurlHttp(obj: *mut BlockdevOptionsCurlHttp);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsCurlHttps(obj: *mut BlockdevOptionsCurlHttps);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsFile(obj: *mut BlockdevOptionsFile);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsGenericCOWFormat(obj: *mut BlockdevOptionsGenericCOWFormat);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsGenericFormat(obj: *mut BlockdevOptionsGenericFormat);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsGluster(obj: *mut BlockdevOptionsGluster);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsIscsi(obj: *mut BlockdevOptionsIscsi);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsLUKS(obj: *mut BlockdevOptionsLUKS);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsNbd(obj: *mut BlockdevOptionsNbd);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsNfs(obj: *mut BlockdevOptionsNfs);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsNull(obj: *mut BlockdevOptionsNull);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsQcow2(obj: *mut BlockdevOptionsQcow2);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsQuorum(obj: *mut BlockdevOptionsQuorum);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsRaw(obj: *mut BlockdevOptionsRaw);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsRbd(obj: *mut BlockdevOptionsRbd);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsReplication(obj: *mut BlockdevOptionsReplication);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsSheepdog(obj: *mut BlockdevOptionsSheepdog);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsSsh(obj: *mut BlockdevOptionsSsh);
}
extern "C" {
    pub fn qapi_free_BlockdevOptionsVVFAT(obj: *mut BlockdevOptionsVVFAT);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct BlockdevRef {
    pub type_: QType,
    pub u: BlockdevRef__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BlockdevRef__bindgen_ty_1 {
    pub definition: BlockdevOptions,
    pub reference: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_BlockdevRef(obj: *mut BlockdevRef);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevRefList {
    pub next: *mut BlockdevRefList,
    pub value: *mut BlockdevRef,
}
extern "C" {
    pub fn qapi_free_BlockdevRefList(obj: *mut BlockdevRefList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevSnapshot {
    pub node: *mut ::std::os::raw::c_char,
    pub overlay: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_BlockdevSnapshot(obj: *mut BlockdevSnapshot);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevSnapshotInternal {
    pub device: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_BlockdevSnapshotInternal(obj: *mut BlockdevSnapshotInternal);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockdevSnapshotSync {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub snapshot_file: *mut ::std::os::raw::c_char,
    pub has_snapshot_node_name: bool,
    pub snapshot_node_name: *mut ::std::os::raw::c_char,
    pub has_format: bool,
    pub format: *mut ::std::os::raw::c_char,
    pub has_mode: bool,
    pub mode: NewImageMode,
}
extern "C" {
    pub fn qapi_free_BlockdevSnapshotSync(obj: *mut BlockdevSnapshotSync);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevFile_wrapper {
    pub data: *mut ChardevFile,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevHostdev_wrapper {
    pub data: *mut ChardevHostdev,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevSocket_wrapper {
    pub data: *mut ChardevSocket,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevUdp_wrapper {
    pub data: *mut ChardevUdp,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevCommon_wrapper {
    pub data: *mut ChardevCommon,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevMux_wrapper {
    pub data: *mut ChardevMux,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevStdio_wrapper {
    pub data: *mut ChardevStdio,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevSpiceChannel_wrapper {
    pub data: *mut ChardevSpiceChannel,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevSpicePort_wrapper {
    pub data: *mut ChardevSpicePort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevVC_wrapper {
    pub data: *mut ChardevVC,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ChardevRingbuf_wrapper {
    pub data: *mut ChardevRingbuf,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ChardevBackend {
    pub type_: ChardevBackendKind,
    pub u: ChardevBackend__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ChardevBackend__bindgen_ty_1 {
    pub file: q_obj_ChardevFile_wrapper,
    pub serial: q_obj_ChardevHostdev_wrapper,
    pub parallel: q_obj_ChardevHostdev_wrapper,
    pub pipe: q_obj_ChardevHostdev_wrapper,
    pub socket: q_obj_ChardevSocket_wrapper,
    pub udp: q_obj_ChardevUdp_wrapper,
    pub pty: q_obj_ChardevCommon_wrapper,
    pub null: q_obj_ChardevCommon_wrapper,
    pub mux: q_obj_ChardevMux_wrapper,
    pub msmouse: q_obj_ChardevCommon_wrapper,
    pub wctablet: q_obj_ChardevCommon_wrapper,
    pub braille: q_obj_ChardevCommon_wrapper,
    pub testdev: q_obj_ChardevCommon_wrapper,
    pub stdio: q_obj_ChardevStdio_wrapper,
    pub console: q_obj_ChardevCommon_wrapper,
    pub spicevmc: q_obj_ChardevSpiceChannel_wrapper,
    pub spiceport: q_obj_ChardevSpicePort_wrapper,
    pub vc: q_obj_ChardevVC_wrapper,
    pub ringbuf: q_obj_ChardevRingbuf_wrapper,
    pub memory: q_obj_ChardevRingbuf_wrapper,
}
extern "C" {
    pub fn qapi_free_ChardevBackend(obj: *mut ChardevBackend);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevBackendInfo {
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ChardevBackendInfo(obj: *mut ChardevBackendInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevBackendInfoList {
    pub next: *mut ChardevBackendInfoList,
    pub value: *mut ChardevBackendInfo,
}
extern "C" {
    pub fn qapi_free_ChardevBackendInfoList(obj: *mut ChardevBackendInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevCommon {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
}
extern "C" {
    pub fn qapi_free_ChardevCommon(obj: *mut ChardevCommon);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevFile {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub has_in: bool,
    pub in_: *mut ::std::os::raw::c_char,
    pub out: *mut ::std::os::raw::c_char,
    pub has_append: bool,
    pub append: bool,
}
extern "C" {
    pub fn qapi_free_ChardevFile(obj: *mut ChardevFile);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevHostdev {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub device: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ChardevHostdev(obj: *mut ChardevHostdev);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevInfo {
    pub label: *mut ::std::os::raw::c_char,
    pub filename: *mut ::std::os::raw::c_char,
    pub frontend_open: bool,
}
extern "C" {
    pub fn qapi_free_ChardevInfo(obj: *mut ChardevInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevInfoList {
    pub next: *mut ChardevInfoList,
    pub value: *mut ChardevInfo,
}
extern "C" {
    pub fn qapi_free_ChardevInfoList(obj: *mut ChardevInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevMux {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub chardev: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ChardevMux(obj: *mut ChardevMux);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevReturn {
    pub has_pty: bool,
    pub pty: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ChardevReturn(obj: *mut ChardevReturn);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevRingbuf {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub has_size: bool,
    pub size: i64,
}
extern "C" {
    pub fn qapi_free_ChardevRingbuf(obj: *mut ChardevRingbuf);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevSocket {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub addr: *mut SocketAddress,
    pub has_tls_creds: bool,
    pub tls_creds: *mut ::std::os::raw::c_char,
    pub has_server: bool,
    pub server: bool,
    pub has_wait: bool,
    pub wait: bool,
    pub has_nodelay: bool,
    pub nodelay: bool,
    pub has_telnet: bool,
    pub telnet: bool,
    pub has_reconnect: bool,
    pub reconnect: i64,
}
extern "C" {
    pub fn qapi_free_ChardevSocket(obj: *mut ChardevSocket);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevSpiceChannel {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub type_: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ChardevSpiceChannel(obj: *mut ChardevSpiceChannel);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevSpicePort {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub fqdn: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ChardevSpicePort(obj: *mut ChardevSpicePort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevStdio {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub has_signal: bool,
    pub signal: bool,
}
extern "C" {
    pub fn qapi_free_ChardevStdio(obj: *mut ChardevStdio);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevUdp {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub remote: *mut SocketAddress,
    pub has_local: bool,
    pub local: *mut SocketAddress,
}
extern "C" {
    pub fn qapi_free_ChardevUdp(obj: *mut ChardevUdp);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChardevVC {
    pub has_logfile: bool,
    pub logfile: *mut ::std::os::raw::c_char,
    pub has_logappend: bool,
    pub logappend: bool,
    pub has_width: bool,
    pub width: i64,
    pub has_height: bool,
    pub height: i64,
    pub has_cols: bool,
    pub cols: i64,
    pub has_rows: bool,
    pub rows: i64,
}
extern "C" {
    pub fn qapi_free_ChardevVC(obj: *mut ChardevVC);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommandInfo {
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_CommandInfo(obj: *mut CommandInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommandInfoList {
    pub next: *mut CommandInfoList,
    pub value: *mut CommandInfo,
}
extern "C" {
    pub fn qapi_free_CommandInfoList(obj: *mut CommandInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommandLineOptionInfo {
    pub option: *mut ::std::os::raw::c_char,
    pub parameters: *mut CommandLineParameterInfoList,
}
extern "C" {
    pub fn qapi_free_CommandLineOptionInfo(obj: *mut CommandLineOptionInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommandLineOptionInfoList {
    pub next: *mut CommandLineOptionInfoList,
    pub value: *mut CommandLineOptionInfo,
}
extern "C" {
    pub fn qapi_free_CommandLineOptionInfoList(obj: *mut CommandLineOptionInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommandLineParameterInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: CommandLineParameterType,
    pub has_help: bool,
    pub help: *mut ::std::os::raw::c_char,
    pub has_q_default: bool,
    pub q_default: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_CommandLineParameterInfo(obj: *mut CommandLineParameterInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommandLineParameterInfoList {
    pub next: *mut CommandLineParameterInfoList,
    pub value: *mut CommandLineParameterInfo,
}
extern "C" {
    pub fn qapi_free_CommandLineParameterInfoList(obj: *mut CommandLineParameterInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuDefinitionInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub has_migration_safe: bool,
    pub migration_safe: bool,
    pub q_static: bool,
    pub has_unavailable_features: bool,
    pub unavailable_features: *mut strList,
    pub q_typename: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_CpuDefinitionInfo(obj: *mut CpuDefinitionInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuDefinitionInfoList {
    pub next: *mut CpuDefinitionInfoList,
    pub value: *mut CpuDefinitionInfo,
}
extern "C" {
    pub fn qapi_free_CpuDefinitionInfoList(obj: *mut CpuDefinitionInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoX86 {
    pub pc: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoSPARC {
    pub pc: i64,
    pub npc: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoPPC {
    pub nip: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoMIPS {
    pub PC: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoTricore {
    pub PC: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoOther {
    pub qapi_dummy_for_empty_struct: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CpuInfo {
    pub CPU: i64,
    pub current: bool,
    pub halted: bool,
    pub qom_path: *mut ::std::os::raw::c_char,
    pub thread_id: i64,
    pub arch: CpuInfoArch,
    pub u: CpuInfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CpuInfo__bindgen_ty_1 {
    pub x86: CpuInfoX86,
    pub q_sparc: CpuInfoSPARC,
    pub ppc: CpuInfoPPC,
    pub q_mips: CpuInfoMIPS,
    pub tricore: CpuInfoTricore,
    pub other: CpuInfoOther,
}
extern "C" {
    pub fn qapi_free_CpuInfo(obj: *mut CpuInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInfoList {
    pub next: *mut CpuInfoList,
    pub value: *mut CpuInfo,
}
extern "C" {
    pub fn qapi_free_CpuInfoList(obj: *mut CpuInfoList);
}
extern "C" {
    pub fn qapi_free_CpuInfoMIPS(obj: *mut CpuInfoMIPS);
}
extern "C" {
    pub fn qapi_free_CpuInfoOther(obj: *mut CpuInfoOther);
}
extern "C" {
    pub fn qapi_free_CpuInfoPPC(obj: *mut CpuInfoPPC);
}
extern "C" {
    pub fn qapi_free_CpuInfoSPARC(obj: *mut CpuInfoSPARC);
}
extern "C" {
    pub fn qapi_free_CpuInfoTricore(obj: *mut CpuInfoTricore);
}
extern "C" {
    pub fn qapi_free_CpuInfoX86(obj: *mut CpuInfoX86);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuInstanceProperties {
    pub has_node_id: bool,
    pub node_id: i64,
    pub has_socket_id: bool,
    pub socket_id: i64,
    pub has_core_id: bool,
    pub core_id: i64,
    pub has_thread_id: bool,
    pub thread_id: i64,
}
extern "C" {
    pub fn qapi_free_CpuInstanceProperties(obj: *mut CpuInstanceProperties);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuModelBaselineInfo {
    pub model: *mut CpuModelInfo,
}
extern "C" {
    pub fn qapi_free_CpuModelBaselineInfo(obj: *mut CpuModelBaselineInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuModelCompareInfo {
    pub result: CpuModelCompareResult,
    pub responsible_properties: *mut strList,
}
extern "C" {
    pub fn qapi_free_CpuModelCompareInfo(obj: *mut CpuModelCompareInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuModelExpansionInfo {
    pub model: *mut CpuModelInfo,
}
extern "C" {
    pub fn qapi_free_CpuModelExpansionInfo(obj: *mut CpuModelExpansionInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CpuModelInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub has_props: bool,
    pub props: *mut QObject,
}
extern "C" {
    pub fn qapi_free_CpuModelInfo(obj: *mut CpuModelInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DevicePropertyInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub has_description: bool,
    pub description: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_DevicePropertyInfo(obj: *mut DevicePropertyInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DevicePropertyInfoList {
    pub next: *mut DevicePropertyInfoList,
    pub value: *mut DevicePropertyInfo,
}
extern "C" {
    pub fn qapi_free_DevicePropertyInfoList(obj: *mut DevicePropertyInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriveBackup {
    pub has_job_id: bool,
    pub job_id: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub target: *mut ::std::os::raw::c_char,
    pub has_format: bool,
    pub format: *mut ::std::os::raw::c_char,
    pub sync: MirrorSyncMode,
    pub has_mode: bool,
    pub mode: NewImageMode,
    pub has_speed: bool,
    pub speed: i64,
    pub has_bitmap: bool,
    pub bitmap: *mut ::std::os::raw::c_char,
    pub has_compress: bool,
    pub compress: bool,
    pub has_on_source_error: bool,
    pub on_source_error: BlockdevOnError,
    pub has_on_target_error: bool,
    pub on_target_error: BlockdevOnError,
}
extern "C" {
    pub fn qapi_free_DriveBackup(obj: *mut DriveBackup);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriveMirror {
    pub has_job_id: bool,
    pub job_id: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub target: *mut ::std::os::raw::c_char,
    pub has_format: bool,
    pub format: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub has_replaces: bool,
    pub replaces: *mut ::std::os::raw::c_char,
    pub sync: MirrorSyncMode,
    pub has_mode: bool,
    pub mode: NewImageMode,
    pub has_speed: bool,
    pub speed: i64,
    pub has_granularity: bool,
    pub granularity: u32,
    pub has_buf_size: bool,
    pub buf_size: i64,
    pub has_on_source_error: bool,
    pub on_source_error: BlockdevOnError,
    pub has_on_target_error: bool,
    pub on_target_error: BlockdevOnError,
    pub has_unmap: bool,
    pub unmap: bool,
}
extern "C" {
    pub fn qapi_free_DriveMirror(obj: *mut DriveMirror);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DummyForceArrays {
    pub unused: *mut X86CPUFeatureWordInfoList,
}
extern "C" {
    pub fn qapi_free_DummyForceArrays(obj: *mut DummyForceArrays);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DumpGuestMemoryCapability {
    pub formats: *mut DumpGuestMemoryFormatList,
}
extern "C" {
    pub fn qapi_free_DumpGuestMemoryCapability(obj: *mut DumpGuestMemoryCapability);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DumpGuestMemoryFormatList {
    pub next: *mut DumpGuestMemoryFormatList,
    pub value: DumpGuestMemoryFormat,
}
extern "C" {
    pub fn qapi_free_DumpGuestMemoryFormatList(obj: *mut DumpGuestMemoryFormatList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DumpQueryResult {
    pub status: DumpStatus,
    pub completed: i64,
    pub total: i64,
}
extern "C" {
    pub fn qapi_free_DumpQueryResult(obj: *mut DumpQueryResult);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EventInfo {
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_EventInfo(obj: *mut EventInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EventInfoList {
    pub next: *mut EventInfoList,
    pub value: *mut EventInfo,
}
extern "C" {
    pub fn qapi_free_EventInfoList(obj: *mut EventInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FdsetFdInfo {
    pub fd: i64,
    pub has_opaque: bool,
    pub opaque: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_FdsetFdInfo(obj: *mut FdsetFdInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FdsetFdInfoList {
    pub next: *mut FdsetFdInfoList,
    pub value: *mut FdsetFdInfo,
}
extern "C" {
    pub fn qapi_free_FdsetFdInfoList(obj: *mut FdsetFdInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FdsetInfo {
    pub fdset_id: i64,
    pub fds: *mut FdsetFdInfoList,
}
extern "C" {
    pub fn qapi_free_FdsetInfo(obj: *mut FdsetInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FdsetInfoList {
    pub next: *mut FdsetInfoList,
    pub value: *mut FdsetInfo,
}
extern "C" {
    pub fn qapi_free_FdsetInfoList(obj: *mut FdsetInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GICCapability {
    pub version: i64,
    pub emulated: bool,
    pub kernel: bool,
}
extern "C" {
    pub fn qapi_free_GICCapability(obj: *mut GICCapability);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GICCapabilityList {
    pub next: *mut GICCapabilityList,
    pub value: *mut GICCapability,
}
extern "C" {
    pub fn qapi_free_GICCapabilityList(obj: *mut GICCapabilityList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GuestPanicInformationHyperV {
    pub arg1: u64,
    pub arg2: u64,
    pub arg3: u64,
    pub arg4: u64,
    pub arg5: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GuestPanicInformation {
    pub type_: GuestPanicInformationType,
    pub u: GuestPanicInformation__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union GuestPanicInformation__bindgen_ty_1 {
    pub hyper_v: GuestPanicInformationHyperV,
}
extern "C" {
    pub fn qapi_free_GuestPanicInformation(obj: *mut GuestPanicInformation);
}
extern "C" {
    pub fn qapi_free_GuestPanicInformationHyperV(obj: *mut GuestPanicInformationHyperV);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GuidInfo {
    pub guid: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_GuidInfo(obj: *mut GuidInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HotpluggableCPU {
    pub type_: *mut ::std::os::raw::c_char,
    pub vcpus_count: i64,
    pub props: *mut CpuInstanceProperties,
    pub has_qom_path: bool,
    pub qom_path: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_HotpluggableCPU(obj: *mut HotpluggableCPU);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HotpluggableCPUList {
    pub next: *mut HotpluggableCPUList,
    pub value: *mut HotpluggableCPU,
}
extern "C" {
    pub fn qapi_free_HotpluggableCPUList(obj: *mut HotpluggableCPUList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IOThreadInfo {
    pub id: *mut ::std::os::raw::c_char,
    pub thread_id: i64,
    pub poll_max_ns: i64,
    pub poll_grow: i64,
    pub poll_shrink: i64,
}
extern "C" {
    pub fn qapi_free_IOThreadInfo(obj: *mut IOThreadInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IOThreadInfoList {
    pub next: *mut IOThreadInfoList,
    pub value: *mut IOThreadInfo,
}
extern "C" {
    pub fn qapi_free_IOThreadInfoList(obj: *mut IOThreadInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImageCheck {
    pub filename: *mut ::std::os::raw::c_char,
    pub format: *mut ::std::os::raw::c_char,
    pub check_errors: i64,
    pub has_image_end_offset: bool,
    pub image_end_offset: i64,
    pub has_corruptions: bool,
    pub corruptions: i64,
    pub has_leaks: bool,
    pub leaks: i64,
    pub has_corruptions_fixed: bool,
    pub corruptions_fixed: i64,
    pub has_leaks_fixed: bool,
    pub leaks_fixed: i64,
    pub has_total_clusters: bool,
    pub total_clusters: i64,
    pub has_allocated_clusters: bool,
    pub allocated_clusters: i64,
    pub has_fragmented_clusters: bool,
    pub fragmented_clusters: i64,
    pub has_compressed_clusters: bool,
    pub compressed_clusters: i64,
}
extern "C" {
    pub fn qapi_free_ImageCheck(obj: *mut ImageCheck);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImageInfo {
    pub filename: *mut ::std::os::raw::c_char,
    pub format: *mut ::std::os::raw::c_char,
    pub has_dirty_flag: bool,
    pub dirty_flag: bool,
    pub has_actual_size: bool,
    pub actual_size: i64,
    pub virtual_size: i64,
    pub has_cluster_size: bool,
    pub cluster_size: i64,
    pub has_encrypted: bool,
    pub encrypted: bool,
    pub has_compressed: bool,
    pub compressed: bool,
    pub has_backing_filename: bool,
    pub backing_filename: *mut ::std::os::raw::c_char,
    pub has_full_backing_filename: bool,
    pub full_backing_filename: *mut ::std::os::raw::c_char,
    pub has_backing_filename_format: bool,
    pub backing_filename_format: *mut ::std::os::raw::c_char,
    pub has_snapshots: bool,
    pub snapshots: *mut SnapshotInfoList,
    pub has_backing_image: bool,
    pub backing_image: *mut ImageInfo,
    pub has_format_specific: bool,
    pub format_specific: *mut ImageInfoSpecific,
}
extern "C" {
    pub fn qapi_free_ImageInfo(obj: *mut ImageInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImageInfoList {
    pub next: *mut ImageInfoList,
    pub value: *mut ImageInfo,
}
extern "C" {
    pub fn qapi_free_ImageInfoList(obj: *mut ImageInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ImageInfoSpecificQCow2_wrapper {
    pub data: *mut ImageInfoSpecificQCow2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ImageInfoSpecificVmdk_wrapper {
    pub data: *mut ImageInfoSpecificVmdk,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_QCryptoBlockInfoLUKS_wrapper {
    pub data: *mut QCryptoBlockInfoLUKS,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImageInfoSpecific {
    pub type_: ImageInfoSpecificKind,
    pub u: ImageInfoSpecific__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ImageInfoSpecific__bindgen_ty_1 {
    pub qcow2: q_obj_ImageInfoSpecificQCow2_wrapper,
    pub vmdk: q_obj_ImageInfoSpecificVmdk_wrapper,
    pub luks: q_obj_QCryptoBlockInfoLUKS_wrapper,
}
extern "C" {
    pub fn qapi_free_ImageInfoSpecific(obj: *mut ImageInfoSpecific);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImageInfoSpecificQCow2 {
    pub compat: *mut ::std::os::raw::c_char,
    pub has_lazy_refcounts: bool,
    pub lazy_refcounts: bool,
    pub has_corrupt: bool,
    pub corrupt: bool,
    pub refcount_bits: i64,
}
extern "C" {
    pub fn qapi_free_ImageInfoSpecificQCow2(obj: *mut ImageInfoSpecificQCow2);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImageInfoSpecificVmdk {
    pub create_type: *mut ::std::os::raw::c_char,
    pub cid: i64,
    pub parent_cid: i64,
    pub extents: *mut ImageInfoList,
}
extern "C" {
    pub fn qapi_free_ImageInfoSpecificVmdk(obj: *mut ImageInfoSpecificVmdk);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InetSocketAddress {
    pub host: *mut ::std::os::raw::c_char,
    pub port: *mut ::std::os::raw::c_char,
    pub has_numeric: bool,
    pub numeric: bool,
    pub has_to: bool,
    pub to: u16,
    pub has_ipv4: bool,
    pub ipv4: bool,
    pub has_ipv6: bool,
    pub ipv6: bool,
}
extern "C" {
    pub fn qapi_free_InetSocketAddress(obj: *mut InetSocketAddress);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InetSocketAddressBase {
    pub host: *mut ::std::os::raw::c_char,
    pub port: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_InetSocketAddressBase(obj: *mut InetSocketAddressBase);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InetSocketAddressBaseList {
    pub next: *mut InetSocketAddressBaseList,
    pub value: *mut InetSocketAddressBase,
}
extern "C" {
    pub fn qapi_free_InetSocketAddressBaseList(obj: *mut InetSocketAddressBaseList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InputBtnEvent {
    pub button: InputButton,
    pub down: bool,
}
extern "C" {
    pub fn qapi_free_InputBtnEvent(obj: *mut InputBtnEvent);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_InputKeyEvent_wrapper {
    pub data: *mut InputKeyEvent,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_InputBtnEvent_wrapper {
    pub data: *mut InputBtnEvent,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_InputMoveEvent_wrapper {
    pub data: *mut InputMoveEvent,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct InputEvent {
    pub type_: InputEventKind,
    pub u: InputEvent__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union InputEvent__bindgen_ty_1 {
    pub key: q_obj_InputKeyEvent_wrapper,
    pub btn: q_obj_InputBtnEvent_wrapper,
    pub rel: q_obj_InputMoveEvent_wrapper,
    pub abs: q_obj_InputMoveEvent_wrapper,
}
extern "C" {
    pub fn qapi_free_InputEvent(obj: *mut InputEvent);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InputEventList {
    pub next: *mut InputEventList,
    pub value: *mut InputEvent,
}
extern "C" {
    pub fn qapi_free_InputEventList(obj: *mut InputEventList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InputKeyEvent {
    pub key: *mut KeyValue,
    pub down: bool,
}
extern "C" {
    pub fn qapi_free_InputKeyEvent(obj: *mut InputKeyEvent);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InputMoveEvent {
    pub axis: InputAxis,
    pub value: i64,
}
extern "C" {
    pub fn qapi_free_InputMoveEvent(obj: *mut InputMoveEvent);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_int_wrapper {
    pub data: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_QKeyCode_wrapper {
    pub data: QKeyCode,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct KeyValue {
    pub type_: KeyValueKind,
    pub u: KeyValue__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union KeyValue__bindgen_ty_1 {
    pub number: q_obj_int_wrapper,
    pub qcode: q_obj_QKeyCode_wrapper,
}
extern "C" {
    pub fn qapi_free_KeyValue(obj: *mut KeyValue);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct KeyValueList {
    pub next: *mut KeyValueList,
    pub value: *mut KeyValue,
}
extern "C" {
    pub fn qapi_free_KeyValueList(obj: *mut KeyValueList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct KvmInfo {
    pub enabled: bool,
    pub present: bool,
}
extern "C" {
    pub fn qapi_free_KvmInfo(obj: *mut KvmInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MachineInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub has_alias: bool,
    pub alias: *mut ::std::os::raw::c_char,
    pub has_is_default: bool,
    pub is_default: bool,
    pub cpu_max: i64,
    pub hotpluggable_cpus: bool,
}
extern "C" {
    pub fn qapi_free_MachineInfo(obj: *mut MachineInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MachineInfoList {
    pub next: *mut MachineInfoList,
    pub value: *mut MachineInfo,
}
extern "C" {
    pub fn qapi_free_MachineInfoList(obj: *mut MachineInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MapEntry {
    pub start: i64,
    pub length: i64,
    pub data: bool,
    pub zero: bool,
    pub depth: i64,
    pub has_offset: bool,
    pub offset: i64,
    pub has_filename: bool,
    pub filename: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_MapEntry(obj: *mut MapEntry);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Memdev {
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub size: u64,
    pub merge: bool,
    pub dump: bool,
    pub prealloc: bool,
    pub host_nodes: *mut uint16List,
    pub policy: HostMemPolicy,
}
extern "C" {
    pub fn qapi_free_Memdev(obj: *mut Memdev);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemdevList {
    pub next: *mut MemdevList,
    pub value: *mut Memdev,
}
extern "C" {
    pub fn qapi_free_MemdevList(obj: *mut MemdevList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_PCDIMMDeviceInfo_wrapper {
    pub data: *mut PCDIMMDeviceInfo,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct MemoryDeviceInfo {
    pub type_: MemoryDeviceInfoKind,
    pub u: MemoryDeviceInfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union MemoryDeviceInfo__bindgen_ty_1 {
    pub dimm: q_obj_PCDIMMDeviceInfo_wrapper,
}
extern "C" {
    pub fn qapi_free_MemoryDeviceInfo(obj: *mut MemoryDeviceInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryDeviceInfoList {
    pub next: *mut MemoryDeviceInfoList,
    pub value: *mut MemoryDeviceInfo,
}
extern "C" {
    pub fn qapi_free_MemoryDeviceInfoList(obj: *mut MemoryDeviceInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationCapabilityStatus {
    pub capability: MigrationCapability,
    pub state: bool,
}
extern "C" {
    pub fn qapi_free_MigrationCapabilityStatus(obj: *mut MigrationCapabilityStatus);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationCapabilityStatusList {
    pub next: *mut MigrationCapabilityStatusList,
    pub value: *mut MigrationCapabilityStatus,
}
extern "C" {
    pub fn qapi_free_MigrationCapabilityStatusList(obj: *mut MigrationCapabilityStatusList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationInfo {
    pub has_status: bool,
    pub status: MigrationStatus,
    pub has_ram: bool,
    pub ram: *mut MigrationStats,
    pub has_disk: bool,
    pub disk: *mut MigrationStats,
    pub has_xbzrle_cache: bool,
    pub xbzrle_cache: *mut XBZRLECacheStats,
    pub has_total_time: bool,
    pub total_time: i64,
    pub has_expected_downtime: bool,
    pub expected_downtime: i64,
    pub has_downtime: bool,
    pub downtime: i64,
    pub has_setup_time: bool,
    pub setup_time: i64,
    pub has_cpu_throttle_percentage: bool,
    pub cpu_throttle_percentage: i64,
    pub has_error_desc: bool,
    pub error_desc: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_MigrationInfo(obj: *mut MigrationInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationParameters {
    pub has_compress_level: bool,
    pub compress_level: i64,
    pub has_compress_threads: bool,
    pub compress_threads: i64,
    pub has_decompress_threads: bool,
    pub decompress_threads: i64,
    pub has_cpu_throttle_initial: bool,
    pub cpu_throttle_initial: i64,
    pub has_cpu_throttle_increment: bool,
    pub cpu_throttle_increment: i64,
    pub has_tls_creds: bool,
    pub tls_creds: *mut ::std::os::raw::c_char,
    pub has_tls_hostname: bool,
    pub tls_hostname: *mut ::std::os::raw::c_char,
    pub has_max_bandwidth: bool,
    pub max_bandwidth: i64,
    pub has_downtime_limit: bool,
    pub downtime_limit: i64,
    pub has_x_checkpoint_delay: bool,
    pub x_checkpoint_delay: i64,
}
extern "C" {
    pub fn qapi_free_MigrationParameters(obj: *mut MigrationParameters);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MigrationStats {
    pub transferred: i64,
    pub remaining: i64,
    pub total: i64,
    pub duplicate: i64,
    pub skipped: i64,
    pub normal: i64,
    pub normal_bytes: i64,
    pub dirty_pages_rate: i64,
    pub mbps: f64,
    pub dirty_sync_count: i64,
    pub postcopy_requests: i64,
}
extern "C" {
    pub fn qapi_free_MigrationStats(obj: *mut MigrationStats);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MouseInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub index: i64,
    pub current: bool,
    pub absolute: bool,
}
extern "C" {
    pub fn qapi_free_MouseInfo(obj: *mut MouseInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MouseInfoList {
    pub next: *mut MouseInfoList,
    pub value: *mut MouseInfo,
}
extern "C" {
    pub fn qapi_free_MouseInfoList(obj: *mut MouseInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NFSServer {
    pub type_: NFSTransport,
    pub host: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_NFSServer(obj: *mut NFSServer);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NameInfo {
    pub has_name: bool,
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_NameInfo(obj: *mut NameInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetLegacy {
    pub has_vlan: bool,
    pub vlan: i32,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub has_name: bool,
    pub name: *mut ::std::os::raw::c_char,
    pub opts: *mut NetLegacyOptions,
}
extern "C" {
    pub fn qapi_free_NetLegacy(obj: *mut NetLegacy);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetLegacyNicOptions {
    pub has_netdev: bool,
    pub netdev: *mut ::std::os::raw::c_char,
    pub has_macaddr: bool,
    pub macaddr: *mut ::std::os::raw::c_char,
    pub has_model: bool,
    pub model: *mut ::std::os::raw::c_char,
    pub has_addr: bool,
    pub addr: *mut ::std::os::raw::c_char,
    pub has_vectors: bool,
    pub vectors: u32,
}
extern "C" {
    pub fn qapi_free_NetLegacyNicOptions(obj: *mut NetLegacyNicOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevNoneOptions {
    pub qapi_dummy_for_empty_struct: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevUserOptions {
    pub has_hostname: bool,
    pub hostname: *mut ::std::os::raw::c_char,
    pub has_q_restrict: bool,
    pub q_restrict: bool,
    pub has_ipv4: bool,
    pub ipv4: bool,
    pub has_ipv6: bool,
    pub ipv6: bool,
    pub has_ip: bool,
    pub ip: *mut ::std::os::raw::c_char,
    pub has_net: bool,
    pub net: *mut ::std::os::raw::c_char,
    pub has_host: bool,
    pub host: *mut ::std::os::raw::c_char,
    pub has_tftp: bool,
    pub tftp: *mut ::std::os::raw::c_char,
    pub has_bootfile: bool,
    pub bootfile: *mut ::std::os::raw::c_char,
    pub has_dhcpstart: bool,
    pub dhcpstart: *mut ::std::os::raw::c_char,
    pub has_dns: bool,
    pub dns: *mut ::std::os::raw::c_char,
    pub has_dnssearch: bool,
    pub dnssearch: *mut StringList,
    pub has_ipv6_prefix: bool,
    pub ipv6_prefix: *mut ::std::os::raw::c_char,
    pub has_ipv6_prefixlen: bool,
    pub ipv6_prefixlen: i64,
    pub has_ipv6_host: bool,
    pub ipv6_host: *mut ::std::os::raw::c_char,
    pub has_ipv6_dns: bool,
    pub ipv6_dns: *mut ::std::os::raw::c_char,
    pub has_smb: bool,
    pub smb: *mut ::std::os::raw::c_char,
    pub has_smbserver: bool,
    pub smbserver: *mut ::std::os::raw::c_char,
    pub has_hostfwd: bool,
    pub hostfwd: *mut StringList,
    pub has_guestfwd: bool,
    pub guestfwd: *mut StringList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevTapOptions {
    pub has_ifname: bool,
    pub ifname: *mut ::std::os::raw::c_char,
    pub has_fd: bool,
    pub fd: *mut ::std::os::raw::c_char,
    pub has_fds: bool,
    pub fds: *mut ::std::os::raw::c_char,
    pub has_script: bool,
    pub script: *mut ::std::os::raw::c_char,
    pub has_downscript: bool,
    pub downscript: *mut ::std::os::raw::c_char,
    pub has_br: bool,
    pub br: *mut ::std::os::raw::c_char,
    pub has_helper: bool,
    pub helper: *mut ::std::os::raw::c_char,
    pub has_sndbuf: bool,
    pub sndbuf: u64,
    pub has_vnet_hdr: bool,
    pub vnet_hdr: bool,
    pub has_vhost: bool,
    pub vhost: bool,
    pub has_vhostfd: bool,
    pub vhostfd: *mut ::std::os::raw::c_char,
    pub has_vhostfds: bool,
    pub vhostfds: *mut ::std::os::raw::c_char,
    pub has_vhostforce: bool,
    pub vhostforce: bool,
    pub has_queues: bool,
    pub queues: u32,
    pub has_poll_us: bool,
    pub poll_us: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevL2TPv3Options {
    pub src: *mut ::std::os::raw::c_char,
    pub dst: *mut ::std::os::raw::c_char,
    pub has_srcport: bool,
    pub srcport: *mut ::std::os::raw::c_char,
    pub has_dstport: bool,
    pub dstport: *mut ::std::os::raw::c_char,
    pub has_ipv6: bool,
    pub ipv6: bool,
    pub has_udp: bool,
    pub udp: bool,
    pub has_cookie64: bool,
    pub cookie64: bool,
    pub has_counter: bool,
    pub counter: bool,
    pub has_pincounter: bool,
    pub pincounter: bool,
    pub has_txcookie: bool,
    pub txcookie: u64,
    pub has_rxcookie: bool,
    pub rxcookie: u64,
    pub txsession: u32,
    pub has_rxsession: bool,
    pub rxsession: u32,
    pub has_offset: bool,
    pub offset: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevSocketOptions {
    pub has_fd: bool,
    pub fd: *mut ::std::os::raw::c_char,
    pub has_listen: bool,
    pub listen: *mut ::std::os::raw::c_char,
    pub has_connect: bool,
    pub connect: *mut ::std::os::raw::c_char,
    pub has_mcast: bool,
    pub mcast: *mut ::std::os::raw::c_char,
    pub has_localaddr: bool,
    pub localaddr: *mut ::std::os::raw::c_char,
    pub has_udp: bool,
    pub udp: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevVdeOptions {
    pub has_sock: bool,
    pub sock: *mut ::std::os::raw::c_char,
    pub has_port: bool,
    pub port: u16,
    pub has_group: bool,
    pub group: *mut ::std::os::raw::c_char,
    pub has_mode: bool,
    pub mode: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevDumpOptions {
    pub has_len: bool,
    pub len: u64,
    pub has_file: bool,
    pub file: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevBridgeOptions {
    pub has_br: bool,
    pub br: *mut ::std::os::raw::c_char,
    pub has_helper: bool,
    pub helper: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevNetmapOptions {
    pub ifname: *mut ::std::os::raw::c_char,
    pub has_devname: bool,
    pub devname: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevVhostUserOptions {
    pub chardev: *mut ::std::os::raw::c_char,
    pub has_vhostforce: bool,
    pub vhostforce: bool,
    pub has_queues: bool,
    pub queues: i64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct NetLegacyOptions {
    pub type_: NetLegacyOptionsType,
    pub u: NetLegacyOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union NetLegacyOptions__bindgen_ty_1 {
    pub none: NetdevNoneOptions,
    pub nic: NetLegacyNicOptions,
    pub user: NetdevUserOptions,
    pub tap: NetdevTapOptions,
    pub l2tpv3: NetdevL2TPv3Options,
    pub socket: NetdevSocketOptions,
    pub vde: NetdevVdeOptions,
    pub dump: NetdevDumpOptions,
    pub bridge: NetdevBridgeOptions,
    pub netmap: NetdevNetmapOptions,
    pub vhost_user: NetdevVhostUserOptions,
}
extern "C" {
    pub fn qapi_free_NetLegacyOptions(obj: *mut NetLegacyOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NetdevHubPortOptions {
    pub hubid: i32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Netdev {
    pub id: *mut ::std::os::raw::c_char,
    pub type_: NetClientDriver,
    pub u: Netdev__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Netdev__bindgen_ty_1 {
    pub none: NetdevNoneOptions,
    pub nic: NetLegacyNicOptions,
    pub user: NetdevUserOptions,
    pub tap: NetdevTapOptions,
    pub l2tpv3: NetdevL2TPv3Options,
    pub socket: NetdevSocketOptions,
    pub vde: NetdevVdeOptions,
    pub dump: NetdevDumpOptions,
    pub bridge: NetdevBridgeOptions,
    pub hubport: NetdevHubPortOptions,
    pub netmap: NetdevNetmapOptions,
    pub vhost_user: NetdevVhostUserOptions,
}
extern "C" {
    pub fn qapi_free_Netdev(obj: *mut Netdev);
}
extern "C" {
    pub fn qapi_free_NetdevBridgeOptions(obj: *mut NetdevBridgeOptions);
}
extern "C" {
    pub fn qapi_free_NetdevDumpOptions(obj: *mut NetdevDumpOptions);
}
extern "C" {
    pub fn qapi_free_NetdevHubPortOptions(obj: *mut NetdevHubPortOptions);
}
extern "C" {
    pub fn qapi_free_NetdevL2TPv3Options(obj: *mut NetdevL2TPv3Options);
}
extern "C" {
    pub fn qapi_free_NetdevNetmapOptions(obj: *mut NetdevNetmapOptions);
}
extern "C" {
    pub fn qapi_free_NetdevNoneOptions(obj: *mut NetdevNoneOptions);
}
extern "C" {
    pub fn qapi_free_NetdevSocketOptions(obj: *mut NetdevSocketOptions);
}
extern "C" {
    pub fn qapi_free_NetdevTapOptions(obj: *mut NetdevTapOptions);
}
extern "C" {
    pub fn qapi_free_NetdevUserOptions(obj: *mut NetdevUserOptions);
}
extern "C" {
    pub fn qapi_free_NetdevVdeOptions(obj: *mut NetdevVdeOptions);
}
extern "C" {
    pub fn qapi_free_NetdevVhostUserOptions(obj: *mut NetdevVhostUserOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NumaNodeOptions {
    pub has_nodeid: bool,
    pub nodeid: u16,
    pub has_cpus: bool,
    pub cpus: *mut uint16List,
    pub has_mem: bool,
    pub mem: u64,
    pub has_memdev: bool,
    pub memdev: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_NumaNodeOptions(obj: *mut NumaNodeOptions);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct NumaOptions {
    pub type_: NumaOptionsType,
    pub u: NumaOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union NumaOptions__bindgen_ty_1 {
    pub node: NumaNodeOptions,
}
extern "C" {
    pub fn qapi_free_NumaOptions(obj: *mut NumaOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectPropertyInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ObjectPropertyInfo(obj: *mut ObjectPropertyInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectPropertyInfoList {
    pub next: *mut ObjectPropertyInfoList,
    pub value: *mut ObjectPropertyInfo,
}
extern "C" {
    pub fn qapi_free_ObjectPropertyInfoList(obj: *mut ObjectPropertyInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectTypeInfo {
    pub name: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ObjectTypeInfo(obj: *mut ObjectTypeInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectTypeInfoList {
    pub next: *mut ObjectTypeInfoList,
    pub value: *mut ObjectTypeInfo,
}
extern "C" {
    pub fn qapi_free_ObjectTypeInfoList(obj: *mut ObjectTypeInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PCDIMMDeviceInfo {
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub addr: i64,
    pub size: i64,
    pub slot: i64,
    pub node: i64,
    pub memdev: *mut ::std::os::raw::c_char,
    pub hotplugged: bool,
    pub hotpluggable: bool,
}
extern "C" {
    pub fn qapi_free_PCDIMMDeviceInfo(obj: *mut PCDIMMDeviceInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PandaPluginInfo {
    pub index: i64,
    pub name: *mut ::std::os::raw::c_char,
    pub address: i64,
}
extern "C" {
    pub fn qapi_free_PandaPluginInfo(obj: *mut PandaPluginInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PandaPluginInfoList {
    pub next: *mut PandaPluginInfoList,
    pub value: *mut PandaPluginInfo,
}
extern "C" {
    pub fn qapi_free_PandaPluginInfoList(obj: *mut PandaPluginInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciBridgeInfo {
    pub bus: *mut PciBusInfo,
    pub has_devices: bool,
    pub devices: *mut PciDeviceInfoList,
}
extern "C" {
    pub fn qapi_free_PciBridgeInfo(obj: *mut PciBridgeInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciBusInfo {
    pub number: i64,
    pub secondary: i64,
    pub subordinate: i64,
    pub io_range: *mut PciMemoryRange,
    pub memory_range: *mut PciMemoryRange,
    pub prefetchable_range: *mut PciMemoryRange,
}
extern "C" {
    pub fn qapi_free_PciBusInfo(obj: *mut PciBusInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciDeviceClass {
    pub has_desc: bool,
    pub desc: *mut ::std::os::raw::c_char,
    pub q_class: i64,
}
extern "C" {
    pub fn qapi_free_PciDeviceClass(obj: *mut PciDeviceClass);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciDeviceId {
    pub device: i64,
    pub vendor: i64,
}
extern "C" {
    pub fn qapi_free_PciDeviceId(obj: *mut PciDeviceId);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciDeviceInfo {
    pub bus: i64,
    pub slot: i64,
    pub function: i64,
    pub class_info: *mut PciDeviceClass,
    pub id: *mut PciDeviceId,
    pub has_irq: bool,
    pub irq: i64,
    pub qdev_id: *mut ::std::os::raw::c_char,
    pub has_pci_bridge: bool,
    pub pci_bridge: *mut PciBridgeInfo,
    pub regions: *mut PciMemoryRegionList,
}
extern "C" {
    pub fn qapi_free_PciDeviceInfo(obj: *mut PciDeviceInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciDeviceInfoList {
    pub next: *mut PciDeviceInfoList,
    pub value: *mut PciDeviceInfo,
}
extern "C" {
    pub fn qapi_free_PciDeviceInfoList(obj: *mut PciDeviceInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciInfo {
    pub bus: i64,
    pub devices: *mut PciDeviceInfoList,
}
extern "C" {
    pub fn qapi_free_PciInfo(obj: *mut PciInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciInfoList {
    pub next: *mut PciInfoList,
    pub value: *mut PciInfo,
}
extern "C" {
    pub fn qapi_free_PciInfoList(obj: *mut PciInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciMemoryRange {
    pub base: i64,
    pub limit: i64,
}
extern "C" {
    pub fn qapi_free_PciMemoryRange(obj: *mut PciMemoryRange);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciMemoryRegion {
    pub bar: i64,
    pub type_: *mut ::std::os::raw::c_char,
    pub address: i64,
    pub size: i64,
    pub has_prefetch: bool,
    pub prefetch: bool,
    pub has_mem_type_64: bool,
    pub mem_type_64: bool,
}
extern "C" {
    pub fn qapi_free_PciMemoryRegion(obj: *mut PciMemoryRegion);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PciMemoryRegionList {
    pub next: *mut PciMemoryRegionList,
    pub value: *mut PciMemoryRegion,
}
extern "C" {
    pub fn qapi_free_PciMemoryRegionList(obj: *mut PciMemoryRegionList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockOptionsQCow {
    pub has_key_secret: bool,
    pub key_secret: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockCreateOptionsLUKS {
    pub has_key_secret: bool,
    pub key_secret: *mut ::std::os::raw::c_char,
    pub has_cipher_alg: bool,
    pub cipher_alg: QCryptoCipherAlgorithm,
    pub has_cipher_mode: bool,
    pub cipher_mode: QCryptoCipherMode,
    pub has_ivgen_alg: bool,
    pub ivgen_alg: QCryptoIVGenAlgorithm,
    pub has_ivgen_hash_alg: bool,
    pub ivgen_hash_alg: QCryptoHashAlgorithm,
    pub has_hash_alg: bool,
    pub hash_alg: QCryptoHashAlgorithm,
    pub has_iter_time: bool,
    pub iter_time: i64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct QCryptoBlockCreateOptions {
    pub format: QCryptoBlockFormat,
    pub u: QCryptoBlockCreateOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union QCryptoBlockCreateOptions__bindgen_ty_1 {
    pub qcow: QCryptoBlockOptionsQCow,
    pub luks: QCryptoBlockCreateOptionsLUKS,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockCreateOptions(obj: *mut QCryptoBlockCreateOptions);
}
extern "C" {
    pub fn qapi_free_QCryptoBlockCreateOptionsLUKS(obj: *mut QCryptoBlockCreateOptionsLUKS);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockInfoQCow {
    pub qapi_dummy_for_empty_struct: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockInfoLUKS {
    pub cipher_alg: QCryptoCipherAlgorithm,
    pub cipher_mode: QCryptoCipherMode,
    pub ivgen_alg: QCryptoIVGenAlgorithm,
    pub has_ivgen_hash_alg: bool,
    pub ivgen_hash_alg: QCryptoHashAlgorithm,
    pub hash_alg: QCryptoHashAlgorithm,
    pub payload_offset: i64,
    pub master_key_iters: i64,
    pub uuid: *mut ::std::os::raw::c_char,
    pub slots: *mut QCryptoBlockInfoLUKSSlotList,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct QCryptoBlockInfo {
    pub format: QCryptoBlockFormat,
    pub u: QCryptoBlockInfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union QCryptoBlockInfo__bindgen_ty_1 {
    pub qcow: QCryptoBlockInfoQCow,
    pub luks: QCryptoBlockInfoLUKS,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockInfo(obj: *mut QCryptoBlockInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockInfoBase {
    pub format: QCryptoBlockFormat,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockInfoBase(obj: *mut QCryptoBlockInfoBase);
}
extern "C" {
    pub fn qapi_free_QCryptoBlockInfoLUKS(obj: *mut QCryptoBlockInfoLUKS);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockInfoLUKSSlot {
    pub active: bool,
    pub has_iters: bool,
    pub iters: i64,
    pub has_stripes: bool,
    pub stripes: i64,
    pub key_offset: i64,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockInfoLUKSSlot(obj: *mut QCryptoBlockInfoLUKSSlot);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockInfoLUKSSlotList {
    pub next: *mut QCryptoBlockInfoLUKSSlotList,
    pub value: *mut QCryptoBlockInfoLUKSSlot,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockInfoLUKSSlotList(obj: *mut QCryptoBlockInfoLUKSSlotList);
}
extern "C" {
    pub fn qapi_free_QCryptoBlockInfoQCow(obj: *mut QCryptoBlockInfoQCow);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockOptionsLUKS {
    pub has_key_secret: bool,
    pub key_secret: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct QCryptoBlockOpenOptions {
    pub format: QCryptoBlockFormat,
    pub u: QCryptoBlockOpenOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union QCryptoBlockOpenOptions__bindgen_ty_1 {
    pub qcow: QCryptoBlockOptionsQCow,
    pub luks: QCryptoBlockOptionsLUKS,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockOpenOptions(obj: *mut QCryptoBlockOpenOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QCryptoBlockOptionsBase {
    pub format: QCryptoBlockFormat,
}
extern "C" {
    pub fn qapi_free_QCryptoBlockOptionsBase(obj: *mut QCryptoBlockOptionsBase);
}
extern "C" {
    pub fn qapi_free_QCryptoBlockOptionsLUKS(obj: *mut QCryptoBlockOptionsLUKS);
}
extern "C" {
    pub fn qapi_free_QCryptoBlockOptionsQCow(obj: *mut QCryptoBlockOptionsQCow);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Qcow2OverlapCheckFlags {
    pub has_q_template: bool,
    pub q_template: Qcow2OverlapCheckMode,
    pub has_main_header: bool,
    pub main_header: bool,
    pub has_active_l1: bool,
    pub active_l1: bool,
    pub has_active_l2: bool,
    pub active_l2: bool,
    pub has_refcount_table: bool,
    pub refcount_table: bool,
    pub has_refcount_block: bool,
    pub refcount_block: bool,
    pub has_snapshot_table: bool,
    pub snapshot_table: bool,
    pub has_inactive_l1: bool,
    pub inactive_l1: bool,
    pub has_inactive_l2: bool,
    pub inactive_l2: bool,
}
extern "C" {
    pub fn qapi_free_Qcow2OverlapCheckFlags(obj: *mut Qcow2OverlapCheckFlags);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Qcow2OverlapChecks {
    pub type_: QType,
    pub u: Qcow2OverlapChecks__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Qcow2OverlapChecks__bindgen_ty_1 {
    pub flags: Qcow2OverlapCheckFlags,
    pub mode: Qcow2OverlapCheckMode,
}
extern "C" {
    pub fn qapi_free_Qcow2OverlapChecks(obj: *mut Qcow2OverlapChecks);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicationStatus {
    pub error: bool,
    pub has_desc: bool,
    pub desc: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_ReplicationStatus(obj: *mut ReplicationStatus);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaFlow {
    pub cookie: u64,
    pub hits: u64,
    pub key: *mut RockerOfDpaFlowKey,
    pub mask: *mut RockerOfDpaFlowMask,
    pub action: *mut RockerOfDpaFlowAction,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaFlow(obj: *mut RockerOfDpaFlow);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaFlowAction {
    pub has_goto_tbl: bool,
    pub goto_tbl: u32,
    pub has_group_id: bool,
    pub group_id: u32,
    pub has_tunnel_lport: bool,
    pub tunnel_lport: u32,
    pub has_vlan_id: bool,
    pub vlan_id: u16,
    pub has_new_vlan_id: bool,
    pub new_vlan_id: u16,
    pub has_out_pport: bool,
    pub out_pport: u32,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaFlowAction(obj: *mut RockerOfDpaFlowAction);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaFlowKey {
    pub priority: u32,
    pub tbl_id: u32,
    pub has_in_pport: bool,
    pub in_pport: u32,
    pub has_tunnel_id: bool,
    pub tunnel_id: u32,
    pub has_vlan_id: bool,
    pub vlan_id: u16,
    pub has_eth_type: bool,
    pub eth_type: u16,
    pub has_eth_src: bool,
    pub eth_src: *mut ::std::os::raw::c_char,
    pub has_eth_dst: bool,
    pub eth_dst: *mut ::std::os::raw::c_char,
    pub has_ip_proto: bool,
    pub ip_proto: u8,
    pub has_ip_tos: bool,
    pub ip_tos: u8,
    pub has_ip_dst: bool,
    pub ip_dst: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaFlowKey(obj: *mut RockerOfDpaFlowKey);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaFlowList {
    pub next: *mut RockerOfDpaFlowList,
    pub value: *mut RockerOfDpaFlow,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaFlowList(obj: *mut RockerOfDpaFlowList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaFlowMask {
    pub has_in_pport: bool,
    pub in_pport: u32,
    pub has_tunnel_id: bool,
    pub tunnel_id: u32,
    pub has_vlan_id: bool,
    pub vlan_id: u16,
    pub has_eth_src: bool,
    pub eth_src: *mut ::std::os::raw::c_char,
    pub has_eth_dst: bool,
    pub eth_dst: *mut ::std::os::raw::c_char,
    pub has_ip_proto: bool,
    pub ip_proto: u8,
    pub has_ip_tos: bool,
    pub ip_tos: u8,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaFlowMask(obj: *mut RockerOfDpaFlowMask);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaGroup {
    pub id: u32,
    pub type_: u8,
    pub has_vlan_id: bool,
    pub vlan_id: u16,
    pub has_pport: bool,
    pub pport: u32,
    pub has_index: bool,
    pub index: u32,
    pub has_out_pport: bool,
    pub out_pport: u32,
    pub has_group_id: bool,
    pub group_id: u32,
    pub has_set_vlan_id: bool,
    pub set_vlan_id: u16,
    pub has_pop_vlan: bool,
    pub pop_vlan: u8,
    pub has_group_ids: bool,
    pub group_ids: *mut uint32List,
    pub has_set_eth_src: bool,
    pub set_eth_src: *mut ::std::os::raw::c_char,
    pub has_set_eth_dst: bool,
    pub set_eth_dst: *mut ::std::os::raw::c_char,
    pub has_ttl_check: bool,
    pub ttl_check: u8,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaGroup(obj: *mut RockerOfDpaGroup);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerOfDpaGroupList {
    pub next: *mut RockerOfDpaGroupList,
    pub value: *mut RockerOfDpaGroup,
}
extern "C" {
    pub fn qapi_free_RockerOfDpaGroupList(obj: *mut RockerOfDpaGroupList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerPort {
    pub name: *mut ::std::os::raw::c_char,
    pub enabled: bool,
    pub link_up: bool,
    pub speed: u32,
    pub duplex: RockerPortDuplex,
    pub autoneg: RockerPortAutoneg,
}
extern "C" {
    pub fn qapi_free_RockerPort(obj: *mut RockerPort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerPortList {
    pub next: *mut RockerPortList,
    pub value: *mut RockerPort,
}
extern "C" {
    pub fn qapi_free_RockerPortList(obj: *mut RockerPortList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RockerSwitch {
    pub name: *mut ::std::os::raw::c_char,
    pub id: u64,
    pub ports: u32,
}
extern "C" {
    pub fn qapi_free_RockerSwitch(obj: *mut RockerSwitch);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RxFilterInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub promiscuous: bool,
    pub multicast: RxState,
    pub unicast: RxState,
    pub vlan: RxState,
    pub broadcast_allowed: bool,
    pub multicast_overflow: bool,
    pub unicast_overflow: bool,
    pub main_mac: *mut ::std::os::raw::c_char,
    pub vlan_table: *mut intList,
    pub unicast_table: *mut strList,
    pub multicast_table: *mut strList,
}
extern "C" {
    pub fn qapi_free_RxFilterInfo(obj: *mut RxFilterInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RxFilterInfoList {
    pub next: *mut RxFilterInfoList,
    pub value: *mut RxFilterInfo,
}
extern "C" {
    pub fn qapi_free_RxFilterInfoList(obj: *mut RxFilterInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoBuiltin {
    pub json_type: JSONType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoEnum {
    pub values: *mut strList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoArray {
    pub element_type: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoObject {
    pub members: *mut SchemaInfoObjectMemberList,
    pub has_tag: bool,
    pub tag: *mut ::std::os::raw::c_char,
    pub has_variants: bool,
    pub variants: *mut SchemaInfoObjectVariantList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoAlternate {
    pub members: *mut SchemaInfoAlternateMemberList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoCommand {
    pub arg_type: *mut ::std::os::raw::c_char,
    pub ret_type: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoEvent {
    pub arg_type: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SchemaInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub meta_type: SchemaMetaType,
    pub u: SchemaInfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SchemaInfo__bindgen_ty_1 {
    pub builtin: SchemaInfoBuiltin,
    pub q_enum: SchemaInfoEnum,
    pub array: SchemaInfoArray,
    pub object: SchemaInfoObject,
    pub alternate: SchemaInfoAlternate,
    pub command: SchemaInfoCommand,
    pub event: SchemaInfoEvent,
}
extern "C" {
    pub fn qapi_free_SchemaInfo(obj: *mut SchemaInfo);
}
extern "C" {
    pub fn qapi_free_SchemaInfoAlternate(obj: *mut SchemaInfoAlternate);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoAlternateMember {
    pub type_: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_SchemaInfoAlternateMember(obj: *mut SchemaInfoAlternateMember);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoAlternateMemberList {
    pub next: *mut SchemaInfoAlternateMemberList,
    pub value: *mut SchemaInfoAlternateMember,
}
extern "C" {
    pub fn qapi_free_SchemaInfoAlternateMemberList(obj: *mut SchemaInfoAlternateMemberList);
}
extern "C" {
    pub fn qapi_free_SchemaInfoArray(obj: *mut SchemaInfoArray);
}
extern "C" {
    pub fn qapi_free_SchemaInfoBuiltin(obj: *mut SchemaInfoBuiltin);
}
extern "C" {
    pub fn qapi_free_SchemaInfoCommand(obj: *mut SchemaInfoCommand);
}
extern "C" {
    pub fn qapi_free_SchemaInfoEnum(obj: *mut SchemaInfoEnum);
}
extern "C" {
    pub fn qapi_free_SchemaInfoEvent(obj: *mut SchemaInfoEvent);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoList {
    pub next: *mut SchemaInfoList,
    pub value: *mut SchemaInfo,
}
extern "C" {
    pub fn qapi_free_SchemaInfoList(obj: *mut SchemaInfoList);
}
extern "C" {
    pub fn qapi_free_SchemaInfoObject(obj: *mut SchemaInfoObject);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoObjectMember {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub has_q_default: bool,
    pub q_default: *mut QObject,
}
extern "C" {
    pub fn qapi_free_SchemaInfoObjectMember(obj: *mut SchemaInfoObjectMember);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoObjectMemberList {
    pub next: *mut SchemaInfoObjectMemberList,
    pub value: *mut SchemaInfoObjectMember,
}
extern "C" {
    pub fn qapi_free_SchemaInfoObjectMemberList(obj: *mut SchemaInfoObjectMemberList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoObjectVariant {
    pub q_case: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_SchemaInfoObjectVariant(obj: *mut SchemaInfoObjectVariant);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SchemaInfoObjectVariantList {
    pub next: *mut SchemaInfoObjectVariantList,
    pub value: *mut SchemaInfoObjectVariant,
}
extern "C" {
    pub fn qapi_free_SchemaInfoObjectVariantList(obj: *mut SchemaInfoObjectVariantList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotInfo {
    pub id: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub vm_state_size: i64,
    pub date_sec: i64,
    pub date_nsec: i64,
    pub vm_clock_sec: i64,
    pub vm_clock_nsec: i64,
}
extern "C" {
    pub fn qapi_free_SnapshotInfo(obj: *mut SnapshotInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotInfoList {
    pub next: *mut SnapshotInfoList,
    pub value: *mut SnapshotInfo,
}
extern "C" {
    pub fn qapi_free_SnapshotInfoList(obj: *mut SnapshotInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_InetSocketAddress_wrapper {
    pub data: *mut InetSocketAddress,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_UnixSocketAddress_wrapper {
    pub data: *mut UnixSocketAddress,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_VsockSocketAddress_wrapper {
    pub data: *mut VsockSocketAddress,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_String_wrapper {
    pub data: *mut String,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SocketAddress {
    pub type_: SocketAddressKind,
    pub u: SocketAddress__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SocketAddress__bindgen_ty_1 {
    pub inet: q_obj_InetSocketAddress_wrapper,
    pub q_unix: q_obj_UnixSocketAddress_wrapper,
    pub vsock: q_obj_VsockSocketAddress_wrapper,
    pub fd: q_obj_String_wrapper,
}
extern "C" {
    pub fn qapi_free_SocketAddress(obj: *mut SocketAddress);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UnixSocketAddress {
    pub path: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VsockSocketAddress {
    pub cid: *mut ::std::os::raw::c_char,
    pub port: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct String {
    pub str_: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SocketAddressFlat {
    pub type_: SocketAddressFlatType,
    pub u: SocketAddressFlat__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SocketAddressFlat__bindgen_ty_1 {
    pub inet: InetSocketAddress,
    pub q_unix: UnixSocketAddress,
    pub vsock: VsockSocketAddress,
    pub fd: String,
}
extern "C" {
    pub fn qapi_free_SocketAddressFlat(obj: *mut SocketAddressFlat);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SocketAddressFlatList {
    pub next: *mut SocketAddressFlatList,
    pub value: *mut SocketAddressFlat,
}
extern "C" {
    pub fn qapi_free_SocketAddressFlatList(obj: *mut SocketAddressFlatList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpiceBasicInfo {
    pub host: *mut ::std::os::raw::c_char,
    pub port: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
}
extern "C" {
    pub fn qapi_free_SpiceBasicInfo(obj: *mut SpiceBasicInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpiceChannel {
    pub host: *mut ::std::os::raw::c_char,
    pub port: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
    pub connection_id: i64,
    pub channel_type: i64,
    pub channel_id: i64,
    pub tls: bool,
}
extern "C" {
    pub fn qapi_free_SpiceChannel(obj: *mut SpiceChannel);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpiceChannelList {
    pub next: *mut SpiceChannelList,
    pub value: *mut SpiceChannel,
}
extern "C" {
    pub fn qapi_free_SpiceChannelList(obj: *mut SpiceChannelList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpiceInfo {
    pub enabled: bool,
    pub migrated: bool,
    pub has_host: bool,
    pub host: *mut ::std::os::raw::c_char,
    pub has_port: bool,
    pub port: i64,
    pub has_tls_port: bool,
    pub tls_port: i64,
    pub has_auth: bool,
    pub auth: *mut ::std::os::raw::c_char,
    pub has_compiled_version: bool,
    pub compiled_version: *mut ::std::os::raw::c_char,
    pub mouse_mode: SpiceQueryMouseMode,
    pub has_channels: bool,
    pub channels: *mut SpiceChannelList,
}
extern "C" {
    pub fn qapi_free_SpiceInfo(obj: *mut SpiceInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpiceServerInfo {
    pub host: *mut ::std::os::raw::c_char,
    pub port: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
    pub has_auth: bool,
    pub auth: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_SpiceServerInfo(obj: *mut SpiceServerInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StatusInfo {
    pub running: bool,
    pub singlestep: bool,
    pub status: RunState,
}
extern "C" {
    pub fn qapi_free_StatusInfo(obj: *mut StatusInfo);
}
extern "C" {
    pub fn qapi_free_String(obj: *mut String);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringList {
    pub next: *mut StringList,
    pub value: *mut String,
}
extern "C" {
    pub fn qapi_free_StringList(obj: *mut StringList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMInfo {
    pub id: *mut ::std::os::raw::c_char,
    pub model: TpmModel,
    pub options: *mut TpmTypeOptions,
}
extern "C" {
    pub fn qapi_free_TPMInfo(obj: *mut TPMInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMInfoList {
    pub next: *mut TPMInfoList,
    pub value: *mut TPMInfo,
}
extern "C" {
    pub fn qapi_free_TPMInfoList(obj: *mut TPMInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMPassthroughOptions {
    pub has_path: bool,
    pub path: *mut ::std::os::raw::c_char,
    pub has_cancel_path: bool,
    pub cancel_path: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_TPMPassthroughOptions(obj: *mut TPMPassthroughOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetInfo {
    pub arch: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_TargetInfo(obj: *mut TargetInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TpmModelList {
    pub next: *mut TpmModelList,
    pub value: TpmModel,
}
extern "C" {
    pub fn qapi_free_TpmModelList(obj: *mut TpmModelList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TpmTypeList {
    pub next: *mut TpmTypeList,
    pub value: TpmType,
}
extern "C" {
    pub fn qapi_free_TpmTypeList(obj: *mut TpmTypeList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_TPMPassthroughOptions_wrapper {
    pub data: *mut TPMPassthroughOptions,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TpmTypeOptions {
    pub type_: TpmTypeOptionsKind,
    pub u: TpmTypeOptions__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TpmTypeOptions__bindgen_ty_1 {
    pub passthrough: q_obj_TPMPassthroughOptions_wrapper,
}
extern "C" {
    pub fn qapi_free_TpmTypeOptions(obj: *mut TpmTypeOptions);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TraceEventInfo {
    pub name: *mut ::std::os::raw::c_char,
    pub state: TraceEventState,
    pub vcpu: bool,
}
extern "C" {
    pub fn qapi_free_TraceEventInfo(obj: *mut TraceEventInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TraceEventInfoList {
    pub next: *mut TraceEventInfoList,
    pub value: *mut TraceEventInfo,
}
extern "C" {
    pub fn qapi_free_TraceEventInfoList(obj: *mut TraceEventInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_Abort_wrapper {
    pub data: *mut Abort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockDirtyBitmapAdd_wrapper {
    pub data: *mut BlockDirtyBitmapAdd,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockDirtyBitmap_wrapper {
    pub data: *mut BlockDirtyBitmap,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockdevBackup_wrapper {
    pub data: *mut BlockdevBackup,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockdevSnapshot_wrapper {
    pub data: *mut BlockdevSnapshot,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockdevSnapshotInternal_wrapper {
    pub data: *mut BlockdevSnapshotInternal,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockdevSnapshotSync_wrapper {
    pub data: *mut BlockdevSnapshotSync,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_DriveBackup_wrapper {
    pub data: *mut DriveBackup,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TransactionAction {
    pub type_: TransactionActionKind,
    pub u: TransactionAction__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TransactionAction__bindgen_ty_1 {
    pub abort: q_obj_Abort_wrapper,
    pub block_dirty_bitmap_add: q_obj_BlockDirtyBitmapAdd_wrapper,
    pub block_dirty_bitmap_clear: q_obj_BlockDirtyBitmap_wrapper,
    pub blockdev_backup: q_obj_BlockdevBackup_wrapper,
    pub blockdev_snapshot: q_obj_BlockdevSnapshot_wrapper,
    pub blockdev_snapshot_internal_sync: q_obj_BlockdevSnapshotInternal_wrapper,
    pub blockdev_snapshot_sync: q_obj_BlockdevSnapshotSync_wrapper,
    pub drive_backup: q_obj_DriveBackup_wrapper,
}
extern "C" {
    pub fn qapi_free_TransactionAction(obj: *mut TransactionAction);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransactionActionList {
    pub next: *mut TransactionActionList,
    pub value: *mut TransactionAction,
}
extern "C" {
    pub fn qapi_free_TransactionActionList(obj: *mut TransactionActionList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransactionProperties {
    pub has_completion_mode: bool,
    pub completion_mode: ActionCompletionMode,
}
extern "C" {
    pub fn qapi_free_TransactionProperties(obj: *mut TransactionProperties);
}
extern "C" {
    pub fn qapi_free_UnixSocketAddress(obj: *mut UnixSocketAddress);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UuidInfo {
    pub UUID: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_UuidInfo(obj: *mut UuidInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VersionInfo {
    pub qemu: *mut VersionTriple,
    pub package: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_VersionInfo(obj: *mut VersionInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VersionTriple {
    pub major: i64,
    pub minor: i64,
    pub micro: i64,
}
extern "C" {
    pub fn qapi_free_VersionTriple(obj: *mut VersionTriple);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncBasicInfo {
    pub host: *mut ::std::os::raw::c_char,
    pub service: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
    pub websocket: bool,
}
extern "C" {
    pub fn qapi_free_VncBasicInfo(obj: *mut VncBasicInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncClientInfo {
    pub host: *mut ::std::os::raw::c_char,
    pub service: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
    pub websocket: bool,
    pub has_x509_dname: bool,
    pub x509_dname: *mut ::std::os::raw::c_char,
    pub has_sasl_username: bool,
    pub sasl_username: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_VncClientInfo(obj: *mut VncClientInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncClientInfoList {
    pub next: *mut VncClientInfoList,
    pub value: *mut VncClientInfo,
}
extern "C" {
    pub fn qapi_free_VncClientInfoList(obj: *mut VncClientInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncInfo {
    pub enabled: bool,
    pub has_host: bool,
    pub host: *mut ::std::os::raw::c_char,
    pub has_family: bool,
    pub family: NetworkAddressFamily,
    pub has_service: bool,
    pub service: *mut ::std::os::raw::c_char,
    pub has_auth: bool,
    pub auth: *mut ::std::os::raw::c_char,
    pub has_clients: bool,
    pub clients: *mut VncClientInfoList,
}
extern "C" {
    pub fn qapi_free_VncInfo(obj: *mut VncInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncInfo2 {
    pub id: *mut ::std::os::raw::c_char,
    pub server: *mut VncServerInfo2List,
    pub clients: *mut VncClientInfoList,
    pub auth: VncPrimaryAuth,
    pub has_vencrypt: bool,
    pub vencrypt: VncVencryptSubAuth,
    pub has_display: bool,
    pub display: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_VncInfo2(obj: *mut VncInfo2);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncInfo2List {
    pub next: *mut VncInfo2List,
    pub value: *mut VncInfo2,
}
extern "C" {
    pub fn qapi_free_VncInfo2List(obj: *mut VncInfo2List);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncServerInfo {
    pub host: *mut ::std::os::raw::c_char,
    pub service: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
    pub websocket: bool,
    pub has_auth: bool,
    pub auth: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn qapi_free_VncServerInfo(obj: *mut VncServerInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncServerInfo2 {
    pub host: *mut ::std::os::raw::c_char,
    pub service: *mut ::std::os::raw::c_char,
    pub family: NetworkAddressFamily,
    pub websocket: bool,
    pub auth: VncPrimaryAuth,
    pub has_vencrypt: bool,
    pub vencrypt: VncVencryptSubAuth,
}
extern "C" {
    pub fn qapi_free_VncServerInfo2(obj: *mut VncServerInfo2);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VncServerInfo2List {
    pub next: *mut VncServerInfo2List,
    pub value: *mut VncServerInfo2,
}
extern "C" {
    pub fn qapi_free_VncServerInfo2List(obj: *mut VncServerInfo2List);
}
extern "C" {
    pub fn qapi_free_VsockSocketAddress(obj: *mut VsockSocketAddress);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X86CPUFeatureWordInfo {
    pub cpuid_input_eax: i64,
    pub has_cpuid_input_ecx: bool,
    pub cpuid_input_ecx: i64,
    pub cpuid_register: X86CPURegister32,
    pub features: i64,
}
extern "C" {
    pub fn qapi_free_X86CPUFeatureWordInfo(obj: *mut X86CPUFeatureWordInfo);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X86CPUFeatureWordInfoList {
    pub next: *mut X86CPUFeatureWordInfoList,
    pub value: *mut X86CPUFeatureWordInfo,
}
extern "C" {
    pub fn qapi_free_X86CPUFeatureWordInfoList(obj: *mut X86CPUFeatureWordInfoList);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XBZRLECacheStats {
    pub cache_size: i64,
    pub bytes: i64,
    pub pages: i64,
    pub cache_miss: i64,
    pub cache_miss_rate: f64,
    pub overflow: i64,
}
extern "C" {
    pub fn qapi_free_XBZRLECacheStats(obj: *mut XBZRLECacheStats);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ACPI_DEVICE_OST_arg {
    pub info: *mut ACPIOSTInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BALLOON_CHANGE_arg {
    pub actual: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_IMAGE_CORRUPTED_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub msg: *mut ::std::os::raw::c_char,
    pub has_offset: bool,
    pub offset: i64,
    pub has_size: bool,
    pub size: i64,
    pub fatal: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_IO_ERROR_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub node_name: *mut ::std::os::raw::c_char,
    pub operation: IoOperationType,
    pub action: BlockErrorAction,
    pub has_nospace: bool,
    pub nospace: bool,
    pub reason: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_JOB_CANCELLED_arg {
    pub type_: BlockJobType,
    pub device: *mut ::std::os::raw::c_char,
    pub len: i64,
    pub offset: i64,
    pub speed: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_JOB_COMPLETED_arg {
    pub type_: BlockJobType,
    pub device: *mut ::std::os::raw::c_char,
    pub len: i64,
    pub offset: i64,
    pub speed: i64,
    pub has_error: bool,
    pub error: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_JOB_ERROR_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub operation: IoOperationType,
    pub action: BlockErrorAction,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_JOB_READY_arg {
    pub type_: BlockJobType,
    pub device: *mut ::std::os::raw::c_char,
    pub len: i64,
    pub offset: i64,
    pub speed: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BLOCK_WRITE_THRESHOLD_arg {
    pub node_name: *mut ::std::os::raw::c_char,
    pub amount_exceeded: u64,
    pub write_threshold: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_BlockdevOptions_base {
    pub driver: BlockdevDriver,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub has_discard: bool,
    pub discard: BlockdevDiscardOptions,
    pub has_cache: bool,
    pub cache: *mut BlockdevCacheOptions,
    pub has_read_only: bool,
    pub read_only: bool,
    pub has_detect_zeroes: bool,
    pub detect_zeroes: BlockdevDetectZeroesOptions,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_CpuInfo_base {
    pub CPU: i64,
    pub current: bool,
    pub halted: bool,
    pub qom_path: *mut ::std::os::raw::c_char,
    pub thread_id: i64,
    pub arch: CpuInfoArch,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_DEVICE_DELETED_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_DEVICE_TRAY_MOVED_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub id: *mut ::std::os::raw::c_char,
    pub tray_open: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_DUMP_COMPLETED_arg {
    pub result: *mut DumpQueryResult,
    pub has_error: bool,
    pub error: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_GUEST_PANICKED_arg {
    pub action: GuestPanicAction,
    pub has_info: bool,
    pub info: *mut GuestPanicInformation,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_GuestPanicInformation_base {
    pub type_: GuestPanicInformationType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_MEM_UNPLUG_ERROR_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub msg: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_MIGRATION_arg {
    pub status: MigrationStatus,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_MIGRATION_PASS_arg {
    pub pass: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_NIC_RX_FILTER_CHANGED_arg {
    pub has_name: bool,
    pub name: *mut ::std::os::raw::c_char,
    pub path: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_NetLegacyOptions_base {
    pub type_: NetLegacyOptionsType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_Netdev_base {
    pub id: *mut ::std::os::raw::c_char,
    pub type_: NetClientDriver,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_NumaOptions_base {
    pub type_: NumaOptionsType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_QUORUM_FAILURE_arg {
    pub reference: *mut ::std::os::raw::c_char,
    pub sector_num: i64,
    pub sectors_count: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_QUORUM_REPORT_BAD_arg {
    pub type_: QuorumOpType,
    pub has_error: bool,
    pub error: *mut ::std::os::raw::c_char,
    pub node_name: *mut ::std::os::raw::c_char,
    pub sector_num: i64,
    pub sectors_count: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_RTC_CHANGE_arg {
    pub offset: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_SPICE_CONNECTED_arg {
    pub server: *mut SpiceBasicInfo,
    pub client: *mut SpiceBasicInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_SPICE_DISCONNECTED_arg {
    pub server: *mut SpiceBasicInfo,
    pub client: *mut SpiceBasicInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_SPICE_INITIALIZED_arg {
    pub server: *mut SpiceServerInfo,
    pub client: *mut SpiceChannel,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_SchemaInfo_base {
    pub name: *mut ::std::os::raw::c_char,
    pub meta_type: SchemaMetaType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_SocketAddressFlat_base {
    pub type_: SocketAddressFlatType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_VNC_CONNECTED_arg {
    pub server: *mut VncServerInfo,
    pub client: *mut VncBasicInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_VNC_DISCONNECTED_arg {
    pub server: *mut VncServerInfo,
    pub client: *mut VncClientInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_VNC_INITIALIZED_arg {
    pub server: *mut VncServerInfo,
    pub client: *mut VncClientInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_VSERPORT_CHANGE_arg {
    pub id: *mut ::std::os::raw::c_char,
    pub open: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_WATCHDOG_arg {
    pub action: WatchdogExpirationAction,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_add_fd_arg {
    pub has_fdset_id: bool,
    pub fdset_id: i64,
    pub has_opaque: bool,
    pub opaque: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_add_client_arg {
    pub protocol: *mut ::std::os::raw::c_char,
    pub fdname: *mut ::std::os::raw::c_char,
    pub has_skipauth: bool,
    pub skipauth: bool,
    pub has_tls: bool,
    pub tls: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_balloon_arg {
    pub value: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_begin_record_arg {
    pub file_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_begin_record_from_arg {
    pub snapshot: *mut ::std::os::raw::c_char,
    pub file_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_begin_replay_arg {
    pub file_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_commit_arg {
    pub has_job_id: bool,
    pub job_id: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub has_base: bool,
    pub base: *mut ::std::os::raw::c_char,
    pub has_top: bool,
    pub top: *mut ::std::os::raw::c_char,
    pub has_backing_file: bool,
    pub backing_file: *mut ::std::os::raw::c_char,
    pub has_speed: bool,
    pub speed: i64,
    pub has_filter_node_name: bool,
    pub filter_node_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_job_cancel_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub has_force: bool,
    pub force: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_job_complete_arg {
    pub device: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_job_pause_arg {
    pub device: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_job_resume_arg {
    pub device: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_job_set_speed_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub speed: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_set_write_threshold_arg {
    pub node_name: *mut ::std::os::raw::c_char,
    pub write_threshold: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_stream_arg {
    pub has_job_id: bool,
    pub job_id: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub has_base: bool,
    pub base: *mut ::std::os::raw::c_char,
    pub has_base_node: bool,
    pub base_node: *mut ::std::os::raw::c_char,
    pub has_backing_file: bool,
    pub backing_file: *mut ::std::os::raw::c_char,
    pub has_speed: bool,
    pub speed: i64,
    pub has_on_error: bool,
    pub on_error: BlockdevOnError,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_passwd_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub password: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_block_resize_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_node_name: bool,
    pub node_name: *mut ::std::os::raw::c_char,
    pub size: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_blockdev_change_medium_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub filename: *mut ::std::os::raw::c_char,
    pub has_format: bool,
    pub format: *mut ::std::os::raw::c_char,
    pub has_read_only_mode: bool,
    pub read_only_mode: BlockdevChangeReadOnlyMode,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_blockdev_close_tray_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_blockdev_del_arg {
    pub node_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_blockdev_mirror_arg {
    pub has_job_id: bool,
    pub job_id: *mut ::std::os::raw::c_char,
    pub device: *mut ::std::os::raw::c_char,
    pub target: *mut ::std::os::raw::c_char,
    pub has_replaces: bool,
    pub replaces: *mut ::std::os::raw::c_char,
    pub sync: MirrorSyncMode,
    pub has_speed: bool,
    pub speed: i64,
    pub has_granularity: bool,
    pub granularity: u32,
    pub has_buf_size: bool,
    pub buf_size: i64,
    pub has_on_source_error: bool,
    pub on_source_error: BlockdevOnError,
    pub has_on_target_error: bool,
    pub on_target_error: BlockdevOnError,
    pub has_filter_node_name: bool,
    pub filter_node_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_blockdev_open_tray_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub has_force: bool,
    pub force: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_blockdev_snapshot_delete_internal_sync_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub has_name: bool,
    pub name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_change_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub target: *mut ::std::os::raw::c_char,
    pub has_arg: bool,
    pub arg: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_change_backing_file_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub image_node_name: *mut ::std::os::raw::c_char,
    pub backing_file: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_change_vnc_password_arg {
    pub password: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_chardev_add_arg {
    pub id: *mut ::std::os::raw::c_char,
    pub backend: *mut ChardevBackend,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_chardev_remove_arg {
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_client_migrate_info_arg {
    pub protocol: *mut ::std::os::raw::c_char,
    pub hostname: *mut ::std::os::raw::c_char,
    pub has_port: bool,
    pub port: i64,
    pub has_tls_port: bool,
    pub tls_port: i64,
    pub has_cert_subject: bool,
    pub cert_subject: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_closefd_arg {
    pub fdname: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_cpu_add_arg {
    pub id: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_cpu_arg {
    pub index: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_device_list_properties_arg {
    pub q_typename: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_device_add_arg {
    pub driver: *mut ::std::os::raw::c_char,
    pub has_bus: bool,
    pub bus: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_device_del_arg {
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_dump_guest_memory_arg {
    pub paging: bool,
    pub protocol: *mut ::std::os::raw::c_char,
    pub has_detach: bool,
    pub detach: bool,
    pub has_begin: bool,
    pub begin: i64,
    pub has_length: bool,
    pub length: i64,
    pub has_format: bool,
    pub format: DumpGuestMemoryFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_dump_skeys_arg {
    pub filename: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_eject_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub has_force: bool,
    pub force: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_expire_password_arg {
    pub protocol: *mut ::std::os::raw::c_char,
    pub time: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_getfd_arg {
    pub fdname: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_human_monitor_command_arg {
    pub command_line: *mut ::std::os::raw::c_char,
    pub has_cpu_index: bool,
    pub cpu_index: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_input_send_event_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_head: bool,
    pub head: i64,
    pub events: *mut InputEventList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_load_plugin_arg {
    pub has_file_name: bool,
    pub file_name: *mut ::std::os::raw::c_char,
    pub plugin_name: *mut ::std::os::raw::c_char,
    pub has_plugin_args: bool,
    pub plugin_args: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_memsave_arg {
    pub val: i64,
    pub size: i64,
    pub filename: *mut ::std::os::raw::c_char,
    pub has_cpu_index: bool,
    pub cpu_index: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_migrate_arg {
    pub uri: *mut ::std::os::raw::c_char,
    pub has_blk: bool,
    pub blk: bool,
    pub has_inc: bool,
    pub inc: bool,
    pub has_detach: bool,
    pub detach: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_migrate_incoming_arg {
    pub uri: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_migrate_set_cache_size_arg {
    pub value: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_migrate_set_capabilities_arg {
    pub capabilities: *mut MigrationCapabilityStatusList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_migrate_set_downtime_arg {
    pub value: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_migrate_set_speed_arg {
    pub value: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_nbd_server_add_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub has_writable: bool,
    pub writable: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_nbd_server_start_arg {
    pub addr: *mut SocketAddress,
    pub has_tls_creds: bool,
    pub tls_creds: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_netdev_add_arg {
    pub type_: *mut ::std::os::raw::c_char,
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_netdev_del_arg {
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_object_add_arg {
    pub qom_type: *mut ::std::os::raw::c_char,
    pub id: *mut ::std::os::raw::c_char,
    pub has_props: bool,
    pub props: *mut QObject,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_object_del_arg {
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_plugin_cmd_arg {
    pub cmd: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_pmemsave_arg {
    pub val: i64,
    pub size: i64,
    pub filename: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_qom_get_arg {
    pub path: *mut ::std::os::raw::c_char,
    pub property: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_qom_list_arg {
    pub path: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_qom_list_types_arg {
    pub has_implements: bool,
    pub implements: *mut ::std::os::raw::c_char,
    pub has_abstract: bool,
    pub abstract_: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_qom_set_arg {
    pub path: *mut ::std::os::raw::c_char,
    pub property: *mut ::std::os::raw::c_char,
    pub value: *mut QObject,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_blockstats_arg {
    pub has_query_nodes: bool,
    pub query_nodes: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_command_line_options_arg {
    pub has_option: bool,
    pub option: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_cpu_model_baseline_arg {
    pub modela: *mut CpuModelInfo,
    pub modelb: *mut CpuModelInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_cpu_model_comparison_arg {
    pub modela: *mut CpuModelInfo,
    pub modelb: *mut CpuModelInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_cpu_model_expansion_arg {
    pub type_: CpuModelExpansionType,
    pub model: *mut CpuModelInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_rocker_arg {
    pub name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_rocker_of_dpa_flows_arg {
    pub name: *mut ::std::os::raw::c_char,
    pub has_tbl_id: bool,
    pub tbl_id: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_rocker_of_dpa_groups_arg {
    pub name: *mut ::std::os::raw::c_char,
    pub has_type: bool,
    pub type_: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_rocker_ports_arg {
    pub name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_query_rx_filter_arg {
    pub has_name: bool,
    pub name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_remove_fd_arg {
    pub fdset_id: i64,
    pub has_fd: bool,
    pub fd: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ringbuf_read_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub size: i64,
    pub has_format: bool,
    pub format: DataFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_ringbuf_write_arg {
    pub device: *mut ::std::os::raw::c_char,
    pub data: *mut ::std::os::raw::c_char,
    pub has_format: bool,
    pub format: DataFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_screendump_arg {
    pub filename: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_send_key_arg {
    pub keys: *mut KeyValueList,
    pub has_hold_time: bool,
    pub hold_time: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_set_link_arg {
    pub name: *mut ::std::os::raw::c_char,
    pub up: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_set_password_arg {
    pub protocol: *mut ::std::os::raw::c_char,
    pub password: *mut ::std::os::raw::c_char,
    pub has_connected: bool,
    pub connected: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_trace_event_get_state_arg {
    pub name: *mut ::std::os::raw::c_char,
    pub has_vcpu: bool,
    pub vcpu: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_trace_event_set_state_arg {
    pub name: *mut ::std::os::raw::c_char,
    pub enable: bool,
    pub has_ignore_unavailable: bool,
    pub ignore_unavailable: bool,
    pub has_vcpu: bool,
    pub vcpu: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_transaction_arg {
    pub actions: *mut TransactionActionList,
    pub has_properties: bool,
    pub properties: *mut TransactionProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_unload_plugin_arg {
    pub index: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_x_blockdev_change_arg {
    pub parent: *mut ::std::os::raw::c_char,
    pub has_child: bool,
    pub child: *mut ::std::os::raw::c_char,
    pub has_node: bool,
    pub node: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_x_blockdev_insert_medium_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
    pub node_name: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_x_blockdev_remove_medium_arg {
    pub has_device: bool,
    pub device: *mut ::std::os::raw::c_char,
    pub has_id: bool,
    pub id: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_xen_load_devices_state_arg {
    pub filename: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_xen_save_devices_state_arg {
    pub filename: *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_xen_set_global_dirty_log_arg {
    pub enable: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct q_obj_xen_set_replication_arg {
    pub enable: bool,
    pub primary: bool,
    pub has_failover: bool,
    pub failover: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QObject {
    pub type_: QType,
    pub refcnt: size_t,
}
extern "C" {
    #[doc = " qobject_destroy(): Free resources used by the object"]
    pub fn qobject_destroy(obj: *mut QObject);
}
extern "C" {
    pub static mut qnull_: QObject;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QListEntry {
    pub value: *mut QObject,
    pub next: QListEntry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QListEntry__bindgen_ty_1 {
    pub tqe_next: *mut QListEntry,
    pub tqe_prev: *mut *mut QListEntry,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QList {
    pub base: QObject,
    pub head: QList__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QList__bindgen_ty_1 {
    pub tqh_first: *mut QListEntry,
    pub tqh_last: *mut *mut QListEntry,
}
extern "C" {
    pub fn qlist_new() -> *mut QList;
}
extern "C" {
    pub fn qlist_copy(src: *mut QList) -> *mut QList;
}
extern "C" {
    pub fn qlist_append_obj(qlist: *mut QList, obj: *mut QObject);
}
extern "C" {
    pub fn qlist_iter(
        qlist: *const QList,
        iter: ::std::option::Option<
            unsafe extern "C" fn(obj: *mut QObject, opaque: *mut ::std::os::raw::c_void),
        >,
        opaque: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qlist_pop(qlist: *mut QList) -> *mut QObject;
}
extern "C" {
    pub fn qlist_peek(qlist: *mut QList) -> *mut QObject;
}
extern "C" {
    pub fn qlist_empty(qlist: *const QList) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qlist_size(qlist: *const QList) -> size_t;
}
extern "C" {
    pub fn qobject_to_qlist(obj: *const QObject) -> *mut QList;
}
extern "C" {
    pub fn qlist_destroy_obj(obj: *mut QObject);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QDictEntry {
    pub key: *mut ::std::os::raw::c_char,
    pub value: *mut QObject,
    pub next: QDictEntry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QDictEntry__bindgen_ty_1 {
    pub le_next: *mut QDictEntry,
    pub le_prev: *mut *mut QDictEntry,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct QDict {
    pub base: QObject,
    pub size: size_t,
    pub table: [QDict__bindgen_ty_1; 512usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QDict__bindgen_ty_1 {
    pub lh_first: *mut QDictEntry,
}
extern "C" {
    pub fn qdict_new() -> *mut QDict;
}
extern "C" {
    pub fn qdict_entry_key(entry: *const QDictEntry) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qdict_entry_value(entry: *const QDictEntry) -> *mut QObject;
}
extern "C" {
    pub fn qdict_size(qdict: *const QDict) -> size_t;
}
extern "C" {
    pub fn qdict_put_obj(
        qdict: *mut QDict,
        key: *const ::std::os::raw::c_char,
        value: *mut QObject,
    );
}
extern "C" {
    pub fn qdict_del(qdict: *mut QDict, key: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn qdict_haskey(
        qdict: *const QDict,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qdict_get(qdict: *const QDict, key: *const ::std::os::raw::c_char) -> *mut QObject;
}
extern "C" {
    pub fn qobject_to_qdict(obj: *const QObject) -> *mut QDict;
}
extern "C" {
    pub fn qdict_iter(
        qdict: *const QDict,
        iter: ::std::option::Option<
            unsafe extern "C" fn(
                key: *const ::std::os::raw::c_char,
                obj: *mut QObject,
                opaque: *mut ::std::os::raw::c_void,
            ),
        >,
        opaque: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qdict_first(qdict: *const QDict) -> *const QDictEntry;
}
extern "C" {
    pub fn qdict_next(qdict: *const QDict, entry: *const QDictEntry) -> *const QDictEntry;
}
extern "C" {
    pub fn qdict_destroy_obj(obj: *mut QObject);
}
extern "C" {
    pub fn qdict_get_double(qdict: *const QDict, key: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn qdict_get_int(qdict: *const QDict, key: *const ::std::os::raw::c_char) -> i64;
}
extern "C" {
    pub fn qdict_get_bool(qdict: *const QDict, key: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn qdict_get_qlist(qdict: *const QDict, key: *const ::std::os::raw::c_char) -> *mut QList;
}
extern "C" {
    pub fn qdict_get_qdict(qdict: *const QDict, key: *const ::std::os::raw::c_char) -> *mut QDict;
}
extern "C" {
    pub fn qdict_get_str(
        qdict: *const QDict,
        key: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qdict_get_try_int(
        qdict: *const QDict,
        key: *const ::std::os::raw::c_char,
        def_value: i64,
    ) -> i64;
}
extern "C" {
    pub fn qdict_get_try_bool(
        qdict: *const QDict,
        key: *const ::std::os::raw::c_char,
        def_value: bool,
    ) -> bool;
}
extern "C" {
    pub fn qdict_get_try_str(
        qdict: *const QDict,
        key: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qdict_copy_default(dst: *mut QDict, src: *mut QDict, key: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn qdict_set_default_str(
        dst: *mut QDict,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn qdict_clone_shallow(src: *const QDict) -> *mut QDict;
}
extern "C" {
    pub fn qdict_flatten(qdict: *mut QDict);
}
extern "C" {
    pub fn qdict_extract_subqdict(
        src: *mut QDict,
        dst: *mut *mut QDict,
        start: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn qdict_array_split(src: *mut QDict, dst: *mut *mut QList);
}
extern "C" {
    pub fn qdict_array_entries(
        src: *mut QDict,
        subqdict: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qdict_crumple(src: *const QDict, errp: *mut *mut Error) -> *mut QObject;
}
extern "C" {
    pub fn qdict_join(dest: *mut QDict, src: *mut QDict, overwrite: bool);
}
extern "C" {
    pub fn get_opt_name(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        p: *const ::std::os::raw::c_char,
        delim: ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn get_opt_value(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        p: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn get_next_param_value(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        tag: *const ::std::os::raw::c_char,
        pstr: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn get_param_value(
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_int,
        tag: *const ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn parse_option_size(
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        ret: *mut u64,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn has_help_option(param: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    pub fn is_valid_option_list(param: *const ::std::os::raw::c_char) -> bool;
}
pub const QemuOptType_QEMU_OPT_STRING: QemuOptType = 0;
pub const QemuOptType_QEMU_OPT_BOOL: QemuOptType = 1;
pub const QemuOptType_QEMU_OPT_NUMBER: QemuOptType = 2;
pub const QemuOptType_QEMU_OPT_SIZE: QemuOptType = 3;
pub type QemuOptType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QemuOptDesc {
    pub name: *const ::std::os::raw::c_char,
    pub type_: QemuOptType,
    pub help: *const ::std::os::raw::c_char,
    pub def_value_str: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug)]
pub struct QemuOptsList {
    pub name: *const ::std::os::raw::c_char,
    pub implied_opt_name: *const ::std::os::raw::c_char,
    pub merge_lists: bool,
    pub head: QemuOptsList__bindgen_ty_1,
    pub desc: __IncompleteArrayField<QemuOptDesc>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QemuOptsList__bindgen_ty_1 {
    pub tqh_first: *mut QemuOpts,
    pub tqh_last: *mut *mut QemuOpts,
}
extern "C" {
    pub fn qemu_opt_get(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qemu_opt_get_del(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " qemu_opt_has_help_opt:"]
    #[doc = " @opts: options to search for a help request"]
    #[doc = ""]
    #[doc = " Check whether the options specified by @opts include one of the"]
    #[doc = " standard strings which indicate that the user is asking for a"]
    #[doc = " list of the valid values for a command line option (as defined"]
    #[doc = " by is_help_option())."]
    #[doc = ""]
    #[doc = " Returns: true if @opts includes 'help' or equivalent."]
    pub fn qemu_opt_has_help_opt(opts: *mut QemuOpts) -> bool;
}
extern "C" {
    pub fn qemu_opt_find(opts: *mut QemuOpts, name: *const ::std::os::raw::c_char) -> *mut QemuOpt;
}
extern "C" {
    pub fn qemu_opt_get_bool(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        defval: bool,
    ) -> bool;
}
extern "C" {
    pub fn qemu_opt_get_number(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        defval: u64,
    ) -> u64;
}
extern "C" {
    pub fn qemu_opt_get_size(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        defval: u64,
    ) -> u64;
}
extern "C" {
    pub fn qemu_opt_get_bool_del(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        defval: bool,
    ) -> bool;
}
extern "C" {
    pub fn qemu_opt_get_number_del(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        defval: u64,
    ) -> u64;
}
extern "C" {
    pub fn qemu_opt_get_size_del(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        defval: u64,
    ) -> u64;
}
extern "C" {
    pub fn qemu_opt_unset(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_opt_set(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn qemu_opt_set_bool(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        val: bool,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn qemu_opt_set_number(
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
        val: i64,
        errp: *mut *mut Error,
    );
}
pub type qemu_opt_loopfunc = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn qemu_opt_foreach(
        opts: *mut QemuOpts,
        func: qemu_opt_loopfunc,
        opaque: *mut ::std::os::raw::c_void,
        errp: *mut *mut Error,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QemuOptsIter {
    pub opts: *mut QemuOpts,
    pub opt: *mut QemuOpt,
    pub name: *const ::std::os::raw::c_char,
}
extern "C" {
    pub fn qemu_opt_iter_init(
        iter: *mut QemuOptsIter,
        opts: *mut QemuOpts,
        name: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn qemu_opt_iter_next(iter: *mut QemuOptsIter) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qemu_opts_find(
        list: *mut QemuOptsList,
        id: *const ::std::os::raw::c_char,
    ) -> *mut QemuOpts;
}
extern "C" {
    pub fn qemu_opts_create(
        list: *mut QemuOptsList,
        id: *const ::std::os::raw::c_char,
        fail_if_exists: ::std::os::raw::c_int,
        errp: *mut *mut Error,
    ) -> *mut QemuOpts;
}
extern "C" {
    pub fn qemu_opts_reset(list: *mut QemuOptsList);
}
extern "C" {
    pub fn qemu_opts_loc_restore(opts: *mut QemuOpts);
}
extern "C" {
    pub fn qemu_opts_set(
        list: *mut QemuOptsList,
        id: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn qemu_opts_id(opts: *mut QemuOpts) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qemu_opts_set_id(opts: *mut QemuOpts, id: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn qemu_opts_del(opts: *mut QemuOpts);
}
extern "C" {
    pub fn qemu_opts_validate(opts: *mut QemuOpts, desc: *const QemuOptDesc, errp: *mut *mut Error);
}
extern "C" {
    pub fn qemu_opts_do_parse(
        opts: *mut QemuOpts,
        params: *const ::std::os::raw::c_char,
        firstname: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn qemu_opts_parse_noisily(
        list: *mut QemuOptsList,
        params: *const ::std::os::raw::c_char,
        permit_abbrev: bool,
    ) -> *mut QemuOpts;
}
extern "C" {
    pub fn qemu_opts_parse(
        list: *mut QemuOptsList,
        params: *const ::std::os::raw::c_char,
        permit_abbrev: bool,
        errp: *mut *mut Error,
    ) -> *mut QemuOpts;
}
extern "C" {
    pub fn qemu_opts_set_defaults(
        list: *mut QemuOptsList,
        params: *const ::std::os::raw::c_char,
        permit_abbrev: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn qemu_opts_from_qdict(
        list: *mut QemuOptsList,
        qdict: *const QDict,
        errp: *mut *mut Error,
    ) -> *mut QemuOpts;
}
extern "C" {
    pub fn qemu_opts_to_qdict(opts: *mut QemuOpts, qdict: *mut QDict) -> *mut QDict;
}
extern "C" {
    pub fn qemu_opts_absorb_qdict(opts: *mut QemuOpts, qdict: *mut QDict, errp: *mut *mut Error);
}
pub type qemu_opts_loopfunc = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        opts: *mut QemuOpts,
        errp: *mut *mut Error,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn qemu_opts_foreach(
        list: *mut QemuOptsList,
        func: qemu_opts_loopfunc,
        opaque: *mut ::std::os::raw::c_void,
        errp: *mut *mut Error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_opts_print(opts: *mut QemuOpts, sep: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn qemu_opts_print_help(list: *mut QemuOptsList);
}
extern "C" {
    pub fn qemu_opts_free(list: *mut QemuOptsList);
}
extern "C" {
    pub fn qemu_opts_append(dst: *mut QemuOptsList, list: *mut QemuOptsList) -> *mut QemuOptsList;
}
extern "C" {
    pub fn keyval_parse(
        params: *const ::std::os::raw::c_char,
        implied_key: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> *mut QDict;
}
extern "C" {
    pub fn qemu_get_timedate(tm: *mut tm, offset: ::std::os::raw::c_int);
}
extern "C" {
    pub fn qemu_timedate_diff(tm: *mut tm) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_oom_check(ptr: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qemu_write_full(
        fd: ::std::os::raw::c_int,
        buf: *const ::std::os::raw::c_void,
        count: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn qemu_pipe(pipefd: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_openpty_raw(
        aslave: *mut ::std::os::raw::c_int,
        pty_name: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcg_exec_init(tb_size: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn tcg_enabled() -> bool;
}
extern "C" {
    pub fn cpu_exec_init_all();
}
extern "C" {
    pub fn cpu_exec_step_atomic(cpu: *mut CPUState);
}
extern "C" {
    #[doc = " set_preferred_target_page_bits:"]
    #[doc = " @bits: number of bits needed to represent an address within the page"]
    #[doc = ""]
    #[doc = " Set the preferred target page size (the actual target page"]
    #[doc = " size may be smaller than any given CPU's preference)."]
    #[doc = " Returns true on success, false on failure (which can only happen"]
    #[doc = " if this is called after the system has already finalized its"]
    #[doc = " choice of page size and the requested page size is smaller than that)."]
    pub fn set_preferred_target_page_bits(bits: ::std::os::raw::c_int) -> bool;
}
extern "C" {
    #[doc = " Sends a (part of) iovec down a socket, yielding when the socket is full, or"]
    #[doc = " Receives data into a (part of) iovec from a socket,"]
    #[doc = " yielding when there is no data in the socket."]
    #[doc = " The same interface as qemu_sendv_recvv(), with added yielding."]
    #[doc = " XXX should mark these as coroutine_fn"]
    pub fn qemu_co_sendv_recvv(
        sockfd: ::std::os::raw::c_int,
        iov: *mut iovec,
        iov_cnt: ::std::os::raw::c_uint,
        offset: size_t,
        bytes: size_t,
        do_send: bool,
    ) -> ssize_t;
}
extern "C" {
    #[doc = " The same as above, but with just a single buffer"]
    pub fn qemu_co_send_recv(
        sockfd: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_void,
        bytes: size_t,
        do_send: bool,
    ) -> ssize_t;
}
extern "C" {
    pub fn qemu_progress_init(enabled: ::std::os::raw::c_int, min_skip: f32);
}
extern "C" {
    pub fn qemu_progress_end();
}
extern "C" {
    pub fn qemu_progress_print(delta: f32, max: ::std::os::raw::c_int);
}
extern "C" {
    pub fn qemu_get_vm_name() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn qemu_find_file(
        type_: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn os_setup_early_signal_handling();
}
extern "C" {
    pub fn os_find_datadir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn os_parse_cmd_args(index: ::std::os::raw::c_int, optarg: *const ::std::os::raw::c_char);
}
pub const module_init_type_MODULE_INIT_BLOCK: module_init_type = 0;
pub const module_init_type_MODULE_INIT_OPTS: module_init_type = 1;
pub const module_init_type_MODULE_INIT_QOM: module_init_type = 2;
pub const module_init_type_MODULE_INIT_TRACE: module_init_type = 3;
pub const module_init_type_MODULE_INIT_MAX: module_init_type = 4;
pub type module_init_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn register_module_init(
        fn_: ::std::option::Option<unsafe extern "C" fn()>,
        type_: module_init_type,
    );
}
extern "C" {
    pub fn register_dso_module_init(
        fn_: ::std::option::Option<unsafe extern "C" fn()>,
        type_: module_init_type,
    );
}
extern "C" {
    pub fn module_call_init(type_: module_init_type);
}
extern "C" {
    pub fn module_load_one(
        prefix: *const ::std::os::raw::c_char,
        lib_name: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn qemu_hexdump(
        buf: *const ::std::os::raw::c_char,
        fp: *mut FILE,
        prefix: *const ::std::os::raw::c_char,
        size: size_t,
    );
}
extern "C" {
    pub fn parse_debug_env(
        name: *const ::std::os::raw::c_char,
        max: ::std::os::raw::c_int,
        initial: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qemu_ether_ntoa(mac: *const MACAddr) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn page_size_init();
}
extern "C" {
    pub fn dump_in_progress() -> bool;
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__0 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__0 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__1 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__2 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__2 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__3 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__4 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__4 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__5 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__5 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__6 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__6 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__7 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__7 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__8 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__9 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__9 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__10 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__10 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__11 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__11 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__12 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__12 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__13 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__13 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__14 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__14 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__15 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__15 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__16 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__16 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__17 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__17 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__18 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__18 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__19 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__19 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__20 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__20 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__21 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__21 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__22 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__22 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__23 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__23 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__24 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__24 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__25 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__25 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__26 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__26 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__27 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__27 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__28 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__28 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__29 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__29 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__30 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__30 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__31 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__31 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__32 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__32 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__33 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__33 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__34 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__34 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__35 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__35 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__36 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__36 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__37 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__37 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__38 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__38 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__39 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__39 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__40 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__40 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__41 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__41 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__42 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__42 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__43 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__43 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__44 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__44 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__45 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__45 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_build_bug_on__46 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl qemu_build_bug_on__46 {
    #[inline]
    pub fn new_bitfield_1() -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
    }
}
pub type flag = u8;
pub const float_relation_less: ::std::os::raw::c_int = -1;
pub const float_relation_equal: ::std::os::raw::c_int = 0;
pub const float_relation_greater: ::std::os::raw::c_int = 1;
pub const float_relation_unordered: ::std::os::raw::c_int = 2;
pub type _bindgen_ty_33 = ::std::os::raw::c_int;
pub type float16 = u16;
pub type float32 = u32;
pub type float64 = u64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct floatx80 {
    pub low: u64,
    pub high: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float128 {
    pub low: u64,
    pub high: u64,
}
pub const float_tininess_after_rounding: ::std::os::raw::c_uint = 0;
pub const float_tininess_before_rounding: ::std::os::raw::c_uint = 1;
pub type _bindgen_ty_34 = ::std::os::raw::c_uint;
pub const float_round_nearest_even: ::std::os::raw::c_uint = 0;
pub const float_round_down: ::std::os::raw::c_uint = 1;
pub const float_round_up: ::std::os::raw::c_uint = 2;
pub const float_round_to_zero: ::std::os::raw::c_uint = 3;
pub const float_round_ties_away: ::std::os::raw::c_uint = 4;
pub const float_round_to_odd: ::std::os::raw::c_uint = 5;
pub type _bindgen_ty_35 = ::std::os::raw::c_uint;
pub const float_flag_invalid: ::std::os::raw::c_uint = 1;
pub const float_flag_divbyzero: ::std::os::raw::c_uint = 4;
pub const float_flag_overflow: ::std::os::raw::c_uint = 8;
pub const float_flag_underflow: ::std::os::raw::c_uint = 16;
pub const float_flag_inexact: ::std::os::raw::c_uint = 32;
pub const float_flag_input_denormal: ::std::os::raw::c_uint = 64;
pub const float_flag_output_denormal: ::std::os::raw::c_uint = 128;
pub type _bindgen_ty_36 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float_status {
    pub float_detect_tininess: ::std::os::raw::c_schar,
    pub float_rounding_mode: ::std::os::raw::c_schar,
    pub float_exception_flags: u8,
    pub floatx80_rounding_precision: ::std::os::raw::c_schar,
    pub flush_to_zero: flag,
    pub flush_inputs_to_zero: flag,
    pub default_nan_mode: flag,
    pub snan_bit_is_one: flag,
}
extern "C" {
    pub fn float_raise(flags: u8, status: *mut float_status);
}
extern "C" {
    pub fn float32_squash_input_denormal(a: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float64_squash_input_denormal(a: float64, status: *mut float_status) -> float64;
}
pub const float_muladd_negate_c: ::std::os::raw::c_uint = 1;
pub const float_muladd_negate_product: ::std::os::raw::c_uint = 2;
pub const float_muladd_negate_result: ::std::os::raw::c_uint = 4;
pub const float_muladd_halve_result: ::std::os::raw::c_uint = 8;
pub type _bindgen_ty_37 = ::std::os::raw::c_uint;
extern "C" {
    pub fn int32_to_float32(arg1: i32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn int32_to_float64(arg1: i32, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn uint32_to_float32(arg1: u32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn uint32_to_float64(arg1: u32, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn int32_to_floatx80(arg1: i32, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn int32_to_float128(arg1: i32, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn int64_to_float32(arg1: i64, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn int64_to_float64(arg1: i64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn int64_to_floatx80(arg1: i64, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn int64_to_float128(arg1: i64, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn uint64_to_float32(arg1: u64, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn uint64_to_float64(arg1: u64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn uint64_to_float128(arg1: u64, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float32_to_float16(arg1: float32, arg2: flag, status: *mut float_status) -> float16;
}
extern "C" {
    pub fn float16_to_float32(arg1: float16, arg2: flag, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float64_to_float16(a: float64, ieee: flag, status: *mut float_status) -> float16;
}
extern "C" {
    pub fn float16_to_float64(a: float16, ieee: flag, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float16_is_quiet_nan(arg1: float16, status: *mut float_status) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float16_is_signaling_nan(
        arg1: float16,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float16_maybe_silence_nan(arg1: float16, status: *mut float_status) -> float16;
}
extern "C" {
    pub fn float16_default_nan(status: *mut float_status) -> float16;
}
extern "C" {
    pub fn float32_to_int16(arg1: float32, status: *mut float_status) -> i16;
}
extern "C" {
    pub fn float32_to_uint16(arg1: float32, status: *mut float_status) -> u16;
}
extern "C" {
    pub fn float32_to_int16_round_to_zero(arg1: float32, status: *mut float_status) -> i16;
}
extern "C" {
    pub fn float32_to_uint16_round_to_zero(arg1: float32, status: *mut float_status) -> u16;
}
extern "C" {
    pub fn float32_to_int32(arg1: float32, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn float32_to_int32_round_to_zero(arg1: float32, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn float32_to_uint32(arg1: float32, status: *mut float_status) -> u32;
}
extern "C" {
    pub fn float32_to_uint32_round_to_zero(arg1: float32, status: *mut float_status) -> u32;
}
extern "C" {
    pub fn float32_to_int64(arg1: float32, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn float32_to_uint64(arg1: float32, status: *mut float_status) -> u64;
}
extern "C" {
    pub fn float32_to_uint64_round_to_zero(arg1: float32, status: *mut float_status) -> u64;
}
extern "C" {
    pub fn float32_to_int64_round_to_zero(arg1: float32, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn float32_to_float64(arg1: float32, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float32_to_floatx80(arg1: float32, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn float32_to_float128(arg1: float32, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float32_round_to_int(arg1: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_add(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_sub(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_mul(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_div(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_rem(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_muladd(
        arg1: float32,
        arg2: float32,
        arg3: float32,
        arg4: ::std::os::raw::c_int,
        status: *mut float_status,
    ) -> float32;
}
extern "C" {
    pub fn float32_sqrt(arg1: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_exp2(arg1: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_log2(arg1: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_eq(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_le(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_lt(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_unordered(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_eq_quiet(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_le_quiet(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_lt_quiet(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_unordered_quiet(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_compare(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_compare_quiet(
        arg1: float32,
        arg2: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_min(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_max(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_minnum(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_maxnum(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_minnummag(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_maxnummag(arg1: float32, arg2: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_is_quiet_nan(arg1: float32, status: *mut float_status) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_is_signaling_nan(
        arg1: float32,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float32_maybe_silence_nan(arg1: float32, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float32_scalbn(
        arg1: float32,
        arg2: ::std::os::raw::c_int,
        status: *mut float_status,
    ) -> float32;
}
extern "C" {
    pub fn float32_default_nan(status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float64_to_int16(arg1: float64, status: *mut float_status) -> i16;
}
extern "C" {
    pub fn float64_to_uint16(arg1: float64, status: *mut float_status) -> u16;
}
extern "C" {
    pub fn float64_to_int16_round_to_zero(arg1: float64, status: *mut float_status) -> i16;
}
extern "C" {
    pub fn float64_to_uint16_round_to_zero(arg1: float64, status: *mut float_status) -> u16;
}
extern "C" {
    pub fn float64_to_int32(arg1: float64, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn float64_to_int32_round_to_zero(arg1: float64, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn float64_to_uint32(arg1: float64, status: *mut float_status) -> u32;
}
extern "C" {
    pub fn float64_to_uint32_round_to_zero(arg1: float64, status: *mut float_status) -> u32;
}
extern "C" {
    pub fn float64_to_int64(arg1: float64, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn float64_to_int64_round_to_zero(arg1: float64, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn float64_to_uint64(a: float64, status: *mut float_status) -> u64;
}
extern "C" {
    pub fn float64_to_uint64_round_to_zero(a: float64, status: *mut float_status) -> u64;
}
extern "C" {
    pub fn float64_to_float32(arg1: float64, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float64_to_floatx80(arg1: float64, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn float64_to_float128(arg1: float64, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float64_round_to_int(arg1: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_trunc_to_int(arg1: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_add(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_sub(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_mul(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_div(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_rem(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_muladd(
        arg1: float64,
        arg2: float64,
        arg3: float64,
        arg4: ::std::os::raw::c_int,
        status: *mut float_status,
    ) -> float64;
}
extern "C" {
    pub fn float64_sqrt(arg1: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_log2(arg1: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_eq(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_le(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_lt(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_unordered(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_eq_quiet(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_le_quiet(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_lt_quiet(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_unordered_quiet(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_compare(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_compare_quiet(
        arg1: float64,
        arg2: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_min(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_max(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_minnum(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_maxnum(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_minnummag(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_maxnummag(arg1: float64, arg2: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_is_quiet_nan(a: float64, status: *mut float_status) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_is_signaling_nan(
        arg1: float64,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float64_maybe_silence_nan(arg1: float64, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float64_scalbn(
        arg1: float64,
        arg2: ::std::os::raw::c_int,
        status: *mut float_status,
    ) -> float64;
}
extern "C" {
    pub fn float64_default_nan(status: *mut float_status) -> float64;
}
extern "C" {
    pub fn floatx80_to_int32(arg1: floatx80, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn floatx80_to_int32_round_to_zero(arg1: floatx80, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn floatx80_to_int64(arg1: floatx80, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn floatx80_to_int64_round_to_zero(arg1: floatx80, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn floatx80_to_float32(arg1: floatx80, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn floatx80_to_float64(arg1: floatx80, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn floatx80_to_float128(arg1: floatx80, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn floatx80_round_to_int(arg1: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_add(arg1: floatx80, arg2: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_sub(arg1: floatx80, arg2: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_mul(arg1: floatx80, arg2: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_div(arg1: floatx80, arg2: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_rem(arg1: floatx80, arg2: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_sqrt(arg1: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_eq(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_le(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_lt(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_unordered(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_eq_quiet(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_le_quiet(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_lt_quiet(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_unordered_quiet(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_compare(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_compare_quiet(
        arg1: floatx80,
        arg2: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_is_quiet_nan(
        arg1: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_is_signaling_nan(
        arg1: floatx80,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn floatx80_maybe_silence_nan(arg1: floatx80, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn floatx80_scalbn(
        arg1: floatx80,
        arg2: ::std::os::raw::c_int,
        status: *mut float_status,
    ) -> floatx80;
}
extern "C" {
    pub fn floatx80_default_nan(status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn float128_to_int32(arg1: float128, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn float128_to_int32_round_to_zero(arg1: float128, status: *mut float_status) -> i32;
}
extern "C" {
    pub fn float128_to_int64(arg1: float128, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn float128_to_int64_round_to_zero(arg1: float128, status: *mut float_status) -> i64;
}
extern "C" {
    pub fn float128_to_uint64(arg1: float128, status: *mut float_status) -> u64;
}
extern "C" {
    pub fn float128_to_uint64_round_to_zero(arg1: float128, status: *mut float_status) -> u64;
}
extern "C" {
    pub fn float128_to_uint32_round_to_zero(arg1: float128, status: *mut float_status) -> u32;
}
extern "C" {
    pub fn float128_to_float32(arg1: float128, status: *mut float_status) -> float32;
}
extern "C" {
    pub fn float128_to_float64(arg1: float128, status: *mut float_status) -> float64;
}
extern "C" {
    pub fn float128_to_floatx80(arg1: float128, status: *mut float_status) -> floatx80;
}
extern "C" {
    pub fn float128_round_to_int(arg1: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_add(arg1: float128, arg2: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_sub(arg1: float128, arg2: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_mul(arg1: float128, arg2: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_div(arg1: float128, arg2: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_rem(arg1: float128, arg2: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_sqrt(arg1: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_eq(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_le(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_lt(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_unordered(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_eq_quiet(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_le_quiet(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_lt_quiet(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_unordered_quiet(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_compare(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_compare_quiet(
        arg1: float128,
        arg2: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_is_quiet_nan(
        arg1: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_is_signaling_nan(
        arg1: float128,
        status: *mut float_status,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn float128_maybe_silence_nan(arg1: float128, status: *mut float_status) -> float128;
}
extern "C" {
    pub fn float128_scalbn(
        arg1: float128,
        arg2: ::std::os::raw::c_int,
        status: *mut float_status,
    ) -> float128;
}
extern "C" {
    pub fn float128_default_nan(status: *mut float_status) -> float128;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPU_FloatU {
    pub f: float32,
    pub l: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPU_DoubleU {
    pub d: float64,
    pub l: CPU_DoubleU__bindgen_ty_1,
    pub ll: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPU_DoubleU__bindgen_ty_1 {
    pub lower: u32,
    pub upper: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPU_LDoubleU {
    pub d: floatx80,
    pub l: CPU_LDoubleU__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPU_LDoubleU__bindgen_ty_1 {
    pub lower: u64,
    pub upper: u16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPU_QuadU {
    pub q: float128,
    pub l: CPU_QuadU__bindgen_ty_1,
    pub ll: CPU_QuadU__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPU_QuadU__bindgen_ty_1 {
    pub lowest: u32,
    pub lower: u32,
    pub upper: u32,
    pub upmost: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPU_QuadU__bindgen_ty_2 {
    pub lower: u64,
    pub upper: u64,
}
extern "C" {
    #[doc = " urshift - 128-bit Unsigned Right Shift."]
    #[doc = " @plow: in/out - lower 64-bit integer."]
    #[doc = " @phigh: in/out - higher 64-bit integer."]
    #[doc = " @shift: in - bytes to shift, between 0 and 127."]
    #[doc = ""]
    #[doc = " Result is zero-extended and stored in plow/phigh, which are"]
    #[doc = " input/output variables. Shift values outside the range will"]
    #[doc = " be mod to 128. In other words, the caller is responsible to"]
    #[doc = " verify/assert both the shift range and plow/phigh pointers."]
    pub fn urshift(plow: *mut u64, phigh: *mut u64, shift: i32);
}
extern "C" {
    #[doc = " ulshift - 128-bit Unsigned Left Shift."]
    #[doc = " @plow: in/out - lower 64-bit integer."]
    #[doc = " @phigh: in/out - higher 64-bit integer."]
    #[doc = " @shift: in - bytes to shift, between 0 and 127."]
    #[doc = " @overflow: out - true if any 1-bit is shifted out."]
    #[doc = ""]
    #[doc = " Result is zero-extended and stored in plow/phigh, which are"]
    #[doc = " input/output variables. Shift values outside the range will"]
    #[doc = " be mod to 128. In other words, the caller is responsible to"]
    #[doc = " verify/assert both the shift range and plow/phigh pointers."]
    pub fn ulshift(plow: *mut u64, phigh: *mut u64, shift: i32, overflow: *mut bool);
}
extern "C" {
    #[doc = " find_last_bit - find the last set bit in a memory region"]
    #[doc = " @addr: The address to start the search at"]
    #[doc = " @size: The maximum size to search"]
    #[doc = ""]
    #[doc = " Returns the bit number of the first set bit, or size."]
    pub fn find_last_bit(
        addr: *const ::std::os::raw::c_ulong,
        size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    #[doc = " find_next_bit - find the next set bit in a memory region"]
    #[doc = " @addr: The address to base the search on"]
    #[doc = " @offset: The bitnumber to start searching at"]
    #[doc = " @size: The bitmap size in bits"]
    pub fn find_next_bit(
        addr: *const ::std::os::raw::c_ulong,
        size: ::std::os::raw::c_ulong,
        offset: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    #[doc = " find_next_zero_bit - find the next cleared bit in a memory region"]
    #[doc = " @addr: The address to base the search on"]
    #[doc = " @offset: The bitnumber to start searching at"]
    #[doc = " @size: The bitmap size in bits"]
    pub fn find_next_zero_bit(
        addr: *const ::std::os::raw::c_ulong,
        size: ::std::os::raw::c_ulong,
        offset: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn slow_bitmap_empty(
        bitmap: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn slow_bitmap_full(
        bitmap: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn slow_bitmap_equal(
        bitmap1: *const ::std::os::raw::c_ulong,
        bitmap2: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn slow_bitmap_complement(
        dst: *mut ::std::os::raw::c_ulong,
        src: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn slow_bitmap_and(
        dst: *mut ::std::os::raw::c_ulong,
        bitmap1: *const ::std::os::raw::c_ulong,
        bitmap2: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn slow_bitmap_or(
        dst: *mut ::std::os::raw::c_ulong,
        bitmap1: *const ::std::os::raw::c_ulong,
        bitmap2: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn slow_bitmap_xor(
        dst: *mut ::std::os::raw::c_ulong,
        bitmap1: *const ::std::os::raw::c_ulong,
        bitmap2: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn slow_bitmap_andnot(
        dst: *mut ::std::os::raw::c_ulong,
        bitmap1: *const ::std::os::raw::c_ulong,
        bitmap2: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn slow_bitmap_intersects(
        bitmap1: *const ::std::os::raw::c_ulong,
        bitmap2: *const ::std::os::raw::c_ulong,
        bits: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bitmap_set(
        map: *mut ::std::os::raw::c_ulong,
        i: ::std::os::raw::c_long,
        len: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn bitmap_set_atomic(
        map: *mut ::std::os::raw::c_ulong,
        i: ::std::os::raw::c_long,
        len: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn bitmap_clear(
        map: *mut ::std::os::raw::c_ulong,
        start: ::std::os::raw::c_long,
        nr: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn bitmap_test_and_clear_atomic(
        map: *mut ::std::os::raw::c_ulong,
        start: ::std::os::raw::c_long,
        nr: ::std::os::raw::c_long,
    ) -> bool;
}
extern "C" {
    pub fn bitmap_find_next_zero_area(
        map: *mut ::std::os::raw::c_ulong,
        size: ::std::os::raw::c_ulong,
        start: ::std::os::raw::c_ulong,
        nr: ::std::os::raw::c_ulong,
        align_mask: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeImpl {
    _unused: [u8; 0],
}
pub type Type = *mut TypeImpl;
#[doc = " ObjectPropertyAccessor:"]
#[doc = " @obj: the object that owns the property"]
#[doc = " @v: the visitor that contains the property data"]
#[doc = " @name: the name of the property"]
#[doc = " @opaque: the object property opaque"]
#[doc = " @errp: a pointer to an Error that is filled if getting/setting fails."]
#[doc = ""]
#[doc = " Called when trying to get/set a property."]
pub type ObjectPropertyAccessor = ::std::option::Option<
    unsafe extern "C" fn(
        obj: *mut Object,
        v: *mut Visitor,
        name: *const ::std::os::raw::c_char,
        opaque: *mut ::std::os::raw::c_void,
        errp: *mut *mut Error,
    ),
>;
#[doc = " ObjectPropertyResolve:"]
#[doc = " @obj: the object that owns the property"]
#[doc = " @opaque: the opaque registered with the property"]
#[doc = " @part: the name of the property"]
#[doc = ""]
#[doc = " Resolves the #Object corresponding to property @part."]
#[doc = ""]
#[doc = " The returned object can also be used as a starting point"]
#[doc = " to resolve a relative path starting with \"@part\"."]
#[doc = ""]
#[doc = " Returns: If @path is the path that led to @obj, the function"]
#[doc = " returns the #Object corresponding to \"@path/@part\"."]
#[doc = " If \"@path/@part\" is not a valid object path, it returns #NULL."]
pub type ObjectPropertyResolve = ::std::option::Option<
    unsafe extern "C" fn(
        obj: *mut Object,
        opaque: *mut ::std::os::raw::c_void,
        part: *const ::std::os::raw::c_char,
    ) -> *mut Object,
>;
#[doc = " ObjectPropertyRelease:"]
#[doc = " @obj: the object that owns the property"]
#[doc = " @name: the name of the property"]
#[doc = " @opaque: the opaque registered with the property"]
#[doc = ""]
#[doc = " Called when a property is removed from a object."]
pub type ObjectPropertyRelease = ::std::option::Option<
    unsafe extern "C" fn(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        opaque: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectProperty {
    pub name: *mut gchar,
    pub type_: *mut gchar,
    pub description: *mut gchar,
    pub get: ObjectPropertyAccessor,
    pub set: ObjectPropertyAccessor,
    pub resolve: ObjectPropertyResolve,
    pub release: ObjectPropertyRelease,
    pub opaque: *mut ::std::os::raw::c_void,
}
#[doc = " ObjectUnparent:"]
#[doc = " @obj: the object that is being removed from the composition tree"]
#[doc = ""]
#[doc = " Called when an object is being removed from the QOM composition tree."]
#[doc = " The function should remove any backlinks from children objects to @obj."]
pub type ObjectUnparent = ::std::option::Option<unsafe extern "C" fn(obj: *mut Object)>;
#[doc = " ObjectFree:"]
#[doc = " @obj: the object being freed"]
#[doc = ""]
#[doc = " Called when an object's last reference is removed."]
pub type ObjectFree = ::std::option::Option<unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void)>;
#[doc = " ObjectClass:"]
#[doc = ""]
#[doc = " The base for all classes.  The only thing that #ObjectClass contains is an"]
#[doc = " integer type handle."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectClass {
    pub type_: Type,
    pub interfaces: *mut GSList,
    pub object_cast_cache: [*const ::std::os::raw::c_char; 4usize],
    pub class_cast_cache: [*const ::std::os::raw::c_char; 4usize],
    pub unparent: ObjectUnparent,
    pub properties: *mut GHashTable,
}
#[doc = " Object:"]
#[doc = ""]
#[doc = " The base for all objects.  The first member of this object is a pointer to"]
#[doc = " a #ObjectClass.  Since C guarantees that the first member of a structure"]
#[doc = " always begins at byte 0 of that structure, as long as any sub-object places"]
#[doc = " its parent as the first member, we can cast directly to a #Object."]
#[doc = ""]
#[doc = " As a result, #Object contains a reference to the objects type as its"]
#[doc = " first member.  This allows identification of the real type of the object at"]
#[doc = " run time."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Object {
    pub klass: *mut ObjectClass,
    pub free: ObjectFree,
    pub properties: *mut GHashTable,
    pub ref_: u32,
    pub parent: *mut Object,
}
#[doc = " TypeInfo:"]
#[doc = " @name: The name of the type."]
#[doc = " @parent: The name of the parent type."]
#[doc = " @instance_size: The size of the object (derivative of #Object).  If"]
#[doc = "   @instance_size is 0, then the size of the object will be the size of the"]
#[doc = "   parent object."]
#[doc = " @instance_init: This function is called to initialize an object.  The parent"]
#[doc = "   class will have already been initialized so the type is only responsible"]
#[doc = "   for initializing its own members."]
#[doc = " @instance_post_init: This function is called to finish initialization of"]
#[doc = "   an object, after all @instance_init functions were called."]
#[doc = " @instance_finalize: This function is called during object destruction.  This"]
#[doc = "   is called before the parent @instance_finalize function has been called."]
#[doc = "   An object should only free the members that are unique to its type in this"]
#[doc = "   function."]
#[doc = " @abstract: If this field is true, then the class is considered abstract and"]
#[doc = "   cannot be directly instantiated."]
#[doc = " @class_size: The size of the class object (derivative of #ObjectClass)"]
#[doc = "   for this object.  If @class_size is 0, then the size of the class will be"]
#[doc = "   assumed to be the size of the parent class.  This allows a type to avoid"]
#[doc = "   implementing an explicit class type if they are not adding additional"]
#[doc = "   virtual functions."]
#[doc = " @class_init: This function is called after all parent class initialization"]
#[doc = "   has occurred to allow a class to set its default virtual method pointers."]
#[doc = "   This is also the function to use to override virtual methods from a parent"]
#[doc = "   class."]
#[doc = " @class_base_init: This function is called for all base classes after all"]
#[doc = "   parent class initialization has occurred, but before the class itself"]
#[doc = "   is initialized.  This is the function to use to undo the effects of"]
#[doc = "   memcpy from the parent class to the descendants."]
#[doc = " @class_finalize: This function is called during class destruction and is"]
#[doc = "   meant to release and dynamic parameters allocated by @class_init."]
#[doc = " @class_data: Data to pass to the @class_init, @class_base_init and"]
#[doc = "   @class_finalize functions.  This can be useful when building dynamic"]
#[doc = "   classes."]
#[doc = " @interfaces: The list of interfaces associated with this type.  This"]
#[doc = "   should point to a static array that's terminated with a zero filled"]
#[doc = "   element."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeInfo {
    pub name: *const ::std::os::raw::c_char,
    pub parent: *const ::std::os::raw::c_char,
    pub instance_size: size_t,
    pub instance_init: ::std::option::Option<unsafe extern "C" fn(obj: *mut Object)>,
    pub instance_post_init: ::std::option::Option<unsafe extern "C" fn(obj: *mut Object)>,
    pub instance_finalize: ::std::option::Option<unsafe extern "C" fn(obj: *mut Object)>,
    pub abstract_: bool,
    pub class_size: size_t,
    pub class_init: ::std::option::Option<
        unsafe extern "C" fn(klass: *mut ObjectClass, data: *mut ::std::os::raw::c_void),
    >,
    pub class_base_init: ::std::option::Option<
        unsafe extern "C" fn(klass: *mut ObjectClass, data: *mut ::std::os::raw::c_void),
    >,
    pub class_finalize: ::std::option::Option<
        unsafe extern "C" fn(klass: *mut ObjectClass, data: *mut ::std::os::raw::c_void),
    >,
    pub class_data: *mut ::std::os::raw::c_void,
    pub interfaces: *mut InterfaceInfo,
}
#[doc = " InterfaceInfo:"]
#[doc = " @type: The name of the interface."]
#[doc = ""]
#[doc = " The information associated with an interface."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InterfaceInfo {
    pub type_: *const ::std::os::raw::c_char,
}
#[doc = " InterfaceClass:"]
#[doc = " @parent_class: the base class"]
#[doc = ""]
#[doc = " The class for all interfaces.  Subclasses of this class should only add"]
#[doc = " virtual methods."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InterfaceClass {
    pub parent_class: ObjectClass,
    pub concrete_class: *mut ObjectClass,
    pub interface_type: Type,
}
extern "C" {
    #[doc = " object_new:"]
    #[doc = " @typename: The name of the type of the object to instantiate."]
    #[doc = ""]
    #[doc = " This function will initialize a new object using heap allocated memory."]
    #[doc = " The returned object has a reference count of 1, and will be freed when"]
    #[doc = " the last reference is dropped."]
    #[doc = ""]
    #[doc = " Returns: The newly allocated and instantiated object."]
    pub fn object_new(typename: *const ::std::os::raw::c_char) -> *mut Object;
}
extern "C" {
    #[doc = " object_new_with_props:"]
    #[doc = " @typename:  The name of the type of the object to instantiate."]
    #[doc = " @parent: the parent object"]
    #[doc = " @id: The unique ID of the object"]
    #[doc = " @errp: pointer to error object"]
    #[doc = " @...: list of property names and values"]
    #[doc = ""]
    #[doc = " This function will initialize a new object using heap allocated memory."]
    #[doc = " The returned object has a reference count of 1, and will be freed when"]
    #[doc = " the last reference is dropped."]
    #[doc = ""]
    #[doc = " The @id parameter will be used when registering the object as a"]
    #[doc = " child of @parent in the composition tree."]
    #[doc = ""]
    #[doc = " The variadic parameters are a list of pairs of (propname, propvalue)"]
    #[doc = " strings. The propname of %NULL indicates the end of the property"]
    #[doc = " list. If the object implements the user creatable interface, the"]
    #[doc = " object will be marked complete once all the properties have been"]
    #[doc = " processed."]
    #[doc = ""]
    #[doc = " <example>"]
    #[doc = "   <title>Creating an object with properties</title>"]
    #[doc = "   <programlisting>"]
    #[doc = "   Error *err = NULL;"]
    #[doc = "   Object *obj;"]
    #[doc = ""]
    #[doc = "   obj = object_new_with_props(TYPE_MEMORY_BACKEND_FILE,"]
    #[doc = "                               object_get_objects_root(),"]
    #[doc = "                               \"hostmem0\","]
    #[doc = "                               &err,"]
    #[doc = "                               \"share\", \"yes\","]
    #[doc = "                               \"mem-path\", \"/dev/shm/somefile\","]
    #[doc = "                               \"prealloc\", \"yes\","]
    #[doc = "                               \"size\", \"1048576\","]
    #[doc = "                               NULL);"]
    #[doc = ""]
    #[doc = "   if (!obj) {"]
    #[doc = "     g_printerr(\"Cannot create memory backend: %s\\n\","]
    #[doc = "                error_get_pretty(err));"]
    #[doc = "   }"]
    #[doc = "   </programlisting>"]
    #[doc = " </example>"]
    #[doc = ""]
    #[doc = " The returned object will have one stable reference maintained"]
    #[doc = " for as long as it is present in the object hierarchy."]
    #[doc = ""]
    #[doc = " Returns: The newly allocated, instantiated & initialized object."]
    pub fn object_new_with_props(
        typename: *const ::std::os::raw::c_char,
        parent: *mut Object,
        id: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
        ...
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_new_with_propv:"]
    #[doc = " @typename:  The name of the type of the object to instantiate."]
    #[doc = " @parent: the parent object"]
    #[doc = " @id: The unique ID of the object"]
    #[doc = " @errp: pointer to error object"]
    #[doc = " @vargs: list of property names and values"]
    #[doc = ""]
    #[doc = " See object_new_with_props() for documentation."]
    pub fn object_new_with_propv(
        typename: *const ::std::os::raw::c_char,
        parent: *mut Object,
        id: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
        vargs: *mut __va_list_tag,
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_set_props:"]
    #[doc = " @obj: the object instance to set properties on"]
    #[doc = " @errp: pointer to error object"]
    #[doc = " @...: list of property names and values"]
    #[doc = ""]
    #[doc = " This function will set a list of properties on an existing object"]
    #[doc = " instance."]
    #[doc = ""]
    #[doc = " The variadic parameters are a list of pairs of (propname, propvalue)"]
    #[doc = " strings. The propname of %NULL indicates the end of the property"]
    #[doc = " list."]
    #[doc = ""]
    #[doc = " <example>"]
    #[doc = "   <title>Update an object's properties</title>"]
    #[doc = "   <programlisting>"]
    #[doc = "   Error *err = NULL;"]
    #[doc = "   Object *obj = ...get / create object...;"]
    #[doc = ""]
    #[doc = "   obj = object_set_props(obj,"]
    #[doc = "                          &err,"]
    #[doc = "                          \"share\", \"yes\","]
    #[doc = "                          \"mem-path\", \"/dev/shm/somefile\","]
    #[doc = "                          \"prealloc\", \"yes\","]
    #[doc = "                          \"size\", \"1048576\","]
    #[doc = "                          NULL);"]
    #[doc = ""]
    #[doc = "   if (!obj) {"]
    #[doc = "     g_printerr(\"Cannot set properties: %s\\n\","]
    #[doc = "                error_get_pretty(err));"]
    #[doc = "   }"]
    #[doc = "   </programlisting>"]
    #[doc = " </example>"]
    #[doc = ""]
    #[doc = " The returned object will have one stable reference maintained"]
    #[doc = " for as long as it is present in the object hierarchy."]
    #[doc = ""]
    #[doc = " Returns: -1 on error, 0 on success"]
    pub fn object_set_props(obj: *mut Object, errp: *mut *mut Error, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " object_set_propv:"]
    #[doc = " @obj: the object instance to set properties on"]
    #[doc = " @errp: pointer to error object"]
    #[doc = " @vargs: list of property names and values"]
    #[doc = ""]
    #[doc = " See object_set_props() for documentation."]
    #[doc = ""]
    #[doc = " Returns: -1 on error, 0 on success"]
    pub fn object_set_propv(
        obj: *mut Object,
        errp: *mut *mut Error,
        vargs: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " object_initialize:"]
    #[doc = " @obj: A pointer to the memory to be used for the object."]
    #[doc = " @size: The maximum size available at @obj for the object."]
    #[doc = " @typename: The name of the type of the object to instantiate."]
    #[doc = ""]
    #[doc = " This function will initialize an object.  The memory for the object should"]
    #[doc = " have already been allocated.  The returned object has a reference count of 1,"]
    #[doc = " and will be finalized when the last reference is dropped."]
    pub fn object_initialize(
        obj: *mut ::std::os::raw::c_void,
        size: size_t,
        typename: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " object_dynamic_cast:"]
    #[doc = " @obj: The object to cast."]
    #[doc = " @typename: The @typename to cast to."]
    #[doc = ""]
    #[doc = " This function will determine if @obj is-a @typename.  @obj can refer to an"]
    #[doc = " object or an interface associated with an object."]
    #[doc = ""]
    #[doc = " Returns: This function returns @obj on success or #NULL on failure."]
    pub fn object_dynamic_cast(
        obj: *mut Object,
        typename: *const ::std::os::raw::c_char,
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_dynamic_cast_assert:"]
    #[doc = ""]
    #[doc = " See object_dynamic_cast() for a description of the parameters of this"]
    #[doc = " function.  The only difference in behavior is that this function asserts"]
    #[doc = " instead of returning #NULL on failure if QOM cast debugging is enabled."]
    #[doc = " This function is not meant to be called directly, but only through"]
    #[doc = " the wrapper macro OBJECT_CHECK."]
    pub fn object_dynamic_cast_assert(
        obj: *mut Object,
        typename: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_get_class:"]
    #[doc = " @obj: A derivative of #Object"]
    #[doc = ""]
    #[doc = " Returns: The #ObjectClass of the type associated with @obj."]
    pub fn object_get_class(obj: *mut Object) -> *mut ObjectClass;
}
extern "C" {
    #[doc = " object_get_typename:"]
    #[doc = " @obj: A derivative of #Object."]
    #[doc = ""]
    #[doc = " Returns: The QOM typename of @obj."]
    pub fn object_get_typename(obj: *mut Object) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " type_register_static:"]
    #[doc = " @info: The #TypeInfo of the new type."]
    #[doc = ""]
    #[doc = " @info and all of the strings it points to should exist for the life time"]
    #[doc = " that the type is registered."]
    #[doc = ""]
    #[doc = " Returns: 0 on failure, the new #Type on success."]
    pub fn type_register_static(info: *const TypeInfo) -> Type;
}
extern "C" {
    #[doc = " type_register:"]
    #[doc = " @info: The #TypeInfo of the new type"]
    #[doc = ""]
    #[doc = " Unlike type_register_static(), this call does not require @info or its"]
    #[doc = " string members to continue to exist after the call returns."]
    #[doc = ""]
    #[doc = " Returns: 0 on failure, the new #Type on success."]
    pub fn type_register(info: *const TypeInfo) -> Type;
}
extern "C" {
    #[doc = " object_class_dynamic_cast_assert:"]
    #[doc = " @klass: The #ObjectClass to attempt to cast."]
    #[doc = " @typename: The QOM typename of the class to cast to."]
    #[doc = ""]
    #[doc = " See object_class_dynamic_cast() for a description of the parameters"]
    #[doc = " of this function.  The only difference in behavior is that this function"]
    #[doc = " asserts instead of returning #NULL on failure if QOM cast debugging is"]
    #[doc = " enabled.  This function is not meant to be called directly, but only through"]
    #[doc = " the wrapper macros OBJECT_CLASS_CHECK and INTERFACE_CHECK."]
    pub fn object_class_dynamic_cast_assert(
        klass: *mut ObjectClass,
        typename: *const ::std::os::raw::c_char,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
    ) -> *mut ObjectClass;
}
extern "C" {
    #[doc = " object_class_dynamic_cast:"]
    #[doc = " @klass: The #ObjectClass to attempt to cast."]
    #[doc = " @typename: The QOM typename of the class to cast to."]
    #[doc = ""]
    #[doc = " Returns: If @typename is a class, this function returns @klass if"]
    #[doc = " @typename is a subtype of @klass, else returns #NULL."]
    #[doc = ""]
    #[doc = " If @typename is an interface, this function returns the interface"]
    #[doc = " definition for @klass if @klass implements it unambiguously; #NULL"]
    #[doc = " is returned if @klass does not implement the interface or if multiple"]
    #[doc = " classes or interfaces on the hierarchy leading to @klass implement"]
    #[doc = " it.  (FIXME: perhaps this can be detected at type definition time?)"]
    pub fn object_class_dynamic_cast(
        klass: *mut ObjectClass,
        typename: *const ::std::os::raw::c_char,
    ) -> *mut ObjectClass;
}
extern "C" {
    #[doc = " object_class_get_parent:"]
    #[doc = " @klass: The class to obtain the parent for."]
    #[doc = ""]
    #[doc = " Returns: The parent for @klass or %NULL if none."]
    pub fn object_class_get_parent(klass: *mut ObjectClass) -> *mut ObjectClass;
}
extern "C" {
    #[doc = " object_class_get_name:"]
    #[doc = " @klass: The class to obtain the QOM typename for."]
    #[doc = ""]
    #[doc = " Returns: The QOM typename for @klass."]
    pub fn object_class_get_name(klass: *mut ObjectClass) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " object_class_is_abstract:"]
    #[doc = " @klass: The class to obtain the abstractness for."]
    #[doc = ""]
    #[doc = " Returns: %true if @klass is abstract, %false otherwise."]
    pub fn object_class_is_abstract(klass: *mut ObjectClass) -> bool;
}
extern "C" {
    #[doc = " object_class_by_name:"]
    #[doc = " @typename: The QOM typename to obtain the class for."]
    #[doc = ""]
    #[doc = " Returns: The class for @typename or %NULL if not found."]
    pub fn object_class_by_name(typename: *const ::std::os::raw::c_char) -> *mut ObjectClass;
}
extern "C" {
    pub fn object_class_foreach(
        fn_: ::std::option::Option<
            unsafe extern "C" fn(klass: *mut ObjectClass, opaque: *mut ::std::os::raw::c_void),
        >,
        implements_type: *const ::std::os::raw::c_char,
        include_abstract: bool,
        opaque: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " object_class_get_list:"]
    #[doc = " @implements_type: The type to filter for, including its derivatives."]
    #[doc = " @include_abstract: Whether to include abstract classes."]
    #[doc = ""]
    #[doc = " Returns: A singly-linked list of the classes in reverse hashtable order."]
    pub fn object_class_get_list(
        implements_type: *const ::std::os::raw::c_char,
        include_abstract: bool,
    ) -> *mut GSList;
}
extern "C" {
    #[doc = " object_ref:"]
    #[doc = " @obj: the object"]
    #[doc = ""]
    #[doc = " Increase the reference count of a object.  A object cannot be freed as long"]
    #[doc = " as its reference count is greater than zero."]
    pub fn object_ref(obj: *mut Object);
}
extern "C" {
    #[doc = " object_unref:"]
    #[doc = " @obj: the object"]
    #[doc = ""]
    #[doc = " Decrease the reference count of a object.  A object cannot be freed as long"]
    #[doc = " as its reference count is greater than zero."]
    pub fn object_unref(obj: *mut Object);
}
extern "C" {
    #[doc = " object_property_add:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property.  This can contain any character except for"]
    #[doc = "  a forward slash.  In general, you should use hyphens '-' instead of"]
    #[doc = "  underscores '_' when naming properties."]
    #[doc = " @type: the type name of the property.  This namespace is pretty loosely"]
    #[doc = "   defined.  Sub namespaces are constructed by using a prefix and then"]
    #[doc = "   to angle brackets.  For instance, the type 'virtio-net-pci' in the"]
    #[doc = "   'link' namespace would be 'link<virtio-net-pci>'."]
    #[doc = " @get: The getter to be called to read a property.  If this is NULL, then"]
    #[doc = "   the property cannot be read."]
    #[doc = " @set: the setter to be called to write a property.  If this is NULL,"]
    #[doc = "   then the property cannot be written."]
    #[doc = " @release: called when the property is removed from the object.  This is"]
    #[doc = "   meant to allow a property to free its opaque upon object"]
    #[doc = "   destruction.  This may be NULL."]
    #[doc = " @opaque: an opaque pointer to pass to the callbacks for the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: The #ObjectProperty; this can be used to set the @resolve"]
    #[doc = " callback for child and link properties."]
    pub fn object_property_add(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        type_: *const ::std::os::raw::c_char,
        get: ObjectPropertyAccessor,
        set: ObjectPropertyAccessor,
        release: ObjectPropertyRelease,
        opaque: *mut ::std::os::raw::c_void,
        errp: *mut *mut Error,
    ) -> *mut ObjectProperty;
}
extern "C" {
    pub fn object_property_del(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        type_: *const ::std::os::raw::c_char,
        get: ObjectPropertyAccessor,
        set: ObjectPropertyAccessor,
        release: ObjectPropertyRelease,
        opaque: *mut ::std::os::raw::c_void,
        errp: *mut *mut Error,
    ) -> *mut ObjectProperty;
}
extern "C" {
    #[doc = " object_property_find:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Look up a property for an object and return its #ObjectProperty if found."]
    pub fn object_property_find(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> *mut ObjectProperty;
}
extern "C" {
    pub fn object_class_property_find(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> *mut ObjectProperty;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectPropertyIterator {
    pub nextclass: *mut ObjectClass,
    pub iter: GHashTableIter,
}
extern "C" {
    #[doc = " object_property_iter_init:"]
    #[doc = " @obj: the object"]
    #[doc = ""]
    #[doc = " Initializes an iterator for traversing all properties"]
    #[doc = " registered against an object instance, its class and all parent classes."]
    #[doc = ""]
    #[doc = " It is forbidden to modify the property list while iterating,"]
    #[doc = " whether removing or adding properties."]
    #[doc = ""]
    #[doc = " Typical usage pattern would be"]
    #[doc = ""]
    #[doc = " <example>"]
    #[doc = "   <title>Using object property iterators</title>"]
    #[doc = "   <programlisting>"]
    #[doc = "   ObjectProperty *prop;"]
    #[doc = "   ObjectPropertyIterator iter;"]
    #[doc = ""]
    #[doc = "   object_property_iter_init(&iter, obj);"]
    #[doc = "   while ((prop = object_property_iter_next(&iter))) {"]
    #[doc = "     ... do something with prop ..."]
    #[doc = "   }"]
    #[doc = "   </programlisting>"]
    #[doc = " </example>"]
    pub fn object_property_iter_init(iter: *mut ObjectPropertyIterator, obj: *mut Object);
}
extern "C" {
    #[doc = " object_property_iter_next:"]
    #[doc = " @iter: the iterator instance"]
    #[doc = ""]
    #[doc = " Return the next available property. If no further properties"]
    #[doc = " are available, a %NULL value will be returned and the @iter"]
    #[doc = " pointer should not be used again after this point without"]
    #[doc = " re-initializing it."]
    #[doc = ""]
    #[doc = " Returns: the next property, or %NULL when all properties"]
    #[doc = " have been traversed."]
    pub fn object_property_iter_next(iter: *mut ObjectPropertyIterator) -> *mut ObjectProperty;
}
extern "C" {
    pub fn object_unparent(obj: *mut Object);
}
extern "C" {
    #[doc = " object_property_get:"]
    #[doc = " @obj: the object"]
    #[doc = " @v: the visitor that will receive the property value.  This should be an"]
    #[doc = "   Output visitor and the data will be written with @name as the name."]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Reads a property from a object."]
    pub fn object_property_get(
        obj: *mut Object,
        v: *mut Visitor,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_set_str:"]
    #[doc = " @value: the value to be written to the property"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Writes a string value to a property."]
    pub fn object_property_set_str(
        obj: *mut Object,
        value: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_get_str:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: the value of the property, converted to a C string, or NULL if"]
    #[doc = " an error occurs (including when the property value is not a string)."]
    #[doc = " The caller should free the string."]
    pub fn object_property_get_str(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " object_property_set_link:"]
    #[doc = " @value: the value to be written to the property"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Writes an object's canonical path to a property."]
    pub fn object_property_set_link(
        obj: *mut Object,
        value: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_get_link:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: the value of the property, resolved from a path to an Object,"]
    #[doc = " or NULL if an error occurs (including when the property value is not a"]
    #[doc = " string or not a valid object path)."]
    pub fn object_property_get_link(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_property_set_bool:"]
    #[doc = " @value: the value to be written to the property"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Writes a bool value to a property."]
    pub fn object_property_set_bool(
        obj: *mut Object,
        value: bool,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_get_bool:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: the value of the property, converted to a boolean, or NULL if"]
    #[doc = " an error occurs (including when the property value is not a bool)."]
    pub fn object_property_get_bool(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> bool;
}
extern "C" {
    #[doc = " object_property_set_int:"]
    #[doc = " @value: the value to be written to the property"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Writes an integer value to a property."]
    pub fn object_property_set_int(
        obj: *mut Object,
        value: i64,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_get_int:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: the value of the property, converted to an integer, or negative if"]
    #[doc = " an error occurs (including when the property value is not an integer)."]
    pub fn object_property_get_int(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> i64;
}
extern "C" {
    #[doc = " object_property_get_enum:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @typename: the name of the enum data type"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: the value of the property, converted to an integer, or"]
    #[doc = " undefined if an error occurs (including when the property value is not"]
    #[doc = " an enum)."]
    pub fn object_property_get_enum(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        typename: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " object_property_get_uint16List:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @list: the returned int list"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns: the value of the property, converted to integers, or"]
    #[doc = " undefined if an error occurs (including when the property value is not"]
    #[doc = " an list of integers)."]
    pub fn object_property_get_uint16List(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        list: *mut *mut uint16List,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_set:"]
    #[doc = " @obj: the object"]
    #[doc = " @v: the visitor that will be used to write the property value.  This should"]
    #[doc = "   be an Input visitor and the data will be first read with @name as the"]
    #[doc = "   name and then written as the property value."]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Writes a property to a object."]
    pub fn object_property_set(
        obj: *mut Object,
        v: *mut Visitor,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_parse:"]
    #[doc = " @obj: the object"]
    #[doc = " @string: the string that will be used to parse the property value."]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Parses a string and writes the result into a property of an object."]
    pub fn object_property_parse(
        obj: *mut Object,
        string: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_print:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @human: if true, print for human consumption"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns a string representation of the value of the property.  The"]
    #[doc = " caller shall free the string."]
    pub fn object_property_print(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        human: bool,
        errp: *mut *mut Error,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " object_property_get_type:"]
    #[doc = " @obj: the object"]
    #[doc = " @name: the name of the property"]
    #[doc = " @errp: returns an error if this function fails"]
    #[doc = ""]
    #[doc = " Returns:  The type name of the property."]
    pub fn object_property_get_type(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " object_get_root:"]
    #[doc = ""]
    #[doc = " Returns: the root object of the composition tree"]
    pub fn object_get_root() -> *mut Object;
}
extern "C" {
    #[doc = " object_get_objects_root:"]
    #[doc = ""]
    #[doc = " Get the container object that holds user created"]
    #[doc = " object instances. This is the object at path"]
    #[doc = " \"/objects\""]
    #[doc = ""]
    #[doc = " Returns: the user object container"]
    pub fn object_get_objects_root() -> *mut Object;
}
extern "C" {
    #[doc = " object_get_canonical_path_component:"]
    #[doc = ""]
    #[doc = " Returns: The final component in the object's canonical path.  The canonical"]
    #[doc = " path is the path within the composition tree starting from the root."]
    pub fn object_get_canonical_path_component(obj: *mut Object) -> *mut gchar;
}
extern "C" {
    #[doc = " object_get_canonical_path:"]
    #[doc = ""]
    #[doc = " Returns: The canonical path for a object.  This is the path within the"]
    #[doc = " composition tree starting from the root."]
    pub fn object_get_canonical_path(obj: *mut Object) -> *mut gchar;
}
extern "C" {
    #[doc = " object_resolve_path:"]
    #[doc = " @path: the path to resolve"]
    #[doc = " @ambiguous: returns true if the path resolution failed because of an"]
    #[doc = "   ambiguous match"]
    #[doc = ""]
    #[doc = " There are two types of supported paths--absolute paths and partial paths."]
    #[doc = ""]
    #[doc = " Absolute paths are derived from the root object and can follow child<> or"]
    #[doc = " link<> properties.  Since they can follow link<> properties, they can be"]
    #[doc = " arbitrarily long.  Absolute paths look like absolute filenames and are"]
    #[doc = " prefixed with a leading slash."]
    #[doc = ""]
    #[doc = " Partial paths look like relative filenames.  They do not begin with a"]
    #[doc = " prefix.  The matching rules for partial paths are subtle but designed to make"]
    #[doc = " specifying objects easy.  At each level of the composition tree, the partial"]
    #[doc = " path is matched as an absolute path.  The first match is not returned.  At"]
    #[doc = " least two matches are searched for.  A successful result is only returned if"]
    #[doc = " only one match is found.  If more than one match is found, a flag is"]
    #[doc = " returned to indicate that the match was ambiguous."]
    #[doc = ""]
    #[doc = " Returns: The matched object or NULL on path lookup failure."]
    pub fn object_resolve_path(
        path: *const ::std::os::raw::c_char,
        ambiguous: *mut bool,
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_resolve_path_type:"]
    #[doc = " @path: the path to resolve"]
    #[doc = " @typename: the type to look for."]
    #[doc = " @ambiguous: returns true if the path resolution failed because of an"]
    #[doc = "   ambiguous match"]
    #[doc = ""]
    #[doc = " This is similar to object_resolve_path.  However, when looking for a"]
    #[doc = " partial path only matches that implement the given type are considered."]
    #[doc = " This restricts the search and avoids spuriously flagging matches as"]
    #[doc = " ambiguous."]
    #[doc = ""]
    #[doc = " For both partial and absolute paths, the return value goes through"]
    #[doc = " a dynamic cast to @typename.  This is important if either the link,"]
    #[doc = " or the typename itself are of interface types."]
    #[doc = ""]
    #[doc = " Returns: The matched object or NULL on path lookup failure."]
    pub fn object_resolve_path_type(
        path: *const ::std::os::raw::c_char,
        typename: *const ::std::os::raw::c_char,
        ambiguous: *mut bool,
    ) -> *mut Object;
}
extern "C" {
    #[doc = " object_resolve_path_component:"]
    #[doc = " @parent: the object in which to resolve the path"]
    #[doc = " @part: the component to resolve."]
    #[doc = ""]
    #[doc = " This is similar to object_resolve_path with an absolute path, but it"]
    #[doc = " only resolves one element (@part) and takes the others from @parent."]
    #[doc = ""]
    #[doc = " Returns: The resolved object or NULL on path lookup failure."]
    pub fn object_resolve_path_component(parent: *mut Object, part: *const gchar) -> *mut Object;
}
extern "C" {
    #[doc = " object_property_add_child:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @child: the child object"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the area"]
    #[doc = ""]
    #[doc = " Child properties form the composition tree.  All objects need to be a child"]
    #[doc = " of another object.  Objects can only be a child of one object."]
    #[doc = ""]
    #[doc = " There is no way for a child to determine what its parent is.  It is not"]
    #[doc = " a bidirectional relationship.  This is by design."]
    #[doc = ""]
    #[doc = " The value of a child property as a C string will be the child object's"]
    #[doc = " canonical path. It can be retrieved using object_property_get_str()."]
    #[doc = " The child object itself can be retrieved using object_property_get_link()."]
    pub fn object_property_add_child(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        child: *mut Object,
        errp: *mut *mut Error,
    );
}
pub const ObjectPropertyLinkFlags_OBJ_PROP_LINK_UNREF_ON_RELEASE: ObjectPropertyLinkFlags = 1;
pub type ObjectPropertyLinkFlags = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " object_property_allow_set_link:"]
    #[doc = ""]
    #[doc = " The default implementation of the object_property_add_link() check()"]
    #[doc = " callback function.  It allows the link property to be set and never returns"]
    #[doc = " an error."]
    pub fn object_property_allow_set_link(
        arg1: *mut Object,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut Object,
        arg4: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_link:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @type: the qobj type of the link"]
    #[doc = " @child: a pointer to where the link object reference is stored"]
    #[doc = " @check: callback to veto setting or NULL if the property is read-only"]
    #[doc = " @flags: additional options for the link"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the area"]
    #[doc = ""]
    #[doc = " Links establish relationships between objects.  Links are unidirectional"]
    #[doc = " although two links can be combined to form a bidirectional relationship"]
    #[doc = " between objects."]
    #[doc = ""]
    #[doc = " Links form the graph in the object model."]
    #[doc = ""]
    #[doc = " The <code>@check()</code> callback is invoked when"]
    #[doc = " object_property_set_link() is called and can raise an error to prevent the"]
    #[doc = " link being set.  If <code>@check</code> is NULL, the property is read-only"]
    #[doc = " and cannot be set."]
    #[doc = ""]
    #[doc = " Ownership of the pointer that @child points to is transferred to the"]
    #[doc = " link property.  The reference count for <code>*@child</code> is"]
    #[doc = " managed by the property from after the function returns till the"]
    #[doc = " property is deleted with object_property_del().  If the"]
    #[doc = " <code>@flags</code> <code>OBJ_PROP_LINK_UNREF_ON_RELEASE</code> bit is set,"]
    #[doc = " the reference count is decremented when the property is deleted."]
    pub fn object_property_add_link(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        type_: *const ::std::os::raw::c_char,
        child: *mut *mut Object,
        check: ::std::option::Option<
            unsafe extern "C" fn(
                obj: *mut Object,
                name: *const ::std::os::raw::c_char,
                val: *mut Object,
                errp: *mut *mut Error,
            ),
        >,
        flags: ObjectPropertyLinkFlags,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_str:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @get: the getter or NULL if the property is write-only.  This function must"]
    #[doc = "   return a string to be freed by g_free()."]
    #[doc = " @set: the setter or NULL if the property is read-only"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add a string property using getters/setters.  This function will add a"]
    #[doc = " property of type 'string'."]
    pub fn object_property_add_str(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut Object,
                arg2: *mut *mut Error,
            ) -> *mut ::std::os::raw::c_char,
        >,
        set: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut Object,
                arg2: *const ::std::os::raw::c_char,
                arg3: *mut *mut Error,
            ),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_str(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut Object,
                arg2: *mut *mut Error,
            ) -> *mut ::std::os::raw::c_char,
        >,
        set: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut Object,
                arg2: *const ::std::os::raw::c_char,
                arg3: *mut *mut Error,
            ),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_bool:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @get: the getter or NULL if the property is write-only."]
    #[doc = " @set: the setter or NULL if the property is read-only"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add a bool property using getters/setters.  This function will add a"]
    #[doc = " property of type 'bool'."]
    pub fn object_property_add_bool(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: *mut *mut Error) -> bool,
        >,
        set: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: bool, arg3: *mut *mut Error),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_bool(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: *mut *mut Error) -> bool,
        >,
        set: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: bool, arg3: *mut *mut Error),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_enum:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @typename: the name of the enum data type"]
    #[doc = " @get: the getter or %NULL if the property is write-only."]
    #[doc = " @set: the setter or %NULL if the property is read-only"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an enum property using getters/setters.  This function will add a"]
    #[doc = " property of type '@typename'."]
    pub fn object_property_add_enum(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        typename: *const ::std::os::raw::c_char,
        strings: *const *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: *mut *mut Error) -> ::std::os::raw::c_int,
        >,
        set: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut Object,
                arg2: ::std::os::raw::c_int,
                arg3: *mut *mut Error,
            ),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_enum(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        typename: *const ::std::os::raw::c_char,
        strings: *const *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: *mut *mut Error) -> ::std::os::raw::c_int,
        >,
        set: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut Object,
                arg2: ::std::os::raw::c_int,
                arg3: *mut *mut Error,
            ),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_tm:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @get: the getter or NULL if the property is write-only."]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add a read-only struct tm valued property using a getter function."]
    #[doc = " This function will add a property of type 'struct tm'."]
    pub fn object_property_add_tm(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: *mut tm, arg3: *mut *mut Error),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_tm(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        get: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut Object, arg2: *mut tm, arg3: *mut *mut Error),
        >,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_uint8_ptr:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @v: pointer to value"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an integer property in memory.  This function will add a"]
    #[doc = " property of type 'uint8'."]
    pub fn object_property_add_uint8_ptr(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        v: *const u8,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_uint8_ptr(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        v: *const u8,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_uint16_ptr:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @v: pointer to value"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an integer property in memory.  This function will add a"]
    #[doc = " property of type 'uint16'."]
    pub fn object_property_add_uint16_ptr(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        v: *const u16,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_uint16_ptr(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        v: *const u16,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_uint32_ptr:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @v: pointer to value"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an integer property in memory.  This function will add a"]
    #[doc = " property of type 'uint32'."]
    pub fn object_property_add_uint32_ptr(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        v: *const u32,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_uint32_ptr(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        v: *const u32,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_uint64_ptr:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @v: pointer to value"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an integer property in memory.  This function will add a"]
    #[doc = " property of type 'uint64'."]
    pub fn object_property_add_uint64_ptr(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        v: *const u64,
        Errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_add_uint64_ptr(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        v: *const u64,
        Errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_alias:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @target_obj: the object to forward property access to"]
    #[doc = " @target_name: the name of the property on the forwarded object"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an alias for a property on an object.  This function will add a property"]
    #[doc = " of the same type as the forwarded property."]
    #[doc = ""]
    #[doc = " The caller must ensure that <code>@target_obj</code> stays alive as long as"]
    #[doc = " this property exists.  In the case of a child object or an alias on the same"]
    #[doc = " object this will be the case.  For aliases to other objects the caller is"]
    #[doc = " responsible for taking a reference."]
    pub fn object_property_add_alias(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        target_obj: *mut Object,
        target_name: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_add_const_link:"]
    #[doc = " @obj: the object to add a property to"]
    #[doc = " @name: the name of the property"]
    #[doc = " @target: the object to be referred by the link"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Add an unmodifiable link for a property on an object.  This function will"]
    #[doc = " add a property of type link<TYPE> where TYPE is the type of @target."]
    #[doc = ""]
    #[doc = " The caller must ensure that @target stays alive as long as"]
    #[doc = " this property exists.  In the case @target is a child of @obj,"]
    #[doc = " this will be the case.  Otherwise, the caller is responsible for"]
    #[doc = " taking a reference."]
    pub fn object_property_add_const_link(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        target: *mut Object,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_property_set_description:"]
    #[doc = " @obj: the object owning the property"]
    #[doc = " @name: the name of the property"]
    #[doc = " @description: the description of the property on the object"]
    #[doc = " @errp: if an error occurs, a pointer to an area to store the error"]
    #[doc = ""]
    #[doc = " Set an object property's description."]
    #[doc = ""]
    pub fn object_property_set_description(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        description: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    pub fn object_class_property_set_description(
        klass: *mut ObjectClass,
        name: *const ::std::os::raw::c_char,
        description: *const ::std::os::raw::c_char,
        errp: *mut *mut Error,
    );
}
extern "C" {
    #[doc = " object_child_foreach:"]
    #[doc = " @obj: the object whose children will be navigated"]
    #[doc = " @fn: the iterator function to be called"]
    #[doc = " @opaque: an opaque value that will be passed to the iterator"]
    #[doc = ""]
    #[doc = " Call @fn passing each child of @obj and @opaque to it, until @fn returns"]
    #[doc = " non-zero."]
    #[doc = ""]
    #[doc = " It is forbidden to add or remove children from @obj from the @fn"]
    #[doc = " callback."]
    #[doc = ""]
    #[doc = " Returns: The last value returned by @fn, or 0 if there is no child."]
    pub fn object_child_foreach(
        obj: *mut Object,
        fn_: ::std::option::Option<
            unsafe extern "C" fn(
                child: *mut Object,
                opaque: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        opaque: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " object_child_foreach_recursive:"]
    #[doc = " @obj: the object whose children will be navigated"]
    #[doc = " @fn: the iterator function to be called"]
    #[doc = " @opaque: an opaque value that will be passed to the iterator"]
    #[doc = ""]
    #[doc = " Call @fn passing each child of @obj and @opaque to it, until @fn returns"]
    #[doc = " non-zero. Calls recursively, all child nodes of @obj will also be passed"]
    #[doc = " all the way down to the leaf nodes of the tree. Depth first ordering."]
    #[doc = ""]
    #[doc = " It is forbidden to add or remove children from @obj (or its"]
    #[doc = " child nodes) from the @fn callback."]
    #[doc = ""]
    #[doc = " Returns: The last value returned by @fn, or 0 if there is no child."]
    pub fn object_child_foreach_recursive(
        obj: *mut Object,
        fn_: ::std::option::Option<
            unsafe extern "C" fn(
                child: *mut Object,
                opaque: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        opaque: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " container_get:"]
    #[doc = " @root: root of the #path, e.g., object_get_root()"]
    #[doc = " @path: path to the container"]
    #[doc = ""]
    #[doc = " Return a container object whose path is @path.  Create more containers"]
    #[doc = " along the path if necessary."]
    #[doc = ""]
    #[doc = " Returns: the container object."]
    pub fn container_get(root: *mut Object, path: *const ::std::os::raw::c_char) -> *mut Object;
}
extern "C" {
    #[doc = " object_type_get_instance_size:"]
    #[doc = " @typename: Name of the Type whose instance_size is required"]
    #[doc = ""]
    #[doc = " Returns the instance_size of the given @typename."]
    pub fn object_type_get_instance_size(typename: *const ::std::os::raw::c_char) -> size_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IRQState {
    _unused: [u8; 0],
}
pub type qemu_irq = *mut IRQState;
pub type qemu_irq_handler = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        n: ::std::os::raw::c_int,
        level: ::std::os::raw::c_int,
    ),
>;
extern "C" {
    pub fn qemu_set_irq(irq: qemu_irq, level: ::std::os::raw::c_int);
}
extern "C" {
    pub fn qemu_all