fn main() {
    #[cfg(feature = "c-bindings")]
    {
        use std::{env, path::Path};

        let crate_dir = env::var("CARGO_MANIFEST_DIR").unwrap();

        let out = if Path::new("../Cargo.toml").exists() {
            Path::new("../target")
                .join(env::var("TARGET").unwrap())
                .join("channel.h")
        } else {
            Path::new("target")
                .join(env::var("TARGET").unwrap())
                .join("channel.h")
        };

        cbindgen::Builder::new()
            .with_language(cbindgen::Language::C)
            .with_crate(crate_dir)
            .generate()
            .expect("Unable to generate bindings")
            .write_to_file(out);
    }
}
