#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

extern "C" {

/// Output a debug string to the hypervisor
void output_debug_string(const uint8_t *s, uintptr_t len);

/// Gets the main channel for a plugin of a given name, returning -1 if the plugin wasn't found
int32_t get_main_channel(const uint8_t *name, uintptr_t len);

/// Read from a channel descriptor into a buffer
uintptr_t channel_read(uint32_t channel, uint8_t *out, uintptr_t out_len);

/// Write a buffer to a given channel descriptor
void channel_write(uint32_t channel, const uint8_t *buf, uintptr_t buf_len);

} // extern "C"
