# panda-channels

A Rust library (with C bindings) for communicating with the hypervisor via hypercalls
in a channel-like manner. Primarily intended for use with the guest plugin API.

### C API Documentation

```c
/**
 * Initialize the channel library, should be run at the start of main() in your guest plu
 */
void hyperchannel_init(void);

/**
 * Uninitialize the channel library, should be run at the end of main() in your guest plu
 */
void hyperchannel_uninit(void);

/**
 * Read from a channel descriptor into a buffer
 *
 * Returns: the number of bytes read into the buffer.
 */
uintptr_t channel_read(uint32_t channel, uint8_t *out, uintptr_t out_len);

/**
 * Write a buffer to a given channel descriptor
 */
void channel_write(uint32_t channel, const uint8_t *buf, uintptr_t buf_len);

/**
 * Gets the main channel for a plugin of a given name
 *
 * Returns: the number of bytes read into the buffer, or -1 if the plugin wasn't found
 */
int32_t get_main_channel(const uint8_t *name, uintptr_t len);

/**
 * Get a new channel not associated with any specific plugin
 *
 * Returns: the channel, or -1 if an error occurs
 */
int32_t get_new_channel(void);
```
