use std::io::{self, Write};

pub use termcolor::Color;
use termcolor::{ColorChoice, ColorSpec, StandardStream, WriteColor};

#[macro_export]
macro_rules! println_bg {
    ($color:expr, $($args:expr),+) => {
        printbg((format!($($args),+)+"\n").as_str(),$color).unwrap();
    };
}

#[macro_export]
macro_rules! println_fg {
    ($color:expr, $($args:expr),+) => {
        printfg((format!($($args),+)+"\n").as_str(),$color).unwrap();
    };
}

#[macro_export]
macro_rules! print_bg {
    ($color:expr, $($args:expr),+) => {
        printbg(format!($($args),+).as_str(),$color).unwrap();
    };
}

#[macro_export]
macro_rules! print_fg {
    ($color:expr, $($args:expr),+) => {
        printfg(format!($($args),+).as_str(),$color).unwrap();
    };
}

pub fn printbg(out: &str, color: Color) -> io::Result<()> {
    let mut stdout = StandardStream::stdout(ColorChoice::Always);
    stdout.set_color(ColorSpec::new().set_bg(Some(color)))?;
    write!(&mut stdout, "{}", out)?;
    stdout.reset()?;
    Ok(())
}

pub fn printfg(out: &str, color: Color) -> io::Result<()> {
    let mut stdout = StandardStream::stdout(ColorChoice::Always);
    stdout.set_color(ColorSpec::new().set_fg(Some(color)))?;
    write!(&mut stdout, "{}", out)?;
    stdout.reset()?;
    Ok(())
}
