use crate::{mock::*, Error};
use frame_support::{assert_noop, assert_ok, traits::OnInitialize};

fn initialize_block(block: u64) {
	System::set_block_number(block);
	Scheduler::on_initialize(block);
}

#[test]
fn it_works_for_enter_pair() {
	new_test_ext().execute_with(|| {
		assert_ok!(Pair::pair(Origin::signed(1), 1234));
		assert_eq!(Pair::pair_list(1234), Some(1));
	});
}

#[test]
fn it_works_for_repeat() {
	new_test_ext().execute_with(|| {
		assert_ok!(Pair::pair(Origin::signed(1), 1234));
		assert_noop!(Pair::pair(Origin::signed(1), 1234), Error::<Test>::Repeat);
		assert_eq!(Pair::pair_list(1234), Some(1));
	});
}

#[test]
fn it_works_for_finish_pair() {
	new_test_ext().execute_with(|| {
		assert_ok!(Pair::pair(Origin::signed(1), 1234));
		assert_eq!(Pair::pair_list(1234), Some(1));
		assert_ok!(Pair::pair(Origin::signed(2), 1234));
		assert_eq!(Pair::pair_list(1234), None);
	});
}

#[test]
fn it_works_for_cancel_pair() {
	new_test_ext().execute_with(|| {
		assert_ok!(Pair::pair(Origin::signed(1), 1234));
		assert_eq!(Pair::pair_list(1234), Some(1));
		assert_ok!(Pair::cancel(Origin::signed(2), 1234));
		assert_eq!(Pair::pair_list(1234), Some(1));
		assert_ok!(Pair::cancel(Origin::signed(1), 1234));
		assert_eq!(Pair::pair_list(1234), None);
	});
}

#[test]
fn it_works_for_timeout() {
	new_test_ext().execute_with(|| {
		assert_ok!(Pair::pair(Origin::signed(1), 1234));
		assert_eq!(Pair::pair_list(1234), Some(1));
		initialize_block(1);
		assert_eq!(Pair::pair_list(1234), Some(1));
		initialize_block(2);
		assert_eq!(Pair::pair_list(1234), None);
	});
}
