//! Benchmarking setup for pallet-template

use super::*;

use frame_benchmarking::{benchmarks, impl_benchmark_test_suite, whitelisted_caller};
use frame_system::RawOrigin;
use sp_std::{boxed::Box, vec, vec::Vec};

#[allow(unused)]
use crate::Module as Pair;

benchmarks! {
	pair {
		let pin in 0 .. 100;
		let caller: T::AccountId = whitelisted_caller();
	}: _(RawOrigin::Signed(caller), pin)
	verify {
		assert_eq!(Something::<T>::get(), Some(pin));
	}
}

impl_benchmark_test_suite!(Pair, crate::mock::new_test_ext(), crate::mock::Test,);
