//! Autogenerated weights for pallet_logion_loc
//!
//! The [original template](https://github.com/paritytech/substrate/blob/630422d6108cbaaca893ab213dde69f3bdaa1f6b/.maintain/frame-weight-template.hbs)
//! was disclosed under [Apache 2.0 license](http://www.apache.org/licenses/LICENSE-2.0).
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 3.0.0
//! DATE: 2022-02-08, STEPS: `[20, ]`, REPEAT: 10, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! EXECUTION: Some(Wasm), WASM-EXECUTION: Compiled, CHAIN: None, DB CACHE: 128

// Executed Command:
// ./target/release/logion-node
// benchmark
// --execution
// wasm
// --wasm-execution
// compiled
// --pallet
// pallet_logion_loc
// --extrinsic
// *
// --steps
// 20
// --repeat
// 10
// --output
// ./pallets/logion_loc/src/weights.rs
// --template
// ./scripts/weights-template.hbs


#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]

use frame_support::{traits::Get, weights::{Weight, constants::RocksDbWeight}};
use sp_std::marker::PhantomData;

/// Weight functions needed for pallet_logion_loc.
pub trait WeightInfo {
	fn create_polkadot_identity_loc() -> Weight;
	fn create_logion_identity_loc() -> Weight;
	fn create_polkadot_transaction_loc() -> Weight;
	fn create_logion_transaction_loc() -> Weight;
	fn add_metadata() -> Weight;
	fn add_file() -> Weight;
	fn add_link() -> Weight;
	fn close() -> Weight;
	fn make_void() -> Weight;
	fn make_void_and_replace() -> Weight;
	fn create_collection_loc() -> Weight;
	fn add_collection_item() -> Weight;
}

/// Weights for pallet_logion_loc using the Substrate node and recommended hardware.
pub struct SubstrateWeight<T>(PhantomData<T>);
impl<T: frame_system::Config> WeightInfo for SubstrateWeight<T> {
	fn create_polkadot_identity_loc() -> Weight {
		(29_862_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(3 as Weight))
			.saturating_add(T::DbWeight::get().writes(2 as Weight))
	}
	fn create_logion_identity_loc() -> Weight {
		(20_945_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(2 as Weight))
			.saturating_add(T::DbWeight::get().writes(1 as Weight))
	}
	fn create_polkadot_transaction_loc() -> Weight {
		(26_316_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(3 as Weight))
			.saturating_add(T::DbWeight::get().writes(2 as Weight))
	}
	fn create_logion_transaction_loc() -> Weight {
		(30_288_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(4 as Weight))
			.saturating_add(T::DbWeight::get().writes(2 as Weight))
	}
	fn add_metadata() -> Weight {
		(11_979_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(1 as Weight))
			.saturating_add(T::DbWeight::get().writes(1 as Weight))
	}
	fn add_file() -> Weight {
		(11_971_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(1 as Weight))
			.saturating_add(T::DbWeight::get().writes(1 as Weight))
	}
	fn add_link() -> Weight {
		(16_067_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(2 as Weight))
			.saturating_add(T::DbWeight::get().writes(1 as Weight))
	}
	fn close() -> Weight {
		(22_224_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(1 as Weight))
			.saturating_add(T::DbWeight::get().writes(1 as Weight))
	}
	fn make_void() -> Weight {
		(22_360_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(1 as Weight))
			.saturating_add(T::DbWeight::get().writes(1 as Weight))
	}
	fn make_void_and_replace() -> Weight {
		(32_724_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(2 as Weight))
			.saturating_add(T::DbWeight::get().writes(2 as Weight))
	}
	fn create_collection_loc() -> Weight {
		(29_219_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(3 as Weight))
			.saturating_add(T::DbWeight::get().writes(2 as Weight))
	}
	fn add_collection_item() -> Weight {
		(31_621_000 as Weight)
			.saturating_add(T::DbWeight::get().reads(3 as Weight))
			.saturating_add(T::DbWeight::get().writes(2 as Weight))
	}
}

// For backwards compatibility and tests
impl WeightInfo for () {
  fn create_polkadot_identity_loc() -> Weight {
    (29_862_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(3 as Weight))
      .saturating_add(RocksDbWeight::get().writes(2 as Weight))
  }
  fn create_logion_identity_loc() -> Weight {
    (20_945_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(2 as Weight))
      .saturating_add(RocksDbWeight::get().writes(1 as Weight))
  }
  fn create_polkadot_transaction_loc() -> Weight {
    (26_316_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(3 as Weight))
      .saturating_add(RocksDbWeight::get().writes(2 as Weight))
  }
  fn create_logion_transaction_loc() -> Weight {
    (30_288_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(4 as Weight))
      .saturating_add(RocksDbWeight::get().writes(2 as Weight))
  }
  fn add_metadata() -> Weight {
    (11_979_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(1 as Weight))
      .saturating_add(RocksDbWeight::get().writes(1 as Weight))
  }
  fn add_file() -> Weight {
    (11_971_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(1 as Weight))
      .saturating_add(RocksDbWeight::get().writes(1 as Weight))
  }
  fn add_link() -> Weight {
    (16_067_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(2 as Weight))
      .saturating_add(RocksDbWeight::get().writes(1 as Weight))
  }
  fn close() -> Weight {
    (22_224_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(1 as Weight))
      .saturating_add(RocksDbWeight::get().writes(1 as Weight))
  }
  fn make_void() -> Weight {
    (22_360_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(1 as Weight))
      .saturating_add(RocksDbWeight::get().writes(1 as Weight))
  }
  fn make_void_and_replace() -> Weight {
    (32_724_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(2 as Weight))
      .saturating_add(RocksDbWeight::get().writes(2 as Weight))
  }
  fn create_collection_loc() -> Weight {
    (29_219_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(3 as Weight))
      .saturating_add(RocksDbWeight::get().writes(2 as Weight))
  }
  fn add_collection_item() -> Weight {
    (31_621_000 as Weight)
      .saturating_add(RocksDbWeight::get().reads(3 as Weight))
      .saturating_add(RocksDbWeight::get().writes(2 as Weight))
  }
}
