# Change Log
# Eclipse Paho Rust

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v0.11.1](https://github.com/eclipse/paho.mqtt.rust/compare/v0.11.0..v0.11.1) - 2021-05-03

- [#156](https://github.com/eclipse/paho.mqtt.rust/issues/156) Improvements to `TopicMatcher`:
    - Doesn't require item type to implement `Default` trait
    - Match iterator returns key/value tuple (not just value).
- [#154](https://github.com/eclipse/paho.mqtt.rust/pull/154) Add public interface to retrieve `client_id`.
    
    
## [v0.11.0](https://github.com/eclipse/paho.mqtt.rust/compare/v0.10.0..v0.11.0) - 2021-04-16

- Updated to support Paho C v1.3.10
- New client functions to stop consuming/streaming and to remove callbacks.
- Started a README for the -sys crate.
- Fixed a bunch of lints. Clippy report is clean.
- [#152](https://github.com/eclipse/paho.mqtt.rust/issues/152) Consumer won't panic when the receiver drops.
- [#113](https://github.com/eclipse/paho.mqtt.rust/issues/113) Build now respects the OPENSSL_STATIC flag (if OPENSSL_DIR or other path flags set).
- [#145](https://github.com/eclipse/paho.mqtt.rust/issues/145) `impl From<Error> for io::Error` An MQTT error can be easily converted back to an I/O error.

## [v0.10.0](https://github.com/eclipse/paho.mqtt.rust/compare/v0.9.1..v0.10.0) - 2021-01-25

- Updated to support Paho C v1.3.9
- Switched consumers/streams to use crossbeam channels and async_channel's, respectively.
- Added a `TopicFilter` type to match topics against an individual filter (typically containing wildcards).
- Added a `TopicMatcher` collection to iterate through a set of matching topic filters, such as to match callbacks to specific filters.
- _Finally_ ran `rustfmt` on source files.
- Fixed MQTT v5 topic alias support.
- [#118](https://github.com/eclipse/paho.mqtt.rust/issues/118) Added `CreateOptionsBuilder::send_while_disconnected(bool)` and detached the behavior somewhat from `max_buffered_messages()`. Now, setting the buffer size to a non-zero value will _not_ enable off-line buffering.
- [#120](https://github.com/eclipse/paho.mqtt.rust/issues/120), [#121](https://github.com/eclipse/paho.mqtt.rust/pull/121) Fixed `subscribe_many_with_options()` outbound opts.
- [#122](https://github.com/eclipse/paho.mqtt.rust/pull/122) Some _clippy_-recommended fixes
- [#139](https://github.com/eclipse/paho.mqtt.rust/issues/139) Added a `SyncClient` struct for repeated publishing to the synchronous client.
- [#140](https://github.com/eclipse/paho.mqtt.rust/issues/140) The MQTT protocol version used to create the client is now the default for connecting.

## [v0.9.1](https://github.com/eclipse/paho.mqtt.rust/compare/v0.9.0..v0.9.1) - 2021-01-01

- [#101](https://github.com/eclipse/paho.mqtt.rust/issues/101) `Token::try_wait()` to check for the result of a `Token` without blocking.
- [#101](https://github.com/eclipse/paho.mqtt.rust/issues/101) A `try_publish()` function for the `AsyncClient` and `Topic` which return a synchronous result that the message was created and queued for transmission successfully.
- [#28](https://github.com/eclipse/paho.mqtt.rust/issues/28) Some instructions for using the "cross" tool for cross-compiling.


## [v0.9.0](https://github.com/eclipse/paho.mqtt.rust/compare/v0.8.0..v0.9.0) - 2020-12-29

- Websocket HTTP/HTTPS proxy support
- Added missing MQTT v5 support:
    - Subscribe and Unsubscribe can now have v5 properties, thus enabling Subscription Identifiers.
- [Breaking] Persistence defaults to `None` if no Client ID specified in creation. 
- Ability to specify a path when using File persistence
- Updated bindings to Paho C v1.3.8
- Ability to start publishing (queuing) messages before fir first successful connection.
- New offline buffering options:
    - Ability to start publishing (queuing) messages before first successful connection.
    - Option to delete the oldest messages first from the queue when it fills up.
- New persistence options:
    - The option to not restore messages from persistence on startup (fresh restart).
    - The option to not persist QoS 0 messages.
- 
- [#110] Update to `futures-timer` v3.0
- [#95] Added Send bounds to `ClientPersistence`
- [#92] Vendored SSL with _openssl-sys_ crate (optional)
- New example apps:
    - _sync_consume_v5.rs_ - An MQTT v5 consumer that uses Subscription ID's to handle incoming messages.
    - _ws_publish.rs_ - Simeple websocket example with optional proxy.


## [v0.8.0](https://github.com/eclipse/paho.mqtt.rust/compare/v0.7.1..v0.8.0) - 2020-11-20

- Upgraded Tokens to implement Futures 0.3. (async/await compatible!)
- Error type based on _thiserror_
- Added some missing/forgotten MQTT v5 support:
    - Connect and Will properties in connect options
    - Reason code and properties in disconnect options
- Ability to set additional HTTP headers in a Websocket opening handshake.
- Added MQTT v5 topic alias capability with an example.
- Examples using async/await
- Removed old asynchronous (futures 0.1-style) examples
- Message and option structs were reimplemented internally with pinned inner data structs.
- Removed `AsyncClientBuilder`. Use `CreateClientBuilder` instead, possibly with new `create_client()` function.
- `SslOptions` using `Path` and `PathBuf` for file names in the API instead of `String`. 
- The reason code returned from the server moved into the `ServerResponse` struct.
- Added `ConnectResponse` as a struct instead of a tuple for the data returned in CONNACK.
- Upgraded crate to 2018 Edition 

## [v0.7.1](https://github.com/eclipse/paho.mqtt.rust/compare/v0.7..v0.7.1) - 2020-04-28

It turned out that the update to the -sys crate in v0.7 was a breaking change. This just bumps the version numbers to indicate that, so as not to break v0.6 builds via crates.io

## [v0.7](https://github.com/eclipse/paho.mqtt.rust/compare/v0.6..v0.7) - 2020-04-27

Version 0.7 brings full support for MQTT v5, including:

- Ability to create an MQTT v5 client and request a v5 connection to the server.
- MQTT v5 `Properties` (for connect, publish, incoming messages, etc)
- `ReasonCode` and better error notifications.
- [Breaking] Restored the single `Token` type, getting rid of separate implementations of `ConnectToken`, `SubscribeToken`, etc.
- Subscribe options, such as "No Local," etc.
- `Topic` objects can now be used to subscribe.
- New callback `on_disconnect()` for when the client receives a disconnect packet from the server, complete with a reason code and properties.
- Example for a simple chat application _(mqttrs_chat)_ using the v5 "No Local" subscription option. The publisher does not get their own messages echoed back to them.
 - Examples for RPC using v5 _Properties_ for _ResponseTopic_ and _CorrelationData:_
     - A math RPC service/server _(rpc_math_srvr)_ that performs basic operations on a list of numbers. 
     - A math RPC client  _(rpc_math_cli)_ that can send requests.

Also:

- Fix for #48: Sends a _None_ (and exits consumer) on manual disconnect.
- Fix for #49: Supporting `on_connect()` callback.
- Fix for #51: Segfault on `subscribe_many()` with a single topic.
- The build now uses the environment variable `OPENSSL_ROOT_DIR` to help find the SSL libraries in a non-standard install directory.

Note that v0.7 still targets Futures v0.1 and Rust Edition 2015. Support for async/await, and std Future (0.3) will be coming shortly in v0.8.


## [v0.6](https://github.com/eclipse/paho.mqtt.rust/compare/v0.5..v0.6) - 2019-10-12

The v0.6 release added support for Futures and cleaned up the internal implementation of the library. 

- **Futures support:**
    - Compatible with the [Rust Futures](https://docs.rs/futures/0.1.25/futures/) library v0.1
    - Now depends on the crates "futures" (v0.1) and "futures-timer" (v0.1).
    - The `Token` objects, which are returned by asynchronous calls, now implements the `Futures` trait, which is _mostly_ compatible with the previous implementation.
    - Incoming messages can be obtained through a `Stream` from the client, implemented with a futures channel.
    - New examples of a publisher and subscriber implemented with futures.

- **Server Responses**
    - There are now several different types of tokens corresponding to different requests for which the server can return a response: _ConnectToken_, _DeliveryToken_, _SubscribeToken_, etc. 
    - Tokens now track the type of request and get the server response upon completion. This is the Futures _Item_ type for the token.
    - In particular this is useful for connecting subscribers. The app can now determine if a persistent session is already present, and only needs to subscribe if not.
    
- **Send and Sync Traits**
    - The clients are now marked as _Send_ and _Sync_
    - The _Token_ types are _Send_
    - Most of the option types are _Send_ and _Sync_
    - _AsyncClient_ and _Token_ objects are now just _Arc_ wrappers around inner structs making it easy to clone and pass references around.
    
- **Internal Cleanup**
    - Updated to wrap Paho C v1.3.1 which has a number of important bug fixes.
    - Moved `Tokens` into their own source file.
    - Consolidated persistence internals into `UserPersistence` struct.
    - Created a new `ResponseOptions` struct to manage the details of the C `MQTTAsync_responseOptions` objects.
    - Cleanup of the `AsyncClient` implementation.
    - A bad reconnect bug is fixed (Issue #33)


## [v0.5](https://github.com/eclipse/paho.mqtt.rust/compare/v0.4..v0.5) - 2018-12-15

### Added

- WebSocket support (free with Paho C 1.3.0 update).
- Example apps can take server URI's from the command line.

### Changed

- Updated the library to bundle and use Paho C v1.3.0


