#[allow(unused_imports)]
use test_env_log::test;
#[allow(unused_imports)]
use pact_models::PactSpecification;
#[allow(unused_imports)]
use serde_json;
#[allow(unused_imports)]
use expectest::prelude::*;
#[allow(unused_imports)]
use pact_matching::{CONTENT_MATCHER_CATALOGUE_ENTRIES, MATCHER_CATALOGUE_ENTRIES};
#[allow(unused_imports)]
use pact_plugin_driver::catalogue_manager::register_core_entries;
#[allow(unused_imports)]
use pact_models::interaction::{Interaction, http_interaction_from_json};
#[allow(unused_imports)]
use pact_matching::{match_interaction_request, match_interaction_response};
#[allow(unused_imports)]
use pact_models::prelude::{Pact, RequestResponsePact};

#[tokio::test]
async fn empty_path_found_when_forward_slash_expected() {
    println!("FILE: tests/spec_testcases/v3/request/path/empty path found when forward slash expected.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": false,
        "comment": "Empty path found when forward slash expected",
        "expected" : {
          "method": "POST",
          "path": "/",
          "query": {},
          "headers": {}
        },
        "actual": {
          "method": "POST",
          "path": "",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/empty path found when forward slash expected.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/empty path found when forward slash expected.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}

#[tokio::test]
async fn matches_with_regex() {
    println!("FILE: tests/spec_testcases/v3/request/path/matches with regex.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": true,
        "comment": "Paths match with regex",
        "expected" : {
          "method": "POST",
          "path": "/path/to/1234",
          "query": {},
          "headers": {},
          "matchingRules": {
            "path": {
              "matchers": [
                {
                  "match": "regex",
                  "regex": "\\/path\\/to\\/\\d{4}"
                }
              ]
            }
          }
        },
        "actual": {
          "method": "POST",
          "path": "/path/to/5678",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/matches with regex.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/matches with regex.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}

#[tokio::test]
async fn unexpected_trailing_slash_in_path() {
    println!("FILE: tests/spec_testcases/v3/request/path/unexpected trailing slash in path.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": false,
        "comment": "Path has unexpected trailing slash, trailing slashes can matter",
        "expected" : {
          "method": "POST",
          "path": "/path/to/something",
          "query": {},
          "headers": {}
        },
        "actual": {
          "method": "POST",
          "path": "/path/to/something/",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/unexpected trailing slash in path.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/unexpected trailing slash in path.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}

#[tokio::test]
async fn forward_slash_found_when_empty_path_expected() {
    println!("FILE: tests/spec_testcases/v3/request/path/forward slash found when empty path expected.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": false,
        "comment": "Foward slash found when empty path expected",
        "expected" : {
          "method": "POST",
          "path": "",
          "query": {},
          "headers": {}
        },
        "actual": {
          "method": "POST",
          "path": "/",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/forward slash found when empty path expected.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/forward slash found when empty path expected.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}

#[tokio::test]
async fn incorrect_path() {
    println!("FILE: tests/spec_testcases/v3/request/path/incorrect path.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": false,
        "comment": "Paths do not match",
        "expected" : {
          "method": "POST",
          "path": "/path/to/something",
          "query": {},
          "headers": {}
        },
        "actual": {
          "method": "POST",
          "path": "/path/to/something/else",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/incorrect path.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/incorrect path.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}

#[tokio::test]
async fn missing_trailing_slash_in_path() {
    println!("FILE: tests/spec_testcases/v3/request/path/missing trailing slash in path.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": false,
        "comment": "Path is missing trailing slash, trailing slashes can matter",
        "expected" : {
          "method": "POST",
          "path": "/path/to/something/",
          "query": {},
          "headers": {}
        },
        "actual": {
          "method": "POST",
          "path": "/path/to/something",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/missing trailing slash in path.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/missing trailing slash in path.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}

#[tokio::test]
async fn matches() {
    println!("FILE: tests/spec_testcases/v3/request/path/matches.json");
    #[allow(unused_mut)]
    let mut pact: serde_json::Value = serde_json::from_str(r#"
      {
        "match": true,
        "comment": "Paths match",
        "expected" : {
          "method": "POST",
          "path": "/path/to/something",
          "query": {},
          "headers": {}
        },
        "actual": {
          "method": "POST",
          "path": "/path/to/something",
          "query": {},
          "headers": {}
        }
      }
    "#).unwrap();

    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("expected").unwrap()});
    let expected = http_interaction_from_json("tests/spec_testcases/v3/request/path/matches.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("EXPECTED: {:?}", expected);
    println!("BODY: {}", expected.as_request_response().unwrap().request.body.str_value());
    let interaction_json = serde_json::json!({"type": "Synchronous/HTTP", "request": pact.get("actual").unwrap()});
    let actual = http_interaction_from_json("tests/spec_testcases/v3/request/path/matches.json", &interaction_json, &PactSpecification::V3).unwrap();
    println!("ACTUAL: {:?}", actual);
    println!("BODY: {}", actual.as_request_response().unwrap().request.body.str_value());
    let pact_match = pact.get("match").unwrap();

    register_core_entries(CONTENT_MATCHER_CATALOGUE_ENTRIES.as_ref());
    register_core_entries(MATCHER_CATALOGUE_ENTRIES.as_ref());
    let pact = RequestResponsePact { interactions: vec![ expected.as_request_response().unwrap_or_default() ], .. RequestResponsePact::default() }.boxed();
    let result = match_interaction_request(expected, actual, pact, &PactSpecification::V3).await.unwrap().mismatches();

    println!("RESULT: {:?}", result);
    if pact_match.as_bool().unwrap() {
       expect!(result.iter()).to(be_empty());
    } else {
       expect!(result.iter()).to_not(be_empty());
    }
}
