//! A packet manipulation, generation, unpackination, and constructionation station.
//!
//! In all seriousness, packeteer is a crate made to assist with programmatically analysing, serving and handling received protocol packets.
//! This is great for servers, clients, proxies as well as packet sniffers, capturers and analysers.
//! Packeteer doesn't implement any ability to send or receive requests/responses nor does it handle streams or threads for you and is instead supposed to be used in applications to structure packets and potentially do automated operations on them as defined by packeteer modules.
//!
//! To include packeteer in your project, you'll need to enable the modules you need. For example, if you required the usage of the http1 module, you would add the following to your `Cargo.toml` file:
//!
//! ```toml
//! packeteer = { version = "0.1", features = ["http1"] }
//! ```
//!
//! It's safe to use ambigious version numbers that exclude the bugfix number as  breaking changes or new features will result in an increment of the minor version number, or possibly major version number in the future.
//!
//! Packeteer aims to use as little dependencies as possible. The less dependenices that packeteer uses, the less storage your project uses. Being conservative with dependencies also makes compilation infinitely faster.
//!
//! An example of request generation using the http1 module:
//!
//! ```no_run
//! use packeteer::http1::*
//!
//! fn main() {
//! 	// generate_request(method, host, location, body)
//! 	// GET requests don't really require bodies.
//! 	let request = generate_request("GET", "example.service", "/api/example_endpoint", "");
//! 	let req_raw = unpack_request(request);
//!
//! 	// Now to send req_raw through a stream to your client!
//! }
//! ```
//!
/// A global structure for key value headers.
/// Can be automatically generated with the function packeteer::generate_kvheader.
#[derive(Debug)]
pub struct KVHeader {
	pub key: String,
	pub value: String,
}

/// A public function for generating a KVHeader structure from two string references representing the key and value.
pub fn generate_kvheader(key: &str, value: &str) -> KVHeader {
	let result = KVHeader { key: key.to_string(), value: value.to_string() };
	return result
}

#[cfg(feature = "http1")]
pub mod http1;
