mod handler;
mod packets;

use pcap::{Capture, Device};
use clap::{Arg, App, SubCommand};

fn is_i32(val: String) -> Result<(), String> {
    match val.parse::<i32>() {
        Ok(_) => Ok(()),
        Err(err) => Err(err.to_string()),
    }
}

fn main() { 

    let application = App::new("PacketDog")
        .version("0.0.1")
        .author("ibx34#6030 (366649052357591044)")
        .about("Track packets in/out bound on your device")
        .subcommand(
            SubCommand::with_name("run")
            .about("Runs PacketDog (provide no args/options for default logging)")
            .arg(Arg::with_name("list-devices")
                .short("l")
                .long("list")
                .takes_value(false)
                .help("Only lists devices.")
            ).arg(Arg::with_name("save")
                .short("s")
                .long("save")
                .takes_value(false)
                .help("Saves output to a file.")
            ).arg(Arg::with_name("device")
                .short("d")
                .long("device")
                .takes_value(true)
                .help("Selects a device to sniff")
            ).arg(Arg::with_name("table")
                .short("t")
                .long("table")
                .takes_value(false)
                .help("Decides whether or not the new data should be put in a table.")
        )
        ).get_matches();
    
    if let Some(_matches) = application.subcommand_matches("run") {
        
        let mut main_device: Device = Device::lookup().unwrap();
        let devices = Device::list().unwrap();
        
        if _matches.is_present("list-devices") {
            println!("{0: <60} | {1: <300}",
                    "Name","Description");
            println!("{:-^1$}", "-", 135,);

            for device in &devices {
                println!(
                    "{0: <60} | {1: <300}",
                    device.name,
                    device.desc.clone().unwrap_or("No description".to_string())
                );
            }

            return;
        }

        let mut thing = handler::Handler::new();

        if let Some(device_arg) = _matches.value_of("device") {

            devices.into_iter().for_each(|dev | {
                if dev.name == device_arg {
                    main_device.name = dev.name.to_owned();
                    main_device.desc = dev.desc.to_owned();
                }
            });

        }

        let cap = Capture::from_device(
            main_device
        ).unwrap().open().unwrap();

        thing.parse(cap);
    }
}