mod handler;
mod packets;

use pcap::{Capture, Device};
use pktparse;
use clap::{Arg, App, SubCommand};
use serde::{Serialize,Deserialize};

#[derive(Debug,Serialize,Deserialize)]
pub struct JsonData {
    pub ipv4: Vec<Option<pktparse::ipv4::IPv4Header>>,
    pub ipv6: Vec<Option<pktparse::ipv6::IPv6Header>>,
    pub ether: Vec<Option<pktparse::ethernet::EthernetFrame>>,
    pub arp: Vec<Option<pktparse::arp::ArpPacket>>,
}

fn main() { 
    
    let mut _data: JsonData = JsonData {
        ipv4: vec![],
        ipv6: vec![],
        ether: vec![],
        arp: vec![]
    };

    let application = App::new("PacketDog")
        .version("0.0.1")
        .author("ibx34#6030 (366649052357591044)")
        .about("Track packets in/out bound on your device")
        .subcommand(
            SubCommand::with_name("run")
            .about("Runs PacketDog (provide no args/options for default logging)")
            .arg(Arg::with_name("list-devices")
                .short("l")
                .long("list")
                .takes_value(false)
                .help("Only lists devices.")
            ).arg(Arg::with_name("save")
                .short("s")
                .long("save")
                .takes_value(false)
                .help("Saves output to a file.")
            ).arg(Arg::with_name("table")
            .short("t")
            .long("table")
            .takes_value(false)
            .help("Decides whether or not the new data should be put in a table.")
        )
        ).get_matches();
    
    if let Some(_matches) = application.subcommand_matches("run") {
        
        let mut main_device: Device = Device::lookup().unwrap();
        let devices = Device::list().unwrap();
        
        if _matches.is_present("list-devices") {
            println!("Listing all devices.");
            for device in &devices {
                println!("Name: {}\nDescription: {}\n-------",
                    device.name,
                    device.desc.clone().unwrap_or("No description".to_string())
                )
            }

            return;
        }

        let mut thing = handler::Handler::new();

        let device = devices.get(3).unwrap();
        main_device.name = device.name.clone();
        main_device.desc = device.desc.clone();

        let cap = Capture::from_device(
            main_device
        ).unwrap().open().unwrap();  

        thing.parse(cap);
    }
}