#![allow(non_upper_case_globals)]
use crate::types::*;
use crate::constants::*;
use wasm_bindgen::prelude::*;
#[doc=r##"<p>Draw a plane with given a width and height</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw a plane
// with width 50 and height 50
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  plane(50, 50);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>width?</code> width of the plane

"##]
///
///
#[doc = r##"<code>height?</code> height of the plane

"##]
///
///
#[doc = r##"<code>detailX?</code> Optional number of triangle
                            subdivisions in x-dimension

"##]
///
///
#[doc = r##"<code>detailY?</code> Optional number of triangle
                            subdivisions in y-dimension

"##]
///

pub static plane: PlaneInternalType = PlaneInternalType;
#[doc(hidden)]
pub struct PlaneInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "plane")]
    fn plane2585599206(_ : f64, _ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,)> for PlaneInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,)) -> Self::Output {
        plane2585599206.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,)> for PlaneInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,)) -> Self::Output {
        plane2585599206.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,)> for PlaneInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,)) -> Self::Output {
        plane2585599206.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "plane")]
    fn plane2406826182(_ : f64, _ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,)> for PlaneInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,)) -> Self::Output {
        plane2406826182.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,)> for PlaneInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,)) -> Self::Output {
        plane2406826182.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,)> for PlaneInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,)) -> Self::Output {
        plane2406826182.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "plane")]
    fn plane2283584251(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for PlaneInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        plane2283584251.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for PlaneInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        plane2283584251.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for PlaneInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        plane2283584251.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "plane")]
    fn plane4150062490(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for PlaneInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        plane4150062490.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for PlaneInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        plane4150062490.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for PlaneInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        plane4150062490.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "plane")]
    fn plane3752690872() ;
}

#[doc(hidden)]
impl FnOnce<()> for PlaneInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        plane3752690872.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for PlaneInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        plane3752690872.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for PlaneInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        plane3752690872.call(args)
    }
}
#[doc=r##"<p>Draw a box with given width, height and depth</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw a spinning box
// with width, height and depth of 50
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  box(50);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>width?</code> width of the box

"##]
///
///
#[doc = r##"<code>Height?</code> height of the box

"##]
///
///
#[doc = r##"<code>depth?</code> depth of the box

"##]
///
///
#[doc = r##"<code>detailX?</code> Optional number of triangle
                           subdivisions in x-dimension

"##]
///
///
#[doc = r##"<code>detailY?</code> Optional number of triangle
                           subdivisions in y-dimension

"##]
///

pub static r#box: RBoxInternalType = RBoxInternalType;
#[doc(hidden)]
pub struct RBoxInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#box")]
    fn r#box1627006999(_ : f64, _ : f64, _ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,i32,i32,)> for RBoxInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,i32,i32,)) -> Self::Output {
        r#box1627006999.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,i32,i32,)> for RBoxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,i32,i32,)) -> Self::Output {
        r#box1627006999.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,i32,i32,)> for RBoxInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,i32,i32,)) -> Self::Output {
        r#box1627006999.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#box")]
    fn r#box2875443328(_ : f64, _ : f64, _ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,i32,)> for RBoxInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,i32,)) -> Self::Output {
        r#box2875443328.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,i32,)> for RBoxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,i32,)) -> Self::Output {
        r#box2875443328.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,i32,)> for RBoxInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,i32,)) -> Self::Output {
        r#box2875443328.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#box")]
    fn r#box2303590482(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for RBoxInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        r#box2303590482.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for RBoxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        r#box2303590482.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for RBoxInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        r#box2303590482.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#box")]
    fn r#box1345169569(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for RBoxInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        r#box1345169569.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for RBoxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        r#box1345169569.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for RBoxInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        r#box1345169569.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#box")]
    fn r#box804119330(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RBoxInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        r#box804119330.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RBoxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        r#box804119330.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RBoxInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        r#box804119330.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#box")]
    fn r#box4208199793() ;
}

#[doc(hidden)]
impl FnOnce<()> for RBoxInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        r#box4208199793.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RBoxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        r#box4208199793.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RBoxInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        r#box4208199793.call(args)
    }
}
#[doc=r##"<p>Draw a sphere with given radius.</p>
<p>DetailX and detailY determines the number of subdivisions in the x-dimension
and the y-dimension of a sphere. More subdivisions make the sphere seem
smoother. The recommended maximum values are both 24. Using a value greater
than 24 may cause a warning or slow down the browser.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw a sphere with radius 40
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(205, 102, 94);
  sphere(40);
}
```"###]
#[doc=r###"```rust
let detailX;
// slide to see how detailX works
function setup() {
  createCanvas(100, 100, WEBGL);
  detailX = createSlider(3, 24, 3);
  detailX.position(10, height + 5);
  detailX.style('width', '80px');
}

function draw() {
  background(205, 105, 94);
  rotateY(millis() / 1000);
  sphere(40, detailX.value(), 16);
}
```"###]
#[doc=r###"```rust
let detailY;
// slide to see how detailY works
function setup() {
  createCanvas(100, 100, WEBGL);
  detailY = createSlider(3, 16, 3);
  detailY.position(10, height + 5);
  detailY.style('width', '80px');
}

function draw() {
  background(205, 105, 94);
  rotateY(millis() / 1000);
  sphere(40, 16, detailY.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>radius?</code> radius of circle

"##]
///
///
#[doc = r##"<code>detailX?</code> optional number of subdivisions in x-dimension

"##]
///
///
#[doc = r##"<code>detailY?</code> optional number of subdivisions in y-dimension

"##]
///

pub static sphere: SphereInternalType = SphereInternalType;
#[doc(hidden)]
pub struct SphereInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sphere")]
    fn sphere2282512766(_ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,i32,)> for SphereInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,i32,i32,)) -> Self::Output {
        sphere2282512766.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,i32,)> for SphereInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,i32,)) -> Self::Output {
        sphere2282512766.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,i32,)> for SphereInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,i32,)) -> Self::Output {
        sphere2282512766.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sphere")]
    fn sphere2478419053(_ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,)> for SphereInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,i32,)) -> Self::Output {
        sphere2478419053.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,)> for SphereInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,)) -> Self::Output {
        sphere2478419053.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,)> for SphereInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,)) -> Self::Output {
        sphere2478419053.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sphere")]
    fn sphere2039576775(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SphereInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        sphere2039576775.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SphereInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        sphere2039576775.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SphereInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        sphere2039576775.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sphere")]
    fn sphere2633905878() ;
}

#[doc(hidden)]
impl FnOnce<()> for SphereInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        sphere2633905878.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for SphereInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        sphere2633905878.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for SphereInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        sphere2633905878.call(args)
    }
}
#[doc=r##"<p>Draw a cylinder with given radius and height</p>
<p>DetailX and detailY determines the number of subdivisions in the x-dimension
and the y-dimension of a cylinder. More subdivisions make the cylinder seem smoother.
The recommended maximum value for detailX is 24. Using a value greater than 24
may cause a warning or slow down the browser.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw a spinning cylinder
// with radius 20 and height 50
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(205, 105, 94);
  rotateX(frameCount * 0.01);
  rotateZ(frameCount * 0.01);
  cylinder(20, 50);
}
```"###]
#[doc=r###"```rust
// slide to see how detailX works
let detailX;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailX = createSlider(3, 24, 3);
  detailX.position(10, height + 5);
  detailX.style('width', '80px');
}

function draw() {
  background(205, 105, 94);
  rotateY(millis() / 1000);
  cylinder(20, 75, detailX.value(), 1);
}
```"###]
#[doc=r###"```rust
// slide to see how detailY works
let detailY;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailY = createSlider(1, 16, 1);
  detailY.position(10, height + 5);
  detailY.style('width', '80px');
}

function draw() {
  background(205, 105, 94);
  rotateY(millis() / 1000);
  cylinder(20, 75, 16, detailY.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>radius?</code> radius of the surface

"##]
///
///
#[doc = r##"<code>height?</code> height of the cylinder

"##]
///
///
#[doc = r##"<code>detailX?</code> number of subdivisions in x-dimension;
                              default is 24

"##]
///
///
#[doc = r##"<code>detailY?</code> number of subdivisions in y-dimension;
                              default is 1

"##]
///
///
#[doc = r##"<code>bottomCap?</code> whether to draw the bottom of the cylinder

"##]
///
///
#[doc = r##"<code>topCap?</code> whether to draw the top of the cylinder

"##]
///

pub static cylinder: CylinderInternalType = CylinderInternalType;
#[doc(hidden)]
pub struct CylinderInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder3607002648(_ : f64, _ : f64, _ : i32, _ : i32, _ : bool, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,bool,bool,)> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,bool,bool,)) -> Self::Output {
        cylinder3607002648.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,bool,bool,)> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,bool,bool,)) -> Self::Output {
        cylinder3607002648.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,bool,bool,)> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,bool,bool,)) -> Self::Output {
        cylinder3607002648.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder838797870(_ : f64, _ : f64, _ : i32, _ : i32, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,bool,)> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,bool,)) -> Self::Output {
        cylinder838797870.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,bool,)> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,bool,)) -> Self::Output {
        cylinder838797870.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,bool,)> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,bool,)) -> Self::Output {
        cylinder838797870.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder3346681972(_ : f64, _ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,)> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,)) -> Self::Output {
        cylinder3346681972.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,)> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,)) -> Self::Output {
        cylinder3346681972.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,)> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,)) -> Self::Output {
        cylinder3346681972.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder374494451(_ : f64, _ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,)> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,)) -> Self::Output {
        cylinder374494451.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,)> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,)) -> Self::Output {
        cylinder374494451.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,)> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,)) -> Self::Output {
        cylinder374494451.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder3593978055(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        cylinder3593978055.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        cylinder3593978055.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        cylinder3593978055.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder3215966866(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        cylinder3215966866.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        cylinder3215966866.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        cylinder3215966866.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cylinder")]
    fn cylinder1175085779() ;
}

#[doc(hidden)]
impl FnOnce<()> for CylinderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        cylinder1175085779.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CylinderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        cylinder1175085779.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CylinderInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        cylinder1175085779.call(args)
    }
}
#[doc=r##"<p>Draw a cone with given radius and height</p>
<p>DetailX and detailY determine the number of subdivisions in the x-dimension and
the y-dimension of a cone. More subdivisions make the cone seem smoother. The
recommended maximum value for detailX is 24. Using a value greater than 24
may cause a warning or slow down the browser.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw a spinning cone
// with radius 40 and height 70
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  rotateX(frameCount * 0.01);
  rotateZ(frameCount * 0.01);
  cone(40, 70);
}
```"###]
#[doc=r###"```rust
// slide to see how detailx works
let detailX;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailX = createSlider(3, 16, 3);
  detailX.position(10, height + 5);
  detailX.style('width', '80px');
}

function draw() {
  background(205, 102, 94);
  rotateY(millis() / 1000);
  cone(30, 65, detailX.value(), 16);
}
```"###]
#[doc=r###"```rust
// slide to see how detailY works
let detailY;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailY = createSlider(3, 16, 3);
  detailY.position(10, height + 5);
  detailY.style('width', '80px');
}

function draw() {
  background(205, 102, 94);
  rotateY(millis() / 1000);
  cone(30, 65, 16, detailY.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>radius?</code> radius of the bottom surface

"##]
///
///
#[doc = r##"<code>height?</code> height of the cone

"##]
///
///
#[doc = r##"<code>detailX?</code> number of segments,
                            the more segments the smoother geometry
                            default is 24

"##]
///
///
#[doc = r##"<code>detailY?</code> number of segments,
                            the more segments the smoother geometry
                            default is 1

"##]
///
///
#[doc = r##"<code>cap?</code> whether to draw the base of the cone

"##]
///

pub static cone: ConeInternalType = ConeInternalType;
#[doc(hidden)]
pub struct ConeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cone")]
    fn cone244031306(_ : f64, _ : f64, _ : i32, _ : i32, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,bool,)> for ConeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,bool,)) -> Self::Output {
        cone244031306.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,bool,)> for ConeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,bool,)) -> Self::Output {
        cone244031306.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,bool,)> for ConeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,bool,)) -> Self::Output {
        cone244031306.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cone")]
    fn cone1649964555(_ : f64, _ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,)> for ConeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,)) -> Self::Output {
        cone1649964555.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,)> for ConeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,)) -> Self::Output {
        cone1649964555.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,)> for ConeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,)) -> Self::Output {
        cone1649964555.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cone")]
    fn cone4145843906(_ : f64, _ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,)> for ConeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,)) -> Self::Output {
        cone4145843906.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,)> for ConeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,)) -> Self::Output {
        cone4145843906.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,)> for ConeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,)) -> Self::Output {
        cone4145843906.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cone")]
    fn cone38068920(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for ConeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        cone38068920.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for ConeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        cone38068920.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for ConeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        cone38068920.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cone")]
    fn cone3153721414(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ConeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        cone3153721414.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ConeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        cone3153721414.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ConeInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        cone3153721414.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cone")]
    fn cone3105658346() ;
}

#[doc(hidden)]
impl FnOnce<()> for ConeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        cone3105658346.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ConeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        cone3105658346.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ConeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        cone3105658346.call(args)
    }
}
#[doc=r##"<p>Draw an ellipsoid with given radius</p>
<p>DetailX and detailY determine the number of subdivisions in the x-dimension and
the y-dimension of a cone. More subdivisions make the ellipsoid appear to be smoother.
Avoid detail number above 150, it may crash the browser.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw an ellipsoid
// with radius 30, 40 and 40.
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(205, 105, 94);
  ellipsoid(30, 40, 40);
}
```"###]
#[doc=r###"```rust
// slide to see how detailX works
let detailX;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailX = createSlider(2, 24, 12);
  detailX.position(10, height + 5);
  detailX.style('width', '80px');
}

function draw() {
  background(205, 105, 94);
  rotateY(millis() / 1000);
  ellipsoid(30, 40, 40, detailX.value(), 8);
}
```"###]
#[doc=r###"```rust
// slide to see how detailY works
let detailY;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailY = createSlider(2, 24, 6);
  detailY.position(10, height + 5);
  detailY.style('width', '80px');
}

function draw() {
  background(205, 105, 9);
  rotateY(millis() / 1000);
  ellipsoid(30, 40, 40, 12, detailY.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>radiusx?</code> x-radius of ellipsoid

"##]
///
///
#[doc = r##"<code>radiusy?</code> y-radius of ellipsoid

"##]
///
///
#[doc = r##"<code>radiusz?</code> z-radius of ellipsoid

"##]
///
///
#[doc = r##"<code>detailX?</code> number of segments,
                                   the more segments the smoother geometry
                                   default is 24. Avoid detail number above
                                   150, it may crash the browser.

"##]
///
///
#[doc = r##"<code>detailY?</code> number of segments,
                                   the more segments the smoother geometry
                                   default is 16. Avoid detail number above
                                   150, it may crash the browser.

"##]
///

pub static ellipsoid: EllipsoidInternalType = EllipsoidInternalType;
#[doc(hidden)]
pub struct EllipsoidInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipsoid")]
    fn ellipsoid381941463(_ : f64, _ : f64, _ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,i32,i32,)> for EllipsoidInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,i32,i32,)) -> Self::Output {
        ellipsoid381941463.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,i32,i32,)> for EllipsoidInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,i32,i32,)) -> Self::Output {
        ellipsoid381941463.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,i32,i32,)> for EllipsoidInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,i32,i32,)) -> Self::Output {
        ellipsoid381941463.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipsoid")]
    fn ellipsoid498476693(_ : f64, _ : f64, _ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,i32,)> for EllipsoidInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,i32,)) -> Self::Output {
        ellipsoid498476693.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,i32,)> for EllipsoidInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,i32,)) -> Self::Output {
        ellipsoid498476693.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,i32,)> for EllipsoidInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,i32,)) -> Self::Output {
        ellipsoid498476693.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipsoid")]
    fn ellipsoid2642596539(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for EllipsoidInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        ellipsoid2642596539.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for EllipsoidInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        ellipsoid2642596539.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for EllipsoidInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        ellipsoid2642596539.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipsoid")]
    fn ellipsoid117457045(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for EllipsoidInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        ellipsoid117457045.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for EllipsoidInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        ellipsoid117457045.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for EllipsoidInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        ellipsoid117457045.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipsoid")]
    fn ellipsoid217783363(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for EllipsoidInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        ellipsoid217783363.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for EllipsoidInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        ellipsoid217783363.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for EllipsoidInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        ellipsoid217783363.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipsoid")]
    fn ellipsoid426001174() ;
}

#[doc(hidden)]
impl FnOnce<()> for EllipsoidInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        ellipsoid426001174.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for EllipsoidInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        ellipsoid426001174.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for EllipsoidInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        ellipsoid426001174.call(args)
    }
}
#[doc=r##"<p>Draw a torus with given radius and tube radius</p>
<p>DetailX and detailY determine the number of subdivisions in the x-dimension and
the y-dimension of a torus. More subdivisions make the torus appear to be smoother.
The default and maximum values for detailX and detailY are 24 and 16, respectively.
Setting them to relatively small values like 4 and 6 allows you to create new
shapes other than a torus.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// draw a spinning torus
// with ring radius 30 and tube radius 15
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(205, 102, 94);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  torus(30, 15);
}
```"###]
#[doc=r###"```rust
// slide to see how detailX works
let detailX;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailX = createSlider(3, 24, 3);
  detailX.position(10, height + 5);
  detailX.style('width', '80px');
}

function draw() {
  background(205, 102, 94);
  rotateY(millis() / 1000);
  torus(30, 15, detailX.value(), 12);
}
```"###]
#[doc=r###"```rust
// slide to see how detailY works
let detailY;
function setup() {
  createCanvas(100, 100, WEBGL);
  detailY = createSlider(3, 16, 3);
  detailY.position(10, height + 5);
  detailY.style('width', '80px');
}

function draw() {
  background(205, 102, 94);
  rotateY(millis() / 1000);
  torus(30, 15, 16, detailY.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>radius?</code> radius of the whole ring

"##]
///
///
#[doc = r##"<code>tubeRadius?</code> radius of the tube

"##]
///
///
#[doc = r##"<code>detailX?</code> number of segments in x-dimension,
                               the more segments the smoother geometry
                               default is 24

"##]
///
///
#[doc = r##"<code>detailY?</code> number of segments in y-dimension,
                               the more segments the smoother geometry
                               default is 16

"##]
///

pub static torus: TorusInternalType = TorusInternalType;
#[doc(hidden)]
pub struct TorusInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "torus")]
    fn torus600724799(_ : f64, _ : f64, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,i32,)> for TorusInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,i32,)) -> Self::Output {
        torus600724799.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,i32,)> for TorusInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,i32,)) -> Self::Output {
        torus600724799.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,i32,)> for TorusInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,i32,)) -> Self::Output {
        torus600724799.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "torus")]
    fn torus3116411155(_ : f64, _ : f64, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,i32,)> for TorusInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,i32,)) -> Self::Output {
        torus3116411155.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,i32,)> for TorusInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,i32,)) -> Self::Output {
        torus3116411155.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,i32,)> for TorusInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,i32,)) -> Self::Output {
        torus3116411155.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "torus")]
    fn torus667053617(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for TorusInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        torus667053617.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for TorusInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        torus667053617.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for TorusInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        torus667053617.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "torus")]
    fn torus4219204190(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for TorusInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        torus4219204190.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for TorusInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        torus4219204190.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for TorusInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        torus4219204190.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "torus")]
    fn torus2253754188() ;
}

#[doc(hidden)]
impl FnOnce<()> for TorusInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        torus2253754188.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TorusInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        torus2253754188.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TorusInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        torus2253754188.call(args)
    }
}
#[doc=r##"<p>Loads a custom shader from the provided vertex and fragment
shader paths. The shader files are loaded asynchronously in the
background, so this method should be used in <a href="#/p5/preload">preload()</a>.</p>
<p>For now, there are three main types of shaders. p5 will automatically
supply appropriate vertices, normals, colors, and lighting attributes
if the parameters defined in the shader match the names.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let mandel;
function preload() {
  // load the shader definitions from files
  mandel = loadShader('assets/shader.vert', 'assets/shader.frag');
}
function setup() {
  createCanvas(100, 100, WEBGL);
  // use the shader
  shader(mandel);
  noStroke();
  mandel.setUniform('p', [-0.74364388703, 0.13182590421]);
}

function draw() {
  mandel.setUniform('r', 1.5 * exp(-6.5 * (1 + sin(millis() / 2000))));
  quad(-1, -1, 1, -1, 1, 1, -1, 1);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>vertFilename</code> path to file containing vertex shader
source code

"##]
///
///
#[doc = r##"<code>fragFilename</code> path to file containing fragment shader
source code

"##]
///
///
#[doc = r##"<code>callback?</code> callback to be executed after loadShader
completes. On success, the Shader object is passed as the first argument.

"##]
///
///
#[doc = r##"<code>errorCallback?</code> callback to be executed when an error
occurs inside loadShader. On error, the error is passed as the first
argument.

"##]
///

pub static loadShader: LoadShaderInternalType = LoadShaderInternalType;
#[doc(hidden)]
pub struct LoadShaderInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadShader")]
    fn loadShader1398834873(_ : & str, _ : & str, _ : js_sys::Function, _ : js_sys::Function, ) ->  Shader;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadShaderInternalType {
    type Output =  Shader;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadShader1398834873.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadShader1398834873.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadShaderInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadShader1398834873.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadShader")]
    fn loadShader3218830193(_ : & str, _ : & str, _ : js_sys::Function, ) ->  Shader;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,js_sys::Function,)> for LoadShaderInternalType {
    type Output =  Shader;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadShader3218830193.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,js_sys::Function,)> for LoadShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadShader3218830193.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,js_sys::Function,)> for LoadShaderInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadShader3218830193.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadShader")]
    fn loadShader2141838164(_ : & str, _ : & str, ) ->  Shader;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for LoadShaderInternalType {
    type Output =  Shader;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadShader2141838164.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for LoadShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadShader2141838164.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for LoadShaderInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadShader2141838164.call(args)
    }
}
/// No description available

///<h2>Examples</h2>
///

#[doc=r###"```rust
// the 'varying's are shared between both vertex & fragment shaders
let varying = 'precision highp float; varying vec2 vPos;';

// the vertex shader is called for each vertex
let vs =
  varying +
  'attribute vec3 aPosition;' +
  'void main() { vPos = (gl_Position = vec4(aPosition,1.0)).xy; }';

// the fragment shader is called for each pixel
let fs =
  varying +
  'uniform vec2 p;' +
  'uniform float r;' +
  'const int I = 500;' +
  'void main() {' +
  '  vec2 c = p + vPos * r, z = c;' +
  '  float n = 0.0;' +
  '  for (int i = I; i > 0; i --) {' +
  '    if(z.x*z.x+z.y*z.y > 4.0) {' +
  '      n = float(i)/float(I);' +
  '      break;' +
  '    }' +
  '    z = vec2(z.x*z.x-z.y*z.y, 2.0*z.x*z.y) + c;' +
  '  }' +
  '  gl_FragColor = vec4(0.5-cos(n*17.0)/2.0,0.5-cos(n*13.0)/2.0,0.5-cos(n*23.0)/2.0,1.0);' +
  '}';

let mandel;
function setup() {
  createCanvas(100, 100, WEBGL);

  // create and initialize the shader
  mandel = createShader(vs, fs);
  shader(mandel);
  noStroke();

  // 'p' is the center point of the Mandelbrot image
  mandel.setUniform('p', [-0.74364388703, 0.13182590421]);
}

function draw() {
  // 'r' is the size of the image in Mandelbrot-space
  mandel.setUniform('r', 1.5 * exp(-6.5 * (1 + sin(millis() / 2000))));
  quad(-1, -1, 1, -1, 1, 1, -1, 1);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>vertSrc</code> source code for the vertex shader

"##]
///
///
#[doc = r##"<code>fragSrc</code> source code for the fragment shader

"##]
///

pub static createShader: CreateShaderInternalType = CreateShaderInternalType;
#[doc(hidden)]
pub struct CreateShaderInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createShader")]
    fn createShader1103143503(_ : & str, _ : & str, ) ->  Shader;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateShaderInternalType {
    type Output =  Shader;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createShader1103143503.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createShader1103143503.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateShaderInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createShader1103143503.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/shader">shader()</a> function lets the user provide a custom shader
to fill in shapes in WEBGL mode. Users can create their
own shaders by loading vertex and fragment shaders with
<a href="#/p5/loadShader">loadShader()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Click within the image to toggle
// the shader used by the quad shape
// Note: for an alternative approach to the same example,
// involving changing uniforms please refer to:
// https://p5js.org/reference/#/p5.Shader/setUniform

let redGreen;
let orangeBlue;
let showRedGreen = false;

function preload() {
  // note that we are using two instances
  // of the same vertex and fragment shaders
  redGreen = loadShader('assets/shader.vert', 'assets/shader-gradient.frag');
  orangeBlue = loadShader('assets/shader.vert', 'assets/shader-gradient.frag');
}

function setup() {
  createCanvas(100, 100, WEBGL);

  // initialize the colors for redGreen shader
  shader(redGreen);
  redGreen.setUniform('colorCenter', [1.0, 0.0, 0.0]);
  redGreen.setUniform('colorBackground', [0.0, 1.0, 0.0]);

  // initialize the colors for orangeBlue shader
  shader(orangeBlue);
  orangeBlue.setUniform('colorCenter', [1.0, 0.5, 0.0]);
  orangeBlue.setUniform('colorBackground', [0.226, 0.0, 0.615]);

  noStroke();
}

function draw() {
  // update the offset values for each shader,
  // moving orangeBlue in vertical and redGreen
  // in horizontal direction
  orangeBlue.setUniform('offset', [0, sin(millis() / 2000) + 1]);
  redGreen.setUniform('offset', [sin(millis() / 2000), 1]);

  if (showRedGreen === true) {
    shader(redGreen);
  } else {
    shader(orangeBlue);
  }
  quad(-1, -1, 1, -1, 1, 1, -1, 1);
}

function mouseClicked() {
  showRedGreen = !showRedGreen;
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>s?</code> the desired p5.Shader to use for rendering
shapes.

"##]
///

pub static shader: ShaderInternalType = ShaderInternalType;
#[doc(hidden)]
pub struct ShaderInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shader")]
    fn shader2235502569(_ : & Shader, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Shader,)> for ShaderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Shader,)) -> Self::Output {
        shader2235502569.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Shader,)> for ShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Shader,)) -> Self::Output {
        shader2235502569.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Shader,)> for ShaderInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Shader,)) -> Self::Output {
        shader2235502569.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shader")]
    fn shader1269949606() ;
}

#[doc(hidden)]
impl FnOnce<()> for ShaderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        shader1269949606.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        shader1269949606.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ShaderInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        shader1269949606.call(args)
    }
}
#[doc=r##"<p>This function restores the default shaders in WEBGL mode. Code that runs
after resetShader() will not be affected by previously defined
shaders. Should be run after <a href="#/p5/shader">shader()</a>.</p>
"##]

pub static resetShader: ResetShaderInternalType = ResetShaderInternalType;
#[doc(hidden)]
pub struct ResetShaderInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "resetShader")]
    fn resetShader1665737980() ;
}

#[doc(hidden)]
impl FnOnce<()> for ResetShaderInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        resetShader1665737980.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ResetShaderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        resetShader1665737980.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ResetShaderInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        resetShader1665737980.call(args)
    }
}
#[doc=r##"<p>Normal material for geometry is a material that is not affected by light.
It is not reflective and is a placeholder material often used for debugging.
Surfaces facing the X-axis, become red, those facing the Y-axis, become green and those facing the Z-axis, become blue.
You can view all possible materials in this
<a href="https://p5js.org/examples/3d-materials.html">example</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  normalMaterial();
  sphere(40);
}
```"###]

pub static normalMaterial: NormalMaterialInternalType = NormalMaterialInternalType;
#[doc(hidden)]
pub struct NormalMaterialInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "normalMaterial")]
    fn normalMaterial1894598176() ;
}

#[doc(hidden)]
impl FnOnce<()> for NormalMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        normalMaterial1894598176.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NormalMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        normalMaterial1894598176.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NormalMaterialInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        normalMaterial1894598176.call(args)
    }
}
#[doc=r##"<p>Texture for geometry.  You can view other possible materials in this
<a href="https://p5js.org/examples/3d-materials.html">example</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}

function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(0);
  rotateZ(frameCount * 0.01);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  //pass image as texture
  texture(img);
  box(200, 200, 200);
}
```"###]
#[doc=r###"```rust
let pg;

function setup() {
  createCanvas(100, 100, WEBGL);
  pg = createGraphics(200, 200);
  pg.textSize(75);
}

function draw() {
  background(0);
  pg.background(255);
  pg.text('hello!', 0, 100);
  //pass image as texture
  texture(pg);
  rotateX(0.5);
  noStroke();
  plane(50);
}
```"###]
#[doc=r###"```rust
let vid;
function preload() {
  vid = createVideo('assets/fingers.mov');
  vid.hide();
}
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(0);
  //pass video frame as texture
  texture(vid);
  rect(-40, -40, 80, 80);
}

function mousePressed() {
  vid.loop();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>tex</code> 2-dimensional graphics
                   to render as texture

"##]
///

pub static texture: TextureInternalType = TextureInternalType;
#[doc(hidden)]
pub struct TextureInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "texture")]
    fn texture687108883(_ : & Image, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,)> for TextureInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,)) -> Self::Output {
        texture687108883.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,)> for TextureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,)) -> Self::Output {
        texture687108883.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,)> for TextureInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,)) -> Self::Output {
        texture687108883.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "texture")]
    fn texture1622397976(_ : & MediaElement, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ MediaElement,)> for TextureInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ MediaElement,)) -> Self::Output {
        texture1622397976.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ MediaElement,)> for TextureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ MediaElement,)) -> Self::Output {
        texture1622397976.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ MediaElement,)> for TextureInternalType {
    extern "rust-call" fn call(&self, args: (&'_ MediaElement,)) -> Self::Output {
        texture1622397976.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "texture")]
    fn texture1640822620(_ : & Graphics, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Graphics,)> for TextureInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Graphics,)) -> Self::Output {
        texture1640822620.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Graphics,)> for TextureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Graphics,)) -> Self::Output {
        texture1640822620.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Graphics,)> for TextureInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Graphics,)) -> Self::Output {
        texture1640822620.call(args)
    }
}
#[doc=r##"<p>Sets the coordinate space for texture mapping. The default mode is IMAGE
which refers to the actual coordinates of the image.
NORMAL refers to a normalized space of values ranging from 0 to 1.
This function only works in WEBGL mode.</p>
<p>With IMAGE, if an image is 100 x 200 pixels, mapping the image onto the entire
size of a quad would require the points (0,0) (100, 0) (100,200) (0,200).
The same mapping in NORMAL is (0,0) (1,0) (1,1) (0,1).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;

function preload() {
  img = loadImage('assets/laDefense.jpg');
}

function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  texture(img);
  textureMode(NORMAL);
  beginShape();
  vertex(-50, -50, 0, 0);
  vertex(50, -50, 1, 0);
  vertex(50, 50, 1, 1);
  vertex(-50, 50, 0, 1);
  endShape();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode</code> either IMAGE or NORMAL

"##]
///

pub static textureMode: TextureModeInternalType = TextureModeInternalType;
#[doc(hidden)]
pub struct TextureModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textureMode")]
    fn textureMode3563658509(_ : TEXTURE_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(TEXTURE_MODE,)> for TextureModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (TEXTURE_MODE,)) -> Self::Output {
        textureMode3563658509.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(TEXTURE_MODE,)> for TextureModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (TEXTURE_MODE,)) -> Self::Output {
        textureMode3563658509.call(args)
    }
}

#[doc(hidden)]
impl Fn<(TEXTURE_MODE,)> for TextureModeInternalType {
    extern "rust-call" fn call(&self, args: (TEXTURE_MODE,)) -> Self::Output {
        textureMode3563658509.call(args)
    }
}
#[doc=r##"<p>Sets the global texture wrapping mode. This controls how textures behave
when their uv's go outside of the 0 - 1 range. There are three options:
CLAMP, REPEAT, and MIRROR.</p>
<p>CLAMP causes the pixels at the edge of the texture to extend to the bounds
REPEAT causes the texture to tile repeatedly until reaching the bounds
MIRROR works similarly to REPEAT but it flips the texture with every new tile</p>
<p>REPEAT & MIRROR are only available if the texture
is a power of two size (128, 256, 512, 1024, etc.).</p>
<p>This method will affect all textures in your sketch until a subsequent
textureWrap call is made.</p>
<p>If only one argument is provided, it will be applied to both the
horizontal and vertical axes.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/rockies128.jpg');
}

function setup() {
  createCanvas(100, 100, WEBGL);
  textureWrap(MIRROR);
}

function draw() {
  background(0);

  let dX = mouseX;
  let dY = mouseY;

  let u = lerp(1.0, 2.0, dX);
  let v = lerp(1.0, 2.0, dY);

  scale(width / 2);

  texture(img);

  beginShape(TRIANGLES);
  vertex(-1, -1, 0, 0, 0);
  vertex(1, -1, 0, u, 0);
  vertex(1, 1, 0, u, v);

  vertex(1, 1, 0, u, v);
  vertex(-1, 1, 0, 0, v);
  vertex(-1, -1, 0, 0, 0);
  endShape();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>wrapX</code> either CLAMP, REPEAT, or MIRROR

"##]
///
///
#[doc = r##"<code>wrapY?</code> either CLAMP, REPEAT, or MIRROR

"##]
///

pub static textureWrap: TextureWrapInternalType = TextureWrapInternalType;
#[doc(hidden)]
pub struct TextureWrapInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textureWrap")]
    fn textureWrap420882032(_ : WRAP_X, _ : WRAP_Y, ) ;
}

#[doc(hidden)]
impl FnOnce<(WRAP_X,WRAP_Y,)> for TextureWrapInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (WRAP_X,WRAP_Y,)) -> Self::Output {
        textureWrap420882032.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(WRAP_X,WRAP_Y,)> for TextureWrapInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (WRAP_X,WRAP_Y,)) -> Self::Output {
        textureWrap420882032.call(args)
    }
}

#[doc(hidden)]
impl Fn<(WRAP_X,WRAP_Y,)> for TextureWrapInternalType {
    extern "rust-call" fn call(&self, args: (WRAP_X,WRAP_Y,)) -> Self::Output {
        textureWrap420882032.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textureWrap")]
    fn textureWrap2540824476(_ : WRAP_X, ) ;
}

#[doc(hidden)]
impl FnOnce<(WRAP_X,)> for TextureWrapInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (WRAP_X,)) -> Self::Output {
        textureWrap2540824476.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(WRAP_X,)> for TextureWrapInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (WRAP_X,)) -> Self::Output {
        textureWrap2540824476.call(args)
    }
}

#[doc(hidden)]
impl Fn<(WRAP_X,)> for TextureWrapInternalType {
    extern "rust-call" fn call(&self, args: (WRAP_X,)) -> Self::Output {
        textureWrap2540824476.call(args)
    }
}
#[doc=r##"<p>Ambient material for geometry with a given color. Ambient material defines the color the object reflects under any lighting.
For example, if the ambient material of an object is pure red, but the ambient lighting only contains green, the object will not reflect any light.
Here's an <a href="https://p5js.org/examples/3d-materials.html">example containing all possible materials</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  noStroke();
  ambientLight(200);
  ambientMaterial(70, 130, 230);
  sphere(40);
}
```"###]
#[doc=r###"```rust
// ambientLight is both red and blue (magenta),
// so object only reflects it's red and blue components
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(70);
  ambientLight(100); // white light
  ambientMaterial(255, 0, 255); // pink material
  box(30);
}
```"###]
#[doc=r###"```rust
// ambientLight is green. Since object does not contain
// green, it does not reflect any light
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(70);
  ambientLight(0, 255, 0); // green light
  ambientMaterial(255, 0, 255); // pink material
  box(30);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> gray value, red or hue value
                        (depending on the current color mode),

"##]
///
///
#[doc = r##"<code>v2?</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3?</code> blue or brightness value

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color, color Array, or CSS color string

"##]
///
///
/// ---
///

pub static ambientMaterial: AmbientMaterialInternalType = AmbientMaterialInternalType;
#[doc(hidden)]
pub struct AmbientMaterialInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientMaterial")]
    fn ambientMaterial3514194483(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for AmbientMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        ambientMaterial3514194483.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        ambientMaterial3514194483.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        ambientMaterial3514194483.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientMaterial")]
    fn ambientMaterial2780234946(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for AmbientMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        ambientMaterial2780234946.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        ambientMaterial2780234946.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        ambientMaterial2780234946.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientMaterial")]
    fn ambientMaterial228896057(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for AmbientMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        ambientMaterial228896057.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        ambientMaterial228896057.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        ambientMaterial228896057.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientMaterial")]
    fn ambientMaterial2230790634(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for AmbientMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        ambientMaterial2230790634.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for AmbientMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        ambientMaterial2230790634.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for AmbientMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        ambientMaterial2230790634.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientMaterial")]
    fn ambientMaterial1074646642(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for AmbientMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        ambientMaterial1074646642.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        ambientMaterial1074646642.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        ambientMaterial1074646642.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientMaterial")]
    fn ambientMaterial4123762854(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for AmbientMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        ambientMaterial4123762854.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        ambientMaterial4123762854.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for AmbientMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        ambientMaterial4123762854.call(args)
    }
}
#[doc=r##"<p>Sets the emissive color of the material used for geometry drawn to
the screen. This is a misnomer in the sense that the material does not
actually emit light that effects surrounding polygons. Instead,
it gives the appearance that the object is glowing. An emissive material
will display at full strength even if there is no light for it to reflect.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  noStroke();
  ambientLight(0);
  emissiveMaterial(130, 230, 0);
  sphere(40);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> gray value, red or hue value
                        (depending on the current color mode),

"##]
///
///
#[doc = r##"<code>v2?</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3?</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>a?</code> opacity

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color, color Array, or CSS color string

"##]
///
///
/// ---
///

pub static emissiveMaterial: EmissiveMaterialInternalType = EmissiveMaterialInternalType;
#[doc(hidden)]
pub struct EmissiveMaterialInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial1085112925(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        emissiveMaterial1085112925.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        emissiveMaterial1085112925.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        emissiveMaterial1085112925.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial3499544487(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        emissiveMaterial3499544487.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        emissiveMaterial3499544487.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        emissiveMaterial3499544487.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial1477521296(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        emissiveMaterial1477521296.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        emissiveMaterial1477521296.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        emissiveMaterial1477521296.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial1935825941(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        emissiveMaterial1935825941.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        emissiveMaterial1935825941.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        emissiveMaterial1935825941.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial2191204501(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        emissiveMaterial2191204501.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        emissiveMaterial2191204501.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        emissiveMaterial2191204501.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial3908629366(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        emissiveMaterial3908629366.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        emissiveMaterial3908629366.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        emissiveMaterial3908629366.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "emissiveMaterial")]
    fn emissiveMaterial2969483702(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for EmissiveMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        emissiveMaterial2969483702.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        emissiveMaterial2969483702.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for EmissiveMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        emissiveMaterial2969483702.call(args)
    }
}
#[doc=r##"<p>Specular material for geometry with a given color. Specular material is a shiny reflective material.
Like ambient material it also defines the color the object reflects under ambient lighting.
For example, if the specular material of an object is pure red, but the ambient lighting only contains green, the object will not reflect any light.
For all other types of light like point and directional light, a specular material will reflect the color of the light source to the viewer.
Here's an <a href="https://p5js.org/examples/3d-materials.html">example containing all possible materials</a>.</p>
"##]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>gray</code> number specifying value between white and black.

"##]
///
///
#[doc = r##"<code>alpha?</code> alpha value relative to current color range
                                (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>alpha?</code> alpha value relative to current color range
                                (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, or CSS color string

"##]
///
///
/// ---
///

pub static specularMaterial: SpecularMaterialInternalType = SpecularMaterialInternalType;
#[doc(hidden)]
pub struct SpecularMaterialInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial1579383874(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        specularMaterial1579383874.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        specularMaterial1579383874.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        specularMaterial1579383874.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial4239906708(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        specularMaterial4239906708.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        specularMaterial4239906708.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        specularMaterial4239906708.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial187021224(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        specularMaterial187021224.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        specularMaterial187021224.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        specularMaterial187021224.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial1529140662(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        specularMaterial1529140662.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        specularMaterial1529140662.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        specularMaterial1529140662.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial935427703(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        specularMaterial935427703.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        specularMaterial935427703.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        specularMaterial935427703.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial4109762938(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        specularMaterial4109762938.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        specularMaterial4109762938.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        specularMaterial4109762938.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularMaterial")]
    fn specularMaterial3103974152(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for SpecularMaterialInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        specularMaterial3103974152.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        specularMaterial3103974152.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for SpecularMaterialInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        specularMaterial3103974152.call(args)
    }
}
#[doc=r##"<p>Sets the amount of gloss in the surface of shapes.
Used in combination with specularMaterial() in setting
the material properties of shapes. The default and minimum value is 1.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  noStroke();
  let locX = mouseX - width / 2;
  let locY = mouseY - height / 2;
  ambientLight(60, 60, 60);
  pointLight(255, 255, 255, locX, locY, 50);
  specularMaterial(250);
  translate(-25, 0, 0);
  shininess(1);
  sphere(20);
  translate(50, 0, 0);
  shininess(20);
  sphere(20);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>shine</code> Degree of Shininess.
                      Defaults to 1.

"##]
///

pub static shininess: ShininessInternalType = ShininessInternalType;
#[doc(hidden)]
pub struct ShininessInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shininess")]
    fn shininess1181296280(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ShininessInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        shininess1181296280.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ShininessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        shininess1181296280.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ShininessInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        shininess1181296280.call(args)
    }
}
#[doc=r##"<p>p5.js communicates with the clock on your computer. The <a href="#/p5/day">day()</a> function
returns the current day as a value from 1 - 31.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let d = day();
text('Current day: \n' + d, 5, 50);
```"###]

pub static day: DayInternalType = DayInternalType;
#[doc(hidden)]
pub struct DayInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "day")]
    fn day1951778498() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for DayInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        day1951778498.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DayInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        day1951778498.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DayInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        day1951778498.call(args)
    }
}
#[doc=r##"<p>p5.js communicates with the clock on your computer. The <a href="#/p5/hour">hour()</a> function
returns the current hour as a value from 0 - 23.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let h = hour();
text('Current hour:\n' + h, 5, 50);
```"###]

pub static hour: HourInternalType = HourInternalType;
#[doc(hidden)]
pub struct HourInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hour")]
    fn hour1010888604() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for HourInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        hour1010888604.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for HourInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        hour1010888604.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for HourInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        hour1010888604.call(args)
    }
}
#[doc=r##"<p>p5.js communicates with the clock on your computer. The <a href="#/p5/minute">minute()</a> function
returns the current minute as a value from 0 - 59.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let m = minute();
text('Current minute: \n' + m, 5, 50);
```"###]

pub static minute: MinuteInternalType = MinuteInternalType;
#[doc(hidden)]
pub struct MinuteInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "minute")]
    fn minute997032401() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for MinuteInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        minute997032401.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MinuteInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        minute997032401.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MinuteInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        minute997032401.call(args)
    }
}
#[doc=r##"<p>Returns the number of milliseconds (thousandths of a second) since
starting the sketch (when <code>setup()</code> is called). This information is often
used for timing events and animation sequences.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let millisecond = millis();
text('Milliseconds \nrunning: \n' + millisecond, 5, 40);
```"###]

pub static millis: MillisInternalType = MillisInternalType;
#[doc(hidden)]
pub struct MillisInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "millis")]
    fn millis2773617350() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for MillisInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        millis2773617350.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MillisInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        millis2773617350.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MillisInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        millis2773617350.call(args)
    }
}
#[doc=r##"<p>p5.js communicates with the clock on your computer. The <a href="#/p5/month">month()</a> function
returns the current month as a value from 1 - 12.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let m = month();
text('Current month: \n' + m, 5, 50);
```"###]

pub static month: MonthInternalType = MonthInternalType;
#[doc(hidden)]
pub struct MonthInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "month")]
    fn month1138786635() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for MonthInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        month1138786635.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MonthInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        month1138786635.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MonthInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        month1138786635.call(args)
    }
}
#[doc=r##"<p>p5.js communicates with the clock on your computer. The <a href="#/p5/second">second()</a> function
returns the current second as a value from 0 - 59.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let s = second();
text('Current second: \n' + s, 5, 50);
```"###]

pub static second: SecondInternalType = SecondInternalType;
#[doc(hidden)]
pub struct SecondInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "second")]
    fn second3443935255() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for SecondInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        second3443935255.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for SecondInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        second3443935255.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for SecondInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        second3443935255.call(args)
    }
}
#[doc=r##"<p>p5.js communicates with the clock on your computer. The <a href="#/p5/year">year()</a> function
returns the current year as an integer (2014, 2015, 2016, etc).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let y = year();
text('Current year: \n' + y, 5, 50);
```"###]

pub static year: YearInternalType = YearInternalType;
#[doc(hidden)]
pub struct YearInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "year")]
    fn year218303772() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for YearInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        year218303772.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for YearInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        year218303772.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for YearInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        year218303772.call(args)
    }
}
#[doc=r##"<p>Sets the seed value for <a href="#/p5/random">random()</a>.</p>
<p>By default, <a href="#/p5/random">random()</a> produces different results each time the program
is run. Set the seed parameter to a constant to return the same
pseudo-random numbers each time the software is run.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
randomSeed(99);
for (let i = 0; i < 100; i++) {
  let r = random(0, 255);
  stroke(r);
  line(i, 0, i, 100);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>seed</code> the seed value

"##]
///

pub static randomSeed: RandomSeedInternalType = RandomSeedInternalType;
#[doc(hidden)]
pub struct RandomSeedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "randomSeed")]
    fn randomSeed2297871959(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RandomSeedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        randomSeed2297871959.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RandomSeedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        randomSeed2297871959.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RandomSeedInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        randomSeed2297871959.call(args)
    }
}
#[doc=r##"<p>Return a random floating-point number.</p>
<p>Takes either 0, 1 or 2 arguments.</p>
<p>If no argument is given, returns a random number from 0
up to (but not including) 1.</p>
<p>If one argument is given and it is a number, returns a random number from 0
up to (but not including) the number.</p>
<p>If one argument is given and it is an array, returns a random element from
that array.</p>
<p>If two arguments are given, returns a random number from the
first argument up to (but not including) the second argument.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
for (let i = 0; i < 100; i++) {
  let r = random(50);
  stroke(r * 5);
  line(50, i, 50 + r, i);
}
```"###]
#[doc=r###"```rust
for (let i = 0; i < 100; i++) {
  let r = random(-50, 50);
  line(50, i, 50 + r, i);
}
```"###]
#[doc=r###"```rust
// Get a random element from an array using the random(Array) syntax
let words = ['apple', 'bear', 'cat', 'dog'];
let word = random(words); // select random word
text(word, 10, 50); // draw the word
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>min?</code> the lower bound (inclusive)

"##]
///
///
#[doc = r##"<code>max?</code> the upper bound (exclusive)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>choices</code> the array to choose from

"##]
///
///
/// ---
///

pub static random: RandomInternalType = RandomInternalType;
#[doc(hidden)]
pub struct RandomInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "random")]
    fn random168459599(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for RandomInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        random168459599.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for RandomInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        random168459599.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for RandomInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        random168459599.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "random")]
    fn random1030429853(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RandomInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        random1030429853.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RandomInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        random1030429853.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RandomInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        random1030429853.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "random")]
    fn random184203624() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for RandomInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        random184203624.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RandomInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        random184203624.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RandomInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        random184203624.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "random")]
    fn random1165443980(_ : js_sys::Array, ) -> JsValue;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for RandomInternalType {
    type Output = JsValue;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        random1165443980.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for RandomInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        random1165443980.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for RandomInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        random1165443980.call(args)
    }
}
#[doc=r##"<p>Returns a random number fitting a Gaussian, or
 normal, distribution. There is theoretically no minimum or maximum
 value that <a href="#/p5/randomGaussian">randomGaussian()</a> might return. Rather, there is
 just a very low probability that values far from the mean will be
 returned; and a higher probability that numbers near the mean will
 be returned.
Takes either 0, 1 or 2 arguments.<br>
 If no args, returns a mean of 0 and standard deviation of 1.<br>
 If one arg, that arg is the mean (standard deviation is 1).<br>
 If two args, first is mean, second is standard deviation.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 for (let y = 0; y < 100; y++) {
   let x = randomGaussian(50, 15);
   line(50, y, x, y);
 }
 ```"###]
#[doc=r###"```rust
 let distribution = new Array(360);
function setup() {
   createCanvas(100, 100);
   for (let i = 0; i < distribution.length; i++) {
     distribution[i] = floor(randomGaussian(0, 15));
   }
 }
function draw() {
   background(204);
  translate(width / 2, width / 2);
  for (let i = 0; i < distribution.length; i++) {
     rotate(TWO_PI / distribution.length);
     stroke(0);
     let dist = abs(distribution[i]);
     line(0, 0, dist, 0);
   }
 }
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mean?</code> the mean

"##]
///
///
#[doc = r##"<code>sd?</code> the standard deviation

"##]
///

pub static randomGaussian: RandomGaussianInternalType = RandomGaussianInternalType;
#[doc(hidden)]
pub struct RandomGaussianInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "randomGaussian")]
    fn randomGaussian1267470261(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for RandomGaussianInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        randomGaussian1267470261.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for RandomGaussianInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        randomGaussian1267470261.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for RandomGaussianInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        randomGaussian1267470261.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "randomGaussian")]
    fn randomGaussian3967716940(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RandomGaussianInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        randomGaussian3967716940.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RandomGaussianInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        randomGaussian3967716940.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RandomGaussianInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        randomGaussian3967716940.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "randomGaussian")]
    fn randomGaussian633108403() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for RandomGaussianInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        randomGaussian633108403.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RandomGaussianInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        randomGaussian633108403.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RandomGaussianInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        randomGaussian633108403.call(args)
    }
}
#[doc=r##"<p>Use the <a href="#/p5/beginContour">beginContour()</a> and
<a href="#/p5/endContour">endContour()</a> functions to create negative shapes
within shapes such as the center of the letter 'O'. <a href="#/p5/beginContour">beginContour()</a>
begins recording vertices for the shape and <a href="#/p5/endContour">endContour()</a> stops recording.
The vertices that define a negative shape must "wind" in the opposite direction
from the exterior shape. First draw vertices for the exterior clockwise order, then for internal shapes, draw vertices
shape in counter-clockwise.</p>
<p>These functions can only be used within a <a href="#/p5/beginShape">beginShape()</a>/<a href="#/p5/endShape">endShape()</a> pair and
transformations such as <a href="#/p5/translate">translate()</a>, <a href="#/p5/rotate">rotate()</a>, and <a href="#/p5/scale">scale()</a> do not work
within a <a href="#/p5/beginContour">beginContour()</a>/<a href="#/p5/endContour">endContour()</a> pair. It is also not possible to use
other shapes, such as <a href="#/p5/ellipse">ellipse()</a> or <a href="#/p5/rect">rect()</a> within.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(50, 50);
stroke(255, 0, 0);
beginShape();
// Exterior part of shape, clockwise winding
vertex(-40, -40);
vertex(40, -40);
vertex(40, 40);
vertex(-40, 40);
// Interior part of shape, counter-clockwise winding
beginContour();
vertex(-20, -20);
vertex(-20, 20);
vertex(20, 20);
vertex(20, -20);
endContour();
endShape(CLOSE);
```"###]

pub static beginContour: BeginContourInternalType = BeginContourInternalType;
#[doc(hidden)]
pub struct BeginContourInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "beginContour")]
    fn beginContour1050088261() ;
}

#[doc(hidden)]
impl FnOnce<()> for BeginContourInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        beginContour1050088261.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for BeginContourInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        beginContour1050088261.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for BeginContourInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        beginContour1050088261.call(args)
    }
}
#[doc=r##"<p>Using the <a href="#/p5/beginShape">beginShape()</a> and <a href="#/p5/endShape">endShape()</a> functions allow creating more
complex forms. <a href="#/p5/beginShape">beginShape()</a> begins recording vertices for a shape and
<a href="#/p5/endShape">endShape()</a> stops recording. The value of the kind parameter tells it which
types of shapes to create from the provided vertices. With no mode
specified, the shape can be any irregular polygon.</p>
<p>The parameters available for <a href="#/p5/beginShape">beginShape()</a> are POINTS, LINES, TRIANGLES,
TRIANGLE_FAN, TRIANGLE_STRIP, QUADS, QUAD_STRIP, and TESS (WebGL only). After calling the
<a href="#/p5/beginShape">beginShape()</a> function, a series of <a href="#/p5/vertex">vertex()</a> commands must follow. To stop
drawing the shape, call <a href="#/p5/endShape">endShape()</a>. Each shape will be outlined with the
current stroke color and filled with the fill color.</p>
<p>Transformations such as <a href="#/p5/translate">translate()</a>, <a href="#/p5/rotate">rotate()</a>, and <a href="#/p5/scale">scale()</a> do not work
within <a href="#/p5/beginShape">beginShape()</a>. It is also not possible to use other shapes, such as
<a href="#/p5/ellipse">ellipse()</a> or <a href="#/p5/rect">rect()</a> within <a href="#/p5/beginShape">beginShape()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
beginShape();
vertex(30, 20);
vertex(85, 20);
vertex(85, 75);
vertex(30, 75);
endShape(CLOSE);
```"###]
#[doc=r###"```rust
beginShape(POINTS);
vertex(30, 20);
vertex(85, 20);
vertex(85, 75);
vertex(30, 75);
endShape();
```"###]
#[doc=r###"```rust
beginShape(LINES);
vertex(30, 20);
vertex(85, 20);
vertex(85, 75);
vertex(30, 75);
endShape();
```"###]
#[doc=r###"```rust
noFill();
beginShape();
vertex(30, 20);
vertex(85, 20);
vertex(85, 75);
vertex(30, 75);
endShape();
```"###]
#[doc=r###"```rust
noFill();
beginShape();
vertex(30, 20);
vertex(85, 20);
vertex(85, 75);
vertex(30, 75);
endShape(CLOSE);
```"###]
#[doc=r###"```rust
beginShape(TRIANGLES);
vertex(30, 75);
vertex(40, 20);
vertex(50, 75);
vertex(60, 20);
vertex(70, 75);
vertex(80, 20);
endShape();
```"###]
#[doc=r###"```rust
beginShape(TRIANGLE_STRIP);
vertex(30, 75);
vertex(40, 20);
vertex(50, 75);
vertex(60, 20);
vertex(70, 75);
vertex(80, 20);
vertex(90, 75);
endShape();
```"###]
#[doc=r###"```rust
beginShape(TRIANGLE_FAN);
vertex(57.5, 50);
vertex(57.5, 15);
vertex(92, 50);
vertex(57.5, 85);
vertex(22, 50);
vertex(57.5, 15);
endShape();
```"###]
#[doc=r###"```rust
beginShape(QUADS);
vertex(30, 20);
vertex(30, 75);
vertex(50, 75);
vertex(50, 20);
vertex(65, 20);
vertex(65, 75);
vertex(85, 75);
vertex(85, 20);
endShape();
```"###]
#[doc=r###"```rust
beginShape(QUAD_STRIP);
vertex(30, 20);
vertex(30, 75);
vertex(50, 20);
vertex(50, 75);
vertex(65, 20);
vertex(65, 75);
vertex(85, 20);
vertex(85, 75);
endShape();
```"###]
#[doc=r###"```rust
beginShape();
vertex(20, 20);
vertex(40, 20);
vertex(40, 40);
vertex(60, 40);
vertex(60, 60);
vertex(20, 60);
endShape(CLOSE);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>kind?</code> either POINTS, LINES, TRIANGLES, TRIANGLE_FAN
                               TRIANGLE_STRIP, QUADS, QUAD_STRIP or TESS

"##]
///

pub static beginShape: BeginShapeInternalType = BeginShapeInternalType;
#[doc(hidden)]
pub struct BeginShapeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "beginShape")]
    fn beginShape2906350777(_ : BEGIN_KIND, ) ;
}

#[doc(hidden)]
impl FnOnce<(BEGIN_KIND,)> for BeginShapeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (BEGIN_KIND,)) -> Self::Output {
        beginShape2906350777.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(BEGIN_KIND,)> for BeginShapeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (BEGIN_KIND,)) -> Self::Output {
        beginShape2906350777.call(args)
    }
}

#[doc(hidden)]
impl Fn<(BEGIN_KIND,)> for BeginShapeInternalType {
    extern "rust-call" fn call(&self, args: (BEGIN_KIND,)) -> Self::Output {
        beginShape2906350777.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "beginShape")]
    fn beginShape1797231439() ;
}

#[doc(hidden)]
impl FnOnce<()> for BeginShapeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        beginShape1797231439.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for BeginShapeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        beginShape1797231439.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for BeginShapeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        beginShape1797231439.call(args)
    }
}
#[doc=r##"<p>Specifies vertex coordinates for Bezier curves. Each call to
bezierVertex() defines the position of two control points and
one anchor point of a Bezier curve, adding a new segment to a
line or shape. For WebGL mode bezierVertex() can be used in 2D
as well as 3D mode. 2D mode expects 6 parameters, while 3D mode
expects 9 parameters (including z coordinates).</p>
<p>The first time bezierVertex() is used within a <a href="#/p5/beginShape">beginShape()</a>
call, it must be prefaced with a call to <a href="#/p5/vertex">vertex()</a> to set the first anchor
point. This function must be used between <a href="#/p5/beginShape">beginShape()</a> and <a href="#/p5/endShape">endShape()</a>
and only when there is no MODE or POINTS parameter specified to
<a href="#/p5/beginShape">beginShape()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
beginShape();
vertex(30, 20);
bezierVertex(80, 0, 80, 75, 30, 75);
endShape();
```"###]
#[doc=r###"```rust
beginShape();
vertex(30, 20);
bezierVertex(80, 0, 80, 75, 30, 75);
bezierVertex(50, 80, 60, 25, 30, 20);
endShape();
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  setAttributes('antialias', true);
}
function draw() {
  orbitControl();
  background(50);
  strokeWeight(4);
  stroke(255);
  point(-25, 30);
  point(25, 30);
  point(25, -30);
  point(-25, -30);

  strokeWeight(1);
  noFill();

  beginShape();
  vertex(-25, 30);
  bezierVertex(25, 30, 25, -30, -25, -30);
  endShape();

  beginShape();
  vertex(-25, 30, 20);
  bezierVertex(25, 30, 20, 25, -30, 20, -25, -30, 20);
  endShape();
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x2</code> x-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>x4</code> x-coordinate for the anchor point

"##]
///
///
#[doc = r##"<code>y4</code> y-coordinate for the anchor point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>x2</code> x-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>z2</code> z-coordinate for the first control point (for WebGL mode)

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>z3</code> z-coordinate for the second control point (for WebGL mode)

"##]
///
///
#[doc = r##"<code>x4</code> x-coordinate for the anchor point

"##]
///
///
#[doc = r##"<code>y4</code> y-coordinate for the anchor point

"##]
///
///
#[doc = r##"<code>z4</code> z-coordinate for the anchor point (for WebGL mode)

"##]
///
///
/// ---
///

pub static bezierVertex: BezierVertexInternalType = BezierVertexInternalType;
#[doc(hidden)]
pub struct BezierVertexInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezierVertex")]
    fn bezierVertex2775367343(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for BezierVertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierVertex2775367343.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for BezierVertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierVertex2775367343.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for BezierVertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierVertex2775367343.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezierVertex")]
    fn bezierVertex575448272(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierVertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierVertex575448272.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierVertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierVertex575448272.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierVertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierVertex575448272.call(args)
    }
}
#[doc=r##"<p>Specifies vertex coordinates for curves. This function may only
be used between <a href="#/p5/beginShape">beginShape()</a> and <a href="#/p5/endShape">endShape()</a> and only when there
is no MODE parameter specified to <a href="#/p5/beginShape">beginShape()</a>.
For WebGL mode curveVertex() can be used in 2D as well as 3D mode.
2D mode expects 2 parameters, while 3D mode expects 3 parameters.</p>
<p>The first and last points in a series of curveVertex() lines will be used to
guide the beginning and end of a the curve. A minimum of four
points is required to draw a tiny curve between the second and
third points. Adding a fifth point with curveVertex() will draw
the curve between the second, third, and fourth points. The
curveVertex() function is an implementation of Catmull-Rom
splines.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
strokeWeight(5);
point(84, 91);
point(68, 19);
point(21, 17);
point(32, 91);
strokeWeight(1);

noFill();
beginShape();
curveVertex(84, 91);
curveVertex(84, 91);
curveVertex(68, 19);
curveVertex(21, 17);
curveVertex(32, 91);
curveVertex(32, 91);
endShape();
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x</code> x-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the vertex

"##]
///
///
/// ---
///
///
#[doc = r##"<code>x</code> x-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>z?</code> z-coordinate of the vertex (for WebGL mode)

"##]
///
///
/// ---
///

pub static curveVertex: CurveVertexInternalType = CurveVertexInternalType;
#[doc(hidden)]
pub struct CurveVertexInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curveVertex")]
    fn curveVertex246087092(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CurveVertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        curveVertex246087092.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CurveVertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        curveVertex246087092.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CurveVertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        curveVertex246087092.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curveVertex")]
    fn curveVertex964829(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for CurveVertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        curveVertex964829.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for CurveVertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        curveVertex964829.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for CurveVertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        curveVertex964829.call(args)
    }
}
#[doc=r##"<p>Use the <a href="#/p5/beginContour">beginContour()</a> and <a href="#/p5/endContour">endContour()</a> functions to create negative
shapes within shapes such as the center of the letter 'O'. <a href="#/p5/beginContour">beginContour()</a>
begins recording vertices for the shape and <a href="#/p5/endContour">endContour()</a> stops recording.
The vertices that define a negative shape must "wind" in the opposite
direction from the exterior shape. First draw vertices for the exterior
clockwise order, then for internal shapes, draw vertices
shape in counter-clockwise.</p>
<p>These functions can only be used within a <a href="#/p5/beginShape">beginShape()</a>/<a href="#/p5/endShape">endShape()</a> pair and
transformations such as <a href="#/p5/translate">translate()</a>, <a href="#/p5/rotate">rotate()</a>, and <a href="#/p5/scale">scale()</a> do not work
within a <a href="#/p5/beginContour">beginContour()</a>/<a href="#/p5/endContour">endContour()</a> pair. It is also not possible to use
other shapes, such as <a href="#/p5/ellipse">ellipse()</a> or <a href="#/p5/rect">rect()</a> within.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(50, 50);
stroke(255, 0, 0);
beginShape();
// Exterior part of shape, clockwise winding
vertex(-40, -40);
vertex(40, -40);
vertex(40, 40);
vertex(-40, 40);
// Interior part of shape, counter-clockwise winding
beginContour();
vertex(-20, -20);
vertex(-20, 20);
vertex(20, 20);
vertex(20, -20);
endContour();
endShape(CLOSE);
```"###]

pub static endContour: EndContourInternalType = EndContourInternalType;
#[doc(hidden)]
pub struct EndContourInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "endContour")]
    fn endContour4039447446() ;
}

#[doc(hidden)]
impl FnOnce<()> for EndContourInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        endContour4039447446.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for EndContourInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        endContour4039447446.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for EndContourInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        endContour4039447446.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/endShape">endShape()</a> function is the companion to <a href="#/p5/beginShape">beginShape()</a> and may only be
called after <a href="#/p5/beginShape">beginShape()</a>. When <a href="#/p5/endshape">endShape()</a> is called, all of image data
defined since the previous call to <a href="#/p5/beginShape">beginShape()</a> is written into the image
buffer. The constant CLOSE as the value for the MODE parameter to close
the shape (to connect the beginning and the end).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();

beginShape();
vertex(20, 20);
vertex(45, 20);
vertex(45, 80);
endShape(CLOSE);

beginShape();
vertex(50, 20);
vertex(75, 20);
vertex(75, 80);
endShape();
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode?</code> use CLOSE to close the shape

"##]
///

pub static endShape: EndShapeInternalType = EndShapeInternalType;
#[doc(hidden)]
pub struct EndShapeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "endShape")]
    fn endShape1665854659(_ : END_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(END_MODE,)> for EndShapeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (END_MODE,)) -> Self::Output {
        endShape1665854659.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(END_MODE,)> for EndShapeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (END_MODE,)) -> Self::Output {
        endShape1665854659.call(args)
    }
}

#[doc(hidden)]
impl Fn<(END_MODE,)> for EndShapeInternalType {
    extern "rust-call" fn call(&self, args: (END_MODE,)) -> Self::Output {
        endShape1665854659.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "endShape")]
    fn endShape2595577121() ;
}

#[doc(hidden)]
impl FnOnce<()> for EndShapeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        endShape2595577121.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for EndShapeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        endShape2595577121.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for EndShapeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        endShape2595577121.call(args)
    }
}
#[doc=r##"<p>Specifies vertex coordinates for quadratic Bezier curves. Each call to
quadraticVertex() defines the position of one control points and one
anchor point of a Bezier curve, adding a new segment to a line or shape.
The first time quadraticVertex() is used within a <a href="#/p5/beginShape">beginShape()</a> call, it
must be prefaced with a call to <a href="#/p5/vertex">vertex()</a> to set the first anchor point.
For WebGL mode quadraticVertex() can be used in 2D as well as 3D mode.
2D mode expects 4 parameters, while 3D mode expects 6 parameters
(including z coordinates).</p>
<p>This function must be used between <a href="#/p5/beginShape">beginShape()</a> and <a href="#/p5/endShape">endShape()</a>
and only when there is no MODE or POINTS parameter specified to
<a href="#/p5/beginShape">beginShape()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
strokeWeight(5);
point(20, 20);
point(80, 20);
point(50, 50);

noFill();
strokeWeight(1);
beginShape();
vertex(20, 20);
quadraticVertex(80, 20, 50, 50);
endShape();
```"###]
#[doc=r###"```rust
strokeWeight(5);
point(20, 20);
point(80, 20);
point(50, 50);

point(20, 80);
point(80, 80);
point(80, 60);

noFill();
strokeWeight(1);
beginShape();
vertex(20, 20);
quadraticVertex(80, 20, 50, 50);
quadraticVertex(20, 80, 80, 80);
vertex(80, 60);
endShape();
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>cx</code> x-coordinate for the control point

"##]
///
///
#[doc = r##"<code>cy</code> y-coordinate for the control point

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the anchor point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the anchor point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>cx</code> x-coordinate for the control point

"##]
///
///
#[doc = r##"<code>cy</code> y-coordinate for the control point

"##]
///
///
#[doc = r##"<code>cz</code> z-coordinate for the control point (for WebGL mode)

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the anchor point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the anchor point

"##]
///
///
#[doc = r##"<code>z3</code> z-coordinate for the anchor point (for WebGL mode)

"##]
///
///
/// ---
///

pub static quadraticVertex: QuadraticVertexInternalType = QuadraticVertexInternalType;
#[doc(hidden)]
pub struct QuadraticVertexInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "quadraticVertex")]
    fn quadraticVertex1738647905(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for QuadraticVertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        quadraticVertex1738647905.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for QuadraticVertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        quadraticVertex1738647905.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for QuadraticVertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        quadraticVertex1738647905.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "quadraticVertex")]
    fn quadraticVertex3188658213(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for QuadraticVertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        quadraticVertex3188658213.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for QuadraticVertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        quadraticVertex3188658213.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for QuadraticVertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        quadraticVertex3188658213.call(args)
    }
}
#[doc=r##"<p>All shapes are constructed by connecting a series of vertices. <a href="#/p5/vertex">vertex()</a>
is used to specify the vertex coordinates for points, lines, triangles,
quads, and polygons. It is used exclusively within the <a href="#/p5/beginShape">beginShape()</a> and
<a href="#/p5/endShape">endShape()</a> functions.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
strokeWeight(3);
beginShape(POINTS);
vertex(30, 20);
vertex(85, 20);
vertex(85, 75);
vertex(30, 75);
endShape();
```"###]
#[doc=r###"```rust
createCanvas(100, 100, WEBGL);
background(240, 240, 240);
fill(237, 34, 93);
noStroke();
beginShape();
vertex(0, 35);
vertex(35, 0);
vertex(0, -35);
vertex(-35, 0);
endShape();
```"###]
#[doc=r###"```rust
createCanvas(100, 100, WEBGL);
background(240, 240, 240);
fill(237, 34, 93);
noStroke();
beginShape();
vertex(-10, 10);
vertex(0, 35);
vertex(10, 10);
vertex(35, 0);
vertex(10, -8);
vertex(0, -35);
vertex(-10, -8);
vertex(-35, 0);
endShape();
```"###]
#[doc=r###"```rust
strokeWeight(3);
stroke(237, 34, 93);
beginShape(LINES);
vertex(10, 35);
vertex(90, 35);
vertex(10, 65);
vertex(90, 65);
vertex(35, 10);
vertex(35, 90);
vertex(65, 10);
vertex(65, 90);
endShape();
```"###]
#[doc=r###"```rust
// Click to change the number of sides.
// In WebGL mode, custom shapes will only
// display hollow fill sections when
// all calls to vertex() use the same z-value.

let sides = 3;
let angle, px, py;

function setup() {
  createCanvas(100, 100, WEBGL);
  setAttributes('antialias', true);
  fill(237, 34, 93);
  strokeWeight(3);
}

function draw() {
  background(200);
  rotateX(frameCount * 0.01);
  rotateZ(frameCount * 0.01);
  ngon(sides, 0, 0, 80);
}

function mouseClicked() {
  if (sides > 6) {
    sides = 3;
  } else {
    sides++;
  }
}

function ngon(n, x, y, d) {
  beginShape(TESS);
  for (let i = 0; i < n + 1; i++) {
    angle = TWO_PI / n * i;
    px = x + sin(angle) * d / 2;
    py = y - cos(angle) * d / 2;
    vertex(px, py, 0);
  }
  for (let i = 0; i < n + 1; i++) {
    angle = TWO_PI / n * i;
    px = x + sin(angle) * d / 4;
    py = y - cos(angle) * d / 4;
    vertex(px, py, 0);
  }
  endShape();
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x</code> x-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the vertex

"##]
///
///
/// ---
///
///
#[doc = r##"<code>x</code> x-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>z</code> z-coordinate of the vertex

"##]
///
///
#[doc = r##"<code>u?</code> the vertex's texture u-coordinate

"##]
///
///
#[doc = r##"<code>v?</code> the vertex's texture v-coordinate

"##]
///
///
/// ---
///

pub static vertex: VertexInternalType = VertexInternalType;
#[doc(hidden)]
pub struct VertexInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "vertex")]
    fn vertex3459756243(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for VertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        vertex3459756243.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        vertex3459756243.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        vertex3459756243.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "vertex")]
    fn vertex876617044(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for VertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        vertex876617044.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        vertex876617044.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        vertex876617044.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "vertex")]
    fn vertex3675753857(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for VertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        vertex3675753857.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        vertex3675753857.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        vertex3675753857.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "vertex")]
    fn vertex3361236501(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for VertexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        vertex3361236501.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        vertex3361236501.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for VertexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        vertex3361236501.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/print">print()</a> function writes to the console area of
your browser. This function is often helpful for looking at the data a program
is producing. This function creates a new line of text for each call to
the function. Individual elements can be separated with quotes ("") and joined
with the addition operator (+).</p>
<p>Note that calling print() without any arguments invokes the window.print()
function which opens the browser's print dialog. To print a blank line
to console you can write print('\n').</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let x = 10;
print('The value of x is ' + x);
// prints "The value of x is 10"
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>contents</code> any combination of Number, String, Object, Boolean,
                      Array to print

"##]
///

pub static print: PrintInternalType = PrintInternalType;
#[doc(hidden)]
pub struct PrintInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "print")]
    fn print1524776357(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for PrintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        print1524776357.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for PrintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        print1524776357.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for PrintInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        print1524776357.call(args)
    }
}
#[doc=r##"<p>Sets the cursor to a predefined symbol or an image, or makes it visible
if already hidden. If you are trying to set an image as the cursor, the
recommended size is 16x16 or 32x32 pixels. The values for parameters x and y
must be less than the dimensions of the image.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Move the mouse across the quadrants
// to see the cursor change
function draw() {
  line(width / 2, 0, width / 2, height);
  line(0, height / 2, width, height / 2);
  if (mouseX < 50 && mouseY < 50) {
    cursor(CROSS);
  } else if (mouseX > 50 && mouseY < 50) {
    cursor('progress');
  } else if (mouseX > 50 && mouseY > 50) {
    cursor('https://avatars0.githubusercontent.com/u/1617169?s=16');
  } else {
    cursor('grab');
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>type</code> Built-In: either ARROW, CROSS, HAND, MOVE, TEXT and WAIT
                              Native CSS properties: 'grab', 'progress', 'cell' etc.
                              External: path for cursor's images
                              (Allowed File extensions: .cur, .gif, .jpg, .jpeg, .png)
                              For more information on Native CSS cursors and url visit:
                              https://developer.mozilla.org/en-US/docs/Web/CSS/cursor

"##]
///
///
#[doc = r##"<code>x?</code> the horizontal active spot of the cursor (must be less than 32)

"##]
///
///
#[doc = r##"<code>y?</code> the vertical active spot of the cursor (must be less than 32)

"##]
///

pub static cursor: CursorInternalType = CursorInternalType;
#[doc(hidden)]
pub struct CursorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cursor")]
    fn cursor2480658222(_ : & str, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,)> for CursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,)) -> Self::Output {
        cursor2480658222.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,)> for CursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,)) -> Self::Output {
        cursor2480658222.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,)> for CursorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,)) -> Self::Output {
        cursor2480658222.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cursor")]
    fn cursor305065760(_ : & str, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,)> for CursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,)) -> Self::Output {
        cursor305065760.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,)> for CursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,)) -> Self::Output {
        cursor305065760.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,)> for CursorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,)) -> Self::Output {
        cursor305065760.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cursor")]
    fn cursor3437256831(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        cursor3437256831.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        cursor3437256831.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CursorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        cursor3437256831.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cursor")]
    fn cursor3785854181(_ : CURSOR_TYPE, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(CURSOR_TYPE,f64,f64,)> for CursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (CURSOR_TYPE,f64,f64,)) -> Self::Output {
        cursor3785854181.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(CURSOR_TYPE,f64,f64,)> for CursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (CURSOR_TYPE,f64,f64,)) -> Self::Output {
        cursor3785854181.call(args)
    }
}

#[doc(hidden)]
impl Fn<(CURSOR_TYPE,f64,f64,)> for CursorInternalType {
    extern "rust-call" fn call(&self, args: (CURSOR_TYPE,f64,f64,)) -> Self::Output {
        cursor3785854181.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cursor")]
    fn cursor1525358950(_ : CURSOR_TYPE, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(CURSOR_TYPE,f64,)> for CursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (CURSOR_TYPE,f64,)) -> Self::Output {
        cursor1525358950.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(CURSOR_TYPE,f64,)> for CursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (CURSOR_TYPE,f64,)) -> Self::Output {
        cursor1525358950.call(args)
    }
}

#[doc(hidden)]
impl Fn<(CURSOR_TYPE,f64,)> for CursorInternalType {
    extern "rust-call" fn call(&self, args: (CURSOR_TYPE,f64,)) -> Self::Output {
        cursor1525358950.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cursor")]
    fn cursor1023755129(_ : CURSOR_TYPE, ) ;
}

#[doc(hidden)]
impl FnOnce<(CURSOR_TYPE,)> for CursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (CURSOR_TYPE,)) -> Self::Output {
        cursor1023755129.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(CURSOR_TYPE,)> for CursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (CURSOR_TYPE,)) -> Self::Output {
        cursor1023755129.call(args)
    }
}

#[doc(hidden)]
impl Fn<(CURSOR_TYPE,)> for CursorInternalType {
    extern "rust-call" fn call(&self, args: (CURSOR_TYPE,)) -> Self::Output {
        cursor1023755129.call(args)
    }
}
#[doc=r##"<p>Specifies the number of frames to be displayed every second. For example,
the function call frameRate(30) will attempt to refresh 30 times a second.
If the processor is not fast enough to maintain the specified rate, the
frame rate will not be achieved. Setting the frame rate within 
<a href="#/p5/setup">setup()</a> is recommended. The default frame rate is
based on the frame rate of the display (here also called "refresh rate"), 
which is set to 60 frames per second on most computers. A frame rate of 24
frames per second (usual for movies) or above will be enough for smooth 
animations. This is the same as setFrameRate(val).</p>
<p>Calling <a href="#/p5/frameRate">frameRate()</a> with no arguments returns
the current framerate. The draw function must run at least once before it will
return a value. This is the same as <a href="#/p5/getFrameRate">getFrameRate()</a>.</p>
<p>Calling <a href="#/p5/frameRate">frameRate()</a> with arguments that are not
of the type numbers or are non positive also returns current framerate.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let rectX = 0;
let fr = 30; //starting FPS
let clr;

function setup() {
  background(200);
  frameRate(fr); // Attempt to refresh at starting FPS
  clr = color(255, 0, 0);
}

function draw() {
  background(200);
  rectX = rectX += 1; // Move Rectangle

  if (rectX >= width) {
   // If you go off screen.
    if (fr === 30) {
      clr = color(0, 0, 255);
      fr = 10;
      frameRate(fr); // make frameRate 10 FPS
    } else {
      clr = color(255, 0, 0);
      fr = 30;
      frameRate(fr); // make frameRate 30 FPS
    }
    rectX = 0;
  }
  fill(clr);
  rect(rectX, 40, 20, 20);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>fps</code> number of frames to be displayed every second

"##]
///
///
/// ---
///
///
/// ---
///

pub static frameRate: FrameRateInternalType = FrameRateInternalType;
#[doc(hidden)]
pub struct FrameRateInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frameRate")]
    fn frameRate3290841073(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for FrameRateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        frameRate3290841073.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for FrameRateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        frameRate3290841073.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for FrameRateInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        frameRate3290841073.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frameRate")]
    fn frameRate2396126771() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for FrameRateInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        frameRate2396126771.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for FrameRateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        frameRate2396126771.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for FrameRateInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        frameRate2396126771.call(args)
    }
}
#[doc=r##"<p>Hides the cursor from view.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  noCursor();
}

function draw() {
  background(200);
  ellipse(mouseX, mouseY, 10, 10);
}
```"###]

pub static noCursor: NoCursorInternalType = NoCursorInternalType;
#[doc(hidden)]
pub struct NoCursorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noCursor")]
    fn noCursor1879471527() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoCursorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noCursor1879471527.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoCursorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noCursor1879471527.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoCursorInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noCursor1879471527.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/windowResized">windowResized()</a> function is called once
every time the browser window is resized. This is a good place to resize the
canvas or do any other adjustments to accommodate the new window size.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(windowWidth, windowHeight);
}

function draw() {
  background(0, 100, 200);
}

function windowResized() {
  resizeCanvas(windowWidth, windowHeight);
}
```"###]

pub static windowResized: WindowResizedInternalType = WindowResizedInternalType;
#[doc(hidden)]
pub struct WindowResizedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "windowResized")]
    fn windowResized186037077() ;
}

#[doc(hidden)]
impl FnOnce<()> for WindowResizedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        windowResized186037077.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for WindowResizedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        windowResized186037077.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for WindowResizedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        windowResized186037077.call(args)
    }
}
#[doc=r##"<p>If argument is given, sets the sketch to fullscreen or not based on the
value of the argument. If no argument is given, returns the current
fullscreen state. Note that due to browser restrictions this can only
be called on user input, for example, on mouse press like the example
below.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Clicking in the box toggles fullscreen on and off.
function setup() {
  background(200);
}
function mousePressed() {
  if (mouseX > 0 && mouseX < 100 && mouseY > 0 && mouseY < 100) {
    let fs = fullscreen();
    fullscreen(!fs);
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>val?</code> whether the sketch should be in fullscreen mode
or not

"##]
///

pub static fullscreen: FullscreenInternalType = FullscreenInternalType;
#[doc(hidden)]
pub struct FullscreenInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fullscreen")]
    fn fullscreen2375952396(_ : bool, ) -> bool;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for FullscreenInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        fullscreen2375952396.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for FullscreenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        fullscreen2375952396.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for FullscreenInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        fullscreen2375952396.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fullscreen")]
    fn fullscreen1366928332() -> bool;
}

#[doc(hidden)]
impl FnOnce<()> for FullscreenInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        fullscreen1366928332.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for FullscreenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        fullscreen1366928332.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for FullscreenInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        fullscreen1366928332.call(args)
    }
}
#[doc=r##"<p>Sets the pixel scaling for high pixel density displays. By default
pixel density is set to match display density, call pixelDensity(1)
to turn this off. Calling <a href="#/p5/pixelDensity">pixelDensity()</a> with no arguments returns
the current pixel density of the sketch.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  pixelDensity(1);
  createCanvas(100, 100);
  background(200);
  ellipse(width / 2, height / 2, 50, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  pixelDensity(3.0);
  createCanvas(100, 100);
  background(200);
  ellipse(width / 2, height / 2, 50, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>val</code> whether or how much the sketch should scale

"##]
///
///
/// ---
///
///
/// ---
///

pub static pixelDensity: PixelDensityInternalType = PixelDensityInternalType;
#[doc(hidden)]
pub struct PixelDensityInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pixelDensity")]
    fn pixelDensity3282118024(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for PixelDensityInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        pixelDensity3282118024.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for PixelDensityInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        pixelDensity3282118024.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for PixelDensityInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        pixelDensity3282118024.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pixelDensity")]
    fn pixelDensity3310621824() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for PixelDensityInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        pixelDensity3310621824.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for PixelDensityInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        pixelDensity3310621824.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for PixelDensityInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        pixelDensity3310621824.call(args)
    }
}
#[doc=r##"<p>Returns the pixel density of the current display the sketch is running on.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let density = displayDensity();
  pixelDensity(density);
  createCanvas(100, 100);
  background(200);
  ellipse(width / 2, height / 2, 50, 50);
}
```"###]

pub static displayDensity: DisplayDensityInternalType = DisplayDensityInternalType;
#[doc(hidden)]
pub struct DisplayDensityInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "displayDensity")]
    fn displayDensity4222169589() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for DisplayDensityInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        displayDensity4222169589.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DisplayDensityInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        displayDensity4222169589.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DisplayDensityInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        displayDensity4222169589.call(args)
    }
}
#[doc=r##"<p>Gets the current URL.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let url;
let x = 100;

function setup() {
  fill(0);
  noStroke();
  url = getURL();
}

function draw() {
  background(200);
  text(url, x, height / 2);
  x--;
}
```"###]

pub static getURL: GetUrlInternalType = GetUrlInternalType;
#[doc(hidden)]
pub struct GetUrlInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "getURL")]
    fn getURL1989040082() -> String;
}

#[doc(hidden)]
impl FnOnce<()> for GetUrlInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        getURL1989040082.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for GetUrlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        getURL1989040082.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for GetUrlInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        getURL1989040082.call(args)
    }
}
#[doc=r##"<p>Gets the current URL path as an array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let urlPath = getURLPath();
  for (let i = 0; i < urlPath.length; i++) {
    text(urlPath[i], 10, i * 20 + 20);
  }
}
```"###]

pub static getURLPath: GetUrlPathInternalType = GetUrlPathInternalType;
#[doc(hidden)]
pub struct GetUrlPathInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "getURLPath")]
    fn getURLPath2409735778() ;
}

#[doc(hidden)]
impl FnOnce<()> for GetUrlPathInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        getURLPath2409735778.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for GetUrlPathInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        getURLPath2409735778.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for GetUrlPathInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        getURLPath2409735778.call(args)
    }
}
#[doc=r##"<p>Gets the current URL params as an Object.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Example: http://p5js.org?year=2014&month=May&day=15

function setup() {
  let params = getURLParams();
  text(params.day, 10, 20);
  text(params.month, 10, 40);
  text(params.year, 10, 60);
}
```"###]

pub static getURLParams: GetUrlParamsInternalType = GetUrlParamsInternalType;
#[doc(hidden)]
pub struct GetUrlParamsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "getURLParams")]
    fn getURLParams765962837() -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<()> for GetUrlParamsInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        getURLParams765962837.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for GetUrlParamsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        getURLParams765962837.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for GetUrlParamsInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        getURLParams765962837.call(args)
    }
}
#[doc=r##"<p>Searches the page for the first element that matches the given CSS selector string (can be an
ID, class, tag name or a combination) and returns it as a <a href="#/p5.Element">p5.Element</a>.
The DOM node itself can be accessed with .elt.
Returns null if none found. You can also specify a container to search within.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(50, 50);
  background(30);
  // move canvas down and right
  select('canvas').position(10, 30);
}
```"###]
#[doc=r###"```rust
// select using ID
let a = select('#container');
let b = select('#beep', '#container');
let c;
if (a) {
  // select using class
  c = select('.boop', a);
}
// select using CSS selector string
let d = select('#container #bleep');
let e = select('#container p');
[a, b, c, d, e]; // unused
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>selectors</code> CSS selector string of element to search for

"##]
///
///
#[doc = r##"<code>container?</code> CSS selector string, p5.Element, or
                                            HTML element to search within

"##]
///

pub static select: SelectInternalType = SelectInternalType;
#[doc(hidden)]
pub struct SelectInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "select")]
    fn select1299716869(_ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for SelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        select1299716869.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for SelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        select1299716869.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for SelectInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        select1299716869.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "select")]
    fn select1227328385(_ : & str, _ : & Element, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Element,)> for SelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Element,)) -> Self::Output {
        select1227328385.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Element,)> for SelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Element,)) -> Self::Output {
        select1227328385.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Element,)> for SelectInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Element,)) -> Self::Output {
        select1227328385.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "select")]
    fn select3121156613(_ : & str, _ : HTMLElement, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,HTMLElement,)> for SelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,HTMLElement,)) -> Self::Output {
        select3121156613.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,HTMLElement,)> for SelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,HTMLElement,)) -> Self::Output {
        select3121156613.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,HTMLElement,)> for SelectInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,HTMLElement,)) -> Self::Output {
        select3121156613.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "select")]
    fn select3102929777(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        select3102929777.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        select3102929777.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SelectInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        select3102929777.call(args)
    }
}
#[doc=r##"<p>Searches the page for elements that match the given CSS selector string (can be an ID a class,
tag name or a combination) and returns them as <a href="#/p5.Element">p5.Element</a>s in
an array.
The DOM node itself can be accessed with .elt.
Returns an empty array if none found.
You can also specify a container to search within.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createButton('btn');
  createButton('2nd btn');
  createButton('3rd btn');
  let buttons = selectAll('button');

  for (let i = 0; i < buttons.length; i++) {
    buttons[i].size(100, 100);
  }
}
```"###]
#[doc=r###"```rust
// these are all valid calls to selectAll()
let a = selectAll('.beep');
a = selectAll('div');
a = selectAll('button', '#container');

let b = createDiv();
b.id('container');
let c = select('#container');
a = selectAll('p', c);
a = selectAll('#container p');

let d = document.getElementById('container');
a = selectAll('.boop', d);
a = selectAll('#container .boop');
console.log(a);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>selectors</code> CSS selector string of elements to search for

"##]
///
///
#[doc = r##"<code>container?</code> CSS selector string, p5.Element
                                            , or HTML element to search within

"##]
///

pub static selectAll: SelectAllInternalType = SelectAllInternalType;
#[doc(hidden)]
pub struct SelectAllInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "selectAll")]
    fn selectAll3091447704(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for SelectAllInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        selectAll3091447704.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for SelectAllInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        selectAll3091447704.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for SelectAllInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        selectAll3091447704.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "selectAll")]
    fn selectAll4223266408(_ : & str, _ : & Element, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Element,)> for SelectAllInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Element,)) -> Self::Output {
        selectAll4223266408.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Element,)> for SelectAllInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Element,)) -> Self::Output {
        selectAll4223266408.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Element,)> for SelectAllInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Element,)) -> Self::Output {
        selectAll4223266408.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "selectAll")]
    fn selectAll3133233034(_ : & str, _ : HTMLElement, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,HTMLElement,)> for SelectAllInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,HTMLElement,)) -> Self::Output {
        selectAll3133233034.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,HTMLElement,)> for SelectAllInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,HTMLElement,)) -> Self::Output {
        selectAll3133233034.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,HTMLElement,)> for SelectAllInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,HTMLElement,)) -> Self::Output {
        selectAll3133233034.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "selectAll")]
    fn selectAll3956998421(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SelectAllInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        selectAll3956998421.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SelectAllInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        selectAll3956998421.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SelectAllInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        selectAll3956998421.call(args)
    }
}
#[doc=r##"<p>Removes all elements created by p5, except any canvas / graphics
elements created by <a href="#/p5/createCanvas">createCanvas</a> or <a href="#/p5/createGraphics">createGraphics</a>.
Event handlers are removed, and element is removed from the DOM.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100);
  createDiv('this is some text');
  createP('this is a paragraph');
}
function mousePressed() {
  removeElements(); // this will remove the div and p, not canvas
}
```"###]

pub static removeElements: RemoveElementsInternalType = RemoveElementsInternalType;
#[doc(hidden)]
pub struct RemoveElementsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "removeElements")]
    fn removeElements94905408() ;
}

#[doc(hidden)]
impl FnOnce<()> for RemoveElementsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        removeElements94905408.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RemoveElementsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        removeElements94905408.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RemoveElementsInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        removeElements94905408.call(args)
    }
}
#[doc=r##"<p>The .<a href="#/p5.Element/changed">changed()</a> function is called when the value of an
element changes.
This can be used to attach an element specific event listener.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let sel;

function setup() {
  textAlign(CENTER);
  background(200);
  sel = createSelect();
  sel.position(10, 10);
  sel.option('pear');
  sel.option('kiwi');
  sel.option('grape');
  sel.changed(mySelectEvent);
}

function mySelectEvent() {
  let item = sel.value();
  background(200);
  text("it's a " + item + '!', 50, 50);
}
```"###]
#[doc=r###"```rust
let checkbox;
let cnv;

function setup() {
  checkbox = createCheckbox(' fill');
  checkbox.changed(changeFill);
  cnv = createCanvas(100, 100);
  cnv.position(0, 30);
  noFill();
}

function draw() {
  background(200);
  ellipse(50, 50, 50, 50);
}

function changeFill() {
  if (checkbox.checked()) {
    fill(0);
  } else {
    noFill();
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>fxn</code> function to be fired when the value of
                               an element changes.
                               if false is passed instead, the previously
                               firing function will no longer fire.

"##]
///

pub static changed: ChangedInternalType = ChangedInternalType;
#[doc(hidden)]
pub struct ChangedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "changed")]
    fn changed424200743(_ : js_sys::Function, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Function,)> for ChangedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Function,)) -> Self::Output {
        changed424200743.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Function,)> for ChangedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Function,)) -> Self::Output {
        changed424200743.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Function,)> for ChangedInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Function,)) -> Self::Output {
        changed424200743.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "changed")]
    fn changed1817070758(_ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for ChangedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        changed1817070758.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for ChangedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        changed1817070758.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for ChangedInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        changed1817070758.call(args)
    }
}
#[doc=r##"<p>The .<a href="#/p5.Element/input">input()</a> function is called when any user input is
detected with an element. The input event is often used
to detect keystrokes in a input element, or changes on a
slider element. This can be used to attach an element specific
event listener.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Open your console to see the output
function setup() {
  let inp = createInput('');
  inp.input(myInputEvent);
}

function myInputEvent() {
  console.log('you are typing: ', this.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>fxn</code> function to be fired when any user input is
                               detected within the element.
                               if false is passed instead, the previously
                               firing function will no longer fire.

"##]
///

pub static input: InputInternalType = InputInternalType;
#[doc(hidden)]
pub struct InputInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "input")]
    fn input198261589(_ : js_sys::Function, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Function,)> for InputInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Function,)) -> Self::Output {
        input198261589.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Function,)> for InputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Function,)) -> Self::Output {
        input198261589.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Function,)> for InputInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Function,)) -> Self::Output {
        input198261589.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "input")]
    fn input2448326341(_ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for InputInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        input2448326341.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for InputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        input2448326341.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for InputInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        input2448326341.call(args)
    }
}
#[doc=r##"<p>Creates a <div></div> element in the DOM with given inner HTML.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createDiv('this is some text');
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>html?</code> inner HTML for element created

"##]
///

pub static createDiv: CreateDivInternalType = CreateDivInternalType;
#[doc(hidden)]
pub struct CreateDivInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createDiv")]
    fn createDiv2263274510(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateDivInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createDiv2263274510.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateDivInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createDiv2263274510.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateDivInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createDiv2263274510.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createDiv")]
    fn createDiv3804873802() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateDivInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createDiv3804873802.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateDivInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createDiv3804873802.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateDivInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createDiv3804873802.call(args)
    }
}
#[doc=r##"<p>Creates a <p></p> element in the DOM with given inner HTML. Used
for paragraph length text.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createP('this is some text');
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>html?</code> inner HTML for element created

"##]
///

pub static createP: CreatePInternalType = CreatePInternalType;
#[doc(hidden)]
pub struct CreatePInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createP")]
    fn createP865021291(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreatePInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createP865021291.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreatePInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createP865021291.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreatePInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createP865021291.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createP")]
    fn createP440791393() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreatePInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createP440791393.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreatePInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createP440791393.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreatePInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createP440791393.call(args)
    }
}
#[doc=r##"<p>Creates a <span></span> element in the DOM with given inner HTML.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createSpan('this is some text');
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>html?</code> inner HTML for element created

"##]
///

pub static createSpan: CreateSpanInternalType = CreateSpanInternalType;
#[doc(hidden)]
pub struct CreateSpanInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSpan")]
    fn createSpan3531062537(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateSpanInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createSpan3531062537.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateSpanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createSpan3531062537.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateSpanInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createSpan3531062537.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSpan")]
    fn createSpan1628100264() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateSpanInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createSpan1628100264.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateSpanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createSpan1628100264.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateSpanInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createSpan1628100264.call(args)
    }
}
#[doc=r##"<p>Creates an <img> element in the DOM with given src and
alternate text.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createImg(
  'https://p5js.org/assets/img/asterisk-01.png',
  'the p5 magenta asterisk'
);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>src</code> src path or url for image

"##]
///
///
#[doc = r##"<code>alt</code> alternate text to be used if image does not load. You can use also an empty string ("") if that an image is not intended to be viewed.

"##]
///
///
/// ---
///
///
#[doc = r##"<code>src</code> src path or url for image

"##]
///
///
#[doc = r##"<code>alt</code> alternate text to be used if image does not load. You can use also an empty string ("") if that an image is not intended to be viewed.

"##]
///
///
#[doc = r##"<code>crossOrigin</code> crossOrigin property of the img element; use either 'anonymous' or 'use-credentials' to retrieve the image with cross-origin access (for later use with canvas. if an empty string("") is passed, CORS is not used

"##]
///
///
#[doc = r##"<code>successCallback?</code> callback to be called once image data is loaded with the p5.Element as argument

"##]
///
///
/// ---
///

pub static createImg: CreateImgInternalType = CreateImgInternalType;
#[doc(hidden)]
pub struct CreateImgInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createImg")]
    fn createImg2928187295(_ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateImgInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createImg2928187295.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateImgInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createImg2928187295.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateImgInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createImg2928187295.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createImg")]
    fn createImg873154382(_ : & str, _ : & str, _ : & str, _ : js_sys::Function, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,js_sys::Function,)> for CreateImgInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        createImg873154382.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,js_sys::Function,)> for CreateImgInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        createImg873154382.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,js_sys::Function,)> for CreateImgInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        createImg873154382.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createImg")]
    fn createImg3719171023(_ : & str, _ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,)> for CreateImgInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        createImg3719171023.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,)> for CreateImgInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        createImg3719171023.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,)> for CreateImgInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        createImg3719171023.call(args)
    }
}
#[doc=r##"<p>Creates an <a></a> element in the DOM for including a hyperlink.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createA('http://p5js.org/', 'this is a link');
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>href</code> url of page to link to

"##]
///
///
#[doc = r##"<code>html</code> inner html of link element to display

"##]
///
///
#[doc = r##"<code>target?</code> target where new link should open,
                            could be _blank, _self, _parent, _top.

"##]
///

pub static createA: CreateAInternalType = CreateAInternalType;
#[doc(hidden)]
pub struct CreateAInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createA")]
    fn createA3632435748(_ : & str, _ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,)> for CreateAInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        createA3632435748.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,)> for CreateAInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        createA3632435748.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,)> for CreateAInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        createA3632435748.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createA")]
    fn createA2403112289(_ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateAInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createA2403112289.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateAInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createA2403112289.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateAInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createA2403112289.call(args)
    }
}
#[doc=r##"<p>Creates a slider input element in the DOM.
Use .size() to set the display length of the slider.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let slider;
function setup() {
  slider = createSlider(0, 255, 100);
  slider.position(10, 10);
  slider.style('width', '80px');
}

function draw() {
  let val = slider.value();
  background(val);
}
```"###]
#[doc=r###"```rust
let slider;
function setup() {
  colorMode(HSB);
  slider = createSlider(0, 360, 60, 40);
  slider.position(10, 10);
  slider.style('width', '80px');
}

function draw() {
  let val = slider.value();
  background(val, 100, 100, 1);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>min</code> minimum value of the slider

"##]
///
///
#[doc = r##"<code>max</code> maximum value of the slider

"##]
///
///
#[doc = r##"<code>value?</code> default value of the slider

"##]
///
///
#[doc = r##"<code>step?</code> step size for each tick of the slider (if step is set to 0, the slider will move continuously from the minimum to the maximum value)

"##]
///

pub static createSlider: CreateSliderInternalType = CreateSliderInternalType;
#[doc(hidden)]
pub struct CreateSliderInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSlider")]
    fn createSlider2597645979(_ : f64, _ : f64, _ : f64, _ : f64, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for CreateSliderInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        createSlider2597645979.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for CreateSliderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        createSlider2597645979.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for CreateSliderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        createSlider2597645979.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSlider")]
    fn createSlider104756977(_ : f64, _ : f64, _ : f64, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for CreateSliderInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        createSlider104756977.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for CreateSliderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        createSlider104756977.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for CreateSliderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        createSlider104756977.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSlider")]
    fn createSlider337851529(_ : f64, _ : f64, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CreateSliderInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        createSlider337851529.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CreateSliderInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        createSlider337851529.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CreateSliderInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        createSlider337851529.call(args)
    }
}
#[doc=r##"<p>Creates a button element in the DOM.
Use .size() to set the display size of the button.
Use .mousePressed() to specify behavior on press.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let button;
function setup() {
  createCanvas(100, 100);
  background(0);
  button = createButton('click me');
  button.position(19, 19);
  button.mousePressed(changeBG);
}

function changeBG() {
  let val = random(255);
  background(val);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>label</code> label displayed on the button

"##]
///
///
#[doc = r##"<code>value?</code> value of the button

"##]
///

pub static createButton: CreateButtonInternalType = CreateButtonInternalType;
#[doc(hidden)]
pub struct CreateButtonInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createButton")]
    fn createButton962234210(_ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateButtonInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createButton962234210.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateButtonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createButton962234210.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateButtonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createButton962234210.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createButton")]
    fn createButton2120256578(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateButtonInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createButton2120256578.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateButtonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createButton2120256578.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateButtonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createButton2120256578.call(args)
    }
}
#[doc=r##"<p>Creates a checkbox input element in the DOM.
Calling .checked() on a checkbox returns if it is checked or not</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let checkbox;

function setup() {
  checkbox = createCheckbox('label', false);
  checkbox.changed(myCheckedEvent);
}

function myCheckedEvent() {
  if (this.checked()) {
    console.log('Checking!');
  } else {
    console.log('Unchecking!');
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>label?</code> label displayed after checkbox

"##]
///
///
#[doc = r##"<code>value?</code> value of the checkbox; checked is true, unchecked is false

"##]
///

pub static createCheckbox: CreateCheckboxInternalType = CreateCheckboxInternalType;
#[doc(hidden)]
pub struct CreateCheckboxInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCheckbox")]
    fn createCheckbox2612799455(_ : & str, _ : bool, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,)> for CreateCheckboxInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,)) -> Self::Output {
        createCheckbox2612799455.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,)> for CreateCheckboxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,)) -> Self::Output {
        createCheckbox2612799455.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,)> for CreateCheckboxInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,)) -> Self::Output {
        createCheckbox2612799455.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCheckbox")]
    fn createCheckbox2724572597(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateCheckboxInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createCheckbox2724572597.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateCheckboxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createCheckbox2724572597.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateCheckboxInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createCheckbox2724572597.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCheckbox")]
    fn createCheckbox2693872504() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateCheckboxInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createCheckbox2693872504.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateCheckboxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createCheckbox2693872504.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateCheckboxInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createCheckbox2693872504.call(args)
    }
}
#[doc=r##"<p>Creates a dropdown menu select element in the DOM.
It also helps to assign select-box methods to <a href="#/p5.Element">p5.Element</a> when selecting existing select box.</p>
<ul>
<li><code>.option(name, [value])</code> can be used to set options for the select after it is created.</li>
<li><code>.value()</code> will return the currently selected option.</li>
<li><code>.selected()</code> will return current dropdown element which is an instance of <a href="#/p5.Element">p5.Element</a></li>
<li><code>.selected(value)</code> can be used to make given option selected by default when the page first loads.</li>
<li><code>.disable()</code> marks whole of dropdown element as disabled.</li>
<li><code>.disable(value)</code> marks given option as disabled</li>
</ul>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let sel;

function setup() {
  textAlign(CENTER);
  background(200);
  sel = createSelect();
  sel.position(10, 10);
  sel.option('pear');
  sel.option('kiwi');
  sel.option('grape');
  sel.selected('kiwi');
  sel.changed(mySelectEvent);
}

function mySelectEvent() {
  let item = sel.value();
  background(200);
  text('It is a ' + item + '!', 50, 50);
}
```"###]
#[doc=r###"```rust
let sel;

function setup() {
  textAlign(CENTER);
  background(200);
  sel = createSelect();
  sel.position(10, 10);
  sel.option('oil');
  sel.option('milk');
  sel.option('bread');
  sel.disable('milk');
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>multiple?</code> true if dropdown should support multiple selections

"##]
///
///
/// ---
///
///
#[doc = r##"<code>existing</code> DOM select element

"##]
///
///
/// ---
///

pub static createSelect: CreateSelectInternalType = CreateSelectInternalType;
#[doc(hidden)]
pub struct CreateSelectInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSelect")]
    fn createSelect3213040229(_ : bool, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for CreateSelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        createSelect3213040229.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for CreateSelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        createSelect3213040229.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for CreateSelectInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        createSelect3213040229.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSelect")]
    fn createSelect3069567093() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateSelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createSelect3069567093.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateSelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createSelect3069567093.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateSelectInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createSelect3069567093.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createSelect")]
    fn createSelect3941036233(_ : JsValue, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for CreateSelectInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        createSelect3941036233.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for CreateSelectInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        createSelect3941036233.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for CreateSelectInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        createSelect3941036233.call(args)
    }
}
#[doc=r##"<p>Creates a radio button element in the DOM.It also helps existing radio buttons
assign methods of <a href="#/p5.Element/">p5.Element</a>.</p>
<ul>
<li><code>.option(value, [label])</code> can be used to create a new option for the
element. If an option with a value already exists, it will be returned.
Optionally, a label can be provided as second argument for the option.</li>
<li><code>.remove(value)</code> can be used to remove an option for the element.</li>
<li><code>.value()</code> method will return the currently selected value.</li>
<li><code>.selected()</code> method will return the currently selected input element.</li>
<li><code>.selected(value)</code> method will select the option and return it.</li>
<li><code>.disable(Boolean)</code> method will enable/disable the whole radio button element.</li>
</ul>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let radio;

function setup() {
  radio = createRadio();
  radio.option('black');
  radio.option('white');
  radio.option('gray');
  radio.style('width', '60px');
  textAlign(CENTER);
  fill(255, 0, 0);
}

function draw() {
  let val = radio.value();
  background(val);
  text(val, width / 2, height / 2);
}
```"###]
#[doc=r###"```rust
let radio;

function setup() {
  radio = createRadio();
  radio.option('apple', 1);
  radio.option('bread', 2);
  radio.option('juice', 3);
  radio.style('width', '60px');
  textAlign(CENTER);
}

function draw() {
  background(200);
  let val = radio.value();
  if (val) {
    text('item cost is $' + val, width / 2, height / 2);
  }
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>containerElement</code> An container HTML Element either a div
or span inside which all existing radio inputs will be considered as options.

"##]
///
///
#[doc = r##"<code>name?</code> A name parameter for each Input Element.

"##]
///
///
/// ---
///
///
#[doc = r##"<code>name</code> A name parameter for each Input Element.

"##]
///
///
/// ---
///
///
/// ---
///

pub static createRadio: CreateRadioInternalType = CreateRadioInternalType;
#[doc(hidden)]
pub struct CreateRadioInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createRadio")]
    fn createRadio2589313030(_ : JsValue, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,)> for CreateRadioInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,)) -> Self::Output {
        createRadio2589313030.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,)> for CreateRadioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,)) -> Self::Output {
        createRadio2589313030.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,)> for CreateRadioInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,)) -> Self::Output {
        createRadio2589313030.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createRadio")]
    fn createRadio181511804(_ : JsValue, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for CreateRadioInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        createRadio181511804.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for CreateRadioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        createRadio181511804.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for CreateRadioInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        createRadio181511804.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createRadio")]
    fn createRadio523430953(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateRadioInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createRadio523430953.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateRadioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createRadio523430953.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateRadioInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createRadio523430953.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createRadio")]
    fn createRadio3801259081() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateRadioInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createRadio3801259081.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateRadioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createRadio3801259081.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateRadioInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createRadio3801259081.call(args)
    }
}
#[doc=r##"<p>Creates a colorPicker element in the DOM for color input.
The .value() method will return a hex string (#rrggbb) of the color.
The .color() method will return a p5.Color object with the current chosen color.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let colorPicker;
function setup() {
  createCanvas(100, 100);
  colorPicker = createColorPicker('#ed225d');
  colorPicker.position(0, height + 5);
}

function draw() {
  background(colorPicker.color());
}
```"###]
#[doc=r###"```rust
let inp1, inp2;
function setup() {
  createCanvas(100, 100);
  background('grey');
  inp1 = createColorPicker('#ff0000');
  inp1.position(0, height + 5);
  inp1.input(setShade1);
  inp2 = createColorPicker(color('yellow'));
  inp2.position(0, height + 30);
  inp2.input(setShade2);
  setMidShade();
}

function setMidShade() {
  // Finding a shade between the two
  let commonShade = lerpColor(inp1.color(), inp2.color(), 0.5);
  fill(commonShade);
  rect(20, 20, 60, 60);
}

function setShade1() {
  setMidShade();
  console.log('You are choosing shade 1 to be : ', this.value());
}
function setShade2() {
  setMidShade();
  console.log('You are choosing shade 2 to be : ', this.value());
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value?</code> default color of element

"##]
///

pub static createColorPicker: CreateColorPickerInternalType = CreateColorPickerInternalType;
#[doc(hidden)]
pub struct CreateColorPickerInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createColorPicker")]
    fn createColorPicker3994785039(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateColorPickerInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createColorPicker3994785039.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateColorPickerInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createColorPicker3994785039.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateColorPickerInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createColorPicker3994785039.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createColorPicker")]
    fn createColorPicker2008390283(_ : & Color, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for CreateColorPickerInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        createColorPicker2008390283.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for CreateColorPickerInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        createColorPicker2008390283.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for CreateColorPickerInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        createColorPicker2008390283.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createColorPicker")]
    fn createColorPicker2765651385() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateColorPickerInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createColorPicker2765651385.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateColorPickerInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createColorPicker2765651385.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateColorPickerInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createColorPicker2765651385.call(args)
    }
}
#[doc=r##"<p>Creates an input element in the DOM for text input.
Use .<a href="#/p5.Element/size">size()</a> to set the display length of the box.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let inp = createInput('');
  inp.input(myInputEvent);
}

function myInputEvent() {
  console.log('you are typing: ', this.value());
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>value</code> default value of the input box

"##]
///
///
#[doc = r##"<code>type?</code> type of text, ie text, password etc. Defaults to text.
  Needs a value to be specified first.

"##]
///
///
/// ---
///
///
#[doc = r##"<code>value?</code> default value of the input box

"##]
///
///
/// ---
///

pub static createInput: CreateInputInternalType = CreateInputInternalType;
#[doc(hidden)]
pub struct CreateInputInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createInput")]
    fn createInput1863055049(_ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateInputInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createInput1863055049.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateInputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createInput1863055049.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateInputInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createInput1863055049.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createInput")]
    fn createInput3457380236(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateInputInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createInput3457380236.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateInputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createInput3457380236.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateInputInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createInput3457380236.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createInput")]
    fn createInput1975963094() ->  Element;
}

#[doc(hidden)]
impl FnOnce<()> for CreateInputInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createInput1975963094.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateInputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createInput1975963094.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateInputInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createInput1975963094.call(args)
    }
}
#[doc=r##"<p>Creates an input element in the DOM of type 'file'.
This allows users to select local files for use in a sketch.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let input;
let img;

function setup() {
  input = createFileInput(handleFile);
  input.position(0, 0);
}

function draw() {
  background(255);
  if (img) {
    image(img, 0, 0, width, height);
  }
}

function handleFile(file) {
  print(file);
  if (file.type === 'image') {
    img = createImg(file.data, '');
    img.hide();
  } else {
    img = null;
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>callback</code> callback function for when a file is loaded

"##]
///
///
#[doc = r##"<code>multiple?</code> optional, to allow multiple files to be selected

"##]
///

pub static createFileInput: CreateFileInputInternalType = CreateFileInputInternalType;
#[doc(hidden)]
pub struct CreateFileInputInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createFileInput")]
    fn createFileInput3973033111(_ : js_sys::Function, _ : bool, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Function,bool,)> for CreateFileInputInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (js_sys::Function,bool,)) -> Self::Output {
        createFileInput3973033111.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Function,bool,)> for CreateFileInputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Function,bool,)) -> Self::Output {
        createFileInput3973033111.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Function,bool,)> for CreateFileInputInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Function,bool,)) -> Self::Output {
        createFileInput3973033111.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createFileInput")]
    fn createFileInput3459209525(_ : js_sys::Function, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Function,)> for CreateFileInputInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (js_sys::Function,)) -> Self::Output {
        createFileInput3459209525.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Function,)> for CreateFileInputInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Function,)) -> Self::Output {
        createFileInput3459209525.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Function,)> for CreateFileInputInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Function,)) -> Self::Output {
        createFileInput3459209525.call(args)
    }
}
#[doc=r##"<p>Creates an HTML5 video element in the DOM for simple playback
of audio/video. Shown by default, can be hidden with .<a href="#/p5.Element/hide">hide()</a>
and drawn into canvas using <a href="#/p5/image">image()</a>. The first parameter
can be either a single string path to a video file, or an array of string
paths to different formats of the same video. This is useful for ensuring
that your video can play across different browsers, as each supports
different formats. See <a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Supported_media_formats'>this
page</a> for further information about supported formats.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let vid;
function setup() {
  noCanvas();

  vid = createVideo(
    ['assets/small.mp4', 'assets/small.ogv', 'assets/small.webm'],
    vidLoad
  );

  vid.size(100, 100);
}

// This function is called when the video loads
function vidLoad() {
  vid.loop();
  vid.volume(0);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>src</code> path to a video file, or array of paths for
                            supporting different browsers

"##]
///
///
#[doc = r##"<code>callback?</code> callback function to be called upon
                            'canplaythrough' event fire, that is, when the
                            browser can play the media, and estimates that
                            enough data has been loaded to play the media
                            up to its end without having to stop for
                            further buffering of content

"##]
///

pub static createVideo: CreateVideoInternalType = CreateVideoInternalType;
#[doc(hidden)]
pub struct CreateVideoInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVideo")]
    fn createVideo3258337539(_ : & str, _ : js_sys::Function, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for CreateVideoInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createVideo3258337539.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for CreateVideoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createVideo3258337539.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for CreateVideoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createVideo3258337539.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVideo")]
    fn createVideo3915665156(_ : & str, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateVideoInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createVideo3915665156.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateVideoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createVideo3915665156.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateVideoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createVideo3915665156.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVideo")]
    fn createVideo1261313333(_ : js_sys::Array, _ : js_sys::Function, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,js_sys::Function,)> for CreateVideoInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,js_sys::Function,)) -> Self::Output {
        createVideo1261313333.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,js_sys::Function,)> for CreateVideoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,js_sys::Function,)) -> Self::Output {
        createVideo1261313333.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,js_sys::Function,)> for CreateVideoInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,js_sys::Function,)) -> Self::Output {
        createVideo1261313333.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVideo")]
    fn createVideo3417948512(_ : js_sys::Array, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for CreateVideoInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        createVideo3417948512.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for CreateVideoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        createVideo3417948512.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for CreateVideoInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        createVideo3417948512.call(args)
    }
}
#[doc=r##"<p>Creates a hidden HTML5 <audio> element in the DOM for simple audio
playback. The first parameter can be either a single string path to a
audio file, or an array of string paths to different formats of the same
audio. This is useful for ensuring that your audio can play across
different browsers, as each supports different formats.
See <a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Supported_media_formats'>this
page for further information about supported formats</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let ele;
function setup() {
  ele = createAudio('assets/beat.mp3');

  // here we set the element to autoplay
  // The element will play as soon
  // as it is able to do so.
  ele.autoplay(true);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>src?</code> path to an audio file, or array of paths
                            for supporting different browsers

"##]
///
///
#[doc = r##"<code>callback?</code> callback function to be called upon
                            'canplaythrough' event fire, that is, when the
                            browser can play the media, and estimates that
                            enough data has been loaded to play the media
                            up to its end without having to stop for
                            further buffering of content

"##]
///

pub static createAudio: CreateAudioInternalType = CreateAudioInternalType;
#[doc(hidden)]
pub struct CreateAudioInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createAudio")]
    fn createAudio3940120517(_ : & str, _ : js_sys::Function, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for CreateAudioInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createAudio3940120517.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for CreateAudioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createAudio3940120517.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for CreateAudioInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createAudio3940120517.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createAudio")]
    fn createAudio2143749912(_ : & str, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateAudioInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createAudio2143749912.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateAudioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createAudio2143749912.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateAudioInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createAudio2143749912.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createAudio")]
    fn createAudio1648180165(_ : js_sys::Array, _ : js_sys::Function, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,js_sys::Function,)> for CreateAudioInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,js_sys::Function,)) -> Self::Output {
        createAudio1648180165.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,js_sys::Function,)> for CreateAudioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,js_sys::Function,)) -> Self::Output {
        createAudio1648180165.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,js_sys::Function,)> for CreateAudioInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,js_sys::Function,)) -> Self::Output {
        createAudio1648180165.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createAudio")]
    fn createAudio1560702386(_ : js_sys::Array, ) ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for CreateAudioInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        createAudio1560702386.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for CreateAudioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        createAudio1560702386.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for CreateAudioInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        createAudio1560702386.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createAudio")]
    fn createAudio3479173020() ->  MediaElement;
}

#[doc(hidden)]
impl FnOnce<()> for CreateAudioInternalType {
    type Output =  MediaElement;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createAudio3479173020.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateAudioInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createAudio3479173020.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateAudioInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createAudio3479173020.call(args)
    }
}
#[doc=r##"<p>Creates a new HTML5 video element that contains the audio/video feed
from a webcam. The element is separate from the canvas and is displayed by
default. The element can be hidden using .<a href="#/p5.Element/hide">hide()</a>.
The feed can be drawn onto the canvas using <a href="#/p5/image">image()</a>.
The loadedmetadata property can be used to detect when the element has fully
loaded (see second example).</p>
<p>More specific properties of the feed can be passing in a Constraints object.
See the <a href='http://w3c.github.io/mediacapture-main/getusermedia.html#media-track-constraints'>
W3C spec</a> for possible properties. Note that not all of these are supported
by all browsers.</p>
<p><em>Security note</em>: A new browser security specification requires that
getUserMedia, which is behind <a href="#/p5/createCapture">createCapture()</a>,
only works when you're running the code locally, or on HTTPS. Learn more
<a href='http://stackoverflow.com/questions/34197653/getusermedia-in-chrome-47-without-using-https'>here</a>
and <a href='https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia'>here</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let capture;

function setup() {
  createCanvas(480, 480);
  capture = createCapture(VIDEO);
  capture.hide();
}

function draw() {
  image(capture, 0, 0, width, width * capture.height / capture.width);
  filter(INVERT);
}
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(480, 120);
  let constraints = {
    video: {
      mandatory: {
        minWidth: 1280,
        minHeight: 720
      },
      optional: [{ maxFrameRate: 10 }]
    },
    audio: true
  };
  createCapture(constraints, function(stream) {
    console.log(stream);
  });
}
```"###]
#[doc=r###"```rust
let capture;

function setup() {
  createCanvas(640, 480);
  capture = createCapture(VIDEO);
}
function draw() {
  background(0);
  if (capture.loadedmetadata) {
    let c = capture.get(0, 0, 100, 100);
    image(c, 0, 0);
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>type</code> type of capture, either VIDEO or
                                  AUDIO if none specified, default both,
                                  or a Constraints object

"##]
///
///
#[doc = r##"<code>callback?</code> function to be called once
                                  stream has loaded

"##]
///

pub static createCapture: CreateCaptureInternalType = CreateCaptureInternalType;
#[doc(hidden)]
pub struct CreateCaptureInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCapture")]
    fn createCapture2119011069(_ : & str, _ : js_sys::Function, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for CreateCaptureInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createCapture2119011069.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for CreateCaptureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createCapture2119011069.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for CreateCaptureInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        createCapture2119011069.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCapture")]
    fn createCapture4055711946(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateCaptureInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createCapture4055711946.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateCaptureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createCapture4055711946.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateCaptureInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createCapture4055711946.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCapture")]
    fn createCapture311323856(_ : TYPE, _ : js_sys::Function, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(TYPE,js_sys::Function,)> for CreateCaptureInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (TYPE,js_sys::Function,)) -> Self::Output {
        createCapture311323856.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(TYPE,js_sys::Function,)> for CreateCaptureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (TYPE,js_sys::Function,)) -> Self::Output {
        createCapture311323856.call(args)
    }
}

#[doc(hidden)]
impl Fn<(TYPE,js_sys::Function,)> for CreateCaptureInternalType {
    extern "rust-call" fn call(&self, args: (TYPE,js_sys::Function,)) -> Self::Output {
        createCapture311323856.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCapture")]
    fn createCapture3526860611(_ : TYPE, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(TYPE,)> for CreateCaptureInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (TYPE,)) -> Self::Output {
        createCapture3526860611.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(TYPE,)> for CreateCaptureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (TYPE,)) -> Self::Output {
        createCapture3526860611.call(args)
    }
}

#[doc(hidden)]
impl Fn<(TYPE,)> for CreateCaptureInternalType {
    extern "rust-call" fn call(&self, args: (TYPE,)) -> Self::Output {
        createCapture3526860611.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCapture")]
    fn createCapture2612472108(_ : JsValue, _ : js_sys::Function, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(JsValue,js_sys::Function,)> for CreateCaptureInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (JsValue,js_sys::Function,)) -> Self::Output {
        createCapture2612472108.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,js_sys::Function,)> for CreateCaptureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,js_sys::Function,)) -> Self::Output {
        createCapture2612472108.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,js_sys::Function,)> for CreateCaptureInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,js_sys::Function,)) -> Self::Output {
        createCapture2612472108.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCapture")]
    fn createCapture4126799723(_ : JsValue, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for CreateCaptureInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        createCapture4126799723.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for CreateCaptureInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        createCapture4126799723.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for CreateCaptureInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        createCapture4126799723.call(args)
    }
}
#[doc=r##"<p>Creates element with given tag in the DOM with given content.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createElement('h2', 'im an h2 p5.element!');
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>tag</code> tag for the new element

"##]
///
///
#[doc = r##"<code>content?</code> html content to be inserted into the element

"##]
///

pub static createElement: CreateElementInternalType = CreateElementInternalType;
#[doc(hidden)]
pub struct CreateElementInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createElement")]
    fn createElement3674936875(_ : & str, _ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateElementInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createElement3674936875.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateElementInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createElement3674936875.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateElementInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createElement3674936875.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createElement")]
    fn createElement3257758854(_ : & str, ) ->  Element;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateElementInternalType {
    type Output =  Element;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createElement3257758854.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateElementInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createElement3257758854.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateElementInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createElement3257758854.call(args)
    }
}
#[doc=r##"<p>Calculates the absolute value (magnitude) of a number. Maps to Math.abs().
The absolute value of a number is always positive.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let x = -3;
  let y = abs(x);

  print(x); // -3
  print(y); // 3
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number to compute

"##]
///

pub static abs: AbsInternalType = AbsInternalType;
#[doc(hidden)]
pub struct AbsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "abs")]
    fn abs3186398319(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for AbsInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        abs3186398319.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for AbsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        abs3186398319.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for AbsInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        abs3186398319.call(args)
    }
}
#[doc=r##"<p>Calculates the closest int value that is greater than or equal to the
value of the parameter. Maps to Math.ceil(). For example, ceil(9.03)
returns the value 10.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);
  // map, mouseX between 0 and 5.
  let ax = map(mouseX, 0, 100, 0, 5);
  let ay = 66;

  //Get the ceiling of the mapped number.
  let bx = ceil(map(mouseX, 0, 100, 0, 5));
  let by = 33;

  // Multiply the mapped numbers by 20 to more easily
  // see the changes.
  stroke(0);
  fill(0);
  line(0, ay, ax * 20, ay);
  line(0, by, bx * 20, by);

  // Reformat the float returned by map and draw it.
  noStroke();
  text(nfc(ax, 2), ax, ay - 5);
  text(nfc(bx, 1), bx, by - 5);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number to round up

"##]
///

pub static ceil: CeilInternalType = CeilInternalType;
#[doc(hidden)]
pub struct CeilInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ceil")]
    fn ceil4000704477(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CeilInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        ceil4000704477.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CeilInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        ceil4000704477.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CeilInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        ceil4000704477.call(args)
    }
}
#[doc=r##"<p>Constrains a value between a minimum and maximum value.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);

  let leftWall = 25;
  let rightWall = 75;

  // xm is just the mouseX, while
  // xc is the mouseX, but constrained
  // between the leftWall and rightWall!
  let xm = mouseX;
  let xc = constrain(mouseX, leftWall, rightWall);

  // Draw the walls.
  stroke(150);
  line(leftWall, 0, leftWall, height);
  line(rightWall, 0, rightWall, height);

  // Draw xm and xc as circles.
  noStroke();
  fill(150);
  ellipse(xm, 33, 9, 9); // Not Constrained
  fill(0);
  ellipse(xc, 66, 9, 9); // Constrained
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number to constrain

"##]
///
///
#[doc = r##"<code>low</code> minimum limit

"##]
///
///
#[doc = r##"<code>high</code> maximum limit

"##]
///

pub static constrain: ConstrainInternalType = ConstrainInternalType;
#[doc(hidden)]
pub struct ConstrainInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "constrain")]
    fn constrain1775638030(_ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for ConstrainInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        constrain1775638030.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for ConstrainInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        constrain1775638030.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for ConstrainInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        constrain1775638030.call(args)
    }
}
#[doc=r##"<p>Calculates the distance between two points, in either two or three dimensions.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Move your mouse inside the canvas to see the
// change in distance between two points!
function draw() {
  background(200);
  fill(0);

  let x1 = 10;
  let y1 = 90;
  let x2 = mouseX;
  let y2 = mouseY;

  line(x1, y1, x2, y2);
  ellipse(x1, y1, 7, 7);
  ellipse(x2, y2, 7, 7);

  // d is the length of the line
  // the distance from point 1 to point 2.
  let d = int(dist(x1, y1, x2, y2));

  // Let's write d along the line we are drawing!
  push();
  translate((x1 + x2) / 2, (y1 + y2) / 2);
  rotate(atan2(y2 - y1, x2 - x1));
  text(nfc(d, 1), 0, -5);
  pop();
  // Fancy!
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x1</code> x-coordinate of the first point

"##]
///
///
#[doc = r##"<code>y1</code> y-coordinate of the first point

"##]
///
///
#[doc = r##"<code>x2</code> x-coordinate of the second point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate of the second point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>x1</code> x-coordinate of the first point

"##]
///
///
#[doc = r##"<code>y1</code> y-coordinate of the first point

"##]
///
///
#[doc = r##"<code>z1</code> z-coordinate of the first point

"##]
///
///
#[doc = r##"<code>x2</code> x-coordinate of the second point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate of the second point

"##]
///
///
#[doc = r##"<code>z2</code> z-coordinate of the second point

"##]
///
///
/// ---
///

pub static dist: DistInternalType = DistInternalType;
#[doc(hidden)]
pub struct DistInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "dist")]
    fn dist1040089283(_ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for DistInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        dist1040089283.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for DistInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        dist1040089283.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for DistInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        dist1040089283.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "dist")]
    fn dist2680465360(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for DistInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        dist2680465360.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for DistInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        dist2680465360.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for DistInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        dist2680465360.call(args)
    }
}
#[doc=r##"<p>Returns Euler's number e (2.71828...) raised to the power of the n
parameter. Maps to Math.exp().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);

  // Compute the exp() function with a value between 0 and 2
  let xValue = map(mouseX, 0, width, 0, 2);
  let yValue = exp(xValue);

  let y = map(yValue, 0, 8, height, 0);

  let legend = 'exp (' + nfc(xValue, 3) + ')\n= ' + nf(yValue, 1, 4);
  stroke(150);
  line(mouseX, y, mouseX, height);
  fill(0);
  text(legend, 5, 15);
  noStroke();
  ellipse(mouseX, y, 7, 7);

  // Draw the exp(x) curve,
  // over the domain of x from 0 to 2
  noFill();
  stroke(0);
  beginShape();
  for (let x = 0; x < width; x++) {
    xValue = map(x, 0, width, 0, 2);
    yValue = exp(xValue);
    y = map(yValue, 0, 8, height, 0);
    vertex(x, y);
  }

  endShape();
  line(0, 0, 0, height);
  line(0, height - 1, width, height - 1);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> exponent to raise

"##]
///

pub static exp: ExpInternalType = ExpInternalType;
#[doc(hidden)]
pub struct ExpInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "exp")]
    fn exp2892082365(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ExpInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        exp2892082365.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ExpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        exp2892082365.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ExpInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        exp2892082365.call(args)
    }
}
#[doc=r##"<p>Calculates the closest int value that is less than or equal to the
value of the parameter. Maps to Math.floor().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);
  //map, mouseX between 0 and 5.
  let ax = map(mouseX, 0, 100, 0, 5);
  let ay = 66;

  //Get the floor of the mapped number.
  let bx = floor(map(mouseX, 0, 100, 0, 5));
  let by = 33;

  // Multiply the mapped numbers by 20 to more easily
  // see the changes.
  stroke(0);
  fill(0);
  line(0, ay, ax * 20, ay);
  line(0, by, bx * 20, by);

  // Reformat the float returned by map and draw it.
  noStroke();
  text(nfc(ax, 2), ax, ay - 5);
  text(nfc(bx, 1), bx, by - 5);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number to round down

"##]
///

pub static floor: FloorInternalType = FloorInternalType;
#[doc(hidden)]
pub struct FloorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "floor")]
    fn floor651910123(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for FloorInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        floor651910123.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for FloorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        floor651910123.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for FloorInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        floor651910123.call(args)
    }
}
#[doc=r##"<p>Calculates a number between two numbers at a specific increment. The amt
parameter is the amount to interpolate between the two values where 0.0
equal to the first point, 0.1 is very near the first point, 0.5 is
half-way in between, and 1.0 is equal to the second point. If the
value of amt is more than 1.0 or less than 0.0, the number will be
calculated accordingly in the ratio of the two given numbers. The lerp
function is convenient for creating motion along a straight
path and for drawing dotted lines.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  background(200);
  let a = 20;
  let b = 80;
  let c = lerp(a, b, 0.2);
  let d = lerp(a, b, 0.5);
  let e = lerp(a, b, 0.8);

  let y = 50;

  strokeWeight(5);
  stroke(0); // Draw the original points in black
  point(a, y);
  point(b, y);

  stroke(100); // Draw the lerp points in gray
  point(c, y);
  point(d, y);
  point(e, y);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>start</code> first value

"##]
///
///
#[doc = r##"<code>stop</code> second value

"##]
///
///
#[doc = r##"<code>amt</code> number

"##]
///

pub static lerp: LerpInternalType = LerpInternalType;
#[doc(hidden)]
pub struct LerpInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lerp")]
    fn lerp3326947376(_ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for LerpInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        lerp3326947376.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for LerpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        lerp3326947376.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for LerpInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        lerp3326947376.call(args)
    }
}
#[doc=r##"<p>Calculates the natural logarithm (the base-e logarithm) of a number. This
function expects the n parameter to be a value greater than 0.0. Maps to
Math.log().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);
  let maxX = 2.8;
  let maxY = 1.5;

  // Compute the natural log of a value between 0 and maxX
  let xValue = map(mouseX, 0, width, 0, maxX);
  let yValue, y;
  if (xValue > 0) {
   // Cannot take the log of a negative number.
    yValue = log(xValue);
    y = map(yValue, -maxY, maxY, height, 0);

    // Display the calculation occurring.
    let legend = 'log(' + nf(xValue, 1, 2) + ')\n= ' + nf(yValue, 1, 3);
    stroke(150);
    line(mouseX, y, mouseX, height);
    fill(0);
    text(legend, 5, 15);
    noStroke();
    ellipse(mouseX, y, 7, 7);
  }

  // Draw the log(x) curve,
  // over the domain of x from 0 to maxX
  noFill();
  stroke(0);
  beginShape();
  for (let x = 0; x < width; x++) {
    xValue = map(x, 0, width, 0, maxX);
    yValue = log(xValue);
    y = map(yValue, -maxY, maxY, height, 0);
    vertex(x, y);
  }
  endShape();
  line(0, 0, 0, height);
  line(0, height / 2, width, height / 2);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number greater than 0

"##]
///

pub static log: LogInternalType = LogInternalType;
#[doc(hidden)]
pub struct LogInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "log")]
    fn log1058788909(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for LogInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        log1058788909.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for LogInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        log1058788909.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for LogInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        log1058788909.call(args)
    }
}
#[doc=r##"<p>Calculates the magnitude (or length) of a vector. A vector is a direction
in space commonly used in computer graphics and linear algebra. Because it
has no "start" position, the magnitude of a vector can be thought of as
the distance from the coordinate 0,0 to its x,y value. Therefore, <a href="#/p5/mag">mag()</a> is
a shortcut for writing dist(0, 0, x, y).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let x1 = 20;
  let x2 = 80;
  let y1 = 30;
  let y2 = 70;

  line(0, 0, x1, y1);
  print(mag(x1, y1)); // Prints "36.05551275463989"
  line(0, 0, x2, y1);
  print(mag(x2, y1)); // Prints "85.44003745317531"
  line(0, 0, x1, y2);
  print(mag(x1, y2)); // Prints "72.80109889280519"
  line(0, 0, x2, y2);
  print(mag(x2, y2)); // Prints "106.3014581273465"
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> first value

"##]
///
///
#[doc = r##"<code>b</code> second value

"##]
///

pub static mag: MagInternalType = MagInternalType;
#[doc(hidden)]
pub struct MagInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mag")]
    fn mag951808025(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for MagInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        mag951808025.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for MagInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        mag951808025.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for MagInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        mag951808025.call(args)
    }
}
#[doc=r##"<p>Re-maps a number from one range to another.</p>
<p>In the first example above, the number 25 is converted from a value in the
range of 0 to 100 into a value that ranges from the left edge of the
window (0) to the right edge (width).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let value = 25;
let m = map(value, 0, 100, 0, width);
ellipse(m, 50, 10, 10);
```"###]
#[doc=r###"```rust
function setup() {
  noStroke();
}

function draw() {
  background(204);
  let x1 = map(mouseX, 0, width, 25, 75);
  ellipse(x1, 25, 25, 25);
  //This ellipse is constrained to the 0-100 range
  //after setting withinBounds to true
  let x2 = map(mouseX, 0, width, 0, 100, true);
  ellipse(x2, 75, 25, 25);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> the incoming value to be converted

"##]
///
///
#[doc = r##"<code>start1</code> lower bound of the value's current range

"##]
///
///
#[doc = r##"<code>stop1</code> upper bound of the value's current range

"##]
///
///
#[doc = r##"<code>start2</code> lower bound of the value's target range

"##]
///
///
#[doc = r##"<code>stop2</code> upper bound of the value's target range

"##]
///
///
#[doc = r##"<code>withinBounds?</code> constrain the value to the newly mapped range

"##]
///

pub static map: MapInternalType = MapInternalType;
#[doc(hidden)]
pub struct MapInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "map")]
    fn map1100426167(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : bool, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,bool,)> for MapInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,bool,)) -> Self::Output {
        map1100426167.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,bool,)> for MapInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,bool,)) -> Self::Output {
        map1100426167.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,bool,)> for MapInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,bool,)) -> Self::Output {
        map1100426167.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "map")]
    fn map161229957(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for MapInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        map161229957.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for MapInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        map161229957.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for MapInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        map161229957.call(args)
    }
}
#[doc=r##"<p>Determines the largest value in a sequence of numbers, and then returns
that value. <a href="#/p5/max">max()</a> accepts any number of Number parameters, or an Array
of any length.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  // Change the elements in the array and run the sketch
  // to show how max() works!
  let numArray = [2, 1, 5, 4, 8, 9];
  fill(0);
  noStroke();
  text('Array Elements', 0, 10);
  // Draw all numbers in the array
  let spacing = 15;
  let elemsY = 25;
  for (let i = 0; i < numArray.length; i++) {
    text(numArray[i], i * spacing, elemsY);
  }
  let maxX = 33;
  let maxY = 80;
  // Draw the Maximum value in the array.
  textSize(32);
  text(max(numArray), maxX, maxY);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n0</code> Number to compare

"##]
///
///
#[doc = r##"<code>n1</code> Number to compare

"##]
///
///
/// ---
///
///
#[doc = r##"<code>nums</code> Numbers to compare

"##]
///
///
/// ---
///

pub static max: MaxInternalType = MaxInternalType;
#[doc(hidden)]
pub struct MaxInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "max")]
    fn max2305263620(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for MaxInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        max2305263620.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for MaxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        max2305263620.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for MaxInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        max2305263620.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "max")]
    fn max3336627698(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for MaxInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        max3336627698.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for MaxInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        max3336627698.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for MaxInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        max3336627698.call(args)
    }
}
#[doc=r##"<p>Determines the smallest value in a sequence of numbers, and then returns
that value. <a href="#/p5/min">min()</a> accepts any number of Number parameters, or an Array
of any length.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  // Change the elements in the array and run the sketch
  // to show how min() works!
  let numArray = [2, 1, 5, 4, 8, 9];
  fill(0);
  noStroke();
  text('Array Elements', 0, 10);
  // Draw all numbers in the array
  let spacing = 15;
  let elemsY = 25;
  for (let i = 0; i < numArray.length; i++) {
    text(numArray[i], i * spacing, elemsY);
  }
  let maxX = 33;
  let maxY = 80;
  // Draw the Minimum value in the array.
  textSize(32);
  text(min(numArray), maxX, maxY);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n0</code> Number to compare

"##]
///
///
#[doc = r##"<code>n1</code> Number to compare

"##]
///
///
/// ---
///
///
#[doc = r##"<code>nums</code> Numbers to compare

"##]
///
///
/// ---
///

pub static min: MinInternalType = MinInternalType;
#[doc(hidden)]
pub struct MinInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "min")]
    fn min200311665(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for MinInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        min200311665.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for MinInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        min200311665.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for MinInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        min200311665.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "min")]
    fn min3245198887(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for MinInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        min3245198887.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for MinInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        min3245198887.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for MinInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        min3245198887.call(args)
    }
}
#[doc=r##"<p>Normalizes a number from another range into a value between 0 and 1.
Identical to map(value, low, high, 0, 1).
Numbers outside of the range are not clamped to 0 and 1, because
out-of-range values are often intentional and useful. (See the example above.)</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);
  let currentNum = mouseX;
  let lowerBound = 0;
  let upperBound = width; //100;
  let normalized = norm(currentNum, lowerBound, upperBound);
  let lineY = 70;
  stroke(3);
  line(0, lineY, width, lineY);
  //Draw an ellipse mapped to the non-normalized value.
  noStroke();
  fill(50);
  let s = 7; // ellipse size
  ellipse(currentNum, lineY, s, s);

  // Draw the guide
  let guideY = lineY + 15;
  text('0', 0, guideY);
  textAlign(RIGHT);
  text('100', width, guideY);

  // Draw the normalized value
  textAlign(LEFT);
  fill(0);
  textSize(32);
  let normalY = 40;
  let normalX = 20;
  text(normalized, normalX, normalY);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> incoming value to be normalized

"##]
///
///
#[doc = r##"<code>start</code> lower bound of the value's current range

"##]
///
///
#[doc = r##"<code>stop</code> upper bound of the value's current range

"##]
///

pub static norm: NormInternalType = NormInternalType;
#[doc(hidden)]
pub struct NormInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "norm")]
    fn norm2495095370(_ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for NormInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        norm2495095370.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for NormInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        norm2495095370.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for NormInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        norm2495095370.call(args)
    }
}
#[doc=r##"<p>Facilitates exponential expressions. The <a href="#/p5/pow">pow()</a> function is an efficient
way of multiplying numbers by themselves (or their reciprocals) in large
quantities. For example, pow(3, 5) is equivalent to the expression
3 × 3 × 3 × 3 × 3 and pow(3, -5) is equivalent to 1 /
3 × 3 × 3 × 3 × 3. Maps to
Math.pow().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  //Exponentially increase the size of an ellipse.
  let eSize = 3; // Original Size
  let eLoc = 10; // Original Location

  ellipse(eLoc, eLoc, eSize, eSize);

  ellipse(eLoc * 2, eLoc * 2, pow(eSize, 2), pow(eSize, 2));

  ellipse(eLoc * 4, eLoc * 4, pow(eSize, 3), pow(eSize, 3));

  ellipse(eLoc * 8, eLoc * 8, pow(eSize, 4), pow(eSize, 4));
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> base of the exponential expression

"##]
///
///
#[doc = r##"<code>e</code> power by which to raise the base

"##]
///

pub static pow: PowInternalType = PowInternalType;
#[doc(hidden)]
pub struct PowInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pow")]
    fn pow1198846471(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for PowInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        pow1198846471.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for PowInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        pow1198846471.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for PowInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        pow1198846471.call(args)
    }
}
#[doc=r##"<p>Calculates the integer closest to the n parameter. For example,
round(133.8) returns the value 134. Maps to Math.round().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let x = round(3.7);
text(x, width / 2, height / 2);
```"###]
#[doc=r###"```rust
let x = round(12.782383, 2);
text(x, width / 2, height / 2);
```"###]
#[doc=r###"```rust
function draw() {
  background(200);
  //map, mouseX between 0 and 5.
  let ax = map(mouseX, 0, 100, 0, 5);
  let ay = 66;

  // Round the mapped number.
  let bx = round(map(mouseX, 0, 100, 0, 5));
  let by = 33;

  // Multiply the mapped numbers by 20 to more easily
  // see the changes.
  stroke(0);
  fill(0);
  line(0, ay, ax * 20, ay);
  line(0, by, bx * 20, by);

  // Reformat the float returned by map and draw it.
  noStroke();
  text(nfc(ax, 2), ax, ay - 5);
  text(nfc(bx, 1), bx, by - 5);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number to round

"##]
///
///
#[doc = r##"<code>decimals?</code> number of decimal places to round to, default is 0

"##]
///

pub static round: RoundInternalType = RoundInternalType;
#[doc(hidden)]
pub struct RoundInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "round")]
    fn round3189610668(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for RoundInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        round3189610668.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for RoundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        round3189610668.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for RoundInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        round3189610668.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "round")]
    fn round281006061(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RoundInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        round281006061.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RoundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        round281006061.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RoundInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        round281006061.call(args)
    }
}
#[doc=r##"<p>Squares a number (multiplies a number by itself). The result is always a
positive number, as multiplying two negative numbers always yields a
positive result. For example, -1 * -1 = 1.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);
  let eSize = 7;
  let x1 = map(mouseX, 0, width, 0, 10);
  let y1 = 80;
  let x2 = sq(x1);
  let y2 = 20;

  // Draw the non-squared.
  line(0, y1, width, y1);
  ellipse(x1, y1, eSize, eSize);

  // Draw the squared.
  line(0, y2, width, y2);
  ellipse(x2, y2, eSize, eSize);

  // Draw dividing line.
  stroke(100);
  line(0, height / 2, width, height / 2);

  // Draw text.
  let spacing = 15;
  noStroke();
  fill(0);
  text('x = ' + x1, 0, y1 + spacing);
  text('sq(x) = ' + x2, 0, y2 + spacing);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> number to square

"##]
///

pub static sq: SqInternalType = SqInternalType;
#[doc(hidden)]
pub struct SqInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sq")]
    fn sq897390548(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SqInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        sq897390548.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SqInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        sq897390548.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SqInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        sq897390548.call(args)
    }
}
#[doc=r##"<p>Calculates the square root of a number. The square root of a number is
always positive, even though there may be a valid negative root. The
square root s of number a is such that s*s = a. It is the opposite of
squaring. Maps to Math.sqrt().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(200);
  let eSize = 7;
  let x1 = mouseX;
  let y1 = 80;
  let x2 = sqrt(x1);
  let y2 = 20;

  // Draw the non-squared.
  line(0, y1, width, y1);
  ellipse(x1, y1, eSize, eSize);

  // Draw the squared.
  line(0, y2, width, y2);
  ellipse(x2, y2, eSize, eSize);

  // Draw dividing line.
  stroke(100);
  line(0, height / 2, width, height / 2);

  // Draw text.
  noStroke();
  fill(0);
  let spacing = 15;
  text('x = ' + x1, 0, y1 + spacing);
  text('sqrt(x) = ' + x2, 0, y2 + spacing);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> non-negative number to square root

"##]
///

pub static sqrt: SqrtInternalType = SqrtInternalType;
#[doc(hidden)]
pub struct SqrtInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sqrt")]
    fn sqrt1890995945(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SqrtInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        sqrt1890995945.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SqrtInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        sqrt1890995945.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SqrtInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        sqrt1890995945.call(args)
    }
}
#[doc=r##"<p>Calculates the fractional part of a number.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(windowWidth, windowHeight);
  fill(0);
  text(7345.73472742, 0, 50);
  text(fract(7345.73472742), 0, 100);
  text(1.4215e-15, 150, 50);
  text(fract(1.4215e-15), 150, 100);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>num</code> Number whose fractional part needs to be found out

"##]
///

pub static fract: FractInternalType = FractInternalType;
#[doc(hidden)]
pub struct FractInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fract")]
    fn fract4139176388(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for FractInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        fract4139176388.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for FractInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        fract4139176388.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for FractInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        fract4139176388.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/background">background()</a> function sets the color used
for the background of the p5.js canvas. The default background is transparent.
This function is typically used within <a href="#/p5/draw">draw()</a> to clear
the display window at the beginning of each frame, but it can be used inside
<a href="#/p5/setup">setup()</a> to set the background on the first frame of
animation or if the background need only be set once.</p>
<p>The color is either specified in terms of the RGB, HSB, or HSL color depending
on the current <a href="#/p5/colorMode">colorMode</a>. (The default color space
is RGB, with each value in the range from 0 to 255). The alpha range by default
is also 0 to 255.<br><br></p>
<p>If a single string argument is provided, RGB, RGBA and Hex CSS color strings
and all named color strings are supported. In this case, an alpha number
value as a second argument is not supported, the RGBA form should be used.</p>
<p>A <a href="#/p5.Color">p5.Color</a> object can also be provided to set the background color.</p>
<p>A <a href="#/p5.Image">p5.Image</a> can also be provided to set the background image.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Grayscale integer value
background(51);
```"###]
#[doc=r###"```rust
// R, G & B integer values
background(255, 204, 0);
```"###]
#[doc=r###"```rust
// H, S & B integer values
colorMode(HSB);
background(255, 204, 100);
```"###]
#[doc=r###"```rust
// Named SVG/CSS color string
background('red');
```"###]
#[doc=r###"```rust
// three-digit hexadecimal RGB notation
background('#fae');
```"###]
#[doc=r###"```rust
// six-digit hexadecimal RGB notation
background('#222222');
```"###]
#[doc=r###"```rust
// integer RGB notation
background('rgb(0,255,0)');
```"###]
#[doc=r###"```rust
// integer RGBA notation
background('rgba(0,255,0, 0.25)');
```"###]
#[doc=r###"```rust
// percentage RGB notation
background('rgb(100%,0%,10%)');
```"###]
#[doc=r###"```rust
// percentage RGBA notation
background('rgba(100%,0%,100%,0.5)');
```"###]
#[doc=r###"```rust
// p5 Color object
background(color(0, 0, 255));
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>color</code> any value created by the color() function

"##]
///
///
/// ---
///
///
#[doc = r##"<code>colorstring</code> color string, possible formats include: integer
                        rgb() or rgba(), percentage rgb() or rgba(),
                        3-digit hex, 6-digit hex

"##]
///
///
#[doc = r##"<code>a?</code> opacity of the background relative to current
                            color range (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gray</code> specifies a value between white and black

"##]
///
///
#[doc = r##"<code>a?</code> opacity of the background relative to current
                            color range (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current color
                       mode)

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value (depending on the current
                       color mode)

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value (depending on the current
                       color mode)

"##]
///
///
#[doc = r##"<code>a?</code> opacity of the background relative to current
                            color range (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red, green, blue
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>image</code> image created with loadImage() or createImage(),
                            to set as background
                            (must be same size as the sketch window)

"##]
///
///
#[doc = r##"<code>a?</code> opacity of the background relative to current
                            color range (default is 0-255)

"##]
///
///
/// ---
///

pub static background: BackgroundInternalType = BackgroundInternalType;
#[doc(hidden)]
pub struct BackgroundInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background604516976(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        background604516976.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        background604516976.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        background604516976.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background857977075(_ : & str, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,)) -> Self::Output {
        background857977075.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,)) -> Self::Output {
        background857977075.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,)) -> Self::Output {
        background857977075.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background3756350514(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        background3756350514.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        background3756350514.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        background3756350514.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background518937759(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        background518937759.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        background518937759.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        background518937759.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background2334025316(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        background2334025316.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        background2334025316.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        background2334025316.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background4262922276(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        background4262922276.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        background4262922276.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        background4262922276.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background2301559220(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        background2301559220.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        background2301559220.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        background2301559220.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background448201987(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        background448201987.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        background448201987.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        background448201987.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background180030014(_ : & Image, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,)) -> Self::Output {
        background180030014.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,)) -> Self::Output {
        background180030014.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,)) -> Self::Output {
        background180030014.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "background")]
    fn background2884809183(_ : & Image, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,)> for BackgroundInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,)) -> Self::Output {
        background2884809183.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,)> for BackgroundInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,)) -> Self::Output {
        background2884809183.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,)> for BackgroundInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,)) -> Self::Output {
        background2884809183.call(args)
    }
}
#[doc=r##"<p>Clears the pixels within a buffer. This function only clears the canvas.
It will not clear objects created by createX() methods such as
<a href="#/p5/createVideo">createVideo()</a> or <a href="#/p5/createDiv">createDiv()</a>.
Unlike the main graphics context, pixels in additional graphics areas created
with <a href="#/p5/createGraphics">createGraphics()</a> can be entirely
or partially transparent. This function clears everything to make all of
the pixels 100% transparent.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Clear the screen on mouse press.
function draw() {
  ellipse(mouseX, mouseY, 20, 20);
}
function mousePressed() {
  clear();
  background(128);
}
```"###]

pub static clear: ClearInternalType = ClearInternalType;
#[doc(hidden)]
pub struct ClearInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "clear")]
    fn clear3351313771() ;
}

#[doc(hidden)]
impl FnOnce<()> for ClearInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        clear3351313771.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ClearInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        clear3351313771.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ClearInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        clear3351313771.call(args)
    }
}
#[doc=r##"<p><a href="#/p5/colorMode">colorMode()</a> changes the way p5.js interprets
color data. By default, the parameters for <a href="#/p5/fill">fill()</a>,
<a href="#/p5/stroke">stroke()</a>, <a href="#/p5/background">background()</a>,
and <a href="#/p5/color">color()</a> are defined by values between 0 and 255
using the RGB color model. This is equivalent to setting colorMode(RGB, 255).
Setting colorMode(HSB) lets you use the HSB system instead. By default, this
is colorMode(HSB, 360, 100, 100, 1). You can also use HSL.</p>
<p>Note: existing color objects remember the mode that they were created in,
so you can change modes as you like without affecting their appearance.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
colorMode(RGB, 100);
for (let i = 0; i < 100; i++) {
  for (let j = 0; j < 100; j++) {
    stroke(i, j, 0);
    point(i, j);
  }
}
```"###]
#[doc=r###"```rust
noStroke();
colorMode(HSB, 100);
for (let i = 0; i < 100; i++) {
  for (let j = 0; j < 100; j++) {
    stroke(i, j, 100);
    point(i, j);
  }
}
```"###]
#[doc=r###"```rust
colorMode(RGB, 255);
let c = color(127, 255, 0);
colorMode(RGB, 1);
let myColor = c._getRed();
text(myColor, 10, 10, 80, 80);
```"###]
#[doc=r###"```rust
noFill();
colorMode(RGB, 255, 255, 255, 1);
background(255);
strokeWeight(4);
stroke(255, 0, 10, 0.3);
ellipse(40, 40, 50, 50);
ellipse(50, 50, 40, 40);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>mode</code> either RGB, HSB or HSL, corresponding to
                         Red/Green/Blue and Hue/Saturation/Brightness
                         (or Lightness)

"##]
///
///
#[doc = r##"<code>max?</code> range for all values

"##]
///
///
/// ---
///
///
#[doc = r##"<code>mode</code> either RGB, HSB or HSL, corresponding to
                         Red/Green/Blue and Hue/Saturation/Brightness
                         (or Lightness)

"##]
///
///
#[doc = r##"<code>max1</code> range for the red or hue depending on the
                             current color mode

"##]
///
///
#[doc = r##"<code>max2</code> range for the green or saturation depending
                             on the current color mode

"##]
///
///
#[doc = r##"<code>max3</code> range for the blue or brightness/lightness
                             depending on the current color mode

"##]
///
///
#[doc = r##"<code>maxA?</code> range for the alpha

"##]
///
///
/// ---
///

pub static colorMode: ColorModeInternalType = ColorModeInternalType;
#[doc(hidden)]
pub struct ColorModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "colorMode")]
    fn colorMode2504777767(_ : COLOR_MODE, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(COLOR_MODE,f64,)> for ColorModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (COLOR_MODE,f64,)) -> Self::Output {
        colorMode2504777767.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(COLOR_MODE,f64,)> for ColorModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (COLOR_MODE,f64,)) -> Self::Output {
        colorMode2504777767.call(args)
    }
}

#[doc(hidden)]
impl Fn<(COLOR_MODE,f64,)> for ColorModeInternalType {
    extern "rust-call" fn call(&self, args: (COLOR_MODE,f64,)) -> Self::Output {
        colorMode2504777767.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "colorMode")]
    fn colorMode2909271478(_ : COLOR_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(COLOR_MODE,)> for ColorModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (COLOR_MODE,)) -> Self::Output {
        colorMode2909271478.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(COLOR_MODE,)> for ColorModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (COLOR_MODE,)) -> Self::Output {
        colorMode2909271478.call(args)
    }
}

#[doc(hidden)]
impl Fn<(COLOR_MODE,)> for ColorModeInternalType {
    extern "rust-call" fn call(&self, args: (COLOR_MODE,)) -> Self::Output {
        colorMode2909271478.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "colorMode")]
    fn colorMode2714767674(_ : Constant, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,f64,f64,f64,)> for ColorModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,f64,f64,f64,)) -> Self::Output {
        colorMode2714767674.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,f64,f64,f64,)> for ColorModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,f64,f64,f64,)) -> Self::Output {
        colorMode2714767674.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,f64,f64,f64,)> for ColorModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,f64,f64,f64,)) -> Self::Output {
        colorMode2714767674.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "colorMode")]
    fn colorMode3248433245(_ : Constant, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,f64,f64,)> for ColorModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,f64,f64,)) -> Self::Output {
        colorMode3248433245.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,f64,f64,)> for ColorModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,f64,f64,)) -> Self::Output {
        colorMode3248433245.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,f64,f64,)> for ColorModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,f64,f64,)) -> Self::Output {
        colorMode3248433245.call(args)
    }
}
#[doc=r##"<p>Sets the color used to fill shapes. For example, if you run fill(204, 102, 0),
all shapes drawn after the fill command will be filled with the color orange.
This color is either specified in terms of the RGB or HSB color depending on
the current <a href="#/p5/colorMode">colorMode()</a>. (The default color space
is RGB, with each value in the range from 0 to 255). The alpha range by default
is also 0 to 255.</p>
<p>If a single string argument is provided, RGB, RGBA and Hex CSS color strings
and all named color strings are supported. In this case, an alpha number
value as a second argument is not supported, the RGBA form should be used.</p>
<p>A p5 <a href="#/p5.Color">Color</a> object can also be provided to set the fill color.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Grayscale integer value
fill(51);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// R, G & B integer values
fill(255, 204, 0);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// H, S & B integer values
colorMode(HSB);
fill(255, 204, 100);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// Named SVG/CSS color string
fill('red');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// three-digit hexadecimal RGB notation
fill('#fae');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// six-digit hexadecimal RGB notation
fill('#222222');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// integer RGB notation
fill('rgb(0,255,0)');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// integer RGBA notation
fill('rgba(0,255,0, 0.25)');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// percentage RGB notation
fill('rgb(100%,0%,10%)');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// percentage RGBA notation
fill('rgba(100%,0%,100%,0.5)');
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// p5 Color object
fill(color(0, 0, 255));
rect(20, 20, 60, 60);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>alpha?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>value</code> a color string

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gray</code> a gray value

"##]
///
///
#[doc = r##"<code>alpha?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red,green,blue &
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> the fill color

"##]
///
///
/// ---
///

pub static fill: FillInternalType = FillInternalType;
#[doc(hidden)]
pub struct FillInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill2633821798(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        fill2633821798.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        fill2633821798.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        fill2633821798.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill2589185921(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        fill2589185921.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        fill2589185921.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        fill2589185921.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill2157829344(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        fill2157829344.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        fill2157829344.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        fill2157829344.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill1828956475(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        fill1828956475.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        fill1828956475.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        fill1828956475.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill4049784345(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        fill4049784345.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        fill4049784345.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        fill4049784345.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill3850228902(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        fill3850228902.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        fill3850228902.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        fill3850228902.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "fill")]
    fn fill1369881449(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for FillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        fill1369881449.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for FillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        fill1369881449.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for FillInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        fill1369881449.call(args)
    }
}
#[doc=r##"<p>Disables filling geometry. If both <a href="#/p5/noStroke">noStroke()</a> and <a href="#/p5/noFill">noFill()</a> are called,
nothing will be drawn to the screen.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
rect(15, 10, 55, 55);
noFill();
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(0);
  noFill();
  stroke(100, 100, 240);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  box(45, 45, 45);
}
```"###]

pub static noFill: NoFillInternalType = NoFillInternalType;
#[doc(hidden)]
pub struct NoFillInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noFill")]
    fn noFill518999741() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoFillInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noFill518999741.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoFillInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noFill518999741.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoFillInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noFill518999741.call(args)
    }
}
#[doc=r##"<p>Disables drawing the stroke (outline). If both <a href="#/p5/noStroke">noStroke()</a> and <a href="#/p5/noFill">noFill()</a>
are called, nothing will be drawn to the screen.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(0);
  noStroke();
  fill(240, 150, 150);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  box(45, 45, 45);
}
```"###]

pub static noStroke: NoStrokeInternalType = NoStrokeInternalType;
#[doc(hidden)]
pub struct NoStrokeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noStroke")]
    fn noStroke1942383773() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoStrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noStroke1942383773.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoStrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noStroke1942383773.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoStrokeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noStroke1942383773.call(args)
    }
}
#[doc=r##"<p>Sets the color used to draw lines and borders around shapes. This color
is either specified in terms of the RGB or HSB color depending on the
current <a href="#/p5/colorMode">colorMode()</a> (the default color space
is RGB, with each value in the range from 0 to 255). The alpha range by
default is also 0 to 255.</p>
<p>If a single string argument is provided, RGB, RGBA and Hex CSS color
strings and all named color strings are supported. In this case, an alpha
number value as a second argument is not supported, the RGBA form should be
used.</p>
<p>A p5 <a href="#/p5.Color">Color</a> object can also be provided to set the stroke color.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Grayscale integer value
strokeWeight(4);
stroke(51);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// R, G & B integer values
stroke(255, 204, 0);
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// H, S & B integer values
colorMode(HSB);
strokeWeight(4);
stroke(255, 204, 100);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// Named SVG/CSS color string
stroke('red');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// three-digit hexadecimal RGB notation
stroke('#fae');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// six-digit hexadecimal RGB notation
stroke('#222222');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// integer RGB notation
stroke('rgb(0,255,0)');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// integer RGBA notation
stroke('rgba(0,255,0,0.25)');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// percentage RGB notation
stroke('rgb(100%,0%,10%)');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// percentage RGBA notation
stroke('rgba(100%,0%,100%,0.5)');
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// p5 Color object
stroke(color(0, 0, 255));
strokeWeight(4);
rect(20, 20, 60, 60);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>alpha?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>value</code> a color string

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gray</code> a gray value

"##]
///
///
#[doc = r##"<code>alpha?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red,green,blue &
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> the stroke color

"##]
///
///
/// ---
///

pub static stroke: StrokeInternalType = StrokeInternalType;
#[doc(hidden)]
pub struct StrokeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke412415895(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        stroke412415895.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        stroke412415895.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        stroke412415895.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke3942276512(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        stroke3942276512.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        stroke3942276512.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        stroke3942276512.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke2816049361(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        stroke2816049361.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        stroke2816049361.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        stroke2816049361.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke3319503251(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        stroke3319503251.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        stroke3319503251.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        stroke3319503251.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke2738412371(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        stroke2738412371.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        stroke2738412371.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        stroke2738412371.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke3644955701(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        stroke3644955701.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        stroke3644955701.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        stroke3644955701.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "stroke")]
    fn stroke2900705715(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for StrokeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        stroke2900705715.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for StrokeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        stroke2900705715.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for StrokeInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        stroke2900705715.call(args)
    }
}
#[doc=r##"<p>All drawing that follows <a href="#/p5/erase">erase()</a> will subtract from
the canvas.Erased areas will reveal the web page underneath the canvas.Erasing
can be canceled with <a href="#/p5/noErase">noErase()</a>.</p>
<p>Drawing done with <a href="#/p5/image">image()</a> and <a href="#/p5/background">
background()</a> in between <a href="#/p5/erase">erase()</a> and
<a href="#/p5/noErase">noErase()</a> will not erase the canvas but works as usual.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
background(100, 100, 250);
fill(250, 100, 100);
rect(20, 20, 60, 60);
erase();
ellipse(25, 30, 30);
noErase();
```"###]
#[doc=r###"```rust
background(150, 250, 150);
fill(100, 100, 250);
rect(20, 20, 60, 60);
strokeWeight(5);
erase(150, 255);
triangle(50, 10, 70, 50, 90, 10);
noErase();
```"###]
#[doc=r###"```rust
function setup() {
  smooth();
  createCanvas(100, 100, WEBGL);
  // Make a <p> element and put it behind the canvas
  let p = createP('I am a dom element');
  p.center();
  p.style('font-size', '20px');
  p.style('text-align', 'center');
  p.style('z-index', '-9999');
}

function draw() {
  background(250, 250, 150);
  fill(15, 195, 185);
  noStroke();
  sphere(30);
  erase();
  rotateY(frameCount * 0.02);
  translate(0, 0, 40);
  torus(15, 5);
  noErase();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>strengthFill?</code> A number (0-255) for the strength of erasing for a shape's fill.
                                       This will default to 255 when no argument is given, which
                                       is full strength.

"##]
///
///
#[doc = r##"<code>strengthStroke?</code> A number (0-255) for the strength of erasing for a shape's stroke.
                                       This will default to 255 when no argument is given, which
                                       is full strength.

"##]
///

pub static erase: EraseInternalType = EraseInternalType;
#[doc(hidden)]
pub struct EraseInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "erase")]
    fn erase1642211702(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for EraseInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        erase1642211702.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for EraseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        erase1642211702.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for EraseInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        erase1642211702.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "erase")]
    fn erase1247078387(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for EraseInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        erase1247078387.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for EraseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        erase1247078387.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for EraseInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        erase1247078387.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "erase")]
    fn erase4182841939() ;
}

#[doc(hidden)]
impl FnOnce<()> for EraseInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        erase4182841939.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for EraseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        erase4182841939.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for EraseInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        erase4182841939.call(args)
    }
}
#[doc=r##"<p>Ends erasing that was started with <a href="#/p5/erase">erase()</a>.
The <a href="#/p5/fill">fill()</a>, <a href="#/p5/stroke">stroke()</a>, and
<a href="#/p5/blendMode">blendMode()</a> settings will return to what they were
prior to calling <a href="#/p5/erase">erase()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
background(235, 145, 15);
noStroke();
fill(30, 45, 220);
rect(30, 10, 10, 80);
erase();
ellipse(50, 50, 60);
noErase();
rect(70, 10, 10, 80);
```"###]

pub static noErase: NoEraseInternalType = NoEraseInternalType;
#[doc(hidden)]
pub struct NoEraseInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noErase")]
    fn noErase4054924934() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoEraseInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noErase4054924934.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoEraseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noErase4054924934.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoEraseInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noErase4054924934.call(args)
    }
}
#[doc=r##"<p>Creates a new <a href="#/p5.Vector">p5.Vector</a> (the datatype for storing vectors). This provides a
two or three dimensional vector, specifically a Euclidean (also known as
geometric) vector. A vector is an entity that has both magnitude and
direction.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let v1;
function setup() {
  createCanvas(100, 100);
  stroke(255, 0, 255);
  v1 = createVector(width / 2, height / 2);
}

function draw() {
  background(255);
  line(v1.x, v1.y, mouseX, mouseY);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>x?</code> x component of the vector

"##]
///
///
#[doc = r##"<code>y?</code> y component of the vector

"##]
///
///
#[doc = r##"<code>z?</code> z component of the vector

"##]
///

pub static createVector: CreateVectorInternalType = CreateVectorInternalType;
#[doc(hidden)]
pub struct CreateVectorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVector")]
    fn createVector2342535230(_ : f64, _ : f64, _ : f64, ) ->  Vector;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for CreateVectorInternalType {
    type Output =  Vector;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        createVector2342535230.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for CreateVectorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        createVector2342535230.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for CreateVectorInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        createVector2342535230.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVector")]
    fn createVector967321891(_ : f64, _ : f64, ) ->  Vector;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CreateVectorInternalType {
    type Output =  Vector;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        createVector967321891.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CreateVectorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        createVector967321891.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CreateVectorInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        createVector967321891.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVector")]
    fn createVector3775874899(_ : f64, ) ->  Vector;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CreateVectorInternalType {
    type Output =  Vector;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        createVector3775874899.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CreateVectorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        createVector3775874899.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CreateVectorInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        createVector3775874899.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createVector")]
    fn createVector3911826149() ->  Vector;
}

#[doc(hidden)]
impl FnOnce<()> for CreateVectorInternalType {
    type Output =  Vector;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createVector3911826149.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateVectorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createVector3911826149.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateVectorInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createVector3911826149.call(args)
    }
}
#[doc=r##"<p>Loads an opentype font file (.otf, .ttf) from a file or a URL,
and returns a PFont Object. This method is asynchronous,
meaning it may not finish before the next line in your sketch
is executed.</p>
<p>The path to the font should be relative to the HTML file
that links in your sketch. Loading fonts from a URL or other
remote location may be blocked due to your browser's built-in
security.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let myFont;
function preload() {
  myFont = loadFont('assets/inconsolata.otf');
}

function setup() {
  fill('#ED225D');
  textFont(myFont);
  textSize(36);
  text('p5*js', 10, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  loadFont('assets/inconsolata.otf', drawText);
}

function drawText(font) {
  fill('#ED225D');
  textFont(font, 36);
  text('p5*js', 10, 50);
}
```"###]
#[doc=r###"```rust
function preload() {
  loadFont('assets/inconsolata.otf');
}

function setup() {
  let myDiv = createDiv('hello there');
  myDiv.style('font-family', 'Inconsolata');
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   loadFont() completes

"##]
///
///
#[doc = r##"<code>onError?</code> function to be executed if
                                   an error occurs

"##]
///

pub static loadFont: LoadFontInternalType = LoadFontInternalType;
#[doc(hidden)]
pub struct LoadFontInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadFont")]
    fn loadFont934439878(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) ->  Font;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadFontInternalType {
    type Output =  Font;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadFont934439878.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadFont934439878.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadFontInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadFont934439878.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadFont")]
    fn loadFont2534061284(_ : & str, _ : js_sys::Function, ) ->  Font;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadFontInternalType {
    type Output =  Font;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadFont2534061284.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadFont2534061284.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadFontInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadFont2534061284.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadFont")]
    fn loadFont3106314809(_ : & str, ) ->  Font;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadFontInternalType {
    type Output =  Font;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadFont3106314809.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadFont3106314809.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadFontInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadFont3106314809.call(args)
    }
}
#[doc=r##"<p>Draws text to the screen. Displays the information specified in the first
parameter on the screen in the position specified by the additional
parameters. A default font will be used unless a font is set with the
<a href="#/p5/textFont">textFont()</a> function and a default size will be
used unless a font is set with <a href="#/p5/textSize">textSize()</a>. Change
the color of the text with the <a href="#/p5/fill">fill()</a> function. Change
the outline of the text with the <a href="#/p5/stroke">stroke()</a> and
<a href="#/p5/strokeWeight">strokeWeight()</a> functions.</p>
<p>The text displays in relation to the <a href="#/p5/textAlign">textAlign()</a>
function, which gives the option to draw to the left, right, and center of the
coordinates.</p>
<p>The x2 and y2 parameters define a rectangular area to display within and
may only be used with string data. When these parameters are specified,
they are interpreted based on the current <a href="#/p5/rectMode">rectMode()</a>
setting. Text that does not fit completely within the rectangle specified will
not be drawn to the screen. If x2 and y2 are not specified, the baseline
alignment is the default, which means that the text will be drawn upwards
from x and y.</p>
<p><b>WEBGL</b>: Only opentype/truetype fonts are supported. You must load a font
using the <a href="#/p5/loadFont">loadFont()</a> method (see the example above).
<a href="#/p5/stroke">stroke()</a> currently has no effect in webgl mode.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
textSize(32);
text('word', 10, 30);
fill(0, 102, 153);
text('word', 10, 60);
fill(0, 102, 153, 51);
text('word', 10, 90);
```"###]
#[doc=r###"```rust
let s = 'The quick brown fox jumped over the lazy dog.';
fill(50);
text(s, 10, 10, 70, 80); // Text wraps within text box
```"###]
#[doc=r###"```rust
let inconsolata;
function preload() {
  inconsolata = loadFont('assets/inconsolata.otf');
}
function setup() {
  createCanvas(100, 100, WEBGL);
  textFont(inconsolata);
  textSize(width / 3);
  textAlign(CENTER, CENTER);
}
function draw() {
  background(0);
  let time = millis();
  rotateX(time / 1000);
  rotateZ(time / 1234);
  text('p5.js', 0, 0);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>str</code> the alphanumeric
                                            symbols to be displayed

"##]
///
///
#[doc = r##"<code>x</code> x-coordinate of text

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of text

"##]
///
///
#[doc = r##"<code>x2?</code> by default, the width of the text box,
                    see rectMode() for more info

"##]
///
///
#[doc = r##"<code>y2?</code> by default, the height of the text box,
                    see rectMode() for more info

"##]
///

pub static text: TextInternalType = TextInternalType;
#[doc(hidden)]
pub struct TextInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text2536058404(_ : & str, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,f64,)) -> Self::Output {
        text2536058404.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,f64,)) -> Self::Output {
        text2536058404.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,f64,)) -> Self::Output {
        text2536058404.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text3519453930(_ : & str, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        text3519453930.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        text3519453930.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        text3519453930.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text1652968455(_ : & str, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,)) -> Self::Output {
        text1652968455.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,)) -> Self::Output {
        text1652968455.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,)) -> Self::Output {
        text1652968455.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text776613070(_ : JsValue, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,f64,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,f64,f64,f64,f64,)) -> Self::Output {
        text776613070.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,f64,f64,f64,f64,)) -> Self::Output {
        text776613070.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,f64,f64,f64,f64,)) -> Self::Output {
        text776613070.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text3363848399(_ : JsValue, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,f64,f64,f64,)) -> Self::Output {
        text3363848399.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,f64,f64,f64,)) -> Self::Output {
        text3363848399.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,f64,f64,f64,)) -> Self::Output {
        text3363848399.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text1389627121(_ : JsValue, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,f64,f64,)) -> Self::Output {
        text1389627121.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,f64,f64,)) -> Self::Output {
        text1389627121.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,f64,f64,)) -> Self::Output {
        text1389627121.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text2128011574(_ : js_sys::Array, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,f64,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,f64,f64,f64,f64,)) -> Self::Output {
        text2128011574.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,f64,f64,f64,f64,)) -> Self::Output {
        text2128011574.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,f64,f64,f64,f64,)) -> Self::Output {
        text2128011574.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text1154009213(_ : js_sys::Array, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,f64,f64,f64,)) -> Self::Output {
        text1154009213.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,f64,f64,f64,)) -> Self::Output {
        text1154009213.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,f64,f64,f64,)) -> Self::Output {
        text1154009213.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text1870702204(_ : js_sys::Array, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,f64,f64,)) -> Self::Output {
        text1870702204.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,f64,f64,)) -> Self::Output {
        text1870702204.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,f64,f64,)) -> Self::Output {
        text1870702204.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text372610415(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        text372610415.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        text372610415.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        text372610415.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text3465596931(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        text3465596931.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        text3465596931.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        text3465596931.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text1624821964(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        text1624821964.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        text1624821964.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        text1624821964.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text45335175(_ : bool, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(bool,f64,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (bool,f64,f64,f64,f64,)) -> Self::Output {
        text45335175.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,f64,f64,f64,f64,)) -> Self::Output {
        text45335175.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,f64,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (bool,f64,f64,f64,f64,)) -> Self::Output {
        text45335175.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text1095759909(_ : bool, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(bool,f64,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (bool,f64,f64,f64,)) -> Self::Output {
        text1095759909.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,f64,f64,f64,)) -> Self::Output {
        text1095759909.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,f64,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (bool,f64,f64,f64,)) -> Self::Output {
        text1095759909.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "text")]
    fn text4118272228(_ : bool, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(bool,f64,f64,)> for TextInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (bool,f64,f64,)) -> Self::Output {
        text4118272228.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,f64,f64,)) -> Self::Output {
        text4118272228.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,f64,f64,)> for TextInternalType {
    extern "rust-call" fn call(&self, args: (bool,f64,f64,)) -> Self::Output {
        text4118272228.call(args)
    }
}
#[doc=r##"<p>Sets the current font that will be drawn with the <a href="#/p5/text">text()</a> function.</p>
<p><b>WEBGL</b>: Only fonts loaded via <a href="#/p5/loadFont">loadFont()</a> are supported.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
fill(0);
textSize(12);
textFont('Georgia');
text('Georgia', 12, 30);
textFont('Helvetica');
text('Helvetica', 12, 60);
```"###]
#[doc=r###"```rust
let fontRegular, fontItalic, fontBold;
function preload() {
  fontRegular = loadFont('assets/Regular.otf');
  fontItalic = loadFont('assets/Italic.ttf');
  fontBold = loadFont('assets/Bold.ttf');
}
function setup() {
  background(210);
  fill(0)
   .strokeWeight(0)
   .textSize(10);
  textFont(fontRegular);
  text('Font Style Normal', 10, 30);
  textFont(fontItalic);
  text('Font Style Italic', 10, 50);
  textFont(fontBold);
  text('Font Style Bold', 10, 70);
}
```"###]
/// <h2>Overloads</h2>
///
/// ---
///
///
#[doc = r##"<code>font</code> a font loaded via loadFont(),
or a String representing a web safe font
(a font that is generally available across all systems)

"##]
///
///
#[doc = r##"<code>size?</code> the font size to use

"##]
///
///
/// ---
///

pub static textFont: TextFontInternalType = TextFontInternalType;
#[doc(hidden)]
pub struct TextFontInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textFont")]
    fn textFont4236794767() -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<()> for TextFontInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textFont4236794767.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textFont4236794767.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextFontInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textFont4236794767.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textFont")]
    fn textFont1809243248(_ : JsValue, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,f64,)> for TextFontInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,f64,)) -> Self::Output {
        textFont1809243248.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,f64,)> for TextFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,f64,)) -> Self::Output {
        textFont1809243248.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,f64,)> for TextFontInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,f64,)) -> Self::Output {
        textFont1809243248.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textFont")]
    fn textFont2655796619(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for TextFontInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        textFont2655796619.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for TextFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        textFont2655796619.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for TextFontInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        textFont2655796619.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textFont")]
    fn textFont2067820070(_ : & str, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,)> for TextFontInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,)) -> Self::Output {
        textFont2067820070.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,)> for TextFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,)) -> Self::Output {
        textFont2067820070.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,)> for TextFontInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,)) -> Self::Output {
        textFont2067820070.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textFont")]
    fn textFont2145736847(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for TextFontInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        textFont2145736847.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for TextFontInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        textFont2145736847.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for TextFontInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        textFont2145736847.call(args)
    }
}
#[doc=r##"<p>Sets the camera position for a 3D sketch. Parameters for this function define
the position for the camera, the center of the sketch (where the camera is
pointing), and an up direction (the orientation of the camera).</p>
<p>This function simulates the movements of the camera, allowing objects to be
viewed from various angles. Remember, it does not move the objects themselves
but the camera instead. For example when centerX value is positive, the camera
is rotating to the right side of the sketch, so the object would seem like
moving to the left.</p>
<p>See this <a href = "https://www.openprocessing.org/sketch/740258">example</a>
to view the position of your camera.</p>
<p>When called with no arguments, this function creates a default camera
equivalent to
camera(0, 0, (height/2.0) / tan(PI*30.0 / 180.0), 0, 0, 0, 0, 1, 0);</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(204);
  //move the camera away from the plane by a sin wave
  camera(0, 0, 20 + sin(frameCount * 0.01) * 10, 0, 0, 0, 0, 1, 0);
  plane(10, 10);
}
```"###]
#[doc=r###"```rust
//move slider to see changes!
//sliders control the first 6 parameters of camera()
let sliderGroup = [];
let X;
let Y;
let Z;
let centerX;
let centerY;
let centerZ;
let h = 20;

function setup() {
  createCanvas(100, 100, WEBGL);
  //create sliders
  for (var i = 0; i < 6; i++) {
    if (i === 2) {
      sliderGroup[i] = createSlider(10, 400, 200);
    } else {
      sliderGroup[i] = createSlider(-400, 400, 0);
    }
    h = map(i, 0, 6, 5, 85);
    sliderGroup[i].position(10, height + h);
    sliderGroup[i].style('width', '80px');
  }
}

function draw() {
  background(60);
  // assigning sliders' value to each parameters
  X = sliderGroup[0].value();
  Y = sliderGroup[1].value();
  Z = sliderGroup[2].value();
  centerX = sliderGroup[3].value();
  centerY = sliderGroup[4].value();
  centerZ = sliderGroup[5].value();
  camera(X, Y, Z, centerX, centerY, centerZ, 0, 1, 0);
  stroke(255);
  fill(255, 102, 94);
  box(85);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>x?</code> camera position value on x axis

"##]
///
///
#[doc = r##"<code>y?</code> camera position value on y axis

"##]
///
///
#[doc = r##"<code>z?</code> camera position value on z axis

"##]
///
///
#[doc = r##"<code>centerX?</code> x coordinate representing center of the sketch

"##]
///
///
#[doc = r##"<code>centerY?</code> y coordinate representing center of the sketch

"##]
///
///
#[doc = r##"<code>centerZ?</code> z coordinate representing center of the sketch

"##]
///
///
#[doc = r##"<code>upX?</code> x component of direction 'up' from camera

"##]
///
///
#[doc = r##"<code>upY?</code> y component of direction 'up' from camera

"##]
///
///
#[doc = r##"<code>upZ?</code> z component of direction 'up' from camera

"##]
///

pub static camera: CameraInternalType = CameraInternalType;
#[doc(hidden)]
pub struct CameraInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera1831847495(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera1831847495.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera1831847495.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera1831847495.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera4178496106(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera4178496106.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera4178496106.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera4178496106.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera449281822(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera449281822.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera449281822.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera449281822.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera406753441(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera406753441.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera406753441.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        camera406753441.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera3823198585(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        camera3823198585.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        camera3823198585.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        camera3823198585.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera4261161617(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        camera4261161617.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        camera4261161617.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        camera4261161617.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera1748037226(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        camera1748037226.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        camera1748037226.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        camera1748037226.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera1015085667(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        camera1015085667.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        camera1015085667.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        camera1015085667.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera2409931744(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        camera2409931744.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        camera2409931744.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CameraInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        camera2409931744.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "camera")]
    fn camera263198682() ;
}

#[doc(hidden)]
impl FnOnce<()> for CameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        camera263198682.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        camera263198682.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CameraInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        camera263198682.call(args)
    }
}
#[doc=r##"<p>Sets a perspective projection for the camera in a 3D sketch. This projection
represents depth through foreshortening: objects that are close to the camera
appear their actual size while those that are further away from the camera
appear smaller. The parameters to this function define the viewing frustum
(the truncated pyramid within which objects are seen by the camera) through
vertical field of view, aspect ratio (usually width/height), and near and far
clipping planes.</p>
<p>When called with no arguments, the defaults
provided are equivalent to
perspective(PI/3.0, width/height, eyeZ/10.0, eyeZ<em>10.0), where eyeZ
is equal to ((height/2.0) / tan(PI</em>60.0/360.0));</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
//drag the mouse to look around!
function setup() {
  createCanvas(100, 100, WEBGL);
  perspective(PI / 3.0, width / height, 0.1, 500);
}
function draw() {
  background(200);
  orbitControl();
  normalMaterial();

  rotateX(-0.3);
  rotateY(-0.2);
  translate(0, 0, -50);

  push();
  translate(-15, 0, sin(frameCount / 30) * 95);
  box(30);
  pop();
  push();
  translate(15, 0, sin(frameCount / 30 + PI) * 95);
  box(30);
  pop();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>fovy?</code> camera frustum vertical field of view,
                          from bottom to top of view, in angleMode units

"##]
///
///
#[doc = r##"<code>aspect?</code> camera frustum aspect ratio

"##]
///
///
#[doc = r##"<code>near?</code> frustum near plane length

"##]
///
///
#[doc = r##"<code>far?</code> frustum far plane length

"##]
///

pub static perspective: PerspectiveInternalType = PerspectiveInternalType;
#[doc(hidden)]
pub struct PerspectiveInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "perspective")]
    fn perspective3728625815(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for PerspectiveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        perspective3728625815.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        perspective3728625815.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        perspective3728625815.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "perspective")]
    fn perspective1796968339(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for PerspectiveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        perspective1796968339.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        perspective1796968339.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        perspective1796968339.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "perspective")]
    fn perspective757771593(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for PerspectiveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        perspective757771593.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        perspective757771593.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        perspective757771593.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "perspective")]
    fn perspective879215782(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for PerspectiveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        perspective879215782.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        perspective879215782.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for PerspectiveInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        perspective879215782.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "perspective")]
    fn perspective2966358409() ;
}

#[doc(hidden)]
impl FnOnce<()> for PerspectiveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        perspective2966358409.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for PerspectiveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        perspective2966358409.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for PerspectiveInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        perspective2966358409.call(args)
    }
}
#[doc=r##"<p>Sets an orthographic projection for the camera in a 3D sketch and defines a
box-shaped viewing frustum within which objects are seen. In this projection,
all objects with the same dimension appear the same size, regardless of
whether they are near or far from the camera. The parameters to this
function specify the viewing frustum where left and right are the minimum and
maximum x values, top and bottom are the minimum and maximum y values, and near
and far are the minimum and maximum z values. If no parameters are given, the
default is used: ortho(-width/2, width/2, -height/2, height/2).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
//drag the mouse to look around!
//there's no vanishing point
function setup() {
  createCanvas(100, 100, WEBGL);
  ortho(-width / 2, width / 2, height / 2, -height / 2, 0, 500);
}
function draw() {
  background(200);
  orbitControl();
  normalMaterial();

  rotateX(0.2);
  rotateY(-0.2);
  push();
  translate(-15, 0, sin(frameCount / 30) * 65);
  box(30);
  pop();
  push();
  translate(15, 0, sin(frameCount / 30 + PI) * 65);
  box(30);
  pop();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>left?</code> camera frustum left plane

"##]
///
///
#[doc = r##"<code>right?</code> camera frustum right plane

"##]
///
///
#[doc = r##"<code>bottom?</code> camera frustum bottom plane

"##]
///
///
#[doc = r##"<code>top?</code> camera frustum top plane

"##]
///
///
#[doc = r##"<code>near?</code> camera frustum near plane

"##]
///
///
#[doc = r##"<code>far?</code> camera frustum far plane

"##]
///

pub static ortho: OrthoInternalType = OrthoInternalType;
#[doc(hidden)]
pub struct OrthoInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho901040758(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        ortho901040758.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        ortho901040758.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        ortho901040758.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho2082655552(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        ortho2082655552.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        ortho2082655552.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        ortho2082655552.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho357273386(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        ortho357273386.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        ortho357273386.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        ortho357273386.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho276651799(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        ortho276651799.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        ortho276651799.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        ortho276651799.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho2225766558(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        ortho2225766558.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        ortho2225766558.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        ortho2225766558.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho3786966317(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        ortho3786966317.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        ortho3786966317.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        ortho3786966317.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ortho")]
    fn ortho1748996739() ;
}

#[doc(hidden)]
impl FnOnce<()> for OrthoInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        ortho1748996739.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for OrthoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        ortho1748996739.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for OrthoInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        ortho1748996739.call(args)
    }
}
#[doc=r##"<p>Sets a perspective matrix as defined by the parameters.</p>
<p>A frustum is a geometric form: a pyramid with its top
cut off. With the viewer's eye at the imaginary top of
the pyramid, the six planes of the frustum act as clipping
planes when rendering a 3D view. Thus, any form inside the
clipping planes is visible; anything outside
those planes is not visible.</p>
<p>Setting the frustum changes the perspective of the scene being rendered.
This can be achieved more simply in many cases by using
<a href="https://p5js.org/reference/#/p5/perspective">perspective()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  setAttributes('antialias', true);
  frustum(-0.1, 0.1, -0.1, 0.1, 0.1, 200);
}
function draw() {
  background(200);
  orbitControl();
  strokeWeight(10);
  stroke(0, 0, 255);
  noFill();

  rotateY(-0.2);
  rotateX(-0.3);
  push();
  translate(-15, 0, sin(frameCount / 30) * 25);
  box(30);
  pop();
  push();
  translate(15, 0, sin(frameCount / 30 + PI) * 25);
  box(30);
  pop();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>left?</code> camera frustum left plane

"##]
///
///
#[doc = r##"<code>right?</code> camera frustum right plane

"##]
///
///
#[doc = r##"<code>bottom?</code> camera frustum bottom plane

"##]
///
///
#[doc = r##"<code>top?</code> camera frustum top plane

"##]
///
///
#[doc = r##"<code>near?</code> camera frustum near plane

"##]
///
///
#[doc = r##"<code>far?</code> camera frustum far plane

"##]
///

pub static frustum: FrustumInternalType = FrustumInternalType;
#[doc(hidden)]
pub struct FrustumInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum3494307598(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        frustum3494307598.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        frustum3494307598.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        frustum3494307598.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum2476450996(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        frustum2476450996.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        frustum2476450996.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        frustum2476450996.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum3512245681(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        frustum3512245681.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        frustum3512245681.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        frustum3512245681.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum2413833478(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        frustum2413833478.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        frustum2413833478.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        frustum2413833478.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum1005227882(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        frustum1005227882.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        frustum1005227882.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        frustum1005227882.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum4072316017(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        frustum4072316017.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        frustum4072316017.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        frustum4072316017.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "frustum")]
    fn frustum3607210306() ;
}

#[doc(hidden)]
impl FnOnce<()> for FrustumInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        frustum3607210306.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for FrustumInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        frustum3607210306.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for FrustumInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        frustum3607210306.call(args)
    }
}
#[doc=r##"<p>Creates a new <a href="#/p5.Camera">p5.Camera</a> object and tells the
renderer to use that camera.
Returns the p5.Camera object.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Creates a camera object and animates it around a box.
let camera;
function setup() {
  createCanvas(100, 100, WEBGL);
  background(0);
  camera = createCamera();
  setCamera(camera);
}

function draw() {
  camera.lookAt(0, 0, 0);
  camera.setPosition(sin(frameCount / 60) * 200, 0, 100);
  box(20);
}
```"###]

pub static createCamera: CreateCameraInternalType = CreateCameraInternalType;
#[doc(hidden)]
pub struct CreateCameraInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCamera")]
    fn createCamera388263915() ->  Camera;
}

#[doc(hidden)]
impl FnOnce<()> for CreateCameraInternalType {
    type Output =  Camera;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        createCamera388263915.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for CreateCameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        createCamera388263915.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for CreateCameraInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        createCamera388263915.call(args)
    }
}
#[doc=r##"<p>Sets rendererGL's current camera to a p5.Camera object.  Allows switching
between multiple cameras.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let cam1, cam2;
let currentCamera;

function setup() {
  createCanvas(100, 100, WEBGL);
  normalMaterial();

  cam1 = createCamera();
  cam2 = createCamera();
  cam2.setPosition(30, 0, 50);
  cam2.lookAt(0, 0, 0);
  cam2.ortho();

  // set variable for previously active camera:
  currentCamera = 1;
}

function draw() {
  background(200);

  // camera 1:
  cam1.lookAt(0, 0, 0);
  cam1.setPosition(sin(frameCount / 60) * 200, 0, 100);

  // every 100 frames, switch between the two cameras
  if (frameCount % 100 === 0) {
    if (currentCamera === 1) {
      setCamera(cam1);
      currentCamera = 0;
    } else {
      setCamera(cam2);
      currentCamera = 1;
    }
  }

  drawBoxes();
}

function drawBoxes() {
  rotateX(frameCount * 0.01);
  translate(-100, 0, 0);
  box(20);
  translate(35, 0, 0);
  box(20);
  translate(35, 0, 0);
  box(20);
  translate(35, 0, 0);
  box(20);
  translate(35, 0, 0);
  box(20);
  translate(35, 0, 0);
  box(20);
  translate(35, 0, 0);
  box(20);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>cam</code> p5.Camera object

"##]
///

pub static setCamera: SetCameraInternalType = SetCameraInternalType;
#[doc(hidden)]
pub struct SetCameraInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "setCamera")]
    fn setCamera410628466(_ : & Camera, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Camera,)> for SetCameraInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Camera,)) -> Self::Output {
        setCamera410628466.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Camera,)> for SetCameraInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Camera,)) -> Self::Output {
        setCamera410628466.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Camera,)> for SetCameraInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Camera,)) -> Self::Output {
        setCamera410628466.call(args)
    }
}
#[doc=r##"<p>Returns the Perlin noise value at specified coordinates. Perlin noise is
a random sequence generator producing a more naturally ordered, harmonic
succession of numbers compared to the standard <b>random()</b> function.
It was invented by Ken Perlin in the 1980s and been used since in
graphical applications to produce procedural textures, natural motion,
shapes, terrains etc.<br /><br /> The main difference to the
<b>random()</b> function is that Perlin noise is defined in an infinite
n-dimensional space where each pair of coordinates corresponds to a
fixed semi-random value (fixed only for the lifespan of the program; see
the <a href="#/p5/noiseSeed">noiseSeed()</a> function). p5.js can compute 1D, 2D and 3D noise,
depending on the number of coordinates given. The resulting value will
always be between 0.0 and 1.0. The noise value can be animated by moving
through the noise space as demonstrated in the example above. The 2nd
and 3rd dimension can also be interpreted as time.<br /><br />The actual
noise is structured similar to an audio signal, in respect to the
function's use of frequencies. Similar to the concept of harmonics in
physics, perlin noise is computed over several octaves which are added
together for the final result. <br /><br />Another way to adjust the
character of the resulting sequence is the scale of the input
coordinates. As the function works within an infinite space the value of
the coordinates doesn't matter as such, only the distance between
successive coordinates does (eg. when using <b>noise()</b> within a
loop). As a general rule the smaller the difference between coordinates,
the smoother the resulting noise sequence will be. Steps of 0.005-0.03
work best for most applications, but this will differ depending on use.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let xoff = 0.0;

function draw() {
  background(204);
  xoff = xoff + 0.01;
  let n = noise(xoff) * width;
  line(n, 0, n, height);
}
```"###]
#[doc=r###"```rustlet noiseScale=0.02;

function draw() {
  background(0);
  for (let x=0; x < width; x++) {
    let noiseVal = noise((mouseX+x)*noiseScale, mouseY*noiseScale);
    stroke(noiseVal*255);
    line(x, mouseY+noiseVal*80, x, height);
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>x</code> x-coordinate in noise space

"##]
///
///
#[doc = r##"<code>y?</code> y-coordinate in noise space

"##]
///
///
#[doc = r##"<code>z?</code> z-coordinate in noise space

"##]
///

pub static noise: NoiseInternalType = NoiseInternalType;
#[doc(hidden)]
pub struct NoiseInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noise")]
    fn noise1655247029(_ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for NoiseInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        noise1655247029.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for NoiseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        noise1655247029.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for NoiseInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        noise1655247029.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noise")]
    fn noise3615599331(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for NoiseInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        noise3615599331.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for NoiseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        noise3615599331.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for NoiseInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        noise3615599331.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noise")]
    fn noise1881910504(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for NoiseInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        noise1881910504.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for NoiseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        noise1881910504.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for NoiseInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        noise1881910504.call(args)
    }
}
#[doc=r##"<p>Adjusts the character and level of detail produced by the Perlin noise
 function. Similar to harmonics in physics, noise is computed over
 several octaves. Lower octaves contribute more to the output signal and
 as such define the overall intensity of the noise, whereas higher octaves
 create finer grained details in the noise sequence.
By default, noise is computed over 4 octaves with each octave contributing
 exactly half than its predecessor, starting at 50% strength for the 1st
 octave. This falloff amount can be changed by adding an additional function
 parameter. Eg. a falloff factor of 0.75 means each octave will now have
 75% impact (25% less) of the previous lower octave. Any value between
 0.0 and 1.0 is valid, however note that values greater than 0.5 might
 result in greater than 1.0 values returned by <b>noise()</b>.
By changing these parameters, the signal created by the <b>noise()</b>
 function can be adapted to fit very specific needs and characteristics.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 let noiseVal;
 let noiseScale = 0.02;
function setup() {
   createCanvas(100, 100);
 }
function draw() {
   background(0);
   for (let y = 0; y < height; y++) {
     for (let x = 0; x < width / 2; x++) {
       noiseDetail(2, 0.2);
       noiseVal = noise((mouseX + x) * noiseScale, (mouseY + y) * noiseScale);
       stroke(noiseVal * 255);
       point(x, y);
       noiseDetail(8, 0.65);
       noiseVal = noise(
         (mouseX + x + width / 2) * noiseScale,
         (mouseY + y) * noiseScale
       );
       stroke(noiseVal * 255);
       point(x + width / 2, y);
     }
   }
 }
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>lod</code> number of octaves to be used by the noise

"##]
///
///
#[doc = r##"<code>falloff</code> falloff factor for each octave

"##]
///

pub static noiseDetail: NoiseDetailInternalType = NoiseDetailInternalType;
#[doc(hidden)]
pub struct NoiseDetailInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noiseDetail")]
    fn noiseDetail216806624(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for NoiseDetailInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        noiseDetail216806624.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for NoiseDetailInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        noiseDetail216806624.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for NoiseDetailInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        noiseDetail216806624.call(args)
    }
}
#[doc=r##"<p>Sets the seed value for <b>noise()</b>. By default, <b>noise()</b>
produces different results each time the program is run. Set the
<b>value</b> parameter to a constant to return the same pseudo-random
numbers each time the software is run.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rustlet xoff = 0.0;

function setup() {
  noiseSeed(99);
  stroke(0, 10);
}

function draw() {
  xoff = xoff + .01;
  let n = noise(xoff) * width;
  line(n, 0, n, height);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>seed</code> the seed value

"##]
///

pub static noiseSeed: NoiseSeedInternalType = NoiseSeedInternalType;
#[doc(hidden)]
pub struct NoiseSeedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noiseSeed")]
    fn noiseSeed3132825471(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for NoiseSeedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        noiseSeed3132825471.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for NoiseSeedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        noiseSeed3132825471.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for NoiseSeedInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        noiseSeed3132825471.call(args)
    }
}
#[doc=r##"<p>The touchStarted() function is called once after every time a touch is
registered. If no <a href="#/p5/touchStarted">touchStarted()</a> function is defined, the <a href="#/p5/mousePressed">mousePressed()</a>
function will be called instead if it is defined.<br><br>
Browsers may have different default behaviors attached to various touch
events. To prevent any default behavior for this event, add "return false"
to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Touch within the image to change
// the value of the rectangle

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function touchStarted() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function touchStarted() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a TouchEvent object
// as a callback argument
function touchStarted(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional TouchEvent callback argument.

"##]
///

pub static touchStarted: TouchStartedInternalType = TouchStartedInternalType;
#[doc(hidden)]
pub struct TouchStartedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "touchStarted")]
    fn touchStarted267435383(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for TouchStartedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        touchStarted267435383.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for TouchStartedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        touchStarted267435383.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for TouchStartedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        touchStarted267435383.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "touchStarted")]
    fn touchStarted3314450930() ;
}

#[doc(hidden)]
impl FnOnce<()> for TouchStartedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        touchStarted3314450930.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TouchStartedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        touchStarted3314450930.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TouchStartedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        touchStarted3314450930.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/touchMoved">touchMoved()</a> function is called every time a touch move is registered.
If no <a href="#/p5/touchMoved">touchMoved()</a> function is defined, the <a href="#/p5/mouseDragged">mouseDragged()</a> function will
be called instead if it is defined.<br><br>
Browsers may have different default behaviors attached to various touch
events. To prevent any default behavior for this event, add "return false"
to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Move your finger across the page
// to change its value

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function touchMoved() {
  value = value + 5;
  if (value > 255) {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function touchMoved() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a TouchEvent object
// as a callback argument
function touchMoved(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional TouchEvent callback argument.

"##]
///

pub static touchMoved: TouchMovedInternalType = TouchMovedInternalType;
#[doc(hidden)]
pub struct TouchMovedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "touchMoved")]
    fn touchMoved1051752438(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for TouchMovedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        touchMoved1051752438.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for TouchMovedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        touchMoved1051752438.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for TouchMovedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        touchMoved1051752438.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "touchMoved")]
    fn touchMoved888449764() ;
}

#[doc(hidden)]
impl FnOnce<()> for TouchMovedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        touchMoved888449764.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TouchMovedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        touchMoved888449764.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TouchMovedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        touchMoved888449764.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/touchEnded">touchEnded()</a> function is called every time a touch ends. If no
<a href="#/p5/touchEnded">touchEnded()</a> function is defined, the <a href="#/p5/mouseReleased">mouseReleased()</a> function will be
called instead if it is defined.<br><br>
Browsers may have different default behaviors attached to various touch
events. To prevent any default behavior for this event, add "return false"
to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Release touch within the image to
// change the value of the rectangle

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function touchEnded() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function touchEnded() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a TouchEvent object
// as a callback argument
function touchEnded(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional TouchEvent callback argument.

"##]
///

pub static touchEnded: TouchEndedInternalType = TouchEndedInternalType;
#[doc(hidden)]
pub struct TouchEndedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "touchEnded")]
    fn touchEnded2964030481(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for TouchEndedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        touchEnded2964030481.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for TouchEndedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        touchEnded2964030481.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for TouchEndedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        touchEnded2964030481.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "touchEnded")]
    fn touchEnded692003763() ;
}

#[doc(hidden)]
impl FnOnce<()> for TouchEndedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        touchEnded692003763.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TouchEndedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        touchEnded692003763.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TouchEndedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        touchEnded692003763.call(args)
    }
}
#[doc=r##"<p>Loads an image from a path and creates a <a href="#/p5.Image">p5.Image</a> from it.</p>
<p>The image may not be immediately available for rendering.
If you want to ensure that the image is ready before doing
anything with it, place the <a href="#/p5/loadImage">loadImage()</a> call in <a href="#/p5/preload">preload()</a>.
You may also supply a callback function to handle the image when it's ready.</p>
<p>The path to the image should be relative to the HTML file
that links in your sketch. Loading an image from a URL or other
remote location may be blocked due to your browser's built-in
security.</p>
<p>You can also pass in a string of a base64 encoded image as an alternative to the file path.
Remember to add "data:image/png;base64," in front of the string.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}
function setup() {
  image(img, 0, 0);
}
```"###]
#[doc=r###"```rust
function setup() {
  // here we use a callback to display the image after loading
  loadImage('assets/laDefense.jpg', img => {
    image(img, 0, 0);
  });
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>path</code> Path of the image to be loaded

"##]
///
///
#[doc = r##"<code>successCallback?</code> Function to be called once
                               the image is loaded. Will be passed the
                               p5.Image.

"##]
///
///
#[doc = r##"<code>failureCallback?</code> called with event error if
                               the image fails to load.

"##]
///

pub static loadImage: LoadImageInternalType = LoadImageInternalType;
#[doc(hidden)]
pub struct LoadImageInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadImage")]
    fn loadImage3717016410(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) ->  Image;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadImageInternalType {
    type Output =  Image;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadImage3717016410.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadImage3717016410.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadImage3717016410.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadImage")]
    fn loadImage3830241055(_ : & str, _ : js_sys::Function, ) ->  Image;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadImageInternalType {
    type Output =  Image;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadImage3830241055.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadImage3830241055.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadImage3830241055.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadImage")]
    fn loadImage624139017(_ : & str, ) ->  Image;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadImageInternalType {
    type Output =  Image;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadImage624139017.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadImage624139017.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadImage624139017.call(args)
    }
}
#[doc=r##"<p>Draw an image to the p5.js canvas.</p>
<p>This function can be used with different numbers of parameters. The
simplest use requires only three parameters: img, x, and y—where (x, y) is
the position of the image. Two more parameters can optionally be added to
specify the width and height of the image.</p>
<p>This function can also be used with all eight Number parameters. To
differentiate between all these parameters, p5.js uses the language of
"destination rectangle" (which corresponds to "dx", "dy", etc.) and "source
image" (which corresponds to "sx", "sy", etc.) below. Specifying the
"source image" dimensions can be useful when you want to display a
subsection of the source image instead of the whole thing. Here's a diagram
to explain further:
<img src="assets/drawImage.png"></img></p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}
function setup() {
  // Top-left corner of the img is at (0, 0)
  // Width and height are the img's original width and height
  image(img, 0, 0);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}
function setup() {
  background(50);
  // Top-left corner of the img is at (10, 10)
  // Width and height are 50 x 50
  image(img, 10, 10, 50, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  // Here, we use a callback to display the image after loading
  loadImage('assets/laDefense.jpg', img => {
    image(img, 0, 0);
  });
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/gradient.png');
}
function setup() {
  // 1. Background image
  // Top-left corner of the img is at (0, 0)
  // Width and height are the img's original width and height, 100 x 100
  image(img, 0, 0);
  // 2. Top right image
  // Top-left corner of destination rectangle is at (50, 0)
  // Destination rectangle width and height are 40 x 20
  // The next parameters are relative to the source image:
  // - Starting at position (50, 50) on the source image, capture a 50 x 50
  // subsection
  // - Draw this subsection to fill the dimensions of the destination rectangle
  image(img, 50, 0, 40, 20, 50, 50, 50, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>img</code> the image to display

"##]
///
///
#[doc = r##"<code>x</code> the x-coordinate of the top-left corner of the image

"##]
///
///
#[doc = r##"<code>y</code> the y-coordinate of the top-left corner of the image

"##]
///
///
#[doc = r##"<code>width?</code> the width to draw the image

"##]
///
///
#[doc = r##"<code>height?</code> the height to draw the image

"##]
///
///
/// ---
///
///
#[doc = r##"<code>img</code> the image to display

"##]
///
///
#[doc = r##"<code>dx</code> the x-coordinate of the destination
                          rectangle in which to draw the source image

"##]
///
///
#[doc = r##"<code>dy</code> the y-coordinate of the destination
                          rectangle in which to draw the source image

"##]
///
///
#[doc = r##"<code>dWidth</code> the width of the destination rectangle

"##]
///
///
#[doc = r##"<code>dHeight</code> the height of the destination rectangle

"##]
///
///
#[doc = r##"<code>sx</code> the x-coordinate of the subsection of the source
image to draw into the destination rectangle

"##]
///
///
#[doc = r##"<code>sy</code> the y-coordinate of the subsection of the source
image to draw into the destination rectangle

"##]
///
///
#[doc = r##"<code>sWidth?</code> the width of the subsection of the
                          source image to draw into the destination
                          rectangle

"##]
///
///
#[doc = r##"<code>sHeight?</code> the height of the subsection of the
                           source image to draw into the destination rectangle

"##]
///
///
/// ---
///

pub static image: ImageInternalType = ImageInternalType;
#[doc(hidden)]
pub struct ImageInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image2508069368(_ : & Image, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,f64,f64,f64,)) -> Self::Output {
        image2508069368.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,f64,f64,f64,)) -> Self::Output {
        image2508069368.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,f64,f64,f64,)) -> Self::Output {
        image2508069368.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image1124913249(_ : & Image, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,f64,f64,)) -> Self::Output {
        image1124913249.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,f64,f64,)) -> Self::Output {
        image1124913249.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,f64,f64,)) -> Self::Output {
        image1124913249.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image3656151773(_ : & Image, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,f64,)) -> Self::Output {
        image3656151773.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,f64,)) -> Self::Output {
        image3656151773.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,f64,)) -> Self::Output {
        image3656151773.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image1499672323(_ : & Element, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,f64,f64,f64,f64,)) -> Self::Output {
        image1499672323.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,f64,f64,f64,f64,)) -> Self::Output {
        image1499672323.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,f64,f64,f64,f64,)) -> Self::Output {
        image1499672323.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image507733629(_ : & Element, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,f64,f64,f64,)) -> Self::Output {
        image507733629.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,f64,f64,f64,)) -> Self::Output {
        image507733629.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,f64,f64,f64,)) -> Self::Output {
        image507733629.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image3038732966(_ : & Element, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,f64,f64,)) -> Self::Output {
        image3038732966.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,f64,f64,)) -> Self::Output {
        image3038732966.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,f64,f64,)) -> Self::Output {
        image3038732966.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image3398954449(_ : & Image, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image3398954449.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image3398954449.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image3398954449.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image3252890054(_ : & Image, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image3252890054.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image3252890054.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image3252890054.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image1748463541(_ : & Image, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image1748463541.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image1748463541.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image1748463541.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image1032710974(_ : & Element, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,f64,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image1032710974.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,f64,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image1032710974.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,f64,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image1032710974.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image2724020135(_ : & Element, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image2724020135.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image2724020135.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,f64,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image2724020135.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "image")]
    fn image369804082(_ : & Element, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image369804082.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image369804082.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,f64,f64,f64,f64,f64,f64,)> for ImageInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        image369804082.call(args)
    }
}
#[doc=r##"<p>Sets the fill value for displaying images. Images can be tinted to
specified colors or made transparent by including an alpha value.</p>
<p>To apply transparency to an image without affecting its color, use
white as the tint color and specify an alpha value. For instance,
tint(255, 128) will make an image 50% transparent (assuming the default
alpha range of 0-255, which can be changed with <a href="#/p5/colorMode">colorMode()</a>).</p>
<p>The value for the gray parameter must be less than or equal to the current
maximum value as specified by <a href="#/p5/colorMode">colorMode()</a>. The default maximum value is
255.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}
function setup() {
  image(img, 0, 0);
  tint(0, 153, 204); // Tint blue
  image(img, 50, 0);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}
function setup() {
  image(img, 0, 0);
  tint(0, 153, 204, 126); // Tint blue and set transparency
  image(img, 50, 0);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/laDefense.jpg');
}
function setup() {
  image(img, 0, 0);
  tint(255, 126); // Apply transparency without changing color
  image(img, 50, 0);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>alpha?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>value</code> a color string

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gray</code> a gray value

"##]
///
///
#[doc = r##"<code>alpha?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red,green,blue &
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> the tint color

"##]
///
///
/// ---
///

pub static tint: TintInternalType = TintInternalType;
#[doc(hidden)]
pub struct TintInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint1823704709(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        tint1823704709.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        tint1823704709.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        tint1823704709.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint4125068485(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        tint4125068485.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        tint4125068485.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        tint4125068485.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint1456239000(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        tint1456239000.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        tint1456239000.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        tint1456239000.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint1625560424(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        tint1625560424.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        tint1625560424.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        tint1625560424.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint431495345(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        tint431495345.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        tint431495345.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        tint431495345.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint2083838113(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        tint2083838113.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        tint2083838113.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        tint2083838113.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tint")]
    fn tint1853969400(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for TintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        tint1853969400.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for TintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        tint1853969400.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for TintInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        tint1853969400.call(args)
    }
}
#[doc=r##"<p>Removes the current fill value for displaying images and reverts to
displaying images with their original hues.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  tint(0, 153, 204); // Tint blue
  image(img, 0, 0);
  noTint(); // Disable tint
  image(img, 50, 0);
}
```"###]

pub static noTint: NoTintInternalType = NoTintInternalType;
#[doc(hidden)]
pub struct NoTintInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noTint")]
    fn noTint1190616066() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoTintInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noTint1190616066.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoTintInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noTint1190616066.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoTintInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noTint1190616066.call(args)
    }
}
#[doc=r##"<p>Set image mode. Modifies the location from which images are drawn by
changing the way in which parameters given to <a href="#/p5/image">image()</a> are interpreted.
The default mode is imageMode(CORNER), which interprets the second and
third parameters of <a href="#/p5/image">image()</a> as the upper-left corner of the image. If
two additional parameters are specified, they are used to set the image's
width and height.</p>
<p>imageMode(CORNERS) interprets the second and third parameters of <a href="#/p5/image">image()</a>
as the location of one corner, and the fourth and fifth parameters as the
opposite corner.</p>
<p>imageMode(CENTER) interprets the second and third parameters of <a href="#/p5/image">image()</a>
as the image's center point. If two additional parameters are specified,
they are used to set the image's width and height.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  imageMode(CORNER);
  image(img, 10, 10, 50, 50);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  imageMode(CORNERS);
  image(img, 10, 10, 90, 40);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  imageMode(CENTER);
  image(img, 50, 50, 80, 80);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode</code> either CORNER, CORNERS, or CENTER

"##]
///

pub static imageMode: ImageModeInternalType = ImageModeInternalType;
#[doc(hidden)]
pub struct ImageModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "imageMode")]
    fn imageMode436145913(_ : IMAGE_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(IMAGE_MODE,)> for ImageModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (IMAGE_MODE,)) -> Self::Output {
        imageMode436145913.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(IMAGE_MODE,)> for ImageModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (IMAGE_MODE,)) -> Self::Output {
        imageMode436145913.call(args)
    }
}

#[doc(hidden)]
impl Fn<(IMAGE_MODE,)> for ImageModeInternalType {
    extern "rust-call" fn call(&self, args: (IMAGE_MODE,)) -> Self::Output {
        imageMode436145913.call(args)
    }
}
#[doc=r##"<p>Creates a screen-reader accessible description for the canvas.
The first parameter should be a string with a description of the canvas.
The second parameter is optional. If specified, it determines how the
description is displayed.</p>
<p><code class="language-javascript">describe(text, LABEL)</code> displays
the description to all users as a <a
href="https://en.wikipedia.org/wiki/Museum_label" target="_blank">
tombstone or exhibit label/caption</a> in a
<code class="language-javascript"><div class="p5Label"></div></code>
adjacent to the canvas. You can style it as you wish in your CSS.</p>
<p><code class="language-javascript">describe(text, FALLBACK)</code> makes the
description accessible to screen-reader users only, in
<a href="https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API/Tutorial/Hit_regions_and_accessibility" target="_blank">
a sub DOM inside the canvas element</a>. If a second parameter is not
specified, by default, the description will only be available to
screen-reader users.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
describe('pink square with red heart in the bottom right corner', LABEL);
background('pink');
fill('red');
noStroke();
ellipse(67, 67, 20, 20);
ellipse(83, 67, 20, 20);
triangle(91, 73, 75, 95, 59, 73);
```"###]
#[doc=r###"```rust
let x = 0;
function draw() {
  if (x > 100) {
    x = 0;
  }
  background(220);
  fill(0, 255, 0);
  ellipse(x, 50, 40, 40);
  x = x + 0.1;
  describe('green circle at x pos ' + round(x) + ' moving to the right');
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>text</code> description of the canvas

"##]
///
///
#[doc = r##"<code>display?</code> either LABEL or FALLBACK (Optional)

"##]
///

pub static describe: DescribeInternalType = DescribeInternalType;
#[doc(hidden)]
pub struct DescribeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "describe")]
    fn describe3975752781(_ : & str, _ : DESCRIBE_DISPLAY, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,DESCRIBE_DISPLAY,)> for DescribeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,DESCRIBE_DISPLAY,)) -> Self::Output {
        describe3975752781.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,DESCRIBE_DISPLAY,)> for DescribeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,DESCRIBE_DISPLAY,)) -> Self::Output {
        describe3975752781.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,DESCRIBE_DISPLAY,)> for DescribeInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,DESCRIBE_DISPLAY,)) -> Self::Output {
        describe3975752781.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "describe")]
    fn describe570787641(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for DescribeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        describe570787641.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for DescribeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        describe570787641.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for DescribeInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        describe570787641.call(args)
    }
}
#[doc=r##"<p>This function creates a screen-reader accessible
description for elements —shapes or groups of shapes that create
meaning together— in the canvas. The first paramater should
be the name of the element. The second parameter should be a string
with a description of the element. The third parameter is optional.
If specified, it determines how the element description is displayed.</p>
<p><code class="language-javascript">describeElement(name, text, LABEL)</code>
displays the element description to all users as a
<a href="https://en.wikipedia.org/wiki/Museum_label" target="_blank">
tombstone or exhibit label/caption</a> in a
<code class="language-javascript"><div class="p5Label"></div></code>
adjacent to the canvas. You can style it as you wish in your CSS.</p>
<p><code class="language-javascript">describeElement(name, text, FALLBACK)</code>
makes the element description accessible to screen-reader users
only, in <a href="https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API/Tutorial/Hit_regions_and_accessibility" target="_blank">
a sub DOM inside the canvas element</a>. If a second parameter is not
specified, by default, the element description will only be available
to screen-reader users.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
describe('Heart and yellow circle over pink background', LABEL);
noStroke();
background('pink');
describeElement('Circle', 'Yellow circle in the top left corner', LABEL);
fill('yellow');
ellipse(25, 25, 40, 40);
describeElement('Heart', 'red heart in the bottom right corner', LABEL);
fill('red');
ellipse(66.6, 66.6, 20, 20);
ellipse(83.2, 66.6, 20, 20);
triangle(91.2, 72.6, 75, 95, 58.6, 72.6);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>name</code> name of the element

"##]
///
///
#[doc = r##"<code>text</code> description of the element

"##]
///
///
#[doc = r##"<code>display?</code> either LABEL or FALLBACK (Optional)

"##]
///

pub static describeElement: DescribeElementInternalType = DescribeElementInternalType;
#[doc(hidden)]
pub struct DescribeElementInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "describeElement")]
    fn describeElement2255475313(_ : & str, _ : & str, _ : DESCRIBE_DISPLAY, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,DESCRIBE_DISPLAY,)> for DescribeElementInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,DESCRIBE_DISPLAY,)) -> Self::Output {
        describeElement2255475313.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,DESCRIBE_DISPLAY,)> for DescribeElementInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,DESCRIBE_DISPLAY,)) -> Self::Output {
        describeElement2255475313.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,DESCRIBE_DISPLAY,)> for DescribeElementInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,DESCRIBE_DISPLAY,)) -> Self::Output {
        describeElement2255475313.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "describeElement")]
    fn describeElement4188445144(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for DescribeElementInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        describeElement4188445144.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for DescribeElementInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        describeElement4188445144.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for DescribeElementInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        describeElement4188445144.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/mouseMoved">mouseMoved()</a> function is called every time the mouse moves and a mouse
button is not pressed.<br><br>
Browsers may have different default
behaviors attached to various mouse events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Move the mouse across the page
// to change its value

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function mouseMoved() {
  value = value + 5;
  if (value > 255) {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function mouseMoved() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a MouseEvent object
// as a callback argument
function mouseMoved(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional MouseEvent callback argument.

"##]
///

pub static mouseMoved: MouseMovedInternalType = MouseMovedInternalType;
#[doc(hidden)]
pub struct MouseMovedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseMoved")]
    fn mouseMoved34348963(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for MouseMovedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        mouseMoved34348963.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for MouseMovedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        mouseMoved34348963.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for MouseMovedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        mouseMoved34348963.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseMoved")]
    fn mouseMoved3189491486() ;
}

#[doc(hidden)]
impl FnOnce<()> for MouseMovedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        mouseMoved3189491486.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MouseMovedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        mouseMoved3189491486.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MouseMovedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        mouseMoved3189491486.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/mouseDragged">mouseDragged()</a> function is called once every time the mouse moves and
a mouse button is pressed. If no <a href="#/p5/mouseDragged">mouseDragged()</a> function is defined, the
<a href="#/p5/touchMoved">touchMoved()</a> function will be called instead if it is defined.<br><br>
Browsers may have different default
behaviors attached to various mouse events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Drag the mouse across the page
// to change its value

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function mouseDragged() {
  value = value + 5;
  if (value > 255) {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function mouseDragged() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a MouseEvent object
// as a callback argument
function mouseDragged(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional MouseEvent callback argument.

"##]
///

pub static mouseDragged: MouseDraggedInternalType = MouseDraggedInternalType;
#[doc(hidden)]
pub struct MouseDraggedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseDragged")]
    fn mouseDragged2398434870(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for MouseDraggedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        mouseDragged2398434870.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for MouseDraggedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        mouseDragged2398434870.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for MouseDraggedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        mouseDragged2398434870.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseDragged")]
    fn mouseDragged851766547() ;
}

#[doc(hidden)]
impl FnOnce<()> for MouseDraggedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        mouseDragged851766547.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MouseDraggedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        mouseDragged851766547.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MouseDraggedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        mouseDragged851766547.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/mousePressed">mousePressed()</a> function is called once after every time a mouse button
is pressed. The mouseButton variable (see the related reference entry)
can be used to determine which button has been pressed. If no
<a href="#/p5/mousePressed">mousePressed()</a> function is defined, the <a href="#/p5/touchStarted">touchStarted()</a> function will be
called instead if it is defined.<br><br>
Browsers may have different default
behaviors attached to various mouse events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Click within the image to change
// the value of the rectangle

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function mousePressed() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function mousePressed() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a MouseEvent object
// as a callback argument
function mousePressed(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional MouseEvent callback argument.

"##]
///

pub static mousePressed: MousePressedInternalType = MousePressedInternalType;
#[doc(hidden)]
pub struct MousePressedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mousePressed")]
    fn mousePressed2975566909(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for MousePressedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        mousePressed2975566909.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for MousePressedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        mousePressed2975566909.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for MousePressedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        mousePressed2975566909.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mousePressed")]
    fn mousePressed1725263012() ;
}

#[doc(hidden)]
impl FnOnce<()> for MousePressedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        mousePressed1725263012.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MousePressedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        mousePressed1725263012.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MousePressedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        mousePressed1725263012.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/mouseReleased">mouseReleased()</a> function is called every time a mouse button is
released. If no <a href="#/p5/mouseReleased">mouseReleased()</a> function is defined, the <a href="#/p5/touchEnded">touchEnded()</a>
function will be called instead if it is defined.<br><br>
Browsers may have different default
behaviors attached to various mouse events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Click within the image to change
// the value of the rectangle
// after the mouse has been clicked

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function mouseReleased() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function mouseReleased() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a MouseEvent object
// as a callback argument
function mouseReleased(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional MouseEvent callback argument.

"##]
///

pub static mouseReleased: MouseReleasedInternalType = MouseReleasedInternalType;
#[doc(hidden)]
pub struct MouseReleasedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseReleased")]
    fn mouseReleased1391447297(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for MouseReleasedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        mouseReleased1391447297.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for MouseReleasedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        mouseReleased1391447297.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for MouseReleasedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        mouseReleased1391447297.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseReleased")]
    fn mouseReleased2020738629() ;
}

#[doc(hidden)]
impl FnOnce<()> for MouseReleasedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        mouseReleased2020738629.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MouseReleasedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        mouseReleased2020738629.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MouseReleasedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        mouseReleased2020738629.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/mouseClicked">mouseClicked()</a> function is called once after a mouse button has been
pressed and then released.<br><br>
Browsers handle clicks differently, so this function is only guaranteed to be
run when the left mouse button is clicked. To handle other mouse buttons
being pressed or released, see <a href="#/p5/mousePressed">mousePressed()</a> or <a href="#/p5/mouseReleased">mouseReleased()</a>.<br><br>
Browsers may have different default
behaviors attached to various mouse events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Click within the image to change
// the value of the rectangle
// after the mouse has been clicked

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}

function mouseClicked() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function mouseClicked() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a MouseEvent object
// as a callback argument
function mouseClicked(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional MouseEvent callback argument.

"##]
///

pub static mouseClicked: MouseClickedInternalType = MouseClickedInternalType;
#[doc(hidden)]
pub struct MouseClickedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseClicked")]
    fn mouseClicked1219075265(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for MouseClickedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        mouseClicked1219075265.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for MouseClickedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        mouseClicked1219075265.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for MouseClickedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        mouseClicked1219075265.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseClicked")]
    fn mouseClicked4009921882() ;
}

#[doc(hidden)]
impl FnOnce<()> for MouseClickedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        mouseClicked4009921882.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MouseClickedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        mouseClicked4009921882.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MouseClickedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        mouseClicked4009921882.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/doubleClicked">doubleClicked()</a> function is executed every time a event
listener has detected a dblclick event which is a part of the
DOM L3 specification. The doubleClicked event is fired when a
pointing device button (usually a mouse's primary button)
is clicked twice on a single element. For more info on the
dblclick event refer to mozilla's documentation here:
<a href="https://developer.mozilla.org/en-US/docs/Web/Events/dblclick">https://developer.mozilla.org/en-US/docs/Web/Events/dblclick</a></p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Click within the image to change
// the value of the rectangle
// after the mouse has been double clicked

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}

function doubleClicked() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function doubleClicked() {
  ellipse(mouseX, mouseY, 5, 5);
  // prevent default
  return false;
}
```"###]
#[doc=r###"```rust
// returns a MouseEvent object
// as a callback argument
function doubleClicked(event) {
  console.log(event);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional MouseEvent callback argument.

"##]
///

pub static doubleClicked: DoubleClickedInternalType = DoubleClickedInternalType;
#[doc(hidden)]
pub struct DoubleClickedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "doubleClicked")]
    fn doubleClicked3928396484(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for DoubleClickedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        doubleClicked3928396484.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for DoubleClickedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        doubleClicked3928396484.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for DoubleClickedInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        doubleClicked3928396484.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "doubleClicked")]
    fn doubleClicked3119985116() ;
}

#[doc(hidden)]
impl FnOnce<()> for DoubleClickedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        doubleClicked3119985116.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DoubleClickedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        doubleClicked3119985116.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DoubleClickedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        doubleClicked3119985116.call(args)
    }
}
#[doc=r##"<p>The function <a href="#/p5/mouseWheel">mouseWheel()</a> is executed every time a vertical mouse wheel
event is detected either triggered by an actual mouse wheel or by a
touchpad.<br><br>
The event.delta property returns the amount the mouse wheel
have scrolled. The values can be positive or negative depending on the
scroll direction (on OS X with "natural" scrolling enabled, the signs
are inverted).<br><br>
Browsers may have different default behaviors attached to various
mouse events. To prevent any default behavior for this event, add
"return false" to the end of the method.<br><br>
Due to the current support of the "wheel" event on Safari, the function
may only work as expected if "return false" is included while using Safari.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let pos = 25;

function draw() {
  background(237, 34, 93);
  fill(0);
  rect(25, pos, 50, 50);
}

function mouseWheel(event) {
  print(event.delta);
  //move the square according to the vertical scroll amount
  pos += event.delta;
  //uncomment to block page scrolling
  //return false;
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>event?</code> optional WheelEvent callback argument.

"##]
///

pub static mouseWheel: MouseWheelInternalType = MouseWheelInternalType;
#[doc(hidden)]
pub struct MouseWheelInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseWheel")]
    fn mouseWheel1795414948(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for MouseWheelInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        mouseWheel1795414948.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for MouseWheelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        mouseWheel1795414948.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for MouseWheelInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        mouseWheel1795414948.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "mouseWheel")]
    fn mouseWheel480703797() ;
}

#[doc(hidden)]
impl FnOnce<()> for MouseWheelInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        mouseWheel480703797.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for MouseWheelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        mouseWheel480703797.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for MouseWheelInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        mouseWheel480703797.call(args)
    }
}
#[doc=r##"<p>The function <a href="#/p5/requestPointerLock">requestPointerLock()</a>
locks the pointer to its current position and makes it invisible.
Use <a href="#/p5/movedX">movedX</a> and <a href="#/p5/movedY">movedY</a> to get the difference the mouse was moved since
the last call of draw.
Note that not all browsers support this feature.
This enables you to create experiences that aren't limited by the mouse moving out of the screen
even if it is repeatedly moved into one direction.
For example, a first person perspective experience.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let cam;
function setup() {
  createCanvas(100, 100, WEBGL);
  requestPointerLock();
  cam = createCamera();
}

function draw() {
  background(255);
  cam.pan(-movedX * 0.001);
  cam.tilt(movedY * 0.001);
  sphere(25);
}
```"###]

pub static requestPointerLock: RequestPointerLockInternalType = RequestPointerLockInternalType;
#[doc(hidden)]
pub struct RequestPointerLockInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "requestPointerLock")]
    fn requestPointerLock3697882030() ;
}

#[doc(hidden)]
impl FnOnce<()> for RequestPointerLockInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        requestPointerLock3697882030.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RequestPointerLockInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        requestPointerLock3697882030.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RequestPointerLockInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        requestPointerLock3697882030.call(args)
    }
}
#[doc=r##"<p>The function <a href="#/p5/exitPointerLock">exitPointerLock()</a>
exits a previously triggered <a href="#/p5/requestPointerLock">pointer Lock</a>
for example to make ui elements usable etc</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
//click the canvas to lock the pointer
//click again to exit (otherwise escape)
let locked = false;
function draw() {
  background(237, 34, 93);
}
function mouseClicked() {
  if (!locked) {
    locked = true;
    requestPointerLock();
  } else {
    exitPointerLock();
    locked = false;
  }
}
```"###]

pub static exitPointerLock: ExitPointerLockInternalType = ExitPointerLockInternalType;
#[doc(hidden)]
pub struct ExitPointerLockInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "exitPointerLock")]
    fn exitPointerLock2483421414() ;
}

#[doc(hidden)]
impl FnOnce<()> for ExitPointerLockInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        exitPointerLock2483421414.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ExitPointerLockInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        exitPointerLock2483421414.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ExitPointerLockInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        exitPointerLock2483421414.call(args)
    }
}
#[doc=r##"<p>Creates a new instance of p5.StringDict using the key-value pair
 or the object you provide.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 function setup() {
   let myDictionary = createStringDict('p5', 'js');
   print(myDictionary.hasKey('p5')); // logs true to console
  let anotherDictionary = createStringDict({ happy: 'coding' });
   print(anotherDictionary.hasKey('happy')); // logs true to console
 }
 ```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>key</code> 
"##]
///
///
#[doc = r##"<code>value</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>object</code> object

"##]
///
///
/// ---
///

pub static createStringDict: CreateStringDictInternalType = CreateStringDictInternalType;
#[doc(hidden)]
pub struct CreateStringDictInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createStringDict")]
    fn createStringDict3270337288(_ : & str, _ : & str, ) ->  StringDict;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateStringDictInternalType {
    type Output =  StringDict;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createStringDict3270337288.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateStringDictInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createStringDict3270337288.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateStringDictInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createStringDict3270337288.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createStringDict")]
    fn createStringDict3958153503(_ : JsValue, ) ->  StringDict;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for CreateStringDictInternalType {
    type Output =  StringDict;
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        createStringDict3958153503.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for CreateStringDictInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        createStringDict3958153503.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for CreateStringDictInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        createStringDict3958153503.call(args)
    }
}
#[doc=r##"<p>Creates a new instance of <a href="#/p5.NumberDict">p5.NumberDict</a> using the key-value pair
 or object you provide.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 function setup() {
   let myDictionary = createNumberDict(100, 42);
   print(myDictionary.hasKey(100)); // logs true to console
  let anotherDictionary = createNumberDict({ 200: 84 });
   print(anotherDictionary.hasKey(200)); // logs true to console
 }
 ```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>key</code> 
"##]
///
///
#[doc = r##"<code>value</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>object</code> object

"##]
///
///
/// ---
///

pub static createNumberDict: CreateNumberDictInternalType = CreateNumberDictInternalType;
#[doc(hidden)]
pub struct CreateNumberDictInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createNumberDict")]
    fn createNumberDict959845598(_ : f64, _ : f64, ) ->  NumberDict;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CreateNumberDictInternalType {
    type Output =  NumberDict;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        createNumberDict959845598.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CreateNumberDictInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        createNumberDict959845598.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CreateNumberDictInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        createNumberDict959845598.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createNumberDict")]
    fn createNumberDict4195567845(_ : JsValue, ) ->  NumberDict;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for CreateNumberDictInternalType {
    type Output =  NumberDict;
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        createNumberDict4195567845.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for CreateNumberDictInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        createNumberDict4195567845.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for CreateNumberDictInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        createNumberDict4195567845.call(args)
    }
}
#[doc=r##"<p>Copies a region of pixels from one image to another, using a specified
blend mode to do the operation.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img0;
let img1;

function preload() {
  img0 = loadImage('assets/rockies.jpg');
  img1 = loadImage('assets/bricks_third.jpg');
}

function setup() {
  background(img0);
  image(img1, 0, 0);
  blend(img1, 0, 0, 33, 100, 67, 0, 33, 100, LIGHTEST);
}
```"###]
#[doc=r###"```rust
let img0;
let img1;

function preload() {
  img0 = loadImage('assets/rockies.jpg');
  img1 = loadImage('assets/bricks_third.jpg');
}

function setup() {
  background(img0);
  image(img1, 0, 0);
  blend(img1, 0, 0, 33, 100, 67, 0, 33, 100, DARKEST);
}
```"###]
#[doc=r###"```rust
let img0;
let img1;

function preload() {
  img0 = loadImage('assets/rockies.jpg');
  img1 = loadImage('assets/bricks_third.jpg');
}

function setup() {
  background(img0);
  image(img1, 0, 0);
  blend(img1, 0, 0, 33, 100, 67, 0, 33, 100, ADD);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>srcImage</code> source image

"##]
///
///
#[doc = r##"<code>sx</code> X coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sy</code> Y coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sw</code> source image width

"##]
///
///
#[doc = r##"<code>sh</code> source image height

"##]
///
///
#[doc = r##"<code>dx</code> X coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dy</code> Y coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dw</code> destination image width

"##]
///
///
#[doc = r##"<code>dh</code> destination image height

"##]
///
///
#[doc = r##"<code>blendMode</code> the blend mode. either
    BLEND, DARKEST, LIGHTEST, DIFFERENCE,
    MULTIPLY, EXCLUSION, SCREEN, REPLACE, OVERLAY, HARD_LIGHT,
    SOFT_LIGHT, DODGE, BURN, ADD or NORMAL.

"##]
///
///
/// ---
///
///
#[doc = r##"<code>sx</code> X coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sy</code> Y coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sw</code> source image width

"##]
///
///
#[doc = r##"<code>sh</code> source image height

"##]
///
///
#[doc = r##"<code>dx</code> X coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dy</code> Y coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dw</code> destination image width

"##]
///
///
#[doc = r##"<code>dh</code> destination image height

"##]
///
///
#[doc = r##"<code>blendMode</code> the blend mode. either
    BLEND, DARKEST, LIGHTEST, DIFFERENCE,
    MULTIPLY, EXCLUSION, SCREEN, REPLACE, OVERLAY, HARD_LIGHT,
    SOFT_LIGHT, DODGE, BURN, ADD or NORMAL.

"##]
///
///
/// ---
///

pub static blend: BlendInternalType = BlendInternalType;
#[doc(hidden)]
pub struct BlendInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "blend")]
    fn blend2839558456(_ : & Image, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : BLEND_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,BLEND_MODE,)> for BlendInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,BLEND_MODE,)) -> Self::Output {
        blend2839558456.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,BLEND_MODE,)> for BlendInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,BLEND_MODE,)) -> Self::Output {
        blend2839558456.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,BLEND_MODE,)> for BlendInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,BLEND_MODE,)) -> Self::Output {
        blend2839558456.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "blend")]
    fn blend2866186324(_ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : Constant, ) ;
}

#[doc(hidden)]
impl FnOnce<(i32,i32,i32,i32,i32,i32,i32,i32,Constant,)> for BlendInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (i32,i32,i32,i32,i32,i32,i32,i32,Constant,)) -> Self::Output {
        blend2866186324.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(i32,i32,i32,i32,i32,i32,i32,i32,Constant,)> for BlendInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (i32,i32,i32,i32,i32,i32,i32,i32,Constant,)) -> Self::Output {
        blend2866186324.call(args)
    }
}

#[doc(hidden)]
impl Fn<(i32,i32,i32,i32,i32,i32,i32,i32,Constant,)> for BlendInternalType {
    extern "rust-call" fn call(&self, args: (i32,i32,i32,i32,i32,i32,i32,i32,Constant,)) -> Self::Output {
        blend2866186324.call(args)
    }
}
#[doc=r##"<p>Copies a region of the canvas to another region of the canvas
and copies a region of pixels from an image used as the srcImg parameter
into the canvas srcImage is specified this is used as the source. If
the source and destination regions aren't the same size, it will
automatically resize source pixels to fit the specified
target region.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;

function preload() {
  img = loadImage('assets/rockies.jpg');
}

function setup() {
  background(img);
  copy(img, 7, 22, 10, 10, 35, 25, 50, 50);
  stroke(255);
  noFill();
  // Rectangle shows area being copied
  rect(7, 22, 10, 10);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>srcImage</code> source image

"##]
///
///
#[doc = r##"<code>sx</code> X coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sy</code> Y coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sw</code> source image width

"##]
///
///
#[doc = r##"<code>sh</code> source image height

"##]
///
///
#[doc = r##"<code>dx</code> X coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dy</code> Y coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dw</code> destination image width

"##]
///
///
#[doc = r##"<code>dh</code> destination image height

"##]
///
///
/// ---
///
///
#[doc = r##"<code>sx</code> X coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sy</code> Y coordinate of the source's upper left corner

"##]
///
///
#[doc = r##"<code>sw</code> source image width

"##]
///
///
#[doc = r##"<code>sh</code> source image height

"##]
///
///
#[doc = r##"<code>dx</code> X coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dy</code> Y coordinate of the destination's upper left corner

"##]
///
///
#[doc = r##"<code>dw</code> destination image width

"##]
///
///
#[doc = r##"<code>dh</code> destination image height

"##]
///
///
/// ---
///

pub static copy: CopyInternalType = CopyInternalType;
#[doc(hidden)]
pub struct CopyInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "copy")]
    fn copy601113704(_ : & Image, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy601113704.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy601113704.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Image,i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy601113704.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "copy")]
    fn copy2219902100(_ : & Element, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy2219902100.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy2219902100.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy2219902100.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "copy")]
    fn copy783741524(_ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy783741524.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy783741524.call(args)
    }
}

#[doc(hidden)]
impl Fn<(i32,i32,i32,i32,i32,i32,i32,i32,)> for CopyInternalType {
    extern "rust-call" fn call(&self, args: (i32,i32,i32,i32,i32,i32,i32,i32,)) -> Self::Output {
        copy783741524.call(args)
    }
}
#[doc=r##"<p>Applies a filter to the canvas. The presets options are:</p>
<p>THRESHOLD
Converts the image to black and white pixels depending if they are above or
below the threshold defined by the level parameter. The parameter must be
between 0.0 (black) and 1.0 (white). If no level is specified, 0.5 is used.</p>
<p>GRAY
Converts any colors in the image to grayscale equivalents. No parameter
is used.</p>
<p>OPAQUE
Sets the alpha channel to entirely opaque. No parameter is used.</p>
<p>INVERT
Sets each pixel to its inverse value. No parameter is used.</p>
<p>POSTERIZE
Limits each channel of the image to the number of colors specified as the
parameter. The parameter can be set to values between 2 and 255, but
results are most noticeable in the lower ranges.</p>
<p>BLUR
Executes a Gaussian blur with the level parameter specifying the extent
of the blurring. If no parameter is used, the blur is equivalent to
Gaussian blur of radius 1. Larger values increase the blur.</p>
<p>ERODE
Reduces the light areas. No parameter is used.</p>
<p>DILATE
Increases the light areas. No parameter is used.</p>
<p>filter() does not work in WEBGL mode.
A similar effect can be achieved in WEBGL mode using custom
shaders. Adam Ferriss has written
a <a href="https://github.com/aferriss/p5jsShaderExamples"
target='_blank'>selection of shader examples</a> that contains many
of the effects present in the filter examples.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(THRESHOLD);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(GRAY);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(OPAQUE);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(INVERT);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(POSTERIZE, 3);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(DILATE);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(BLUR, 3);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/bricks.jpg');
}
function setup() {
  image(img, 0, 0);
  filter(ERODE);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>filterType</code> either THRESHOLD, GRAY, OPAQUE, INVERT,
                               POSTERIZE, BLUR, ERODE, DILATE or BLUR.
                               See Filters.js for docs on
                               each available filter

"##]
///
///
#[doc = r##"<code>filterParam?</code> an optional parameter unique
                               to each filter, see above

"##]
///

pub static filter: FilterInternalType = FilterInternalType;
#[doc(hidden)]
pub struct FilterInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "filter")]
    fn filter2903367131(_ : FILTER_TYPE, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(FILTER_TYPE,f64,)> for FilterInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (FILTER_TYPE,f64,)) -> Self::Output {
        filter2903367131.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(FILTER_TYPE,f64,)> for FilterInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (FILTER_TYPE,f64,)) -> Self::Output {
        filter2903367131.call(args)
    }
}

#[doc(hidden)]
impl Fn<(FILTER_TYPE,f64,)> for FilterInternalType {
    extern "rust-call" fn call(&self, args: (FILTER_TYPE,f64,)) -> Self::Output {
        filter2903367131.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "filter")]
    fn filter425466419(_ : FILTER_TYPE, ) ;
}

#[doc(hidden)]
impl FnOnce<(FILTER_TYPE,)> for FilterInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (FILTER_TYPE,)) -> Self::Output {
        filter425466419.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(FILTER_TYPE,)> for FilterInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (FILTER_TYPE,)) -> Self::Output {
        filter425466419.call(args)
    }
}

#[doc(hidden)]
impl Fn<(FILTER_TYPE,)> for FilterInternalType {
    extern "rust-call" fn call(&self, args: (FILTER_TYPE,)) -> Self::Output {
        filter425466419.call(args)
    }
}
#[doc=r##"<p>Get a region of pixels, or a single pixel, from the canvas.</p>
<p>Returns an array of [R,G,B,A] values for any pixel or grabs a section of
an image. If no parameters are specified, the entire image is returned.
Use the x and y parameters to get the value of one pixel. Get a section of
the display window by specifying additional w and h parameters. When
getting an image, the x and y parameters define the coordinates for the
upper-left corner of the image, regardless of the current <a href="#/p5/imageMode">imageMode()</a>.</p>
<p>Getting the color of a single pixel with get(x, y) is easy, but not as fast
as grabbing the data directly from <a href="#/p5/pixels">pixels[]</a>. The equivalent statement to
get(x, y) using <a href="#/p5/pixels">pixels[]</a> with pixel density d is</p>
<pre><code class="language-javascript">let x, y, d; // set these to the coordinates
let off = (y * width + x) * d * 4;
let components = [
  pixels[off],
  pixels[off + 1],
  pixels[off + 2],
  pixels[off + 3]
];
print(components);</code></pre>
<p>See the reference for <a href="#/p5/pixels">pixels[]</a> for more information.</p>
<p>If you want to extract an array of colors or a subimage from an p5.Image object,
take a look at <a href="#/p5.Image/get">p5.Image.get()</a></p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/rockies.jpg');
}
function setup() {
  image(img, 0, 0);
  let c = get();
  image(c, width / 2, 0);
}
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/rockies.jpg');
}
function setup() {
  image(img, 0, 0);
  let c = get(50, 90);
  fill(c);
  noStroke();
  rect(25, 25, 50, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x</code> x-coordinate of the pixel

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the pixel

"##]
///
///
#[doc = r##"<code>w</code> width

"##]
///
///
#[doc = r##"<code>h</code> height

"##]
///
///
/// ---
///
///
/// ---
///
///
#[doc = r##"<code>x</code> x-coordinate of the pixel

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the pixel

"##]
///
///
/// ---
///

pub static get: GetInternalType = GetInternalType;
#[doc(hidden)]
pub struct GetInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "get")]
    fn get4166229418(_ : f64, _ : f64, _ : f64, _ : f64, ) ->  Image;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for GetInternalType {
    type Output =  Image;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        get4166229418.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for GetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        get4166229418.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for GetInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        get4166229418.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "get")]
    fn get3857964034() ->  Image;
}

#[doc(hidden)]
impl FnOnce<()> for GetInternalType {
    type Output =  Image;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        get3857964034.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for GetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        get3857964034.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for GetInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        get3857964034.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "get")]
    fn get1071965337(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for GetInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        get1071965337.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for GetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        get1071965337.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for GetInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        get1071965337.call(args)
    }
}
#[doc=r##"<p>Loads the pixel data for the display window into the <a href="#/p5/pixels">pixels[]</a> array. This
function must always be called before reading from or writing to <a href="#/p5/pixels">pixels[]</a>.
Note that only changes made with <a href="#/p5/set">set()</a> or direct manipulation of <a href="#/p5/pixels">pixels[]</a>
will occur.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/rockies.jpg');
}

function setup() {
  image(img, 0, 0, width, height);
  let d = pixelDensity();
  let halfImage = 4 * (width * d) * (height * d / 2);
  loadPixels();
  for (let i = 0; i < halfImage; i++) {
    pixels[i + halfImage] = pixels[i];
  }
  updatePixels();
}
```"###]

pub static loadPixels: LoadPixelsInternalType = LoadPixelsInternalType;
#[doc(hidden)]
pub struct LoadPixelsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadPixels")]
    fn loadPixels3068735308() ;
}

#[doc(hidden)]
impl FnOnce<()> for LoadPixelsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        loadPixels3068735308.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for LoadPixelsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        loadPixels3068735308.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for LoadPixelsInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        loadPixels3068735308.call(args)
    }
}
#[doc=r##"<p>Changes the color of any pixel, or writes an image directly to the
display window.
The x and y parameters specify the pixel to change and the c parameter
specifies the color value. This can be a <a href="#/p5.Color">p5.Color</a> object, or [R, G, B, A]
pixel array. It can also be a single grayscale value.
When setting an image, the x and y parameters define the coordinates for
the upper-left corner of the image, regardless of the current <a href="#/p5/imageMode">imageMode()</a>.</p>
<p>After using <a href="#/p5/set">set()</a>, you must call <a href="#/p5/updatePixels">updatePixels()</a> for your changes to appear.
This should be called once all pixels have been set, and must be called before
calling .<a href="#/p5/get">get()</a> or drawing the image.</p>
<p>Setting the color of a single pixel with set(x, y) is easy, but not as
fast as putting the data directly into <a href="#/p5/pixels">pixels[]</a>. Setting the <a href="#/p5/pixels">pixels[]</a>
values directly may be complicated when working with a retina display,
but will perform better when lots of pixels need to be set directly on
every loop. See the reference for <a href="#/p5/pixels">pixels[]</a> for more information.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let black = color(0);
set(30, 20, black);
set(85, 20, black);
set(85, 75, black);
set(30, 75, black);
updatePixels();
```"###]
#[doc=r###"```rust
for (let i = 30; i < width - 15; i++) {
  for (let j = 20; j < height - 25; j++) {
    let c = color(204 - j, 153 - i, 0);
    set(i, j, c);
  }
}
updatePixels();
```"###]
#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/rockies.jpg');
}

function setup() {
  set(0, 0, img);
  updatePixels();
  line(0, 0, width, height);
  line(0, height, width, 0);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>x</code> x-coordinate of the pixel

"##]
///
///
#[doc = r##"<code>y</code> y-coordinate of the pixel

"##]
///
///
#[doc = r##"<code>c</code> insert a grayscale value | a pixel array |
                               a p5.Color object | a p5.Image to copy

"##]
///

pub static set: SetInternalType = SetInternalType;
#[doc(hidden)]
pub struct SetInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "set")]
    fn set1430776427(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for SetInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        set1430776427.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for SetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        set1430776427.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for SetInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        set1430776427.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "set")]
    fn set448010371(_ : f64, _ : f64, _ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,&'_ [f64],)> for SetInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,&'_ [f64],)) -> Self::Output {
        set448010371.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,&'_ [f64],)> for SetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,&'_ [f64],)) -> Self::Output {
        set448010371.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,&'_ [f64],)> for SetInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,&'_ [f64],)) -> Self::Output {
        set448010371.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "set")]
    fn set891369379(_ : f64, _ : f64, _ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,JsValue,)> for SetInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,JsValue,)) -> Self::Output {
        set891369379.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,JsValue,)> for SetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,JsValue,)) -> Self::Output {
        set891369379.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,JsValue,)> for SetInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,JsValue,)) -> Self::Output {
        set891369379.call(args)
    }
}
#[doc=r##"<p>Updates the display window with the data in the <a href="#/p5/pixels">pixels[]</a> array.
Use in conjunction with <a href="#/p5/loadPixels">loadPixels()</a>. If you're only reading pixels from
the array, there's no need to call <a href="#/p5/updatePixels">updatePixels()</a> — updating is only
necessary to apply changes. <a href="#/p5/updatePixels">updatePixels()</a> should be called anytime the
pixels array is manipulated or <a href="#/p5/set">set()</a> is called, and only changes made with
<a href="#/p5/set">set()</a> or direct changes to <a href="#/p5/pixels">pixels[]</a> will occur.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img;
function preload() {
  img = loadImage('assets/rockies.jpg');
}

function setup() {
  image(img, 0, 0, width, height);
  let d = pixelDensity();
  let halfImage = 4 * (width * d) * (height * d / 2);
  loadPixels();
  for (let i = 0; i < halfImage; i++) {
    pixels[i + halfImage] = pixels[i];
  }
  updatePixels();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>x?</code> x-coordinate of the upper-left corner of region
                        to update

"##]
///
///
#[doc = r##"<code>y?</code> y-coordinate of the upper-left corner of region
                        to update

"##]
///
///
#[doc = r##"<code>w?</code> width of region to update

"##]
///
///
#[doc = r##"<code>h?</code> height of region to update

"##]
///

pub static updatePixels: UpdatePixelsInternalType = UpdatePixelsInternalType;
#[doc(hidden)]
pub struct UpdatePixelsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "updatePixels")]
    fn updatePixels2723485461(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for UpdatePixelsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        updatePixels2723485461.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        updatePixels2723485461.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        updatePixels2723485461.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "updatePixels")]
    fn updatePixels3913062415(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for UpdatePixelsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        updatePixels3913062415.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        updatePixels3913062415.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        updatePixels3913062415.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "updatePixels")]
    fn updatePixels4110431285(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for UpdatePixelsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        updatePixels4110431285.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        updatePixels4110431285.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        updatePixels4110431285.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "updatePixels")]
    fn updatePixels1328394842(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for UpdatePixelsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        updatePixels1328394842.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        updatePixels1328394842.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for UpdatePixelsInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        updatePixels1328394842.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "updatePixels")]
    fn updatePixels1259933552() ;
}

#[doc(hidden)]
impl FnOnce<()> for UpdatePixelsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        updatePixels1259933552.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for UpdatePixelsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        updatePixels1259933552.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for UpdatePixelsInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        updatePixels1259933552.call(args)
    }
}
#[doc=r##"<p>Combines an array of Strings into one String, each separated by the
character(s) used for the separator parameter. To join arrays of ints or
floats, it's necessary to first convert them to Strings using <a href="#/p5/nf">nf()</a> or
nfs().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let array = ['Hello', 'world!'];
let separator = ' ';
let message = join(array, separator);
text(message, 5, 50);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> array of Strings to be joined

"##]
///
///
#[doc = r##"<code>separator</code> String to be placed between each item

"##]
///

pub static join: JoinInternalType = JoinInternalType;
#[doc(hidden)]
pub struct JoinInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "join")]
    fn join4171417911(_ : js_sys::Array, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,)> for JoinInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        join4171417911.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,)> for JoinInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        join4171417911.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,)> for JoinInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        join4171417911.call(args)
    }
}
#[doc=r##"<p>This function is used to apply a regular expression to a piece of text,
and return matching groups (elements found inside parentheses) as a
String array. If there are no matches, a null value will be returned.
If no groups are specified in the regular expression, but the sequence
matches, an array of length 1 (with the matched text as the first element
of the array) will be returned.</p>
<p>To use the function, first check to see if the result is null. If the
result is null, then the sequence did not match at all. If the sequence
did match, an array is returned.</p>
<p>If there are groups (specified by sets of parentheses) in the regular
expression, then the contents of each will be returned in the array.
Element [0] of a regular expression match returns the entire matching
string, and the match groups start at element [1] (the first group is [1],
the second [2], and so on).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let string = 'Hello p5js*!';
let regexp = 'p5js\\*';
let m = match(string, regexp);
text(m, 5, 50);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>str</code> the String to be searched

"##]
///
///
#[doc = r##"<code>regexp</code> the regexp to be used for matching

"##]
///

pub static r#match: RMatchInternalType = RMatchInternalType;
#[doc(hidden)]
pub struct RMatchInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#match")]
    fn r#match3560130753(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for RMatchInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        r#match3560130753.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for RMatchInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        r#match3560130753.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for RMatchInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        r#match3560130753.call(args)
    }
}
#[doc=r##"<p>This function is used to apply a regular expression to a piece of text,
and return a list of matching groups (elements found inside parentheses)
as a two-dimensional String array. If there are no matches, a null value
will be returned. If no groups are specified in the regular expression,
but the sequence matches, a two dimensional array is still returned, but
the second dimension is only of length one.</p>
<p>To use the function, first check to see if the result is null. If the
result is null, then the sequence did not match at all. If the sequence
did match, a 2D array is returned.</p>
<p>If there are groups (specified by sets of parentheses) in the regular
expression, then the contents of each will be returned in the array.
Assuming a loop with counter variable i, element [i][0] of a regular
expression match returns the entire matching string, and the match groups
start at element [i][1] (the first group is [i][1], the second [i][2],
and so on).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let string = 'Hello p5js*! Hello world!';
let regexp = 'Hello';
matchAll(string, regexp);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>str</code> the String to be searched

"##]
///
///
#[doc = r##"<code>regexp</code> the regexp to be used for matching

"##]
///

pub static matchAll: MatchAllInternalType = MatchAllInternalType;
#[doc(hidden)]
pub struct MatchAllInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "matchAll")]
    fn matchAll2969875630(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for MatchAllInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        matchAll2969875630.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for MatchAllInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        matchAll2969875630.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for MatchAllInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        matchAll2969875630.call(args)
    }
}
#[doc=r##"<p>Utility function for formatting numbers into strings. There are two
versions: one for formatting floats, and one for formatting ints.
The values for the digits, left, and right parameters should always
be positive integers.
(NOTE): Be cautious when using left and right parameters as it prepends numbers of 0's if the parameter
if greater than the current length of the number.
For example if number is 123.2 and left parameter passed is 4 which is greater than length of 123
(integer part) i.e 3 than result will be 0123.2. Same case for right parameter i.e. if right is 3 than
the result will be 123.200.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let myFont;
function preload() {
  myFont = loadFont('assets/fonts/inconsolata.ttf');
}
function setup() {
  background(200);
  let num1 = 321;
  let num2 = -1321;

  noStroke();
  fill(0);
  textFont(myFont);
  textSize(22);

  text(nf(num1, 4, 2), 10, 30);
  text(nf(num2, 4, 2), 10, 80);
  // Draw dividing line
  stroke(120);
  line(0, 50, width, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>num</code> the Number to format

"##]
///
///
#[doc = r##"<code>left?</code> number of digits to the left of the
                               decimal point

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                               decimal point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>nums</code> the Numbers to format

"##]
///
///
#[doc = r##"<code>left?</code> number of digits to the left of the
                               decimal point

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                               decimal point

"##]
///
///
/// ---
///

pub static nf: NfInternalType = NfInternalType;
#[doc(hidden)]
pub struct NfInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf2430351649(_ : f64, _ : i32, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,i32,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,i32,)) -> Self::Output {
        nf2430351649.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,i32,)) -> Self::Output {
        nf2430351649.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,i32,)) -> Self::Output {
        nf2430351649.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf188240331(_ : f64, _ : i32, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,&'_ str,)) -> Self::Output {
        nf188240331.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,&'_ str,)) -> Self::Output {
        nf188240331.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,&'_ str,)) -> Self::Output {
        nf188240331.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf2271951143(_ : f64, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,)) -> Self::Output {
        nf2271951143.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,)) -> Self::Output {
        nf2271951143.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,)) -> Self::Output {
        nf2271951143.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf1860460859(_ : f64, _ : & str, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,&'_ str,i32,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,&'_ str,i32,)) -> Self::Output {
        nf1860460859.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,&'_ str,i32,)) -> Self::Output {
        nf1860460859.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,&'_ str,i32,)) -> Self::Output {
        nf1860460859.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3515540172(_ : f64, _ : & str, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,&'_ str,&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,&'_ str,&'_ str,)) -> Self::Output {
        nf3515540172.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,&'_ str,&'_ str,)) -> Self::Output {
        nf3515540172.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,&'_ str,&'_ str,)) -> Self::Output {
        nf3515540172.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3725962799(_ : f64, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,&'_ str,)) -> Self::Output {
        nf3725962799.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,&'_ str,)) -> Self::Output {
        nf3725962799.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,&'_ str,)) -> Self::Output {
        nf3725962799.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf2362082915(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        nf2362082915.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        nf2362082915.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        nf2362082915.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf4037302814(_ : & str, _ : i32, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,i32,i32,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,i32,i32,)) -> Self::Output {
        nf4037302814.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,i32,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,i32,i32,)) -> Self::Output {
        nf4037302814.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,i32,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,i32,i32,)) -> Self::Output {
        nf4037302814.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf1508410174(_ : & str, _ : i32, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,i32,&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,i32,&'_ str,)) -> Self::Output {
        nf1508410174.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,i32,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,i32,&'_ str,)) -> Self::Output {
        nf1508410174.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,i32,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,i32,&'_ str,)) -> Self::Output {
        nf1508410174.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf397064524(_ : & str, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,i32,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,i32,)) -> Self::Output {
        nf397064524.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,i32,)) -> Self::Output {
        nf397064524.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,i32,)) -> Self::Output {
        nf397064524.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3335112119(_ : & str, _ : & str, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,i32,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,i32,)) -> Self::Output {
        nf3335112119.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,i32,)) -> Self::Output {
        nf3335112119.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,i32,)) -> Self::Output {
        nf3335112119.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3461014560(_ : & str, _ : & str, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        nf3461014560.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        nf3461014560.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        nf3461014560.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3221756482(_ : & str, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        nf3221756482.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        nf3221756482.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        nf3221756482.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3394344498(_ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for NfInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        nf3394344498.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        nf3394344498.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        nf3394344498.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf712852831(_ : js_sys::Array, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,i32,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        nf712852831.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        nf712852831.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        nf712852831.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3060337981(_ : js_sys::Array, _ : i32, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,&'_ str,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,&'_ str,)) -> Self::Output {
        nf3060337981.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,&'_ str,)) -> Self::Output {
        nf3060337981.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,&'_ str,)) -> Self::Output {
        nf3060337981.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf1996452429(_ : js_sys::Array, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,)) -> Self::Output {
        nf1996452429.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,)) -> Self::Output {
        nf1996452429.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,)) -> Self::Output {
        nf1996452429.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf3723669229(_ : js_sys::Array, _ : & str, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,i32,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,i32,)) -> Self::Output {
        nf3723669229.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,i32,)) -> Self::Output {
        nf3723669229.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,i32,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,i32,)) -> Self::Output {
        nf3723669229.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf4265470417(_ : js_sys::Array, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,&'_ str,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,&'_ str,)) -> Self::Output {
        nf4265470417.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,&'_ str,)) -> Self::Output {
        nf4265470417.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,&'_ str,)) -> Self::Output {
        nf4265470417.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf2245562924(_ : js_sys::Array, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        nf2245562924.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        nf2245562924.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        nf2245562924.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nf")]
    fn nf1089988393(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for NfInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        nf1089988393.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for NfInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        nf1089988393.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for NfInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        nf1089988393.call(args)
    }
}
#[doc=r##"<p>Utility function for formatting numbers into strings and placing
appropriate commas to mark units of 1000. There are two versions: one
for formatting ints, and one for formatting an array of ints. The value
for the right parameter should always be a positive integer.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  background(200);
  let num = 11253106.115;
  let numArr = [1, 1, 2];

  noStroke();
  fill(0);
  textSize(12);

  // Draw formatted numbers
  text(nfc(num, 4), 10, 30);
  text(nfc(numArr, 2), 10, 80);

  // Draw dividing line
  stroke(120);
  line(0, 50, width, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>num</code> the Number to format

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                                 decimal point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>nums</code> the Numbers to format

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                                 decimal point

"##]
///
///
/// ---
///

pub static nfc: NfcInternalType = NfcInternalType;
#[doc(hidden)]
pub struct NfcInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc716502095(_ : f64, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,)> for NfcInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,)) -> Self::Output {
        nfc716502095.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,)) -> Self::Output {
        nfc716502095.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,)) -> Self::Output {
        nfc716502095.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc1673587678(_ : f64, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,&'_ str,)> for NfcInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,&'_ str,)) -> Self::Output {
        nfc1673587678.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,&'_ str,)) -> Self::Output {
        nfc1673587678.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (f64,&'_ str,)) -> Self::Output {
        nfc1673587678.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc2579927856(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for NfcInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        nfc2579927856.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        nfc2579927856.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        nfc2579927856.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc3010841235(_ : & str, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,i32,)> for NfcInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,i32,)) -> Self::Output {
        nfc3010841235.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,i32,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,i32,)) -> Self::Output {
        nfc3010841235.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,i32,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,i32,)) -> Self::Output {
        nfc3010841235.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc1883538040(_ : & str, _ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for NfcInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        nfc1883538040.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        nfc1883538040.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        nfc1883538040.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc830813834(_ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for NfcInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        nfc830813834.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        nfc830813834.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        nfc830813834.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc2753296327(_ : js_sys::Array, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,)> for NfcInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,)) -> Self::Output {
        nfc2753296327.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,)) -> Self::Output {
        nfc2753296327.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,)) -> Self::Output {
        nfc2753296327.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc1943624632(_ : js_sys::Array, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,)> for NfcInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        nfc1943624632.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        nfc1943624632.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        nfc1943624632.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfc")]
    fn nfc520645911(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for NfcInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        nfc520645911.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for NfcInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        nfc520645911.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for NfcInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        nfc520645911.call(args)
    }
}
#[doc=r##"<p>Utility function for formatting numbers into strings. Similar to <a href="#/p5/nf">nf()</a> but
puts a "+" in front of positive numbers and a "-" in front of negative
numbers. There are two versions: one for formatting floats, and one for
formatting ints. The values for left, and right parameters
should always be positive integers.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  background(200);
  let num1 = 11253106.115;
  let num2 = -11253106.115;

  noStroke();
  fill(0);
  textSize(12);

  // Draw formatted numbers
  text(nfp(num1, 4, 2), 10, 30);
  text(nfp(num2, 4, 2), 10, 80);

  // Draw dividing line
  stroke(120);
  line(0, 50, width, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>num</code> the Number to format

"##]
///
///
#[doc = r##"<code>left?</code> number of digits to the left of the decimal
                               point

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                               decimal point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>nums</code> the Numbers to format

"##]
///
///
#[doc = r##"<code>left?</code> number of digits to the left of the decimal
                               point

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                               decimal point

"##]
///
///
/// ---
///

pub static nfp: NfpInternalType = NfpInternalType;
#[doc(hidden)]
pub struct NfpInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfp")]
    fn nfp1583436572(_ : f64, _ : i32, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,i32,)> for NfpInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,i32,)) -> Self::Output {
        nfp1583436572.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,i32,)> for NfpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,i32,)) -> Self::Output {
        nfp1583436572.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,i32,)> for NfpInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,i32,)) -> Self::Output {
        nfp1583436572.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfp")]
    fn nfp524023511(_ : f64, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,)> for NfpInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,)) -> Self::Output {
        nfp524023511.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,)> for NfpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,)) -> Self::Output {
        nfp524023511.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,)> for NfpInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,)) -> Self::Output {
        nfp524023511.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfp")]
    fn nfp3487710781(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for NfpInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        nfp3487710781.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for NfpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        nfp3487710781.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for NfpInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        nfp3487710781.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfp")]
    fn nfp3725056356(_ : & [f64], _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],i32,i32,)> for NfpInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],i32,i32,)) -> Self::Output {
        nfp3725056356.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],i32,i32,)> for NfpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],i32,i32,)) -> Self::Output {
        nfp3725056356.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],i32,i32,)> for NfpInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],i32,i32,)) -> Self::Output {
        nfp3725056356.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfp")]
    fn nfp3720362272(_ : & [f64], _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],i32,)> for NfpInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],i32,)) -> Self::Output {
        nfp3720362272.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],i32,)> for NfpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],i32,)) -> Self::Output {
        nfp3720362272.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],i32,)> for NfpInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],i32,)) -> Self::Output {
        nfp3720362272.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfp")]
    fn nfp444492660(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for NfpInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        nfp444492660.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for NfpInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        nfp444492660.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for NfpInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        nfp444492660.call(args)
    }
}
#[doc=r##"<p>Utility function for formatting numbers into strings. Similar to <a href="#/p5/nf">nf()</a> but
puts an additional "_" (space) in front of positive numbers just in case to align it with negative
numbers which includes "-" (minus) sign.
The main usecase of nfs() can be seen when one wants to align the digits (place values) of a non-negative
number with some negative number (See the example to get a clear picture).
There are two versions: one for formatting float, and one for formatting int.
The values for the digits, left, and right parameters should always be positive integers.
(IMP): The result on the canvas basically the expected alignment can vary based on the typeface you are using.
(NOTE): Be cautious when using left and right parameters as it prepends numbers of 0's if the parameter
if greater than the current length of the number.
For example if number is 123.2 and left parameter passed is 4 which is greater than length of 123
(integer part) i.e 3 than result will be 0123.2. Same case for right parameter i.e. if right is 3 than
the result will be 123.200.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let myFont;
function preload() {
  myFont = loadFont('assets/fonts/inconsolata.ttf');
}
function setup() {
  background(200);
  let num1 = 321;
  let num2 = -1321;

  noStroke();
  fill(0);
  textFont(myFont);
  textSize(22);

  // nfs() aligns num1 (positive number) with num2 (negative number) by
  // adding a blank space in front of the num1 (positive number)
  // [left = 4] in num1 add one 0 in front, to align the digits with num2
  // [right = 2] in num1 and num2 adds two 0's after both numbers
  // To see the differences check the example of nf() too.
  text(nfs(num1, 4, 2), 10, 30);
  text(nfs(num2, 4, 2), 10, 80);
  // Draw dividing line
  stroke(120);
  line(0, 50, width, 50);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>num</code> the Number to format

"##]
///
///
#[doc = r##"<code>left?</code> number of digits to the left of the decimal
                               point

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                               decimal point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>nums</code> the Numbers to format

"##]
///
///
#[doc = r##"<code>left?</code> number of digits to the left of the decimal
                               point

"##]
///
///
#[doc = r##"<code>right?</code> number of digits to the right of the
                               decimal point

"##]
///
///
/// ---
///

pub static nfs: NfsInternalType = NfsInternalType;
#[doc(hidden)]
pub struct NfsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfs")]
    fn nfs2081774705(_ : f64, _ : i32, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,i32,)> for NfsInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,i32,)) -> Self::Output {
        nfs2081774705.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,i32,)> for NfsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,i32,)) -> Self::Output {
        nfs2081774705.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,i32,)> for NfsInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,i32,)) -> Self::Output {
        nfs2081774705.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfs")]
    fn nfs3918230971(_ : f64, _ : i32, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,)> for NfsInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,i32,)) -> Self::Output {
        nfs3918230971.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,)> for NfsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,)) -> Self::Output {
        nfs3918230971.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,)> for NfsInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,)) -> Self::Output {
        nfs3918230971.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfs")]
    fn nfs982935868(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for NfsInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        nfs982935868.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for NfsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        nfs982935868.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for NfsInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        nfs982935868.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfs")]
    fn nfs4257406057(_ : js_sys::Array, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,i32,)> for NfsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        nfs4257406057.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,i32,)> for NfsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        nfs4257406057.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,i32,)> for NfsInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        nfs4257406057.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfs")]
    fn nfs2788245080(_ : js_sys::Array, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,)> for NfsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,)) -> Self::Output {
        nfs2788245080.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,)> for NfsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,)) -> Self::Output {
        nfs2788245080.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,)> for NfsInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,)) -> Self::Output {
        nfs2788245080.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "nfs")]
    fn nfs737673710(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for NfsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        nfs737673710.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for NfsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        nfs737673710.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for NfsInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        nfs737673710.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/split">split()</a> function maps to String.split(), it breaks a String into
pieces using a character or string as the delimiter. The delim parameter
specifies the character or characters that mark the boundaries between
each piece. A String[] array is returned that contains each of the pieces.</p>
<p>The <a href="#/p5/splitTokens">splitTokens()</a> function works in a similar fashion, except that it
splits using a range of characters instead of a specific character or
sequence.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let names = 'Pat,Xio,Alex';
let splitString = split(names, ',');
text(splitString[0], 5, 30);
text(splitString[1], 5, 50);
text(splitString[2], 5, 70);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> the String to be split

"##]
///
///
#[doc = r##"<code>delim</code> the String used to separate the data

"##]
///

pub static split: SplitInternalType = SplitInternalType;
#[doc(hidden)]
pub struct SplitInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "split")]
    fn split1601592130(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for SplitInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        split1601592130.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for SplitInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        split1601592130.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for SplitInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        split1601592130.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/splitTokens">splitTokens()</a> function splits a String at one or many character
delimiters or "tokens." The delim parameter specifies the character or
characters to be used as a boundary.</p>
<p>If no delim characters are specified, any whitespace character is used to
split. Whitespace characters include tab (\t), line feed (\n), carriage
return (\r), form feed (\f), and space.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let myStr = 'Mango, Banana, Lime';
  let myStrArr = splitTokens(myStr, ',');

  print(myStrArr); // prints : ["Mango"," Banana"," Lime"]
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> the String to be split

"##]
///
///
#[doc = r##"<code>delim?</code> list of individual Strings that will be used as
                         separators

"##]
///

pub static splitTokens: SplitTokensInternalType = SplitTokensInternalType;
#[doc(hidden)]
pub struct SplitTokensInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "splitTokens")]
    fn splitTokens3487344536(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for SplitTokensInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        splitTokens3487344536.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for SplitTokensInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        splitTokens3487344536.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for SplitTokensInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        splitTokens3487344536.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "splitTokens")]
    fn splitTokens2440679195(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SplitTokensInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        splitTokens2440679195.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SplitTokensInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        splitTokens2440679195.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SplitTokensInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        splitTokens2440679195.call(args)
    }
}
#[doc=r##"<p>Removes whitespace characters from the beginning and end of a String. In
addition to standard whitespace characters such as space, carriage return,
and tab, this function also removes the Unicode "nbsp" character.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let string = trim('  No new lines\n   ');
text(string + ' here', 2, 50);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>str</code> a String to be trimmed

"##]
///
///
/// ---
///
///
#[doc = r##"<code>strs</code> an Array of Strings to be trimmed

"##]
///
///
/// ---
///

pub static trim: TrimInternalType = TrimInternalType;
#[doc(hidden)]
pub struct TrimInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "trim")]
    fn trim4124924324(_ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for TrimInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        trim4124924324.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for TrimInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        trim4124924324.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for TrimInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        trim4124924324.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "trim")]
    fn trim912580576(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for TrimInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        trim912580576.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for TrimInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        trim912580576.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for TrimInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        trim912580576.call(args)
    }
}
#[doc=r##"<p>The inverse of <a href="#/p5/cos">cos()</a>, returns the arc cosine of a value.
This function expects the values in the range of -1 to 1 and values are returned in
the range 0 to PI (3.1415927) if the angleMode is RADIANS or 0 to 180 if the
angle mode is DEGREES.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let a = PI;
let c = cos(a);
let ac = acos(c);
// Prints: "3.1415927 : -1.0 : 3.1415927"
print(a + ' : ' + c + ' : ' + ac);
```"###]
#[doc=r###"```rust
let a = PI + PI / 4.0;
let c = cos(a);
let ac = acos(c);
// Prints: "3.926991 : -0.70710665 : 2.3561943"
print(a + ' : ' + c + ' : ' + ac);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> the value whose arc cosine is to be returned

"##]
///

pub static acos: AcosInternalType = AcosInternalType;
#[doc(hidden)]
pub struct AcosInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "acos")]
    fn acos1188825790(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for AcosInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        acos1188825790.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for AcosInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        acos1188825790.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for AcosInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        acos1188825790.call(args)
    }
}
#[doc=r##"<p>The inverse of <a href="#/p5/sin">sin()</a>, returns the arc sine of a value.
This function expects the values in the range of -1 to 1 and values are returned
in the range -PI/2 to PI/2 if the angleMode is RADIANS or -90 to 90 if the angle
mode is DEGREES.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let a = PI / 3.0;
let s = sin(a);
let as = asin(s);
// Prints: "1.0471975 : 0.86602540 : 1.0471975"
print(a + ' : ' + s + ' : ' + as);
```"###]
#[doc=r###"```rust
let a = PI + PI / 3.0;
let s = sin(a);
let as = asin(s);
// Prints: "4.1887902 : -0.86602540 : -1.0471975"
print(a + ' : ' + s + ' : ' + as);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> the value whose arc sine is to be returned

"##]
///

pub static asin: AsinInternalType = AsinInternalType;
#[doc(hidden)]
pub struct AsinInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "asin")]
    fn asin2813492774(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for AsinInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        asin2813492774.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for AsinInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        asin2813492774.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for AsinInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        asin2813492774.call(args)
    }
}
#[doc=r##"<p>The inverse of <a href="#/p5/tan">tan()</a>, returns the arc tangent of a value.
This function expects the values in the range of -Infinity to Infinity (exclusive) and
values are returned in the range -PI/2 to PI/2 if the angleMode is RADIANS or
-90 to 90 if the angle mode is DEGREES.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let a = PI / 3.0;
let t = tan(a);
let at = atan(t);
// Prints: "1.0471975 : 1.7320508 : 1.0471975"
print(a + ' : ' + t + ' : ' + at);
```"###]
#[doc=r###"```rust
let a = PI + PI / 3.0;
let t = tan(a);
let at = atan(t);
// Prints: "4.1887902 : 1.7320508 : 1.0471975"
print(a + ' : ' + t + ' : ' + at);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> the value whose arc tangent is to be returned

"##]
///

pub static atan: AtanInternalType = AtanInternalType;
#[doc(hidden)]
pub struct AtanInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "atan")]
    fn atan3812741378(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for AtanInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        atan3812741378.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for AtanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        atan3812741378.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for AtanInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        atan3812741378.call(args)
    }
}
#[doc=r##"<p>Calculates the angle (in radians) from a specified point to the coordinate
origin as measured from the positive x-axis. Values are returned as a
float in the range from PI to -PI if the angleMode is RADIANS or 180 to
-180 if the angleMode is DEGREES. The atan2<a href="#/p5/">()</a> function is
most often used for orienting geometry to the position of the cursor.</p>
<p>Note: The y-coordinate of the point is the first parameter, and the
x-coordinate is the second parameter, due the the structure of calculating
the tangent.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(204);
  translate(width / 2, height / 2);
  let a = atan2(mouseY - height / 2, mouseX - width / 2);
  rotate(a);
  rect(-30, -5, 60, 10);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>y</code> y-coordinate of the point

"##]
///
///
#[doc = r##"<code>x</code> x-coordinate of the point

"##]
///

pub static atan2: Atan2InternalType = Atan2InternalType;
#[doc(hidden)]
pub struct Atan2InternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "atan2")]
    fn atan257021824(_ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for Atan2InternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        atan257021824.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for Atan2InternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        atan257021824.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for Atan2InternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        atan257021824.call(args)
    }
}
#[doc=r##"<p>Calculates the cosine of an angle. This function takes into account the
current <a href="#/p5/angleMode">angleMode</a>. Values are returned in the range -1 to 1.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let a = 0.0;
let inc = TWO_PI / 25.0;
for (let i = 0; i < 25; i++) {
  line(i * 4, 50, i * 4, 50 + cos(a) * 40.0);
  a = a + inc;
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle

"##]
///

pub static cos: CosInternalType = CosInternalType;
#[doc(hidden)]
pub struct CosInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "cos")]
    fn cos3768136020(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CosInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        cos3768136020.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CosInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        cos3768136020.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CosInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        cos3768136020.call(args)
    }
}
#[doc=r##"<p>Calculates the sine of an angle. This function takes into account the
current <a href="#/p5/angleMode">angleMode</a>. Values are returned in the range -1 to 1.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let a = 0.0;
let inc = TWO_PI / 25.0;
for (let i = 0; i < 25; i++) {
  line(i * 4, 50, i * 4, 50 + sin(a) * 40.0);
  a = a + inc;
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle

"##]
///

pub static sin: SinInternalType = SinInternalType;
#[doc(hidden)]
pub struct SinInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sin")]
    fn sin1278000597(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SinInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        sin1278000597.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SinInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        sin1278000597.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SinInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        sin1278000597.call(args)
    }
}
#[doc=r##"<p>Calculates the tangent of an angle. This function takes into account
the current <a href="#/p5/angleMode">angleMode</a>. Values are returned in the range of all real numbers.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let a = 0.0;
let inc = TWO_PI / 50.0;
for (let i = 0; i < 100; i = i + 2) {
  line(i, 50, i, 50 + tan(a) * 2.0);
  a = a + inc;
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle

"##]
///

pub static tan: TanInternalType = TanInternalType;
#[doc(hidden)]
pub struct TanInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "tan")]
    fn tan2789107627(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for TanInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        tan2789107627.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for TanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        tan2789107627.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for TanInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        tan2789107627.call(args)
    }
}
#[doc=r##"<p>Converts a radian measurement to its corresponding value in degrees.
Radians and degrees are two ways of measuring the same thing. There are
360 degrees in a circle and 2*PI radians in a circle. For example,
90° = PI/2 = 1.5707964. This function does not take into account the
current <a href="#/p5/angleMode">angleMode</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let rad = PI / 4;
let deg = degrees(rad);
print(rad + ' radians is ' + deg + ' degrees');
// Prints: 0.7853981633974483 radians is 45 degrees
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>radians</code> the radians value to convert to degrees

"##]
///

pub static degrees: DegreesInternalType = DegreesInternalType;
#[doc(hidden)]
pub struct DegreesInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "degrees")]
    fn degrees1983220414(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for DegreesInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        degrees1983220414.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for DegreesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        degrees1983220414.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for DegreesInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        degrees1983220414.call(args)
    }
}
#[doc=r##"<p>Converts a degree measurement to its corresponding value in radians.
Radians and degrees are two ways of measuring the same thing. There are
360 degrees in a circle and 2*PI radians in a circle. For example,
90° = PI/2 = 1.5707964. This function does not take into account the
current <a href="#/p5/angleMode">angleMode</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let deg = 45.0;
let rad = radians(deg);
print(deg + ' degrees is ' + rad + ' radians');
// Prints: 45 degrees is 0.7853981633974483 radians
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>degrees</code> the degree value to convert to radians

"##]
///

pub static radians: RadiansInternalType = RadiansInternalType;
#[doc(hidden)]
pub struct RadiansInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "radians")]
    fn radians3334138422(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RadiansInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        radians3334138422.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RadiansInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        radians3334138422.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RadiansInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        radians3334138422.call(args)
    }
}
#[doc=r##"<p>Sets the current mode of p5 to given mode. Default mode is RADIANS.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function draw() {
  background(204);
  angleMode(DEGREES); // Change the mode to DEGREES
  let a = atan2(mouseY - height / 2, mouseX - width / 2);
  translate(width / 2, height / 2);
  push();
  rotate(a);
  rect(-20, -5, 40, 10); // Larger rectangle is rotating in degrees
  pop();
  angleMode(RADIANS); // Change the mode to RADIANS
  rotate(a); // variable a stays the same
  rect(-40, -5, 20, 10); // Smaller rectangle is rotating in radians
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode</code> either RADIANS or DEGREES

"##]
///

pub static angleMode: AngleModeInternalType = AngleModeInternalType;
#[doc(hidden)]
pub struct AngleModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "angleMode")]
    fn angleMode105599934(_ : ANGLE_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(ANGLE_MODE,)> for AngleModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (ANGLE_MODE,)) -> Self::Output {
        angleMode105599934.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(ANGLE_MODE,)> for AngleModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (ANGLE_MODE,)) -> Self::Output {
        angleMode105599934.call(args)
    }
}

#[doc(hidden)]
impl Fn<(ANGLE_MODE,)> for AngleModeInternalType {
    extern "rust-call" fn call(&self, args: (ANGLE_MODE,)) -> Self::Output {
        angleMode105599934.call(args)
    }
}
#[doc=r##"<p>Set attributes for the WebGL Drawing context.
This is a way of adjusting how the WebGL
renderer works to fine-tune the display and performance.</p>
<p>Note that this will reinitialize the drawing context
if called after the WebGL canvas is made.</p>
<p>If an object is passed as the parameter, all attributes
not declared in the object will be set to defaults.</p>
<p>The available attributes are:
<br>
alpha - indicates if the canvas contains an alpha buffer
default is true</p>
<p>depth - indicates whether the drawing buffer has a depth buffer
of at least 16 bits - default is true</p>
<p>stencil - indicates whether the drawing buffer has a stencil buffer
of at least 8 bits</p>
<p>antialias - indicates whether or not to perform anti-aliasing
default is false (true in Safari)</p>
<p>premultipliedAlpha - indicates that the page compositor will assume
the drawing buffer contains colors with pre-multiplied alpha
default is false</p>
<p>preserveDrawingBuffer - if true the buffers will not be cleared and
and will preserve their values until cleared or overwritten by author
(note that p5 clears automatically on draw loop)
default is true</p>
<p>perPixelLighting - if true, per-pixel lighting will be used in the
lighting shader otherwise per-vertex lighting is used.
default is true.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(255);
  push();
  rotateZ(frameCount * 0.02);
  rotateX(frameCount * 0.02);
  rotateY(frameCount * 0.02);
  fill(0, 0, 0);
  box(50);
  pop();
}
```"###]
#[doc=r###"```rust
function setup() {
  setAttributes('antialias', true);
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(255);
  push();
  rotateZ(frameCount * 0.02);
  rotateX(frameCount * 0.02);
  rotateY(frameCount * 0.02);
  fill(0, 0, 0);
  box(50);
  pop();
}
```"###]
#[doc=r###"```rust
// press the mouse button to disable perPixelLighting
function setup() {
  createCanvas(100, 100, WEBGL);
  noStroke();
  fill(255);
}

let lights = [
  { c: '#f00', t: 1.12, p: 1.91, r: 0.2 },
  { c: '#0f0', t: 1.21, p: 1.31, r: 0.2 },
  { c: '#00f', t: 1.37, p: 1.57, r: 0.2 },
  { c: '#ff0', t: 1.12, p: 1.91, r: 0.7 },
  { c: '#0ff', t: 1.21, p: 1.31, r: 0.7 },
  { c: '#f0f', t: 1.37, p: 1.57, r: 0.7 }
];

function draw() {
  let t = millis() / 1000 + 1000;
  background(0);
  directionalLight(color('#222'), 1, 1, 1);

  for (let i = 0; i < lights.length; i++) {
    let light = lights[i];
    pointLight(
      color(light.c),
      p5.Vector.fromAngles(t * light.t, t * light.p, width * light.r)
    );
  }

  specularMaterial(255);
  sphere(width * 0.1);

  rotateX(t * 0.77);
  rotateY(t * 0.83);
  rotateZ(t * 0.91);
  torus(width * 0.3, width * 0.07, 24, 10);
}

function mousePressed() {
  setAttributes('perPixelLighting', false);
  noStroke();
  fill(255);
}
function mouseReleased() {
  setAttributes('perPixelLighting', true);
  noStroke();
  fill(255);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>key</code> Name of attribute

"##]
///
///
#[doc = r##"<code>value</code> New value of named attribute

"##]
///
///
/// ---
///
///
#[doc = r##"<code>obj</code> object with key-value pairs

"##]
///
///
/// ---
///

pub static setAttributes: SetAttributesInternalType = SetAttributesInternalType;
#[doc(hidden)]
pub struct SetAttributesInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "setAttributes")]
    fn setAttributes2279280046(_ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,)> for SetAttributesInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,)) -> Self::Output {
        setAttributes2279280046.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,)> for SetAttributesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,)) -> Self::Output {
        setAttributes2279280046.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,)> for SetAttributesInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,)) -> Self::Output {
        setAttributes2279280046.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "setAttributes")]
    fn setAttributes2523539394(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for SetAttributesInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        setAttributes2523539394.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for SetAttributesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        setAttributes2523539394.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for SetAttributesInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        setAttributes2523539394.call(args)
    }
}
#[doc=r##"<p>Sets the current alignment for drawing text. Accepts two
arguments: horizAlign (LEFT, CENTER, or RIGHT) and
vertAlign (TOP, BOTTOM, CENTER, or BASELINE).</p>
<p>The horizAlign parameter is in reference to the x value
of the <a href="#/p5/text">text()</a> function, while the vertAlign parameter
is in reference to the y value.</p>
<p>So if you write textAlign(LEFT), you are aligning the left
edge of your text to the x value you give in <a href="#/p5/text">text()</a>.
If you write textAlign(RIGHT, TOP), you are aligning the right edge
of your text to the x value and the top of edge of the text
to the y value.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
textSize(16);
textAlign(RIGHT);
text('ABCD', 50, 30);
textAlign(CENTER);
text('EFGH', 50, 50);
textAlign(LEFT);
text('IJKL', 50, 70);
```"###]
#[doc=r###"```rust
textSize(16);
strokeWeight(0.5);

line(0, 12, width, 12);
textAlign(CENTER, TOP);
text('TOP', 0, 12, width);

line(0, 37, width, 37);
textAlign(CENTER, CENTER);
text('CENTER', 0, 37, width);

line(0, 62, width, 62);
textAlign(CENTER, BASELINE);
text('BASELINE', 0, 62, width);

line(0, 87, width, 87);
textAlign(CENTER, BOTTOM);
text('BOTTOM', 0, 87, width);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>horizAlign</code> horizontal alignment, either LEFT,
                           CENTER, or RIGHT

"##]
///
///
#[doc = r##"<code>vertAlign?</code> vertical alignment, either TOP,
                           BOTTOM, CENTER, or BASELINE

"##]
///
///
/// ---
///
///
/// ---
///

pub static textAlign: TextAlignInternalType = TextAlignInternalType;
#[doc(hidden)]
pub struct TextAlignInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textAlign")]
    fn textAlign2261606669(_ : HORIZ_ALIGN, _ : VERT_ALIGN, ) ;
}

#[doc(hidden)]
impl FnOnce<(HORIZ_ALIGN,VERT_ALIGN,)> for TextAlignInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (HORIZ_ALIGN,VERT_ALIGN,)) -> Self::Output {
        textAlign2261606669.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(HORIZ_ALIGN,VERT_ALIGN,)> for TextAlignInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (HORIZ_ALIGN,VERT_ALIGN,)) -> Self::Output {
        textAlign2261606669.call(args)
    }
}

#[doc(hidden)]
impl Fn<(HORIZ_ALIGN,VERT_ALIGN,)> for TextAlignInternalType {
    extern "rust-call" fn call(&self, args: (HORIZ_ALIGN,VERT_ALIGN,)) -> Self::Output {
        textAlign2261606669.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textAlign")]
    fn textAlign68811059(_ : HORIZ_ALIGN, ) ;
}

#[doc(hidden)]
impl FnOnce<(HORIZ_ALIGN,)> for TextAlignInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (HORIZ_ALIGN,)) -> Self::Output {
        textAlign68811059.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(HORIZ_ALIGN,)> for TextAlignInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (HORIZ_ALIGN,)) -> Self::Output {
        textAlign68811059.call(args)
    }
}

#[doc(hidden)]
impl Fn<(HORIZ_ALIGN,)> for TextAlignInternalType {
    extern "rust-call" fn call(&self, args: (HORIZ_ALIGN,)) -> Self::Output {
        textAlign68811059.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textAlign")]
    fn textAlign4084341697() -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<()> for TextAlignInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textAlign4084341697.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextAlignInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textAlign4084341697.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextAlignInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textAlign4084341697.call(args)
    }
}
#[doc=r##"<p>Sets/gets the spacing, in pixels, between lines of text. This setting will be
used in all subsequent calls to the <a href="#/p5/text">text()</a> function.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let lines = 'L1\nL2\nL3'; // "\n" is a "new line" character
textSize(12);

textLeading(10);
text(lines, 10, 25);

textLeading(20);
text(lines, 40, 25);

textLeading(30);
text(lines, 70, 25);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>leading</code> the size in pixels for spacing between lines

"##]
///
///
/// ---
///
///
/// ---
///

pub static textLeading: TextLeadingInternalType = TextLeadingInternalType;
#[doc(hidden)]
pub struct TextLeadingInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textLeading")]
    fn textLeading1455853475(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for TextLeadingInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        textLeading1455853475.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for TextLeadingInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        textLeading1455853475.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for TextLeadingInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        textLeading1455853475.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textLeading")]
    fn textLeading1098004036() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for TextLeadingInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textLeading1098004036.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextLeadingInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textLeading1098004036.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextLeadingInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textLeading1098004036.call(args)
    }
}
#[doc=r##"<p>Sets/gets the current font size. This size will be used in all subsequent
calls to the <a href="#/p5/text">text()</a> function. Font size is measured in pixels.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
textSize(12);
text('Font Size 12', 10, 30);
textSize(14);
text('Font Size 14', 10, 60);
textSize(16);
text('Font Size 16', 10, 90);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>theSize</code> the size of the letters in units of pixels

"##]
///
///
/// ---
///
///
/// ---
///

pub static textSize: TextSizeInternalType = TextSizeInternalType;
#[doc(hidden)]
pub struct TextSizeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textSize")]
    fn textSize517594270(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for TextSizeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        textSize517594270.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for TextSizeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        textSize517594270.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for TextSizeInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        textSize517594270.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textSize")]
    fn textSize46458980() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for TextSizeInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textSize46458980.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextSizeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textSize46458980.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextSizeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textSize46458980.call(args)
    }
}
#[doc=r##"<p>Sets/gets the style of the text for system fonts to NORMAL, ITALIC, BOLD or BOLDITALIC.
Note: this may be is overridden by CSS styling. For non-system fonts
(opentype, truetype, etc.) please load styled fonts instead.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
strokeWeight(0);
textSize(12);
textStyle(NORMAL);
text('Font Style Normal', 10, 15);
textStyle(ITALIC);
text('Font Style Italic', 10, 40);
textStyle(BOLD);
text('Font Style Bold', 10, 65);
textStyle(BOLDITALIC);
text('Font Style Bold Italic', 10, 90);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>theStyle</code> styling for text, either NORMAL,
                           ITALIC, BOLD or BOLDITALIC

"##]
///
///
/// ---
///
///
/// ---
///

pub static textStyle: TextStyleInternalType = TextStyleInternalType;
#[doc(hidden)]
pub struct TextStyleInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textStyle")]
    fn textStyle1042628788(_ : THE_STYLE, ) ;
}

#[doc(hidden)]
impl FnOnce<(THE_STYLE,)> for TextStyleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (THE_STYLE,)) -> Self::Output {
        textStyle1042628788.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(THE_STYLE,)> for TextStyleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (THE_STYLE,)) -> Self::Output {
        textStyle1042628788.call(args)
    }
}

#[doc(hidden)]
impl Fn<(THE_STYLE,)> for TextStyleInternalType {
    extern "rust-call" fn call(&self, args: (THE_STYLE,)) -> Self::Output {
        textStyle1042628788.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textStyle")]
    fn textStyle50401707() -> String;
}

#[doc(hidden)]
impl FnOnce<()> for TextStyleInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textStyle50401707.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextStyleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textStyle50401707.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextStyleInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textStyle50401707.call(args)
    }
}
#[doc=r##"<p>Calculates and returns the width of any character or text string.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
textSize(28);

let aChar = 'P';
let cWidth = textWidth(aChar);
text(aChar, 0, 40);
line(cWidth, 0, cWidth, 50);

let aString = 'p5.js';
let sWidth = textWidth(aString);
text(aString, 0, 85);
line(sWidth, 50, sWidth, 100);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>theText</code> the String of characters to measure

"##]
///

pub static textWidth: TextWidthInternalType = TextWidthInternalType;
#[doc(hidden)]
pub struct TextWidthInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textWidth")]
    fn textWidth1632051229(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for TextWidthInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        textWidth1632051229.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for TextWidthInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        textWidth1632051229.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for TextWidthInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        textWidth1632051229.call(args)
    }
}
#[doc=r##"<p>Returns the ascent of the current font at its current size. The ascent
represents the distance, in pixels, of the tallest character above
the baseline.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let base = height * 0.75;
let scalar = 0.8; // Different for each font

textSize(32); // Set initial text size
let asc = textAscent() * scalar; // Calc ascent
line(0, base - asc, width, base - asc);
text('dp', 0, base); // Draw text on baseline

textSize(64); // Increase text size
asc = textAscent() * scalar; // Recalc ascent
line(40, base - asc, width, base - asc);
text('dp', 40, base); // Draw text on baseline
```"###]

pub static textAscent: TextAscentInternalType = TextAscentInternalType;
#[doc(hidden)]
pub struct TextAscentInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textAscent")]
    fn textAscent4079815082() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for TextAscentInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textAscent4079815082.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextAscentInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textAscent4079815082.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextAscentInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textAscent4079815082.call(args)
    }
}
#[doc=r##"<p>Returns the descent of the current font at its current size. The descent
represents the distance, in pixels, of the character with the longest
descender below the baseline.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let base = height * 0.75;
let scalar = 0.8; // Different for each font

textSize(32); // Set initial text size
let desc = textDescent() * scalar; // Calc ascent
line(0, base + desc, width, base + desc);
text('dp', 0, base); // Draw text on baseline

textSize(64); // Increase text size
desc = textDescent() * scalar; // Recalc ascent
line(40, base + desc, width, base + desc);
text('dp', 40, base); // Draw text on baseline
```"###]

pub static textDescent: TextDescentInternalType = TextDescentInternalType;
#[doc(hidden)]
pub struct TextDescentInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "textDescent")]
    fn textDescent1741730523() -> f64;
}

#[doc(hidden)]
impl FnOnce<()> for TextDescentInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        textDescent1741730523.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for TextDescentInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        textDescent1741730523.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for TextDescentInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        textDescent1741730523.call(args)
    }
}
#[doc=r##"<p>Multiplies the current matrix by the one specified through the parameters.
This is a powerful operation that can perform the equivalent of translate,
scale, shear and rotate all at once. You can learn more about transformation
matrices on <a href="https://en.wikipedia.org/wiki/Transformation_matrix">
Wikipedia</a>.</p>
<p>The naming of the arguments here follows the naming of the <a href=
"https://html.spec.whatwg.org/multipage/canvas.html#dom-context-2d-transform">
WHATWG specification</a> and corresponds to a
transformation matrix of the
form:</p>
<blockquote>
<p><img style="max-width: 150px" src="assets/transformation-matrix.png"
alt="The transformation matrix used when applyMatrix is called"/></p>
</blockquote>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  frameRate(10);
  rectMode(CENTER);
}

function draw() {
  let step = frameCount % 20;
  background(200);
  // Equivalent to translate(x, y);
  applyMatrix(1, 0, 0, 1, 40 + step, 50);
  rect(0, 0, 50, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  frameRate(10);
  rectMode(CENTER);
}

function draw() {
  let step = frameCount % 20;
  background(200);
  translate(50, 50);
  // Equivalent to scale(x, y);
  applyMatrix(1 / step, 0, 0, 1 / step, 0, 0);
  rect(0, 0, 50, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  frameRate(10);
  rectMode(CENTER);
}

function draw() {
  let step = frameCount % 20;
  let angle = map(step, 0, 20, 0, TWO_PI);
  let cos_a = cos(angle);
  let sin_a = sin(angle);
  background(200);
  translate(50, 50);
  // Equivalent to rotate(angle);
  applyMatrix(cos_a, sin_a, -sin_a, cos_a, 0, 0);
  rect(0, 0, 50, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  frameRate(10);
  rectMode(CENTER);
}

function draw() {
  let step = frameCount % 20;
  let angle = map(step, 0, 20, -PI / 4, PI / 4);
  background(200);
  translate(50, 50);
  // equivalent to shearX(angle);
  let shear_factor = 1 / tan(PI / 2 - angle);
  applyMatrix(1, 0, shear_factor, 1, 0, 0);
  rect(0, 0, 50, 50);
}
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  noFill();
}

function draw() {
  background(200);
  rotateY(PI / 6);
  stroke(153);
  box(35);
  let rad = millis() / 1000;
  // Set rotation angles
  let ct = cos(rad);
  let st = sin(rad);
  // Matrix for rotation around the Y axis
  applyMatrix(  ct, 0.0,  st,  0.0,
               0.0, 1.0, 0.0,  0.0,
               -st, 0.0,  ct,  0.0,
               0.0, 0.0, 0.0,  1.0);
  stroke(255);
  box(50);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> numbers which define the 2x3 matrix to be multiplied

"##]
///
///
#[doc = r##"<code>b</code> numbers which define the 2x3 matrix to be multiplied

"##]
///
///
#[doc = r##"<code>c</code> numbers which define the 2x3 matrix to be multiplied

"##]
///
///
#[doc = r##"<code>d</code> numbers which define the 2x3 matrix to be multiplied

"##]
///
///
#[doc = r##"<code>e</code> numbers which define the 2x3 matrix to be multiplied

"##]
///
///
#[doc = r##"<code>f</code> numbers which define the 2x3 matrix to be multiplied

"##]
///

pub static applyMatrix: ApplyMatrixInternalType = ApplyMatrixInternalType;
#[doc(hidden)]
pub struct ApplyMatrixInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "applyMatrix")]
    fn applyMatrix1640153144(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for ApplyMatrixInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        applyMatrix1640153144.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for ApplyMatrixInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        applyMatrix1640153144.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for ApplyMatrixInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        applyMatrix1640153144.call(args)
    }
}
#[doc=r##"<p>Replaces the current matrix with the identity matrix.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(50, 50);
applyMatrix(0.5, 0.5, -0.5, 0.5, 0, 0);
rect(0, 0, 20, 20);
// Note that the translate is also reset.
resetMatrix();
rect(0, 0, 20, 20);
```"###]

pub static resetMatrix: ResetMatrixInternalType = ResetMatrixInternalType;
#[doc(hidden)]
pub struct ResetMatrixInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "resetMatrix")]
    fn resetMatrix1062250360() ;
}

#[doc(hidden)]
impl FnOnce<()> for ResetMatrixInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        resetMatrix1062250360.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ResetMatrixInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        resetMatrix1062250360.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ResetMatrixInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        resetMatrix1062250360.call(args)
    }
}
#[doc=r##"<p>Rotates a shape by the amount specified by the angle parameter. This
function accounts for <a href="#/p5/angleMode">angleMode</a>, so angles
can be entered in either RADIANS or DEGREES.</p>
<p>Objects are always rotated around their relative position to the
origin and positive numbers rotate objects in a clockwise direction.
Transformations apply to everything that happens after and subsequent
calls to the function accumulates the effect. For example, calling
rotate(HALF_PI) and then rotate(HALF_PI) is the same as rotate(PI).
All tranformations are reset when <a href="#/p5/draw">draw()</a> begins again.</p>
<p>Technically, <a href="#/p5/rotate">rotate()</a> multiplies the current transformation matrix
by a rotation matrix. This function can be further controlled by
the <a href="#/p5/push">push()</a> and <a href="#/p5/pop">pop()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(width / 2, height / 2);
rotate(PI / 3.0);
rect(-26, -26, 52, 52);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle of rotation, specified in radians
                       or degrees, depending on current angleMode

"##]
///
///
#[doc = r##"<code>axis?</code> (in 3d) the axis to rotate around

"##]
///

pub static rotate: RotateInternalType = RotateInternalType;
#[doc(hidden)]
pub struct RotateInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rotate")]
    fn rotate874210099(_ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,&'_ Vector,)> for RotateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,&'_ Vector,)) -> Self::Output {
        rotate874210099.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,&'_ Vector,)> for RotateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,&'_ Vector,)) -> Self::Output {
        rotate874210099.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,&'_ Vector,)> for RotateInternalType {
    extern "rust-call" fn call(&self, args: (f64,&'_ Vector,)) -> Self::Output {
        rotate874210099.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rotate")]
    fn rotate2079470350(_ : f64, _ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,&'_ [f64],)> for RotateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,&'_ [f64],)) -> Self::Output {
        rotate2079470350.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,&'_ [f64],)> for RotateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,&'_ [f64],)) -> Self::Output {
        rotate2079470350.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,&'_ [f64],)> for RotateInternalType {
    extern "rust-call" fn call(&self, args: (f64,&'_ [f64],)) -> Self::Output {
        rotate2079470350.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rotate")]
    fn rotate3251684292(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RotateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        rotate3251684292.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RotateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        rotate3251684292.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RotateInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        rotate3251684292.call(args)
    }
}
#[doc=r##"<p>Rotates a shape around X axis by the amount specified in angle parameter.
The angles can be entered in either RADIANS or DEGREES.</p>
<p>Objects are always rotated around their relative position to the
origin and positive numbers rotate objects in a clockwise direction.
All tranformations are reset when <a href="#/p5/draw">draw()</a> begins again.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(255);
  rotateX(millis() / 1000);
  box();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle of rotation, specified in radians
                       or degrees, depending on current angleMode

"##]
///

pub static rotateX: RotateXInternalType = RotateXInternalType;
#[doc(hidden)]
pub struct RotateXInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rotateX")]
    fn rotateX537443161(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RotateXInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        rotateX537443161.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RotateXInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        rotateX537443161.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RotateXInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        rotateX537443161.call(args)
    }
}
#[doc=r##"<p>Rotates a shape around Y axis by the amount specified in angle parameter.
The angles can be entered in either RADIANS or DEGREES.</p>
<p>Objects are always rotated around their relative position to the
origin and positive numbers rotate objects in a clockwise direction.
All tranformations are reset when <a href="#/p5/draw">draw()</a> begins again.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(255);
  rotateY(millis() / 1000);
  box();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle of rotation, specified in radians
                       or degrees, depending on current angleMode

"##]
///

pub static rotateY: RotateYInternalType = RotateYInternalType;
#[doc(hidden)]
pub struct RotateYInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rotateY")]
    fn rotateY202484440(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RotateYInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        rotateY202484440.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RotateYInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        rotateY202484440.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RotateYInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        rotateY202484440.call(args)
    }
}
#[doc=r##"<p>Rotates a shape around Z axis by the amount specified in angle parameter.
The angles can be entered in either RADIANS or DEGREES.</p>
<p>This method works in WEBGL mode only.</p>
<p>Objects are always rotated around their relative position to the
origin and positive numbers rotate objects in a clockwise direction.
All tranformations are reset when <a href="#/p5/draw">draw()</a> begins again.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(255);
  rotateZ(millis() / 1000);
  box();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> the angle of rotation, specified in radians
                       or degrees, depending on current angleMode

"##]
///

pub static rotateZ: RotateZInternalType = RotateZInternalType;
#[doc(hidden)]
pub struct RotateZInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rotateZ")]
    fn rotateZ760085044(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for RotateZInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        rotateZ760085044.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for RotateZInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        rotateZ760085044.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for RotateZInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        rotateZ760085044.call(args)
    }
}
#[doc=r##"<p>Increases or decreases the size of a shape by expanding or contracting
vertices. Objects always scale from their relative origin to the
coordinate system. Scale values are specified as decimal percentages.
For example, the function call scale(2.0) increases the dimension of a
shape by 200%.</p>
<p>Transformations apply to everything that happens after and subsequent
calls to the function multiply the effect. For example, calling scale(2.0)
and then scale(1.5) is the same as scale(3.0). If <a href="#/p5/scale">scale()</a> is called
within <a href="#/p5/draw">draw()</a>, the transformation is reset when the loop begins again.</p>
<p>Using this function with the z parameter is only available in WEBGL mode.
This function can be further controlled with <a href="#/p5/push">push()</a> and <a href="#/p5/pop">pop()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
rect(30, 20, 50, 50);
scale(0.5);
rect(30, 20, 50, 50);
```"###]
#[doc=r###"```rust
rect(30, 20, 50, 50);
scale(0.5, 1.3);
rect(30, 20, 50, 50);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>s</code> percent to scale the object, or percentage to
                     scale the object in the x-axis if multiple arguments
                     are given

"##]
///
///
#[doc = r##"<code>y?</code> percent to scale the object in the y-axis

"##]
///
///
#[doc = r##"<code>z?</code> percent to scale the object in the z-axis (webgl only)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>scales</code> per-axis percents to scale the object

"##]
///
///
/// ---
///

pub static scale: ScaleInternalType = ScaleInternalType;
#[doc(hidden)]
pub struct ScaleInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale678612558(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        scale678612558.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        scale678612558.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        scale678612558.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale1495517535(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        scale1495517535.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        scale1495517535.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        scale1495517535.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale2606391196(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        scale2606391196.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        scale2606391196.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        scale2606391196.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale1108887924(_ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Vector,f64,f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Vector,f64,f64,)) -> Self::Output {
        scale1108887924.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Vector,f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Vector,f64,f64,)) -> Self::Output {
        scale1108887924.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Vector,f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Vector,f64,f64,)) -> Self::Output {
        scale1108887924.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale1782013511(_ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Vector,f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Vector,f64,)) -> Self::Output {
        scale1782013511.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Vector,f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Vector,f64,)) -> Self::Output {
        scale1782013511.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Vector,f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Vector,f64,)) -> Self::Output {
        scale1782013511.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale2742958802(_ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Vector,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Vector,)) -> Self::Output {
        scale2742958802.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Vector,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Vector,)) -> Self::Output {
        scale2742958802.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Vector,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Vector,)) -> Self::Output {
        scale2742958802.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale808972105(_ : & [f64], _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,)) -> Self::Output {
        scale808972105.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,)) -> Self::Output {
        scale808972105.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,)) -> Self::Output {
        scale808972105.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale1242081759(_ : & [f64], _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,)) -> Self::Output {
        scale1242081759.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,)) -> Self::Output {
        scale1242081759.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,)) -> Self::Output {
        scale1242081759.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "scale")]
    fn scale2515990498(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for ScaleInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        scale2515990498.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for ScaleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        scale2515990498.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for ScaleInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        scale2515990498.call(args)
    }
}
#[doc=r##"<p>Shears a shape around the x-axis by the amount specified by the angle
parameter. Angles should be specified in the current angleMode.
Objects are always sheared around their relative position to the origin
and positive numbers shear objects in a clockwise direction.</p>
<p>Transformations apply to everything that happens after and subsequent
calls to the function accumulates the effect. For example, calling
shearX(PI/2) and then shearX(PI/2) is the same as shearX(PI).
If <a href="#/p5/shearX">shearX()</a> is called within the <a href="#/p5/draw">draw()</a>,
the transformation is reset when the loop begins again.</p>
<p>Technically, <a href="#/p5/shearX">shearX()</a> multiplies the current
transformation matrix by a rotation matrix. This function can be further
controlled by the <a href="#/p5/push">push()</a> and <a href="#/p5/pop">pop()</a> functions.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(width / 4, height / 4);
shearX(PI / 4.0);
rect(0, 0, 30, 30);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> angle of shear specified in radians or degrees,
                       depending on current angleMode

"##]
///

pub static shearX: ShearXInternalType = ShearXInternalType;
#[doc(hidden)]
pub struct ShearXInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shearX")]
    fn shearX499780366(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ShearXInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        shearX499780366.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ShearXInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        shearX499780366.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ShearXInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        shearX499780366.call(args)
    }
}
#[doc=r##"<p>Shears a shape around the y-axis the amount specified by the angle
parameter. Angles should be specified in the current angleMode. Objects
are always sheared around their relative position to the origin and
positive numbers shear objects in a clockwise direction.</p>
<p>Transformations apply to everything that happens after and subsequent
calls to the function accumulates the effect. For example, calling
shearY(PI/2) and then shearY(PI/2) is the same as shearY(PI). If
<a href="#/p5/shearY">shearY()</a> is called within the <a href="#/p5/draw">draw()</a>, the transformation is reset when
the loop begins again.</p>
<p>Technically, <a href="#/p5/shearY">shearY()</a> multiplies the current transformation matrix by a
rotation matrix. This function can be further controlled by the
<a href="#/p5/push">push()</a> and <a href="#/p5/pop">pop()</a> functions.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(width / 4, height / 4);
shearY(PI / 4.0);
rect(0, 0, 30, 30);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>angle</code> angle of shear specified in radians or degrees,
                       depending on current angleMode

"##]
///

pub static shearY: ShearYInternalType = ShearYInternalType;
#[doc(hidden)]
pub struct ShearYInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shearY")]
    fn shearY2594860630(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ShearYInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        shearY2594860630.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ShearYInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        shearY2594860630.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ShearYInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        shearY2594860630.call(args)
    }
}
#[doc=r##"<p>Specifies an amount to displace objects within the display window.
The x parameter specifies left/right translation, the y parameter
specifies up/down translation.</p>
<p>Transformations are cumulative and apply to everything that happens after
and subsequent calls to the function accumulates the effect. For example,
calling translate(50, 0) and then translate(20, 0) is the same as
translate(70, 0). If <a href="#/p5/translate">translate()</a> is called within <a href="#/p5/draw">draw()</a>, the
transformation is reset when the loop begins again. This function can be
further controlled by using <a href="#/p5/push">push()</a> and <a href="#/p5/pop">pop()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
translate(30, 20);
rect(0, 0, 55, 55);
```"###]
#[doc=r###"```rust
rect(0, 0, 55, 55); // Draw rect at original 0,0
translate(30, 20);
rect(0, 0, 55, 55); // Draw rect at new 0,0
translate(14, 14);
rect(0, 0, 55, 55); // Draw rect at new 0,0
```"###]
#[doc=r###"```rust
function draw() {
  background(200);
  rectMode(CENTER);
  translate(width / 2, height / 2);
  translate(p5.Vector.fromAngle(millis() / 1000, 40));
  rect(0, 0, 20, 20);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x</code> left/right translation

"##]
///
///
#[doc = r##"<code>y</code> up/down translation

"##]
///
///
#[doc = r##"<code>z?</code> forward/backward translation (webgl only)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>vector</code> the vector to translate by

"##]
///
///
/// ---
///

pub static translate: TranslateInternalType = TranslateInternalType;
#[doc(hidden)]
pub struct TranslateInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "translate")]
    fn translate1872703650(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for TranslateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        translate1872703650.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for TranslateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        translate1872703650.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for TranslateInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        translate1872703650.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "translate")]
    fn translate4035295824(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for TranslateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        translate4035295824.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for TranslateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        translate4035295824.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for TranslateInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        translate4035295824.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "translate")]
    fn translate2663268457(_ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Vector,)> for TranslateInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Vector,)) -> Self::Output {
        translate2663268457.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Vector,)> for TranslateInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Vector,)) -> Self::Output {
        translate2663268457.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Vector,)> for TranslateInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Vector,)) -> Self::Output {
        translate2663268457.call(args)
    }
}
#[doc=r##"<p>Extracts the alpha value from a color or pixel array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
let c = color(0, 126, 255, 102);
fill(c);
rect(15, 15, 35, 70);
let value = alpha(c); // Sets 'value' to 102
fill(value);
rect(50, 15, 35, 70);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static alpha: AlphaInternalType = AlphaInternalType;
#[doc(hidden)]
pub struct AlphaInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "alpha")]
    fn alpha2771614555(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for AlphaInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        alpha2771614555.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for AlphaInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        alpha2771614555.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for AlphaInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        alpha2771614555.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "alpha")]
    fn alpha3092700221(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for AlphaInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        alpha3092700221.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for AlphaInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        alpha3092700221.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for AlphaInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        alpha3092700221.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "alpha")]
    fn alpha689731141(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for AlphaInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        alpha689731141.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for AlphaInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        alpha689731141.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for AlphaInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        alpha689731141.call(args)
    }
}
#[doc=r##"<p>Extracts the blue value from a color or pixel array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let c = color(175, 100, 220);
fill(c);
rect(15, 20, 35, 60); // Draw left rectangle
let blueValue = blue(c);
fill(0, 0, blueValue);
rect(50, 20, 35, 60); // Draw right rectangle
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static blue: BlueInternalType = BlueInternalType;
#[doc(hidden)]
pub struct BlueInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "blue")]
    fn blue2803915788(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for BlueInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        blue2803915788.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for BlueInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        blue2803915788.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for BlueInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        blue2803915788.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "blue")]
    fn blue2224436633(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for BlueInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        blue2224436633.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for BlueInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        blue2224436633.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for BlueInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        blue2224436633.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "blue")]
    fn blue3607422463(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for BlueInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        blue3607422463.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for BlueInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        blue3607422463.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for BlueInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        blue3607422463.call(args)
    }
}
#[doc=r##"<p>Extracts the HSB brightness value from a color or pixel array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
colorMode(HSB, 255);
let c = color(0, 126, 255);
fill(c);
rect(15, 20, 35, 60);
let value = brightness(c); // Sets 'value' to 255
fill(value);
rect(50, 20, 35, 60);
```"###]
#[doc=r###"```rust
noStroke();
colorMode(HSB, 255);
let c = color('hsb(60, 100%, 50%)');
fill(c);
rect(15, 20, 35, 60);
let value = brightness(c); // A 'value' of 50% is 127.5
fill(value);
rect(50, 20, 35, 60);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static brightness: BrightnessInternalType = BrightnessInternalType;
#[doc(hidden)]
pub struct BrightnessInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "brightness")]
    fn brightness3171960842(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for BrightnessInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        brightness3171960842.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for BrightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        brightness3171960842.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for BrightnessInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        brightness3171960842.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "brightness")]
    fn brightness3263699917(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for BrightnessInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        brightness3263699917.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for BrightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        brightness3263699917.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for BrightnessInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        brightness3263699917.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "brightness")]
    fn brightness2922027373(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for BrightnessInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        brightness2922027373.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for BrightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        brightness2922027373.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for BrightnessInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        brightness2922027373.call(args)
    }
}
#[doc=r##"<p>Creates colors for storing in variables of the color datatype. The
parameters are interpreted as RGB or HSB values depending on the
current <a href="#/p5/colorMode">colorMode()</a>. The default mode is RGB values from 0 to 255
and, therefore, the function call color(255, 204, 0) will return a
bright yellow color.</p>
<p>Note that if only one value is provided to <a href="#/p5/color">color()</a>, it will be interpreted
as a grayscale value. Add a second value, and it will be used for alpha
transparency. When three values are specified, they are interpreted as
either RGB or HSB values. Adding a fourth value applies alpha
transparency.</p>
<p>If a single string argument is provided, RGB, RGBA and Hex CSS color
strings and all named color strings are supported. In this case, an alpha
number value as a second argument is not supported, the RGBA form should be
used.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let c = color(255, 204, 0);
fill(c);
noStroke();
rect(30, 20, 55, 55);
```"###]
#[doc=r###"```rust
let c = color(255, 204, 0);
fill(c);
noStroke();
ellipse(25, 25, 80, 80); // Draw left circle
// Using only one value generates a grayscale value.
c = color(65);
fill(c);
ellipse(75, 75, 80, 80);
```"###]
#[doc=r###"```rust
// You can use named SVG & CSS colors
let c = color('magenta');
fill(c);
noStroke();
rect(20, 20, 60, 60);
```"###]
#[doc=r###"```rust
// Example of hex color codes
noStroke();
let c = color('#0f0');
fill(c);
rect(0, 10, 45, 80);
c = color('#00ff00');
fill(c);
rect(55, 10, 45, 80);
```"###]
#[doc=r###"```rust
// RGB and RGBA color strings are also supported
// these all set to the same color (solid blue)
let c;
noStroke();
c = color('rgb(0,0,255)');
fill(c);
rect(10, 10, 35, 35); // Draw rectangle
c = color('rgb(0%, 0%, 100%)');
fill(c);
rect(55, 10, 35, 35); // Draw rectangle
c = color('rgba(0, 0, 255, 1)');
fill(c);
rect(10, 55, 35, 35); // Draw rectangle
c = color('rgba(0%, 0%, 100%, 1)');
fill(c);
rect(55, 55, 35, 35); // Draw rectangle
```"###]
#[doc=r###"```rust
// HSL color can also be specified by value
let c = color('hsl(160, 100%, 50%)');
noStroke();
fill(c);
rect(0, 10, 45, 80); // Draw rectangle
c = color('hsla(160, 100%, 50%, 0.5)');
fill(c);
rect(55, 10, 45, 80); // Draw rectangle
```"###]
#[doc=r###"```rust
// HSB color can also be specified
let c = color('hsb(160, 100%, 50%)');
noStroke();
fill(c);
rect(0, 10, 45, 80); // Draw rectangle
c = color('hsba(160, 100%, 50%, 0.5)');
fill(c);
rect(55, 10, 45, 80); // Draw rectangle
```"###]
#[doc=r###"```rust
noStroke();
let c = color(50, 55, 100);
fill(c);
rect(0, 10, 45, 80); // Draw left rect
colorMode(HSB, 100);
c = color(50, 55, 100);
fill(c);
rect(55, 10, 45, 80);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>gray</code> number specifying value between white and black.

"##]
///
///
#[doc = r##"<code>alpha?</code> alpha value relative to current color range
                                (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>alpha?</code> alpha value relative to current color range
                                (default is 0-255)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>value</code> a color string

"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red,green,blue &
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> 
"##]
///
///
/// ---
///

pub static color: ColorInternalType = ColorInternalType;
#[doc(hidden)]
pub struct ColorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color2547786803(_ : f64, _ : f64, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        color2547786803.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        color2547786803.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        color2547786803.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color1258302120(_ : f64, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        color1258302120.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        color1258302120.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        color1258302120.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color1865288631(_ : f64, _ : f64, _ : f64, _ : f64, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        color1865288631.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        color1865288631.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        color1865288631.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color1229716470(_ : f64, _ : f64, _ : f64, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        color1229716470.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        color1229716470.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        color1229716470.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color3217502212(_ : & str, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        color3217502212.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        color3217502212.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        color3217502212.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color411208024(_ : & [f64], ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        color411208024.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        color411208024.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        color411208024.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "color")]
    fn color3982212263(_ : & Color, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for ColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        color3982212263.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for ColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        color3982212263.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for ColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        color3982212263.call(args)
    }
}
#[doc=r##"<p>Extracts the green value from a color or pixel array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let c = color(20, 75, 200); // Define color 'c'
fill(c); // Use color variable 'c' as fill color
rect(15, 20, 35, 60); // Draw left rectangle

let greenValue = green(c); // Get green in 'c'
print(greenValue); // Print "75.0"
fill(0, greenValue, 0); // Use 'greenValue' in new fill
rect(50, 20, 35, 60); // Draw right rectangle
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static green: GreenInternalType = GreenInternalType;
#[doc(hidden)]
pub struct GreenInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "green")]
    fn green1048113876(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for GreenInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        green1048113876.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for GreenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        green1048113876.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for GreenInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        green1048113876.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "green")]
    fn green2294506626(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for GreenInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        green2294506626.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for GreenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        green2294506626.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for GreenInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        green2294506626.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "green")]
    fn green3014603660(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for GreenInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        green3014603660.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for GreenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        green3014603660.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for GreenInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        green3014603660.call(args)
    }
}
#[doc=r##"<p>Extracts the hue value from a color or pixel array.</p>
<p>Hue exists in both HSB and HSL. This function will return the
HSB-normalized hue when supplied with an HSB color object (or when supplied
with a pixel array while the color mode is HSB), but will default to the
HSL-normalized hue otherwise. (The values will only be different if the
maximum hue setting for each system is different.)</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
colorMode(HSB, 255);
let c = color(0, 126, 255);
fill(c);
rect(15, 20, 35, 60);
let value = hue(c); // Sets 'value' to "0"
fill(value);
rect(50, 20, 35, 60);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static hue: HueInternalType = HueInternalType;
#[doc(hidden)]
pub struct HueInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hue")]
    fn hue2990081610(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for HueInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        hue2990081610.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for HueInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        hue2990081610.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for HueInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        hue2990081610.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hue")]
    fn hue809211351(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for HueInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        hue809211351.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for HueInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        hue809211351.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for HueInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        hue809211351.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hue")]
    fn hue396918183(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for HueInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        hue396918183.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for HueInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        hue396918183.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for HueInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        hue396918183.call(args)
    }
}
#[doc=r##"<p>Blends two colors to find a third color somewhere between them. The amt
parameter is the amount to interpolate between the two values where 0.0
equal to the first color, 0.1 is very near the first color, 0.5 is halfway
in between, etc. An amount below 0 will be treated as 0. Likewise, amounts
above 1 will be capped at 1. This is different from the behavior of <a href="#/p5/lerp">lerp()</a>,
but necessary because otherwise numbers outside the range will produce
strange and unexpected colors.</p>
<p>The way that colors are interpolated depends on the current color mode.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
colorMode(RGB);
stroke(255);
background(51);
let from = color(218, 165, 32);
let to = color(72, 61, 139);
colorMode(RGB); // Try changing to HSB.
let interA = lerpColor(from, to, 0.33);
let interB = lerpColor(from, to, 0.66);
fill(from);
rect(10, 20, 20, 60);
fill(interA);
rect(30, 20, 20, 60);
fill(interB);
rect(50, 20, 20, 60);
fill(to);
rect(70, 20, 20, 60);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>c1</code> interpolate from this color

"##]
///
///
#[doc = r##"<code>c2</code> interpolate to this color

"##]
///
///
#[doc = r##"<code>amt</code> number between 0 and 1

"##]
///

pub static lerpColor: LerpColorInternalType = LerpColorInternalType;
#[doc(hidden)]
pub struct LerpColorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lerpColor")]
    fn lerpColor961202270(_ : & Color, _ : & Color, _ : f64, ) ->  Color;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Color,f64,)> for LerpColorInternalType {
    type Output =  Color;
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Color,f64,)) -> Self::Output {
        lerpColor961202270.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Color,f64,)> for LerpColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Color,f64,)) -> Self::Output {
        lerpColor961202270.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Color,f64,)> for LerpColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Color,f64,)) -> Self::Output {
        lerpColor961202270.call(args)
    }
}
#[doc=r##"<p>Extracts the HSL lightness value from a color or pixel array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
colorMode(HSL);
let c = color(156, 100, 50, 1);
fill(c);
rect(15, 20, 35, 60);
let value = lightness(c); // Sets 'value' to 50
fill(value);
rect(50, 20, 35, 60);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static lightness: LightnessInternalType = LightnessInternalType;
#[doc(hidden)]
pub struct LightnessInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lightness")]
    fn lightness3772083704(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for LightnessInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        lightness3772083704.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for LightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        lightness3772083704.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for LightnessInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        lightness3772083704.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lightness")]
    fn lightness3208825503(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for LightnessInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        lightness3208825503.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for LightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        lightness3208825503.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for LightnessInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        lightness3208825503.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lightness")]
    fn lightness3617662242(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LightnessInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        lightness3617662242.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        lightness3617662242.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LightnessInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        lightness3617662242.call(args)
    }
}
#[doc=r##"<p>Extracts the red value from a color or pixel array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let c = color(255, 204, 0); // Define color 'c'
fill(c); // Use color variable 'c' as fill color
rect(15, 20, 35, 60); // Draw left rectangle

let redValue = red(c); // Get red in 'c'
print(redValue); // Print "255.0"
fill(redValue, 0, 0); // Use 'redValue' in new fill
rect(50, 20, 35, 60); // Draw right rectangle
```"###]
#[doc=r###"```rust
colorMode(RGB, 255); // Sets the range for red, green, and blue to 255
let c = color(127, 255, 0);
colorMode(RGB, 1); // Sets the range for red, green, and blue to 1
let myColor = red(c);
print(myColor); // 0.4980392156862745
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static red: RedInternalType = RedInternalType;
#[doc(hidden)]
pub struct RedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "red")]
    fn red3730130047(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for RedInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        red3730130047.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for RedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        red3730130047.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for RedInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        red3730130047.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "red")]
    fn red3945275644(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for RedInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        red3945275644.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for RedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        red3945275644.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for RedInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        red3945275644.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "red")]
    fn red3521520627(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for RedInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        red3521520627.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for RedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        red3521520627.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for RedInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        red3521520627.call(args)
    }
}
#[doc=r##"<p>Extracts the saturation value from a color or pixel array.</p>
<p>Saturation is scaled differently in HSB and HSL. This function will return
the HSB saturation when supplied with an HSB color object (or when supplied
with a pixel array while the color mode is HSB), but will default to the
HSL saturation otherwise.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noStroke();
colorMode(HSB, 255);
let c = color(0, 126, 255);
fill(c);
rect(15, 20, 35, 60);
let value = saturation(c); // Sets 'value' to 126
fill(value);
rect(50, 20, 35, 60);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>color</code> p5.Color object, color components,
                                        or CSS color

"##]
///

pub static saturation: SaturationInternalType = SaturationInternalType;
#[doc(hidden)]
pub struct SaturationInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saturation")]
    fn saturation1437837177(_ : & Color, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for SaturationInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        saturation1437837177.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for SaturationInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        saturation1437837177.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for SaturationInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        saturation1437837177.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saturation")]
    fn saturation4029856146(_ : & [f64], ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for SaturationInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        saturation4029856146.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for SaturationInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        saturation4029856146.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for SaturationInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        saturation4029856146.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saturation")]
    fn saturation1544709490(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SaturationInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        saturation1544709490.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SaturationInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        saturation1544709490.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SaturationInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        saturation1544709490.call(args)
    }
}
#[doc=r##"<p>Stores a value in local storage under the key name.
 Local storage is saved in the browser and persists
 between browsing sessions and page reloads.
 The key can be the name of the variable but doesn't
 have to be. To retrieve stored items
 see <a href="#/p5/getItem">getItem</a>.
Sensitive data such as passwords or personal information
 should not be stored in local storage.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 // Type to change the letter in the
 // center of the canvas.
 // If you reload the page, it will
 // still display the last key you entered
let myText;
function setup() {
   createCanvas(100, 100);
   myText = getItem('myText');
   if (myText === null) {
     myText = '';
   }
 }
function draw() {
   textSize(40);
   background(255);
   text(myText, width / 2, height / 2);
 }
function keyPressed() {
   myText = key;
   storeItem('myText', myText);
 }
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>key</code> 
"##]
///
///
#[doc = r##"<code>value</code> 
"##]
///

pub static storeItem: StoreItemInternalType = StoreItemInternalType;
#[doc(hidden)]
pub struct StoreItemInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "storeItem")]
    fn storeItem4113173554(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for StoreItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        storeItem4113173554.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for StoreItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        storeItem4113173554.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for StoreItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        storeItem4113173554.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "storeItem")]
    fn storeItem1284299563(_ : & str, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,)> for StoreItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,)) -> Self::Output {
        storeItem1284299563.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,)> for StoreItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,)) -> Self::Output {
        storeItem1284299563.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,)> for StoreItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,)) -> Self::Output {
        storeItem1284299563.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "storeItem")]
    fn storeItem3499518402(_ : & str, _ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,)> for StoreItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,)) -> Self::Output {
        storeItem3499518402.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,)> for StoreItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,)) -> Self::Output {
        storeItem3499518402.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,)> for StoreItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,)) -> Self::Output {
        storeItem3499518402.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "storeItem")]
    fn storeItem628929274(_ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,)> for StoreItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,)) -> Self::Output {
        storeItem628929274.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,)> for StoreItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,)) -> Self::Output {
        storeItem628929274.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,)> for StoreItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,)) -> Self::Output {
        storeItem628929274.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "storeItem")]
    fn storeItem717232080(_ : & str, _ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Color,)> for StoreItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Color,)) -> Self::Output {
        storeItem717232080.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Color,)> for StoreItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Color,)) -> Self::Output {
        storeItem717232080.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Color,)> for StoreItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Color,)) -> Self::Output {
        storeItem717232080.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "storeItem")]
    fn storeItem772879454(_ : & str, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,)> for StoreItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        storeItem772879454.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,)> for StoreItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        storeItem772879454.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,)> for StoreItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        storeItem772879454.call(args)
    }
}
#[doc=r##"<p>Returns the value of an item that was stored in local storage
 using storeItem()</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 // Click the mouse to change
 // the color of the background
 // Once you have changed the color
 // it will stay changed even when you
 // reload the page.
let myColor;
function setup() {
   createCanvas(100, 100);
   myColor = getItem('myColor');
 }
function draw() {
   if (myColor !== null) {
     background(myColor);
   }
 }
function mousePressed() {
   myColor = color(random(255), random(255), random(255));
   storeItem('myColor', myColor);
 }
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>key</code> name that you wish to use to store in local storage

"##]
///

pub static getItem: GetItemInternalType = GetItemInternalType;
#[doc(hidden)]
pub struct GetItemInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "getItem")]
    fn getItem1901660384(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for GetItemInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        getItem1901660384.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for GetItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        getItem1901660384.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for GetItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        getItem1901660384.call(args)
    }
}
#[doc=r##"<p>Clears all local storage items set with storeItem()
 for the current domain.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 function setup() {
   let myNum = 10;
   let myBool = false;
   storeItem('myNum', myNum);
   storeItem('myBool', myBool);
   print(getItem('myNum')); // logs 10 to the console
   print(getItem('myBool')); // logs false to the console
   clearStorage();
   print(getItem('myNum')); // logs null to the console
   print(getItem('myBool')); // logs null to the console
 }
 ```"###]

pub static clearStorage: ClearStorageInternalType = ClearStorageInternalType;
#[doc(hidden)]
pub struct ClearStorageInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "clearStorage")]
    fn clearStorage3178783879() ;
}

#[doc(hidden)]
impl FnOnce<()> for ClearStorageInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        clearStorage3178783879.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for ClearStorageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        clearStorage3178783879.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for ClearStorageInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        clearStorage3178783879.call(args)
    }
}
#[doc=r##"<p>Removes an item that was stored with storeItem()</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 function setup() {
   let myVar = 10;
   storeItem('myVar', myVar);
   print(getItem('myVar')); // logs 10 to the console
   removeItem('myVar');
   print(getItem('myVar')); // logs null to the console
 }
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>key</code> 
"##]
///

pub static removeItem: RemoveItemInternalType = RemoveItemInternalType;
#[doc(hidden)]
pub struct RemoveItemInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "removeItem")]
    fn removeItem997857833(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for RemoveItemInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        removeItem997857833.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for RemoveItemInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        removeItem997857833.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for RemoveItemInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        removeItem997857833.call(args)
    }
}
#[doc=r##"<p>Stops p5.js from continuously executing the code within <a href="#/p5/draw">draw()</a>.
If <a href="#/p5/loop">loop()</a> is called, the code in <a href="#/p5/draw">draw()</a>
begins to run continuously again. If using <a href="#/p5/noLoop">noLoop()</a>
in <a href="#/p5/setup">setup()</a>, it should be the last line inside the block.</p>
<p>When <a href="#/p5/noLoop">noLoop()</a> is used, it's not possible to manipulate
or access the screen inside event handling functions such as
<a href="#/p5/mousePressed">mousePressed()</a> or
<a href="#/p5/keyPressed">keyPressed()</a>. Instead, use those functions to
call <a href="#/p5/redraw">redraw()</a> or <a href="#/p5/loop">loop()</a>,
which will run <a href="#/p5/draw">draw()</a>, which can update the screen
properly. This means that when <a href="#/p5/noLoop">noLoop()</a> has been
called, no drawing can happen, and functions like <a href="#/p5/saveFrame">saveFrame()</a>
or <a href="#/p5/loadPixels">loadPixels()</a> may not be used.</p>
<p>Note that if the sketch is resized, <a href="#/p5/redraw">redraw()</a> will
be called to update the sketch, even after <a href="#/p5/noLoop">noLoop()</a>
has been specified. Otherwise, the sketch would enter an odd state until
<a href="#/p5/loop">loop()</a> was called.</p>
<p>Use <a href="#/p5/isLooping">isLooping()</a> to check current state of loop().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100);
  background(200);
  noLoop();
}

function draw() {
  line(10, 10, 90, 90);
}
```"###]
#[doc=r###"```rust
let x = 0;
function setup() {
  createCanvas(100, 100);
}

function draw() {
  background(204);
  x = x + 0.1;
  if (x > width) {
    x = 0;
  }
  line(x, 0, x, height);
}

function mousePressed() {
  noLoop();
}

function mouseReleased() {
  loop();
}
```"###]

pub static noLoop: NoLoopInternalType = NoLoopInternalType;
#[doc(hidden)]
pub struct NoLoopInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noLoop")]
    fn noLoop538356296() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoLoopInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noLoop538356296.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoLoopInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noLoop538356296.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoLoopInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noLoop538356296.call(args)
    }
}
#[doc=r##"<p>By default, p5.js loops through draw() continuously, executing the code within
it. However, the <a href="#/p5/draw">draw()</a> loop may be stopped by calling
<a href="#/p5/noLoop">noLoop()</a>. In that case, the <a href="#/p5/draw">draw()</a>
loop can be resumed with loop().</p>
<p>Avoid calling loop() from inside setup().</p>
<p>Use <a href="#/p5/isLooping">isLooping()</a> to check current state of loop().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let x = 0;
function setup() {
  createCanvas(100, 100);
  noLoop();
}

function draw() {
  background(204);
  x = x + 0.1;
  if (x > width) {
    x = 0;
  }
  line(x, 0, x, height);
}

function mousePressed() {
  loop();
}

function mouseReleased() {
  noLoop();
}
```"###]

pub static r#loop: RLoopInternalType = RLoopInternalType;
#[doc(hidden)]
pub struct RLoopInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "r#loop")]
    fn r#loop3298883363() ;
}

#[doc(hidden)]
impl FnOnce<()> for RLoopInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        r#loop3298883363.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RLoopInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        r#loop3298883363.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RLoopInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        r#loop3298883363.call(args)
    }
}
#[doc=r##"<p>By default, p5.js loops through <a href="#/p5/draw">draw()</a> continuously,
executing the code within it. If the sketch is stopped with
<a href="#/p5/noLoop">noLoop()</a> or resumed with <a href="#/p5/loop">loop()</a>,
isLooping() returns the current state for use within custom event handlers.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let checkbox, button, colBG, colFill;

function setup() {
  createCanvas(100, 100);

  button = createButton('Colorize if loop()');
  button.position(0, 120);
  button.mousePressed(changeBG);

  checkbox = createCheckbox('loop()', true);
  checkbox.changed(checkLoop);

  colBG = color(0);
  colFill = color(255);
}

function changeBG() {
  if (isLooping()) {
    colBG = color(random(255), random(255), random(255));
    colFill = color(random(255), random(255), random(255));
  }
}

function checkLoop() {
  if (this.checked()) {
    loop();
  } else {
    noLoop();
  }
}

function draw() {
  background(colBG);
  fill(colFill);
  ellipse(frameCount % width, height / 2, 50);
}
```"###]

pub static isLooping: IsLoopingInternalType = IsLoopingInternalType;
#[doc(hidden)]
pub struct IsLoopingInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "isLooping")]
    fn isLooping3045790815() ;
}

#[doc(hidden)]
impl FnOnce<()> for IsLoopingInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        isLooping3045790815.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for IsLoopingInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        isLooping3045790815.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for IsLoopingInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        isLooping3045790815.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/push">push()</a> function saves the current drawing style
settings and transformations, while <a href="#/p5/pop">pop()</a> restores these
settings. Note that these functions are always used together. They allow you to
change the style and transformation settings and later return to what you had.
When a new state is started with <a href="#/p5/push">push()</a>, it builds on
the current style and transform information. The <a href="#/p5/push">push()</a>
and <a href="#/p5/pop">pop()</a> functions can be embedded to provide more
control. (See the second example for a demonstration.)</p>
<p><a href="#/p5/push">push()</a> stores information related to the current transformation state
and style settings controlled by the following functions:
<a href="#/p5/fill">fill()</a>,
<a href="#/p5/noFill">noFill()</a>,
<a href="#/p5/noStroke">noStroke()</a>,
<a href="#/p5/stroke">stroke()</a>,
<a href="#/p5/tint">tint()</a>,
<a href="#/p5/noTint">noTint()</a>,
<a href="#/p5/strokeWeight">strokeWeight()</a>,
<a href="#/p5/strokeCap">strokeCap()</a>,
<a href="#/p5/strokeJoin">strokeJoin()</a>,
<a href="#/p5/imageMode">imageMode()</a>,
<a href="#/p5/rectMode">rectMode()</a>,
<a href="#/p5/ellipseMode">ellipseMode()</a>,
<a href="#/p5/colorMode">colorMode()</a>,
<a href="#/p5/textAlign">textAlign()</a>,
<a href="#/p5/textFont">textFont()</a>,
<a href="#/p5/textSize">textSize()</a>,
<a href="#/p5/textLeading">textLeading()</a>,
<a href="#/p5/applyMatrix">applyMatrix()</a>,
<a href="#/p5/resetMatrix">resetMatrix()</a>,
<a href="#/p5/rotate">rotate()</a>,
<a href="#/p5/scale">scale()</a>,
<a href="#/p5/shearX">shearX()</a>,
<a href="#/p5/shearY">shearY()</a>,
<a href="#/p5/translate">translate()</a>,
<a href="#/p5/noiseSeed">noiseSeed()</a>.</p>
<p>In WEBGL mode additional style settings are stored. These are controlled by the
following functions: <a href="#/p5/setCamera">setCamera()</a>,
<a href="#/p5/ambientLight">ambientLight()</a>,
<a href="#/p5/directionalLight">directionalLight()</a>,
<a href="#/p5/pointLight">pointLight()</a>, <a href="#/p5/texture">texture()</a>,
<a href="#/p5/specularMaterial">specularMaterial()</a>,
<a href="#/p5/shininess">shininess()</a>,
<a href="#/p5/normalMaterial">normalMaterial()</a>
and <a href="#/p5/shader">shader()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
ellipse(0, 50, 33, 33); // Left circle

push(); // Start a new drawing state
strokeWeight(10);
fill(204, 153, 0);
translate(50, 0);
ellipse(0, 50, 33, 33); // Middle circle
pop(); // Restore original state

ellipse(100, 50, 33, 33); // Right circle
```"###]
#[doc=r###"```rust
ellipse(0, 50, 33, 33); // Left circle

push(); // Start a new drawing state
strokeWeight(10);
fill(204, 153, 0);
ellipse(33, 50, 33, 33); // Left-middle circle

push(); // Start another new drawing state
stroke(0, 102, 153);
ellipse(66, 50, 33, 33); // Right-middle circle
pop(); // Restore previous state

pop(); // Restore original state

ellipse(100, 50, 33, 33); // Right circle
```"###]

pub static push: PushInternalType = PushInternalType;
#[doc(hidden)]
pub struct PushInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "push")]
    fn push1115498150() ;
}

#[doc(hidden)]
impl FnOnce<()> for PushInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        push1115498150.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for PushInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        push1115498150.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for PushInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        push1115498150.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/push">push()</a> function saves the current drawing style
settings and transformations, while <a href="#/p5/pop">pop()</a> restores
these settings. Note that these functions are always used together. They allow
you to change the style and transformation settings and later return to what
you had. When a new state is started with <a href="#/p5/push">push()</a>, it
builds on the current style and transform information. The <a href="#/p5/push">push()</a>
and <a href="#/p5/pop">pop()</a> functions can be embedded to provide more
control. (See the second example for a demonstration.)</p>
<p><a href="#/p5/push">push()</a> stores information related to the current transformation state
and style settings controlled by the following functions:
<a href="#/p5/fill">fill()</a>,
<a href="#/p5/noFill">noFill()</a>,
<a href="#/p5/noStroke">noStroke()</a>,
<a href="#/p5/stroke">stroke()</a>,
<a href="#/p5/tint">tint()</a>,
<a href="#/p5/noTint">noTint()</a>,
<a href="#/p5/strokeWeight">strokeWeight()</a>,
<a href="#/p5/strokeCap">strokeCap()</a>,
<a href="#/p5/strokeJoin">strokeJoin()</a>,
<a href="#/p5/imageMode">imageMode()</a>,
<a href="#/p5/rectMode">rectMode()</a>,
<a href="#/p5/ellipseMode">ellipseMode()</a>,
<a href="#/p5/colorMode">colorMode()</a>,
<a href="#/p5/textAlign">textAlign()</a>,
<a href="#/p5/textFont">textFont()</a>,
<a href="#/p5/textSize">textSize()</a>,
<a href="#/p5/textLeading">textLeading()</a>,
<a href="#/p5/applyMatrix">applyMatrix()</a>,
<a href="#/p5/resetMatrix">resetMatrix()</a>,
<a href="#/p5/rotate">rotate()</a>,
<a href="#/p5/scale">scale()</a>,
<a href="#/p5/shearX">shearX()</a>,
<a href="#/p5/shearY">shearY()</a>,
<a href="#/p5/translate">translate()</a>,
<a href="#/p5/noiseSeed">noiseSeed()</a>.</p>
<p>In WEBGL mode additional style settings are stored. These are controlled by
the following functions:
<a href="#/p5/setCamera">setCamera()</a>,
<a href="#/p5/ambientLight">ambientLight()</a>,
<a href="#/p5/directionalLight">directionalLight()</a>,
<a href="#/p5/pointLight">pointLight()</a>,
<a href="#/p5/texture">texture()</a>,
<a href="#/p5/specularMaterial">specularMaterial()</a>,
<a href="#/p5/shininess">shininess()</a>,
<a href="#/p5/normalMaterial">normalMaterial()</a> and
<a href="#/p5/shader">shader()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
ellipse(0, 50, 33, 33); // Left circle

push(); // Start a new drawing state
translate(50, 0);
strokeWeight(10);
fill(204, 153, 0);
ellipse(0, 50, 33, 33); // Middle circle
pop(); // Restore original state

ellipse(100, 50, 33, 33); // Right circle
```"###]
#[doc=r###"```rust
ellipse(0, 50, 33, 33); // Left circle

push(); // Start a new drawing state
strokeWeight(10);
fill(204, 153, 0);
ellipse(33, 50, 33, 33); // Left-middle circle

push(); // Start another new drawing state
stroke(0, 102, 153);
ellipse(66, 50, 33, 33); // Right-middle circle
pop(); // Restore previous state

pop(); // Restore original state

ellipse(100, 50, 33, 33); // Right circle
```"###]

pub static pop: PopInternalType = PopInternalType;
#[doc(hidden)]
pub struct PopInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pop")]
    fn pop3141922570() ;
}

#[doc(hidden)]
impl FnOnce<()> for PopInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        pop3141922570.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for PopInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        pop3141922570.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for PopInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        pop3141922570.call(args)
    }
}
#[doc=r##"<p>Executes the code within <a href="#/p5/draw">draw()</a> one time. This
function allows the program to update the display window only when necessary,
for example when an event registered by <a href="#/p5/mousePressed">mousePressed()</a>
or <a href="#/p5/keyPressed">keyPressed()</a> occurs.</p>
<p>In structuring a program, it only makes sense to call <a href="#/p5/redraw">redraw()</a>
within events such as <a href="#/p5/mousePressed">mousePressed()</a>. This
is because <a href="#/p5/redraw">redraw()</a> does not run
<a href="#/p5/draw">draw()</a> immediately (it only sets a flag that indicates
an update is needed).</p>
<p>The <a href="#/p5/redraw">redraw()</a> function does not work properly when
called inside <a href="#/p5/draw">draw()</a>.To enable/disable animations,
use <a href="#/p5/loop">loop()</a> and <a href="#/p5/noLoop">noLoop()</a>.</p>
<p>In addition you can set the number of redraws per method call. Just
add an integer as single parameter for the number of redraws.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let x = 0;

function setup() {
  createCanvas(100, 100);
  noLoop();
}

function draw() {
  background(204);
  line(x, 0, x, height);
}

function mousePressed() {
  x += 1;
  redraw();
}
```"###]
#[doc=r###"```rust
let x = 0;

function setup() {
  createCanvas(100, 100);
  noLoop();
}

function draw() {
  background(204);
  x += 1;
  line(x, 0, x, height);
}

function mousePressed() {
  redraw(5);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n?</code> Redraw for n-times. The default value is 1.

"##]
///

pub static redraw: RedrawInternalType = RedrawInternalType;
#[doc(hidden)]
pub struct RedrawInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "redraw")]
    fn redraw564499594(_ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(i32,)> for RedrawInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (i32,)) -> Self::Output {
        redraw564499594.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(i32,)> for RedrawInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (i32,)) -> Self::Output {
        redraw564499594.call(args)
    }
}

#[doc(hidden)]
impl Fn<(i32,)> for RedrawInternalType {
    extern "rust-call" fn call(&self, args: (i32,)) -> Self::Output {
        redraw564499594.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "redraw")]
    fn redraw2268040650() ;
}

#[doc(hidden)]
impl FnOnce<()> for RedrawInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        redraw2268040650.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for RedrawInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        redraw2268040650.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for RedrawInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        redraw2268040650.call(args)
    }
}
#[doc=r##"<p>The <code>p5()</code> constructor enables you to activate "instance mode" instead of normal
"global mode". This is an advanced topic. A short description and example is
included below. Please see
<a target="blank" href="https://www.youtube.com/watch?v=Su792jEauZg&feature=youtu.be">
Dan Shiffman's Coding Train video tutorial</a> or this
<a target="blank" href="https://github.com/processing/p5.js/wiki/p5.js-overview#instantiation--namespace">tutorial page</a>
for more info.</p>
<p>By default, all p5.js functions are in the global namespace (i.e. bound to the window
object), meaning you can call them simply <code>ellipse()</code>, <code>fill()</code>, etc. However, this
might be inconvenient if you are mixing with other JS libraries (synchronously or
asynchronously) or writing long programs of your own. p5.js currently supports a
way around this problem called "instance mode". In instance mode, all p5 functions
are bound up in a single variable instead of polluting your global namespace.</p>
<p>Optionally, you can specify a default container for the canvas and any other elements
to append to with a second argument. You can give the ID of an element in your html,
or an html node itself.</p>
<p>Note that creating instances like this also allows you to have more than one p5 sketch on
a single web page, as they will each be wrapped up with their own set up variables. Of
course, you could also use iframes to have multiple sketches in global mode.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
const s = p => {
  let x = 100;
  let y = 100;

  p.setup = function() {
    p.createCanvas(700, 410);
  };

  p.draw = function() {
    p.background(0);
    p.fill(255);
    p.rect(x, y, 50, 50);
  };
};

new p5(s); // invoke p5
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>sketch</code> a function containing a p5.js sketch

"##]
///
///
#[doc = r##"<code>node</code> ID or pointer to HTML DOM node to contain sketch in

"##]
///

pub static p5: P5InternalType = P5InternalType;
#[doc(hidden)]
pub struct P5InternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "p5")]
    fn p5833171748(_ : JsValue, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,)> for P5InternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,)) -> Self::Output {
        p5833171748.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,)> for P5InternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,)) -> Self::Output {
        p5833171748.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,)> for P5InternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,)) -> Self::Output {
        p5833171748.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "p5")]
    fn p53496952788(_ : JsValue, _ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,JsValue,)> for P5InternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,JsValue,)) -> Self::Output {
        p53496952788.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,JsValue,)> for P5InternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,JsValue,)) -> Self::Output {
        p53496952788.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,JsValue,)> for P5InternalType {
    extern "rust-call" fn call(&self, args: (JsValue,JsValue,)) -> Self::Output {
        p53496952788.call(args)
    }
}
#[doc=r##"<p>Creates an ambient light with a color. Ambient light is light that comes from everywhere on the canvas.
It has no particular source.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
createCanvas(100, 100, WEBGL);
ambientLight(0);
ambientMaterial(250);
sphere(40);
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(51);
  ambientLight(100); // white light
  ambientMaterial(255, 102, 94); // magenta material
  box(30);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>alpha?</code> the alpha value

"##]
///
///
/// ---
///
///
#[doc = r##"<code>value</code> a color string

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gray</code> a gray value

"##]
///
///
#[doc = r##"<code>alpha?</code> the alpha value

"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red,green,blue &
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> the ambient light color

"##]
///
///
/// ---
///

pub static ambientLight: AmbientLightInternalType = AmbientLightInternalType;
#[doc(hidden)]
pub struct AmbientLightInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight264979927(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        ambientLight264979927.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        ambientLight264979927.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        ambientLight264979927.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight1030369908(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        ambientLight1030369908.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        ambientLight1030369908.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        ambientLight1030369908.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight564210670(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        ambientLight564210670.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        ambientLight564210670.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        ambientLight564210670.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight4261199237(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        ambientLight4261199237.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        ambientLight4261199237.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        ambientLight4261199237.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight3917054215(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        ambientLight3917054215.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        ambientLight3917054215.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        ambientLight3917054215.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight2583764148(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        ambientLight2583764148.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        ambientLight2583764148.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        ambientLight2583764148.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ambientLight")]
    fn ambientLight3014577676(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for AmbientLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        ambientLight3014577676.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for AmbientLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        ambientLight3014577676.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for AmbientLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        ambientLight3014577676.call(args)
    }
}
#[doc=r##"<p>Set's the color of the specular highlight when using a specular material and
specular light.</p>
<p>This method can be combined with specularMaterial() and shininess()
functions to set specular highlights. The default color is white, ie
(255, 255, 255), which is used if this method is not called before
specularMaterial(). If this method is called without specularMaterial(),
There will be no effect.</p>
<p>Note: specularColor is equivalent to the processing function
<a href="https://processing.org/reference/lightSpecular_.html">lightSpecular</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  noStroke();
}

function draw() {
  background(0);
  shininess(20);
  ambientLight(50);
  specularColor(255, 0, 0);
  pointLight(255, 0, 0, 0, -50, 50);
  specularColor(0, 255, 0);
  pointLight(0, 255, 0, 0, 50, 50);
  specularMaterial(255);
  sphere(40);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value relative to
                                the current color range

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value
                                relative to the current color range

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value
                                relative to the current color range

"##]
///
///
/// ---
///
///
#[doc = r##"<code>value</code> a color string

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gray</code> a gray value

"##]
///
///
/// ---
///
///
#[doc = r##"<code>values</code> an array containing the red,green,blue &
                                and alpha components of the color

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> the ambient light color

"##]
///
///
/// ---
///

pub static specularColor: SpecularColorInternalType = SpecularColorInternalType;
#[doc(hidden)]
pub struct SpecularColorInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularColor")]
    fn specularColor2703518711(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for SpecularColorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        specularColor2703518711.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for SpecularColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        specularColor2703518711.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for SpecularColorInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        specularColor2703518711.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularColor")]
    fn specularColor3312087972(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SpecularColorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        specularColor3312087972.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SpecularColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        specularColor3312087972.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SpecularColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        specularColor3312087972.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularColor")]
    fn specularColor3662165415(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SpecularColorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        specularColor3662165415.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SpecularColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        specularColor3662165415.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SpecularColorInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        specularColor3662165415.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularColor")]
    fn specularColor3811383337(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for SpecularColorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        specularColor3811383337.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for SpecularColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        specularColor3811383337.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for SpecularColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        specularColor3811383337.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "specularColor")]
    fn specularColor1321806907(_ : & Color, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,)> for SpecularColorInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,)) -> Self::Output {
        specularColor1321806907.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,)> for SpecularColorInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,)) -> Self::Output {
        specularColor1321806907.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,)> for SpecularColorInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,)) -> Self::Output {
        specularColor1321806907.call(args)
    }
}
#[doc=r##"<p>Creates a directional light with a color and a direction</p>
<p>A maximum of 5 directionalLight can be active at one time</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  //move your mouse to change light direction
  let dirX = (mouseX / width - 0.5) * 2;
  let dirY = (mouseY / height - 0.5) * 2;
  directionalLight(250, 250, 250, -dirX, -dirY, -1);
  noStroke();
  sphere(40);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>position</code> the direction of the light

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
                                            or p5.Color value

"##]
///
///
#[doc = r##"<code>x</code> x axis direction

"##]
///
///
#[doc = r##"<code>y</code> y axis direction

"##]
///
///
#[doc = r##"<code>z</code> z axis direction

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
                                            or p5.Color value

"##]
///
///
#[doc = r##"<code>position</code> the direction of the light

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>x</code> x axis direction

"##]
///
///
#[doc = r##"<code>y</code> y axis direction

"##]
///
///
#[doc = r##"<code>z</code> z axis direction

"##]
///
///
/// ---
///

pub static directionalLight: DirectionalLightInternalType = DirectionalLightInternalType;
#[doc(hidden)]
pub struct DirectionalLightInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight3207987357(_ : f64, _ : f64, _ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,)) -> Self::Output {
        directionalLight3207987357.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,)) -> Self::Output {
        directionalLight3207987357.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,)) -> Self::Output {
        directionalLight3207987357.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight854581901(_ : & [f64], _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,)) -> Self::Output {
        directionalLight854581901.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,)) -> Self::Output {
        directionalLight854581901.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,)) -> Self::Output {
        directionalLight854581901.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight1594715861(_ : & str, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        directionalLight1594715861.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        directionalLight1594715861.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        directionalLight1594715861.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight3830959573(_ : & Color, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,)) -> Self::Output {
        directionalLight3830959573.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,)) -> Self::Output {
        directionalLight3830959573.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,)) -> Self::Output {
        directionalLight3830959573.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight1069429165(_ : & [f64], _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,)) -> Self::Output {
        directionalLight1069429165.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,)) -> Self::Output {
        directionalLight1069429165.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,)) -> Self::Output {
        directionalLight1069429165.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight3986974955(_ : & str, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        directionalLight3986974955.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        directionalLight3986974955.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        directionalLight3986974955.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight2575269121(_ : & Color, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,)) -> Self::Output {
        directionalLight2575269121.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,)) -> Self::Output {
        directionalLight2575269121.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,)) -> Self::Output {
        directionalLight2575269121.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "directionalLight")]
    fn directionalLight211217796(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for DirectionalLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        directionalLight211217796.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        directionalLight211217796.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for DirectionalLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        directionalLight211217796.call(args)
    }
}
#[doc=r##"<p>Creates a point light with a color and a light position</p>
<p>A maximum of 5 pointLight can be active at one time</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  //move your mouse to change light position
  let locX = mouseX - width / 2;
  let locY = mouseY - height / 2;
  // to set the light position,
  // think of the world's coordinate as:
  // -width/2,-height/2 -------- width/2,-height/2
  //                |            |
  //                |     0,0    |
  //                |            |
  // -width/2,height/2--------width/2,height/2
  pointLight(250, 250, 250, locX, locY, 50);
  noStroke();
  sphere(40);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>x</code> x axis position

"##]
///
///
#[doc = r##"<code>y</code> y axis position

"##]
///
///
#[doc = r##"<code>z</code> z axis position

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>position</code> the position of the light

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
or p5.Color value

"##]
///
///
#[doc = r##"<code>x</code> x axis position

"##]
///
///
#[doc = r##"<code>y</code> y axis position

"##]
///
///
#[doc = r##"<code>z</code> z axis position

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
or p5.Color value

"##]
///
///
#[doc = r##"<code>position</code> the position of the light

"##]
///
///
/// ---
///

pub static pointLight: PointLightInternalType = PointLightInternalType;
#[doc(hidden)]
pub struct PointLightInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight882938072(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        pointLight882938072.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        pointLight882938072.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        pointLight882938072.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight2980930638(_ : f64, _ : f64, _ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,)) -> Self::Output {
        pointLight2980930638.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,)) -> Self::Output {
        pointLight2980930638.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,)) -> Self::Output {
        pointLight2980930638.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight3965194534(_ : & [f64], _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,)) -> Self::Output {
        pointLight3965194534.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,)) -> Self::Output {
        pointLight3965194534.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,)) -> Self::Output {
        pointLight3965194534.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight2103117131(_ : & str, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        pointLight2103117131.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        pointLight2103117131.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,)) -> Self::Output {
        pointLight2103117131.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight3488473115(_ : & Color, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,)) -> Self::Output {
        pointLight3488473115.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,)) -> Self::Output {
        pointLight3488473115.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,)) -> Self::Output {
        pointLight3488473115.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight2812934801(_ : & [f64], _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,)) -> Self::Output {
        pointLight2812934801.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,)) -> Self::Output {
        pointLight2812934801.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,)) -> Self::Output {
        pointLight2812934801.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight2012919146(_ : & str, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        pointLight2012919146.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        pointLight2012919146.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,)) -> Self::Output {
        pointLight2012919146.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "pointLight")]
    fn pointLight1394103085(_ : & Color, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,)> for PointLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,)) -> Self::Output {
        pointLight1394103085.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,)) -> Self::Output {
        pointLight1394103085.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,)> for PointLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,)) -> Self::Output {
        pointLight1394103085.call(args)
    }
}
#[doc=r##"<p>Sets the default ambient and directional light. The defaults are <a href="#/p5/ambientLight">ambientLight(128, 128, 128)</a> and <a href="#/p5/directionalLight">directionalLight(128, 128, 128, 0, 0, -1)</a>. Lights need to be included in the <a href="#/p5/draw">draw()</a> to remain persistent in a looping program. Placing them in the <a href="#/p5/setup">setup()</a> of a looping program will cause them to only have an effect the first time through the loop.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  lights();
  rotateX(millis() / 1000);
  rotateY(millis() / 1000);
  rotateZ(millis() / 1000);
  box();
}
```"###]

pub static lights: LightsInternalType = LightsInternalType;
#[doc(hidden)]
pub struct LightsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lights")]
    fn lights3739958075() ;
}

#[doc(hidden)]
impl FnOnce<()> for LightsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        lights3739958075.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for LightsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        lights3739958075.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for LightsInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        lights3739958075.call(args)
    }
}
#[doc=r##"<p>Sets the falloff rates for point lights. It affects only the elements which are created after it in the code.
The default value is lightFalloff(1.0, 0.0, 0.0), and the parameters are used to calculate the falloff with the following equation:</p>
<p>d = distance from light position to vertex position</p>
<p>falloff = 1 / (CONSTANT + d * LINEAR + ( d * d ) * QUADRATIC)</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  noStroke();
}
function draw() {
  background(0);
  let locX = mouseX - width / 2;
  let locY = mouseY - height / 2;
  translate(-25, 0, 0);
  lightFalloff(1, 0, 0);
  pointLight(250, 250, 250, locX, locY, 50);
  sphere(20);
  translate(50, 0, 0);
  lightFalloff(0.9, 0.01, 0);
  pointLight(250, 250, 250, locX, locY, 50);
  sphere(20);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>constant</code> constant value for determining falloff

"##]
///
///
#[doc = r##"<code>linear</code> linear value for determining falloff

"##]
///
///
#[doc = r##"<code>quadratic</code> quadratic value for determining falloff

"##]
///

pub static lightFalloff: LightFalloffInternalType = LightFalloffInternalType;
#[doc(hidden)]
pub struct LightFalloffInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "lightFalloff")]
    fn lightFalloff1050281091(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for LightFalloffInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        lightFalloff1050281091.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for LightFalloffInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        lightFalloff1050281091.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for LightFalloffInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        lightFalloff1050281091.call(args)
    }
}
#[doc=r##"<p>Creates a spotlight with a given color, position, direction of light,
angle and concentration. Here, angle refers to the opening or aperture
of the cone of the spotlight, and concentration is used to focus the
light towards the center. Both angle and concentration are optional, but if
you want to provide concentration, you will also have to specify the angle.</p>
<p>A maximum of 5 spotLight can be active at one time</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  //move your mouse to change light position
  let locX = mouseX - width / 2;
  let locY = mouseY - height / 2;
  // to set the light position,
  // think of the world's coordinate as:
  // -width/2,-height/2 -------- width/2,-height/2
  //                |            |
  //                |     0,0    |
  //                |            |
  // -width/2,height/2--------width/2,height/2
  ambientLight(50);
  spotLight(0, 250, 0, locX, locY, 100, 0, 0, -1, Math.PI / 16);
  noStroke();
  sphere(40);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>x</code> x axis position

"##]
///
///
#[doc = r##"<code>y</code> y axis position

"##]
///
///
#[doc = r##"<code>z</code> z axis position

"##]
///
///
#[doc = r##"<code>rx</code> x axis direction of light

"##]
///
///
#[doc = r##"<code>ry</code> y axis direction of light

"##]
///
///
#[doc = r##"<code>rz</code> z axis direction of light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
or p5.Color value

"##]
///
///
#[doc = r##"<code>position</code> the position of the light

"##]
///
///
#[doc = r##"<code>direction</code> the direction of the light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>position</code> the position of the light

"##]
///
///
#[doc = r##"<code>direction</code> the direction of the light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
or p5.Color value

"##]
///
///
#[doc = r##"<code>x</code> x axis position

"##]
///
///
#[doc = r##"<code>y</code> y axis position

"##]
///
///
#[doc = r##"<code>z</code> z axis position

"##]
///
///
#[doc = r##"<code>direction</code> the direction of the light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
or p5.Color value

"##]
///
///
#[doc = r##"<code>position</code> the position of the light

"##]
///
///
#[doc = r##"<code>rx</code> x axis direction of light

"##]
///
///
#[doc = r##"<code>ry</code> y axis direction of light

"##]
///
///
#[doc = r##"<code>rz</code> z axis direction of light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>x</code> x axis position

"##]
///
///
#[doc = r##"<code>y</code> y axis position

"##]
///
///
#[doc = r##"<code>z</code> z axis position

"##]
///
///
#[doc = r##"<code>direction</code> the direction of the light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>v1</code> red or hue value (depending on the current
color mode),

"##]
///
///
#[doc = r##"<code>v2</code> green or saturation value

"##]
///
///
#[doc = r##"<code>v3</code> blue or brightness value

"##]
///
///
#[doc = r##"<code>position</code> the position of the light

"##]
///
///
#[doc = r##"<code>rx</code> x axis direction of light

"##]
///
///
#[doc = r##"<code>ry</code> y axis direction of light

"##]
///
///
#[doc = r##"<code>rz</code> z axis direction of light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///
///
#[doc = r##"<code>color</code> color Array, CSS color string,
or p5.Color value

"##]
///
///
#[doc = r##"<code>x</code> x axis position

"##]
///
///
#[doc = r##"<code>y</code> y axis position

"##]
///
///
#[doc = r##"<code>z</code> z axis position

"##]
///
///
#[doc = r##"<code>rx</code> x axis direction of light

"##]
///
///
#[doc = r##"<code>ry</code> y axis direction of light

"##]
///
///
#[doc = r##"<code>rz</code> z axis direction of light

"##]
///
///
#[doc = r##"<code>angle?</code> optional parameter for angle. Defaults to PI/3

"##]
///
///
#[doc = r##"<code>conc?</code> optional parameter for concentration. Defaults to 100

"##]
///
///
/// ---
///

pub static spotLight: SpotLightInternalType = SpotLightInternalType;
#[doc(hidden)]
pub struct SpotLightInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1308801150(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1308801150.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1308801150.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1308801150.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight4140842868(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight4140842868.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight4140842868.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight4140842868.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2362751213(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2362751213.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2362751213.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2362751213.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3171394915(_ : & [f64], _ : & Vector, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3171394915.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3171394915.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3171394915.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3375071488(_ : & [f64], _ : & Vector, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight3375071488.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight3375071488.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight3375071488.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2697552092(_ : & [f64], _ : & Vector, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight2697552092.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight2697552092.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight2697552092.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1123030294(_ : & str, _ : & Vector, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight1123030294.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight1123030294.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight1123030294.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1699260810(_ : & str, _ : & Vector, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight1699260810.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight1699260810.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight1699260810.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight369901195(_ : & str, _ : & Vector, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight369901195.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight369901195.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight369901195.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2889914109(_ : & Color, _ : & Vector, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight2889914109.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight2889914109.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight2889914109.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight309896609(_ : & Color, _ : & Vector, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight309896609.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight309896609.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight309896609.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight892840671(_ : & Color, _ : & Vector, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight892840671.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight892840671.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight892840671.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3572262150(_ : f64, _ : f64, _ : f64, _ : & Vector, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3572262150.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3572262150.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3572262150.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3860252111(_ : f64, _ : f64, _ : f64, _ : & Vector, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight3860252111.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight3860252111.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,f64,)) -> Self::Output {
        spotLight3860252111.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3249436797(_ : f64, _ : f64, _ : f64, _ : & Vector, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight3249436797.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight3249436797.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,&'_ Vector,)) -> Self::Output {
        spotLight3249436797.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1644356978(_ : & [f64], _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight1644356978.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight1644356978.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight1644356978.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight745842001(_ : & [f64], _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight745842001.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight745842001.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight745842001.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3296226736(_ : & [f64], _ : f64, _ : f64, _ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight3296226736.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight3296226736.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight3296226736.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3712072760(_ : & str, _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3712072760.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3712072760.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3712072760.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3954297721(_ : & str, _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight3954297721.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight3954297721.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight3954297721.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight4094990181(_ : & str, _ : f64, _ : f64, _ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight4094990181.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight4094990181.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight4094990181.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight67627449(_ : & Color, _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight67627449.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight67627449.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight67627449.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2703603675(_ : & Color, _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight2703603675.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight2703603675.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight2703603675.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1622927813(_ : & Color, _ : f64, _ : f64, _ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight1622927813.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight1622927813.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight1622927813.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3711218125(_ : & [f64], _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3711218125.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3711218125.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3711218125.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3457922688(_ : & [f64], _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3457922688.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3457922688.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3457922688.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2356023299(_ : & [f64], _ : & Vector, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight2356023299.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight2356023299.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight2356023299.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3316204128(_ : & str, _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3316204128.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3316204128.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3316204128.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3012809455(_ : & str, _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3012809455.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3012809455.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3012809455.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3098058974(_ : & str, _ : & Vector, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight3098058974.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight3098058974.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight3098058974.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight909010766(_ : & Color, _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight909010766.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight909010766.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight909010766.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2773604094(_ : & Color, _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2773604094.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2773604094.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2773604094.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3923904160(_ : & Color, _ : & Vector, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight3923904160.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight3923904160.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight3923904160.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3040105239(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3040105239.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3040105239.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,&'_ Vector,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,f64,f64,)) -> Self::Output {
        spotLight3040105239.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight4186198688(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight4186198688.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight4186198688.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,&'_ Vector,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,f64,)) -> Self::Output {
        spotLight4186198688.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight852905730(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : & Vector, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight852905730.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight852905730.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,&'_ Vector,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,&'_ Vector,)) -> Self::Output {
        spotLight852905730.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2138466943(_ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2138466943.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2138466943.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2138466943.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1123935226(_ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1123935226.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1123935226.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1123935226.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight72216051(_ : f64, _ : f64, _ : f64, _ : & Vector, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight72216051.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight72216051.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,&'_ Vector,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,&'_ Vector,f64,f64,f64,)) -> Self::Output {
        spotLight72216051.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2833750077(_ : & [f64], _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2833750077.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2833750077.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2833750077.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3843546550(_ : & [f64], _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3843546550.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3843546550.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3843546550.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1185569178(_ : & [f64], _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1185569178.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1185569178.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1185569178.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2797787561(_ : & str, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2797787561.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2797787561.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2797787561.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2955521624(_ : & str, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2955521624.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2955521624.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2955521624.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight3421692463(_ : & str, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3421692463.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3421692463.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight3421692463.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight1884373168(_ : & Color, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1884373168.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1884373168.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight1884373168.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight896594924(_ : & Color, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight896594924.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight896594924.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight896594924.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "spotLight")]
    fn spotLight2705526750(_ : & Color, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Color,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2705526750.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Color,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2705526750.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Color,f64,f64,f64,f64,f64,f64,)> for SpotLightInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Color,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        spotLight2705526750.call(args)
    }
}
#[doc=r##"<p>This function will remove all the lights from the sketch for the
subsequent materials rendered. It affects all the subsequent methods.
Calls to lighting methods made after noLights() will re-enable lights
in the sketch.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
}
function draw() {
  background(0);
  noStroke();

  ambientLight(150, 0, 0);
  translate(-25, 0, 0);
  ambientMaterial(250);
  sphere(20);

  noLights();
  ambientLight(0, 150, 0);
  translate(50, 0, 0);
  ambientMaterial(250);
  sphere(20);
}
```"###]

pub static noLights: NoLightsInternalType = NoLightsInternalType;
#[doc(hidden)]
pub struct NoLightsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noLights")]
    fn noLights1701882882() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoLightsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noLights1701882882.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoLightsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noLights1701882882.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoLightsInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noLights1701882882.call(args)
    }
}
#[doc=r##"<p>Load a 3d model from an OBJ or STL file.</p>
<p><a href="#/p5/loadModel">loadModel()</a> should be placed inside of <a href="#/p5/preload">preload()</a>.
This allows the model to load fully before the rest of your code is run.</p>
<p>One of the limitations of the OBJ and STL format is that it doesn't have a built-in
sense of scale. This means that models exported from different programs might
be very different sizes. If your model isn't displaying, try calling
<a href="#/p5/loadModel">loadModel()</a> with the normalized parameter set to true. This will resize the
model to a scale appropriate for p5. You can also make additional changes to
the final size of your model with the <a href="#/p5/scale">scale()</a> function.</p>
<p>Also, the support for colored STL files is not present. STL files with color will be
rendered without color properties.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
//draw a spinning octahedron
let octahedron;

function preload() {
  octahedron = loadModel('assets/octahedron.obj');
}

function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  model(octahedron);
}
```"###]
#[doc=r###"```rust
//draw a spinning teapot
let teapot;

function preload() {
  // Load model with normalise parameter set to true
  teapot = loadModel('assets/teapot.obj', true);
}

function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  scale(0.4); // Scaled to make model fit into canvas
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  normalMaterial(); // For effect
  model(teapot);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>path</code> Path of the model to be loaded

"##]
///
///
#[doc = r##"<code>normalize</code> If true, scale the model to a
                                     standardized size when loading

"##]
///
///
#[doc = r##"<code>successCallback?</code> Function to be called
                                    once the model is loaded. Will be passed
                                    the 3D model object.

"##]
///
///
#[doc = r##"<code>failureCallback?</code> called with event error if
                                        the model fails to load.

"##]
///
///
#[doc = r##"<code>fileType?</code> The file extension of the model
                                     (.stl, .obj).

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> Path of the model to be loaded

"##]
///
///
#[doc = r##"<code>successCallback?</code> Function to be called
                                    once the model is loaded. Will be passed
                                    the 3D model object.

"##]
///
///
#[doc = r##"<code>failureCallback?</code> called with event error if
                                        the model fails to load.

"##]
///
///
#[doc = r##"<code>fileType?</code> The file extension of the model
                                     (.stl, .obj).

"##]
///
///
/// ---
///

pub static loadModel: LoadModelInternalType = LoadModelInternalType;
#[doc(hidden)]
pub struct LoadModelInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel3284087574(_ : & str, _ : bool, _ : js_sys::Function, _ : js_sys::Function, _ : & str, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,js_sys::Function,&'_ str,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,&'_ str,)) -> Self::Output {
        loadModel3284087574.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,js_sys::Function,&'_ str,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,&'_ str,)) -> Self::Output {
        loadModel3284087574.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,js_sys::Function,&'_ str,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,&'_ str,)) -> Self::Output {
        loadModel3284087574.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel3744074438(_ : & str, _ : bool, _ : js_sys::Function, _ : js_sys::Function, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadModel3744074438.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadModel3744074438.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadModel3744074438.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel2987058576(_ : & str, _ : bool, _ : js_sys::Function, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        loadModel2987058576.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        loadModel2987058576.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        loadModel2987058576.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel3138280052(_ : & str, _ : bool, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,)) -> Self::Output {
        loadModel3138280052.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,)) -> Self::Output {
        loadModel3138280052.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,)) -> Self::Output {
        loadModel3138280052.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel3646612048(_ : & str, _ : js_sys::Function, _ : js_sys::Function, _ : & str, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,&'_ str,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,&'_ str,)) -> Self::Output {
        loadModel3646612048.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,&'_ str,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,&'_ str,)) -> Self::Output {
        loadModel3646612048.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,&'_ str,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,&'_ str,)) -> Self::Output {
        loadModel3646612048.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel3660669488(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadModel3660669488.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadModel3660669488.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadModel3660669488.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel2484836372(_ : & str, _ : js_sys::Function, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadModel2484836372.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadModel2484836372.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadModel2484836372.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadModel")]
    fn loadModel4061679869(_ : & str, ) ->  Geometry;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadModelInternalType {
    type Output =  Geometry;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadModel4061679869.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadModel4061679869.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadModel4061679869.call(args)
    }
}
#[doc=r##"<p>Render a 3d model to the screen.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
//draw a spinning octahedron
let octahedron;

function preload() {
  octahedron = loadModel('assets/octahedron.obj');
}

function setup() {
  createCanvas(100, 100, WEBGL);
}

function draw() {
  background(200);
  rotateX(frameCount * 0.01);
  rotateY(frameCount * 0.01);
  model(octahedron);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>model</code> Loaded 3d model to be rendered

"##]
///

pub static model: ModelInternalType = ModelInternalType;
#[doc(hidden)]
pub struct ModelInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "model")]
    fn model813207277(_ : & Geometry, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Geometry,)> for ModelInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Geometry,)) -> Self::Output {
        model813207277.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Geometry,)> for ModelInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Geometry,)) -> Self::Output {
        model813207277.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Geometry,)> for ModelInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Geometry,)) -> Self::Output {
        model813207277.call(args)
    }
}
#[doc=r##"<p>Converts a string to its floating point representation. The contents of a
string must resemble a number, or NaN (not a number) will be returned.
For example, float("1234.56") evaluates to 1234.56, but float("giraffe")
will return NaN.</p>
<p>When an array of values is passed in, then an array of floats of the same
length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let str = '20';
let diameter = float(str);
ellipse(width / 2, height / 2, diameter, diameter);
```"###]
#[doc=r###"```rust
print(float('10.31')); // 10.31
print(float('Infinity')); // Infinity
print(float('-Infinity')); // -Infinity
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>str</code> float string to parse

"##]
///

pub static float: FloatInternalType = FloatInternalType;
#[doc(hidden)]
pub struct FloatInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "float")]
    fn float3541251080(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for FloatInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        float3541251080.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for FloatInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        float3541251080.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for FloatInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        float3541251080.call(args)
    }
}
#[doc=r##"<p>Converts a boolean, string, or float to its integer representation.
When an array of values is passed in, then an int array of the same length
is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(int('10')); // 10
print(int(10.31)); // 10
print(int(-10)); // -10
print(int(true)); // 1
print(int(false)); // 0
print(int([false, true, '10.3', 9.8])); // [0, 1, 10, 9]
print(int(Infinity)); // Infinity
print(int('-Infinity')); // -Infinity
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///
///
#[doc = r##"<code>radix?</code> the radix to convert to (default: 10)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>ns</code> values to parse

"##]
///
///
/// ---
///

pub static int: IntInternalType = IntInternalType;
#[doc(hidden)]
pub struct IntInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int364430369(_ : & str, _ : i32, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,i32,)> for IntInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,i32,)) -> Self::Output {
        int364430369.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,i32,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,i32,)) -> Self::Output {
        int364430369.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,i32,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,i32,)) -> Self::Output {
        int364430369.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int1113836105(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for IntInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        int1113836105.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        int1113836105.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        int1113836105.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int2616980441(_ : bool, _ : i32, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(bool,i32,)> for IntInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (bool,i32,)) -> Self::Output {
        int2616980441.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,i32,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,i32,)) -> Self::Output {
        int2616980441.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,i32,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (bool,i32,)) -> Self::Output {
        int2616980441.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int2286569230(_ : bool, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for IntInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        int2286569230.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        int2286569230.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        int2286569230.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int1206893810(_ : f64, _ : i32, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,i32,)> for IntInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,i32,)) -> Self::Output {
        int1206893810.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,i32,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,i32,)) -> Self::Output {
        int1206893810.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,i32,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (f64,i32,)) -> Self::Output {
        int1206893810.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int705357487(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for IntInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        int705357487.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        int705357487.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        int705357487.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "int")]
    fn int1739044027(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for IntInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        int1739044027.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for IntInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        int1739044027.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for IntInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        int1739044027.call(args)
    }
}
#[doc=r##"<p>Converts a boolean, string or number to its string representation.
When an array of values is passed in, then an array of strings of the same
length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(str('10')); // "10"
print(str(10.31)); // "10.31"
print(str(-10)); // "-10"
print(str(true)); // "true"
print(str(false)); // "false"
print(str([true, '10.3', 9.8])); // [ "true", "10.3", "9.8" ]
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///

pub static str: StrInternalType = StrInternalType;
#[doc(hidden)]
pub struct StrInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "str")]
    fn str3633901085(_ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for StrInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        str3633901085.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for StrInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        str3633901085.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for StrInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        str3633901085.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "str")]
    fn str3942742964(_ : bool, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for StrInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        str3942742964.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for StrInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        str3942742964.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for StrInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        str3942742964.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "str")]
    fn str1736560206(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for StrInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        str1736560206.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for StrInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        str1736560206.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for StrInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        str1736560206.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "str")]
    fn str3512922021(_ : js_sys::Array, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for StrInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        str3512922021.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for StrInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        str3512922021.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for StrInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        str3512922021.call(args)
    }
}
#[doc=r##"<p>Converts a number or string to its boolean representation.
For a number, any non-zero value (positive or negative) evaluates to true,
while zero evaluates to false. For a string, the value "true" evaluates to
true, while any other value evaluates to false. When an array of number or
string values is passed in, then a array of booleans of the same length is
returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(boolean(0)); // false
print(boolean(1)); // true
print(boolean('true')); // true
print(boolean('abcd')); // false
print(boolean([0, 12, 'true'])); // [false, true, true]
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///

pub static boolean: BooleanInternalType = BooleanInternalType;
#[doc(hidden)]
pub struct BooleanInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "boolean")]
    fn boolean3951030036(_ : & str, ) -> bool;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for BooleanInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        boolean3951030036.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for BooleanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        boolean3951030036.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for BooleanInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        boolean3951030036.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "boolean")]
    fn boolean84320844(_ : bool, ) -> bool;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for BooleanInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        boolean84320844.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for BooleanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        boolean84320844.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for BooleanInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        boolean84320844.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "boolean")]
    fn boolean2563413168(_ : f64, ) -> bool;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for BooleanInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        boolean2563413168.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for BooleanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        boolean2563413168.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for BooleanInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        boolean2563413168.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "boolean")]
    fn boolean2629180668(_ : js_sys::Array, ) -> bool;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for BooleanInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        boolean2629180668.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for BooleanInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        boolean2629180668.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for BooleanInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        boolean2629180668.call(args)
    }
}
#[doc=r##"<p>Converts a number, string representation of a number, or boolean to its byte
representation. A byte can be only a whole number between -128 and 127, so
when a value outside of this range is converted, it wraps around to the
corresponding byte representation. When an array of number, string or boolean
values is passed in, then an array of bytes the same length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(byte(127)); // 127
print(byte(128)); // -128
print(byte(23.4)); // 23
print(byte('23.4')); // 23
print(byte('hello')); // NaN
print(byte(true)); // 1
print(byte([0, 255, '100'])); // [0, -1, 100]
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///
///
/// ---
///
///
#[doc = r##"<code>ns</code> values to parse

"##]
///
///
/// ---
///

pub static byte: ByteInternalType = ByteInternalType;
#[doc(hidden)]
pub struct ByteInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "byte")]
    fn byte276735682(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for ByteInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        byte276735682.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for ByteInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        byte276735682.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for ByteInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        byte276735682.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "byte")]
    fn byte808577236(_ : bool, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(bool,)> for ByteInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (bool,)) -> Self::Output {
        byte808577236.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(bool,)> for ByteInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (bool,)) -> Self::Output {
        byte808577236.call(args)
    }
}

#[doc(hidden)]
impl Fn<(bool,)> for ByteInternalType {
    extern "rust-call" fn call(&self, args: (bool,)) -> Self::Output {
        byte808577236.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "byte")]
    fn byte3271537786(_ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for ByteInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        byte3271537786.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for ByteInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        byte3271537786.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for ByteInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        byte3271537786.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "byte")]
    fn byte3521256876(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for ByteInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        byte3521256876.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for ByteInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        byte3521256876.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for ByteInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        byte3521256876.call(args)
    }
}
#[doc=r##"<p>Converts a number or string to its corresponding single-character
string representation. If a string parameter is provided, it is first
parsed as an integer and then translated into a single-character string.
When an array of number or string values is passed in, then an array of
single-character strings of the same length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(char(65)); // "A"
print(char('65')); // "A"
print(char([65, 66, 67])); // [ "A", "B", "C" ]
print(join(char([65, 66, 67]), '')); // "ABC"
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///
///
/// ---
///
///
#[doc = r##"<code>ns</code> values to parse

"##]
///
///
/// ---
///

pub static char: CharInternalType = CharInternalType;
#[doc(hidden)]
pub struct CharInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "char")]
    fn char2480288696(_ : & str, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CharInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        char2480288696.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CharInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        char2480288696.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CharInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        char2480288696.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "char")]
    fn char2486771194(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CharInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        char2486771194.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CharInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        char2486771194.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CharInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        char2486771194.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "char")]
    fn char2573481464(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for CharInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        char2573481464.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for CharInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        char2573481464.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for CharInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        char2573481464.call(args)
    }
}
#[doc=r##"<p>Converts a single-character string to its corresponding integer
representation. When an array of single-character string values is passed
in, then an array of integers of the same length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(unchar('A')); // 65
print(unchar(['A', 'B', 'C'])); // [ 65, 66, 67 ]
print(unchar(split('ABC', ''))); // [ 65, 66, 67 ]
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///
///
/// ---
///
///
#[doc = r##"<code>ns</code> values to parse

"##]
///
///
/// ---
///

pub static unchar: UncharInternalType = UncharInternalType;
#[doc(hidden)]
pub struct UncharInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "unchar")]
    fn unchar2654755076(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for UncharInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        unchar2654755076.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for UncharInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        unchar2654755076.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for UncharInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        unchar2654755076.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "unchar")]
    fn unchar3162826292(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for UncharInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        unchar3162826292.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for UncharInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        unchar3162826292.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for UncharInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        unchar3162826292.call(args)
    }
}
#[doc=r##"<p>Converts a number to a string in its equivalent hexadecimal notation. If a
second parameter is passed, it is used to set the number of characters to
generate in the hexadecimal notation. When an array is passed in, an
array of strings in hexadecimal notation of the same length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(hex(255)); // "000000FF"
print(hex(255, 6)); // "0000FF"
print(hex([0, 127, 255], 6)); // [ "000000", "00007F", "0000FF" ]
print(Infinity); // "FFFFFFFF"
print(-Infinity); // "00000000"
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///
///
#[doc = r##"<code>digits?</code> 
"##]
///
///
/// ---
///
///
#[doc = r##"<code>ns</code> array of values to parse

"##]
///
///
#[doc = r##"<code>digits?</code> 
"##]
///
///
/// ---
///

pub static hex: HexInternalType = HexInternalType;
#[doc(hidden)]
pub struct HexInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hex")]
    fn hex1541739485(_ : f64, _ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for HexInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        hex1541739485.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for HexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        hex1541739485.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for HexInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        hex1541739485.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hex")]
    fn hex3252397222(_ : f64, ) -> String;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for HexInternalType {
    type Output = String;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        hex3252397222.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for HexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        hex3252397222.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for HexInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        hex3252397222.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hex")]
    fn hex1200762366(_ : & [f64], _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],f64,)> for HexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],f64,)) -> Self::Output {
        hex1200762366.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],f64,)> for HexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],f64,)) -> Self::Output {
        hex1200762366.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],f64,)> for HexInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],f64,)) -> Self::Output {
        hex1200762366.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "hex")]
    fn hex1339023257(_ : & [f64], ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ [f64],)> for HexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ [f64],)) -> Self::Output {
        hex1339023257.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ [f64],)> for HexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ [f64],)) -> Self::Output {
        hex1339023257.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ [f64],)> for HexInternalType {
    extern "rust-call" fn call(&self, args: (&'_ [f64],)) -> Self::Output {
        hex1339023257.call(args)
    }
}
#[doc=r##"<p>Converts a string representation of a hexadecimal number to its equivalent
integer value. When an array of strings in hexadecimal notation is passed
in, an array of integers of the same length is returned.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
print(unhex('A')); // 10
print(unhex('FF')); // 255
print(unhex(['FF', 'AA', '00'])); // [ 255, 170, 0 ]
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>n</code> value to parse

"##]
///
///
/// ---
///
///
#[doc = r##"<code>ns</code> values to parse

"##]
///
///
/// ---
///

pub static unhex: UnhexInternalType = UnhexInternalType;
#[doc(hidden)]
pub struct UnhexInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "unhex")]
    fn unhex1717453651(_ : & str, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for UnhexInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        unhex1717453651.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for UnhexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        unhex1717453651.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for UnhexInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        unhex1717453651.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "unhex")]
    fn unhex1066496546(_ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for UnhexInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        unhex1066496546.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for UnhexInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        unhex1066496546.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for UnhexInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        unhex1066496546.call(args)
    }
}
#[doc=r##"<p>Allows movement around a 3D sketch using a mouse or trackpad.  Left-clicking
and dragging will rotate the camera position about the center of the sketch,
right-clicking and dragging will pan the camera position without rotation,
and using the mouse wheel (scrolling) will move the camera closer or further
from the center of the sketch. This function can be called with parameters
dictating sensitivity to mouse movement along the X and Y axes.  Calling
this function without parameters is equivalent to calling orbitControl(1,1).
To reverse direction of movement in either axis, enter a negative number
for sensitivity.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  normalMaterial();
}
function draw() {
  background(200);
  orbitControl();
  rotateY(0.5);
  box(30, 50);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>sensitivityX?</code> sensitivity to mouse movement along X axis

"##]
///
///
#[doc = r##"<code>sensitivityY?</code> sensitivity to mouse movement along Y axis

"##]
///
///
#[doc = r##"<code>sensitivityZ?</code> sensitivity to scroll movement along Z axis

"##]
///

pub static orbitControl: OrbitControlInternalType = OrbitControlInternalType;
#[doc(hidden)]
pub struct OrbitControlInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "orbitControl")]
    fn orbitControl616872769(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for OrbitControlInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        orbitControl616872769.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for OrbitControlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        orbitControl616872769.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for OrbitControlInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        orbitControl616872769.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "orbitControl")]
    fn orbitControl1889685749(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for OrbitControlInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        orbitControl1889685749.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for OrbitControlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        orbitControl1889685749.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for OrbitControlInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        orbitControl1889685749.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "orbitControl")]
    fn orbitControl3330417010(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for OrbitControlInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        orbitControl3330417010.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for OrbitControlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        orbitControl3330417010.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for OrbitControlInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        orbitControl3330417010.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "orbitControl")]
    fn orbitControl3856162103() ;
}

#[doc(hidden)]
impl FnOnce<()> for OrbitControlInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        orbitControl3856162103.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for OrbitControlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        orbitControl3856162103.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for OrbitControlInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        orbitControl3856162103.call(args)
    }
}
#[doc=r##"<p>debugMode() helps visualize 3D space by adding a grid to indicate where the
‘ground’ is in a sketch and an axes icon which indicates the +X, +Y, and +Z
directions. This function can be called without parameters to create a
default grid and axes icon, or it can be called according to the examples
above to customize the size and position of the grid and/or axes icon.  The
grid is drawn using the most recently set stroke color and weight.  To
specify these parameters, add a call to stroke() and strokeWeight()
just before the end of the draw() loop.</p>
<p>By default, the grid will run through the origin (0,0,0) of the sketch
along the XZ plane
and the axes icon will be offset from the origin.  Both the grid and axes
icon will be sized according to the current canvas size.  Note that because the
grid runs parallel to the default camera view, it is often helpful to use
debugMode along with orbitControl to allow full view of the grid.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  camera(0, -30, 100, 0, 0, 0, 0, 1, 0);
  normalMaterial();
  debugMode();
}

function draw() {
  background(200);
  orbitControl();
  box(15, 30);
  // Press the spacebar to turn debugMode off!
  if (keyIsDown(32)) {
    noDebugMode();
  }
}
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  camera(0, -30, 100, 0, 0, 0, 0, 1, 0);
  normalMaterial();
  debugMode(GRID);
}

function draw() {
  background(200);
  orbitControl();
  box(15, 30);
}
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  camera(0, -30, 100, 0, 0, 0, 0, 1, 0);
  normalMaterial();
  debugMode(AXES);
}

function draw() {
  background(200);
  orbitControl();
  box(15, 30);
}
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  camera(0, -30, 100, 0, 0, 0, 0, 1, 0);
  normalMaterial();
  debugMode(GRID, 100, 10, 0, 0, 0);
}

function draw() {
  background(200);
  orbitControl();
  box(15, 30);
}
```"###]
#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  camera(0, -30, 100, 0, 0, 0, 0, 1, 0);
  normalMaterial();
  debugMode(100, 10, 0, 0, 0, 20, 0, -40, 0);
}

function draw() {
  noStroke();
  background(200);
  orbitControl();
  box(15, 30);
  // set the stroke color and weight for the grid!
  stroke(255, 0, 150);
  strokeWeight(0.8);
}
```"###]
/// <h2>Overloads</h2>
///
/// ---
///
///
#[doc = r##"<code>mode</code> either GRID or AXES

"##]
///
///
/// ---
///
///
#[doc = r##"<code>mode</code> either GRID or AXES

"##]
///
///
#[doc = r##"<code>gridSize?</code> size of one side of the grid

"##]
///
///
#[doc = r##"<code>gridDivisions?</code> number of divisions in the grid

"##]
///
///
#[doc = r##"<code>xOff?</code> X axis offset from origin (0,0,0)

"##]
///
///
#[doc = r##"<code>yOff?</code> Y axis offset from origin (0,0,0)

"##]
///
///
#[doc = r##"<code>zOff?</code> Z axis offset from origin (0,0,0)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>mode</code> either GRID or AXES

"##]
///
///
#[doc = r##"<code>axesSize?</code> size of axes icon

"##]
///
///
#[doc = r##"<code>xOff?</code> X axis offset from origin (0,0,0)

"##]
///
///
#[doc = r##"<code>yOff?</code> Y axis offset from origin (0,0,0)

"##]
///
///
#[doc = r##"<code>zOff?</code> Z axis offset from origin (0,0,0)

"##]
///
///
/// ---
///
///
#[doc = r##"<code>gridSize?</code> size of one side of the grid

"##]
///
///
#[doc = r##"<code>gridDivisions?</code> number of divisions in the grid

"##]
///
///
#[doc = r##"<code>gridXOff?</code> 
"##]
///
///
#[doc = r##"<code>gridYOff?</code> 
"##]
///
///
#[doc = r##"<code>gridZOff?</code> 
"##]
///
///
#[doc = r##"<code>axesSize?</code> size of axes icon

"##]
///
///
#[doc = r##"<code>axesXOff?</code> 
"##]
///
///
#[doc = r##"<code>axesYOff?</code> 
"##]
///
///
#[doc = r##"<code>axesZOff?</code> 
"##]
///
///
/// ---
///

pub static debugMode: DebugModeInternalType = DebugModeInternalType;
#[doc(hidden)]
pub struct DebugModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode2898242943() ;
}

#[doc(hidden)]
impl FnOnce<()> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        debugMode2898242943.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        debugMode2898242943.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        debugMode2898242943.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode1923323614(_ : DEBUG_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(DEBUG_MODE,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (DEBUG_MODE,)) -> Self::Output {
        debugMode1923323614.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(DEBUG_MODE,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (DEBUG_MODE,)) -> Self::Output {
        debugMode1923323614.call(args)
    }
}

#[doc(hidden)]
impl Fn<(DEBUG_MODE,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (DEBUG_MODE,)) -> Self::Output {
        debugMode1923323614.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode1403789756(_ : Constant, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode1403789756.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode1403789756.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode1403789756.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode545415975(_ : Constant, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,f64,f64,f64,)) -> Self::Output {
        debugMode545415975.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,f64,f64,f64,)) -> Self::Output {
        debugMode545415975.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,f64,f64,f64,)) -> Self::Output {
        debugMode545415975.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode3369882809(_ : Constant, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,f64,f64,)) -> Self::Output {
        debugMode3369882809.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,f64,f64,)) -> Self::Output {
        debugMode3369882809.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,f64,f64,)) -> Self::Output {
        debugMode3369882809.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode3280002228(_ : Constant, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,f64,)) -> Self::Output {
        debugMode3280002228.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,f64,)) -> Self::Output {
        debugMode3280002228.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,f64,)) -> Self::Output {
        debugMode3280002228.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode2915866396(_ : Constant, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,f64,)) -> Self::Output {
        debugMode2915866396.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,f64,)) -> Self::Output {
        debugMode2915866396.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,f64,)) -> Self::Output {
        debugMode2915866396.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode3378809195(_ : Constant, ) ;
}

#[doc(hidden)]
impl FnOnce<(Constant,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (Constant,)) -> Self::Output {
        debugMode3378809195.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(Constant,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (Constant,)) -> Self::Output {
        debugMode3378809195.call(args)
    }
}

#[doc(hidden)]
impl Fn<(Constant,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (Constant,)) -> Self::Output {
        debugMode3378809195.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode431229174(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode431229174.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode431229174.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode431229174.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode3965568682(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode3965568682.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode3965568682.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode3965568682.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode4138248674(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode4138248674.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode4138248674.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode4138248674.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode2344365972(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode2344365972.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode2344365972.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode2344365972.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode1983586192(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode1983586192.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode1983586192.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        debugMode1983586192.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode2686725642(_ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,)) -> Self::Output {
        debugMode2686725642.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,)) -> Self::Output {
        debugMode2686725642.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,)) -> Self::Output {
        debugMode2686725642.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode128196915(_ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,)) -> Self::Output {
        debugMode128196915.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,)) -> Self::Output {
        debugMode128196915.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,)) -> Self::Output {
        debugMode128196915.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode2559674909(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        debugMode2559674909.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        debugMode2559674909.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        debugMode2559674909.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "debugMode")]
    fn debugMode3460375635(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for DebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        debugMode3460375635.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for DebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        debugMode3460375635.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for DebugModeInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        debugMode3460375635.call(args)
    }
}
#[doc=r##"<p>Turns off debugMode() in a 3D sketch.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  camera(0, -30, 100, 0, 0, 0, 0, 1, 0);
  normalMaterial();
  debugMode();
}

function draw() {
  background(200);
  orbitControl();
  box(15, 30);
  // Press the spacebar to turn debugMode off!
  if (keyIsDown(32)) {
    noDebugMode();
  }
}
```"###]

pub static noDebugMode: NoDebugModeInternalType = NoDebugModeInternalType;
#[doc(hidden)]
pub struct NoDebugModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noDebugMode")]
    fn noDebugMode3357251490() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoDebugModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noDebugMode3357251490.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoDebugModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noDebugMode3357251490.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoDebugModeInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noDebugMode3357251490.call(args)
    }
}
#[doc=r##"<p>Modifies the location from which ellipses are drawn by changing the way in
which parameters given to <a href="#/p5/ellipse">ellipse()</a>,
<a href="#/p5/circle">circle()</a> and <a href="#/p5/arc">arc()</a> are interpreted.</p>
<p>The default mode is CENTER, in which the first two parameters are interpreted
as the shape's center point's x and y coordinates respectively, while the third
and fourth parameters are its width and height.</p>
<p>ellipseMode(RADIUS) also uses the first two parameters as the shape's center
point's x and y coordinates, but uses the third and fourth parameters to
specify half of the shapes's width and height.</p>
<p>ellipseMode(CORNER) interprets the first two parameters as the upper-left
corner of the shape, while the third and fourth parameters are its width
and height.</p>
<p>ellipseMode(CORNERS) interprets the first two parameters as the location of
one corner of the ellipse's bounding box, and the third and fourth parameters
as the location of the opposite corner.</p>
<p>The parameter to this method must be written in ALL CAPS because they are
predefined as constants in ALL CAPS and Javascript is a case-sensitive language.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Example showing RADIUS and CENTER ellipsemode with 2 overlaying ellipses
ellipseMode(RADIUS);
fill(255);
ellipse(50, 50, 30, 30); // Outer white ellipse
ellipseMode(CENTER);
fill(100);
ellipse(50, 50, 30, 30); // Inner gray ellipse
```"###]
#[doc=r###"```rust
// Example showing CORNER and CORNERS ellipseMode with 2 overlaying ellipses
ellipseMode(CORNER);
fill(255);
ellipse(25, 25, 50, 50); // Outer white ellipse
ellipseMode(CORNERS);
fill(100);
ellipse(25, 25, 50, 50); // Inner gray ellipse
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode</code> either CENTER, RADIUS, CORNER, or CORNERS

"##]
///

pub static ellipseMode: EllipseModeInternalType = EllipseModeInternalType;
#[doc(hidden)]
pub struct EllipseModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "ellipseMode")]
    fn ellipseMode1861965515(_ : ELLIPSE_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(ELLIPSE_MODE,)> for EllipseModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (ELLIPSE_MODE,)) -> Self::Output {
        ellipseMode1861965515.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(ELLIPSE_MODE,)> for EllipseModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (ELLIPSE_MODE,)) -> Self::Output {
        ellipseMode1861965515.call(args)
    }
}

#[doc(hidden)]
impl Fn<(ELLIPSE_MODE,)> for EllipseModeInternalType {
    extern "rust-call" fn call(&self, args: (ELLIPSE_MODE,)) -> Self::Output {
        ellipseMode1861965515.call(args)
    }
}
#[doc=r##"<p>Draws all geometry with jagged (aliased) edges. Note that <a href="#/p5/smooth">smooth()</a> is
active by default in 2D mode, so it is necessary to call <a href="#/p5/noSmooth">noSmooth()</a> to disable
smoothing of geometry, images, and fonts. In 3D mode, <a href="#/p5/noSmooth">noSmooth()</a> is enabled
by default, so it is necessary to call <a href="#/p5/smooth">smooth()</a> if you would like
smooth (antialiased) edges on your geometry.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
background(0);
noStroke();
smooth();
ellipse(30, 48, 36, 36);
noSmooth();
ellipse(70, 48, 36, 36);
```"###]

pub static noSmooth: NoSmoothInternalType = NoSmoothInternalType;
#[doc(hidden)]
pub struct NoSmoothInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noSmooth")]
    fn noSmooth2830739131() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoSmoothInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noSmooth2830739131.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoSmoothInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noSmooth2830739131.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoSmoothInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noSmooth2830739131.call(args)
    }
}
#[doc=r##"<p>Modifies the location from which rectangles are drawn by changing the way
in which parameters given to <a href="#/p5/rect">rect()</a> are interpreted.</p>
<p>The default mode is CORNER, which interprets the first two parameters as the
upper-left corner of the shape, while the third and fourth parameters are its
width and height.</p>
<p>rectMode(CORNERS) interprets the first two parameters as the location of
one of the corners, and the third and fourth parameters as the location of
the diagonally opposite corner. Note, the rectangle is drawn between the
coordinates, so it is not neccesary that the first corner be the upper left
corner.</p>
<p>rectMode(CENTER) interprets the first two parameters as the shape's center
point, while the third and fourth parameters are its width and height.</p>
<p>rectMode(RADIUS) also uses the first two parameters as the shape's center
point, but uses the third and fourth parameters to specify half of the shape's
width and height respectively.</p>
<p>The parameter to this method must be written in ALL CAPS because they are
predefined as constants in ALL CAPS and Javascript is a case-sensitive language.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
rectMode(CORNER);
fill(255);
rect(25, 25, 50, 50); // Draw white rectangle using CORNER mode

rectMode(CORNERS);
fill(100);
rect(25, 25, 50, 50); // Draw gray rectanle using CORNERS mode
```"###]
#[doc=r###"```rust
rectMode(RADIUS);
fill(255);
rect(50, 50, 30, 30); // Draw white rectangle using RADIUS mode

rectMode(CENTER);
fill(100);
rect(50, 50, 30, 30); // Draw gray rectangle using CENTER mode
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode</code> either CORNER, CORNERS, CENTER, or RADIUS

"##]
///

pub static rectMode: RectModeInternalType = RectModeInternalType;
#[doc(hidden)]
pub struct RectModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "rectMode")]
    fn rectMode3641780604(_ : RECT_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(RECT_MODE,)> for RectModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (RECT_MODE,)) -> Self::Output {
        rectMode3641780604.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(RECT_MODE,)> for RectModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (RECT_MODE,)) -> Self::Output {
        rectMode3641780604.call(args)
    }
}

#[doc(hidden)]
impl Fn<(RECT_MODE,)> for RectModeInternalType {
    extern "rust-call" fn call(&self, args: (RECT_MODE,)) -> Self::Output {
        rectMode3641780604.call(args)
    }
}
#[doc=r##"<p>Draws all geometry with smooth (anti-aliased) edges. <a href="#/p5/smooth">smooth()</a> will also
improve image quality of resized images. Note that <a href="#/p5/smooth">smooth()</a> is active by
default in 2D mode; <a href="#/p5/noSmooth">noSmooth()</a> can be used to disable smoothing of geometry,
images, and fonts. In 3D mode, <a href="#/p5/noSmooth">noSmooth()</a> is enabled
by default, so it is necessary to call <a href="#/p5/smooth">smooth()</a> if you would like
smooth (antialiased) edges on your geometry.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
background(0);
noStroke();
smooth();
ellipse(30, 48, 36, 36);
noSmooth();
ellipse(70, 48, 36, 36);
```"###]

pub static smooth: SmoothInternalType = SmoothInternalType;
#[doc(hidden)]
pub struct SmoothInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "smooth")]
    fn smooth1712109492() ;
}

#[doc(hidden)]
impl FnOnce<()> for SmoothInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        smooth1712109492.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for SmoothInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        smooth1712109492.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for SmoothInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        smooth1712109492.call(args)
    }
}
#[doc=r##"<p>Sets the style for rendering line endings. These ends are either rounded,
squared or extended, each of which specified with the corresponding
parameters: ROUND, SQUARE and PROJECT. The default cap is ROUND.</p>
<p>The parameter to this method must be written in ALL CAPS because they are
predefined as constants in ALL CAPS and Javascript is a case-sensitive language.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Example of different strokeCaps
strokeWeight(12.0);
strokeCap(ROUND);
line(20, 30, 80, 30);
strokeCap(SQUARE);
line(20, 50, 80, 50);
strokeCap(PROJECT);
line(20, 70, 80, 70);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>cap</code> either ROUND, SQUARE or PROJECT

"##]
///

pub static strokeCap: StrokeCapInternalType = StrokeCapInternalType;
#[doc(hidden)]
pub struct StrokeCapInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "strokeCap")]
    fn strokeCap2533240632(_ : STROKE_CAP, ) ;
}

#[doc(hidden)]
impl FnOnce<(STROKE_CAP,)> for StrokeCapInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (STROKE_CAP,)) -> Self::Output {
        strokeCap2533240632.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(STROKE_CAP,)> for StrokeCapInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (STROKE_CAP,)) -> Self::Output {
        strokeCap2533240632.call(args)
    }
}

#[doc(hidden)]
impl Fn<(STROKE_CAP,)> for StrokeCapInternalType {
    extern "rust-call" fn call(&self, args: (STROKE_CAP,)) -> Self::Output {
        strokeCap2533240632.call(args)
    }
}
#[doc=r##"<p>Sets the style of the joints which connect line segments. These joints
are either mitered, beveled or rounded and specified with the
corresponding parameters MITER, BEVEL and ROUND. The default joint is
MITER.</p>
<p>The parameter to this method must be written in ALL CAPS because they are
predefined as constants in ALL CAPS and Javascript is a case-sensitive language.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Example of MITER type of joints
noFill();
strokeWeight(10.0);
strokeJoin(MITER);
beginShape();
vertex(35, 20);
vertex(65, 50);
vertex(35, 80);
endShape();
```"###]
#[doc=r###"```rust
// Example of BEVEL type of joints
noFill();
strokeWeight(10.0);
strokeJoin(BEVEL);
beginShape();
vertex(35, 20);
vertex(65, 50);
vertex(35, 80);
endShape();
```"###]
#[doc=r###"```rust
// Example of ROUND type of joints
noFill();
strokeWeight(10.0);
strokeJoin(ROUND);
beginShape();
vertex(35, 20);
vertex(65, 50);
vertex(35, 80);
endShape();
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>join</code> either MITER, BEVEL, ROUND

"##]
///

pub static strokeJoin: StrokeJoinInternalType = StrokeJoinInternalType;
#[doc(hidden)]
pub struct StrokeJoinInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "strokeJoin")]
    fn strokeJoin3676005219(_ : STROKE_JOIN, ) ;
}

#[doc(hidden)]
impl FnOnce<(STROKE_JOIN,)> for StrokeJoinInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (STROKE_JOIN,)) -> Self::Output {
        strokeJoin3676005219.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(STROKE_JOIN,)> for StrokeJoinInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (STROKE_JOIN,)) -> Self::Output {
        strokeJoin3676005219.call(args)
    }
}

#[doc(hidden)]
impl Fn<(STROKE_JOIN,)> for StrokeJoinInternalType {
    extern "rust-call" fn call(&self, args: (STROKE_JOIN,)) -> Self::Output {
        strokeJoin3676005219.call(args)
    }
}
#[doc=r##"<p>Sets the width of the stroke used for lines, points and the border around
shapes. All widths are set in units of pixels.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Example of different stroke weights
strokeWeight(1); // Default
line(20, 20, 80, 20);
strokeWeight(4); // Thicker
line(20, 40, 80, 40);
strokeWeight(10); // Beastly
line(20, 70, 80, 70);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>weight</code> the weight of the stroke (in pixels)

"##]
///

pub static strokeWeight: StrokeWeightInternalType = StrokeWeightInternalType;
#[doc(hidden)]
pub struct StrokeWeightInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "strokeWeight")]
    fn strokeWeight3249474782(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for StrokeWeightInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        strokeWeight3249474782.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for StrokeWeightInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        strokeWeight3249474782.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for StrokeWeightInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        strokeWeight3249474782.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/setMoveThreshold">setMoveThreshold()</a> function is used to set the movement threshold for
the <a href="#/p5/deviceMoved">deviceMoved()</a> function. The default threshold is set to 0.5.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Run this example on a mobile device
// You will need to move the device incrementally further
// the closer the square's color gets to white in order to change the value.

let value = 0;
let threshold = 0.5;
function setup() {
  setMoveThreshold(threshold);
}
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function deviceMoved() {
  value = value + 5;
  threshold = threshold + 0.1;
  if (value > 255) {
    value = 0;
    threshold = 30;
  }
  setMoveThreshold(threshold);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> The threshold value

"##]
///

pub static setMoveThreshold: SetMoveThresholdInternalType = SetMoveThresholdInternalType;
#[doc(hidden)]
pub struct SetMoveThresholdInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "setMoveThreshold")]
    fn setMoveThreshold1801969978(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SetMoveThresholdInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        setMoveThreshold1801969978.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SetMoveThresholdInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        setMoveThreshold1801969978.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SetMoveThresholdInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        setMoveThreshold1801969978.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/setShakeThreshold">setShakeThreshold()</a> function is used to set the movement threshold for
the <a href="#/p5/deviceShaken">deviceShaken()</a> function. The default threshold is set to 30.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Run this example on a mobile device
// You will need to shake the device more firmly
// the closer the box's fill gets to white in order to change the value.

let value = 0;
let threshold = 30;
function setup() {
  setShakeThreshold(threshold);
}
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function deviceMoved() {
  value = value + 5;
  threshold = threshold + 5;
  if (value > 255) {
    value = 0;
    threshold = 30;
  }
  setShakeThreshold(threshold);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>value</code> The threshold value

"##]
///

pub static setShakeThreshold: SetShakeThresholdInternalType = SetShakeThresholdInternalType;
#[doc(hidden)]
pub struct SetShakeThresholdInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "setShakeThreshold")]
    fn setShakeThreshold1764002885(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for SetShakeThresholdInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        setShakeThreshold1764002885.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for SetShakeThresholdInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        setShakeThreshold1764002885.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for SetShakeThresholdInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        setShakeThreshold1764002885.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/deviceMoved">deviceMoved()</a> function is called when the device is moved by more than
the threshold value along X, Y or Z axis. The default threshold is set to 0.5.
The threshold value can be changed using <a href="https://p5js.org/reference/#/p5/setMoveThreshold">setMoveThreshold()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Run this example on a mobile device
// Move the device around
// to change the value.

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function deviceMoved() {
  value = value + 5;
  if (value > 255) {
    value = 0;
  }
}
```"###]

pub static deviceMoved: DeviceMovedInternalType = DeviceMovedInternalType;
#[doc(hidden)]
pub struct DeviceMovedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "deviceMoved")]
    fn deviceMoved2559331401() ;
}

#[doc(hidden)]
impl FnOnce<()> for DeviceMovedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        deviceMoved2559331401.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DeviceMovedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        deviceMoved2559331401.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DeviceMovedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        deviceMoved2559331401.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/deviceTurned">deviceTurned()</a> function is called when the device rotates by
more than 90 degrees continuously.</p>
<p>The axis that triggers the <a href="#/p5/deviceTurned">deviceTurned()</a> method is stored in the turnAxis
variable. The <a href="#/p5/deviceTurned">deviceTurned()</a> method can be locked to trigger on any axis:
X, Y or Z by comparing the turnAxis variable to 'X', 'Y' or 'Z'.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Run this example on a mobile device
// Rotate the device by 90 degrees
// to change the value.

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function deviceTurned() {
  if (value === 0) {
    value = 255;
  } else if (value === 255) {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
// Run this example on a mobile device
// Rotate the device by 90 degrees in the
// X-axis to change the value.

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function deviceTurned() {
  if (turnAxis === 'X') {
    if (value === 0) {
      value = 255;
    } else if (value === 255) {
      value = 0;
    }
  }
}
```"###]

pub static deviceTurned: DeviceTurnedInternalType = DeviceTurnedInternalType;
#[doc(hidden)]
pub struct DeviceTurnedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "deviceTurned")]
    fn deviceTurned1374578179() ;
}

#[doc(hidden)]
impl FnOnce<()> for DeviceTurnedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        deviceTurned1374578179.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DeviceTurnedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        deviceTurned1374578179.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DeviceTurnedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        deviceTurned1374578179.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/deviceShaken">deviceShaken()</a> function is called when the device total acceleration
changes of accelerationX and accelerationY values is more than
the threshold value. The default threshold is set to 30.
The threshold value can be changed using <a href="https://p5js.org/reference/#/p5/setShakeThreshold">setShakeThreshold()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Run this example on a mobile device
// Shake the device to change the value.

let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function deviceShaken() {
  value = value + 5;
  if (value > 255) {
    value = 0;
  }
}
```"###]

pub static deviceShaken: DeviceShakenInternalType = DeviceShakenInternalType;
#[doc(hidden)]
pub struct DeviceShakenInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "deviceShaken")]
    fn deviceShaken3614399667() ;
}

#[doc(hidden)]
impl FnOnce<()> for DeviceShakenInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        deviceShaken3614399667.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for DeviceShakenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        deviceShaken3614399667.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for DeviceShakenInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        deviceShaken3614399667.call(args)
    }
}
#[doc=r##"<p>Draws a cubic Bezier curve on the screen. These curves are defined by a
series of anchor and control points. The first two parameters specify
the first anchor point and the last two parameters specify the other
anchor point, which become the first and last points on the curve. The
middle parameters specify the two control points which define the shape
of the curve. Approximately speaking, control points "pull" the curve
towards them.</p>
<p>Bezier curves were developed by French automotive engineer Pierre Bezier,
and are commonly used in computer graphics to define gently sloping curves.
See also <a href="#/p5/curve">curve()</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
stroke(255, 102, 0);
line(85, 20, 10, 10);
line(90, 90, 15, 80);
stroke(0, 0, 0);
bezier(85, 20, 10, 10, 90, 90, 15, 80);
```"###]
#[doc=r###"```rust
background(0, 0, 0);
noFill();
stroke(255);
bezier(250, 250, 0, 100, 100, 0, 100, 0, 0, 0, 100, 0);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x1</code> x-coordinate for the first anchor point

"##]
///
///
#[doc = r##"<code>y1</code> y-coordinate for the first anchor point

"##]
///
///
#[doc = r##"<code>x2</code> x-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>x4</code> x-coordinate for the second anchor point

"##]
///
///
#[doc = r##"<code>y4</code> y-coordinate for the second anchor point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>x1</code> x-coordinate for the first anchor point

"##]
///
///
#[doc = r##"<code>y1</code> y-coordinate for the first anchor point

"##]
///
///
#[doc = r##"<code>z1</code> z-coordinate for the first anchor point

"##]
///
///
#[doc = r##"<code>x2</code> x-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>z2</code> z-coordinate for the first control point

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>z3</code> z-coordinate for the second control point

"##]
///
///
#[doc = r##"<code>x4</code> x-coordinate for the second anchor point

"##]
///
///
#[doc = r##"<code>y4</code> y-coordinate for the second anchor point

"##]
///
///
#[doc = r##"<code>z4</code> z-coordinate for the second anchor point

"##]
///
///
/// ---
///

pub static bezier: BezierInternalType = BezierInternalType;
#[doc(hidden)]
pub struct BezierInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezier")]
    fn bezier4024972507(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezier4024972507.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezier4024972507.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezier4024972507.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezier")]
    fn bezier237465044(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezier237465044.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezier237465044.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for BezierInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        bezier237465044.call(args)
    }
}
#[doc=r##"<p>Sets the resolution at which Bezier's curve is displayed. The default value is 20.</p>
<p>Note, This function is only useful when using the WEBGL renderer
as the default canvas renderer does not use this information.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);
  noFill();
  bezierDetail(5);
}

function draw() {
  background(200);
  bezier(-40, -40, 0,
          90, -40, 0,
         -90,  40, 0,
          40,  40, 0);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>detail</code> resolution of the curves

"##]
///

pub static bezierDetail: BezierDetailInternalType = BezierDetailInternalType;
#[doc(hidden)]
pub struct BezierDetailInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezierDetail")]
    fn bezierDetail2184196585(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for BezierDetailInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        bezierDetail2184196585.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for BezierDetailInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        bezierDetail2184196585.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for BezierDetailInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        bezierDetail2184196585.call(args)
    }
}
#[doc=r##"<p>Given the x or y co-ordinate values of control and anchor points of a bezier
curve, it evaluates the x or y coordinate of the bezier at position t. The
parameters a and d are the x or y coordinates of first and last points on the
curve while b and c are of the control points.The final parameter t is the
position of the resultant point which is given between 0 and 1.
This can be done once with the x coordinates and a second time
with the y coordinates to get the location of a bezier curve at t.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
let x1 = 85,
 x2 = 10,
 x3 = 90,
 x4 = 15;
let y1 = 20,
 y2 = 10,
 y3 = 90,
 y4 = 80;
bezier(x1, y1, x2, y2, x3, y3, x4, y4);
fill(255);
let steps = 10;
for (let i = 0; i <= steps; i++) {
  let t = i / steps;
  let x = bezierPoint(x1, x2, x3, x4, t);
  let y = bezierPoint(y1, y2, y3, y4, t);
  circle(x, y, 5);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> coordinate of first point on the curve

"##]
///
///
#[doc = r##"<code>b</code> coordinate of first control point

"##]
///
///
#[doc = r##"<code>c</code> coordinate of second control point

"##]
///
///
#[doc = r##"<code>d</code> coordinate of second point on the curve

"##]
///
///
#[doc = r##"<code>t</code> value between 0 and 1

"##]
///

pub static bezierPoint: BezierPointInternalType = BezierPointInternalType;
#[doc(hidden)]
pub struct BezierPointInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezierPoint")]
    fn bezierPoint3751003331(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for BezierPointInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierPoint3751003331.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for BezierPointInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierPoint3751003331.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for BezierPointInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierPoint3751003331.call(args)
    }
}
#[doc=r##"<p>Evaluates the tangent to the Bezier at position t for points a, b, c, d.
The parameters a and d are the first and last points
on the curve, and b and c are the control points.
The final parameter t varies between 0 and 1.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
bezier(85, 20, 10, 10, 90, 90, 15, 80);
let steps = 6;
fill(255);
for (let i = 0; i <= steps; i++) {
  let t = i / steps;
  // Get the location of the point
  let x = bezierPoint(85, 10, 90, 15, t);
  let y = bezierPoint(20, 10, 90, 80, t);
  // Get the tangent points
  let tx = bezierTangent(85, 10, 90, 15, t);
  let ty = bezierTangent(20, 10, 90, 80, t);
  // Calculate an angle from the tangent points
  let a = atan2(ty, tx);
  a += PI;
  stroke(255, 102, 0);
  line(x, y, cos(a) * 30 + x, sin(a) * 30 + y);
  // The following line of code makes a line
  // inverse of the above line
  //line(x, y, cos(a)*-30 + x, sin(a)*-30 + y);
  stroke(0);
  ellipse(x, y, 5, 5);
}
```"###]
#[doc=r###"```rust
noFill();
bezier(85, 20, 10, 10, 90, 90, 15, 80);
stroke(255, 102, 0);
let steps = 16;
for (let i = 0; i <= steps; i++) {
  let t = i / steps;
  let x = bezierPoint(85, 10, 90, 15, t);
  let y = bezierPoint(20, 10, 90, 80, t);
  let tx = bezierTangent(85, 10, 90, 15, t);
  let ty = bezierTangent(20, 10, 90, 80, t);
  let a = atan2(ty, tx);
  a -= HALF_PI;
  line(x, y, cos(a) * 8 + x, sin(a) * 8 + y);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> coordinate of first point on the curve

"##]
///
///
#[doc = r##"<code>b</code> coordinate of first control point

"##]
///
///
#[doc = r##"<code>c</code> coordinate of second control point

"##]
///
///
#[doc = r##"<code>d</code> coordinate of second point on the curve

"##]
///
///
#[doc = r##"<code>t</code> value between 0 and 1

"##]
///

pub static bezierTangent: BezierTangentInternalType = BezierTangentInternalType;
#[doc(hidden)]
pub struct BezierTangentInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "bezierTangent")]
    fn bezierTangent3322685672(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for BezierTangentInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierTangent3322685672.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for BezierTangentInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierTangent3322685672.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for BezierTangentInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        bezierTangent3322685672.call(args)
    }
}
#[doc=r##"<p>Draws a curved line on the screen between two points, given as the
middle four parameters. The first two parameters are a control point, as
if the curve came from this point even though it's not drawn. The last
two parameters similarly describe the other control point. <br /><br />
Longer curves can be created by putting a series of <a href="#/p5/curve">curve()</a> functions
together or using <a href="#/p5/curveVertex">curveVertex()</a>. An additional function called
<a href="#/p5/curveTightness">curveTightness()</a> provides control for the visual quality of the curve.
The <a href="#/p5/curve">curve()</a> function is an implementation of Catmull-Rom splines.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
stroke(255, 102, 0);
curve(5, 26, 5, 26, 73, 24, 73, 61);
stroke(0);
curve(5, 26, 73, 24, 73, 61, 15, 65);
stroke(255, 102, 0);
curve(73, 24, 73, 61, 15, 65, 15, 65);
```"###]
#[doc=r###"```rust
// Define the curve points as JavaScript objects
let p1 = { x: 5, y: 26 };
let p2 = { x: 73, y: 24 };
let p3 = { x: 73, y: 61 };
let p4 = { x: 15, y: 65 };
noFill();
stroke(255, 102, 0);
curve(p1.x, p1.y, p1.x, p1.y, p2.x, p2.y, p3.x, p3.y);
stroke(0);
curve(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
stroke(255, 102, 0);
curve(p2.x, p2.y, p3.x, p3.y, p4.x, p4.y, p4.x, p4.y);
```"###]
#[doc=r###"```rust
noFill();
stroke(255, 102, 0);
curve(5, 26, 0, 5, 26, 0, 73, 24, 0, 73, 61, 0);
stroke(0);
curve(5, 26, 0, 73, 24, 0, 73, 61, 0, 15, 65, 0);
stroke(255, 102, 0);
curve(73, 24, 0, 73, 61, 0, 15, 65, 0, 15, 65, 0);
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>x1</code> x-coordinate for the beginning control point

"##]
///
///
#[doc = r##"<code>y1</code> y-coordinate for the beginning control point

"##]
///
///
#[doc = r##"<code>x2</code> x-coordinate for the first point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate for the first point

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the second point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the second point

"##]
///
///
#[doc = r##"<code>x4</code> x-coordinate for the ending control point

"##]
///
///
#[doc = r##"<code>y4</code> y-coordinate for the ending control point

"##]
///
///
/// ---
///
///
#[doc = r##"<code>x1</code> x-coordinate for the beginning control point

"##]
///
///
#[doc = r##"<code>y1</code> y-coordinate for the beginning control point

"##]
///
///
#[doc = r##"<code>z1</code> z-coordinate for the beginning control point

"##]
///
///
#[doc = r##"<code>x2</code> x-coordinate for the first point

"##]
///
///
#[doc = r##"<code>y2</code> y-coordinate for the first point

"##]
///
///
#[doc = r##"<code>z2</code> z-coordinate for the first point

"##]
///
///
#[doc = r##"<code>x3</code> x-coordinate for the second point

"##]
///
///
#[doc = r##"<code>y3</code> y-coordinate for the second point

"##]
///
///
#[doc = r##"<code>z3</code> z-coordinate for the second point

"##]
///
///
#[doc = r##"<code>x4</code> x-coordinate for the ending control point

"##]
///
///
#[doc = r##"<code>y4</code> y-coordinate for the ending control point

"##]
///
///
#[doc = r##"<code>z4</code> z-coordinate for the ending control point

"##]
///
///
/// ---
///

pub static curve: CurveInternalType = CurveInternalType;
#[doc(hidden)]
pub struct CurveInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curve")]
    fn curve2281763382(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,)> for CurveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        curve2281763382.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,)> for CurveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        curve2281763382.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,)> for CurveInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        curve2281763382.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curve")]
    fn curve3542769215(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for CurveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        curve3542769215.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for CurveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        curve3542769215.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)> for CurveInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,f64,)) -> Self::Output {
        curve3542769215.call(args)
    }
}
#[doc=r##"<p>Sets the resolution at which curves display. The default value is 20 while
the minimum value is 3.</p>
<p>This function is only useful when using the WEBGL renderer
as the default canvas renderer does not use this
information.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100, WEBGL);

  curveDetail(5);
}
function draw() {
  background(200);

  curve(250, 600, 0, -30, 40, 0, 30, 30, 0, -250, 600, 0);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>resolution</code> resolution of the curves

"##]
///

pub static curveDetail: CurveDetailInternalType = CurveDetailInternalType;
#[doc(hidden)]
pub struct CurveDetailInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curveDetail")]
    fn curveDetail1166007069(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CurveDetailInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        curveDetail1166007069.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CurveDetailInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        curveDetail1166007069.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CurveDetailInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        curveDetail1166007069.call(args)
    }
}
#[doc=r##"<p>Modifies the quality of forms created with <a href="#/p5/curve">curve()</a>
and <a href="#/p5/curveVertex">curveVertex()</a>.The parameter tightness
determines how the curve fits to the vertex points. The value 0.0 is the
default value for tightness (this value defines the curves to be Catmull-Rom
splines) and the value 1.0 connects all the points with straight lines.
Values within the range -5.0 and 5.0 will deform the curves but will leave
them recognizable and as values increase in magnitude, they will continue to deform.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Move the mouse left and right to see the curve change
function setup() {
  createCanvas(100, 100);
  noFill();
}

function draw() {
  background(204);
  let t = map(mouseX, 0, width, -5, 5);
  curveTightness(t);
  beginShape();
  curveVertex(10, 26);
  curveVertex(10, 26);
  curveVertex(83, 24);
  curveVertex(83, 61);
  curveVertex(25, 65);
  curveVertex(25, 65);
  endShape();
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>amount</code> amount of deformation from the original vertices

"##]
///

pub static curveTightness: CurveTightnessInternalType = CurveTightnessInternalType;
#[doc(hidden)]
pub struct CurveTightnessInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curveTightness")]
    fn curveTightness891210425(_ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for CurveTightnessInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        curveTightness891210425.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for CurveTightnessInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        curveTightness891210425.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for CurveTightnessInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        curveTightness891210425.call(args)
    }
}
#[doc=r##"<p>Evaluates the curve at position t for points a, b, c, d.
The parameter t varies between 0 and 1, a and d are control points
of the curve, and b and c are the start and end points of the curve.
This can be done once with the x coordinates and a second time
with the y coordinates to get the location of a curve at t.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
curve(5, 26, 5, 26, 73, 24, 73, 61);
curve(5, 26, 73, 24, 73, 61, 15, 65);
fill(255);
ellipseMode(CENTER);
let steps = 6;
for (let i = 0; i <= steps; i++) {
  let t = i / steps;
  let x = curvePoint(5, 5, 73, 73, t);
  let y = curvePoint(26, 26, 24, 61, t);
  ellipse(x, y, 5, 5);
  x = curvePoint(5, 73, 73, 15, t);
  y = curvePoint(26, 24, 61, 65, t);
  ellipse(x, y, 5, 5);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> coordinate of first control point of the curve

"##]
///
///
#[doc = r##"<code>b</code> coordinate of first point

"##]
///
///
#[doc = r##"<code>c</code> coordinate of second point

"##]
///
///
#[doc = r##"<code>d</code> coordinate of second control point

"##]
///
///
#[doc = r##"<code>t</code> value between 0 and 1

"##]
///

pub static curvePoint: CurvePointInternalType = CurvePointInternalType;
#[doc(hidden)]
pub struct CurvePointInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curvePoint")]
    fn curvePoint419357484(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for CurvePointInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        curvePoint419357484.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for CurvePointInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        curvePoint419357484.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for CurvePointInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        curvePoint419357484.call(args)
    }
}
#[doc=r##"<p>Evaluates the tangent to the curve at position t for points a, b, c, d.
The parameter t varies between 0 and 1, a and d are points on the curve,
and b and c are the control points.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
noFill();
curve(5, 26, 73, 24, 73, 61, 15, 65);
let steps = 6;
for (let i = 0; i <= steps; i++) {
  let t = i / steps;
  let x = curvePoint(5, 73, 73, 15, t);
  let y = curvePoint(26, 24, 61, 65, t);
  //ellipse(x, y, 5, 5);
  let tx = curveTangent(5, 73, 73, 15, t);
  let ty = curveTangent(26, 24, 61, 65, t);
  let a = atan2(ty, tx);
  a -= PI / 2.0;
  line(x, y, cos(a) * 8 + x, sin(a) * 8 + y);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> coordinate of first control point

"##]
///
///
#[doc = r##"<code>b</code> coordinate of first point on the curve

"##]
///
///
#[doc = r##"<code>c</code> coordinate of second point on the curve

"##]
///
///
#[doc = r##"<code>d</code> coordinate of second conrol point

"##]
///
///
#[doc = r##"<code>t</code> value between 0 and 1

"##]
///

pub static curveTangent: CurveTangentInternalType = CurveTangentInternalType;
#[doc(hidden)]
pub struct CurveTangentInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "curveTangent")]
    fn curveTangent2379488461(_ : f64, _ : f64, _ : f64, _ : f64, _ : f64, ) -> f64;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,f64,f64,f64,)> for CurveTangentInternalType {
    type Output = f64;
    extern "rust-call" fn call_once(self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        curveTangent2379488461.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,f64,f64,f64,)> for CurveTangentInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        curveTangent2379488461.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,f64,f64,f64,)> for CurveTangentInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,f64,f64,f64,)) -> Self::Output {
        curveTangent2379488461.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/keyPressed">keyPressed()</a> function is called once every time a key is pressed. The
keyCode for the key that was pressed is stored in the <a href="#/p5/keyCode">keyCode</a> variable.</p>
<p>For non-ASCII keys, use the keyCode variable. You can check if the keyCode
equals BACKSPACE, DELETE, ENTER, RETURN, TAB, ESCAPE, SHIFT, CONTROL,
OPTION, ALT, UP_ARROW, DOWN_ARROW, LEFT_ARROW, RIGHT_ARROW.</p>
<p>For ASCII keys, the key that was pressed is stored in the key variable. However, it
does not distinguish between uppercase and lowercase. For this reason, it
is recommended to use <a href="#/p5/keyTyped">keyTyped()</a> to read the key variable, in which the
case of the variable will be distinguished.</p>
<p>Because of how operating systems handle key repeats, holding down a key
may cause multiple calls to <a href="#/p5/keyTyped">keyTyped()</a> (and <a href="#/p5/keyReleased">keyReleased()</a> as well). The
rate of repeat is set by the operating system and how each computer is
configured.<br><br>
Browsers may have different default
behaviors attached to various key events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function keyPressed() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function keyPressed() {
  if (keyCode === LEFT_ARROW) {
    value = 255;
  } else if (keyCode === RIGHT_ARROW) {
    value = 0;
  }
}
```"###]
#[doc=r###"```rust
function keyPressed() {
  // Do something
  return false; // prevent any default behaviour
}
```"###]

pub static keyPressed: KeyPressedInternalType = KeyPressedInternalType;
#[doc(hidden)]
pub struct KeyPressedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "keyPressed")]
    fn keyPressed160435629() ;
}

#[doc(hidden)]
impl FnOnce<()> for KeyPressedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        keyPressed160435629.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for KeyPressedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        keyPressed160435629.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for KeyPressedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        keyPressed160435629.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/keyReleased">keyReleased()</a> function is called once every time a key is released.
See <a href="#/p5/key">key</a> and <a href="#/p5/keyCode">keyCode</a> for more information.<br><br>
Browsers may have different default
behaviors attached to various key events. To prevent any default
behavior for this event, add "return false" to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function keyReleased() {
  if (value === 0) {
    value = 255;
  } else {
    value = 0;
  }
  return false; // prevent any default behavior
}
```"###]

pub static keyReleased: KeyReleasedInternalType = KeyReleasedInternalType;
#[doc(hidden)]
pub struct KeyReleasedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "keyReleased")]
    fn keyReleased915948071() ;
}

#[doc(hidden)]
impl FnOnce<()> for KeyReleasedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        keyReleased915948071.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for KeyReleasedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        keyReleased915948071.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for KeyReleasedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        keyReleased915948071.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/keyTyped">keyTyped()</a> function is called once every time a key is pressed, but
action keys such as Backspace, Delete, Ctrl, Shift, and Alt are ignored. If you are trying to detect
a keyCode for one of these keys, use the <a href="#/p5/keyPressed">keyPressed()</a> function instead.
The most recent key typed will be stored in the key variable.</p>
<p>Because of how operating systems handle key repeats, holding down a key
will cause multiple calls to <a href="#/p5/keyTyped">keyTyped()</a> (and <a href="#/p5/keyReleased">keyReleased()</a> as well). The
rate of repeat is set by the operating system and how each computer is
configured.<br><br>
Browsers may have different default behaviors attached to various key
events. To prevent any default behavior for this event, add "return false"
to the end of the method.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let value = 0;
function draw() {
  fill(value);
  rect(25, 25, 50, 50);
}
function keyTyped() {
  if (key === 'a') {
    value = 255;
  } else if (key === 'b') {
    value = 0;
  }
  // uncomment to prevent any default behavior
  // return false;
}
```"###]

pub static keyTyped: KeyTypedInternalType = KeyTypedInternalType;
#[doc(hidden)]
pub struct KeyTypedInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "keyTyped")]
    fn keyTyped861305108() ;
}

#[doc(hidden)]
impl FnOnce<()> for KeyTypedInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        keyTyped861305108.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for KeyTypedInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        keyTyped861305108.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for KeyTypedInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        keyTyped861305108.call(args)
    }
}
#[doc=r##"<p>The <a href="#/p5/keyIsDown">keyIsDown()</a> function checks if the key is currently down, i.e. pressed.
It can be used if you have an object that moves, and you want several keys
to be able to affect its behaviour simultaneously, such as moving a
sprite diagonally. You can put in any number representing the keyCode of
the key, or use any of the variable <a href="#/p5/keyCode">keyCode</a> names listed
<a href="http://p5js.org/reference/#p5/keyCode">here</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let x = 100;
let y = 100;

function setup() {
  createCanvas(512, 512);
  fill(255, 0, 0);
}

function draw() {
  if (keyIsDown(LEFT_ARROW)) {
    x -= 5;
  }

  if (keyIsDown(RIGHT_ARROW)) {
    x += 5;
  }

  if (keyIsDown(UP_ARROW)) {
    y -= 5;
  }

  if (keyIsDown(DOWN_ARROW)) {
    y += 5;
  }

  clear();
  ellipse(x, y, 50, 50);
}
```"###]
#[doc=r###"```rust
let diameter = 50;

function setup() {
  createCanvas(512, 512);
}

function draw() {
  // 107 and 187 are keyCodes for "+"
  if (keyIsDown(107) || keyIsDown(187)) {
    diameter += 1;
  }

  // 109 and 189 are keyCodes for "-"
  if (keyIsDown(109) || keyIsDown(189)) {
    diameter -= 1;
  }

  clear();
  fill(255, 0, 0);
  ellipse(50, 50, diameter, diameter);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>code</code> The key to check for.

"##]
///

pub static keyIsDown: KeyIsDownInternalType = KeyIsDownInternalType;
#[doc(hidden)]
pub struct KeyIsDownInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "keyIsDown")]
    fn keyIsDown1775458590(_ : f64, ) -> bool;
}

#[doc(hidden)]
impl FnOnce<(f64,)> for KeyIsDownInternalType {
    type Output = bool;
    extern "rust-call" fn call_once(self, args: (f64,)) -> Self::Output {
        keyIsDown1775458590.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,)> for KeyIsDownInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,)) -> Self::Output {
        keyIsDown1775458590.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,)> for KeyIsDownInternalType {
    extern "rust-call" fn call(&self, args: (f64,)) -> Self::Output {
        keyIsDown1775458590.call(args)
    }
}
#[doc=r##"<p>Loads a JSON file from a file or a URL, and returns an Object.
Note that even if the JSON file contains an Array, an Object will be
returned with index numbers as keys.</p>
<p>This method is asynchronous, meaning it may not finish before the next
line in your sketch is executed. JSONP is supported via a polyfill and you
can pass in as the second argument an object with definitions of the json
callback following the syntax specified <a href="https://github.com/camsong/
fetch-jsonp">here</a>.</p>
<p>This method is suitable for fetching files up to size of 64MB.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Examples use USGS Earthquake API:
//   https://earthquake.usgs.gov/fdsnws/event/1/#methods
let earthquakes;
function preload() {
  // Get the most recent earthquake in the database
  let url =
   'https://earthquake.usgs.gov/earthquakes/feed/v1.0/' +
    'summary/all_day.geojson';
  earthquakes = loadJSON(url);
}

function setup() {
  noLoop();
}

function draw() {
  background(200);
  // Get the magnitude and name of the earthquake out of the loaded JSON
  let earthquakeMag = earthquakes.features[0].properties.mag;
  let earthquakeName = earthquakes.features[0].properties.place;
  ellipse(width / 2, height / 2, earthquakeMag * 10, earthquakeMag * 10);
  textAlign(CENTER);
  text(earthquakeName, 0, height - 30, width, 30);
}
```"###]
#[doc=r###"```rust
function setup() {
  noLoop();
  let url =
   'https://earthquake.usgs.gov/earthquakes/feed/v1.0/' +
    'summary/all_day.geojson';
  loadJSON(url, drawEarthquake);
}

function draw() {
  background(200);
}

function drawEarthquake(earthquakes) {
  // Get the magnitude and name of the earthquake out of the loaded JSON
  let earthquakeMag = earthquakes.features[0].properties.mag;
  let earthquakeName = earthquakes.features[0].properties.place;
  ellipse(width / 2, height / 2, earthquakeMag * 10, earthquakeMag * 10);
  textAlign(CENTER);
  text(earthquakeName, 0, height - 30, width, 30);
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>jsonpOptions?</code> options object for jsonp related settings

"##]
///
///
#[doc = r##"<code>datatype?</code> "json" or "jsonp"

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   loadJSON() completes, data is passed
                                   in as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>datatype</code> "json" or "jsonp"

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   loadJSON() completes, data is passed
                                   in as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>callback</code> function to be executed after
                                   loadJSON() completes, data is passed
                                   in as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///

pub static loadJSON: LoadJsonInternalType = LoadJsonInternalType;
#[doc(hidden)]
pub struct LoadJsonInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON3821504875(_ : & str, _ : JsValue, _ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON3821504875.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON3821504875.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON3821504875.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON521465445(_ : & str, _ : JsValue, _ : & str, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON521465445.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON521465445.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON521465445.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON1949232515(_ : & str, _ : JsValue, _ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,&'_ str,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,&'_ str,)) -> Self::Output {
        loadJSON1949232515.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,&'_ str,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,&'_ str,)) -> Self::Output {
        loadJSON1949232515.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,&'_ str,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,&'_ str,)) -> Self::Output {
        loadJSON1949232515.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON2155205768(_ : & str, _ : JsValue, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,)) -> Self::Output {
        loadJSON2155205768.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,)) -> Self::Output {
        loadJSON2155205768.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,)) -> Self::Output {
        loadJSON2155205768.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON486731804(_ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadJSON486731804.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadJSON486731804.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadJSON486731804.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON2960559718(_ : & str, _ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON2960559718.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON2960559718.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON2960559718.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON729990816(_ : & str, _ : & str, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON729990816.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON729990816.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON729990816.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON2503003795(_ : & str, _ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadJSON2503003795.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadJSON2503003795.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadJSON2503003795.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON2328940690(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON2328940690.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON2328940690.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadJSON2328940690.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadJSON")]
    fn loadJSON310329974(_ : & str, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON310329974.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON310329974.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadJsonInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadJSON310329974.call(args)
    }
}
#[doc=r##"<p>Reads the contents of a file and creates a String array of its individual
lines. If the name of the file is used as the parameter, as in the above
example, the file must be located in the sketch directory/folder.</p>
<p>Alternatively, the file maybe be loaded from anywhere on the local
computer using an absolute path (something that starts with / on Unix and
Linux, or a drive letter on Windows), or the filename parameter can be a
URL for a file found on a network.</p>
<p>This method is asynchronous, meaning it may not finish before the next
line in your sketch is executed.</p>
<p>This method is suitable for fetching files up to size of 64MB.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let result;
function preload() {
  result = loadStrings('assets/test.txt');
}

function setup() {
  background(200);
  text(random(result), 10, 10, 80, 80);
}
```"###]
#[doc=r###"```rust
function setup() {
  loadStrings('assets/test.txt', pickString);
}

function pickString(result) {
  background(200);
  text(random(result), 10, 10, 80, 80);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>filename</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after loadStrings()
                              completes, Array is passed in as first
                              argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                              there is an error, response is passed
                              in as first argument

"##]
///

pub static loadStrings: LoadStringsInternalType = LoadStringsInternalType;
#[doc(hidden)]
pub struct LoadStringsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadStrings")]
    fn loadStrings924857752(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadStringsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadStrings924857752.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadStringsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadStrings924857752.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadStringsInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadStrings924857752.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadStrings")]
    fn loadStrings1838297068(_ : & str, _ : js_sys::Function, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadStringsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadStrings1838297068.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadStringsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadStrings1838297068.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadStringsInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadStrings1838297068.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadStrings")]
    fn loadStrings13108207(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadStringsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadStrings13108207.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadStringsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadStrings13108207.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadStringsInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadStrings13108207.call(args)
    }
}
#[doc=r##"<p>Reads the contents of a file or URL and creates a <a href="#/p5.Table">p5.Table</a> object with
its values. If a file is specified, it must be located in the sketch's
"data" folder. The filename parameter can also be a URL to a file found
online. By default, the file is assumed to be comma-separated (in CSV
format). Table only looks for a header row if the 'header' option is
included.</p>
<p>This method is asynchronous, meaning it may not finish before the next
line in your sketch is executed. Calling <a href="#/p5/loadTable">loadTable()</a> inside <a href="#/p5/preload">preload()</a>
guarantees to complete the operation before <a href="#/p5/setup">setup()</a> and <a href="#/p5/draw">draw()</a> are called.
Outside of <a href="#/p5/preload">preload()</a>, you may supply a callback function to handle the
object:</p>
<p>All files loaded and saved use UTF-8 encoding. This method is suitable for fetching files up to size of 64MB.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Given the following CSV file called "mammals.csv"
// located in the project's "assets" folder:
//
// id,species,name
// 0,Capra hircus,Goat
// 1,Panthera pardus,Leopard
// 2,Equus zebra,Zebra

let table;

function preload() {
  //my table is comma separated value "csv"
  //and has a header specifying the columns labels
  table = loadTable('assets/mammals.csv', 'csv', 'header');
  //the file can be remote
  //table = loadTable("http://p5js.org/reference/assets/mammals.csv",
  //                  "csv", "header");
}

function setup() {
  //count the columns
  print(table.getRowCount() + ' total rows in table');
  print(table.getColumnCount() + ' total columns in table');

  print(table.getColumn('name'));
  //["Goat", "Leopard", "Zebra"]

  //cycle through the table
  for (let r = 0; r < table.getRowCount(); r++)
    for (let c = 0; c < table.getColumnCount(); c++) {
      print(table.getString(r, c));
    }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>filename</code> name of the file or URL to load

"##]
///
///
#[doc = r##"<code>extension?</code> parse the table by comma-separated values "csv", semicolon-separated
                                     values "ssv", or tab-separated values "tsv"

"##]
///
///
#[doc = r##"<code>header?</code> "header" to indicate table has header row

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                     loadTable() completes. On success, the
                                     Table object is passed in as the
                                     first argument.

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                     there is an error, response is passed
                                     in as first argument

"##]
///

pub static loadTable: LoadTableInternalType = LoadTableInternalType;
#[doc(hidden)]
pub struct LoadTableInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadTable")]
    fn loadTable3473586981(_ : & str, _ : & str, _ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadTableInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadTable3473586981.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadTable3473586981.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,js_sys::Function,js_sys::Function,)> for LoadTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadTable3473586981.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadTable")]
    fn loadTable2650630685(_ : & str, _ : & str, _ : & str, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,js_sys::Function,)> for LoadTableInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadTable2650630685.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,js_sys::Function,)> for LoadTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadTable2650630685.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,js_sys::Function,)> for LoadTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,js_sys::Function,)) -> Self::Output {
        loadTable2650630685.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadTable")]
    fn loadTable761886391(_ : & str, _ : & str, _ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,)> for LoadTableInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        loadTable761886391.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,)> for LoadTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        loadTable761886391.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,)> for LoadTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        loadTable761886391.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadTable")]
    fn loadTable209300687(_ : & str, _ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for LoadTableInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadTable209300687.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for LoadTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadTable209300687.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for LoadTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        loadTable209300687.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadTable")]
    fn loadTable1007926902(_ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadTableInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadTable1007926902.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadTable1007926902.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadTable1007926902.call(args)
    }
}
#[doc=r##"<p>Reads the contents of a file and creates an XML object with its values.
If the name of the file is used as the parameter, as in the above example,
the file must be located in the sketch directory/folder.</p>
<p>Alternatively, the file maybe be loaded from anywhere on the local
computer using an absolute path (something that starts with / on Unix and
Linux, or a drive letter on Windows), or the filename parameter can be a
URL for a file found on a network.</p>
<p>This method is asynchronous, meaning it may not finish before the next
line in your sketch is executed. Calling <a href="#/p5/loadXML">loadXML()</a> inside <a href="#/p5/preload">preload()</a>
guarantees to complete the operation before <a href="#/p5/setup">setup()</a> and <a href="#/p5/draw">draw()</a> are called.</p>
<p>Outside of <a href="#/p5/preload">preload()</a>, you may supply a callback function to handle the
object.</p>
<p>This method is suitable for fetching files up to size of 64MB.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// The following short XML file called "mammals.xml" is parsed
// in the code below.
//
// 
// <mammals>
//   <animal id="0" species="Capra hircus">Goat</animal>
//   <animal id="1" species="Panthera pardus">Leopard</animal>
//   <animal id="2" species="Equus zebra">Zebra</animal>
// </mammals>

let xml;

function preload() {
  xml = loadXML('assets/mammals.xml');
}

function setup() {
  let children = xml.getChildren('animal');

  for (let i = 0; i < children.length; i++) {
    let id = children[i].getNum('id');
    let coloring = children[i].getString('species');
    let name = children[i].getContent();
    print(id + ', ' + coloring + ', ' + name);
  }
}

// Sketch prints:
// 0, Capra hircus, Goat
// 1, Panthera pardus, Leopard
// 2, Equus zebra, Zebra
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>filename</code> name of the file or URL to load

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after loadXML()
                              completes, XML object is passed in as
                              first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                              there is an error, response is passed
                              in as first argument

"##]
///

pub static loadXML: LoadXmlInternalType = LoadXmlInternalType;
#[doc(hidden)]
pub struct LoadXmlInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadXML")]
    fn loadXML3449664474(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadXmlInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadXML3449664474.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadXmlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadXML3449664474.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadXmlInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadXML3449664474.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadXML")]
    fn loadXML2621228502(_ : & str, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadXmlInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadXML2621228502.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadXmlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadXML2621228502.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadXmlInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadXML2621228502.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadXML")]
    fn loadXML3170479037(_ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadXmlInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadXML3170479037.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadXmlInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadXML3170479037.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadXmlInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadXML3170479037.call(args)
    }
}
#[doc=r##"<p>This method is suitable for fetching files up to size of 64MB.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let data;

function preload() {
  data = loadBytes('assets/mammals.xml');
}

function setup() {
  for (let i = 0; i < 5; i++) {
    console.log(data.bytes[i].toString(16));
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>file</code> name of the file or URL to load

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after loadBytes()
                                   completes

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if there
                                   is an error

"##]
///

pub static loadBytes: LoadBytesInternalType = LoadBytesInternalType;
#[doc(hidden)]
pub struct LoadBytesInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadBytes")]
    fn loadBytes1145197542(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadBytesInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadBytes1145197542.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadBytesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadBytes1145197542.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for LoadBytesInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        loadBytes1145197542.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadBytes")]
    fn loadBytes143850068(_ : & str, _ : js_sys::Function, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for LoadBytesInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadBytes143850068.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for LoadBytesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadBytes143850068.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for LoadBytesInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        loadBytes143850068.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "loadBytes")]
    fn loadBytes111771256(_ : & str, ) -> js_sys::Object;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for LoadBytesInternalType {
    type Output = js_sys::Object;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        loadBytes111771256.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for LoadBytesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        loadBytes111771256.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for LoadBytesInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        loadBytes111771256.call(args)
    }
}
#[doc=r##"<p>Method for executing an HTTP GET request. If data type is not specified,
p5 will try to guess based on the URL, defaulting to text. This is equivalent to
calling <code>httpDo(path, 'GET')</code>. The 'binary' datatype will return
a Blob object, and the 'arrayBuffer' datatype will return an ArrayBuffer
which can be used to initialize typed arrays (such as Uint8Array).</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Examples use USGS Earthquake API:
//   https://earthquake.usgs.gov/fdsnws/event/1/#methods
let earthquakes;
function preload() {
  // Get the most recent earthquake in the database
  let url =
   'https://earthquake.usgs.gov/fdsnws/event/1/query?' +
    'format=geojson&limit=1&orderby=time';
  httpGet(url, 'jsonp', false, function(response) {
    // when the HTTP request completes, populate the variable that holds the
    // earthquake data used in the visualization.
    earthquakes = response;
  });
}

function draw() {
  if (!earthquakes) {
    // Wait until the earthquake data has loaded before drawing.
    return;
  }
  background(200);
  // Get the magnitude and name of the earthquake out of the loaded JSON
  let earthquakeMag = earthquakes.features[0].properties.mag;
  let earthquakeName = earthquakes.features[0].properties.place;
  ellipse(width / 2, height / 2, earthquakeMag * 10, earthquakeMag * 10);
  textAlign(CENTER);
  text(earthquakeName, 0, height - 30, width, 30);
  noLoop();
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>datatype?</code> "json", "jsonp", "binary", "arrayBuffer",
                                   "xml", or "text"

"##]
///
///
#[doc = r##"<code>data?</code> param data passed sent with request

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   httpGet() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>data</code> param data passed sent with request

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   httpGet() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>callback</code> function to be executed after
                                   httpGet() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///

pub static httpGet: HttpGetInternalType = HttpGetInternalType;
#[doc(hidden)]
pub struct HttpGetInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet538500630(_ : & str, _ : & str, _ : JsValue, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet538500630.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet538500630.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet538500630.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet4027022194(_ : & str, _ : & str, _ : JsValue, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpGet4027022194.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpGet4027022194.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpGet4027022194.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet2403898149(_ : & str, _ : & str, _ : JsValue, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,JsValue,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpGet2403898149.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,JsValue,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpGet2403898149.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,JsValue,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpGet2403898149.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet3019183323(_ : & str, _ : & str, _ : bool, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet3019183323.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet3019183323.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet3019183323.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet2494177976(_ : & str, _ : & str, _ : bool, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpGet2494177976.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpGet2494177976.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpGet2494177976.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet772318715(_ : & str, _ : & str, _ : bool, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        httpGet772318715.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        httpGet772318715.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        httpGet772318715.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet1004234822(_ : & str, _ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpGet1004234822.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpGet1004234822.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpGet1004234822.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet3890602830(_ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        httpGet3890602830.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        httpGet3890602830.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        httpGet3890602830.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet3415041175(_ : & str, _ : JsValue, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet3415041175.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet3415041175.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet3415041175.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet852440075(_ : & str, _ : JsValue, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpGet852440075.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpGet852440075.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpGet852440075.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet3011383747(_ : & str, _ : JsValue, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpGet3011383747.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpGet3011383747.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpGet3011383747.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet1000130468(_ : & str, _ : bool, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet1000130468.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet1000130468.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet1000130468.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet1692424169(_ : & str, _ : bool, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpGet1692424169.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpGet1692424169.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpGet1692424169.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet1032328672(_ : & str, _ : bool, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,)) -> Self::Output {
        httpGet1032328672.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,)) -> Self::Output {
        httpGet1032328672.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,)) -> Self::Output {
        httpGet1032328672.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet779788063(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet779788063.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet779788063.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpGet779788063.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpGet")]
    fn httpGet2703064936(_ : & str, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for HttpGetInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        httpGet2703064936.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        httpGet2703064936.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for HttpGetInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        httpGet2703064936.call(args)
    }
}
#[doc=r##"<p>Method for executing an HTTP POST request. If data type is not specified,
p5 will try to guess based on the URL, defaulting to text. This is equivalent to
calling <code>httpDo(path, 'POST')</code>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Examples use jsonplaceholder.typicode.com for a Mock Data API

let url = 'https://jsonplaceholder.typicode.com/posts';
let postData = { userId: 1, title: 'p5 Clicked!', body: 'p5.js is way cool.' };

function setup() {
  createCanvas(800, 800);
}

function mousePressed() {
  // Pick new random color values
  let r = random(255);
  let g = random(255);
  let b = random(255);

  httpPost(url, 'json', postData, function(result) {
    strokeWeight(2);
    stroke(r, g, b);
    fill(r, g, b, 127);
    ellipse(mouseX, mouseY, 200, 200);
    text(result.body, mouseX, mouseY);
  });
}
```"###]
#[doc=r###"```rust
let url = 'ttps://invalidURL'; // A bad URL that will cause errors
let postData = { title: 'p5 Clicked!', body: 'p5.js is way cool.' };

function setup() {
  createCanvas(800, 800);
}

function mousePressed() {
  // Pick new random color values
  let r = random(255);
  let g = random(255);
  let b = random(255);

  httpPost(
    url,
    'json',
    postData,
    function(result) {
      // ... won't be called
    },
    function(error) {
      strokeWeight(2);
      stroke(r, g, b);
      fill(r, g, b, 127);
      text(error.toString(), mouseX, mouseY);
    }
  );
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>datatype?</code> "json", "jsonp", "xml", or "text".
                                   If omitted, httpPost() will guess.

"##]
///
///
#[doc = r##"<code>data?</code> param data passed sent with request

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   httpPost() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>data</code> param data passed sent with request

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   httpPost() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>callback</code> function to be executed after
                                   httpPost() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///

pub static httpPost: HttpPostInternalType = HttpPostInternalType;
#[doc(hidden)]
pub struct HttpPostInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost3740323388(_ : & str, _ : & str, _ : JsValue, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost3740323388.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost3740323388.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost3740323388.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost1230666065(_ : & str, _ : & str, _ : JsValue, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpPost1230666065.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpPost1230666065.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpPost1230666065.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost3016011239(_ : & str, _ : & str, _ : JsValue, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,JsValue,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpPost3016011239.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,JsValue,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpPost3016011239.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,JsValue,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpPost3016011239.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost1159124800(_ : & str, _ : & str, _ : bool, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost1159124800.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost1159124800.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost1159124800.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost1555616831(_ : & str, _ : & str, _ : bool, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpPost1555616831.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpPost1555616831.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpPost1555616831.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost1203661100(_ : & str, _ : & str, _ : bool, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        httpPost1203661100.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        httpPost1203661100.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        httpPost1203661100.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost3627556571(_ : & str, _ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpPost3627556571.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpPost3627556571.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpPost3627556571.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost3271733409(_ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        httpPost3271733409.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        httpPost3271733409.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        httpPost3271733409.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost658927319(_ : & str, _ : JsValue, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost658927319.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost658927319.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost658927319.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost2340551199(_ : & str, _ : JsValue, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpPost2340551199.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpPost2340551199.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpPost2340551199.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost2070591007(_ : & str, _ : JsValue, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpPost2070591007.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpPost2070591007.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpPost2070591007.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost2125653400(_ : & str, _ : bool, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost2125653400.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost2125653400.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost2125653400.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost2610742569(_ : & str, _ : bool, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpPost2610742569.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpPost2610742569.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,js_sys::Function,)) -> Self::Output {
        httpPost2610742569.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost1816569678(_ : & str, _ : bool, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,bool,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,bool,)) -> Self::Output {
        httpPost1816569678.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,bool,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,bool,)) -> Self::Output {
        httpPost1816569678.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,bool,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,bool,)) -> Self::Output {
        httpPost1816569678.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost1714891768(_ : & str, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost1714891768.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost1714891768.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpPost1714891768.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpPost")]
    fn httpPost4080875965(_ : & str, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,js_sys::Function,)> for HttpPostInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        httpPost4080875965.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        httpPost4080875965.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,js_sys::Function,)> for HttpPostInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,js_sys::Function,)) -> Self::Output {
        httpPost4080875965.call(args)
    }
}
#[doc=r##"<p>Method for executing an HTTP request. If data type is not specified,
p5 will try to guess based on the URL, defaulting to text.<br><br>
For more advanced use, you may also pass in the path as the first argument
and a object as the second argument, the signature follows the one specified
in the Fetch API specification.
This method is suitable for fetching files up to size of 64MB when "GET" is used.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
// Examples use USGS Earthquake API:
// https://earthquake.usgs.gov/fdsnws/event/1/#methods

// displays an animation of all USGS earthquakes
let earthquakes;
let eqFeatureIndex = 0;

function preload() {
  let url = 'https://earthquake.usgs.gov/fdsnws/event/1/query?format=geojson';
  httpDo(
    url,
    {
      method: 'GET',
      // Other Request options, like special headers for apis
      headers: { authorization: 'Bearer secretKey' }
    },
    function(res) {
      earthquakes = res;
    }
  );
}

function draw() {
  // wait until the data is loaded
  if (!earthquakes || !earthquakes.features[eqFeatureIndex]) {
    return;
  }
  clear();

  let feature = earthquakes.features[eqFeatureIndex];
  let mag = feature.properties.mag;
  let rad = mag / 11 * ((width + height) / 2);
  fill(255, 0, 0, 100);
  ellipse(width / 2 + random(-2, 2), height / 2 + random(-2, 2), rad, rad);

  if (eqFeatureIndex >= earthquakes.features.length) {
    eqFeatureIndex = 0;
  } else {
    eqFeatureIndex += 1;
  }
}
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>method?</code> either "GET", "POST", or "PUT",
                                   defaults to "GET"

"##]
///
///
#[doc = r##"<code>datatype?</code> "json", "jsonp", "xml", or "text"

"##]
///
///
#[doc = r##"<code>data?</code> param data passed sent with request

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   httpGet() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///
///
#[doc = r##"<code>path</code> name of the file or url to load

"##]
///
///
#[doc = r##"<code>options</code> Request object options as documented in the
                                   "fetch" API
reference

"##]
///
///
#[doc = r##"<code>callback?</code> function to be executed after
                                   httpGet() completes, data is passed in
                                   as first argument

"##]
///
///
#[doc = r##"<code>errorCallback?</code> function to be executed if
                                   there is an error, response is passed
                                   in as first argument

"##]
///
///
/// ---
///

pub static httpDo: HttpDoInternalType = HttpDoInternalType;
#[doc(hidden)]
pub struct HttpDoInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo3566303959(_ : & str, _ : & str, _ : & str, _ : JsValue, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpDo3566303959.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpDo3566303959.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpDo3566303959.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo3010166900(_ : & str, _ : & str, _ : & str, _ : JsValue, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpDo3010166900.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpDo3010166900.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpDo3010166900.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo382985505(_ : & str, _ : & str, _ : & str, _ : JsValue, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,JsValue,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpDo382985505.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,JsValue,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpDo382985505.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,JsValue,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,JsValue,)) -> Self::Output {
        httpDo382985505.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo3139326005(_ : & str, _ : & str, _ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        httpDo3139326005.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        httpDo3139326005.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        httpDo3139326005.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo2958022713(_ : & str, _ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpDo2958022713.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpDo2958022713.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        httpDo2958022713.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo185026388(_ : & str, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        httpDo185026388.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        httpDo185026388.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        httpDo185026388.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo3848020651(_ : & str, _ : JsValue, _ : js_sys::Function, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpDo3848020651.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpDo3848020651.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,js_sys::Function,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,js_sys::Function,js_sys::Function,)) -> Self::Output {
        httpDo3848020651.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo1112124800(_ : & str, _ : JsValue, _ : js_sys::Function, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,js_sys::Function,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpDo1112124800.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpDo1112124800.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,js_sys::Function,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,js_sys::Function,)) -> Self::Output {
        httpDo1112124800.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "httpDo")]
    fn httpDo1393396467(_ : & str, _ : JsValue, ) -> js_sys::Promise;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,JsValue,)> for HttpDoInternalType {
    type Output = js_sys::Promise;
    extern "rust-call" fn call_once(self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpDo1393396467.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,JsValue,)> for HttpDoInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpDo1393396467.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,JsValue,)> for HttpDoInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,JsValue,)) -> Self::Output {
        httpDo1393396467.call(args)
    }
}
/// No description available

///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 100);
  background(200);
  text('click here to save', 10, 10, 70, 80);
}

function mousePressed() {
  if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
    const writer = createWriter('squares.txt');
    for (let i = 0; i < 10; i++) {
      writer.print(i * i);
    }
    writer.close();
    writer.clear();
  }
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>name</code> name of the file to be created

"##]
///
///
#[doc = r##"<code>extension?</code> 
"##]
///

pub static createWriter: CreateWriterInternalType = CreateWriterInternalType;
#[doc(hidden)]
pub struct CreateWriterInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createWriter")]
    fn createWriter1572387715(_ : & str, _ : & str, ) ->  PrintWriter;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for CreateWriterInternalType {
    type Output =  PrintWriter;
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createWriter1572387715.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for CreateWriterInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createWriter1572387715.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for CreateWriterInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        createWriter1572387715.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createWriter")]
    fn createWriter543306631(_ : & str, ) ->  PrintWriter;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for CreateWriterInternalType {
    type Output =  PrintWriter;
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        createWriter543306631.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for CreateWriterInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        createWriter543306631.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for CreateWriterInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        createWriter543306631.call(args)
    }
}
#[doc=r##"<p>Saves a given element(image, text, json, csv, wav, or html) to the client's
computer. The first parameter can be a pointer to element we want to save.
The element can be one of <a href="#/p5.Element">p5.Element</a>,an Array of
Strings, an Array of JSON, a JSON object, a <a href="#/p5.Table">p5.Table
</a>, a <a href="#/p5.Image">p5.Image</a>, or a p5.SoundFile (requires
p5.sound). The second parameter is a filename (including extension).The
third parameter is for options specific to this type of object. This method
will save a file that fits the given parameters.
If it is called without specifying an element, by default it will save the
whole canvas as an image file. You can optionally specify a filename as
the first parameter in such a case.
<strong>Note that it is not recommended to
call this method within draw, as it will open a new save dialog on every
render.</strong></p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 // Saves the canvas as an image
 cnv = createCanvas(300, 300);
 save(cnv, 'myCanvas.jpg');

 // Saves the canvas as an image by default
 save('myCanvas.jpg');
 ```"###]
#[doc=r###"```rust
 // Saves p5.Image as an image
 img = createImage(10, 10);
 save(img, 'myImage.png');
 ```"###]
#[doc=r###"```rust
 // Saves p5.Renderer object as an image
 obj = createGraphics(100, 100);
 save(obj, 'myObject.png');
 ```"###]
#[doc=r###"```rust
 let myTable = new p5.Table();
 // Saves table as html file
 save(myTable, 'myTable.html');

 // Comma Separated Values
 save(myTable, 'myTable.csv');

 // Tab Separated Values
 save(myTable, 'myTable.tsv');
 ```"###]
#[doc=r###"```rust
 let myJSON = { a: 1, b: true };

 // Saves pretty JSON
 save(myJSON, 'my.json');

 // Optimizes JSON filesize
 save(myJSON, 'my.json', true);
 ```"###]
#[doc=r###"```rust
 // Saves array of strings to text file with line breaks after each item
 let arrayOfStrings = ['a', 'b'];
 save(arrayOfStrings, 'my.txt');
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>objectOrFilename?</code> If filename is provided, will
                                           save canvas as an image with
                                           either png or jpg extension
                                           depending on the filename.
                                           If object is provided, will
                                           save depending on the object
                                           and filename (see examples
                                           above).

"##]
///
///
#[doc = r##"<code>filename?</code> If an object is provided as the first
                             parameter, then the second parameter
                             indicates the filename,
                             and should include an appropriate
                             file extension (see examples above).

"##]
///
///
#[doc = r##"<code>options?</code> Additional options depend on
                          filetype. For example, when saving JSON,
                          true indicates that the
                          output will be optimized for filesize,
                          rather than readability.

"##]
///

pub static save: SaveInternalType = SaveInternalType;
#[doc(hidden)]
pub struct SaveInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save2680295680(_ : JsValue, _ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,bool,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,bool,)) -> Self::Output {
        save2680295680.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,bool,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,bool,)) -> Self::Output {
        save2680295680.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,bool,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,bool,)) -> Self::Output {
        save2680295680.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save3326729834(_ : JsValue, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,&'_ str,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,&'_ str,)) -> Self::Output {
        save3326729834.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,&'_ str,)) -> Self::Output {
        save3326729834.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,&'_ str,)) -> Self::Output {
        save3326729834.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save2230704792(_ : JsValue, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,)) -> Self::Output {
        save2230704792.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,)) -> Self::Output {
        save2230704792.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,)) -> Self::Output {
        save2230704792.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save2651846913(_ : JsValue, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,)) -> Self::Output {
        save2651846913.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,)) -> Self::Output {
        save2651846913.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,)) -> Self::Output {
        save2651846913.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save2112178144(_ : & str, _ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,bool,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        save2112178144.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,bool,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        save2112178144.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,bool,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,bool,)) -> Self::Output {
        save2112178144.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save3998918152(_ : & str, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,&'_ str,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        save3998918152.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        save3998918152.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,&'_ str,)) -> Self::Output {
        save3998918152.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save3522320965(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        save3522320965.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        save3522320965.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        save3522320965.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save4267564376(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        save4267564376.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        save4267564376.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SaveInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        save4267564376.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "save")]
    fn save2473877019() ;
}

#[doc(hidden)]
impl FnOnce<()> for SaveInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        save2473877019.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for SaveInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        save2473877019.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for SaveInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        save2473877019.call(args)
    }
}
#[doc=r##"<p>Writes the contents of an Array or a JSON object to a .json file.
The file saving process and location of the saved file will
vary between web browsers.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 let json = {}; // new  JSON Object

 json.id = 0;
 json.species = 'Panthera leo';
 json.name = 'Lion';

 function setup() {
 createCanvas(100, 100);
 background(200);
 text('click here to save', 10, 10, 70, 80);
 }

 function mousePressed() {
 if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
   saveJSON(json, 'lion.json');
 }
 }

 // saves the following to a file called "lion.json":
 // {
 //   "id": 0,
 //   "species": "Panthera leo",
 //   "name": "Lion"
 // }
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>json</code> 
"##]
///
///
#[doc = r##"<code>filename</code> 
"##]
///
///
#[doc = r##"<code>optimize?</code> If true, removes line breaks
                               and spaces from the output
                               file to optimize filesize
                               (but not readability).

"##]
///

pub static saveJSON: SaveJsonInternalType = SaveJsonInternalType;
#[doc(hidden)]
pub struct SaveJsonInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveJSON")]
    fn saveJSON549021301(_ : js_sys::Array, _ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,bool,)> for SaveJsonInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,bool,)) -> Self::Output {
        saveJSON549021301.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,bool,)> for SaveJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,bool,)) -> Self::Output {
        saveJSON549021301.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,bool,)> for SaveJsonInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,bool,)) -> Self::Output {
        saveJSON549021301.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveJSON")]
    fn saveJSON791113174(_ : js_sys::Array, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,)> for SaveJsonInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        saveJSON791113174.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,)> for SaveJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        saveJSON791113174.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,)> for SaveJsonInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        saveJSON791113174.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveJSON")]
    fn saveJSON753564954(_ : JsValue, _ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,bool,)> for SaveJsonInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,bool,)) -> Self::Output {
        saveJSON753564954.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,bool,)> for SaveJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,bool,)) -> Self::Output {
        saveJSON753564954.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,bool,)> for SaveJsonInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,bool,)) -> Self::Output {
        saveJSON753564954.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveJSON")]
    fn saveJSON3900948025(_ : JsValue, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(JsValue,&'_ str,)> for SaveJsonInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (JsValue,&'_ str,)) -> Self::Output {
        saveJSON3900948025.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(JsValue,&'_ str,)> for SaveJsonInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (JsValue,&'_ str,)) -> Self::Output {
        saveJSON3900948025.call(args)
    }
}

#[doc(hidden)]
impl Fn<(JsValue,&'_ str,)> for SaveJsonInternalType {
    extern "rust-call" fn call(&self, args: (JsValue,&'_ str,)) -> Self::Output {
        saveJSON3900948025.call(args)
    }
}
#[doc=r##"<p>Writes an array of Strings to a text file, one line per String.
The file saving process and location of the saved file will
vary between web browsers.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 let words = 'apple bear cat dog';

 // .split() outputs an Array
 let list = split(words, ' ');

 function setup() {
 createCanvas(100, 100);
 background(200);
 text('click here to save', 10, 10, 70, 80);
 }

 function mousePressed() {
 if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
   saveStrings(list, 'nouns.txt');
 }
 }

 // Saves the following to a file called 'nouns.txt':
 //
 // apple
 // bear
 // cat
 // dog
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> string array to be written

"##]
///
///
#[doc = r##"<code>filename</code> filename for output

"##]
///
///
#[doc = r##"<code>extension?</code> the filename's extension

"##]
///
///
#[doc = r##"<code>isCRLF?</code> if true, change line-break to CRLF

"##]
///

pub static saveStrings: SaveStringsInternalType = SaveStringsInternalType;
#[doc(hidden)]
pub struct SaveStringsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveStrings")]
    fn saveStrings2912981391(_ : js_sys::Array, _ : & str, _ : & str, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,&'_ str,bool,)> for SaveStringsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,&'_ str,bool,)) -> Self::Output {
        saveStrings2912981391.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,&'_ str,bool,)> for SaveStringsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,&'_ str,bool,)) -> Self::Output {
        saveStrings2912981391.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,&'_ str,bool,)> for SaveStringsInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,&'_ str,bool,)) -> Self::Output {
        saveStrings2912981391.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveStrings")]
    fn saveStrings797083405(_ : js_sys::Array, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,&'_ str,)> for SaveStringsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,&'_ str,)) -> Self::Output {
        saveStrings797083405.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,&'_ str,)> for SaveStringsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,&'_ str,)) -> Self::Output {
        saveStrings797083405.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,&'_ str,)> for SaveStringsInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,&'_ str,)) -> Self::Output {
        saveStrings797083405.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveStrings")]
    fn saveStrings934674721(_ : js_sys::Array, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,&'_ str,)> for SaveStringsInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        saveStrings934674721.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,&'_ str,)> for SaveStringsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        saveStrings934674721.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,&'_ str,)> for SaveStringsInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,&'_ str,)) -> Self::Output {
        saveStrings934674721.call(args)
    }
}
#[doc=r##"<p>Writes the contents of a <a href="#/p5.Table">Table</a> object to a file. Defaults to a
text file with comma-separated-values ('csv') but can also
use tab separation ('tsv'), or generate an HTML table ('html').
The file saving process and location of the saved file will
vary between web browsers.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 let table;

 function setup() {
 table = new p5.Table();

 table.addColumn('id');
 table.addColumn('species');
 table.addColumn('name');

 let newRow = table.addRow();
 newRow.setNum('id', table.getRowCount() - 1);
 newRow.setString('species', 'Panthera leo');
 newRow.setString('name', 'Lion');

 // To save, un-comment next line then click 'run'
 // saveTable(table, 'new.csv');
 }

 // Saves the following to a file called 'new.csv':
 // id,species,name
 // 0,Panthera leo,Lion
 ```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>Table</code> the Table object to save to a file

"##]
///
///
#[doc = r##"<code>filename</code> the filename to which the Table should be saved

"##]
///
///
#[doc = r##"<code>options?</code> can be one of "tsv", "csv", or "html"

"##]
///

pub static saveTable: SaveTableInternalType = SaveTableInternalType;
#[doc(hidden)]
pub struct SaveTableInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveTable")]
    fn saveTable3617999184(_ : & Table, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Table,&'_ str,&'_ str,)> for SaveTableInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Table,&'_ str,&'_ str,)) -> Self::Output {
        saveTable3617999184.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Table,&'_ str,&'_ str,)> for SaveTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Table,&'_ str,&'_ str,)) -> Self::Output {
        saveTable3617999184.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Table,&'_ str,&'_ str,)> for SaveTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Table,&'_ str,&'_ str,)) -> Self::Output {
        saveTable3617999184.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveTable")]
    fn saveTable3970021730(_ : & Table, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Table,&'_ str,)> for SaveTableInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Table,&'_ str,)) -> Self::Output {
        saveTable3970021730.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Table,&'_ str,)> for SaveTableInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Table,&'_ str,)) -> Self::Output {
        saveTable3970021730.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Table,&'_ str,)> for SaveTableInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Table,&'_ str,)) -> Self::Output {
        saveTable3970021730.call(args)
    }
}
#[doc=r##"<p>Adds a value to the end of an array. Extends the length of
the array by one. Maps to Array.push().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let myArray = ['Mango', 'Apple', 'Papaya'];
  print(myArray); // ['Mango', 'Apple', 'Papaya']

  append(myArray, 'Peach');
  print(myArray); // ['Mango', 'Apple', 'Papaya', 'Peach']
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>array</code> Array to append

"##]
///
///
#[doc = r##"<code>value</code> to be added to the Array

"##]
///

pub static append: AppendInternalType = AppendInternalType;
#[doc(hidden)]
pub struct AppendInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "append")]
    fn append518383231(_ : js_sys::Array, _ : JsValue, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,JsValue,)> for AppendInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,JsValue,)) -> Self::Output {
        append518383231.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,JsValue,)> for AppendInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,JsValue,)) -> Self::Output {
        append518383231.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,JsValue,)> for AppendInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,JsValue,)) -> Self::Output {
        append518383231.call(args)
    }
}
#[doc=r##"<p>Copies an array (or part of an array) to another array. The src array is
copied to the dst array, beginning at the position specified by
srcPosition and into the position specified by dstPosition. The number of
elements to copy is determined by length. Note that copying values
overwrites existing values in the destination array. To append values
instead of overwriting them, use <a href="#/p5/concat">concat()</a>.</p>
<p>The simplified version with only two arguments, arrayCopy(src, dst),
copies an entire array to another of the same size. It is equivalent to
arrayCopy(src, 0, dst, 0, src.length).</p>
<p>Using this function is far more efficient for copying array data than
iterating through a for() loop and copying each element individually.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let src = ['A', 'B', 'C'];
let dst = [1, 2, 3];
let srcPosition = 1;
let dstPosition = 0;
let length = 2;

print(src); // ['A', 'B', 'C']
print(dst); // [ 1 ,  2 ,  3 ]

arrayCopy(src, srcPosition, dst, dstPosition, length);
print(dst); // ['B', 'C', 3]
```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>src</code> the source Array

"##]
///
///
#[doc = r##"<code>srcPosition</code> starting position in the source Array

"##]
///
///
#[doc = r##"<code>dst</code> the destination Array

"##]
///
///
#[doc = r##"<code>dstPosition</code> starting position in the destination Array

"##]
///
///
#[doc = r##"<code>length</code> number of Array elements to be copied

"##]
///
///
/// ---
///
///
#[doc = r##"<code>src</code> the source Array

"##]
///
///
#[doc = r##"<code>dst</code> the destination Array

"##]
///
///
#[doc = r##"<code>length?</code> number of Array elements to be copied

"##]
///
///
/// ---
///

pub static arrayCopy: ArrayCopyInternalType = ArrayCopyInternalType;
#[doc(hidden)]
pub struct ArrayCopyInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "arrayCopy")]
    fn arrayCopy3673153524(_ : js_sys::Array, _ : i32, _ : js_sys::Array, _ : i32, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,js_sys::Array,i32,i32,)> for ArrayCopyInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,js_sys::Array,i32,i32,)) -> Self::Output {
        arrayCopy3673153524.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,js_sys::Array,i32,i32,)> for ArrayCopyInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,js_sys::Array,i32,i32,)) -> Self::Output {
        arrayCopy3673153524.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,js_sys::Array,i32,i32,)> for ArrayCopyInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,js_sys::Array,i32,i32,)) -> Self::Output {
        arrayCopy3673153524.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "arrayCopy")]
    fn arrayCopy2477520722(_ : js_sys::Array, _ : js_sys::Array, _ : i32, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,js_sys::Array,i32,)> for ArrayCopyInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,js_sys::Array,i32,)) -> Self::Output {
        arrayCopy2477520722.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,js_sys::Array,i32,)> for ArrayCopyInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,js_sys::Array,i32,)) -> Self::Output {
        arrayCopy2477520722.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,js_sys::Array,i32,)> for ArrayCopyInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,js_sys::Array,i32,)) -> Self::Output {
        arrayCopy2477520722.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "arrayCopy")]
    fn arrayCopy3659982786(_ : js_sys::Array, _ : js_sys::Array, ) ;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,js_sys::Array,)> for ArrayCopyInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (js_sys::Array,js_sys::Array,)) -> Self::Output {
        arrayCopy3659982786.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,js_sys::Array,)> for ArrayCopyInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,js_sys::Array,)) -> Self::Output {
        arrayCopy3659982786.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,js_sys::Array,)> for ArrayCopyInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,js_sys::Array,)) -> Self::Output {
        arrayCopy3659982786.call(args)
    }
}
#[doc=r##"<p>Concatenates two arrays, maps to Array.concat(). Does not modify the
input arrays.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let arr1 = ['A', 'B', 'C'];
  let arr2 = [1, 2, 3];

  print(arr1); // ['A','B','C']
  print(arr2); // [1,2,3]

  let arr3 = concat(arr1, arr2);

  print(arr1); // ['A','B','C']
  print(arr2); // [1, 2, 3]
  print(arr3); // ['A','B','C', 1, 2, 3]
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>a</code> first Array to concatenate

"##]
///
///
#[doc = r##"<code>b</code> second Array to concatenate

"##]
///

pub static concat: ConcatInternalType = ConcatInternalType;
#[doc(hidden)]
pub struct ConcatInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "concat")]
    fn concat487831388(_ : js_sys::Array, _ : js_sys::Array, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,js_sys::Array,)> for ConcatInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,js_sys::Array,)) -> Self::Output {
        concat487831388.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,js_sys::Array,)> for ConcatInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,js_sys::Array,)) -> Self::Output {
        concat487831388.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,js_sys::Array,)> for ConcatInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,js_sys::Array,)) -> Self::Output {
        concat487831388.call(args)
    }
}
#[doc=r##"<p>Reverses the order of an array, maps to Array.reverse()</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let myArray = ['A', 'B', 'C'];
  print(myArray); // ['A','B','C']

  reverse(myArray);
  print(myArray); // ['C','B','A']
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> Array to reverse

"##]
///

pub static reverse: ReverseInternalType = ReverseInternalType;
#[doc(hidden)]
pub struct ReverseInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "reverse")]
    fn reverse2346010962(_ : js_sys::Array, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for ReverseInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        reverse2346010962.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for ReverseInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        reverse2346010962.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for ReverseInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        reverse2346010962.call(args)
    }
}
#[doc=r##"<p>Decreases an array by one element and returns the shortened array,
maps to Array.pop().</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let myArray = ['A', 'B', 'C'];
  print(myArray); // ['A', 'B', 'C']
  let newArray = shorten(myArray);
  print(myArray); // ['A','B','C']
  print(newArray); // ['A','B']
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> Array to shorten

"##]
///

pub static shorten: ShortenInternalType = ShortenInternalType;
#[doc(hidden)]
pub struct ShortenInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shorten")]
    fn shorten3698192937(_ : js_sys::Array, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for ShortenInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        shorten3698192937.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for ShortenInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        shorten3698192937.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for ShortenInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        shorten3698192937.call(args)
    }
}
#[doc=r##"<p>Randomizes the order of the elements of an array. Implements
<a href='http://Bost.Ocks.org/mike/shuffle/' target=_blank>
Fisher-Yates Shuffle Algorithm</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let regularArr = ['ABC', 'def', createVector(), TAU, Math.E];
  print(regularArr);
  shuffle(regularArr, true); // force modifications to passed array
  print(regularArr);

  // By default shuffle() returns a shuffled cloned array:
  let newArr = shuffle(regularArr);
  print(regularArr);
  print(newArr);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>array</code> Array to shuffle

"##]
///
///
#[doc = r##"<code>bool?</code> modify passed array

"##]
///

pub static shuffle: ShuffleInternalType = ShuffleInternalType;
#[doc(hidden)]
pub struct ShuffleInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shuffle")]
    fn shuffle2156651590(_ : js_sys::Array, _ : bool, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,bool,)> for ShuffleInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,bool,)) -> Self::Output {
        shuffle2156651590.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,bool,)> for ShuffleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,bool,)) -> Self::Output {
        shuffle2156651590.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,bool,)> for ShuffleInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,bool,)) -> Self::Output {
        shuffle2156651590.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "shuffle")]
    fn shuffle3507977306(_ : js_sys::Array, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for ShuffleInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        shuffle3507977306.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for ShuffleInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        shuffle3507977306.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for ShuffleInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        shuffle3507977306.call(args)
    }
}
#[doc=r##"<p>Sorts an array of numbers from smallest to largest, or puts an array of
words in alphabetical order. The original array is not modified; a
re-ordered array is returned. The count parameter states the number of
elements to sort. For example, if there are 12 elements in an array and
count is set to 5, only the first 5 elements in the array will be sorted.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let words = ['banana', 'apple', 'pear', 'lime'];
  print(words); // ['banana', 'apple', 'pear', 'lime']
  let count = 4; // length of array

  words = sort(words, count);
  print(words); // ['apple', 'banana', 'lime', 'pear']
}
```"###]
#[doc=r###"```rust
function setup() {
  let numbers = [2, 6, 1, 5, 14, 9, 8, 12];
  print(numbers); // [2, 6, 1, 5, 14, 9, 8, 12]
  let count = 5; // Less than the length of the array

  numbers = sort(numbers, count);
  print(numbers); // [1,2,5,6,14,9,8,12]
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> Array to sort

"##]
///
///
#[doc = r##"<code>count?</code> number of elements to sort, starting from 0

"##]
///

pub static sort: SortInternalType = SortInternalType;
#[doc(hidden)]
pub struct SortInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sort")]
    fn sort544457332(_ : js_sys::Array, _ : i32, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,)> for SortInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,)) -> Self::Output {
        sort544457332.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,)> for SortInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,)) -> Self::Output {
        sort544457332.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,)> for SortInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,)) -> Self::Output {
        sort544457332.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "sort")]
    fn sort2543696511(_ : js_sys::Array, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,)> for SortInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,)) -> Self::Output {
        sort2543696511.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,)> for SortInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,)) -> Self::Output {
        sort2543696511.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,)> for SortInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,)) -> Self::Output {
        sort2543696511.call(args)
    }
}
#[doc=r##"<p>Inserts a value or an array of values into an existing array. The first
parameter specifies the initial array to be modified, and the second
parameter defines the data to be inserted. The third parameter is an index
value which specifies the array position from which to insert data.
(Remember that array index numbering starts at zero, so the first position
is 0, the second position is 1, and so on.)</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let myArray = [0, 1, 2, 3, 4];
  let insArray = ['A', 'B', 'C'];
  print(myArray); // [0, 1, 2, 3, 4]
  print(insArray); // ['A','B','C']

  splice(myArray, insArray, 3);
  print(myArray); // [0,1,2,'A','B','C',3,4]
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> Array to splice into

"##]
///
///
#[doc = r##"<code>value</code> value to be spliced in

"##]
///
///
#[doc = r##"<code>position</code> in the array from which to insert data

"##]
///

pub static splice: SpliceInternalType = SpliceInternalType;
#[doc(hidden)]
pub struct SpliceInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "splice")]
    fn splice4113154429(_ : js_sys::Array, _ : JsValue, _ : i32, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,JsValue,i32,)> for SpliceInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,JsValue,i32,)) -> Self::Output {
        splice4113154429.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,JsValue,i32,)> for SpliceInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,JsValue,i32,)) -> Self::Output {
        splice4113154429.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,JsValue,i32,)> for SpliceInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,JsValue,i32,)) -> Self::Output {
        splice4113154429.call(args)
    }
}
#[doc=r##"<p>Extracts an array of elements from an existing array. The list parameter
defines the array from which the elements will be copied, and the start
and count parameters specify which elements to extract. If no count is
given, elements will be extracted from the start to the end of the array.
When specifying the start, remember that the first array element is 0.
This function does not change the source array.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  let myArray = [1, 2, 3, 4, 5];
  print(myArray); // [1, 2, 3, 4, 5]

  let sub1 = subset(myArray, 0, 3);
  let sub2 = subset(myArray, 2, 2);
  print(sub1); // [1,2,3]
  print(sub2); // [3,4]
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>list</code> Array to extract from

"##]
///
///
#[doc = r##"<code>start</code> position to begin

"##]
///
///
#[doc = r##"<code>count?</code> number of values to extract

"##]
///

pub static subset: SubsetInternalType = SubsetInternalType;
#[doc(hidden)]
pub struct SubsetInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "subset")]
    fn subset2937050010(_ : js_sys::Array, _ : i32, _ : i32, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,i32,)> for SubsetInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        subset2937050010.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,i32,)> for SubsetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        subset2937050010.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,i32,)> for SubsetInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,i32,)) -> Self::Output {
        subset2937050010.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "subset")]
    fn subset3388893379(_ : js_sys::Array, _ : i32, ) -> js_sys::Array;
}

#[doc(hidden)]
impl FnOnce<(js_sys::Array,i32,)> for SubsetInternalType {
    type Output = js_sys::Array;
    extern "rust-call" fn call_once(self, args: (js_sys::Array,i32,)) -> Self::Output {
        subset3388893379.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(js_sys::Array,i32,)> for SubsetInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (js_sys::Array,i32,)) -> Self::Output {
        subset3388893379.call(args)
    }
}

#[doc(hidden)]
impl Fn<(js_sys::Array,i32,)> for SubsetInternalType {
    extern "rust-call" fn call(&self, args: (js_sys::Array,i32,)) -> Self::Output {
        subset3388893379.call(args)
    }
}
#[doc=r##"<p>Creates a new <a href="#/p5.Image">p5.Image</a> (the datatype for storing images). This provides a
fresh buffer of pixels to play with. Set the size of the buffer with the
width and height parameters.</p>
<p>.<a href="#/p5.Image/pixels">pixels</a> gives access to an array containing the values for all the pixels
in the display window.
These values are numbers. This array is the size (including an appropriate
factor for the <a href="#/p5/pixelDensity">pixelDensity</a>) of the display window x4,
representing the R, G, B, A values in order for each pixel, moving from
left to right across each row, then down each column. See .<a href="#/p5.Image/pixels">pixels</a> for
more info. It may also be simpler to use <a href="#/p5.Image/set">set()</a> or <a href="#/p5.Image/get">get()</a>.</p>
<p>Before accessing the pixels of an image, the data must loaded with the
<a href="#/p5.Image/loadPixels">loadPixels()</a> function. After the array data has been modified, the
<a href="#/p5.Image/updatePixels">updatePixels()</a> function must be run to update the changes.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let img = createImage(66, 66);
img.loadPixels();
for (let i = 0; i < img.width; i++) {
  for (let j = 0; j < img.height; j++) {
    img.set(i, j, color(0, 90, 102));
  }
}
img.updatePixels();
image(img, 17, 17);
```"###]
#[doc=r###"```rust
let img = createImage(66, 66);
img.loadPixels();
for (let i = 0; i < img.width; i++) {
  for (let j = 0; j < img.height; j++) {
    img.set(i, j, color(0, 90, 102, (i % img.width) * 2));
  }
}
img.updatePixels();
image(img, 17, 17);
image(img, 34, 34);
```"###]
#[doc=r###"```rust
let pink = color(255, 102, 204);
let img = createImage(66, 66);
img.loadPixels();
let d = pixelDensity();
let halfImage = 4 * (img.width * d) * (img.height / 2 * d);
for (let i = 0; i < halfImage; i += 4) {
  img.pixels[i] = red(pink);
  img.pixels[i + 1] = green(pink);
  img.pixels[i + 2] = blue(pink);
  img.pixels[i + 3] = alpha(pink);
}
img.updatePixels();
image(img, 17, 17);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>width</code> width in pixels

"##]
///
///
#[doc = r##"<code>height</code> height in pixels

"##]
///

pub static createImage: CreateImageInternalType = CreateImageInternalType;
#[doc(hidden)]
pub struct CreateImageInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createImage")]
    fn createImage2559448072(_ : i32, _ : i32, ) ->  Image;
}

#[doc(hidden)]
impl FnOnce<(i32,i32,)> for CreateImageInternalType {
    type Output =  Image;
    extern "rust-call" fn call_once(self, args: (i32,i32,)) -> Self::Output {
        createImage2559448072.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(i32,i32,)> for CreateImageInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (i32,i32,)) -> Self::Output {
        createImage2559448072.call(args)
    }
}

#[doc(hidden)]
impl Fn<(i32,i32,)> for CreateImageInternalType {
    extern "rust-call" fn call(&self, args: (i32,i32,)) -> Self::Output {
        createImage2559448072.call(args)
    }
}
#[doc=r##"<p>Save the current canvas as an image. The browser will either save the
file immediately, or prompt the user with a dialogue window.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 function setup() {
 let c = createCanvas(100, 100);
 background(255, 0, 0);
 saveCanvas(c, 'myCanvas', 'jpg');
 }
 ```"###]
#[doc=r###"```rust
 // note that this example has the same result as above
 // if no canvas is specified, defaults to main canvas
 function setup() {
 let c = createCanvas(100, 100);
 background(255, 0, 0);
 saveCanvas('myCanvas', 'jpg');

 // all of the following are valid
 saveCanvas(c, 'myCanvas', 'jpg');
 saveCanvas(c, 'myCanvas.jpg');
 saveCanvas(c, 'myCanvas');
 saveCanvas(c);
 saveCanvas('myCanvas', 'png');
 saveCanvas('myCanvas');
 saveCanvas();
 }
 ```"###]
/// <h2>Overloads</h2>
///
#[doc = r##"<code>selectedCanvas</code> a variable
                                representing a specific html5 canvas (optional)

"##]
///
///
#[doc = r##"<code>filename?</code> 
"##]
///
///
#[doc = r##"<code>extension?</code> 'jpg' or 'png'

"##]
///
///
/// ---
///
///
#[doc = r##"<code>filename?</code> 
"##]
///
///
#[doc = r##"<code>extension?</code> 'jpg' or 'png'

"##]
///
///
/// ---
///

pub static saveCanvas: SaveCanvasInternalType = SaveCanvasInternalType;
#[doc(hidden)]
pub struct SaveCanvasInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas1517594658(_ : & Element, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,&'_ str,&'_ str,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas1517594658.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,&'_ str,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas1517594658.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,&'_ str,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas1517594658.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas1267909474(_ : & Element, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,&'_ str,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,&'_ str,)) -> Self::Output {
        saveCanvas1267909474.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,&'_ str,)) -> Self::Output {
        saveCanvas1267909474.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,&'_ str,)) -> Self::Output {
        saveCanvas1267909474.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas663379273(_ : & Element, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ Element,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ Element,)) -> Self::Output {
        saveCanvas663379273.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ Element,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ Element,)) -> Self::Output {
        saveCanvas663379273.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ Element,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (&'_ Element,)) -> Self::Output {
        saveCanvas663379273.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas3400503945(_ : HTMLCanvasElement, _ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(HTMLCanvasElement,&'_ str,&'_ str,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (HTMLCanvasElement,&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas3400503945.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(HTMLCanvasElement,&'_ str,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (HTMLCanvasElement,&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas3400503945.call(args)
    }
}

#[doc(hidden)]
impl Fn<(HTMLCanvasElement,&'_ str,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (HTMLCanvasElement,&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas3400503945.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas2597786788(_ : HTMLCanvasElement, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(HTMLCanvasElement,&'_ str,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (HTMLCanvasElement,&'_ str,)) -> Self::Output {
        saveCanvas2597786788.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(HTMLCanvasElement,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (HTMLCanvasElement,&'_ str,)) -> Self::Output {
        saveCanvas2597786788.call(args)
    }
}

#[doc(hidden)]
impl Fn<(HTMLCanvasElement,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (HTMLCanvasElement,&'_ str,)) -> Self::Output {
        saveCanvas2597786788.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas2513720672(_ : HTMLCanvasElement, ) ;
}

#[doc(hidden)]
impl FnOnce<(HTMLCanvasElement,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (HTMLCanvasElement,)) -> Self::Output {
        saveCanvas2513720672.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(HTMLCanvasElement,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (HTMLCanvasElement,)) -> Self::Output {
        saveCanvas2513720672.call(args)
    }
}

#[doc(hidden)]
impl Fn<(HTMLCanvasElement,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (HTMLCanvasElement,)) -> Self::Output {
        saveCanvas2513720672.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas2811927246(_ : & str, _ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas2811927246.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas2811927246.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,)) -> Self::Output {
        saveCanvas2811927246.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas2664072050(_ : & str, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,)> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,)) -> Self::Output {
        saveCanvas2664072050.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,)) -> Self::Output {
        saveCanvas2664072050.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,)> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,)) -> Self::Output {
        saveCanvas2664072050.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveCanvas")]
    fn saveCanvas2961206942() ;
}

#[doc(hidden)]
impl FnOnce<()> for SaveCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        saveCanvas2961206942.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for SaveCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        saveCanvas2961206942.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for SaveCanvasInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        saveCanvas2961206942.call(args)
    }
}
#[doc=r##"<p>Capture a sequence of frames that can be used to create a movie.
Accepts a callback. For example, you may wish to send the frames
to a server where they can be stored or converted into a movie.
If no callback is provided, the browser will pop up save dialogues in an
attempt to download all of the images that have just been created. With the
callback provided the image data isn't saved by default but instead passed
as an argument to the callback function as an array of objects, with the
size of array equal to the total number of frames.</p>
<p>Note that <a href="#/p5.Image/saveFrames">saveFrames()</a> will only save the first 15 frames of an animation.
To export longer animations, you might look into a library like
<a href="https://github.com/spite/ccapture.js/">ccapture.js</a>.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
 function draw() {
 background(mouseX);
 }

 function mousePressed() {
 saveFrames('out', 'png', 1, 25, data => {
   print(data);
 });
 }
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>filename</code> 
"##]
///
///
#[doc = r##"<code>extension</code> 'jpg' or 'png'

"##]
///
///
#[doc = r##"<code>duration</code> Duration in seconds to save the frames for.

"##]
///
///
#[doc = r##"<code>framerate</code> Framerate to save the frames in.

"##]
///
///
#[doc = r##"<code>callback?</code> A callback function that will be executed
                                to handle the image data. This function
                                should accept an array as argument. The
                                array will contain the specified number of
                                frames of objects. Each object has three
                                properties: imageData - an
                                image/octet-stream, filename and extension.

"##]
///

pub static saveFrames: SaveFramesInternalType = SaveFramesInternalType;
#[doc(hidden)]
pub struct SaveFramesInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveFrames")]
    fn saveFrames3201956655(_ : & str, _ : & str, _ : f64, _ : f64, _ : js_sys::Function, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,f64,f64,js_sys::Function,)> for SaveFramesInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,f64,f64,js_sys::Function,)) -> Self::Output {
        saveFrames3201956655.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,f64,f64,js_sys::Function,)> for SaveFramesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,f64,f64,js_sys::Function,)) -> Self::Output {
        saveFrames3201956655.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,f64,f64,js_sys::Function,)> for SaveFramesInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,f64,f64,js_sys::Function,)) -> Self::Output {
        saveFrames3201956655.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "saveFrames")]
    fn saveFrames1289093036(_ : & str, _ : & str, _ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(&'_ str,&'_ str,f64,f64,)> for SaveFramesInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (&'_ str,&'_ str,f64,f64,)) -> Self::Output {
        saveFrames1289093036.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(&'_ str,&'_ str,f64,f64,)> for SaveFramesInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (&'_ str,&'_ str,f64,f64,)) -> Self::Output {
        saveFrames1289093036.call(args)
    }
}

#[doc(hidden)]
impl Fn<(&'_ str,&'_ str,f64,f64,)> for SaveFramesInternalType {
    extern "rust-call" fn call(&self, args: (&'_ str,&'_ str,f64,f64,)) -> Self::Output {
        saveFrames1289093036.call(args)
    }
}
#[doc=r##"<p>Creates a canvas element in the document, and sets the dimensions of it
in pixels. This method should be called only once at the start of setup.
Calling <a href="#/p5/createCanvas">createCanvas</a> more than once in a
sketch will result in very unpredictable behavior. If you want more than
one drawing canvas you could use <a href="#/p5/createGraphics">createGraphics</a>
(hidden by default but it can be shown).</p>
<p>The system variables width and height are set by the parameters passed to this
function. If <a href="#/p5/createCanvas">createCanvas()</a> is not used, the
window will be given a default size of 100x100 pixels.</p>
<p>For more ways to position the canvas, see the
<a href='https://github.com/processing/p5.js/wiki/Positioning-your-canvas'>
positioning the canvas</a> wiki page.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(100, 50);
  background(153);
  line(0, 0, width, height);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>w</code> width of the canvas

"##]
///
///
#[doc = r##"<code>h</code> height of the canvas

"##]
///
///
#[doc = r##"<code>renderer?</code> either P2D or WEBGL

"##]
///

pub static createCanvas: CreateCanvasInternalType = CreateCanvasInternalType;
#[doc(hidden)]
pub struct CreateCanvasInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCanvas")]
    fn createCanvas1551900665(_ : f64, _ : f64, _ : RENDERER, ) ->  Renderer;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,RENDERER,)> for CreateCanvasInternalType {
    type Output =  Renderer;
    extern "rust-call" fn call_once(self, args: (f64,f64,RENDERER,)) -> Self::Output {
        createCanvas1551900665.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,RENDERER,)> for CreateCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,RENDERER,)) -> Self::Output {
        createCanvas1551900665.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,RENDERER,)> for CreateCanvasInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,RENDERER,)) -> Self::Output {
        createCanvas1551900665.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createCanvas")]
    fn createCanvas1607719848(_ : f64, _ : f64, ) ->  Renderer;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CreateCanvasInternalType {
    type Output =  Renderer;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        createCanvas1607719848.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CreateCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        createCanvas1607719848.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CreateCanvasInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        createCanvas1607719848.call(args)
    }
}
#[doc=r##"<p>Resizes the canvas to given width and height. The canvas will be cleared
and draw will be called immediately, allowing the sketch to re-render itself
in the resized canvas.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  createCanvas(windowWidth, windowHeight);
}

function draw() {
  background(0, 100, 200);
}

function windowResized() {
  resizeCanvas(windowWidth, windowHeight);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>w</code> width of the canvas

"##]
///
///
#[doc = r##"<code>h</code> height of the canvas

"##]
///
///
#[doc = r##"<code>noRedraw?</code> don't redraw the canvas immediately

"##]
///

pub static resizeCanvas: ResizeCanvasInternalType = ResizeCanvasInternalType;
#[doc(hidden)]
pub struct ResizeCanvasInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "resizeCanvas")]
    fn resizeCanvas255296542(_ : f64, _ : f64, _ : bool, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,bool,)> for ResizeCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,bool,)) -> Self::Output {
        resizeCanvas255296542.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,bool,)> for ResizeCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,bool,)) -> Self::Output {
        resizeCanvas255296542.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,bool,)> for ResizeCanvasInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,bool,)) -> Self::Output {
        resizeCanvas255296542.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "resizeCanvas")]
    fn resizeCanvas3245381178(_ : f64, _ : f64, ) ;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for ResizeCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        resizeCanvas3245381178.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for ResizeCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        resizeCanvas3245381178.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for ResizeCanvasInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        resizeCanvas3245381178.call(args)
    }
}
#[doc=r##"<p>Removes the default canvas for a p5 sketch that doesn't require a canvas</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
function setup() {
  noCanvas();
}
```"###]

pub static noCanvas: NoCanvasInternalType = NoCanvasInternalType;
#[doc(hidden)]
pub struct NoCanvasInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "noCanvas")]
    fn noCanvas2362607088() ;
}

#[doc(hidden)]
impl FnOnce<()> for NoCanvasInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: ()) -> Self::Output {
        noCanvas2362607088.call(args)
    }
}

#[doc(hidden)]
impl FnMut<()> for NoCanvasInternalType {
    extern "rust-call" fn call_mut(&mut self, args: ()) -> Self::Output {
        noCanvas2362607088.call(args)
    }
}

#[doc(hidden)]
impl Fn<()> for NoCanvasInternalType {
    extern "rust-call" fn call(&self, args: ()) -> Self::Output {
        noCanvas2362607088.call(args)
    }
}
#[doc=r##"<p>Creates and returns a new p5.Renderer object. Use this class if you need
to draw into an off-screen graphics buffer. The two parameters define the
width and height in pixels.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
let pg;
function setup() {
  createCanvas(100, 100);
  pg = createGraphics(100, 100);
}

function draw() {
  background(200);
  pg.background(100);
  pg.noStroke();
  pg.ellipse(pg.width / 2, pg.height / 2, 50, 50);
  image(pg, 50, 50);
  image(pg, 0, 0, 50, 50);
}
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>w</code> width of the offscreen graphics buffer

"##]
///
///
#[doc = r##"<code>h</code> height of the offscreen graphics buffer

"##]
///
///
#[doc = r##"<code>renderer?</code> either P2D or WEBGL
                              undefined defaults to p2d

"##]
///

pub static createGraphics: CreateGraphicsInternalType = CreateGraphicsInternalType;
#[doc(hidden)]
pub struct CreateGraphicsInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createGraphics")]
    fn createGraphics532217601(_ : f64, _ : f64, _ : RENDERER, ) ->  Graphics;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,RENDERER,)> for CreateGraphicsInternalType {
    type Output =  Graphics;
    extern "rust-call" fn call_once(self, args: (f64,f64,RENDERER,)) -> Self::Output {
        createGraphics532217601.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,RENDERER,)> for CreateGraphicsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,RENDERER,)) -> Self::Output {
        createGraphics532217601.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,RENDERER,)> for CreateGraphicsInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,RENDERER,)) -> Self::Output {
        createGraphics532217601.call(args)
    }
}

#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "createGraphics")]
    fn createGraphics771491789(_ : f64, _ : f64, ) ->  Graphics;
}

#[doc(hidden)]
impl FnOnce<(f64,f64,)> for CreateGraphicsInternalType {
    type Output =  Graphics;
    extern "rust-call" fn call_once(self, args: (f64,f64,)) -> Self::Output {
        createGraphics771491789.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(f64,f64,)> for CreateGraphicsInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (f64,f64,)) -> Self::Output {
        createGraphics771491789.call(args)
    }
}

#[doc(hidden)]
impl Fn<(f64,f64,)> for CreateGraphicsInternalType {
    extern "rust-call" fn call(&self, args: (f64,f64,)) -> Self::Output {
        createGraphics771491789.call(args)
    }
}
#[doc=r##"<p>Blends the pixels in the display window according to the defined mode.
There is a choice of the following modes to blend the source pixels (A)
with the ones of pixels already in the display window (B):</p>
<ul>
<li><code>BLEND</code> - linear interpolation of colours: C =
A\*factor + B. <b>This is the default blending mode.</b></li>
<li><code>ADD</code> - sum of A and B</li>
<li><code>DARKEST</code> - only the darkest colour succeeds: C =
min(A\*factor, B).</li>
<li><code>LIGHTEST</code> - only the lightest colour succeeds: C =
max(A\*factor, B).</li>
<li><code>DIFFERENCE</code> - subtract colors from underlying image.</li>
<li><code>EXCLUSION</code> - similar to <code>DIFFERENCE</code>, but less
extreme.</li>
<li><code>MULTIPLY</code> - multiply the colors, result will always be
darker.</li>
<li><code>SCREEN</code> - opposite multiply, uses inverse values of the
colors.</li>
<li><code>REPLACE</code> - the pixels entirely replace the others and
don't utilize alpha (transparency) values.</li>
<li><code>REMOVE</code> - removes pixels from B with the alpha strength of A.</li>
<li><code>OVERLAY</code> - mix of <code>MULTIPLY</code> and <code>SCREEN
</code>. Multiplies dark values, and screens light values. <em>(2D)</em></li>
<li><code>HARD_LIGHT</code> - <code>SCREEN</code> when greater than 50%
gray, <code>MULTIPLY</code> when lower. <em>(2D)</em></li>
<li><code>SOFT_LIGHT</code> - mix of <code>DARKEST</code> and
<code>LIGHTEST</code>. Works like <code>OVERLAY</code>, but not as harsh. <em>(2D)</em>
</li>
<li><code>DODGE</code> - lightens light tones and increases contrast,
ignores darks. <em>(2D)</em></li>
<li><code>BURN</code> - darker areas are applied, increasing contrast,
ignores lights. <em>(2D)</em></li>
<li><code>SUBTRACT</code> - remainder of A and B <em>(3D)</em></li>
</ul>

<p><em>(2D)</em> indicates that this blend mode <b>only</b> works in the 2D renderer.<br>
<em>(3D)</em> indicates that this blend mode <b>only</b> works in the WEBGL renderer.</p>
"##]
///<h2>Examples</h2>
///

#[doc=r###"```rust
blendMode(LIGHTEST);
strokeWeight(30);
stroke(80, 150, 255);
line(25, 25, 75, 75);
stroke(255, 50, 50);
line(75, 25, 25, 75);
```"###]
#[doc=r###"```rust
blendMode(MULTIPLY);
strokeWeight(30);
stroke(80, 150, 255);
line(25, 25, 75, 75);
stroke(255, 50, 50);
line(75, 25, 25, 75);
```"###]
/// <h2>Parameters</h2>
///
#[doc = r##"<code>mode</code> blend mode to set for canvas.
               either BLEND, DARKEST, LIGHTEST, DIFFERENCE, MULTIPLY,
               EXCLUSION, SCREEN, REPLACE, OVERLAY, HARD_LIGHT,
               SOFT_LIGHT, DODGE, BURN, ADD, REMOVE or SUBTRACT

"##]
///

pub static blendMode: BlendModeInternalType = BlendModeInternalType;
#[doc(hidden)]
pub struct BlendModeInternalType;


#[wasm_bindgen]
extern {
    #[wasm_bindgen(js_name = "blendMode")]
    fn blendMode2494644583(_ : BLEND_MODE, ) ;
}

#[doc(hidden)]
impl FnOnce<(BLEND_MODE,)> for BlendModeInternalType {
    type Output = ();
    extern "rust-call" fn call_once(self, args: (BLEND_MODE,)) -> Self::Output {
        blendMode2494644583.call(args)
    }
}

#[doc(hidden)]
impl FnMut<(BLEND_MODE,)> for BlendModeInternalType {
    extern "rust-call" fn call_mut(&mut self, args: (BLEND_MODE,)) -> Self::Output {
        blendMode2494644583.call(args)
   