/* lib.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! AVRoxide procedural macros

// Imports ===================================================================
extern crate proc_macro;
use proc_macro::TokenStream;

mod entrypoint;
mod persist;

// Declarations ==============================================================
#[proc_macro_attribute]
#[cfg(not(test))]
pub fn main(args: TokenStream, item: TokenStream) -> TokenStream {
  entrypoint::generate_main(args,item)
}

#[proc_macro_derive(Persist, attributes(persist))]
pub fn derive_persist(item: TokenStream) -> TokenStream {
  persist::derive_persist(item)
}
// Code ======================================================================


// Tests =====================================================================
