/* lib.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! AVRoxide procedural macros

// Imports ===================================================================
extern crate proc_macro;
use proc_macro::TokenStream;

mod entrypoint;

// Declarations ==============================================================
#[proc_macro_attribute]
#[cfg(not(test))]
pub fn main(args: TokenStream, item: TokenStream) -> TokenStream {
  entrypoint::generate_main(args,item)
}

// Code ======================================================================


// Tests =====================================================================
#[cfg(test)]
mod tests {
  #[allow(unused_imports)]
  use super::*;

  #[test]
  fn a_test() {}

  #[test]
  #[should_panic]
  fn a_failure_test() {
    panic!()
  }
}