use crate::structures::Word;
use crate::utility::mappings::*;

pub(crate) const SPECIFIC_WORD_MAPPING_LIST: [fn(Word) -> Word; 12] = [
    map_fuc_to_fwuc,
    map_mom_to_mwom,
    map_time_to_tim,
    map_me_to_mwe,
    map_n_vowel_to_ny,
    map_over_to_owor,
    map_ove_to_uv,
    map_haha_to_hehe_xd,
    map_the_to_teh,
    map_you_to_u,
    map_read_to_wead,
    map_worse_to_wose,
];

pub(crate) const UVU_MAPPING_LIST: [fn(Word) -> Word; 5] = [
    map_o_to_owo,
    map_ew_to_uwu,
    map_hey_to_hay,
    map_dead_to_ded,
    map_n_vowel_t_to_nd,
];

pub(crate) const UWU_MAPPING_LIST: [fn(Word) -> Word; 8] = [
    map_brackets_to_star_trails,
    map_period_comma_exclamation_semicolon_to_kaomojis,
    map_that_to_dat,
    map_th_to_f,
    map_le_to_wal,
    map_ve_to_we,
    map_ry_to_wwy,
    map_r_or_l_to_w,
];

pub(crate) const OWO_MAPPING_LIST: [fn(Word) -> Word; 15] = [
    map_ll_to_ww,
    map_vowel_or_r_except_o_l_to_wl,
    map_old_to_owld,
    map_ol_to_owl,
    map_l_or_r_o_to_wo,
    map_specific_consonants_o_to_letter_and_wo,
    map_v_or_w_le_to_wal,
    map_fi_to_fwi,
    map_ver_to_wer,
    map_poi_to_pwoi,
    map_specific_consonants_le_to_letter_and_wal,
    map_consonant_r_to_consonant_w,
    map_ly_to_wy,
    map_ple_to_pwe,
    map_nr_to_nw,
];
