use num_enum::{IntoPrimitive, TryFromPrimitive};
use std::convert::TryFrom;
use std::error::Error;
use std::fmt;

#[derive(Debug, Eq, PartialEq, IntoPrimitive, TryFromPrimitive)]
#[repr(u32)]
pub enum OwaError {
    NoError = 0,
    NotImplemented = 1,
    InParameters = 2,
    OpeningPort = 3,
    ClosingPort = 4,
    CreatingNode = 5,
    UndefinedNodeStatus = 6,
    InvalidNode = 7,
    PortAlreadyJoined = 8,
    InsertingNode = 9,
    PortNotJoined = 10,
    PortNotYetClosed = 11,
    RtucontrolReserved = 12,
    SelectAlreadyRunning = 13,
    SelectNotRunning = 14,
    SelectLoopThreadCreating = 15,
    SelectClosingTimeout = 16,
    SelectLoopThreadClosing = 17,
    PortNotOpen = 18,
    InvalidFileDescriptor = 19,
    InsuficientMemory = 20,
    LastFreeSignal = 21,
    NoFreeSignalsAvailable = 22,
    RtucontrolAlreadyInitalized = 23,
    RtucontrolNotInitalized = 24,
    RtucontrolAlreadyStarted = 25,
    RtucontrolNotStarted = 26,
    Owa22xmDriverOpening = 27,
    Owa22xmDriverClosing = 28,
    Owa22xmDriverAlreadyOpened = 29,
    Owa22xmDriverNotOpened = 30,
    InCommandCall = 31,
    PartitionName = 32,
    FileName = 33,
    BootHeader = 34,
    OpeningRtuDriver = 35,
    ClosingRtuDriver = 36,
    CallingRtuDriver = 37,
    UsecsleepNotExecuted = 38,
    Owa3xFdDriverOpening = 39,
    Owa3xFdDriverClosing = 40,
    Owa3xFdDriverAlreadyOpened = 41,
    Owa3xFdDriverNotOpened = 42,
    PowerManagementNotWorking = 43,
    PowerManagementNotAnswer = 44,
    Owa3xPmDriverNotOpened = 45,
    Owa3xDigitalInput = 46,
    Owa3xDigitalOutput = 47,
    Owa3xCfgInputInt = 48,
    Owa3xBadInputNum = 49,
    Owa3xBadOutputNum = 50,
    Owa3xAlreadyCfg = 51,
    Owa3xIntNotEnabled = 52,
    Owa3xBadPdSelect = 53,
    Owa3xBadOutputVal = 54,
    ExpansionBoardNotWorking = 55,
    ExpansionBoardNotAnswer = 56,
    IbuttonNotDetected = 57,
    UmountCmd = 58,
    MountCmd = 59,
    NotUsed = 60,
    Owa3xAccelNotReady = 61,
    AccelAlreadyStarted = 62,
    PmAnswer = 63,
    EnterStandby = 64,
    IosBase = 100,
    InvalidOutputType = 101,
    InvalidCalibrationType = 102,
    InvalidEndAdviceType = 103,
    InvalidUsageType = 104,
    InvalidPwmDutyCycle = 105,
    InvalidPwmSourceFreq = 106,
    InvalidPwmCycleType = 107,
    OpeningDeviceDriver = 108,
    ClosingDeviceDriver = 109,
    InIoctlCommand = 110,
    TimerAlreadyUsed = 111,
    TimerNotUsed = 112,
    NoFreeTimers = 113,
    IosAlreadyInitialized = 114,
    IosNotInitialized = 115,
    IosAlreadyStarted = 116,
    IosNotStarted = 117,
    ReadAnalogInput = 118,
    IbuttonSearching = 119,
    OwDiscovering = 120,
    OwTooManyDevices = 121,
    IbDataSize = 122,
    IbReadData = 123,
    PpsInUse = 124,
    GsmErrMeFailure = 200,
    GsmErrConnectionFailure = 201,
    GsmErrMePhoneAdaptorLinkReserved = 202,
    GsmErrOperationNotAllowed = 203,
    GsmErrOperationNotSupported = 204,
    GsmErrPhSimPinRequired = 205,
    GsmErrSimNotInserted = 206,
    GsmErrSimPinRequired = 207,
    GsmErrSimPukRequired = 208,
    GsmErrSimFailure = 209,
    GsmErrSimBusy = 210,
    GsmErrSimWrong = 211,
    GsmErrIncorrectPassword = 212,
    GsmErrSimPin2Required = 213,
    GsmErrSimPuk2Required = 214,
    GsmErrMemoryFull = 215,
    GsmErrInvalidIndex = 216,
    GsmErrNotFound = 217,
    GsmErrMemoryFailure = 218,
    GsmErrTextStringTooLong = 219,
    GsmErrInvalidCharactersInTextString = 220,
    GsmErrDialStringTooLong = 221,
    GsmErrInvalidCharactersInDialString = 222,
    GsmErrNoNetworkService = 223,
    GsmErrNetworkTimeout = 224,
    GsmErrUnknown = 225,
    GsmErrSmsMeFailure = 226,
    GsmErrSmsServiceOfMeReserved = 227,
    GsmErrSmsOperationNotAllowed = 228,
    GsmErrSmsOperationNotSupported = 229,
    GsmErrSmsInvalidPduModeParameter = 230,
    GsmErrSmsSmscAddressUnknown = 231,
    GsmErrSmsNoCnmaAckExpected = 232,
    GsmErrSmsUnknown = 233,
    GsmErrBusy = 234,
    GsmErrNoAnswer = 235,
    GsmErrNoCarrier = 236,
    GsmErrDialing = 237,
    GsmErrInitFailure = 238,
    GsmErrTimeout = 239,
    GsmErrDataMode = 240,
    GsmErrGeneralFailure = 241,
    GsmErrInitInProgress = 242,
    GsmErrInGprsParam = 243,
    GsmErrAlreadyInitialized = 244,
    GsmErrNotInitialized = 245,
    GsmErrAlreadyStarted = 246,
    GsmErrNotStarted = 247,
    GsmErrInvalidData = 248,
    GsmErrNetworkLock = 249,
    GsmErrSmsType = 250,
    GsmErrAudioParameter = 251,
    GsmErrNotSwitchedOn = 252,
    GsmErrPlmnSelectFailure = 253,
    GsmErrNoDialtone = 254,
    GsmErrOpenAudio = 255,
    GsmErrAudioAllocHw = 256,
    GsmErrAudioInitHw = 257,
    GsmErrAudioSetActype = 258,
    GsmErrAudioSampForm = 259,
    GsmErrAudioSampRate = 260,
    GsmErrAudioChanCount = 261,
    GsmErrAudioSetParams = 262,
    GsmErrAudioPcmPrepare = 263,
    GsmErrAudioPcmLink = 264,
    GsmErrAudioNotAllowed = 265,
    GsmErrPsBusy = 266,
    GsmErrSmsSimNotReady = 267,
    GsmErrAudioAlreadyOpened = 268,
    GsmErrRejectedBusy = 269,
    GsmErrNotTimeAvailable = 270,
    GsmErrNoLcpTime = 271,
    GsmErrNoIpTime = 272,
    GsmErrLinkCreate = 273,
    GsmErrTempNotAllowed = 274,
    GsmErrNoCoverage = 275,
    GsmErrModelUnknown = 276,
    GsmErrSdmDisabled = 277,
    GsmErrDeviceDetection = 278,
    GpsBase = 400,
    InGpsType = 401,
    NoValidBaudrate = 402,
    NoValidParity = 403,
    NoValidByteLength = 404,
    NoValidStopbits = 405,
    NoValidProtocol = 406,
    ProtocolNotImplemented = 407,
    NoValidPort = 408,
    GpsNotStarted = 409,
    MsgNotSentToGps = 410,
    NoDataFromGps = 411,
    GpsMsgWithBadChk = 412,
    GpsPortNotOpened = 413,
    GpsNotPowerOn = 414,
    UnlinkportInFinalize = 415,
    UnloadLibraryInFinalize = 416,
    MsgNotAllowed = 417,
    GpsAlreadyInitialized = 418,
    GpsNotInitialized = 419,
    GpsAlreadyStarted = 420,
    GpsBinaryTimeout = 421,
    GpsBinaryNack = 422,
    FunctionNotAllowedInNmea = 423,
    FunctionNotAllowedInBinary = 424,
    NoMemoryInGpsFunction = 425,
    FunctionNotAllowedOnGps = 426,
    GpsBinaryTx = 427,
    GpsBinaryWait = 428,
    GpsBinaryRxNack = 429,
    GpsNotNewMsg = 430,
    GpsRxWait = 431,
    GpsBinChk = 432,
    NoValidMeasRate = 433,
    TestBase = 500,
    TestIo = 501,
    TestRtu = 502,
    TestGsm = 503,
    TestUart = 504,
    TestLed = 505,
    InetAlreadyRunning = 600,
    InetNotInitialized = 601,
    InetNotStarted = 602,
    InetIpIfNotReady = 603,
    InetIpNotAvailable = 604,
    InetGsmOnVoice = 605,
    InetGsmOnCall = 606,
    FmsBase = 1500,
    FmsAlreadyInitialized = 1501,
    FmsNotInitialized = 1502,
    FmsAlreadyStarted = 1503,
    StartingFms = 1504,
    FmsCreateSocket = 1505,
    FmsCfgSocket = 1506,
    FmsBindSocket = 1507,
    FmsThreadInit = 1508,
    FmsNotStarted = 1509,
    FmsLoadLibrary = 1510,
    FmsUnloadLibrary = 1511,
    FmsLoadFunction = 1512,
    FmsOptionNotEnabled = 1513,
    FmsEnableCan = 1514,
    FmsGetOption = 1515,
    FmsTireNotFound = 1516,
    FmsSrvConf = 1517,
    // a couple of extra errors useful when doing things like parsing return values into enums
    UnknownError,
    ParseError,
}

impl OwaError {
    pub fn from_or_unknown(r: u32) -> OwaError {
        match OwaError::try_from(r) {
            Ok(e) => e,
            Err(_) => {
                trace!("Unknown error: {:?}", r);
                OwaError::UnknownError
            }
        }
    }
}

impl Error for OwaError {}

impl fmt::Display for OwaError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        //let s = format!("OWA error: {}", self.error_code);
        write!(f, "OWA error")
    }
}

