/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// With : The information to display in each returned log. If this parameter is not specified, all available response elements are displayed. If this parameter is specified, by default `AccountId` and `RequestId` are also included in the response, unless you explicitly specify them as false.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct With {
    /// By default or if set to true, the account ID is displayed.
    #[serde(rename = "AccountId", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<bool>,
    /// If set to true, the duration of the call is displayed.
    #[serde(rename = "CallDuration", skip_serializing_if = "Option::is_none")]
    pub call_duration: Option<bool>,
    /// If set to true, the access key is displayed.
    #[serde(rename = "QueryAccessKey", skip_serializing_if = "Option::is_none")]
    pub query_access_key: Option<bool>,
    /// If set to true, the name of the API is displayed.
    #[serde(rename = "QueryApiName", skip_serializing_if = "Option::is_none")]
    pub query_api_name: Option<bool>,
    /// If set to true, the version of the API is displayed.
    #[serde(rename = "QueryApiVersion", skip_serializing_if = "Option::is_none")]
    pub query_api_version: Option<bool>,
    /// If set to true, the name of the call is displayed.
    #[serde(rename = "QueryCallName", skip_serializing_if = "Option::is_none")]
    pub query_call_name: Option<bool>,
    /// If set to true, the date of the call is displayed.
    #[serde(rename = "QueryDate", skip_serializing_if = "Option::is_none")]
    pub query_date: Option<bool>,
    /// If set to true, the raw header of the HTTP request is displayed.
    #[serde(rename = "QueryHeaderRaw", skip_serializing_if = "Option::is_none")]
    pub query_header_raw: Option<bool>,
    /// If set to true, the size of the raw header of the HTTP request is displayed.
    #[serde(rename = "QueryHeaderSize", skip_serializing_if = "Option::is_none")]
    pub query_header_size: Option<bool>,
    /// If set to true, the IP is displayed.
    #[serde(rename = "QueryIpAddress", skip_serializing_if = "Option::is_none")]
    pub query_ip_address: Option<bool>,
    /// If set to true, the raw payload of the HTTP request is displayed.
    #[serde(rename = "QueryPayloadRaw", skip_serializing_if = "Option::is_none")]
    pub query_payload_raw: Option<bool>,
    /// If set to true, the size of the raw payload of the HTTP request is displayed.
    #[serde(rename = "QueryPayloadSize", skip_serializing_if = "Option::is_none")]
    pub query_payload_size: Option<bool>,
    /// If set to true, the user agent of the HTTP request is displayed.
    #[serde(rename = "QueryUserAgent", skip_serializing_if = "Option::is_none")]
    pub query_user_agent: Option<bool>,
    /// By default or if set to true, the request ID is displayed.
    #[serde(rename = "RequestId", skip_serializing_if = "Option::is_none")]
    pub request_id: Option<bool>,
    /// If set to true, the size of the response is displayed.
    #[serde(rename = "ResponseSize", skip_serializing_if = "Option::is_none")]
    pub response_size: Option<bool>,
    /// If set to true, the HTTP status code of the response is displayed.
    #[serde(rename = "ResponseStatusCode", skip_serializing_if = "Option::is_none")]
    pub response_status_code: Option<bool>,
}

impl With {
    /// The information to display in each returned log. If this parameter is not specified, all available response elements are displayed. If this parameter is specified, by default `AccountId` and `RequestId` are also included in the response, unless you explicitly specify them as false.
    pub fn new() -> With {
        With {
            account_id: None,
            call_duration: None,
            query_access_key: None,
            query_api_name: None,
            query_api_version: None,
            query_call_name: None,
            query_date: None,
            query_header_raw: None,
            query_header_size: None,
            query_ip_address: None,
            query_payload_raw: None,
            query_payload_size: None,
            query_user_agent: None,
            request_id: None,
            response_size: None,
            response_status_code: None,
        }
    }
}
