/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// VpnConnection : Information about a VPN connection.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct VpnConnection {
    /// Example configuration for the client gateway.
    #[serde(
        rename = "ClientGatewayConfiguration",
        skip_serializing_if = "Option::is_none"
    )]
    pub client_gateway_configuration: Option<String>,
    /// The ID of the client gateway used on the client end of the connection.
    #[serde(rename = "ClientGatewayId", skip_serializing_if = "Option::is_none")]
    pub client_gateway_id: Option<String>,
    /// The type of VPN connection (always `ipsec.1`).
    #[serde(rename = "ConnectionType", skip_serializing_if = "Option::is_none")]
    pub connection_type: Option<String>,
    /// Information about one or more static routes associated with the VPN connection, if any.
    #[serde(rename = "Routes", skip_serializing_if = "Option::is_none")]
    pub routes: Option<Vec<crate::models::RouteLight>>,
    /// The state of the VPN connection (`pending` \\| `available` \\| `deleting` \\| `deleted`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// If false, the VPN connection uses dynamic routing with Border Gateway Protocol (BGP). If true, routing is controlled using static routes. For more information about how to create and delete static routes, see [CreateVpnConnectionRoute](#createvpnconnectionroute) and [DeleteVpnConnectionRoute](#deletevpnconnectionroute).
    #[serde(rename = "StaticRoutesOnly", skip_serializing_if = "Option::is_none")]
    pub static_routes_only: Option<bool>,
    /// One or more tags associated with the VPN connection.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
    /// Information about the current state of one or more of the VPN tunnels.
    #[serde(rename = "VgwTelemetries", skip_serializing_if = "Option::is_none")]
    pub vgw_telemetries: Option<Vec<crate::models::VgwTelemetry>>,
    /// The ID of the virtual gateway used on the OUTSCALE end of the connection.
    #[serde(rename = "VirtualGatewayId", skip_serializing_if = "Option::is_none")]
    pub virtual_gateway_id: Option<String>,
    /// The ID of the VPN connection.
    #[serde(rename = "VpnConnectionId", skip_serializing_if = "Option::is_none")]
    pub vpn_connection_id: Option<String>,
    #[serde(rename = "VpnOptions", skip_serializing_if = "Option::is_none")]
    pub vpn_options: Option<Box<crate::models::VpnOptions>>,
}

impl VpnConnection {
    /// Information about a VPN connection.
    pub fn new() -> VpnConnection {
        VpnConnection {
            client_gateway_configuration: None,
            client_gateway_id: None,
            connection_type: None,
            routes: None,
            state: None,
            static_routes_only: None,
            tags: None,
            vgw_telemetries: None,
            virtual_gateway_id: None,
            vpn_connection_id: None,
            vpn_options: None,
        }
    }
}
