/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// VmType : Information about the VM type.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct VmType {
    /// This parameter is not available. It is present in our API for the sake of historical compatibility with AWS.
    #[serde(rename = "BsuOptimized", skip_serializing_if = "Option::is_none")]
    pub bsu_optimized: Option<bool>,
    /// The maximum number of private IPs per network interface card (NIC).
    #[serde(rename = "MaxPrivateIps", skip_serializing_if = "Option::is_none")]
    pub max_private_ips: Option<i32>,
    /// The amount of memory, in gibibytes.
    #[serde(rename = "MemorySize", skip_serializing_if = "Option::is_none")]
    pub memory_size: Option<f32>,
    /// The number of vCores.
    #[serde(rename = "VcoreCount", skip_serializing_if = "Option::is_none")]
    pub vcore_count: Option<i32>,
    /// The name of the VM type.
    #[serde(rename = "VmTypeName", skip_serializing_if = "Option::is_none")]
    pub vm_type_name: Option<String>,
    /// The maximum number of ephemeral storage disks.
    #[serde(rename = "VolumeCount", skip_serializing_if = "Option::is_none")]
    pub volume_count: Option<i32>,
    /// The size of one ephemeral storage disk, in gibibytes (GiB).
    #[serde(rename = "VolumeSize", skip_serializing_if = "Option::is_none")]
    pub volume_size: Option<i32>,
}

impl VmType {
    /// Information about the VM type.
    pub fn new() -> VmType {
        VmType {
            bsu_optimized: None,
            max_private_ips: None,
            memory_size: None,
            vcore_count: None,
            vm_type_name: None,
            volume_count: None,
            volume_size: None,
        }
    }
}
