/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// VgwTelemetry : Information about the current state of a VPN tunnel.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct VgwTelemetry {
    /// The number of routes accepted through BGP (Border Gateway Protocol) route exchanges.
    #[serde(rename = "AcceptedRouteCount", skip_serializing_if = "Option::is_none")]
    pub accepted_route_count: Option<i32>,
    /// The date and time (UTC) of the latest state update.
    #[serde(
        rename = "LastStateChangeDate",
        skip_serializing_if = "Option::is_none"
    )]
    pub last_state_change_date: Option<String>,
    /// The IP on the OUTSCALE side of the tunnel.
    #[serde(rename = "OutsideIpAddress", skip_serializing_if = "Option::is_none")]
    pub outside_ip_address: Option<String>,
    /// The state of the IPSEC tunnel (`UP` \\| `DOWN`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// A description of the current state of the tunnel.
    #[serde(rename = "StateDescription", skip_serializing_if = "Option::is_none")]
    pub state_description: Option<String>,
}

impl VgwTelemetry {
    /// Information about the current state of a VPN tunnel.
    pub fn new() -> VgwTelemetry {
        VgwTelemetry {
            accepted_route_count: None,
            last_state_change_date: None,
            outside_ip_address: None,
            state: None,
            state_description: None,
        }
    }
}
