/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct UpdateNicRequest {
    /// A new description for the NIC.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    #[serde(rename = "LinkNic", skip_serializing_if = "Option::is_none")]
    pub link_nic: Option<Box<crate::models::LinkNicToUpdate>>,
    /// The ID of the NIC you want to modify.
    #[serde(rename = "NicId")]
    pub nic_id: String,
    /// One or more IDs of security groups for the NIC.<br /> You must specify at least one group, even if you use the default security group in the Net.
    #[serde(rename = "SecurityGroupIds", skip_serializing_if = "Option::is_none")]
    pub security_group_ids: Option<Vec<String>>,
}

impl UpdateNicRequest {
    pub fn new(nic_id: String) -> UpdateNicRequest {
        UpdateNicRequest {
            description: None,
            dry_run: None,
            link_nic: None,
            nic_id,
            security_group_ids: None,
        }
    }
}
