/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct UnlinkInternetServiceRequest {
    /// If true, checks whether you have the required permissions to perform the action.
    #[serde(rename = "DryRun", skip_serializing_if = "Option::is_none")]
    pub dry_run: Option<bool>,
    /// The ID of the Internet service you want to detach.
    #[serde(rename = "InternetServiceId")]
    pub internet_service_id: String,
    /// The ID of the Net from which you want to detach the Internet service.
    #[serde(rename = "NetId")]
    pub net_id: String,
}

impl UnlinkInternetServiceRequest {
    pub fn new(internet_service_id: String, net_id: String) -> UnlinkInternetServiceRequest {
        UnlinkInternetServiceRequest {
            dry_run: None,
            internet_service_id,
            net_id,
        }
    }
}
