/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// Snapshot : Information about the snapshot.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Snapshot {
    /// The account alias of the owner of the snapshot.
    #[serde(rename = "AccountAlias", skip_serializing_if = "Option::is_none")]
    pub account_alias: Option<String>,
    /// The account ID of the owner of the snapshot.
    #[serde(rename = "AccountId", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// The date and time of creation of the snapshot.
    #[serde(rename = "CreationDate", skip_serializing_if = "Option::is_none")]
    pub creation_date: Option<String>,
    /// The description of the snapshot.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(
        rename = "PermissionsToCreateVolume",
        skip_serializing_if = "Option::is_none"
    )]
    pub permissions_to_create_volume: Option<Box<crate::models::PermissionsOnResource>>,
    /// The progress of the snapshot, as a percentage.
    #[serde(rename = "Progress", skip_serializing_if = "Option::is_none")]
    pub progress: Option<i32>,
    /// The ID of the snapshot.
    #[serde(rename = "SnapshotId", skip_serializing_if = "Option::is_none")]
    pub snapshot_id: Option<String>,
    /// The state of the snapshot (`in-queue` \\| `completed` \\| `error`).
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<String>,
    /// One or more tags associated with the snapshot.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
    /// The ID of the volume used to create the snapshot.
    #[serde(rename = "VolumeId", skip_serializing_if = "Option::is_none")]
    pub volume_id: Option<String>,
    /// The size of the volume used to create the snapshot, in gibibytes (GiB).
    #[serde(rename = "VolumeSize", skip_serializing_if = "Option::is_none")]
    pub volume_size: Option<i32>,
}

impl Snapshot {
    /// Information about the snapshot.
    pub fn new() -> Snapshot {
        Snapshot {
            account_alias: None,
            account_id: None,
            creation_date: None,
            description: None,
            permissions_to_create_volume: None,
            progress: None,
            snapshot_id: None,
            state: None,
            tags: None,
            volume_id: None,
            volume_size: None,
        }
    }
}
