/*
 * 3DS OUTSCALE API
 *
 * Welcome to the OUTSCALE API documentation.<br /><br />  The OUTSCALE API enables you to manage your resources in the OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the OUTSCALE API. You can find a list of the differences [here](https://docs.outscale.com/en/userguide/OUTSCALE-APIs-Reference.html).<br /><br />  You can also manage your resources using the [Cockpit](https://docs.outscale.com/en/userguide/About-Cockpit.html) web interface.
 *
 * The version of the OpenAPI document: 1.19
 * Contact: support@outscale.com
 * Generated by: https://openapi-generator.tech
 */

/// SecurityGroup : Information about the security group.

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct SecurityGroup {
    /// The account ID of a user that has been granted permission.
    #[serde(rename = "AccountId", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// The description of the security group.
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The inbound rules associated with the security group.
    #[serde(rename = "InboundRules", skip_serializing_if = "Option::is_none")]
    pub inbound_rules: Option<Vec<crate::models::SecurityGroupRule>>,
    /// The ID of the Net for the security group.
    #[serde(rename = "NetId", skip_serializing_if = "Option::is_none")]
    pub net_id: Option<String>,
    /// The outbound rules associated with the security group.
    #[serde(rename = "OutboundRules", skip_serializing_if = "Option::is_none")]
    pub outbound_rules: Option<Vec<crate::models::SecurityGroupRule>>,
    /// The ID of the security group.
    #[serde(rename = "SecurityGroupId", skip_serializing_if = "Option::is_none")]
    pub security_group_id: Option<String>,
    /// The name of the security group.
    #[serde(rename = "SecurityGroupName", skip_serializing_if = "Option::is_none")]
    pub security_group_name: Option<String>,
    /// One or more tags associated with the security group.
    #[serde(rename = "Tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<crate::models::ResourceTag>>,
}

impl SecurityGroup {
    /// Information about the security group.
    pub fn new() -> SecurityGroup {
        SecurityGroup {
            account_id: None,
            description: None,
            inbound_rules: None,
            net_id: None,
            outbound_rules: None,
            security_group_id: None,
            security_group_name: None,
            tags: None,
        }
    }
}
